/* preferences-dialog.c generated by valac 0.56.2, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2020 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "libengine.h"
#include <stdlib.h>
#include <string.h>
#include "libchess.h"
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GSettings* settings;
	GList* ai_profiles;
	guint save_duration_timeout;
	GtkCheckButton* show_numbering_check;
	GtkCheckButton* show_move_hints_check;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* opponent_combo;
	GtkListStore* opponent_model;
	GtkAdjustment* duration_adjustment;
	GtkAdjustment* timer_increment_adjustment;
	GtkBox* custom_duration_box;
	GtkBox* timer_increment_box;
	GtkComboBox* custom_duration_units_combo;
	GtkLabel* timer_increment_label;
	GtkComboBox* timer_increment_units_combo;
	GtkComboBox* clock_type_combo;
	GtkComboBox* duration_combo;
	GtkComboBox* orientation_combo;
	GtkComboBox* move_format_combo;
	GtkComboBox* piece_style_combo;
};

static gint PreferencesDialog_private_offset;
static gpointer preferences_dialog_parent_class = NULL;

VALA_EXTERN GType preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
static gboolean preferences_dialog_save_duration_cb (PreferencesDialog* self);
VALA_EXTERN PreferencesDialog* preferences_dialog_new (GtkWindow* window,
                                           GSettings* settings,
                                           GList* ai_profiles);
VALA_EXTERN PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkWindow* window,
                                                 GSettings* settings,
                                                 GList* ai_profiles);
static void preferences_dialog_set_combo (PreferencesDialog* self,
                                   GtkComboBox* combo,
                                   gint value_index,
                                   const gchar* value);
static void preferences_dialog_set_duration (PreferencesDialog* self,
                                      gint duration,
                                      gboolean simplify);
static void preferences_dialog_set_clock_type (PreferencesDialog* self,
                                        gint clock_type);
static void preferences_dialog_set_timer_increment (PreferencesDialog* self,
                                             gint timer_increment);
static gchar* preferences_dialog_get_combo (PreferencesDialog* self,
                                     GtkComboBox* combo,
                                     gint value_index);
static void preferences_dialog_side_combo_changed_cb (PreferencesDialog* self,
                                               GtkComboBox* combo);
static void _preferences_dialog_side_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                      gpointer self);
static void preferences_dialog_opponent_combo_changed_cb (PreferencesDialog* self,
                                                   GtkComboBox* combo);
static void _preferences_dialog_opponent_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                          gpointer self);
static void preferences_dialog_difficulty_combo_changed_cb (PreferencesDialog* self,
                                                     GtkComboBox* combo);
static void _preferences_dialog_difficulty_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                            gpointer self);
static void preferences_dialog_clock_type_changed_cb (PreferencesDialog* self,
                                               GtkComboBox* combo);
static void preferences_dialog_timer_increment_units_changed_cb (PreferencesDialog* self,
                                                          GtkWidget* widget);
static gint preferences_dialog_get_duration (PreferencesDialog* self);
static void preferences_dialog_duration_changed_cb (PreferencesDialog* self,
                                             GtkAdjustment* adjustment);
static void preferences_dialog_save_duration (PreferencesDialog* self);
static void _preferences_dialog_duration_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                           gpointer self);
static void preferences_dialog_duration_units_changed_cb (PreferencesDialog* self,
                                                   GtkWidget* widget);
static void _preferences_dialog_duration_units_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                          gpointer self);
static void _preferences_dialog_timer_increment_units_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                 gpointer self);
static gboolean _preferences_dialog_save_duration_cb_gsource_func (gpointer self);
static void preferences_dialog_duration_combo_changed_cb (PreferencesDialog* self,
                                                   GtkComboBox* combo);
static void _preferences_dialog_duration_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                          gpointer self);
static void _preferences_dialog_clock_type_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                      gpointer self);
static void preferences_dialog_piece_style_combo_changed_cb (PreferencesDialog* self,
                                                      GtkComboBox* combo);
static void _preferences_dialog_piece_style_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self);
static void preferences_dialog_move_format_combo_changed_cb (PreferencesDialog* self,
                                                      GtkComboBox* combo);
static void _preferences_dialog_move_format_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self);
static void preferences_dialog_orientation_combo_changed_cb (PreferencesDialog* self,
                                                      GtkComboBox* combo);
static void _preferences_dialog_orientation_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                             gpointer self);
static void preferences_dialog_finalize (GObject * obj);
static GType preferences_dialog_get_type_once (void);

static inline gpointer
preferences_dialog_get_instance_private (PreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PreferencesDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PreferencesDialog*
preferences_dialog_construct (GType object_type,
                              GtkWindow* window,
                              GSettings* settings,
                              GList* ai_profiles)
{
	PreferencesDialog * self = NULL;
	GSettings* _tmp0_;
	GtkCheckButton* _tmp1_;
	GtkCheckButton* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* opponent_name = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkComboBox* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GtkComboBox* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GtkComboBox* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GtkComboBox* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkComboBox* _tmp48_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (PreferencesDialog*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	self->priv->ai_profiles = ai_profiles;
	_tmp1_ = self->priv->show_numbering_check;
	g_settings_bind (settings, "show-numbering", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->show_move_hints_check;
	g_settings_bind (settings, "show-move-hints", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->side_combo;
	gtk_combo_box_set_active (_tmp3_, g_settings_get_enum (settings, "play-as"));
	_tmp4_ = self->priv->difficulty_combo;
	_tmp5_ = g_settings_get_string (settings, "difficulty");
	_tmp6_ = _tmp5_;
	preferences_dialog_set_combo (self, _tmp4_, 1, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = g_settings_get_string (settings, "opponent");
	opponent_name = _tmp7_;
	_tmp8_ = opponent_name;
	if (g_strcmp0 (_tmp8_, "human") == 0) {
		GtkComboBox* _tmp9_;
		_tmp9_ = self->priv->opponent_combo;
		gtk_combo_box_set_active (_tmp9_, 0);
	}
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = ai_profiles;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp10_;
			AIProfile* p = NULL;
			_tmp10_ = _g_object_ref0 ((AIProfile*) p_it->data);
			p = _tmp10_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp11_;
				GtkTreeIter _tmp12_ = {0};
				GtkListStore* _tmp13_;
				GtkTreeIter _tmp14_;
				AIProfile* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				AIProfile* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				AIProfile* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp11_ = self->priv->opponent_model;
				gtk_list_store_append (_tmp11_, &_tmp12_);
				iter = _tmp12_;
				_tmp13_ = self->priv->opponent_model;
				_tmp14_ = iter;
				_tmp15_ = p;
				_tmp16_ = ai_profile_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = p;
				_tmp19_ = ai_profile_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp17_, 1, _tmp20_, -1, -1);
				_tmp22_ = p;
				_tmp23_ = ai_profile_get_name (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = opponent_name;
				if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
					_tmp21_ = TRUE;
				} else {
					gboolean _tmp26_ = FALSE;
					const gchar* _tmp27_;
					_tmp27_ = opponent_name;
					if (g_strcmp0 (_tmp27_, "") == 0) {
						GtkComboBox* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						_tmp28_ = self->priv->opponent_combo;
						_tmp29_ = gtk_combo_box_get_active (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp26_ = _tmp30_ == -1;
					} else {
						_tmp26_ = FALSE;
					}
					_tmp21_ = _tmp26_;
				}
				if (_tmp21_) {
					GtkComboBox* _tmp31_;
					GtkTreeIter _tmp32_;
					_tmp31_ = self->priv->opponent_combo;
					_tmp32_ = iter;
					gtk_combo_box_set_active_iter (_tmp31_, &_tmp32_);
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp33_ = self->priv->opponent_combo;
	_tmp34_ = gtk_combo_box_get_active (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ == -1) {
		GtkComboBox* _tmp36_;
		_tmp36_ = self->priv->opponent_combo;
		gtk_combo_box_set_active (_tmp36_, 0);
		g_settings_set_string (settings, "opponent", "human");
	}
	preferences_dialog_set_duration (self, g_settings_get_int (settings, "duration"), TRUE);
	_tmp37_ = g_settings_get_string (settings, "clock-type");
	_tmp38_ = _tmp37_;
	preferences_dialog_set_clock_type (self, (gint) clock_type_string_to_enum (_tmp38_));
	_g_free0 (_tmp38_);
	preferences_dialog_set_timer_increment (self, g_settings_get_int (settings, "timer-increment"));
	_tmp39_ = self->priv->orientation_combo;
	_tmp40_ = g_settings_get_string (settings, "board-side");
	_tmp41_ = _tmp40_;
	preferences_dialog_set_combo (self, _tmp39_, 1, _tmp41_);
	_g_free0 (_tmp41_);
	_tmp42_ = self->priv->move_format_combo;
	_tmp43_ = g_settings_get_string (settings, "move-format");
	_tmp44_ = _tmp43_;
	preferences_dialog_set_combo (self, _tmp42_, 1, _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = self->priv->piece_style_combo;
	_tmp46_ = g_settings_get_string (settings, "piece-theme");
	_tmp47_ = _tmp46_;
	preferences_dialog_set_combo (self, _tmp45_, 1, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->opponent_combo;
	if (gtk_combo_box_get_active (_tmp48_) == 0) {
		GtkComboBox* _tmp49_;
		GtkComboBox* _tmp50_;
		_tmp49_ = self->priv->side_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp49_, FALSE);
		_tmp50_ = self->priv->difficulty_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp50_, FALSE);
	}
	_g_free0 (opponent_name);
	return self;
}

PreferencesDialog*
preferences_dialog_new (GtkWindow* window,
                        GSettings* settings,
                        GList* ai_profiles)
{
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, window, settings, ai_profiles);
}

static void
preferences_dialog_set_combo (PreferencesDialog* self,
                              GtkComboBox* combo,
                              gint value_index,
                              const gchar* value)
{
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = gtk_combo_box_get_model (combo);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gchar* v = NULL;
			GtkTreeModel* _tmp9_;
			GtkTreeIter _tmp10_;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_;
			if (!_tmp6_) {
				GtkTreeModel* _tmp7_;
				gboolean _tmp8_;
				_tmp7_ = model;
				_tmp8_ = gtk_tree_model_iter_next (_tmp7_, &iter);
				if (!_tmp8_) {
					break;
				}
			}
			_tmp6_ = FALSE;
			_tmp9_ = model;
			_tmp10_ = iter;
			gtk_tree_model_get (_tmp9_, &_tmp10_, value_index, &_tmp11_, -1, -1);
			_g_free0 (v);
			v = _tmp11_;
			_tmp12_ = v;
			if (g_strcmp0 (_tmp12_, value) == 0) {
				GtkTreeIter _tmp13_;
				_tmp13_ = iter;
				gtk_combo_box_set_active_iter (combo, &_tmp13_);
				_g_free0 (v);
				_g_object_unref0 (model);
				return;
			}
			_g_free0 (v);
		}
	}
	_g_object_unref0 (model);
}

static gchar*
preferences_dialog_get_combo (PreferencesDialog* self,
                              GtkComboBox* combo,
                              gint value_index)
{
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (combo != NULL, NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		result = NULL;
		_g_free0 (value);
		return result;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, value_index, &_tmp5_, -1, -1);
	_g_free0 (value);
	value = _tmp5_;
	result = value;
	return result;
}

static void
preferences_dialog_side_combo_changed_cb (PreferencesDialog* self,
                                          GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gint player = 0;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gint _tmp5_ = 0;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1, -1);
	player = _tmp5_;
	_tmp6_ = self->priv->settings;
	g_settings_set_enum (_tmp6_, "play-as", player);
}

static void
_preferences_dialog_side_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self)
{
	preferences_dialog_side_combo_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_opponent_combo_changed_cb (PreferencesDialog* self,
                                              GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* opponent = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gchar* _tmp5_ = NULL;
	GSettings* _tmp6_;
	const gchar* _tmp7_;
	gboolean vs_human = FALSE;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1, -1);
	_g_free0 (opponent);
	opponent = _tmp5_;
	_tmp6_ = self->priv->settings;
	_tmp7_ = opponent;
	g_settings_set_string (_tmp6_, "opponent", _tmp7_);
	vs_human = gtk_combo_box_get_active (combo) == 0;
	_tmp8_ = self->priv->side_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, !vs_human);
	_tmp9_ = self->priv->difficulty_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, !vs_human);
	_g_free0 (opponent);
}

static void
_preferences_dialog_opponent_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self)
{
	preferences_dialog_opponent_combo_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_difficulty_combo_changed_cb (PreferencesDialog* self,
                                                GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* difficulty = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gchar* _tmp5_ = NULL;
	GSettings* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1, -1);
	_g_free0 (difficulty);
	difficulty = _tmp5_;
	_tmp6_ = self->priv->settings;
	_tmp7_ = difficulty;
	g_settings_set_string (_tmp6_, "difficulty", _tmp7_);
	_g_free0 (difficulty);
}

static void
_preferences_dialog_difficulty_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                       gpointer self)
{
	preferences_dialog_difficulty_combo_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_set_clock_type (PreferencesDialog* self,
                                   gint clock_type)
{
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter active_iter_clock_type = {0};
	GtkTreeIter _tmp4_ = {0};
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	GtkComboBox* _tmp15_;
	GtkTreeIter _tmp16_;
	GtkComboBox* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock_type_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	active_iter_clock_type = _tmp4_;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint type = 0;
				GtkTreeModel* _tmp11_;
				GtkTreeIter _tmp12_;
				gint _tmp13_ = 0;
				if (!_tmp8_) {
					GtkTreeModel* _tmp9_;
					gboolean _tmp10_;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &_tmp13_, -1, -1);
				type = _tmp13_;
				if (type == clock_type) {
					GtkTreeIter _tmp14_;
					_tmp14_ = iter;
					active_iter_clock_type = _tmp14_;
				}
			}
		}
	}
	_tmp15_ = self->priv->clock_type_combo;
	_tmp16_ = active_iter_clock_type;
	gtk_combo_box_set_active_iter (_tmp15_, &_tmp16_);
	_tmp17_ = self->priv->clock_type_combo;
	preferences_dialog_clock_type_changed_cb (self, _tmp17_);
	_g_object_unref0 (model);
}

static void
preferences_dialog_set_timer_increment (PreferencesDialog* self,
                                        gint timer_increment)
{
	gint timer_increment_multiplier = 0;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter iter = {0};
	GtkTreeIter reqd_iter = {0};
	GtkTreeIter _tmp6_ = {0};
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_;
	GtkComboBox* _tmp17_;
	GtkTreeIter _tmp18_;
	GtkComboBox* _tmp19_;
	g_return_if_fail (self != NULL);
	timer_increment_multiplier = 1;
	if (timer_increment >= 60) {
		GtkAdjustment* _tmp0_;
		_tmp0_ = self->priv->timer_increment_adjustment;
		gtk_adjustment_set_value (_tmp0_, (gdouble) (timer_increment / 60));
		timer_increment_multiplier = 60;
	} else {
		GtkAdjustment* _tmp1_;
		_tmp1_ = self->priv->timer_increment_adjustment;
		gtk_adjustment_set_value (_tmp1_, (gdouble) timer_increment);
	}
	_tmp2_ = self->priv->timer_increment_units_combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	model = _tmp5_;
	reqd_iter = _tmp6_;
	_tmp7_ = model;
	_tmp9_ = gtk_tree_model_get_iter_first (_tmp7_, &_tmp8_);
	iter = _tmp8_;
	if (_tmp9_) {
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkTreeModel* _tmp13_;
				GtkTreeIter _tmp14_;
				gint _tmp15_ = 0;
				if (!_tmp10_) {
					GtkTreeModel* _tmp11_;
					gboolean _tmp12_;
					_tmp11_ = model;
					_tmp12_ = gtk_tree_model_iter_next (_tmp11_, &iter);
					if (!_tmp12_) {
						break;
					}
				}
				_tmp10_ = FALSE;
				_tmp13_ = model;
				_tmp14_ = iter;
				gtk_tree_model_get (_tmp13_, &_tmp14_, 1, &_tmp15_, -1, -1);
				multiplier = _tmp15_;
				if (multiplier == timer_increment_multiplier) {
					GtkTreeIter _tmp16_;
					_tmp16_ = iter;
					reqd_iter = _tmp16_;
				}
			}
		}
	}
	_tmp17_ = self->priv->timer_increment_units_combo;
	_tmp18_ = reqd_iter;
	gtk_combo_box_set_active_iter (_tmp17_, &_tmp18_);
	_tmp19_ = self->priv->timer_increment_units_combo;
	preferences_dialog_timer_increment_units_changed_cb (self, (GtkWidget*) _tmp19_);
	_g_object_unref0 (model);
}

static void
preferences_dialog_set_duration (PreferencesDialog* self,
                                 gint duration,
                                 gboolean simplify)
{
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier = 0;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	gint value = 0;
	GtkComboBox* _tmp19_;
	GtkTreeModel* _tmp20_;
	GtkTreeModel* _tmp21_;
	GtkTreeModel* _tmp22_;
	GtkTreeModel* _tmp23_;
	GtkTreeIter _tmp24_ = {0};
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	max_iter = _tmp4_;
	max_multiplier = 0;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkTreeModel* _tmp11_;
				GtkTreeIter _tmp12_;
				gint _tmp13_ = 0;
				gboolean _tmp14_ = FALSE;
				if (!_tmp8_) {
					GtkTreeModel* _tmp9_;
					gboolean _tmp10_;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &_tmp13_, -1, -1);
				multiplier = _tmp13_;
				if (multiplier > max_multiplier) {
					_tmp14_ = (duration % multiplier) == 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					GtkTreeIter _tmp15_;
					max_multiplier = multiplier;
					_tmp15_ = iter;
					max_iter = _tmp15_;
				}
			}
		}
	}
	value = 0;
	if (max_multiplier > 0) {
		GtkAdjustment* _tmp16_;
		GtkComboBox* _tmp17_;
		GtkTreeIter _tmp18_;
		value = duration / max_multiplier;
		_tmp16_ = self->priv->duration_adjustment;
		gtk_adjustment_set_value (_tmp16_, (gdouble) value);
		_tmp17_ = self->priv->custom_duration_units_combo;
		_tmp18_ = max_iter;
		gtk_combo_box_set_active_iter (_tmp17_, &_tmp18_);
	}
	if (!simplify) {
		_g_object_unref0 (model);
		return;
	}
	_tmp19_ = self->priv->duration_combo;
	_tmp20_ = gtk_combo_box_get_model (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (model);
	model = _tmp22_;
	_tmp23_ = model;
	_tmp25_ = gtk_tree_model_get_iter_first (_tmp23_, &_tmp24_);
	iter = _tmp24_;
	if (!_tmp25_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp26_ = FALSE;
		_tmp26_ = TRUE;
		while (TRUE) {
			gint v = 0;
			GtkTreeModel* _tmp29_;
			GtkTreeIter _tmp30_;
			gint _tmp31_ = 0;
			gboolean _tmp32_ = FALSE;
			if (!_tmp26_) {
				GtkTreeModel* _tmp27_;
				gboolean _tmp28_;
				_tmp27_ = model;
				_tmp28_ = gtk_tree_model_iter_next (_tmp27_, &iter);
				if (!_tmp28_) {
					break;
				}
			}
			_tmp26_ = FALSE;
			_tmp29_ = model;
			_tmp30_ = iter;
			gtk_tree_model_get (_tmp29_, &_tmp30_, 1, &_tmp31_, -1, -1);
			v = _tmp31_;
			if (v == duration) {
				_tmp32_ = TRUE;
			} else {
				_tmp32_ = v == -1;
			}
			if (_tmp32_) {
				GtkComboBox* _tmp33_;
				GtkTreeIter _tmp34_;
				GtkBox* _tmp35_;
				_tmp33_ = self->priv->duration_combo;
				_tmp34_ = iter;
				gtk_combo_box_set_active_iter (_tmp33_, &_tmp34_);
				_tmp35_ = self->priv->custom_duration_box;
				gtk_widget_set_visible ((GtkWidget*) _tmp35_, v == -1);
				_g_object_unref0 (model);
				return;
			}
		}
	}
	_g_object_unref0 (model);
}

static gint
preferences_dialog_get_duration (PreferencesDialog* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint magnitude = 0;
	GtkAdjustment* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gint multiplier = 0;
	GtkComboBox* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->duration_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gint duration = 0;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		gint _tmp7_ = 0;
		_tmp3_ = self->priv->duration_combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = iter;
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &_tmp7_, -1, -1);
		duration = _tmp7_;
		if (duration >= 0) {
			result = duration;
			return result;
		}
	}
	_tmp8_ = self->priv->duration_adjustment;
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
	_tmp10_ = _tmp9_;
	magnitude = (gint) _tmp10_;
	multiplier = 1;
	_tmp11_ = self->priv->custom_duration_units_combo;
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
	iter = _tmp12_;
	if (_tmp13_) {
		GtkComboBox* _tmp14_;
		GtkTreeModel* _tmp15_;
		GtkTreeModel* _tmp16_;
		GtkTreeIter _tmp17_;
		gint _tmp18_ = 0;
		_tmp14_ = self->priv->custom_duration_units_combo;
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = iter;
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &_tmp18_, -1, -1);
		multiplier = _tmp18_;
	}
	switch (multiplier) {
		case 60:
		{
			GtkAdjustment* _tmp19_;
			_tmp19_ = self->priv->duration_adjustment;
			if (gtk_adjustment_get_upper (_tmp19_) != ((gdouble) 600)) {
				GtkAdjustment* _tmp20_;
				_tmp20_ = self->priv->duration_adjustment;
				gtk_adjustment_set_upper (_tmp20_, (gdouble) 600);
			}
			break;
		}
		case 3600:
		{
			GtkAdjustment* _tmp21_;
			_tmp21_ = self->priv->duration_adjustment;
			if (gtk_adjustment_get_upper (_tmp21_) != ((gdouble) 10)) {
				GtkAdjustment* _tmp22_;
				GtkAdjustment* _tmp23_;
				gdouble _tmp24_;
				gdouble _tmp25_;
				_tmp22_ = self->priv->duration_adjustment;
				gtk_adjustment_set_upper (_tmp22_, (gdouble) 10);
				_tmp23_ = self->priv->duration_adjustment;
				_tmp24_ = gtk_adjustment_get_value (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ > ((gdouble) 10)) {
					GtkAdjustment* _tmp26_;
					_tmp26_ = self->priv->duration_adjustment;
					gtk_adjustment_set_value (_tmp26_, (gdouble) 10);
					magnitude = 10;
				}
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = magnitude * multiplier;
	return result;
}

static void
preferences_dialog_duration_changed_cb (PreferencesDialog* self,
                                        GtkAdjustment* adjustment)
{
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint multiplier = 0;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_ = 0;
				if (!_tmp7_) {
					GtkListStore* _tmp8_;
					gboolean _tmp9_;
					_tmp8_ = model;
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &_tmp12_, -1, -1);
				multiplier = _tmp12_;
				switch (multiplier) {
					case 60:
					{
						GtkListStore* _tmp13_;
						GtkTreeIter _tmp14_;
						gdouble _tmp15_;
						gdouble _tmp16_;
						_tmp13_ = model;
						_tmp14_ = iter;
						_tmp15_ = gtk_adjustment_get_value (adjustment);
						_tmp16_ = _tmp15_;
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, ngettext ("minute", "minutes", (gulong) _tmp16_), -1, -1);
						break;
					}
					case 3600:
					{
						GtkListStore* _tmp17_;
						GtkTreeIter _tmp18_;
						gdouble _tmp19_;
						gdouble _tmp20_;
						_tmp17_ = model;
						_tmp18_ = iter;
						_tmp19_ = gtk_adjustment_get_value (adjustment);
						_tmp20_ = _tmp19_;
						gtk_list_store_set (_tmp17_, &_tmp18_, 0, ngettext ("hour", "hours", (gulong) _tmp20_), -1, -1);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	preferences_dialog_save_duration (self);
	_g_object_unref0 (model);
}

static void
_preferences_dialog_duration_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                      gpointer self)
{
	preferences_dialog_duration_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_duration_units_changed_cb (PreferencesDialog* self,
                                              GtkWidget* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	preferences_dialog_save_duration (self);
}

static void
_preferences_dialog_duration_units_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self)
{
	preferences_dialog_duration_units_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_timer_increment_units_changed_cb (PreferencesDialog* self,
                                                     GtkWidget* widget)
{
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	gint multiplier = 0;
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	GtkComboBox* _tmp23_;
	GtkTreeIter _tmp24_ = {0};
	gboolean _tmp25_;
	GSettings* _tmp39_;
	GtkAdjustment* _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->timer_increment_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
	model = _tmp3_;
	multiplier = 0;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_ = 0;
				if (!_tmp7_) {
					GtkListStore* _tmp8_;
					gboolean _tmp9_;
					_tmp8_ = model;
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
					if (!_tmp9_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &_tmp12_, -1, -1);
				multiplier = _tmp12_;
				switch (multiplier) {
					case 1:
					{
						GtkListStore* _tmp13_;
						GtkTreeIter _tmp14_;
						GtkAdjustment* _tmp15_;
						gdouble _tmp16_;
						gdouble _tmp17_;
						_tmp13_ = model;
						_tmp14_ = iter;
						_tmp15_ = self->priv->timer_increment_adjustment;
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
						_tmp17_ = _tmp16_;
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, ngettext ("second", "seconds", (gulong) _tmp17_), -1, -1);
						break;
					}
					case 60:
					{
						GtkListStore* _tmp18_;
						GtkTreeIter _tmp19_;
						GtkAdjustment* _tmp20_;
						gdouble _tmp21_;
						gdouble _tmp22_;
						_tmp18_ = model;
						_tmp19_ = iter;
						_tmp20_ = self->priv->timer_increment_adjustment;
						_tmp21_ = gtk_adjustment_get_value (_tmp20_);
						_tmp22_ = _tmp21_;
						gtk_list_store_set (_tmp18_, &_tmp19_, 0, ngettext ("minute", "minutes", (gulong) _tmp22_), -1, -1);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	_tmp23_ = self->priv->timer_increment_units_combo;
	_tmp25_ = gtk_combo_box_get_active_iter (_tmp23_, &_tmp24_);
	iter = _tmp24_;
	if (_tmp25_) {
		GtkComboBox* _tmp26_;
		GtkTreeModel* _tmp27_;
		GtkTreeModel* _tmp28_;
		GtkTreeIter _tmp29_;
		gint _tmp30_ = 0;
		_tmp26_ = self->priv->timer_increment_units_combo;
		_tmp27_ = gtk_combo_box_get_model (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = iter;
		gtk_tree_model_get (_tmp28_, &_tmp29_, 1, &_tmp30_, -1, -1);
		multiplier = _tmp30_;
	}
	switch (multiplier) {
		case 1:
		{
			GtkAdjustment* _tmp31_;
			_tmp31_ = self->priv->timer_increment_adjustment;
			if (gtk_adjustment_get_upper (_tmp31_) != ((gdouble) 59)) {
				GtkAdjustment* _tmp32_;
				_tmp32_ = self->priv->timer_increment_adjustment;
				gtk_adjustment_set_upper (_tmp32_, (gdouble) 59);
			}
			break;
		}
		case 60:
		{
			GtkAdjustment* _tmp33_;
			_tmp33_ = self->priv->timer_increment_adjustment;
			if (gtk_adjustment_get_upper (_tmp33_) != ((gdouble) 10)) {
				GtkAdjustment* _tmp34_;
				GtkAdjustment* _tmp35_;
				gdouble _tmp36_;
				gdouble _tmp37_;
				_tmp34_ = self->priv->timer_increment_adjustment;
				gtk_adjustment_set_upper (_tmp34_, (gdouble) 10);
				_tmp35_ = self->priv->timer_increment_adjustment;
				_tmp36_ = gtk_adjustment_get_value (_tmp35_);
				_tmp37_ = _tmp36_;
				if (_tmp37_ > ((gdouble) 10)) {
					GtkAdjustment* _tmp38_;
					_tmp38_ = self->priv->timer_increment_adjustment;
					gtk_adjustment_set_value (_tmp38_, (gdouble) 10);
				}
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp39_ = self->priv->settings;
	_tmp40_ = self->priv->timer_increment_adjustment;
	_tmp41_ = gtk_adjustment_get_value (_tmp40_);
	_tmp42_ = _tmp41_;
	g_settings_set_int (_tmp39_, "timer-increment", ((gint) _tmp42_) * multiplier);
	_g_object_unref0 (model);
}

static void
_preferences_dialog_timer_increment_units_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                            gpointer self)
{
	preferences_dialog_timer_increment_units_changed_cb ((PreferencesDialog*) self, _sender);
}

static gboolean
preferences_dialog_save_duration_cb (PreferencesDialog* self)
{
	GSettings* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, "duration", preferences_dialog_get_duration (self));
	self->priv->save_duration_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_preferences_dialog_save_duration_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = preferences_dialog_save_duration_cb ((PreferencesDialog*) self);
	return result;
}

static void
preferences_dialog_save_duration (PreferencesDialog* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->save_duration_timeout != ((guint) 0)) {
		g_source_remove (self->priv->save_duration_timeout);
	}
	self->priv->save_duration_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _preferences_dialog_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
}

static void
preferences_dialog_duration_combo_changed_cb (PreferencesDialog* self,
                                              GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gint duration = 0;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gint _tmp5_ = 0;
	GtkBox* _tmp6_;
	GtkComboBox* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1, -1);
	duration = _tmp5_;
	_tmp6_ = self->priv->custom_duration_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, duration < 0);
	_tmp7_ = self->priv->clock_type_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, duration != 0);
	if (duration == 0) {
		preferences_dialog_set_clock_type (self, (gint) CLOCK_TYPE_SIMPLE);
	}
	if (duration >= 0) {
		preferences_dialog_set_duration (self, duration, FALSE);
	} else {
		if (preferences_dialog_get_duration (self) <= 0) {
			preferences_dialog_set_duration (self, 60 * 60, FALSE);
		}
	}
	preferences_dialog_save_duration (self);
}

static void
_preferences_dialog_duration_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self)
{
	preferences_dialog_duration_combo_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_clock_type_changed_cb (PreferencesDialog* self,
                                          GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	ClockType clock_type = 0;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	ClockType _tmp5_ = 0;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GSettings* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1, -1);
	clock_type = _tmp5_;
	_tmp6_ = self->priv->timer_increment_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, clock_type > 0);
	_tmp7_ = self->priv->timer_increment_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, clock_type > 0);
	_tmp8_ = self->priv->settings;
	_tmp9_ = clock_type_to_string (clock_type);
	_tmp10_ = _tmp9_;
	g_settings_set_string (_tmp8_, "clock-type", _tmp10_);
	_g_free0 (_tmp10_);
}

static void
_preferences_dialog_clock_type_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self)
{
	preferences_dialog_clock_type_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_piece_style_combo_changed_cb (PreferencesDialog* self,
                                                 GtkComboBox* combo)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = preferences_dialog_get_combo (self, combo, 1);
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "piece-theme", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
_preferences_dialog_piece_style_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self)
{
	preferences_dialog_piece_style_combo_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_move_format_combo_changed_cb (PreferencesDialog* self,
                                                 GtkComboBox* combo)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = preferences_dialog_get_combo (self, combo, 1);
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "move-format", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
_preferences_dialog_move_format_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self)
{
	preferences_dialog_move_format_combo_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_orientation_combo_changed_cb (PreferencesDialog* self,
                                                 GtkComboBox* combo)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = preferences_dialog_get_combo (self, combo, 1);
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "board-side", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
_preferences_dialog_orientation_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                        gpointer self)
{
	preferences_dialog_orientation_combo_changed_cb ((PreferencesDialog*) self, _sender);
}

static void
preferences_dialog_class_init (PreferencesDialogClass * klass,
                               gpointer klass_data)
{
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PreferencesDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Chess/ui/preferences.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_numbering_check", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, show_numbering_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_move_hints_check", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, show_move_hints_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "side_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, side_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "difficulty_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, difficulty_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "opponent_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, opponent_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "opponent_model", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, opponent_model));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "duration_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, duration_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer_increment_adjustment", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, timer_increment_adjustment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_duration_box", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, custom_duration_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer_increment_box", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, timer_increment_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_duration_units_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, custom_duration_units_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer_increment_label", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, timer_increment_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer_increment_units_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, timer_increment_units_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_type_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, clock_type_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "duration_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, duration_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "orientation_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, orientation_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_format_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, move_format_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "piece_style_combo", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, piece_style_combo));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "side_combo_changed_cb", G_CALLBACK(_preferences_dialog_side_combo_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "opponent_combo_changed_cb", G_CALLBACK(_preferences_dialog_opponent_combo_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "difficulty_combo_changed_cb", G_CALLBACK(_preferences_dialog_difficulty_combo_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "duration_changed_cb", G_CALLBACK(_preferences_dialog_duration_changed_cb_gtk_adjustment_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "duration_units_changed_cb", G_CALLBACK(_preferences_dialog_duration_units_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "timer_increment_units_changed_cb", G_CALLBACK(_preferences_dialog_timer_increment_units_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "duration_combo_changed_cb", G_CALLBACK(_preferences_dialog_duration_combo_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "clock_type_changed_cb", G_CALLBACK(_preferences_dialog_clock_type_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "piece_style_combo_changed_cb", G_CALLBACK(_preferences_dialog_piece_style_combo_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "move_format_combo_changed_cb", G_CALLBACK(_preferences_dialog_move_format_combo_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "orientation_combo_changed_cb", G_CALLBACK(_preferences_dialog_orientation_combo_changed_cb_gtk_combo_box_changed));
}

static void
preferences_dialog_instance_init (PreferencesDialog * self,
                                  gpointer klass)
{
	self->priv = preferences_dialog_get_instance_private (self);
	self->priv->save_duration_timeout = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
	if (self->priv->save_duration_timeout != ((guint) 0)) {
		g_source_remove (self->priv->save_duration_timeout);
		preferences_dialog_save_duration_cb (self);
	}
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}

static GType
preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
	GType preferences_dialog_type_id;
	preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
	PreferencesDialog_private_offset = g_type_add_instance_private (preferences_dialog_type_id, sizeof (PreferencesDialogPrivate));
	return preferences_dialog_type_id;
}

GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__once)) {
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = preferences_dialog_get_type_once ();
		g_once_init_leave (&preferences_dialog_type_id__once, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__once;
}

