/* alarm-item.c generated by valac 0.56.0, the Vala compiler
 * generated from alarm-item.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Zander Brown <zbrown@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <adwaita.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_ALARM_TYPE_ALARM_TIME (clocks_alarm_alarm_time_get_type ())
typedef struct _ClocksAlarmAlarmTime ClocksAlarmAlarmTime;

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
typedef struct _ClocksAlarmItemPrivate ClocksAlarmItemPrivate;

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;
typedef enum  {
	CLOCKS_ALARM_ITEM_STATE_READY,
	CLOCKS_ALARM_ITEM_STATE_RINGING,
	CLOCKS_ALARM_ITEM_STATE_SNOOZING
} ClocksAlarmItemState;

#define CLOCKS_ALARM_ITEM_TYPE_STATE (clocks_alarm_item_state_get_type ())

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
enum  {
	CLOCKS_ALARM_ITEM_0_PROPERTY,
	CLOCKS_ALARM_ITEM_EDITING_PROPERTY,
	CLOCKS_ALARM_ITEM_ID_PROPERTY,
	CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY,
	CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY,
	CLOCKS_ALARM_ITEM_NAME_PROPERTY,
	CLOCKS_ALARM_ITEM_TIME_PROPERTY,
	CLOCKS_ALARM_ITEM_DAYS_PROPERTY,
	CLOCKS_ALARM_ITEM_STATE_PROPERTY,
	CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY,
	CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL_PROPERTY,
	CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY,
	CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY,
	CLOCKS_ALARM_ITEM_NUM_PROPERTIES
};
static GParamSpec* clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _clocks_utils_weekdays_unref0(var) ((var == NULL) ? NULL : (var = (clocks_utils_weekdays_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
typedef enum  {
	CLOCKS_UTILS_WEEKDAYS_DAY_MON = 0,
	CLOCKS_UTILS_WEEKDAYS_DAY_TUE,
	CLOCKS_UTILS_WEEKDAYS_DAY_WED,
	CLOCKS_UTILS_WEEKDAYS_DAY_THU,
	CLOCKS_UTILS_WEEKDAYS_DAY_FRI,
	CLOCKS_UTILS_WEEKDAYS_DAY_SAT,
	CLOCKS_UTILS_WEEKDAYS_DAY_SUN
} ClocksUtilsWeekdaysDay;

#define CLOCKS_UTILS_WEEKDAYS_TYPE_DAY (clocks_utils_weekdays_day_get_type ())
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;
enum  {
	CLOCKS_ALARM_ITEM_RING_SIGNAL,
	CLOCKS_ALARM_ITEM_NUM_SIGNALS
};
static guint clocks_alarm_item_signals[CLOCKS_ALARM_ITEM_NUM_SIGNALS] = {0};

struct _ClocksAlarmAlarmTime {
	gint hour;
	gint minute;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksAlarmItem {
	GObject parent_instance;
	ClocksAlarmItemPrivate * priv;
};

struct _ClocksAlarmItemClass {
	GObjectClass parent_class;
	void (*ring) (ClocksAlarmItem* self);
};

struct _ClocksAlarmItemPrivate {
	gboolean _editing;
	gchar* _id;
	gint _snooze_minutes;
	gint _ring_minutes;
	ClocksAlarmAlarmTime _time;
	ClocksUtilsWeekdays* _days;
	ClocksAlarmItemState _state;
	gchar* _name;
	gboolean _active;
	GDateTime* alarm_time;
	GDateTime* snooze_time;
	GDateTime* ring_end_time;
	ClocksUtilsBell* bell;
	GNotification* notification;
};

static gint ClocksAlarmItem_private_offset;
static gpointer clocks_alarm_item_parent_class = NULL;
static ClocksContentItemIface * clocks_alarm_item_clocks_content_item_parent_iface = NULL;

VALA_EXTERN GType clocks_alarm_alarm_time_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksAlarmAlarmTime* clocks_alarm_alarm_time_dup (const ClocksAlarmAlarmTime* self);
VALA_EXTERN void clocks_alarm_alarm_time_free (ClocksAlarmAlarmTime* self);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN GType clocks_alarm_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmItem, g_object_unref)
VALA_EXTERN gpointer clocks_utils_weekdays_ref (gpointer instance);
VALA_EXTERN void clocks_utils_weekdays_unref (gpointer instance);
VALA_EXTERN GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void clocks_utils_value_set_weekdays (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void clocks_utils_value_take_weekdays (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer clocks_utils_value_get_weekdays (const GValue* value);
VALA_EXTERN GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWeekdays, clocks_utils_weekdays_unref)
VALA_EXTERN GType clocks_alarm_item_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_utils_bell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsBell, g_object_unref)
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_new (const gchar* id);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_construct (GType object_type,
                                              const gchar* id);
static void clocks_alarm_item_setup_bell (ClocksAlarmItem* self);
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid);
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_construct (GType object_type,
                                              const gchar* soundid);
VALA_EXTERN const gchar* clocks_content_item_get_name (ClocksContentItem* self);
VALA_EXTERN const gchar* clocks_alarm_item_get_id (ClocksAlarmItem* self);
VALA_EXTERN void clocks_alarm_item_reset (ClocksAlarmItem* self);
static void clocks_alarm_item_update_alarm_time (ClocksAlarmItem* self);
static void clocks_alarm_item_update_snooze_time (ClocksAlarmItem* self,
                                           GDateTime* start_time);
static void clocks_alarm_item_set_state (ClocksAlarmItem* self,
                                  ClocksAlarmItemState value);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
VALA_EXTERN GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
VALA_EXTERN GTimeZone* clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self);
VALA_EXTERN void clocks_alarm_item_get_time (ClocksAlarmItem* self,
                                 ClocksAlarmAlarmTime * result);
VALA_EXTERN ClocksUtilsWeekdays* clocks_alarm_item_get_days (ClocksAlarmItem* self);
VALA_EXTERN gboolean clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self);
VALA_EXTERN GType clocks_utils_weekdays_day_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self,
                                    ClocksUtilsWeekdaysDay d);
VALA_EXTERN gint clocks_alarm_item_get_snooze_minutes (ClocksAlarmItem* self);
static void clocks_alarm_item_start_ringing (ClocksAlarmItem* self,
                                      GDateTime* now);
VALA_EXTERN gint clocks_alarm_item_get_ring_minutes (ClocksAlarmItem* self);
VALA_EXTERN void clocks_alarm_item_snooze (ClocksAlarmItem* self);
VALA_EXTERN void clocks_utils_bell_stop (ClocksUtilsBell* self);
VALA_EXTERN void clocks_alarm_item_stop (ClocksAlarmItem* self);
static gboolean clocks_alarm_item_compare_with_item (ClocksAlarmItem* self,
                                              ClocksAlarmItem* i);
VALA_EXTERN gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self);
VALA_EXTERN gboolean clocks_alarm_item_get_editing (ClocksAlarmItem* self);
VALA_EXTERN gboolean clocks_alarm_item_check_duplicate_alarm (ClocksAlarmItem* self,
                                                  GList* alarms);
VALA_EXTERN gboolean clocks_alarm_item_tick (ClocksAlarmItem* self);
VALA_EXTERN ClocksAlarmItemState clocks_alarm_item_get_state (ClocksAlarmItem* self);
static void clocks_alarm_item_real_serialize (ClocksContentItem* base,
                                       GVariantBuilder* builder);
VALA_EXTERN GVariant* clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self);
VALA_EXTERN ClocksContentItem* clocks_alarm_item_deserialize (GVariant* alarm_variant);
static gchar* _variant_get3 (GVariant* value);
static gchar* _variant_get4 (GVariant* value);
static gboolean _variant_get5 (GVariant* value);
static gint32 _variant_get6 (GVariant* value);
static gint32 _variant_get7 (GVariant* value);
VALA_EXTERN ClocksUtilsWeekdays* clocks_utils_weekdays_deserialize (GVariant* days_variant);
static gint32 _variant_get8 (GVariant* value);
static gint32 _variant_get9 (GVariant* value);
VALA_EXTERN void clocks_content_item_set_name (ClocksContentItem* self,
                                   const gchar* value);
VALA_EXTERN void clocks_alarm_item_set_active (ClocksAlarmItem* self,
                                   gboolean value);
VALA_EXTERN void clocks_alarm_item_set_time (ClocksAlarmItem* self,
                                 ClocksAlarmAlarmTime * value);
VALA_EXTERN void clocks_alarm_item_set_days (ClocksAlarmItem* self,
                                 ClocksUtilsWeekdays* value);
VALA_EXTERN void clocks_alarm_item_set_ring_minutes (ClocksAlarmItem* self,
                                         gint value);
VALA_EXTERN void clocks_alarm_item_set_snooze_minutes (ClocksAlarmItem* self,
                                           gint value);
VALA_EXTERN void clocks_alarm_item_set_editing (ClocksAlarmItem* self,
                                    gboolean value);
VALA_EXTERN void clocks_alarm_item_set_id (ClocksAlarmItem* self,
                               const gchar* value);
static gboolean _clocks_alarm_alarm_time_equal (const ClocksAlarmAlarmTime * s1,
                                         const ClocksAlarmAlarmTime * s2);
VALA_EXTERN gchar* clocks_alarm_item_get_time_label (ClocksAlarmItem* self);
VALA_EXTERN gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self,
                                            GDateTime* date_time);
VALA_EXTERN gchar* clocks_alarm_item_get_snooze_time_label (ClocksAlarmItem* self);
VALA_EXTERN gchar* clocks_alarm_item_get_days_label (ClocksAlarmItem* self);
VALA_EXTERN gchar* clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self);
static void clocks_alarm_item_real_ring (ClocksAlarmItem* self);
VALA_EXTERN GType clocks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksApplication, g_object_unref)
VALA_EXTERN void clocks_application_send_notification (ClocksApplication* self,
                                           const gchar* notification_id,
                                           GNotification* notification);
VALA_EXTERN void clocks_utils_bell_ring (ClocksUtilsBell* self);
VALA_EXTERN void clocks_content_item_serialize (ClocksContentItem* self,
                                    GVariantBuilder* builder);
static void clocks_alarm_item_finalize (GObject * obj);
static GType clocks_alarm_item_get_type_once (void);
static void _vala_clocks_alarm_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_clocks_alarm_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

ClocksAlarmAlarmTime*
clocks_alarm_alarm_time_dup (const ClocksAlarmAlarmTime* self)
{
	ClocksAlarmAlarmTime* dup;
	dup = g_new0 (ClocksAlarmAlarmTime, 1);
	memcpy (dup, self, sizeof (ClocksAlarmAlarmTime));
	return dup;
}

void
clocks_alarm_alarm_time_free (ClocksAlarmAlarmTime* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_alarm_time_get_type_once (void)
{
	GType clocks_alarm_alarm_time_type_id;
	clocks_alarm_alarm_time_type_id = g_boxed_type_register_static ("ClocksAlarmAlarmTime", (GBoxedCopyFunc) clocks_alarm_alarm_time_dup, (GBoxedFreeFunc) clocks_alarm_alarm_time_free);
	return clocks_alarm_alarm_time_type_id;
}

GType
clocks_alarm_alarm_time_get_type (void)
{
	static volatile gsize clocks_alarm_alarm_time_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_alarm_time_type_id__once)) {
		GType clocks_alarm_alarm_time_type_id;
		clocks_alarm_alarm_time_type_id = clocks_alarm_alarm_time_get_type_once ();
		g_once_init_leave (&clocks_alarm_alarm_time_type_id__once, clocks_alarm_alarm_time_type_id);
	}
	return clocks_alarm_alarm_time_type_id__once;
}

static inline gpointer
clocks_alarm_item_get_instance_private (ClocksAlarmItem* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksAlarmItem_private_offset);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_item_state_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_ALARM_ITEM_STATE_READY, "CLOCKS_ALARM_ITEM_STATE_READY", "ready"}, {CLOCKS_ALARM_ITEM_STATE_RINGING, "CLOCKS_ALARM_ITEM_STATE_RINGING", "ringing"}, {CLOCKS_ALARM_ITEM_STATE_SNOOZING, "CLOCKS_ALARM_ITEM_STATE_SNOOZING", "snoozing"}, {0, NULL, NULL}};
	GType clocks_alarm_item_state_type_id;
	clocks_alarm_item_state_type_id = g_enum_register_static ("ClocksAlarmItemState", values);
	return clocks_alarm_item_state_type_id;
}

GType
clocks_alarm_item_state_get_type (void)
{
	static volatile gsize clocks_alarm_item_state_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_item_state_type_id__once)) {
		GType clocks_alarm_item_state_type_id;
		clocks_alarm_item_state_type_id = clocks_alarm_item_state_get_type_once ();
		g_once_init_leave (&clocks_alarm_item_state_type_id__once, clocks_alarm_item_state_type_id);
	}
	return clocks_alarm_item_state_type_id__once;
}

ClocksAlarmItem*
clocks_alarm_item_construct (GType object_type,
                             const gchar* id)
{
	ClocksAlarmItem * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* guid = NULL;
	gchar* _tmp3_;
	if (id != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ((const gchar*) id);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_dbus_generate_guid ();
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	guid = _tmp3_;
	self = (ClocksAlarmItem*) g_object_new (object_type, "id", guid, NULL);
	_g_free0 (guid);
	_g_free0 (_tmp0_);
	return self;
}

ClocksAlarmItem*
clocks_alarm_item_new (const gchar* id)
{
	return clocks_alarm_item_construct (CLOCKS_ALARM_TYPE_ITEM, id);
}

static void
clocks_alarm_item_setup_bell (ClocksAlarmItem* self)
{
	ClocksUtilsBell* _tmp0_;
	GNotification* _tmp1_;
	GNotification* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GNotification* _tmp5_;
	GNotification* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GNotification* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_utils_bell_new ("alarm-clock-elapsed");
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp0_;
	_tmp1_ = g_notification_new (_ ("Alarm"));
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = _tmp1_;
	_tmp2_ = self->priv->notification;
	_tmp3_ = clocks_content_item_get_name ((ClocksContentItem*) self);
	_tmp4_ = _tmp3_;
	g_notification_set_body (_tmp2_, _tmp4_);
	_tmp5_ = self->priv->notification;
	g_notification_set_priority (_tmp5_, G_NOTIFICATION_PRIORITY_HIGH);
	_tmp6_ = self->priv->notification;
	_tmp7_ = self->priv->_id;
	_tmp8_ = g_strconcat ("app.stop-alarm::", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	g_notification_add_button (_tmp6_, _ ("Stop"), _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->notification;
	_tmp11_ = self->priv->_id;
	_tmp12_ = g_strconcat ("app.snooze-alarm::", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	g_notification_add_button (_tmp10_, _ ("Snooze"), _tmp13_);
	_g_free0 (_tmp13_);
}

void
clocks_alarm_item_reset (ClocksAlarmItem* self)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	clocks_alarm_item_update_alarm_time (self);
	_tmp0_ = self->priv->alarm_time;
	clocks_alarm_item_update_snooze_time (self, _tmp0_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
clocks_alarm_item_update_alarm_time (ClocksAlarmItem* self)
{
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp0_;
	GDateTime* now = NULL;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* dt = NULL;
	ClocksUtilsWallClock* _tmp5_;
	GTimeZone* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	ClocksAlarmAlarmTime _tmp11_;
	ClocksAlarmAlarmTime _tmp12_;
	GDateTime* _tmp13_;
	gboolean _tmp14_ = FALSE;
	ClocksUtilsWeekdays* _tmp15_;
	GDateTime* _tmp30_;
	GDateTime* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = wallclock;
	_tmp2_ = clocks_utils_wall_clock_get_date_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	now = _tmp4_;
	_tmp5_ = wallclock;
	_tmp6_ = clocks_utils_wall_clock_get_timezone (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = now;
	_tmp9_ = now;
	_tmp10_ = now;
	_tmp11_ = self->priv->_time;
	_tmp12_ = self->priv->_time;
	_tmp13_ = g_date_time_new (_tmp7_, g_date_time_get_year (_tmp8_), g_date_time_get_month (_tmp9_), g_date_time_get_day_of_month (_tmp10_), _tmp11_.hour, _tmp12_.minute, (gdouble) 0);
	dt = _tmp13_;
	_tmp15_ = self->priv->_days;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		ClocksUtilsWeekdays* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp16_ = self->priv->_days;
		_tmp17_ = clocks_utils_weekdays_get_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_;
	}
	if (_tmp14_) {
		GDateTime* _tmp19_;
		GDateTime* _tmp20_;
		_tmp19_ = dt;
		_tmp20_ = now;
		if (g_date_time_compare (_tmp19_, _tmp20_) <= 0) {
			GDateTime* _tmp21_;
			GDateTime* _tmp22_;
			_tmp21_ = dt;
			_tmp22_ = g_date_time_add_days (_tmp21_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp22_;
		}
	} else {
		while (TRUE) {
			gboolean _tmp23_ = FALSE;
			GDateTime* _tmp24_;
			GDateTime* _tmp25_;
			GDateTime* _tmp28_;
			GDateTime* _tmp29_;
			_tmp24_ = dt;
			_tmp25_ = now;
			if (g_date_time_compare (_tmp24_, _tmp25_) <= 0) {
				_tmp23_ = TRUE;
			} else {
				ClocksUtilsWeekdays* _tmp26_;
				GDateTime* _tmp27_;
				_tmp26_ = self->priv->_days;
				_tmp27_ = dt;
				_tmp23_ = !clocks_utils_weekdays_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays), (ClocksUtilsWeekdaysDay) (g_date_time_get_day_of_week (_tmp27_) - 1));
			}
			if (!_tmp23_) {
				break;
			}
			_tmp28_ = dt;
			_tmp29_ = g_date_time_add_days (_tmp28_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp29_;
		}
	}
	_tmp30_ = dt;
	_tmp31_ = _g_date_time_ref0 (_tmp30_);
	_g_date_time_unref0 (self->priv->alarm_time);
	self->priv->alarm_time = _tmp31_;
	_g_date_time_unref0 (dt);
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
}

static void
clocks_alarm_item_update_snooze_time (ClocksAlarmItem* self,
                                      GDateTime* start_time)
{
	gint _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_time != NULL);
	_tmp0_ = self->priv->_snooze_minutes;
	_tmp1_ = g_date_time_add_minutes (start_time, _tmp0_);
	_g_date_time_unref0 (self->priv->snooze_time);
	self->priv->snooze_time = _tmp1_;
}

static void
clocks_alarm_item_start_ringing (ClocksAlarmItem* self,
                                 GDateTime* now)
{
	gint _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (now != NULL);
	clocks_alarm_item_update_snooze_time (self, now);
	_tmp0_ = self->priv->_ring_minutes;
	_tmp1_ = g_date_time_add_minutes (now, _tmp0_);
	_g_date_time_unref0 (self->priv->ring_end_time);
	self->priv->ring_end_time = _tmp1_;
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_RINGING);
	g_signal_emit (self, clocks_alarm_item_signals[CLOCKS_ALARM_ITEM_RING_SIGNAL], 0);
}

void
clocks_alarm_item_snooze (ClocksAlarmItem* self)
{
	ClocksUtilsBell* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_stop (_tmp0_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_SNOOZING);
}

void
clocks_alarm_item_stop (ClocksAlarmItem* self)
{
	ClocksUtilsBell* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_stop (_tmp0_);
	_tmp1_ = self->priv->alarm_time;
	clocks_alarm_item_update_snooze_time (self, _tmp1_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}

static gboolean
clocks_alarm_item_compare_with_item (ClocksAlarmItem* self,
                                     ClocksAlarmItem* i)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	_tmp2_ = self->priv->alarm_time;
	_tmp3_ = i->priv->alarm_time;
	if (g_date_time_compare (_tmp2_, _tmp3_) == 0) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = clocks_alarm_item_get_active (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp7_;
			_tmp7_ = self->priv->_editing;
			_tmp4_ = _tmp7_;
		}
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = clocks_alarm_item_get_active (i);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
clocks_alarm_item_check_duplicate_alarm (ClocksAlarmItem* self,
                                         GList* alarms)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	clocks_alarm_item_update_alarm_time (self);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = alarms;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ClocksAlarmItem* _tmp0_;
			ClocksAlarmItem* item = NULL;
			_tmp0_ = _g_object_ref0 ((ClocksAlarmItem*) item_it->data);
			item = _tmp0_;
			{
				ClocksAlarmItem* _tmp1_;
				_tmp1_ = item;
				if (clocks_alarm_item_compare_with_item (self, _tmp1_)) {
					result = TRUE;
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
clocks_alarm_item_tick (ClocksAlarmItem* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	ClocksAlarmItemState last_state = 0;
	ClocksAlarmItemState _tmp2_;
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp3_;
	GDateTime* now = NULL;
	ClocksUtilsWallClock* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	gboolean _tmp8_ = FALSE;
	ClocksAlarmItemState _tmp9_;
	gboolean _tmp12_ = FALSE;
	ClocksAlarmItemState _tmp13_;
	gboolean _tmp17_ = FALSE;
	ClocksAlarmItemState _tmp18_;
	ClocksAlarmItemState _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = clocks_alarm_item_get_active (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_state;
	last_state = _tmp2_;
	_tmp3_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp3_;
	_tmp4_ = wallclock;
	_tmp5_ = clocks_utils_wall_clock_get_date_time (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_date_time_ref0 (_tmp6_);
	now = _tmp7_;
	_tmp9_ = self->priv->_state;
	if (_tmp9_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		_tmp10_ = now;
		_tmp11_ = self->priv->ring_end_time;
		_tmp8_ = g_date_time_compare (_tmp10_, _tmp11_) > 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		clocks_alarm_item_stop (self);
	}
	_tmp13_ = self->priv->_state;
	if (_tmp13_ == CLOCKS_ALARM_ITEM_STATE_SNOOZING) {
		GDateTime* _tmp14_;
		GDateTime* _tmp15_;
		_tmp14_ = now;
		_tmp15_ = self->priv->snooze_time;
		_tmp12_ = g_date_time_compare (_tmp14_, _tmp15_) > 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GDateTime* _tmp16_;
		_tmp16_ = now;
		clocks_alarm_item_start_ringing (self, _tmp16_);
	}
	_tmp18_ = self->priv->_state;
	if (_tmp18_ == CLOCKS_ALARM_ITEM_STATE_READY) {
		GDateTime* _tmp19_;
		GDateTime* _tmp20_;
		_tmp19_ = now;
		_tmp20_ = self->priv->alarm_time;
		_tmp17_ = g_date_time_compare (_tmp19_, _tmp20_) > 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GDateTime* _tmp21_;
		_tmp21_ = now;
		clocks_alarm_item_start_ringing (self, _tmp21_);
		clocks_alarm_item_update_alarm_time (self);
	}
	_tmp22_ = self->priv->_state;
	result = _tmp22_ != last_state;
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
	return result;
}

static void
clocks_alarm_item_real_serialize (ClocksContentItem* base,
                                  GVariantBuilder* builder)
{
	ClocksAlarmItem * self;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	const gchar* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	ClocksAlarmAlarmTime _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	ClocksAlarmAlarmTime _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	ClocksUtilsWeekdays* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	gint _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	gint _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	self = (ClocksAlarmItem*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_variant_type_new ("a{sv}");
	_tmp1_ = _tmp0_;
	g_variant_builder_open (builder, _tmp1_);
	_g_variant_type_free0 (_tmp1_);
	_tmp2_ = clocks_content_item_get_name ((ClocksContentItem*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_string ((const gchar*) _tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_variant_builder_add (builder, "{sv}", "name", _tmp5_, NULL);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = self->priv->_id;
	_tmp7_ = g_variant_new_string (_tmp6_);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	g_variant_builder_add (builder, "{sv}", "id", _tmp8_, NULL);
	_g_variant_unref0 (_tmp8_);
	_tmp9_ = clocks_alarm_item_get_active (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_new_boolean (_tmp10_);
	g_variant_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	g_variant_builder_add (builder, "{sv}", "active", _tmp12_, NULL);
	_g_variant_unref0 (_tmp12_);
	_tmp13_ = self->priv->_time;
	_tmp14_ = g_variant_new_int32 ((gint32) _tmp13_.hour);
	g_variant_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	g_variant_builder_add (builder, "{sv}", "hour", _tmp15_, NULL);
	_g_variant_unref0 (_tmp15_);
	_tmp16_ = self->priv->_time;
	_tmp17_ = g_variant_new_int32 ((gint32) _tmp16_.minute);
	g_variant_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	g_variant_builder_add (builder, "{sv}", "minute", _tmp18_, NULL);
	_g_variant_unref0 (_tmp18_);
	_tmp19_ = self->priv->_days;
	_tmp20_ = clocks_utils_weekdays_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
	_tmp21_ = _tmp20_;
	g_variant_builder_add (builder, "{sv}", "days", _tmp21_, NULL);
	_g_variant_unref0 (_tmp21_);
	_tmp22_ = self->priv->_snooze_minutes;
	_tmp23_ = g_variant_new_int32 ((gint32) _tmp22_);
	g_variant_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	g_variant_builder_add (builder, "{sv}", "snooze_minutes", _tmp24_, NULL);
	_g_variant_unref0 (_tmp24_);
	_tmp25_ = self->priv->_ring_minutes;
	_tmp26_ = g_variant_new_int32 ((gint32) _tmp25_);
	g_variant_ref_sink (_tmp26_);
	_tmp27_ = _tmp26_;
	g_variant_builder_add (builder, "{sv}", "ring_minutes", _tmp27_, NULL);
	_g_variant_unref0 (_tmp27_);
	g_variant_builder_close (builder);
}

static gchar*
_variant_get3 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get4 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gboolean
_variant_get5 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

static gint32
_variant_get6 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint32
_variant_get7 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint32
_variant_get8 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static gint32
_variant_get9 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

ClocksContentItem*
clocks_alarm_item_deserialize (GVariant* alarm_variant)
{
	gchar* key = NULL;
	GVariant* val = NULL;
	gchar* name = NULL;
	gchar* id = NULL;
	gboolean active = FALSE;
	gint hour = 0;
	gint minute = 0;
	gint snooze_minutes = 0;
	gint ring_minutes = 0;
	ClocksUtilsWeekdays* days = NULL;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp0_;
	gboolean _tmp29_ = FALSE;
	ClocksContentItem* result;
	g_return_val_if_fail (alarm_variant != NULL, NULL);
	name = NULL;
	id = NULL;
	active = TRUE;
	hour = -1;
	minute = -1;
	snooze_minutes = 10;
	ring_minutes = 5;
	days = NULL;
	_tmp0_ = g_variant_iter_new (alarm_variant);
	iter = _tmp0_;
	while (TRUE) {
		GVariantIter* _tmp1_;
		gchar* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
		gboolean _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = iter;
		_tmp4_ = g_variant_iter_next (_tmp1_, "{sv}", &_tmp2_, &_tmp3_, NULL);
		_g_free0 (key);
		key = _tmp2_;
		_g_variant_unref0 (val);
		val = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = key;
		if (g_strcmp0 (_tmp5_, "name") == 0) {
			GVariant* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = val;
			_tmp7_ = _variant_get3 (_tmp6_);
			_g_free0 (name);
			name = _tmp7_;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = key;
			if (g_strcmp0 (_tmp8_, "id") == 0) {
				GVariant* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = val;
				_tmp10_ = _variant_get4 (_tmp9_);
				_g_free0 (id);
				id = _tmp10_;
			} else {
				const gchar* _tmp11_;
				_tmp11_ = key;
				if (g_strcmp0 (_tmp11_, "active") == 0) {
					GVariant* _tmp12_;
					gboolean _tmp13_;
					_tmp12_ = val;
					_tmp13_ = _variant_get5 (_tmp12_);
					active = _tmp13_;
				} else {
					const gchar* _tmp14_;
					_tmp14_ = key;
					if (g_strcmp0 (_tmp14_, "hour") == 0) {
						GVariant* _tmp15_;
						gint32 _tmp16_;
						_tmp15_ = val;
						_tmp16_ = _variant_get6 (_tmp15_);
						hour = (gint) _tmp16_;
					} else {
						const gchar* _tmp17_;
						_tmp17_ = key;
						if (g_strcmp0 (_tmp17_, "minute") == 0) {
							GVariant* _tmp18_;
							gint32 _tmp19_;
							_tmp18_ = val;
							_tmp19_ = _variant_get7 (_tmp18_);
							minute = (gint) _tmp19_;
						} else {
							const gchar* _tmp20_;
							_tmp20_ = key;
							if (g_strcmp0 (_tmp20_, "days") == 0) {
								GVariant* _tmp21_;
								ClocksUtilsWeekdays* _tmp22_;
								_tmp21_ = val;
								_tmp22_ = clocks_utils_weekdays_deserialize (_tmp21_);
								_clocks_utils_weekdays_unref0 (days);
								days = _tmp22_;
							} else {
								const gchar* _tmp23_;
								_tmp23_ = key;
								if (g_strcmp0 (_tmp23_, "snooze_minutes") == 0) {
									GVariant* _tmp24_;
									gint32 _tmp25_;
									_tmp24_ = val;
									_tmp25_ = _variant_get8 (_tmp24_);
									snooze_minutes = (gint) _tmp25_;
								} else {
									const gchar* _tmp26_;
									_tmp26_ = key;
									if (g_strcmp0 (_tmp26_, "ring_minutes") == 0) {
										GVariant* _tmp27_;
										gint32 _tmp28_;
										_tmp27_ = val;
										_tmp28_ = _variant_get9 (_tmp27_);
										ring_minutes = (gint) _tmp28_;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (hour >= 0) {
		_tmp29_ = minute >= 0;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ClocksAlarmItem* alarm = NULL;
		const gchar* _tmp30_;
		ClocksAlarmItem* _tmp31_;
		ClocksAlarmItem* _tmp32_;
		const gchar* _tmp33_;
		ClocksAlarmItem* _tmp34_;
		ClocksAlarmItem* _tmp35_;
		ClocksAlarmAlarmTime _tmp36_ = {0};
		ClocksAlarmItem* _tmp37_;
		ClocksUtilsWeekdays* _tmp38_;
		ClocksAlarmItem* _tmp39_;
		ClocksAlarmItem* _tmp40_;
		ClocksAlarmItem* _tmp41_;
		_tmp30_ = id;
		_tmp31_ = clocks_alarm_item_new (_tmp30_);
		alarm = _tmp31_;
		_tmp32_ = alarm;
		_tmp33_ = name;
		clocks_content_item_set_name ((ClocksContentItem*) _tmp32_, _tmp33_);
		_tmp34_ = alarm;
		clocks_alarm_item_set_active (_tmp34_, active);
		_tmp35_ = alarm;
		_tmp36_.hour = hour;
		_tmp36_.minute = minute;
		clocks_alarm_item_set_time (_tmp35_, &_tmp36_);
		_tmp37_ = alarm;
		_tmp38_ = days;
		clocks_alarm_item_set_days (_tmp37_, _tmp38_);
		_tmp39_ = alarm;
		clocks_alarm_item_set_ring_minutes (_tmp39_, ring_minutes);
		_tmp40_ = alarm;
		clocks_alarm_item_set_snooze_minutes (_tmp40_, snooze_minutes);
		_tmp41_ = alarm;
		clocks_alarm_item_reset (_tmp41_);
		result = (ClocksContentItem*) alarm;
		_g_variant_iter_free0 (iter);
		_clocks_utils_weekdays_unref0 (days);
		_g_free0 (id);
		_g_free0 (name);
		_g_variant_unref0 (val);
		_g_free0 (key);
		return result;
	} else {
		const gchar* _tmp42_ = NULL;
		const gchar* _tmp43_;
		_tmp43_ = name;
		if (_tmp43_ != NULL) {
			const gchar* _tmp44_;
			_tmp44_ = name;
			_tmp42_ = (const gchar*) _tmp44_;
		} else {
			_tmp42_ = "[unnamed]";
		}
		g_warning ("alarm-item.vala:284: Invalid alarm %s", _tmp42_);
	}
	result = NULL;
	_g_variant_iter_free0 (iter);
	_clocks_utils_weekdays_unref0 (days);
	_g_free0 (id);
	_g_free0 (name);
	_g_variant_unref0 (val);
	_g_free0 (key);
	return result;
}

gboolean
clocks_alarm_item_get_editing (ClocksAlarmItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_editing;
	return result;
}

void
clocks_alarm_item_set_editing (ClocksAlarmItem* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_editing (self);
	if (old_value != value) {
		self->priv->_editing = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_EDITING_PROPERTY]);
	}
}

const gchar*
clocks_alarm_item_get_id (ClocksAlarmItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

void
clocks_alarm_item_set_id (ClocksAlarmItem* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_ID_PROPERTY]);
	}
}

gint
clocks_alarm_item_get_snooze_minutes (ClocksAlarmItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_snooze_minutes;
	return result;
}

void
clocks_alarm_item_set_snooze_minutes (ClocksAlarmItem* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_snooze_minutes (self);
	if (old_value != value) {
		self->priv->_snooze_minutes = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY]);
	}
}

gint
clocks_alarm_item_get_ring_minutes (ClocksAlarmItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ring_minutes;
	return result;
}

void
clocks_alarm_item_set_ring_minutes (ClocksAlarmItem* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_ring_minutes (self);
	if (old_value != value) {
		self->priv->_ring_minutes = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY]);
	}
}

static const gchar*
clocks_alarm_item_real_get_name (ClocksContentItem* base)
{
	const gchar* result;
	ClocksAlarmItem* self;
	const gchar* _tmp0_;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
clocks_alarm_item_real_set_name (ClocksContentItem* base,
                                 const gchar* value)
{
	ClocksAlarmItem* self;
	gchar* _tmp0_;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = g_strdup ((const gchar*) value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	clocks_alarm_item_setup_bell (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_NAME_PROPERTY]);
}

void
clocks_alarm_item_get_time (ClocksAlarmItem* self,
                            ClocksAlarmAlarmTime * result)
{
	ClocksAlarmAlarmTime _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_time;
	*result = _tmp0_;
	return;
}

static gboolean
_clocks_alarm_alarm_time_equal (const ClocksAlarmAlarmTime * s1,
                                const ClocksAlarmAlarmTime * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->hour != s2->hour) {
		return FALSE;
	}
	if (s1->minute != s2->minute) {
		return FALSE;
	}
	return TRUE;
}

void
clocks_alarm_item_set_time (ClocksAlarmItem* self,
                            ClocksAlarmAlarmTime * value)
{
	ClocksAlarmAlarmTime old_value;
	g_return_if_fail (self != NULL);
	clocks_alarm_item_get_time (self, &old_value);
	if (_clocks_alarm_alarm_time_equal (value, &old_value) != TRUE) {
		ClocksAlarmAlarmTime _tmp0_;
		_tmp0_ = *value;
		self->priv->_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_TIME_PROPERTY]);
	}
}

ClocksUtilsWeekdays*
clocks_alarm_item_get_days (ClocksAlarmItem* self)
{
	ClocksUtilsWeekdays* result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days;
	result = _tmp0_;
	return result;
}

static gpointer
_clocks_utils_weekdays_ref0 (gpointer self)
{
	return self ? clocks_utils_weekdays_ref (self) : NULL;
}

void
clocks_alarm_item_set_days (ClocksAlarmItem* self,
                            ClocksUtilsWeekdays* value)
{
	ClocksUtilsWeekdays* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_days (self);
	if (old_value != value) {
		ClocksUtilsWeekdays* _tmp0_;
		_tmp0_ = _clocks_utils_weekdays_ref0 (value);
		_clocks_utils_weekdays_unref0 (self->priv->_days);
		self->priv->_days = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_DAYS_PROPERTY]);
	}
}

ClocksAlarmItemState
clocks_alarm_item_get_state (ClocksAlarmItem* self)
{
	ClocksAlarmItemState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
clocks_alarm_item_set_state (ClocksAlarmItem* self,
                             ClocksAlarmItemState value)
{
	ClocksAlarmItemState old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_item_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_STATE_PROPERTY]);
	}
}

gchar*
clocks_alarm_item_get_time_label (ClocksAlarmItem* self)
{
	gchar* result;
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->alarm_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gchar*
clocks_alarm_item_get_snooze_time_label (ClocksAlarmItem* self)
{
	gchar* result;
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->snooze_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gchar*
clocks_alarm_item_get_days_label (ClocksAlarmItem* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	ClocksUtilsWeekdays* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_days;
	if (_tmp1_ != NULL) {
		ClocksUtilsWeekdays* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_days;
		_tmp3_ = clocks_utils_weekdays_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
		_g_free0 (_tmp0_);
		_tmp0_ = (gchar*) _tmp3_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

gboolean
clocks_alarm_item_get_active (ClocksAlarmItem* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_active) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_editing;
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
clocks_alarm_item_set_active (ClocksAlarmItem* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_active) {
		self->priv->_active = value;
		if (self->priv->_active) {
			clocks_alarm_item_reset (self);
		} else {
			ClocksAlarmItemState _tmp0_;
			_tmp0_ = self->priv->_state;
			if (_tmp0_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
				clocks_alarm_item_stop (self);
			}
		}
		g_object_notify ((GObject*) self, "active");
	}
}

static void
clocks_alarm_item_real_ring (ClocksAlarmItem* self)
{
	ClocksApplication* app = NULL;
	GApplication* _tmp0_;
	ClocksApplication* _tmp1_;
	GNotification* _tmp2_;
	ClocksUtilsBell* _tmp3_;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_TYPE_APPLICATION, ClocksApplication));
	app = _tmp1_;
	_tmp2_ = self->priv->notification;
	clocks_application_send_notification (app, "alarm-clock-elapsed", _tmp2_);
	_tmp3_ = self->priv->bell;
	clocks_utils_bell_ring (_tmp3_);
	_g_object_unref0 (app);
}

static void
clocks_alarm_item_class_init (ClocksAlarmItemClass * klass,
                              gpointer klass_data)
{
	clocks_alarm_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksAlarmItem_private_offset);
	((ClocksAlarmItemClass *) klass)->ring = clocks_alarm_item_real_ring;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_EDITING_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_EDITING_PROPERTY] = g_param_spec_boolean ("editing", "editing", "editing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_ID_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY] = g_param_spec_int ("snooze-minutes", "snooze-minutes", "snooze-minutes", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY] = g_param_spec_int ("ring-minutes", "ring-minutes", "ring-minutes", G_MININT, G_MAXINT, 5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_NAME_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_TIME_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_TIME_PROPERTY] = g_param_spec_boxed ("time", "time", "time", CLOCKS_ALARM_TYPE_ALARM_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_DAYS_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_DAYS_PROPERTY] = clocks_utils_param_spec_weekdays ("days", "days", "days", CLOCKS_UTILS_TYPE_WEEKDAYS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_STATE_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CLOCKS_ALARM_ITEM_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY] = g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL_PROPERTY] = g_param_spec_string ("snooze-time-label", "snooze-time-label", "snooze-time-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY] = g_param_spec_string ("days-label", "days-label", "days-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY, clocks_alarm_item_properties[CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	clocks_alarm_item_signals[CLOCKS_ALARM_ITEM_RING_SIGNAL] = g_signal_new ("ring", CLOCKS_ALARM_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksAlarmItemClass, ring), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
clocks_alarm_item_clocks_content_item_interface_init (ClocksContentItemIface * iface,
                                                      gpointer iface_data)
{
	clocks_alarm_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize = (void (*) (ClocksContentItem*, GVariantBuilder*)) clocks_alarm_item_real_serialize;
	iface->get_name = clocks_alarm_item_real_get_name;
	iface->set_name = clocks_alarm_item_real_set_name;
}

static void
clocks_alarm_item_instance_init (ClocksAlarmItem * self,
                                 gpointer klass)
{
	self->priv = clocks_alarm_item_get_instance_private (self);
	self->priv->_editing = FALSE;
	self->priv->_snooze_minutes = 10;
	self->priv->_ring_minutes = 5;
	self->priv->_active = TRUE;
}

static void
clocks_alarm_item_finalize (GObject * obj)
{
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	_g_free0 (self->priv->_id);
	_clocks_utils_weekdays_unref0 (self->priv->_days);
	_g_free0 (self->priv->_name);
	_g_date_time_unref0 (self->priv->alarm_time);
	_g_date_time_unref0 (self->priv->snooze_time);
	_g_date_time_unref0 (self->priv->ring_end_time);
	_g_object_unref0 (self->priv->bell);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (clocks_alarm_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmItem), 0, (GInstanceInitFunc) clocks_alarm_item_instance_init, NULL };
	static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_alarm_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_alarm_item_type_id;
	clocks_alarm_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksAlarmItem", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_alarm_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
	ClocksAlarmItem_private_offset = g_type_add_instance_private (clocks_alarm_item_type_id, sizeof (ClocksAlarmItemPrivate));
	return clocks_alarm_item_type_id;
}

GType
clocks_alarm_item_get_type (void)
{
	static volatile gsize clocks_alarm_item_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_item_type_id__once)) {
		GType clocks_alarm_item_type_id;
		clocks_alarm_item_type_id = clocks_alarm_item_get_type_once ();
		g_once_init_leave (&clocks_alarm_item_type_id__once, clocks_alarm_item_type_id);
	}
	return clocks_alarm_item_type_id__once;
}

static void
_vala_clocks_alarm_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_EDITING_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_item_get_editing (self));
		break;
		case CLOCKS_ALARM_ITEM_ID_PROPERTY:
		g_value_set_string (value, clocks_alarm_item_get_id (self));
		break;
		case CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY:
		g_value_set_int (value, clocks_alarm_item_get_snooze_minutes (self));
		break;
		case CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY:
		g_value_set_int (value, clocks_alarm_item_get_ring_minutes (self));
		break;
		case CLOCKS_ALARM_ITEM_NAME_PROPERTY:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_ALARM_ITEM_TIME_PROPERTY:
		{
			ClocksAlarmAlarmTime boxed;
			clocks_alarm_item_get_time (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case CLOCKS_ALARM_ITEM_DAYS_PROPERTY:
		clocks_utils_value_set_weekdays (value, clocks_alarm_item_get_days (self));
		break;
		case CLOCKS_ALARM_ITEM_STATE_PROPERTY:
		g_value_set_enum (value, clocks_alarm_item_get_state (self));
		break;
		case CLOCKS_ALARM_ITEM_TIME_LABEL_PROPERTY:
		g_value_take_string (value, clocks_alarm_item_get_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL_PROPERTY:
		g_value_take_string (value, clocks_alarm_item_get_snooze_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_DAYS_LABEL_PROPERTY:
		g_value_take_string (value, clocks_alarm_item_get_days_label (self));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_item_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_alarm_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_EDITING_PROPERTY:
		clocks_alarm_item_set_editing (self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_ITEM_ID_PROPERTY:
		clocks_alarm_item_set_id (self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_SNOOZE_MINUTES_PROPERTY:
		clocks_alarm_item_set_snooze_minutes (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_RING_MINUTES_PROPERTY:
		clocks_alarm_item_set_ring_minutes (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_NAME_PROPERTY:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_TIME_PROPERTY:
		clocks_alarm_item_set_time (self, g_value_get_boxed (value));
		break;
		case CLOCKS_ALARM_ITEM_DAYS_PROPERTY:
		clocks_alarm_item_set_days (self, clocks_utils_value_get_weekdays (value));
		break;
		case CLOCKS_ALARM_ITEM_STATE_PROPERTY:
		clocks_alarm_item_set_state (self, g_value_get_enum (value));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE_PROPERTY:
		clocks_alarm_item_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

