/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         ir3_yyparse
#define yylex           ir3_yylex
#define yyerror         ir3_yyerror
#define yydebug         ir3_yydebug
#define yynerrs         ir3_yynerrs
#define yylval          ir3_yylval
#define yychar          ir3_yychar

/* First part of user prologue.  */
#line 32 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"

#define YYDEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "util/half_float.h"
#include "util/u_math.h"

#include "ir3/ir3.h"
#include "ir3/ir3_shader.h"
#include "ir3/instr-a3xx.h"

#include "ir3_parser.h"

#define swap(a, b) \
	do { __typeof(a) __tmp = (a); (a) = (b); (b) = __tmp; } while (0)

/* ir3 treats the abs/neg flags as separate flags for float vs integer,
 * but in the instruction encoding they are the same thing.  Tracking
 * them separately is only for the benefit of ir3 opt passes, and not
 * required here, so just use the float versions:
 */
#define IR3_REG_ABS     IR3_REG_FABS
#define IR3_REG_NEGATE  IR3_REG_FNEG

static struct ir3_kernel_info    *info;
static struct ir3_shader_variant *variant;
/* NOTE the assembler doesn't really use the ir3_block construction
 * like the compiler does.  Everything is treated as one large block.
 * Which might happen to contain flow control.  But since we don't
 * use any of the ir3 backend passes (sched, RA, etc) this doesn't
 * really matter.
 */
static struct ir3_block          *block;   /* current shader block */
static struct ir3_instruction    *instr;   /* current instruction */
static unsigned ip; /* current instruction pointer */
static struct hash_table *labels;

void *ir3_parser_dead_ctx;

static struct {
	unsigned flags;
	unsigned repeat;
	unsigned nop;
} iflags;

static struct {
	unsigned flags;
	unsigned wrmask;
} rflags;

int ir3_yyget_lineno(void);

static void new_label(const char *name)
{
	ralloc_steal(labels, (void *) name);
	_mesa_hash_table_insert(labels, name, (void *)(uintptr_t)ip);
}

static struct ir3_instruction * new_instr(opc_t opc)
{
	instr = ir3_instr_create(block, opc, 4, 6);
	instr->flags = iflags.flags;
	instr->repeat = iflags.repeat;
	instr->nop = iflags.nop;
	instr->line = ir3_yyget_lineno();
	iflags.flags = iflags.repeat = iflags.nop = 0;
	ip++;
	return instr;
}

static void new_shader(void)
{
	variant->ir = ir3_create(variant->compiler, variant);
	block = ir3_block_create(variant->ir);
	list_addtail(&block->node, &variant->ir->block_list);
	ip = 0;
	labels = _mesa_hash_table_create(variant, _mesa_hash_string, _mesa_key_string_equal);
	ir3_parser_dead_ctx = ralloc_context(NULL);
}

static type_t parse_type(const char **type)
{
	if (!strncmp("f16", *type, 3)) {
		*type += 3;
		return TYPE_F16;
	} else if (!strncmp("f32", *type, 3)) {
		*type += 3;
		return TYPE_F32;
	} else if (!strncmp("u16", *type, 3)) {
		*type += 3;
		return TYPE_U16;
	} else if (!strncmp("u32", *type, 3)) {
		*type += 3;
		return TYPE_U32;
	} else if (!strncmp("s16", *type, 3)) {
		*type += 3;
		return TYPE_S16;
	} else if (!strncmp("s32", *type, 3)) {
		*type += 3;
		return TYPE_S32;
	} else if (!strncmp("u8", *type, 2)) {
		*type += 2;
		return TYPE_U8;
	} else if (!strncmp("s8", *type, 2)) {
		*type += 2;
		return TYPE_S8;
	} else {
		assert(0);  /* shouldn't get here */
		return ~0;
	}
}

static struct ir3_instruction * parse_type_type(struct ir3_instruction *instr,
		const char *type_type)
{
	instr->cat1.src_type = parse_type(&type_type);
	instr->cat1.dst_type = parse_type(&type_type);
	return instr;
}

static struct ir3_register * new_src(int num, unsigned flags)
{
	struct ir3_register *reg;
	flags |= rflags.flags;
	if (num & 0x1)
		flags |= IR3_REG_HALF;
	reg = ir3_src_create(instr, num>>1, flags);
	reg->wrmask = MAX2(1, rflags.wrmask);
	rflags.flags = rflags.wrmask = 0;
	return reg;
}

static struct ir3_register * new_dst(int num, unsigned flags)
{
	struct ir3_register *reg;
	flags |= rflags.flags;
	if (num & 0x1)
		flags |= IR3_REG_HALF;
	reg = ir3_dst_create(instr, num>>1, flags);
	reg->wrmask = MAX2(1, rflags.wrmask);
	rflags.flags = rflags.wrmask = 0;
	return reg;
}

static struct ir3_register * dummy_dst(void)
{
	return new_dst(0, 0);
}

static void fixup_cat5_s2en(void)
{
	assert(opc_cat(instr->opc) == 5);
	if (!(instr->flags & IR3_INSTR_S2EN))
		return;
	/* For various reasons (ie. mainly to make the .s2en src easier to
	 * find, given that various different cat5 tex instructions can have
	 * different # of src registers), in ir3 the samp/tex src register
	 * is first, rather than last.  So we have to detect this case and
	 * fix things up.
	 */
	struct ir3_register *s2en_src = instr->srcs[instr->srcs_count - 1];

	if (instr->flags & IR3_INSTR_B)
		assert(!(s2en_src->flags & IR3_REG_HALF));
	else
		assert(s2en_src->flags & IR3_REG_HALF);

	for (int i = 0; i < instr->srcs_count - 1; i++) {
		instr->srcs[i+1] = instr->srcs[i];
	}
	instr->srcs[0] = s2en_src;
}

static void add_const(unsigned reg, unsigned c0, unsigned c1, unsigned c2, unsigned c3)
{
	struct ir3_const_state *const_state = ir3_const_state(variant);
	assert((reg & 0x7) == 0);
	int idx = reg >> (1 + 2); /* low bit is half vs full, next two bits are swiz */
	if (idx * 4 + 4 > const_state->immediates_size) {
		const_state->immediates = rerzalloc(const_state,
				const_state->immediates,
				__typeof__(const_state->immediates[0]),
				const_state->immediates_size,
				idx * 4 + 4);
		for (unsigned i = const_state->immediates_size; i < idx * 4; i++)
			const_state->immediates[i] = 0xd0d0d0d0;
		const_state->immediates_size = const_state->immediates_count = idx * 4 + 4;
	}
	const_state->immediates[idx * 4 + 0] = c0;
	const_state->immediates[idx * 4 + 1] = c1;
	const_state->immediates[idx * 4 + 2] = c2;
	const_state->immediates[idx * 4 + 3] = c3;
}

static void add_sysval(unsigned reg, unsigned compmask, gl_system_value sysval)
{
	unsigned n = variant->inputs_count++;
	variant->inputs[n].regid = reg;
	variant->inputs[n].sysval = true;
	variant->inputs[n].slot = sysval;
	variant->inputs[n].compmask = compmask;
	variant->total_in++;
}

static bool resolve_labels(void)
{
	int instr_ip = 0;
	foreach_instr (instr, &block->instr_list) {
		if (opc_cat(instr->opc) == 0 && instr->cat0.target_label) {
			struct hash_entry *entry = _mesa_hash_table_search(labels, instr->cat0.target_label);
			if (!entry) {
				fprintf(stderr, "unknown label %s\n", instr->cat0.target_label);
				return false;
			}
			int target_ip = (uintptr_t)entry->data;
			instr->cat0.immed = target_ip - instr_ip;
		}
		instr_ip++;
	}
	return true;
}

#ifdef YYDEBUG
int yydebug;
#endif

extern int yylex(void);
void ir3_yyset_lineno(int _line_number);
void ir3_yyset_input(FILE *f);

int yyparse(void);

static void yyerror(const char *error)
{
	fprintf(stderr, "error at line %d: %s\n", ir3_yyget_lineno(), error);
}

struct ir3 * ir3_parse(struct ir3_shader_variant *v,
		struct ir3_kernel_info *k, FILE *f)
{
	ir3_yyset_lineno(1);
	ir3_yyset_input(f);
#ifdef YYDEBUG
	yydebug = 1;
#endif
	info = k;
	variant = v;
	if (yyparse() || !resolve_labels()) {
		ir3_destroy(variant->ir);
		variant->ir = NULL;
	}
	ralloc_free(labels);
	ralloc_free(ir3_parser_dead_ctx);
	return variant->ir;
}

#line 339 "src/freedreno/ir3/ir3_parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "ir3_parser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_T_INT = 3,                      /* T_INT  */
  YYSYMBOL_T_HEX = 4,                      /* T_HEX  */
  YYSYMBOL_T_FLOAT = 5,                    /* T_FLOAT  */
  YYSYMBOL_T_IDENTIFIER = 6,               /* T_IDENTIFIER  */
  YYSYMBOL_T_REGISTER = 7,                 /* T_REGISTER  */
  YYSYMBOL_T_CONSTANT = 8,                 /* T_CONSTANT  */
  YYSYMBOL_T_A_LOCALSIZE = 9,              /* T_A_LOCALSIZE  */
  YYSYMBOL_T_A_CONST = 10,                 /* T_A_CONST  */
  YYSYMBOL_T_A_BUF = 11,                   /* T_A_BUF  */
  YYSYMBOL_T_A_INVOCATIONID = 12,          /* T_A_INVOCATIONID  */
  YYSYMBOL_T_A_WGID = 13,                  /* T_A_WGID  */
  YYSYMBOL_T_A_NUMWG = 14,                 /* T_A_NUMWG  */
  YYSYMBOL_T_A_BRANCHSTACK = 15,           /* T_A_BRANCHSTACK  */
  YYSYMBOL_T_A_IN = 16,                    /* T_A_IN  */
  YYSYMBOL_T_A_OUT = 17,                   /* T_A_OUT  */
  YYSYMBOL_T_A_TEX = 18,                   /* T_A_TEX  */
  YYSYMBOL_T_A_PVTMEM = 19,                /* T_A_PVTMEM  */
  YYSYMBOL_T_A_EARLYPREAMBLE = 20,         /* T_A_EARLYPREAMBLE  */
  YYSYMBOL_T_ABSNEG = 21,                  /* T_ABSNEG  */
  YYSYMBOL_T_NEG = 22,                     /* T_NEG  */
  YYSYMBOL_T_ABS = 23,                     /* T_ABS  */
  YYSYMBOL_T_R = 24,                       /* T_R  */
  YYSYMBOL_T_HR = 25,                      /* T_HR  */
  YYSYMBOL_T_HC = 26,                      /* T_HC  */
  YYSYMBOL_T_EVEN = 27,                    /* T_EVEN  */
  YYSYMBOL_T_POS_INFINITY = 28,            /* T_POS_INFINITY  */
  YYSYMBOL_T_NEG_INFINITY = 29,            /* T_NEG_INFINITY  */
  YYSYMBOL_T_EI = 30,                      /* T_EI  */
  YYSYMBOL_T_WRMASK = 31,                  /* T_WRMASK  */
  YYSYMBOL_T_FLUT_0_0 = 32,                /* T_FLUT_0_0  */
  YYSYMBOL_T_FLUT_0_5 = 33,                /* T_FLUT_0_5  */
  YYSYMBOL_T_FLUT_1_0 = 34,                /* T_FLUT_1_0  */
  YYSYMBOL_T_FLUT_2_0 = 35,                /* T_FLUT_2_0  */
  YYSYMBOL_T_FLUT_E = 36,                  /* T_FLUT_E  */
  YYSYMBOL_T_FLUT_PI = 37,                 /* T_FLUT_PI  */
  YYSYMBOL_T_FLUT_INV_PI = 38,             /* T_FLUT_INV_PI  */
  YYSYMBOL_T_FLUT_INV_LOG2_E = 39,         /* T_FLUT_INV_LOG2_E  */
  YYSYMBOL_T_FLUT_LOG2_E = 40,             /* T_FLUT_LOG2_E  */
  YYSYMBOL_T_FLUT_INV_LOG2_10 = 41,        /* T_FLUT_INV_LOG2_10  */
  YYSYMBOL_T_FLUT_LOG2_10 = 42,            /* T_FLUT_LOG2_10  */
  YYSYMBOL_T_FLUT_4_0 = 43,                /* T_FLUT_4_0  */
  YYSYMBOL_T_SY = 44,                      /* T_SY  */
  YYSYMBOL_T_SS = 45,                      /* T_SS  */
  YYSYMBOL_T_JP = 46,                      /* T_JP  */
  YYSYMBOL_T_SAT = 47,                     /* T_SAT  */
  YYSYMBOL_T_RPT = 48,                     /* T_RPT  */
  YYSYMBOL_T_UL = 49,                      /* T_UL  */
  YYSYMBOL_T_NOP = 50,                     /* T_NOP  */
  YYSYMBOL_T_OP_NOP = 51,                  /* T_OP_NOP  */
  YYSYMBOL_T_OP_BR = 52,                   /* T_OP_BR  */
  YYSYMBOL_T_OP_BRAO = 53,                 /* T_OP_BRAO  */
  YYSYMBOL_T_OP_BRAA = 54,                 /* T_OP_BRAA  */
  YYSYMBOL_T_OP_BRAC = 55,                 /* T_OP_BRAC  */
  YYSYMBOL_T_OP_BANY = 56,                 /* T_OP_BANY  */
  YYSYMBOL_T_OP_BALL = 57,                 /* T_OP_BALL  */
  YYSYMBOL_T_OP_BRAX = 58,                 /* T_OP_BRAX  */
  YYSYMBOL_T_OP_JUMP = 59,                 /* T_OP_JUMP  */
  YYSYMBOL_T_OP_CALL = 60,                 /* T_OP_CALL  */
  YYSYMBOL_T_OP_RET = 61,                  /* T_OP_RET  */
  YYSYMBOL_T_OP_KILL = 62,                 /* T_OP_KILL  */
  YYSYMBOL_T_OP_END = 63,                  /* T_OP_END  */
  YYSYMBOL_T_OP_EMIT = 64,                 /* T_OP_EMIT  */
  YYSYMBOL_T_OP_CUT = 65,                  /* T_OP_CUT  */
  YYSYMBOL_T_OP_CHMASK = 66,               /* T_OP_CHMASK  */
  YYSYMBOL_T_OP_CHSH = 67,                 /* T_OP_CHSH  */
  YYSYMBOL_T_OP_FLOW_REV = 68,             /* T_OP_FLOW_REV  */
  YYSYMBOL_T_OP_BKT = 69,                  /* T_OP_BKT  */
  YYSYMBOL_T_OP_STKS = 70,                 /* T_OP_STKS  */
  YYSYMBOL_T_OP_STKR = 71,                 /* T_OP_STKR  */
  YYSYMBOL_T_OP_XSET = 72,                 /* T_OP_XSET  */
  YYSYMBOL_T_OP_XCLR = 73,                 /* T_OP_XCLR  */
  YYSYMBOL_T_OP_GETLAST = 74,              /* T_OP_GETLAST  */
  YYSYMBOL_T_OP_GETONE = 75,               /* T_OP_GETONE  */
  YYSYMBOL_T_OP_DBG = 76,                  /* T_OP_DBG  */
  YYSYMBOL_T_OP_SHPS = 77,                 /* T_OP_SHPS  */
  YYSYMBOL_T_OP_SHPE = 78,                 /* T_OP_SHPE  */
  YYSYMBOL_T_OP_PREDT = 79,                /* T_OP_PREDT  */
  YYSYMBOL_T_OP_PREDF = 80,                /* T_OP_PREDF  */
  YYSYMBOL_T_OP_PREDE = 81,                /* T_OP_PREDE  */
  YYSYMBOL_T_OP_MOVMSK = 82,               /* T_OP_MOVMSK  */
  YYSYMBOL_T_OP_MOVA1 = 83,                /* T_OP_MOVA1  */
  YYSYMBOL_T_OP_MOVA = 84,                 /* T_OP_MOVA  */
  YYSYMBOL_T_OP_MOV = 85,                  /* T_OP_MOV  */
  YYSYMBOL_T_OP_COV = 86,                  /* T_OP_COV  */
  YYSYMBOL_T_OP_SWZ = 87,                  /* T_OP_SWZ  */
  YYSYMBOL_T_OP_GAT = 88,                  /* T_OP_GAT  */
  YYSYMBOL_T_OP_SCT = 89,                  /* T_OP_SCT  */
  YYSYMBOL_T_OP_ADD_F = 90,                /* T_OP_ADD_F  */
  YYSYMBOL_T_OP_MIN_F = 91,                /* T_OP_MIN_F  */
  YYSYMBOL_T_OP_MAX_F = 92,                /* T_OP_MAX_F  */
  YYSYMBOL_T_OP_MUL_F = 93,                /* T_OP_MUL_F  */
  YYSYMBOL_T_OP_SIGN_F = 94,               /* T_OP_SIGN_F  */
  YYSYMBOL_T_OP_CMPS_F = 95,               /* T_OP_CMPS_F  */
  YYSYMBOL_T_OP_ABSNEG_F = 96,             /* T_OP_ABSNEG_F  */
  YYSYMBOL_T_OP_CMPV_F = 97,               /* T_OP_CMPV_F  */
  YYSYMBOL_T_OP_FLOOR_F = 98,              /* T_OP_FLOOR_F  */
  YYSYMBOL_T_OP_CEIL_F = 99,               /* T_OP_CEIL_F  */
  YYSYMBOL_T_OP_RNDNE_F = 100,             /* T_OP_RNDNE_F  */
  YYSYMBOL_T_OP_RNDAZ_F = 101,             /* T_OP_RNDAZ_F  */
  YYSYMBOL_T_OP_TRUNC_F = 102,             /* T_OP_TRUNC_F  */
  YYSYMBOL_T_OP_ADD_U = 103,               /* T_OP_ADD_U  */
  YYSYMBOL_T_OP_ADD_S = 104,               /* T_OP_ADD_S  */
  YYSYMBOL_T_OP_SUB_U = 105,               /* T_OP_SUB_U  */
  YYSYMBOL_T_OP_SUB_S = 106,               /* T_OP_SUB_S  */
  YYSYMBOL_T_OP_CMPS_U = 107,              /* T_OP_CMPS_U  */
  YYSYMBOL_T_OP_CMPS_S = 108,              /* T_OP_CMPS_S  */
  YYSYMBOL_T_OP_MIN_U = 109,               /* T_OP_MIN_U  */
  YYSYMBOL_T_OP_MIN_S = 110,               /* T_OP_MIN_S  */
  YYSYMBOL_T_OP_MAX_U = 111,               /* T_OP_MAX_U  */
  YYSYMBOL_T_OP_MAX_S = 112,               /* T_OP_MAX_S  */
  YYSYMBOL_T_OP_ABSNEG_S = 113,            /* T_OP_ABSNEG_S  */
  YYSYMBOL_T_OP_AND_B = 114,               /* T_OP_AND_B  */
  YYSYMBOL_T_OP_OR_B = 115,                /* T_OP_OR_B  */
  YYSYMBOL_T_OP_NOT_B = 116,               /* T_OP_NOT_B  */
  YYSYMBOL_T_OP_XOR_B = 117,               /* T_OP_XOR_B  */
  YYSYMBOL_T_OP_CMPV_U = 118,              /* T_OP_CMPV_U  */
  YYSYMBOL_T_OP_CMPV_S = 119,              /* T_OP_CMPV_S  */
  YYSYMBOL_T_OP_MUL_U24 = 120,             /* T_OP_MUL_U24  */
  YYSYMBOL_T_OP_MUL_S24 = 121,             /* T_OP_MUL_S24  */
  YYSYMBOL_T_OP_MULL_U = 122,              /* T_OP_MULL_U  */
  YYSYMBOL_T_OP_BFREV_B = 123,             /* T_OP_BFREV_B  */
  YYSYMBOL_T_OP_CLZ_S = 124,               /* T_OP_CLZ_S  */
  YYSYMBOL_T_OP_CLZ_B = 125,               /* T_OP_CLZ_B  */
  YYSYMBOL_T_OP_SHL_B = 126,               /* T_OP_SHL_B  */
  YYSYMBOL_T_OP_SHR_B = 127,               /* T_OP_SHR_B  */
  YYSYMBOL_T_OP_ASHR_B = 128,              /* T_OP_ASHR_B  */
  YYSYMBOL_T_OP_BARY_F = 129,              /* T_OP_BARY_F  */
  YYSYMBOL_T_OP_FLAT_B = 130,              /* T_OP_FLAT_B  */
  YYSYMBOL_T_OP_MGEN_B = 131,              /* T_OP_MGEN_B  */
  YYSYMBOL_T_OP_GETBIT_B = 132,            /* T_OP_GETBIT_B  */
  YYSYMBOL_T_OP_SETRM = 133,               /* T_OP_SETRM  */
  YYSYMBOL_T_OP_CBITS_B = 134,             /* T_OP_CBITS_B  */
  YYSYMBOL_T_OP_SHB = 135,                 /* T_OP_SHB  */
  YYSYMBOL_T_OP_MSAD = 136,                /* T_OP_MSAD  */
  YYSYMBOL_T_OP_MAD_U16 = 137,             /* T_OP_MAD_U16  */
  YYSYMBOL_T_OP_MADSH_U16 = 138,           /* T_OP_MADSH_U16  */
  YYSYMBOL_T_OP_MAD_S16 = 139,             /* T_OP_MAD_S16  */
  YYSYMBOL_T_OP_MADSH_M16 = 140,           /* T_OP_MADSH_M16  */
  YYSYMBOL_T_OP_MAD_U24 = 141,             /* T_OP_MAD_U24  */
  YYSYMBOL_T_OP_MAD_S24 = 142,             /* T_OP_MAD_S24  */
  YYSYMBOL_T_OP_MAD_F16 = 143,             /* T_OP_MAD_F16  */
  YYSYMBOL_T_OP_MAD_F32 = 144,             /* T_OP_MAD_F32  */
  YYSYMBOL_T_OP_SEL_B16 = 145,             /* T_OP_SEL_B16  */
  YYSYMBOL_T_OP_SEL_B32 = 146,             /* T_OP_SEL_B32  */
  YYSYMBOL_T_OP_SEL_S16 = 147,             /* T_OP_SEL_S16  */
  YYSYMBOL_T_OP_SEL_S32 = 148,             /* T_OP_SEL_S32  */
  YYSYMBOL_T_OP_SEL_F16 = 149,             /* T_OP_SEL_F16  */
  YYSYMBOL_T_OP_SEL_F32 = 150,             /* T_OP_SEL_F32  */
  YYSYMBOL_T_OP_SAD_S16 = 151,             /* T_OP_SAD_S16  */
  YYSYMBOL_T_OP_SAD_S32 = 152,             /* T_OP_SAD_S32  */
  YYSYMBOL_T_OP_SHRM = 153,                /* T_OP_SHRM  */
  YYSYMBOL_T_OP_SHLM = 154,                /* T_OP_SHLM  */
  YYSYMBOL_T_OP_SHRG = 155,                /* T_OP_SHRG  */
  YYSYMBOL_T_OP_SHLG = 156,                /* T_OP_SHLG  */
  YYSYMBOL_T_OP_ANDG = 157,                /* T_OP_ANDG  */
  YYSYMBOL_T_OP_DP2ACC = 158,              /* T_OP_DP2ACC  */
  YYSYMBOL_T_OP_DP4ACC = 159,              /* T_OP_DP4ACC  */
  YYSYMBOL_T_OP_WMM = 160,                 /* T_OP_WMM  */
  YYSYMBOL_T_OP_WMM_ACCU = 161,            /* T_OP_WMM_ACCU  */
  YYSYMBOL_T_OP_RCP = 162,                 /* T_OP_RCP  */
  YYSYMBOL_T_OP_RSQ = 163,                 /* T_OP_RSQ  */
  YYSYMBOL_T_OP_LOG2 = 164,                /* T_OP_LOG2  */
  YYSYMBOL_T_OP_EXP2 = 165,                /* T_OP_EXP2  */
  YYSYMBOL_T_OP_SIN = 166,                 /* T_OP_SIN  */
  YYSYMBOL_T_OP_COS = 167,                 /* T_OP_COS  */
  YYSYMBOL_T_OP_SQRT = 168,                /* T_OP_SQRT  */
  YYSYMBOL_T_OP_HRSQ = 169,                /* T_OP_HRSQ  */
  YYSYMBOL_T_OP_HLOG2 = 170,               /* T_OP_HLOG2  */
  YYSYMBOL_T_OP_HEXP2 = 171,               /* T_OP_HEXP2  */
  YYSYMBOL_T_OP_ISAM = 172,                /* T_OP_ISAM  */
  YYSYMBOL_T_OP_ISAML = 173,               /* T_OP_ISAML  */
  YYSYMBOL_T_OP_ISAMM = 174,               /* T_OP_ISAMM  */
  YYSYMBOL_T_OP_SAM = 175,                 /* T_OP_SAM  */
  YYSYMBOL_T_OP_SAMB = 176,                /* T_OP_SAMB  */
  YYSYMBOL_T_OP_SAML = 177,                /* T_OP_SAML  */
  YYSYMBOL_T_OP_SAMGQ = 178,               /* T_OP_SAMGQ  */
  YYSYMBOL_T_OP_GETLOD = 179,              /* T_OP_GETLOD  */
  YYSYMBOL_T_OP_CONV = 180,                /* T_OP_CONV  */
  YYSYMBOL_T_OP_CONVM = 181,               /* T_OP_CONVM  */
  YYSYMBOL_T_OP_GETSIZE = 182,             /* T_OP_GETSIZE  */
  YYSYMBOL_T_OP_GETBUF = 183,              /* T_OP_GETBUF  */
  YYSYMBOL_T_OP_GETPOS = 184,              /* T_OP_GETPOS  */
  YYSYMBOL_T_OP_GETINFO = 185,             /* T_OP_GETINFO  */
  YYSYMBOL_T_OP_DSX = 186,                 /* T_OP_DSX  */
  YYSYMBOL_T_OP_DSY = 187,                 /* T_OP_DSY  */
  YYSYMBOL_T_OP_GATHER4R = 188,            /* T_OP_GATHER4R  */
  YYSYMBOL_T_OP_GATHER4G = 189,            /* T_OP_GATHER4G  */
  YYSYMBOL_T_OP_GATHER4B = 190,            /* T_OP_GATHER4B  */
  YYSYMBOL_T_OP_GATHER4A = 191,            /* T_OP_GATHER4A  */
  YYSYMBOL_T_OP_SAMGP0 = 192,              /* T_OP_SAMGP0  */
  YYSYMBOL_T_OP_SAMGP1 = 193,              /* T_OP_SAMGP1  */
  YYSYMBOL_T_OP_SAMGP2 = 194,              /* T_OP_SAMGP2  */
  YYSYMBOL_T_OP_SAMGP3 = 195,              /* T_OP_SAMGP3  */
  YYSYMBOL_T_OP_DSXPP_1 = 196,             /* T_OP_DSXPP_1  */
  YYSYMBOL_T_OP_DSYPP_1 = 197,             /* T_OP_DSYPP_1  */
  YYSYMBOL_T_OP_RGETPOS = 198,             /* T_OP_RGETPOS  */
  YYSYMBOL_T_OP_RGETINFO = 199,            /* T_OP_RGETINFO  */
  YYSYMBOL_T_OP_BRCST_A = 200,             /* T_OP_BRCST_A  */
  YYSYMBOL_T_OP_QSHUFFLE_BRCST = 201,      /* T_OP_QSHUFFLE_BRCST  */
  YYSYMBOL_T_OP_QSHUFFLE_H = 202,          /* T_OP_QSHUFFLE_H  */
  YYSYMBOL_T_OP_QSHUFFLE_V = 203,          /* T_OP_QSHUFFLE_V  */
  YYSYMBOL_T_OP_QSHUFFLE_DIAG = 204,       /* T_OP_QSHUFFLE_DIAG  */
  YYSYMBOL_T_OP_LDG = 205,                 /* T_OP_LDG  */
  YYSYMBOL_T_OP_LDG_A = 206,               /* T_OP_LDG_A  */
  YYSYMBOL_T_OP_LDL = 207,                 /* T_OP_LDL  */
  YYSYMBOL_T_OP_LDP = 208,                 /* T_OP_LDP  */
  YYSYMBOL_T_OP_STG = 209,                 /* T_OP_STG  */
  YYSYMBOL_T_OP_STG_A = 210,               /* T_OP_STG_A  */
  YYSYMBOL_T_OP_STL = 211,                 /* T_OP_STL  */
  YYSYMBOL_T_OP_STP = 212,                 /* T_OP_STP  */
  YYSYMBOL_T_OP_LDIB = 213,                /* T_OP_LDIB  */
  YYSYMBOL_T_OP_G2L = 214,                 /* T_OP_G2L  */
  YYSYMBOL_T_OP_L2G = 215,                 /* T_OP_L2G  */
  YYSYMBOL_T_OP_PREFETCH = 216,            /* T_OP_PREFETCH  */
  YYSYMBOL_T_OP_LDLW = 217,                /* T_OP_LDLW  */
  YYSYMBOL_T_OP_STLW = 218,                /* T_OP_STLW  */
  YYSYMBOL_T_OP_RESFMT = 219,              /* T_OP_RESFMT  */
  YYSYMBOL_T_OP_RESINFO = 220,             /* T_OP_RESINFO  */
  YYSYMBOL_T_OP_ATOMIC_ADD = 221,          /* T_OP_ATOMIC_ADD  */
  YYSYMBOL_T_OP_ATOMIC_SUB = 222,          /* T_OP_ATOMIC_SUB  */
  YYSYMBOL_T_OP_ATOMIC_XCHG = 223,         /* T_OP_ATOMIC_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_INC = 224,          /* T_OP_ATOMIC_INC  */
  YYSYMBOL_T_OP_ATOMIC_DEC = 225,          /* T_OP_ATOMIC_DEC  */
  YYSYMBOL_T_OP_ATOMIC_CMPXCHG = 226,      /* T_OP_ATOMIC_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_MIN = 227,          /* T_OP_ATOMIC_MIN  */
  YYSYMBOL_T_OP_ATOMIC_MAX = 228,          /* T_OP_ATOMIC_MAX  */
  YYSYMBOL_T_OP_ATOMIC_AND = 229,          /* T_OP_ATOMIC_AND  */
  YYSYMBOL_T_OP_ATOMIC_OR = 230,           /* T_OP_ATOMIC_OR  */
  YYSYMBOL_T_OP_ATOMIC_XOR = 231,          /* T_OP_ATOMIC_XOR  */
  YYSYMBOL_T_OP_RESINFO_B = 232,           /* T_OP_RESINFO_B  */
  YYSYMBOL_T_OP_LDIB_B = 233,              /* T_OP_LDIB_B  */
  YYSYMBOL_T_OP_STIB_B = 234,              /* T_OP_STIB_B  */
  YYSYMBOL_T_OP_ATOMIC_B_ADD = 235,        /* T_OP_ATOMIC_B_ADD  */
  YYSYMBOL_T_OP_ATOMIC_B_SUB = 236,        /* T_OP_ATOMIC_B_SUB  */
  YYSYMBOL_T_OP_ATOMIC_B_XCHG = 237,       /* T_OP_ATOMIC_B_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_B_INC = 238,        /* T_OP_ATOMIC_B_INC  */
  YYSYMBOL_T_OP_ATOMIC_B_DEC = 239,        /* T_OP_ATOMIC_B_DEC  */
  YYSYMBOL_T_OP_ATOMIC_B_CMPXCHG = 240,    /* T_OP_ATOMIC_B_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_B_MIN = 241,        /* T_OP_ATOMIC_B_MIN  */
  YYSYMBOL_T_OP_ATOMIC_B_MAX = 242,        /* T_OP_ATOMIC_B_MAX  */
  YYSYMBOL_T_OP_ATOMIC_B_AND = 243,        /* T_OP_ATOMIC_B_AND  */
  YYSYMBOL_T_OP_ATOMIC_B_OR = 244,         /* T_OP_ATOMIC_B_OR  */
  YYSYMBOL_T_OP_ATOMIC_B_XOR = 245,        /* T_OP_ATOMIC_B_XOR  */
  YYSYMBOL_T_OP_ATOMIC_S_ADD = 246,        /* T_OP_ATOMIC_S_ADD  */
  YYSYMBOL_T_OP_ATOMIC_S_SUB = 247,        /* T_OP_ATOMIC_S_SUB  */
  YYSYMBOL_T_OP_ATOMIC_S_XCHG = 248,       /* T_OP_ATOMIC_S_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_S_INC = 249,        /* T_OP_ATOMIC_S_INC  */
  YYSYMBOL_T_OP_ATOMIC_S_DEC = 250,        /* T_OP_ATOMIC_S_DEC  */
  YYSYMBOL_T_OP_ATOMIC_S_CMPXCHG = 251,    /* T_OP_ATOMIC_S_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_S_MIN = 252,        /* T_OP_ATOMIC_S_MIN  */
  YYSYMBOL_T_OP_ATOMIC_S_MAX = 253,        /* T_OP_ATOMIC_S_MAX  */
  YYSYMBOL_T_OP_ATOMIC_S_AND = 254,        /* T_OP_ATOMIC_S_AND  */
  YYSYMBOL_T_OP_ATOMIC_S_OR = 255,         /* T_OP_ATOMIC_S_OR  */
  YYSYMBOL_T_OP_ATOMIC_S_XOR = 256,        /* T_OP_ATOMIC_S_XOR  */
  YYSYMBOL_T_OP_ATOMIC_G_ADD = 257,        /* T_OP_ATOMIC_G_ADD  */
  YYSYMBOL_T_OP_ATOMIC_G_SUB = 258,        /* T_OP_ATOMIC_G_SUB  */
  YYSYMBOL_T_OP_ATOMIC_G_XCHG = 259,       /* T_OP_ATOMIC_G_XCHG  */
  YYSYMBOL_T_OP_ATOMIC_G_INC = 260,        /* T_OP_ATOMIC_G_INC  */
  YYSYMBOL_T_OP_ATOMIC_G_DEC = 261,        /* T_OP_ATOMIC_G_DEC  */
  YYSYMBOL_T_OP_ATOMIC_G_CMPXCHG = 262,    /* T_OP_ATOMIC_G_CMPXCHG  */
  YYSYMBOL_T_OP_ATOMIC_G_MIN = 263,        /* T_OP_ATOMIC_G_MIN  */
  YYSYMBOL_T_OP_ATOMIC_G_MAX = 264,        /* T_OP_ATOMIC_G_MAX  */
  YYSYMBOL_T_OP_ATOMIC_G_AND = 265,        /* T_OP_ATOMIC_G_AND  */
  YYSYMBOL_T_OP_ATOMIC_G_OR = 266,         /* T_OP_ATOMIC_G_OR  */
  YYSYMBOL_T_OP_ATOMIC_G_XOR = 267,        /* T_OP_ATOMIC_G_XOR  */
  YYSYMBOL_T_OP_LDGB = 268,                /* T_OP_LDGB  */
  YYSYMBOL_T_OP_STGB = 269,                /* T_OP_STGB  */
  YYSYMBOL_T_OP_STIB = 270,                /* T_OP_STIB  */
  YYSYMBOL_T_OP_LDC = 271,                 /* T_OP_LDC  */
  YYSYMBOL_T_OP_LDLV = 272,                /* T_OP_LDLV  */
  YYSYMBOL_T_OP_GETSPID = 273,             /* T_OP_GETSPID  */
  YYSYMBOL_T_OP_GETWID = 274,              /* T_OP_GETWID  */
  YYSYMBOL_T_OP_GETFIBERID = 275,          /* T_OP_GETFIBERID  */
  YYSYMBOL_T_OP_STC = 276,                 /* T_OP_STC  */
  YYSYMBOL_T_OP_BAR = 277,                 /* T_OP_BAR  */
  YYSYMBOL_T_OP_FENCE = 278,               /* T_OP_FENCE  */
  YYSYMBOL_T_TYPE_F16 = 279,               /* T_TYPE_F16  */
  YYSYMBOL_T_TYPE_F32 = 280,               /* T_TYPE_F32  */
  YYSYMBOL_T_TYPE_U16 = 281,               /* T_TYPE_U16  */
  YYSYMBOL_T_TYPE_U32 = 282,               /* T_TYPE_U32  */
  YYSYMBOL_T_TYPE_S16 = 283,               /* T_TYPE_S16  */
  YYSYMBOL_T_TYPE_S32 = 284,               /* T_TYPE_S32  */
  YYSYMBOL_T_TYPE_U8 = 285,                /* T_TYPE_U8  */
  YYSYMBOL_T_TYPE_S8 = 286,                /* T_TYPE_S8  */
  YYSYMBOL_T_UNTYPED = 287,                /* T_UNTYPED  */
  YYSYMBOL_T_TYPED = 288,                  /* T_TYPED  */
  YYSYMBOL_T_MIXED = 289,                  /* T_MIXED  */
  YYSYMBOL_T_UNSIGNED = 290,               /* T_UNSIGNED  */
  YYSYMBOL_T_LOW = 291,                    /* T_LOW  */
  YYSYMBOL_T_HIGH = 292,                   /* T_HIGH  */
  YYSYMBOL_T_1D = 293,                     /* T_1D  */
  YYSYMBOL_T_2D = 294,                     /* T_2D  */
  YYSYMBOL_T_3D = 295,                     /* T_3D  */
  YYSYMBOL_T_4D = 296,                     /* T_4D  */
  YYSYMBOL_T_LT = 297,                     /* T_LT  */
  YYSYMBOL_T_LE = 298,                     /* T_LE  */
  YYSYMBOL_T_GT = 299,                     /* T_GT  */
  YYSYMBOL_T_GE = 300,                     /* T_GE  */
  YYSYMBOL_T_EQ = 301,                     /* T_EQ  */
  YYSYMBOL_T_NE = 302,                     /* T_NE  */
  YYSYMBOL_T_S2EN = 303,                   /* T_S2EN  */
  YYSYMBOL_T_SAMP = 304,                   /* T_SAMP  */
  YYSYMBOL_T_TEX = 305,                    /* T_TEX  */
  YYSYMBOL_T_BASE = 306,                   /* T_BASE  */
  YYSYMBOL_T_OFFSET = 307,                 /* T_OFFSET  */
  YYSYMBOL_T_UNIFORM = 308,                /* T_UNIFORM  */
  YYSYMBOL_T_NONUNIFORM = 309,             /* T_NONUNIFORM  */
  YYSYMBOL_T_IMM = 310,                    /* T_IMM  */
  YYSYMBOL_T_NAN = 311,                    /* T_NAN  */
  YYSYMBOL_T_INF = 312,                    /* T_INF  */
  YYSYMBOL_T_A0 = 313,                     /* T_A0  */
  YYSYMBOL_T_A1 = 314,                     /* T_A1  */
  YYSYMBOL_T_P0 = 315,                     /* T_P0  */
  YYSYMBOL_T_W = 316,                      /* T_W  */
  YYSYMBOL_T_CAT1_TYPE_TYPE = 317,         /* T_CAT1_TYPE_TYPE  */
  YYSYMBOL_318_ = 318,                     /* '-'  */
  YYSYMBOL_319_ = 319,                     /* ','  */
  YYSYMBOL_320_ = 320,                     /* '('  */
  YYSYMBOL_321_ = 321,                     /* ')'  */
  YYSYMBOL_322_ = 322,                     /* '='  */
  YYSYMBOL_323_ = 323,                     /* ':'  */
  YYSYMBOL_324_ = 324,                     /* '!'  */
  YYSYMBOL_325_ = 325,                     /* '#'  */
  YYSYMBOL_326_ = 326,                     /* '.'  */
  YYSYMBOL_327_a_ = 327,                   /* 'a'  */
  YYSYMBOL_328_o_ = 328,                   /* 'o'  */
  YYSYMBOL_329_p_ = 329,                   /* 'p'  */
  YYSYMBOL_330_s_ = 330,                   /* 's'  */
  YYSYMBOL_331_ = 331,                     /* '+'  */
  YYSYMBOL_332_ = 332,                     /* '<'  */
  YYSYMBOL_333_g_ = 333,                   /* 'g'  */
  YYSYMBOL_334_ = 334,                     /* '['  */
  YYSYMBOL_335_ = 335,                     /* ']'  */
  YYSYMBOL_336_l_ = 336,                   /* 'l'  */
  YYSYMBOL_337_k_ = 337,                   /* 'k'  */
  YYSYMBOL_338_c_ = 338,                   /* 'c'  */
  YYSYMBOL_339_w_ = 339,                   /* 'w'  */
  YYSYMBOL_340_r_ = 340,                   /* 'r'  */
  YYSYMBOL_341_ = 341,                     /* '>'  */
  YYSYMBOL_342_h_ = 342,                   /* 'h'  */
  YYSYMBOL_YYACCEPT = 343,                 /* $accept  */
  YYSYMBOL_shader = 344,                   /* shader  */
  YYSYMBOL_345_1 = 345,                    /* $@1  */
  YYSYMBOL_headers = 346,                  /* headers  */
  YYSYMBOL_header = 347,                   /* header  */
  YYSYMBOL_const_val = 348,                /* const_val  */
  YYSYMBOL_localsize_header = 349,         /* localsize_header  */
  YYSYMBOL_const_header = 350,             /* const_header  */
  YYSYMBOL_buf_header_addr_reg = 351,      /* buf_header_addr_reg  */
  YYSYMBOL_buf_header = 352,               /* buf_header  */
  YYSYMBOL_353_2 = 353,                    /* $@2  */
  YYSYMBOL_invocationid_header = 354,      /* invocationid_header  */
  YYSYMBOL_wgid_header = 355,              /* wgid_header  */
  YYSYMBOL_numwg_header = 356,             /* numwg_header  */
  YYSYMBOL_branchstack_header = 357,       /* branchstack_header  */
  YYSYMBOL_pvtmem_header = 358,            /* pvtmem_header  */
  YYSYMBOL_earlypreamble_header = 359,     /* earlypreamble_header  */
  YYSYMBOL_in_header = 360,                /* in_header  */
  YYSYMBOL_out_header = 361,               /* out_header  */
  YYSYMBOL_tex_header = 362,               /* tex_header  */
  YYSYMBOL_iflag = 363,                    /* iflag  */
  YYSYMBOL_iflags = 364,                   /* iflags  */
  YYSYMBOL_instrs = 365,                   /* instrs  */
  YYSYMBOL_instr = 366,                    /* instr  */
  YYSYMBOL_label = 367,                    /* label  */
  YYSYMBOL_cat0_src1 = 368,                /* cat0_src1  */
  YYSYMBOL_cat0_src2 = 369,                /* cat0_src2  */
  YYSYMBOL_cat0_immed = 370,               /* cat0_immed  */
  YYSYMBOL_cat0_instr = 371,               /* cat0_instr  */
  YYSYMBOL_372_3 = 372,                    /* $@3  */
  YYSYMBOL_373_4 = 373,                    /* $@4  */
  YYSYMBOL_374_5 = 374,                    /* $@5  */
  YYSYMBOL_375_6 = 375,                    /* $@6  */
  YYSYMBOL_376_7 = 376,                    /* $@7  */
  YYSYMBOL_377_8 = 377,                    /* $@8  */
  YYSYMBOL_378_9 = 378,                    /* $@9  */
  YYSYMBOL_379_10 = 379,                   /* $@10  */
  YYSYMBOL_380_11 = 380,                   /* $@11  */
  YYSYMBOL_381_12 = 381,                   /* $@12  */
  YYSYMBOL_382_13 = 382,                   /* $@13  */
  YYSYMBOL_383_14 = 383,                   /* $@14  */
  YYSYMBOL_384_15 = 384,                   /* $@15  */
  YYSYMBOL_385_16 = 385,                   /* $@16  */
  YYSYMBOL_386_17 = 386,                   /* $@17  */
  YYSYMBOL_387_18 = 387,                   /* $@18  */
  YYSYMBOL_cat1_opc = 388,                 /* cat1_opc  */
  YYSYMBOL_cat1_src = 389,                 /* cat1_src  */
  YYSYMBOL_cat1_movmsk = 390,              /* cat1_movmsk  */
  YYSYMBOL_391_19 = 391,                   /* $@19  */
  YYSYMBOL_cat1_mova1 = 392,               /* cat1_mova1  */
  YYSYMBOL_393_20 = 393,                   /* $@20  */
  YYSYMBOL_cat1_mova = 394,                /* cat1_mova  */
  YYSYMBOL_395_21 = 395,                   /* $@21  */
  YYSYMBOL_cat1_swz = 396,                 /* cat1_swz  */
  YYSYMBOL_397_22 = 397,                   /* $@22  */
  YYSYMBOL_cat1_gat = 398,                 /* cat1_gat  */
  YYSYMBOL_399_23 = 399,                   /* $@23  */
  YYSYMBOL_cat1_sct = 400,                 /* cat1_sct  */
  YYSYMBOL_401_24 = 401,                   /* $@24  */
  YYSYMBOL_cat1_instr = 402,               /* cat1_instr  */
  YYSYMBOL_cat2_opc_1src = 403,            /* cat2_opc_1src  */
  YYSYMBOL_cat2_opc_2src_cnd = 404,        /* cat2_opc_2src_cnd  */
  YYSYMBOL_cat2_opc_2src = 405,            /* cat2_opc_2src  */
  YYSYMBOL_cond = 406,                     /* cond  */
  YYSYMBOL_cat2_instr = 407,               /* cat2_instr  */
  YYSYMBOL_cat3_dp_signedness = 408,       /* cat3_dp_signedness  */
  YYSYMBOL_cat3_dp_pack = 409,             /* cat3_dp_pack  */
  YYSYMBOL_cat3_opc = 410,                 /* cat3_opc  */
  YYSYMBOL_cat3_imm_reg_opc = 411,         /* cat3_imm_reg_opc  */
  YYSYMBOL_cat3_wmm = 412,                 /* cat3_wmm  */
  YYSYMBOL_cat3_dp = 413,                  /* cat3_dp  */
  YYSYMBOL_cat3_instr = 414,               /* cat3_instr  */
  YYSYMBOL_cat4_opc = 415,                 /* cat4_opc  */
  YYSYMBOL_cat4_instr = 416,               /* cat4_instr  */
  YYSYMBOL_cat5_opc_dsxypp = 417,          /* cat5_opc_dsxypp  */
  YYSYMBOL_cat5_opc = 418,                 /* cat5_opc  */
  YYSYMBOL_cat5_flag = 419,                /* cat5_flag  */
  YYSYMBOL_cat5_flags = 420,               /* cat5_flags  */
  YYSYMBOL_cat5_samp = 421,                /* cat5_samp  */
  YYSYMBOL_cat5_tex = 422,                 /* cat5_tex  */
  YYSYMBOL_cat5_type = 423,                /* cat5_type  */
  YYSYMBOL_cat5_a1 = 424,                  /* cat5_a1  */
  YYSYMBOL_cat5_instr = 425,               /* cat5_instr  */
  YYSYMBOL_cat6_typed = 426,               /* cat6_typed  */
  YYSYMBOL_cat6_dim = 427,                 /* cat6_dim  */
  YYSYMBOL_cat6_type = 428,                /* cat6_type  */
  YYSYMBOL_cat6_imm_offset = 429,          /* cat6_imm_offset  */
  YYSYMBOL_cat6_offset = 430,              /* cat6_offset  */
  YYSYMBOL_cat6_dst_offset = 431,          /* cat6_dst_offset  */
  YYSYMBOL_cat6_immed = 432,               /* cat6_immed  */
  YYSYMBOL_cat6_stg_ldg_a6xx_offset = 433, /* cat6_stg_ldg_a6xx_offset  */
  YYSYMBOL_cat6_load = 434,                /* cat6_load  */
  YYSYMBOL_435_25 = 435,                   /* $@25  */
  YYSYMBOL_436_26 = 436,                   /* $@26  */
  YYSYMBOL_437_27 = 437,                   /* $@27  */
  YYSYMBOL_438_28 = 438,                   /* $@28  */
  YYSYMBOL_439_29 = 439,                   /* $@29  */
  YYSYMBOL_440_30 = 440,                   /* $@30  */
  YYSYMBOL_441_31 = 441,                   /* $@31  */
  YYSYMBOL_cat6_store = 442,               /* cat6_store  */
  YYSYMBOL_443_32 = 443,                   /* $@32  */
  YYSYMBOL_444_33 = 444,                   /* $@33  */
  YYSYMBOL_445_34 = 445,                   /* $@34  */
  YYSYMBOL_446_35 = 446,                   /* $@35  */
  YYSYMBOL_447_36 = 447,                   /* $@36  */
  YYSYMBOL_cat6_loadib = 448,              /* cat6_loadib  */
  YYSYMBOL_449_37 = 449,                   /* $@37  */
  YYSYMBOL_cat6_storeib = 450,             /* cat6_storeib  */
  YYSYMBOL_451_38 = 451,                   /* $@38  */
  YYSYMBOL_cat6_prefetch = 452,            /* cat6_prefetch  */
  YYSYMBOL_453_39 = 453,                   /* $@39  */
  YYSYMBOL_cat6_atomic_opc = 454,          /* cat6_atomic_opc  */
  YYSYMBOL_cat6_a3xx_atomic_opc = 455,     /* cat6_a3xx_atomic_opc  */
  YYSYMBOL_cat6_a6xx_atomic_opc = 456,     /* cat6_a6xx_atomic_opc  */
  YYSYMBOL_cat6_a3xx_atomic_s = 457,       /* cat6_a3xx_atomic_s  */
  YYSYMBOL_cat6_a6xx_atomic_g = 458,       /* cat6_a6xx_atomic_g  */
  YYSYMBOL_cat6_atomic_l = 459,            /* cat6_atomic_l  */
  YYSYMBOL_cat6_atomic = 460,              /* cat6_atomic  */
  YYSYMBOL_cat6_ibo_opc_1src = 461,        /* cat6_ibo_opc_1src  */
  YYSYMBOL_cat6_ibo_opc_ldgb = 462,        /* cat6_ibo_opc_ldgb  */
  YYSYMBOL_cat6_ibo_opc_stgb = 463,        /* cat6_ibo_opc_stgb  */
  YYSYMBOL_cat6_ibo = 464,                 /* cat6_ibo  */
  YYSYMBOL_465_40 = 465,                   /* $@40  */
  YYSYMBOL_cat6_id_opc = 466,              /* cat6_id_opc  */
  YYSYMBOL_cat6_id = 467,                  /* cat6_id  */
  YYSYMBOL_cat6_bindless_base = 468,       /* cat6_bindless_base  */
  YYSYMBOL_cat6_bindless_mode = 469,       /* cat6_bindless_mode  */
  YYSYMBOL_cat6_reg_or_immed = 470,        /* cat6_reg_or_immed  */
  YYSYMBOL_cat6_bindless_ibo_opc_1src = 471, /* cat6_bindless_ibo_opc_1src  */
  YYSYMBOL_cat6_bindless_ibo_opc_2src = 472, /* cat6_bindless_ibo_opc_2src  */
  YYSYMBOL_cat6_bindless_ibo_opc_2src_dst = 473, /* cat6_bindless_ibo_opc_2src_dst  */
  YYSYMBOL_cat6_bindless_ibo = 474,        /* cat6_bindless_ibo  */
  YYSYMBOL_cat6_bindless_ldc_opc = 475,    /* cat6_bindless_ldc_opc  */
  YYSYMBOL_cat6_bindless_ldc_middle = 476, /* cat6_bindless_ldc_middle  */
  YYSYMBOL_cat6_bindless_ldc = 477,        /* cat6_bindless_ldc  */
  YYSYMBOL_stc_dst = 478,                  /* stc_dst  */
  YYSYMBOL_cat6_stc = 479,                 /* cat6_stc  */
  YYSYMBOL_480_41 = 480,                   /* $@41  */
  YYSYMBOL_cat6_todo = 481,                /* cat6_todo  */
  YYSYMBOL_cat6_instr = 482,               /* cat6_instr  */
  YYSYMBOL_cat7_scope = 483,               /* cat7_scope  */
  YYSYMBOL_cat7_scopes = 484,              /* cat7_scopes  */
  YYSYMBOL_cat7_barrier = 485,             /* cat7_barrier  */
  YYSYMBOL_486_42 = 486,                   /* $@42  */
  YYSYMBOL_487_43 = 487,                   /* $@43  */
  YYSYMBOL_cat7_instr = 488,               /* cat7_instr  */
  YYSYMBOL_src = 489,                      /* src  */
  YYSYMBOL_dst = 490,                      /* dst  */
  YYSYMBOL_const = 491,                    /* const  */
  YYSYMBOL_dst_reg_flag = 492,             /* dst_reg_flag  */
  YYSYMBOL_dst_reg_flags = 493,            /* dst_reg_flags  */
  YYSYMBOL_dst_reg = 494,                  /* dst_reg  */
  YYSYMBOL_src_reg_flag = 495,             /* src_reg_flag  */
  YYSYMBOL_src_reg_flags = 496,            /* src_reg_flags  */
  YYSYMBOL_src_reg = 497,                  /* src_reg  */
  YYSYMBOL_src_reg_gpr = 498,              /* src_reg_gpr  */
  YYSYMBOL_src_const = 499,                /* src_const  */
  YYSYMBOL_src_reg_or_const = 500,         /* src_reg_or_const  */
  YYSYMBOL_src_reg_or_const_or_rel = 501,  /* src_reg_or_const_or_rel  */
  YYSYMBOL_src_reg_or_const_or_rel_or_imm = 502, /* src_reg_or_const_or_rel_or_imm  */
  YYSYMBOL_src_reg_or_rel_or_imm = 503,    /* src_reg_or_rel_or_imm  */
  YYSYMBOL_offset = 504,                   /* offset  */
  YYSYMBOL_relative_gpr_src = 505,         /* relative_gpr_src  */
  YYSYMBOL_relative_gpr_dst = 506,         /* relative_gpr_dst  */
  YYSYMBOL_relative_const = 507,           /* relative_const  */
  YYSYMBOL_relative = 508,                 /* relative  */
  YYSYMBOL_immediate_cat1 = 509,           /* immediate_cat1  */
  YYSYMBOL_immediate = 510,                /* immediate  */
  YYSYMBOL_flut_immed = 511,               /* flut_immed  */
  YYSYMBOL_integer = 512,                  /* integer  */
  YYSYMBOL_float = 513,                    /* float  */
  YYSYMBOL_type = 514                      /* type  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 307 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"

#if YYDEBUG
static void print_token(FILE *file, int type, YYSTYPE value)
{
	fprintf(file, "\ntype: %d\n", type);
}

#define YYPRINT(file, type, value) print_token(file, type, value)
#endif

#line 898 "src/freedreno/ir3/ir3_parser.c"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   1367

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  343
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  172
/* YYNRULES -- Number of rules.  */
#define YYNRULES  542
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1136

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   572


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   324,     2,   325,     2,     2,     2,     2,
     320,   321,     2,   331,   319,   318,   326,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   323,     2,
     332,   322,   341,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   334,     2,   335,     2,     2,     2,   327,     2,   338,
       2,     2,     2,   333,   342,     2,     2,   337,   336,     2,
       2,   328,   329,     2,   340,   330,     2,     2,     2,   339,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   689,   689,   689,   691,   692,   694,   695,   696,   697,
     698,   699,   700,   701,   702,   703,   704,   705,   707,   708,
     709,   710,   712,   718,   723,   731,   733,   733,   739,   745,
     752,   759,   768,   770,   772,   775,   777,   779,   786,   787,
     788,   789,   790,   791,   792,   794,   795,   797,   798,   800,
     801,   802,   803,   804,   805,   806,   807,   808,   810,   812,
     813,   815,   816,   818,   819,   821,   822,   822,   823,   823,
     824,   824,   825,   825,   826,   826,   827,   827,   828,   828,
     829,   829,   830,   830,   831,   832,   832,   833,   834,   835,
     836,   837,   838,   839,   839,   840,   841,   842,   843,   844,
     844,   845,   846,   846,   847,   848,   848,   849,   849,   850,
     851,   851,   853,   856,   860,   861,   863,   863,   879,   879,
     886,   886,   893,   893,   895,   895,   897,   897,   900,   901,
     902,   903,   904,   905,   906,   907,   909,   910,   911,   912,
     913,   914,   915,   916,   917,   918,   919,   920,   921,   922,
     924,   925,   926,   927,   928,   929,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   959,   960,   961,   962,   963,   964,   966,
     967,   968,   970,   971,   973,   974,   976,   977,   978,   979,
     980,   981,   982,   983,   984,   985,   986,   987,   988,   989,
     990,   991,   993,   994,   995,   996,   997,   999,  1000,  1002,
    1003,  1005,  1006,  1007,  1008,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1021,  1023,  1024,  1026,  1027,
    1028,  1029,  1030,  1031,  1032,  1033,  1034,  1035,  1036,  1037,
    1038,  1039,  1040,  1041,  1042,  1043,  1044,  1045,  1046,  1047,
    1048,  1049,  1050,  1051,  1052,  1053,  1054,  1055,  1056,  1058,
    1059,  1060,  1061,  1062,  1063,  1064,  1065,  1066,  1067,  1068,
    1069,  1071,  1072,  1073,  1074,  1076,  1077,  1078,  1079,  1080,
    1081,  1082,  1083,  1084,  1085,  1086,  1087,  1088,  1089,  1090,
    1092,  1093,  1095,  1096,  1097,  1098,  1100,  1101,  1102,  1103,
    1104,  1105,  1107,  1110,  1115,  1121,  1121,  1122,  1122,  1123,
    1123,  1124,  1124,  1125,  1125,  1126,  1126,  1126,  1130,  1130,
    1131,  1131,  1132,  1132,  1133,  1133,  1134,  1134,  1136,  1136,
    1137,  1137,  1139,  1139,  1141,  1142,  1143,  1144,  1145,  1146,
    1147,  1148,  1149,  1150,  1151,  1153,  1154,  1155,  1156,  1157,
    1158,  1159,  1160,  1161,  1162,  1163,  1165,  1166,  1167,  1168,
    1169,  1170,  1171,  1172,  1173,  1174,  1175,  1177,  1179,  1181,
    1183,  1184,  1185,  1187,  1189,  1190,  1192,  1193,  1194,  1194,
    1197,  1198,  1199,  1201,  1203,  1204,  1206,  1207,  1208,  1210,
    1211,  1213,  1215,  1216,  1217,  1218,  1219,  1220,  1221,  1222,
    1223,  1224,  1225,  1226,  1228,  1230,  1231,  1232,  1234,  1238,
    1239,  1241,  1247,  1248,  1249,  1251,  1251,  1253,  1254,  1255,
    1257,  1258,  1259,  1260,  1261,  1262,  1263,  1264,  1265,  1266,
    1267,  1268,  1270,  1271,  1272,  1273,  1275,  1276,  1278,  1278,
    1279,  1279,  1281,  1283,  1284,  1285,  1286,  1288,  1289,  1290,
    1291,  1293,  1295,  1296,  1297,  1298,  1299,  1301,  1302,  1305,
    1306,  1308,  1309,  1310,  1311,  1313,  1314,  1316,  1317,  1319,
    1320,  1322,  1323,  1325,  1326,  1328,  1329,  1330,  1332,  1333,
    1334,  1336,  1337,  1338,  1340,  1341,  1342,  1344,  1345,  1347,
    1348,  1350,  1351,  1353,  1354,  1360,  1361,  1362,  1363,  1364,
    1365,  1366,  1368,  1369,  1370,  1371,  1372,  1375,  1376,  1377,
    1378,  1379,  1380,  1381,  1382,  1383,  1384,  1385,  1386,  1388,
    1389,  1390,  1391,  1393,  1394,  1396,  1397,  1398,  1399,  1400,
    1401,  1402,  1403
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "T_INT", "T_HEX",
  "T_FLOAT", "T_IDENTIFIER", "T_REGISTER", "T_CONSTANT", "T_A_LOCALSIZE",
  "T_A_CONST", "T_A_BUF", "T_A_INVOCATIONID", "T_A_WGID", "T_A_NUMWG",
  "T_A_BRANCHSTACK", "T_A_IN", "T_A_OUT", "T_A_TEX", "T_A_PVTMEM",
  "T_A_EARLYPREAMBLE", "T_ABSNEG", "T_NEG", "T_ABS", "T_R", "T_HR", "T_HC",
  "T_EVEN", "T_POS_INFINITY", "T_NEG_INFINITY", "T_EI", "T_WRMASK",
  "T_FLUT_0_0", "T_FLUT_0_5", "T_FLUT_1_0", "T_FLUT_2_0", "T_FLUT_E",
  "T_FLUT_PI", "T_FLUT_INV_PI", "T_FLUT_INV_LOG2_E", "T_FLUT_LOG2_E",
  "T_FLUT_INV_LOG2_10", "T_FLUT_LOG2_10", "T_FLUT_4_0", "T_SY", "T_SS",
  "T_JP", "T_SAT", "T_RPT", "T_UL", "T_NOP", "T_OP_NOP", "T_OP_BR",
  "T_OP_BRAO", "T_OP_BRAA", "T_OP_BRAC", "T_OP_BANY", "T_OP_BALL",
  "T_OP_BRAX", "T_OP_JUMP", "T_OP_CALL", "T_OP_RET", "T_OP_KILL",
  "T_OP_END", "T_OP_EMIT", "T_OP_CUT", "T_OP_CHMASK", "T_OP_CHSH",
  "T_OP_FLOW_REV", "T_OP_BKT", "T_OP_STKS", "T_OP_STKR", "T_OP_XSET",
  "T_OP_XCLR", "T_OP_GETLAST", "T_OP_GETONE", "T_OP_DBG", "T_OP_SHPS",
  "T_OP_SHPE", "T_OP_PREDT", "T_OP_PREDF", "T_OP_PREDE", "T_OP_MOVMSK",
  "T_OP_MOVA1", "T_OP_MOVA", "T_OP_MOV", "T_OP_COV", "T_OP_SWZ",
  "T_OP_GAT", "T_OP_SCT", "T_OP_ADD_F", "T_OP_MIN_F", "T_OP_MAX_F",
  "T_OP_MUL_F", "T_OP_SIGN_F", "T_OP_CMPS_F", "T_OP_ABSNEG_F",
  "T_OP_CMPV_F", "T_OP_FLOOR_F", "T_OP_CEIL_F", "T_OP_RNDNE_F",
  "T_OP_RNDAZ_F", "T_OP_TRUNC_F", "T_OP_ADD_U", "T_OP_ADD_S", "T_OP_SUB_U",
  "T_OP_SUB_S", "T_OP_CMPS_U", "T_OP_CMPS_S", "T_OP_MIN_U", "T_OP_MIN_S",
  "T_OP_MAX_U", "T_OP_MAX_S", "T_OP_ABSNEG_S", "T_OP_AND_B", "T_OP_OR_B",
  "T_OP_NOT_B", "T_OP_XOR_B", "T_OP_CMPV_U", "T_OP_CMPV_S", "T_OP_MUL_U24",
  "T_OP_MUL_S24", "T_OP_MULL_U", "T_OP_BFREV_B", "T_OP_CLZ_S",
  "T_OP_CLZ_B", "T_OP_SHL_B", "T_OP_SHR_B", "T_OP_ASHR_B", "T_OP_BARY_F",
  "T_OP_FLAT_B", "T_OP_MGEN_B", "T_OP_GETBIT_B", "T_OP_SETRM",
  "T_OP_CBITS_B", "T_OP_SHB", "T_OP_MSAD", "T_OP_MAD_U16",
  "T_OP_MADSH_U16", "T_OP_MAD_S16", "T_OP_MADSH_M16", "T_OP_MAD_U24",
  "T_OP_MAD_S24", "T_OP_MAD_F16", "T_OP_MAD_F32", "T_OP_SEL_B16",
  "T_OP_SEL_B32", "T_OP_SEL_S16", "T_OP_SEL_S32", "T_OP_SEL_F16",
  "T_OP_SEL_F32", "T_OP_SAD_S16", "T_OP_SAD_S32", "T_OP_SHRM", "T_OP_SHLM",
  "T_OP_SHRG", "T_OP_SHLG", "T_OP_ANDG", "T_OP_DP2ACC", "T_OP_DP4ACC",
  "T_OP_WMM", "T_OP_WMM_ACCU", "T_OP_RCP", "T_OP_RSQ", "T_OP_LOG2",
  "T_OP_EXP2", "T_OP_SIN", "T_OP_COS", "T_OP_SQRT", "T_OP_HRSQ",
  "T_OP_HLOG2", "T_OP_HEXP2", "T_OP_ISAM", "T_OP_ISAML", "T_OP_ISAMM",
  "T_OP_SAM", "T_OP_SAMB", "T_OP_SAML", "T_OP_SAMGQ", "T_OP_GETLOD",
  "T_OP_CONV", "T_OP_CONVM", "T_OP_GETSIZE", "T_OP_GETBUF", "T_OP_GETPOS",
  "T_OP_GETINFO", "T_OP_DSX", "T_OP_DSY", "T_OP_GATHER4R", "T_OP_GATHER4G",
  "T_OP_GATHER4B", "T_OP_GATHER4A", "T_OP_SAMGP0", "T_OP_SAMGP1",
  "T_OP_SAMGP2", "T_OP_SAMGP3", "T_OP_DSXPP_1", "T_OP_DSYPP_1",
  "T_OP_RGETPOS", "T_OP_RGETINFO", "T_OP_BRCST_A", "T_OP_QSHUFFLE_BRCST",
  "T_OP_QSHUFFLE_H", "T_OP_QSHUFFLE_V", "T_OP_QSHUFFLE_DIAG", "T_OP_LDG",
  "T_OP_LDG_A", "T_OP_LDL", "T_OP_LDP", "T_OP_STG", "T_OP_STG_A",
  "T_OP_STL", "T_OP_STP", "T_OP_LDIB", "T_OP_G2L", "T_OP_L2G",
  "T_OP_PREFETCH", "T_OP_LDLW", "T_OP_STLW", "T_OP_RESFMT", "T_OP_RESINFO",
  "T_OP_ATOMIC_ADD", "T_OP_ATOMIC_SUB", "T_OP_ATOMIC_XCHG",
  "T_OP_ATOMIC_INC", "T_OP_ATOMIC_DEC", "T_OP_ATOMIC_CMPXCHG",
  "T_OP_ATOMIC_MIN", "T_OP_ATOMIC_MAX", "T_OP_ATOMIC_AND",
  "T_OP_ATOMIC_OR", "T_OP_ATOMIC_XOR", "T_OP_RESINFO_B", "T_OP_LDIB_B",
  "T_OP_STIB_B", "T_OP_ATOMIC_B_ADD", "T_OP_ATOMIC_B_SUB",
  "T_OP_ATOMIC_B_XCHG", "T_OP_ATOMIC_B_INC", "T_OP_ATOMIC_B_DEC",
  "T_OP_ATOMIC_B_CMPXCHG", "T_OP_ATOMIC_B_MIN", "T_OP_ATOMIC_B_MAX",
  "T_OP_ATOMIC_B_AND", "T_OP_ATOMIC_B_OR", "T_OP_ATOMIC_B_XOR",
  "T_OP_ATOMIC_S_ADD", "T_OP_ATOMIC_S_SUB", "T_OP_ATOMIC_S_XCHG",
  "T_OP_ATOMIC_S_INC", "T_OP_ATOMIC_S_DEC", "T_OP_ATOMIC_S_CMPXCHG",
  "T_OP_ATOMIC_S_MIN", "T_OP_ATOMIC_S_MAX", "T_OP_ATOMIC_S_AND",
  "T_OP_ATOMIC_S_OR", "T_OP_ATOMIC_S_XOR", "T_OP_ATOMIC_G_ADD",
  "T_OP_ATOMIC_G_SUB", "T_OP_ATOMIC_G_XCHG", "T_OP_ATOMIC_G_INC",
  "T_OP_ATOMIC_G_DEC", "T_OP_ATOMIC_G_CMPXCHG", "T_OP_ATOMIC_G_MIN",
  "T_OP_ATOMIC_G_MAX", "T_OP_ATOMIC_G_AND", "T_OP_ATOMIC_G_OR",
  "T_OP_ATOMIC_G_XOR", "T_OP_LDGB", "T_OP_STGB", "T_OP_STIB", "T_OP_LDC",
  "T_OP_LDLV", "T_OP_GETSPID", "T_OP_GETWID", "T_OP_GETFIBERID",
  "T_OP_STC", "T_OP_BAR", "T_OP_FENCE", "T_TYPE_F16", "T_TYPE_F32",
  "T_TYPE_U16", "T_TYPE_U32", "T_TYPE_S16", "T_TYPE_S32", "T_TYPE_U8",
  "T_TYPE_S8", "T_UNTYPED", "T_TYPED", "T_MIXED", "T_UNSIGNED", "T_LOW",
  "T_HIGH", "T_1D", "T_2D", "T_3D", "T_4D", "T_LT", "T_LE", "T_GT", "T_GE",
  "T_EQ", "T_NE", "T_S2EN", "T_SAMP", "T_TEX", "T_BASE", "T_OFFSET",
  "T_UNIFORM", "T_NONUNIFORM", "T_IMM", "T_NAN", "T_INF", "T_A0", "T_A1",
  "T_P0", "T_W", "T_CAT1_TYPE_TYPE", "'-'", "','", "'('", "')'", "'='",
  "':'", "'!'", "'#'", "'.'", "'a'", "'o'", "'p'", "'s'", "'+'", "'<'",
  "'g'", "'['", "']'", "'l'", "'k'", "'c'", "'w'", "'r'", "'>'", "'h'",
  "$accept", "shader", "$@1", "headers", "header", "const_val",
  "localsize_header", "const_header", "buf_header_addr_reg", "buf_header",
  "$@2", "invocationid_header", "wgid_header", "numwg_header",
  "branchstack_header", "pvtmem_header", "earlypreamble_header",
  "in_header", "out_header", "tex_header", "iflag", "iflags", "instrs",
  "instr", "label", "cat0_src1", "cat0_src2", "cat0_immed", "cat0_instr",
  "$@3", "$@4", "$@5", "$@6", "$@7", "$@8", "$@9", "$@10", "$@11", "$@12",
  "$@13", "$@14", "$@15", "$@16", "$@17", "$@18", "cat1_opc", "cat1_src",
  "cat1_movmsk", "$@19", "cat1_mova1", "$@20", "cat1_mova", "$@21",
  "cat1_swz", "$@22", "cat1_gat", "$@23", "cat1_sct", "$@24", "cat1_instr",
  "cat2_opc_1src", "cat2_opc_2src_cnd", "cat2_opc_2src", "cond",
  "cat2_instr", "cat3_dp_signedness", "cat3_dp_pack", "cat3_opc",
  "cat3_imm_reg_opc", "cat3_wmm", "cat3_dp", "cat3_instr", "cat4_opc",
  "cat4_instr", "cat5_opc_dsxypp", "cat5_opc", "cat5_flag", "cat5_flags",
  "cat5_samp", "cat5_tex", "cat5_type", "cat5_a1", "cat5_instr",
  "cat6_typed", "cat6_dim", "cat6_type", "cat6_imm_offset", "cat6_offset",
  "cat6_dst_offset", "cat6_immed", "cat6_stg_ldg_a6xx_offset", "cat6_load",
  "$@25", "$@26", "$@27", "$@28", "$@29", "$@30", "$@31", "cat6_store",
  "$@32", "$@33", "$@34", "$@35", "$@36", "cat6_loadib", "$@37",
  "cat6_storeib", "$@38", "cat6_prefetch", "$@39", "cat6_atomic_opc",
  "cat6_a3xx_atomic_opc", "cat6_a6xx_atomic_opc", "cat6_a3xx_atomic_s",
  "cat6_a6xx_atomic_g", "cat6_atomic_l", "cat6_atomic",
  "cat6_ibo_opc_1src", "cat6_ibo_opc_ldgb", "cat6_ibo_opc_stgb",
  "cat6_ibo", "$@40", "cat6_id_opc", "cat6_id", "cat6_bindless_base",
  "cat6_bindless_mode", "cat6_reg_or_immed", "cat6_bindless_ibo_opc_1src",
  "cat6_bindless_ibo_opc_2src", "cat6_bindless_ibo_opc_2src_dst",
  "cat6_bindless_ibo", "cat6_bindless_ldc_opc", "cat6_bindless_ldc_middle",
  "cat6_bindless_ldc", "stc_dst", "cat6_stc", "$@41", "cat6_todo",
  "cat6_instr", "cat7_scope", "cat7_scopes", "cat7_barrier", "$@42",
  "$@43", "cat7_instr", "src", "dst", "const", "dst_reg_flag",
  "dst_reg_flags", "dst_reg", "src_reg_flag", "src_reg_flags", "src_reg",
  "src_reg_gpr", "src_const", "src_reg_or_const",
  "src_reg_or_const_or_rel", "src_reg_or_const_or_rel_or_imm",
  "src_reg_or_rel_or_imm", "offset", "relative_gpr_src",
  "relative_gpr_dst", "relative_const", "relative", "immediate_cat1",
  "immediate", "flut_immed", "integer", "float", "type", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-859)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-4)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -859,    49,   796,  -859,    47,  -233,    47,  -227,  -215,  -205,
      47,  -199,  -188,  -182,    47,  -859,   167,   796,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,   140,  -174,   173,  -859,   141,    17,   187,
    -859,   189,   192,   193,  -859,  -115,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,   855,  1089,   845,  -859,  -859,  -859,  -859,
      47,  -114,   -99,   -96,   -90,   -85,   -76,   -73,   -70,   -64,
    -859,  -859,  -859,  -859,  -859,  -859,  -102,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,   -66,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,   -60,   -56,   -46,   -53,   -51,   -50,   -47,
     -40,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,   100,  -859,  -859,  -859,  -859,  -859,  -859,  -859,   139,
     -37,   139,  -859,   139,   139,   139,   -36,  -859,   139,  -859,
     -21,   -21,  -859,  -859,  -859,  -859,  -859,  -859,   -18,   -18,
     -18,  -859,  -859,  -859,  -859,   -17,   -18,   -18,  -859,   -17,
    -859,   -18,   -18,   -18,  -859,   -16,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,    -8,    47,   307,  -859,  -859,  -859,  -859,
    -859,   310,   321,   323,  -248,  -248,  -248,    56,  -248,  -248,
       5,     5,     5,  -248,     5,    31,     5,     5,  -248,  -248,
      33,    27,    32,    42,    50,    52,    58,    59,   -17,   -17,
     -17,   -17,   -17,   -17,   -17,   -17,   -18,    24,   -17,   -17,
     -18,   -17,   -17,    55,    55,  -859,    18,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,    34,  -859,   481,    -1,    69,
      75,    85,   292,    89,    98,   101,   102,  -126,    64,   103,
     622,   -21,   139,    87,  -116,    93,    93,    93,   660,    93,
      93,    93,   139,    93,    93,    93,    80,    47,   107,   111,
     118,   125,   124,  -859,   142,   136,   137,   143,  -859,  -859,
     171,  -859,   144,   146,    88,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,   139,   139,   139,   139,   126,   127,   130,
     147,    93,   134,   139,   152,    93,   139,   132,  -110,    55,
    -859,  -859,   164,   165,  -859,  -859,    40,    40,   755,  -859,
    -859,  -859,  -859,  -859,  -859,   139,   755,    78,   797,   240,
    -859,  -859,  -113,   139,   755,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,   161,   660,   139,  -859,
    -859,   -24,   -17,   -17,   -17,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,   139,   -17,   -17,  -859,   -17,   -17,
     -17,   168,   174,   172,  -859,  -859,    47,  -859,   484,   489,
      56,  -859,     5,  -236,  -236,  -859,  -859,     5,     5,     5,
    -859,  -859,     5,   139,    40,    40,   139,   139,   139,   185,
     186,   195,   196,   184,   200,   202,   203,   -17,     8,   201,
     205,   -17,   208,   206,  -859,  -859,  -859,  -859,  -859,  -309,
    -309,  -859,  -859,  -859,  -859,  -859,  -859,   210,   216,  -859,
    -859,  -859,   113,   217,   218,   199,  -859,  -859,  -859,   277,
      30,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,    56,   592,   299,  -859,  -859,  -859,  -859,
    -859,   232,   239,   243,     8,  -859,   244,  -859,  -859,  -859,
     245,  -859,  -859,  -859,   248,  -859,   451,   238,   249,  -859,
    -859,  -859,  -859,   235,   246,   247,   250,   253,   255,   258,
     259,   270,    56,   233,    71,   278,   276,   283,   280,  -859,
    -859,   285,   288,   290,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,   291,   297,   301,   303,   309,   275,   289,     8,     8,
       8,     8,   295,  -273,   287,     8,   314,   308,    38,    56,
      56,   302,   304,   333,   338,  -859,   331,   334,    92,   336,
     342,   340,   346,   105,  -859,  -859,  -859,  -859,   352,    56,
    -859,  -859,   755,   755,   231,   231,   451,   797,  -859,  -859,
     261,    56,    56,    56,   341,    56,    56,    56,    56,    56,
     349,   350,   348,  -859,  -859,    47,    56,    56,   674,  -859,
       5,     5,   139,   451,   139,   354,   355,   356,   357,  -309,
     361,  -241,  -241,    56,    71,  -859,   358,  -859,   365,  -241,
      56,   370,   364,   371,  -859,  -859,  -859,  -859,  -859,  -309,
    -309,  -859,  -859,  -859,  -859,  -859,  -309,  -309,   387,   388,
    -859,   391,   396,  -859,   169,   397,   398,   401,   402,  -859,
    -859,   403,  -859,   405,   399,   400,   404,   393,   139,  -859,
     406,   408,   409,   -68,   -68,    71,   410,   423,   425,   426,
    -859,  -859,   428,   430,   431,     8,     8,     8,     8,   418,
     129,   419,    71,   420,  -859,   421,   139,  -859,   438,     8,
     433,   427,    56,    56,   442,   429,   432,   441,   443,  -859,
    -859,  -859,   755,    78,   797,   119,   231,   466,   261,   436,
     450,   452,    71,   455,   453,   -68,   -68,   -68,   476,   476,
     476,   139,   465,  -859,    47,  -859,  -859,    56,   451,   451,
     139,  -273,   361,  -273,  -273,   498,     8,   493,   509,  -859,
     522,   523,   524,    56,  -273,   525,   512,   513,  -859,   451,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,   528,  -859,
     530,  -859,   533,   139,   139,   139,   521,   527,   534,   139,
     451,   139,   551,  -859,  -859,  -859,  -859,   535,  -859,   539,
     542,   543,   545,   537,   546,   547,   550,     8,  -309,   538,
       8,     8,     8,   555,  -859,   561,     8,   119,  -859,   578,
     797,   273,   261,   589,   594,   595,  -859,   581,    71,   601,
     602,   603,  -859,   612,   921,   451,   451,   139,   610,   613,
     614,   615,   616,   627,    56,   617,   618,   634,   620,   636,
     637,   623,   638,    56,  -859,  -859,  -859,  -859,   641,  -859,
    -859,   625,   632,     8,    71,   635,    71,    71,    71,   639,
     647,  -859,   652,   653,   119,   119,   119,   119,   119,   643,
    -309,   119,   119,   119,   119,   119,   119,   654,   119,  -859,
     466,   642,   644,   658,   645,   662,  -859,   663,   664,  -859,
      56,   451,   451,  -859,  -859,  -859,  -859,  -859,   656,   657,
    -859,  -859,  -859,   649,  -859,  -859,     8,  -859,  -859,    71,
      71,     8,   666,     8,    71,    71,   671,  -859,  -859,    56,
     661,   673,   675,   665,   668,  -859,     8,   676,  -859,  -859,
     993,  -859,    56,     8,     8,   685,   686,   688,    71,   687,
    -859,   689,   692,     8,     8,     8,   693,    56,     8,     8,
    -859,   694,  -859,     8,   695,  -859,  -859,     8,  -859,  1010,
     698,   696,     8,    56,  -859,  -859
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     4,     1,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    34,    45,     4,     6,     7,
       8,     9,    10,    11,    12,    16,    17,    13,    14,    15,
      19,    21,    18,     0,     0,     0,    26,     0,     0,     0,
      32,     0,     0,     0,    33,     0,    38,    39,    40,    41,
      42,    43,    44,    45,     0,    45,    48,    57,     5,    20,
       0,     0,    25,     0,     0,     0,     0,     0,     0,     0,
      58,    46,    65,    66,    68,    70,     0,    74,    76,    78,
      80,    82,    84,    85,    87,    88,    89,    90,    91,    92,
      93,    95,    96,    97,    98,     0,    99,   101,   102,   104,
     105,   107,   109,     0,     0,     0,     0,     0,     0,     0,
       0,   156,   157,   158,   159,   140,   150,   136,   153,   141,
     142,   143,   144,   145,   160,   161,   162,   163,   151,   152,
     164,   165,   166,   167,   137,   168,   169,   146,   170,   154,
     155,   171,   172,   173,   147,   139,   138,   174,   175,   176,
     177,   178,   179,   180,   148,   149,   181,   182,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   219,
     220,   217,   218,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   236,   237,   262,
     263,   264,   265,   266,   267,   268,   315,   317,   321,   319,
     328,   330,   334,   332,   338,   427,   428,   342,   323,   336,
     429,   383,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   401,   414,   413,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,   412,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   384,
     385,   340,   418,   325,   390,   391,   392,   425,   448,   450,
      49,     0,   128,   129,   130,   131,   132,   133,    50,     0,
       0,     0,    51,     0,     0,     0,     0,    52,     0,    53,
     279,   279,    54,   430,   432,   431,   433,   434,     0,     0,
       0,   381,   382,   380,   435,     0,     0,     0,   436,     0,
     437,     0,     0,     0,   439,     0,   438,   440,   441,    55,
     452,    56,    47,     0,     0,     0,    27,    28,    29,    30,
      31,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   446,   446,   457,     0,   462,   463,   464,
     465,   466,   458,   459,   460,     0,   469,   467,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   279,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    60,     0,     0,     0,     0,   529,   531,
       0,    72,     0,     0,     0,    79,    81,    83,    86,    94,
     110,   100,   103,   106,   108,   116,   118,   120,   112,   113,
     122,   124,   126,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   446,
     449,   451,     0,     0,   468,   470,     0,     0,     0,   183,
     184,   185,   186,   187,   188,     0,     0,     0,     0,     0,
     192,   193,     0,     0,     0,   269,   274,   277,   275,   276,
     278,   270,   271,   272,   273,   280,     0,     0,     0,   300,
     301,     0,     0,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   306,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,   312,    22,     0,    24,     0,     0,
       0,    59,     0,     0,     0,   530,   532,     0,     0,     0,
      64,    63,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   445,   444,   442,   443,   447,   494,
     494,   453,   461,   471,   472,   473,   474,     0,     0,   454,
     455,   456,     0,     0,     0,     0,   134,   477,   481,   475,
       0,   483,   484,   485,   114,   503,   504,   486,   115,   505,
     135,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,   528,     0,     0,     0,   488,   189,   490,   514,
     512,     0,     0,     0,     0,   491,     0,   492,   493,   479,
       0,   480,   194,   195,     0,   235,     0,     0,   299,   302,
     303,   304,   305,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    67,
      62,     0,     0,     0,    73,    75,    77,   111,   117,   119,
     121,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   494,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   533,     0,     0,     0,     0,
       0,     0,     0,     0,   476,   478,   482,   487,     0,     0,
     516,   489,     0,     0,     0,     0,     0,     0,   285,   283,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   399,   400,     0,     0,     0,     0,    61,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   494,
       0,   494,   494,     0,     0,   308,     0,   307,     0,   494,
       0,     0,   423,     0,   422,   496,   495,   500,   499,   494,
     494,   510,   511,   534,   506,   507,   494,   494,     0,     0,
     513,     0,     0,   191,     0,     0,     0,     0,     0,   281,
     282,   297,   298,   295,     0,     0,     0,     0,     0,   388,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      69,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   310,     0,     0,   309,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   508,
     509,   515,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   394,   394,
     394,     0,     0,   421,     0,    35,    36,     0,     0,     0,
       0,   494,     0,   494,   494,     0,     0,     0,     0,   311,
       0,     0,     0,     0,   494,     0,     0,     0,   424,     0,
     498,   502,   501,   497,   190,   221,   222,   223,     0,   296,
     293,   294,   290,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   397,   398,   396,   419,     0,    23,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   494,     0,
       0,     0,     0,     0,   343,     0,     0,     0,   326,     0,
       0,     0,     0,     0,     0,     0,   386,     0,     0,     0,
       0,     0,   395,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   291,   292,   284,   288,   289,
     286,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     494,     0,     0,     0,     0,     0,     0,     0,     0,   426,
       0,     0,     0,     0,     0,     0,   415,     0,     0,   420,
       0,     0,     0,   316,   318,   322,   320,   329,     0,     0,
     331,   335,   333,     0,   324,   337,     0,   327,   287,     0,
       0,     0,     0,     0,     0,     0,     0,   125,   127,     0,
       0,     0,     0,     0,     0,   378,     0,     0,   416,   417,
       0,   313,     0,     0,     0,     0,     0,     0,     0,     0,
     314,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     379,     0,   387,     0,     0,   339,   341,     0,   389,     0,
       0,     0,     0,     0,   377,    37
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -859,  -859,  -859,  1002,  -859,    -6,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,   967,  -859,   966,  -859,   332,   448,  -345,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -450,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -311,  -858,  -776,
    -859,  -859,  -859,   156,   242,   485,   234,  -731,  -666,   -97,
     112,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -713,  -827,  -161,  -859,  -859,
    -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,  -859,
    -859,  -393,  -859,  -859,  -859,  -859,  -117,   607,  -602,  -859,
     609,  -295,  -859,  -435,  -479,  -859,  -859,  -721,  -471,  -503,
    -745,  -607,   511,  -859,  -859,  -511,  -859,  -513,   377,  -366,
     293,   495
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,    16,    17,    34,    18,    19,   356,    20,
      62,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      53,    54,    55,    56,    57,   455,   702,   465,   300,   364,
     365,   366,   577,   368,   369,   370,   371,   372,   373,   374,
     376,   377,   378,   379,   582,   301,   626,   302,   583,   303,
     584,   304,   585,   305,   586,   306,   587,   307,   588,   308,
     309,   310,   311,   515,   312,   428,   523,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   431,   432,   831,   832,
     538,  1016,   322,   435,   542,   439,   795,   796,   863,   562,
     861,   323,   388,   389,   391,   390,   398,   401,  1012,   324,
     392,   393,   395,   394,   399,   325,   396,   326,   400,   327,
     397,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   894,   339,   340,   953,   901,   772,   341,   342,
     343,   344,   345,   563,   346,   803,   347,   402,   348,   349,
     499,   500,   350,   403,   404,   351,   627,   416,   628,   417,
     418,   419,   629,   664,   631,   670,   632,   633,   656,   657,
     666,   797,   635,   420,   636,   637,   638,   658,   659,   660,
     740,   553
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      36,   461,   731,   732,    40,   668,   405,   667,    44,   729,
     433,   501,   828,   662,   421,   611,   423,   902,   424,   425,
     426,   675,   730,   429,    64,    65,   466,   467,   746,   469,
     940,   471,   472,   825,   826,   634,   634,   611,   612,   665,
     669,   458,   459,   458,   459,   729,   663,   611,   612,     3,
      30,    31,    32,   746,   353,   617,   618,   640,   794,   458,
     459,   613,   614,   615,   616,   617,   618,   453,   949,   950,
     951,   630,   630,   655,   458,   459,   454,   729,   611,   700,
     564,   655,   630,   458,   459,   611,   612,    35,   701,   655,
     862,   458,   459,    37,   580,   575,   576,   813,   581,   613,
     614,   615,   616,   617,   618,    38,   608,   405,   458,   459,
     735,   939,   941,   634,   634,    39,   458,   459,   735,   747,
     535,    41,   458,   459,  1018,   406,   865,   407,   408,   409,
     410,   411,    42,   870,   709,   710,   611,   536,    43,   936,
     639,   639,   751,    59,   747,    60,   405,   557,    63,   630,
     630,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   520,   521,   938,   407,   408,   409,   410,
     411,   539,   540,    45,   575,   576,   611,   612,   672,   673,
     963,    61,   965,   966,   864,   864,   954,   955,   589,   590,
     591,   592,   864,   975,   744,    66,    67,   758,   599,    68,
      69,   602,   875,   876,   698,  1015,  1019,   354,    70,   877,
     878,    46,    47,    48,    49,    50,    51,    52,   639,   639,
     661,   355,   746,   604,   367,   357,   605,   699,   674,   606,
     607,   358,   704,   705,   706,  1014,   359,   707,   611,   612,
     898,   899,   900,   678,   668,   360,   667,   611,   361,   822,
     823,   362,   613,   614,   615,   616,   739,   363,   381,   686,
     375,   613,   614,   615,   616,   617,   380,   382,   611,   679,
     680,   681,   682,   383,  1078,   384,   385,   827,   665,   386,
     611,   833,   613,   614,   615,   616,   387,   748,   708,   422,
     427,   711,   712,   713,   613,   614,   615,   616,   613,   614,
     615,   616,   458,   459,   853,   430,   611,   612,   434,   438,
     446,   447,   412,   413,   414,   449,   450,   655,   655,   824,
     824,   619,   620,   621,   617,   618,   564,   451,   774,   452,
     464,   641,   642,   643,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   619,   620,   621,   476,   470,   448,   475,
     502,   477,   802,   619,   620,   621,   460,   492,   460,   478,
     622,  1003,   804,   805,   806,    33,   503,   479,   623,   480,
     624,   668,   937,   667,   460,   481,   482,   818,   623,   934,
     624,   498,   625,   821,   619,   620,   621,   561,   506,   460,
     522,   619,   620,   621,   507,   564,   564,   564,   460,   564,
     564,   564,   564,   564,   508,   665,   460,   537,   516,   942,
     847,   848,   935,   412,   413,   414,   623,   517,   624,   541,
     518,   519,   524,   738,   736,   737,   566,   564,   806,   960,
     961,   738,   567,  1069,   564,   850,   851,   460,   568,   653,
     415,   565,   619,   620,   621,   569,   570,   655,   630,   916,
     979,   824,   412,   413,   414,   572,   573,   571,   611,   593,
     594,   654,   574,   578,  1011,   579,   595,   668,   598,   667,
     603,   990,   613,   614,   615,   616,   596,   609,   610,   774,
     676,   723,   619,   620,   621,   436,   437,   852,   600,   854,
     696,   694,   440,   441,   692,   697,   806,   443,   444,   445,
     693,   665,  1017,  1020,   714,   715,   927,   928,   407,   408,
     409,   410,   411,   745,   716,   717,  1031,  1032,   718,   743,
     724,  1063,  1064,  1065,  1066,  1067,   774,   727,  1070,  1071,
    1072,  1073,  1074,  1075,   719,  1077,   720,   721,   745,   725,
     728,   959,   733,   893,   619,   620,   621,   745,   734,   741,
     742,   752,   491,   619,   620,   621,   495,   564,   753,   759,
     695,   761,   754,   755,   756,   829,   830,   757,   760,   764,
     771,   922,   762,   763,   619,   620,   621,   773,   830,   765,
     624,   766,  1087,  1088,   767,   768,   619,   620,   621,   509,
     510,   511,   512,   513,   514,   770,   769,   775,   776,   778,
     779,   789,   790,   791,   792,   777,   956,   780,   799,   781,
     782,   787,   619,   620,   621,   962,   783,   460,   788,   653,
     784,   793,   774,   798,   641,   642,   643,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   785,   623,  1040,   624,
     800,   654,   786,   807,   801,   808,   809,   564,   983,   984,
     985,   810,   811,   816,   989,   812,   991,   814,   774,   817,
     774,   774,   774,   815,   834,   835,   836,   845,   838,   839,
     840,   841,   842,   820,   837,   843,   844,   867,   543,   544,
     849,   554,   555,   556,   903,   558,   559,   560,   855,   856,
     857,   858,   860,   868,  1086,   873,   866,   456,   457,   869,
     462,   463,  1033,   871,   872,   468,   874,   745,   879,   880,
     473,   474,   881,   774,   774,   882,   883,   884,   774,   774,
     885,   886,   887,  1101,   888,   889,   890,   892,   773,   904,
     891,   946,   895,   597,   896,   897,  1110,   601,   911,   912,
     913,   914,   774,   917,   905,   919,   906,   908,   907,   909,
     910,  1124,   924,   915,   918,   920,   921,   923,   458,   459,
     926,   929,   611,   612,   619,   620,   621,  1135,   925,   846,
     930,   830,   943,   931,   947,   773,   613,   614,   615,   616,
     617,   618,   932,   944,   933,   945,   948,   641,   642,   643,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   968,
     458,   459,   952,   957,   611,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,   967,   613,   614,
     615,   616,   617,   618,   442,   969,   974,  1025,   970,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   971,   972,   973,   976,    -3,   977,   980,   978,   981,
    1002,    45,   982,  1005,  1006,  1007,   986,   992,   994,  1010,
     987,   995,   996,  1054,   997,  1056,  1057,  1058,   988,   993,
    1004,   773,   998,   483,   484,   485,   486,   487,   488,   489,
     490,   999,  1000,   493,   494,  1001,   496,   497,  1008,    46,
      47,    48,    49,    50,    51,    52,  1009,  1013,   958,    46,
      47,    48,    49,    50,    51,    52,  1053,   773,  1021,   773,
     773,   773,   749,  1022,  1023,  1024,  1049,   525,  1093,  1094,
    1026,  1027,  1028,  1098,  1099,   526,  1029,  1030,   527,  1034,
     528,   529,  1035,  1036,  1037,  1038,  1041,  1042,   530,   545,
     546,   547,   548,   549,   550,   551,   552,  1116,  1039,   531,
     532,   533,   534,  1043,  1044,  1045,  1046,  1048,  1047,  1092,
    1050,  1051,   773,   773,  1095,  1052,  1097,   773,   773,  1060,
    1055,  1061,  1062,  1076,  1059,  1068,  1079,  1081,  1080,  1107,
    1082,  1083,  1084,  1085,  1091,  1096,  1111,  1112,  1089,  1090,
    1100,   773,  1103,  1102,  1104,  1108,  1120,  1121,  1122,  1109,
    1105,  1125,  1126,  1106,  1113,  1114,  1128,  1115,  1118,  1117,
    1130,  1119,  1123,  1127,  1129,  1134,  1131,  1132,  1133,    58,
      71,   352,   703,   859,   964,   505,   504,   683,   684,   685,
     671,   750,   677,     0,     0,     0,   819,     0,     0,     0,
     687,   688,     0,   689,   690,   691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   619,   620,
     621,     0,     0,   460,     0,   653,     0,     0,     0,     0,
       0,     0,   722,     0,     0,     0,   726,     0,     0,     0,
       0,     0,     0,   623,     0,   624,     0,   654,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     619,   620,   621,     0,     0,   460,     0,   653,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   623,     0,   624,     0,   654,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299
};

static const yytype_int16 yycheck[] =
{
       6,   367,   609,   610,    10,   518,     7,   518,    14,   318,
     321,   404,   757,   516,   309,     7,   311,   844,   313,   314,
     315,   524,   331,   318,     7,     8,   371,   372,   630,   374,
     888,   376,   377,   754,   755,   506,   507,     7,     8,   518,
     519,     3,     4,     3,     4,   318,   517,     7,     8,     0,
       3,     4,     5,   655,    60,    25,    26,   507,   331,     3,
       4,    21,    22,    23,    24,    25,    26,   315,   895,   896,
     897,   506,   507,   508,     3,     4,   324,   318,     7,   315,
     446,   516,   517,     3,     4,     7,     8,   320,   324,   524,
     331,     3,     4,   320,     6,     3,     4,     5,   464,    21,
      22,    23,    24,    25,    26,   320,   499,     7,     3,     4,
       5,   887,   888,   584,   585,   320,     3,     4,     5,   630,
     431,   320,     3,     4,   982,    25,   792,    27,    28,    29,
      30,    31,   320,   799,   584,   585,     7,   432,   320,   884,
     506,   507,   655,     3,   655,   319,     7,   442,     7,   584,
     585,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,   289,   290,   886,    27,    28,    29,    30,
      31,   287,   288,     6,     3,     4,     7,     8,   291,   292,
     911,     8,   913,   914,   791,   792,   899,   900,   483,   484,
     485,   486,   799,   924,   629,     8,     7,   676,   493,     7,
       7,   496,   809,   810,   570,   981,   982,   321,   323,   816,
     817,    44,    45,    46,    47,    48,    49,    50,   584,   585,
     515,   320,   824,   333,   326,   321,   336,   572,   523,   339,
     340,   321,   577,   578,   579,   980,   321,   582,     7,     8,
     308,   309,   310,   538,   757,   321,   757,     7,   321,   752,
     753,   321,    21,    22,    23,    24,   622,   321,   314,   554,
     326,    21,    22,    23,    24,    25,   326,   313,     7,   293,
     294,   295,   296,   326,  1050,   326,   326,   756,   757,   326,
       7,   760,    21,    22,    23,    24,   326,   653,   583,   326,
     326,   586,   587,   588,    21,    22,    23,    24,    21,    22,
      23,    24,     3,     4,   783,   326,     7,     8,   326,   326,
     326,   319,   313,   314,   315,     8,     6,   752,   753,   754,
     755,   313,   314,   315,    25,    26,   692,     6,   694,     6,
     325,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,   313,   314,   315,   319,   316,   354,   316,
     332,   319,   314,   313,   314,   315,   318,   333,   318,   317,
     320,   968,   728,   729,   730,   318,   332,   317,   338,   317,
     340,   884,   885,   884,   318,   317,   317,   743,   338,   882,
     340,   326,   342,   749,   313,   314,   315,   307,   319,   318,
     326,   313,   314,   315,   319,   761,   762,   763,   318,   765,
     766,   767,   768,   769,   319,   884,   318,   320,   319,   888,
     776,   777,   883,   313,   314,   315,   338,   319,   340,   326,
     319,   319,   319,   318,   311,   312,   319,   793,   794,   908,
     909,   318,   321,  1040,   800,   780,   781,   318,   320,   320,
     340,   447,   313,   314,   315,   320,   322,   882,   883,   320,
     929,   886,   313,   314,   315,   319,   319,   315,     7,   333,
     333,   342,   319,   319,   977,   319,   336,   980,   334,   980,
     338,   950,    21,    22,    23,    24,   329,   313,   313,   845,
     319,   598,   313,   314,   315,   329,   330,   782,   336,   784,
       6,   319,   336,   337,   326,     6,   862,   341,   342,   343,
     326,   980,   981,   982,   319,   319,   872,   873,    27,    28,
      29,    30,    31,   630,   319,   319,   995,   996,   334,   320,
     319,  1034,  1035,  1036,  1037,  1038,   892,   319,  1041,  1042,
    1043,  1044,  1045,  1046,   334,  1048,   334,   334,   655,   334,
     334,   907,   332,   838,   313,   314,   315,   664,   332,   332,
     332,   319,   396,   313,   314,   315,   400,   923,   319,   321,
     566,   326,   319,   319,   319,   304,   305,   319,   319,   319,
     337,   866,   326,   326,   313,   314,   315,   694,   305,   326,
     340,   326,  1061,  1062,   326,   326,   313,   314,   315,   297,
     298,   299,   300,   301,   302,   692,   326,   319,   322,   319,
     315,   718,   719,   720,   721,   322,   901,   319,   725,   319,
     319,   336,   313,   314,   315,   910,   319,   318,   329,   320,
     319,   326,   988,   336,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,   333,   338,  1004,   340,
     326,   342,   333,   341,   336,   341,   313,  1013,   943,   944,
     945,   313,   321,   313,   949,   321,   951,   321,  1024,   313,
    1026,  1027,  1028,   321,   761,   762,   763,   319,   765,   766,
     767,   768,   769,   321,   333,   326,   326,   794,   436,   437,
       6,   439,   440,   441,   845,   443,   444,   445,   334,   334,
     334,   334,   331,   335,  1060,   331,   793,   365,   366,   334,
     368,   369,   997,   800,   334,   373,   335,   824,   321,   321,
     378,   379,   321,  1079,  1080,   319,   319,   319,  1084,  1085,
     319,   319,   319,  1089,   319,   326,   326,   334,   845,   319,
     326,   892,   326,   491,   326,   326,  1102,   495,   855,   856,
     857,   858,  1108,   860,   321,   862,   321,   319,   322,   319,
     319,  1117,   869,   335,   335,   335,   335,   319,     3,     4,
     333,   319,     7,     8,   313,   314,   315,  1133,   335,   775,
     341,   305,   336,   341,   319,   892,    21,    22,    23,    24,
      25,    26,   341,   333,   341,   333,   333,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,   916,
       3,     4,   326,   338,     7,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,   319,    21,    22,
      23,    24,    25,    26,   339,   332,   923,   988,   319,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,   319,   319,   319,   319,     0,   334,   319,   335,   319,
     967,     6,   319,   970,   971,   972,   335,   306,   319,   976,
     333,   319,   319,  1024,   319,  1026,  1027,  1028,   334,   334,
     332,   988,   335,   388,   389,   390,   391,   392,   393,   394,
     395,   335,   335,   398,   399,   335,   401,   402,   333,    44,
      45,    46,    47,    48,    49,    50,   335,   319,   904,    44,
      45,    46,    47,    48,    49,    50,  1023,  1024,   319,  1026,
    1027,  1028,   320,   319,   319,   334,  1013,   295,  1079,  1080,
     319,   319,   319,  1084,  1085,   303,   314,     6,   306,   319,
     308,   309,   319,   319,   319,   319,   319,   319,   316,   279,
     280,   281,   282,   283,   284,   285,   286,  1108,   321,   327,
     328,   329,   330,   319,   334,   319,   319,   319,   335,  1076,
     319,   336,  1079,  1080,  1081,   333,  1083,  1084,  1085,   322,
     335,   319,   319,   319,   335,   332,   334,   319,   334,  1096,
     335,   319,   319,   319,   335,   319,  1103,  1104,   332,   332,
     319,  1108,   319,   332,   319,   319,  1113,  1114,  1115,     6,
     335,  1118,  1119,   335,   319,   319,  1123,   319,   319,   322,
    1127,   319,   319,   319,   319,  1132,     6,   319,   322,    17,
      53,    55,   574,   789,   912,   418,   417,   542,   543,   544,
     519,   654,   537,    -1,    -1,    -1,   743,    -1,    -1,    -1,
     555,   556,    -1,   558,   559,   560,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   313,   314,
     315,    -1,    -1,   318,    -1,   320,    -1,    -1,    -1,    -1,
      -1,    -1,   597,    -1,    -1,    -1,   601,    -1,    -1,    -1,
      -1,    -1,    -1,   338,    -1,   340,    -1,   342,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     313,   314,   315,    -1,    -1,   318,    -1,   320,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   338,    -1,   340,    -1,   342,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   344,   345,     0,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,   346,   347,   349,   350,
     352,   354,   355,   356,   357,   358,   359,   360,   361,   362,
       3,     4,     5,   318,   348,   320,   348,   320,   320,   320,
     348,   320,   320,   320,   348,     6,    44,    45,    46,    47,
      48,    49,    50,   363,   364,   365,   366,   367,   346,     3,
     319,     8,   353,     7,     7,     8,     8,     7,     7,     7,
     323,   364,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     371,   388,   390,   392,   394,   396,   398,   400,   402,   403,
     404,   405,   407,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   425,   434,   442,   448,   450,   452,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,   466,
     467,   471,   472,   473,   474,   475,   477,   479,   481,   482,
     485,   488,   366,   348,   321,   320,   351,   321,   321,   321,
     321,   321,   321,   321,   372,   373,   374,   326,   376,   377,
     378,   379,   380,   381,   382,   326,   383,   384,   385,   386,
     326,   314,   313,   326,   326,   326,   326,   326,   435,   436,
     438,   437,   443,   444,   446,   445,   449,   453,   439,   447,
     451,   440,   480,   486,   487,     7,    25,    27,    28,    29,
      30,    31,   313,   314,   315,   340,   490,   492,   493,   494,
     506,   494,   326,   494,   494,   494,   494,   326,   408,   494,
     326,   419,   420,   420,   326,   426,   426,   426,   326,   428,
     426,   426,   428,   426,   426,   426,   326,   319,   348,     8,
       6,     6,     6,   315,   324,   368,   368,   368,     3,     4,
     318,   512,   368,   368,   325,   370,   370,   370,   368,   370,
     316,   370,   370,   368,   368,   316,   319,   319,   317,   317,
     317,   317,   317,   428,   428,   428,   428,   428,   428,   428,
     428,   426,   333,   428,   428,   426,   428,   428,   326,   483,
     484,   484,   332,   332,   493,   490,   319,   319,   319,   297,
     298,   299,   300,   301,   302,   406,   319,   319,   319,   319,
     289,   290,   326,   409,   319,   295,   303,   306,   308,   309,
     316,   327,   328,   329,   330,   420,   494,   320,   423,   287,
     288,   326,   427,   427,   427,   279,   280,   281,   282,   283,
     284,   285,   286,   514,   427,   427,   427,   494,   427,   427,
     427,   307,   432,   476,   512,   348,   319,   321,   320,   320,
     322,   315,   319,   319,   319,     3,     4,   375,   319,   319,
       6,   512,   387,   391,   393,   395,   397,   399,   401,   494,
     494,   494,   494,   333,   333,   336,   329,   427,   334,   494,
     336,   427,   494,   338,   333,   336,   339,   340,   484,   313,
     313,     7,     8,    21,    22,    23,    24,    25,    26,   313,
     314,   315,   320,   338,   340,   342,   389,   489,   491,   495,
     496,   497,   499,   500,   501,   505,   507,   508,   509,   512,
     389,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,   320,   342,   496,   501,   502,   510,   511,
     512,   494,   502,   501,   496,   497,   503,   508,   510,   497,
     498,   505,   291,   292,   494,   502,   319,   514,   494,   293,
     294,   295,   296,   428,   428,   428,   494,   428,   428,   428,
     428,   428,   326,   326,   319,   348,     6,     6,   512,   370,
     315,   324,   369,   369,   370,   370,   370,   370,   494,   389,
     389,   494,   494,   494,   319,   319,   319,   319,   334,   334,
     334,   334,   428,   489,   319,   334,   428,   319,   334,   318,
     331,   504,   504,   332,   332,     5,   311,   312,   318,   512,
     513,   332,   332,   320,   496,   489,   491,   508,   512,   320,
     511,   510,   319,   319,   319,   319,   319,   319,   497,   321,
     319,   326,   326,   326,   319,   326,   326,   326,   326,   326,
     432,   337,   470,   489,   512,   319,   322,   322,   319,   315,
     319,   319,   319,   319,   319,   333,   333,   336,   329,   489,
     489,   489,   489,   326,   331,   429,   430,   504,   336,   489,
     326,   336,   314,   478,   512,   512,   512,   341,   341,   313,
     313,   321,   321,     5,   321,   321,   313,   313,   512,   513,
     321,   512,   502,   502,   496,   500,   500,   497,   503,   304,
     305,   421,   422,   497,   432,   432,   432,   333,   432,   432,
     432,   432,   432,   326,   326,   319,   348,   512,   512,     6,
     370,   370,   494,   497,   494,   334,   334,   334,   334,   429,
     331,   433,   331,   431,   504,   431,   432,   489,   335,   334,
     431,   432,   334,   331,   335,   504,   504,   504,   504,   321,
     321,   321,   319,   319,   319,   319,   319,   319,   319,   326,
     326,   326,   334,   494,   465,   326,   326,   326,   308,   309,
     310,   469,   469,   470,   319,   321,   321,   322,   319,   319,
     319,   489,   489,   489,   489,   335,   320,   489,   335,   489,
     335,   335,   494,   319,   489,   335,   333,   512,   512,   319,
     341,   341,   341,   341,   502,   501,   503,   510,   500,   422,
     421,   422,   497,   336,   333,   333,   470,   319,   333,   469,
     469,   469,   326,   468,   468,   468,   494,   338,   348,   512,
     497,   497,   494,   430,   433,   430,   430,   319,   489,   332,
     319,   319,   319,   319,   432,   430,   319,   334,   335,   497,
     319,   319,   319,   494,   494,   494,   335,   333,   334,   494,
     497,   494,   306,   334,   319,   319,   319,   319,   335,   335,
     335,   335,   489,   504,   332,   489,   489,   489,   333,   335,
     489,   510,   441,   319,   503,   422,   424,   497,   421,   422,
     497,   319,   319,   319,   334,   470,   319,   319,   319,   314,
       6,   497,   497,   494,   319,   319,   319,   319,   319,   321,
     512,   319,   319,   319,   334,   319,   319,   335,   319,   432,
     319,   336,   333,   489,   470,   335,   470,   470,   470,   335,
     322,   319,   319,   510,   510,   510,   510,   510,   332,   504,
     510,   510,   510,   510,   510,   510,   319,   510,   422,   334,
     334,   319,   335,   319,   319,   319,   512,   497,   497,   332,
     332,   335,   489,   470,   470,   489,   319,   489,   470,   470,
     319,   512,   332,   319,   319,   335,   335,   489,   319,     6,
     512,   489,   489,   319,   319,   319,   470,   322,   319,   319,
     489,   489,   489,   319,   512,   489,   489,   319,   489,   319,
     489,     6,   319,   322,   489,   512
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   343,   345,   344,   346,   346,   347,   347,   347,   347,
     347,   347,   347,   347,   347,   347,   347,   347,   348,   348,
     348,   348,   349,   350,   351,   351,   353,   352,   354,   355,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   363,
     363,   363,   363,   363,   363,   364,   364,   365,   365,   366,
     366,   366,   366,   366,   366,   366,   366,   366,   367,   368,
     368,   369,   369,   370,   370,   371,   372,   371,   373,   371,
     374,   371,   375,   371,   376,   371,   377,   371,   378,   371,
     379,   371,   380,   371,   371,   381,   371,   371,   371,   371,
     371,   371,   371,   382,   371,   371,   371,   371,   371,   383,
     371,   371,   384,   371,   371,   385,   371,   386,   371,   371,
     387,   371,   388,   388,   389,   389,   391,   390,   393,   392,
     395,   394,   397,   396,   399,   398,   401,   400,   402,   402,
     402,   402,   402,   402,   402,   402,   403,   403,   403,   403,
     403,   403,   403,   403,   403,   403,   403,   403,   403,   403,
     404,   404,   404,   404,   404,   404,   405,   405,   405,   405,
     405,   405,   405,   405,   405,   405,   405,   405,   405,   405,
     405,   405,   405,   405,   405,   405,   405,   405,   405,   405,
     405,   405,   405,   406,   406,   406,   406,   406,   406,   407,
     407,   407,   408,   408,   409,   409,   410,   410,   410,   410,
     410,   410,   410,   410,   410,   410,   410,   410,   410,   410,
     410,   410,   411,   411,   411,   411,   411,   412,   412,   413,
     413,   414,   414,   414,   414,   415,   415,   415,   415,   415,
     415,   415,   415,   415,   415,   416,   417,   417,   418,   418,
     418,   418,   418,   418,   418,   418,   418,   418,   418,   418,
     418,   418,   418,   418,   418,   418,   418,   418,   418,   418,
     418,   418,   418,   418,   418,   418,   418,   418,   418,   419,
     419,   419,   419,   419,   419,   419,   419,   419,   419,   420,
     420,   421,   422,   423,   424,   425,   425,   425,   425,   425,
     425,   425,   425,   425,   425,   425,   425,   425,   425,   425,
     426,   426,   427,   427,   427,   427,   428,   429,   430,   430,
     431,   431,   432,   433,   433,   435,   434,   436,   434,   437,
     434,   438,   434,   439,   434,   440,   441,   434,   443,   442,
     444,   442,   445,   442,   446,   442,   447,   442,   449,   448,
     451,   450,   453,   452,   454,   454,   454,   454,   454,   454,
     454,   454,   454,   454,   454,   455,   455,   455,   455,   455,
     455,   455,   455,   455,   455,   455,   456,   456,   456,   456,
     456,   456,   456,   456,   456,   456,   456,   457,   458,   459,
     460,   460,   460,   461,   462,   463,   464,   464,   465,   464,
     466,   466,   466,   467,   468,   468,   469,   469,   469,   470,
     470,   471,   472,   472,   472,   472,   472,   472,   472,   472,
     472,   472,   472,   472,   473,   474,   474,   474,   475,   476,
     476,   477,   478,   478,   478,   480,   479,   481,   481,   481,
     482,   482,   482,   482,   482,   482,   482,   482,   482,   482,
     482,   482,   483,   483,   483,   483,   484,   484,   486,   485,
     487,   485,   488,   489,   489,   489,   489,   490,   490,   490,
     490,   491,   492,   492,   492,   492,   492,   493,   493,   494,
     494,   495,   495,   495,   495,   496,   496,   497,   497,   498,
     498,   499,   499,   500,   500,   501,   501,   501,   502,   502,
     502,   503,   503,   503,   504,   504,   504,   505,   505,   506,
     506,   507,   507,   508,   508,   509,   509,   509,   509,   509,
     509,   509,   510,   510,   510,   510,   510,   511,   511,   511,
     511,   511,   511,   511,   511,   511,   511,   511,   511,   512,
     512,   512,   512,   513,   513,   514,   514,   514,   514,   514,
     514,   514,   514
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     3,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     6,    11,     3,     0,     0,     4,     4,     4,
       4,     4,     2,     2,     1,    10,    10,    23,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     2,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     2,
       1,     2,     1,     2,     2,     1,     0,     5,     0,     7,
       0,     7,     0,     5,     0,     5,     0,     5,     0,     3,
       0,     3,     0,     3,     1,     0,     3,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     1,     1,     1,     0,
       3,     1,     0,     3,     1,     0,     3,     0,     3,     1,
       0,     5,     3,     3,     1,     1,     0,     5,     0,     5,
       0,     5,     0,    11,     0,    13,     0,    13,     1,     1,
       1,     1,     1,     1,     4,     4,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       8,     6,     2,     2,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     8,     8,     8,    10,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     0,
       2,     1,     1,     3,     1,     5,    10,    12,    10,    10,
       8,    10,    10,     8,     8,     6,     8,     6,     6,     4,
       2,     2,     2,     2,     2,     2,     2,     1,     1,     2,
       1,     2,     1,     8,     9,     0,    12,     0,    12,     0,
      12,     0,    12,     0,    12,     0,     0,    12,     0,    12,
       0,    12,     0,    12,     0,    12,     0,    12,     0,    17,
       0,    17,     0,     9,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,    20,    13,    16,
       1,     1,     1,     1,     1,     1,     9,    16,     0,    17,
       1,     1,     1,     3,     0,     2,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,    11,    13,    13,     1,     6,
       9,     7,     1,     1,     3,     0,    11,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     0,     2,     0,     3,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       2,     1,     1,     1,     1,     1,     2,     1,     2,     1,
       1,     1,     2,     1,     1,     1,     1,     2,     1,     2,
       1,     1,     1,     1,     0,     2,     2,     5,     5,     5,
       5,     5,     5,     1,     1,     1,     3,     3,     4,     4,
       3,     3,     1,     3,     1,     4,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 689 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                   { new_shader(); }
#line 3054 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 18: /* const_val: T_FLOAT  */
#line 707 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = fui((yyvsp[0].flt)); }
#line 3060 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 19: /* const_val: T_INT  */
#line 708 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = (yyvsp[0].num);      }
#line 3066 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 20: /* const_val: '-' T_INT  */
#line 709 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = -(yyvsp[0].num);     }
#line 3072 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 21: /* const_val: T_HEX  */
#line 710 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { (yyval.unum) = (yyvsp[0].unum);      }
#line 3078 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 22: /* localsize_header: T_A_LOCALSIZE const_val ',' const_val ',' const_val  */
#line 712 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                       {
                       variant->local_size[0] = (yyvsp[-4].unum);
                       variant->local_size[1] = (yyvsp[-2].unum);
                       variant->local_size[2] = (yyvsp[0].unum);
}
#line 3088 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 23: /* const_header: T_A_CONST '(' T_CONSTANT ')' const_val ',' const_val ',' const_val ',' const_val  */
#line 718 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                                    {
                       add_const((yyvsp[-8].num), (yyvsp[-6].unum), (yyvsp[-4].unum), (yyvsp[-2].unum), (yyvsp[0].unum));
}
#line 3096 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 24: /* buf_header_addr_reg: '(' T_CONSTANT ')'  */
#line 723 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                      {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;

                       info->buf_addr_regs[info->num_bufs - 1] = reg;
                       /* reserve space in immediates for the actual value to be plugged in later: */
                       add_const((yyvsp[-1].num), 0, 0, 0, 0);
}
#line 3109 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 26: /* $@2: %empty  */
#line 733 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                     {
                       int idx = info->num_bufs++;
                       assert(idx < MAX_BUFS);
                       info->buf_sizes[idx] = (yyvsp[0].unum);
}
#line 3119 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 28: /* invocationid_header: T_A_INVOCATIONID '(' T_REGISTER ')'  */
#line 739 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                         {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       add_sysval(reg, 0x7, SYSTEM_VALUE_LOCAL_INVOCATION_ID);
}
#line 3129 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 29: /* wgid_header: T_A_WGID '(' T_REGISTER ')'  */
#line 745 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                               {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       assert(variant->compiler->gen >= 5);
                       assert(reg >= regid(48, 0)); /* must be a high reg */
                       add_sysval(reg, 0x7, SYSTEM_VALUE_WORKGROUP_ID);
}
#line 3141 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 30: /* wgid_header: T_A_WGID '(' T_CONSTANT ')'  */
#line 752 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                               {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       assert(variant->compiler->gen < 5);
                       info->wgid = reg;
}
#line 3152 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 31: /* numwg_header: T_A_NUMWG '(' T_CONSTANT ')'  */
#line 759 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                {
                       assert(((yyvsp[-1].num) & 0x1) == 0);  /* half-reg not allowed */
                       unsigned reg = (yyvsp[-1].num) >> 1;
                       info->numwg = reg;
                       /* reserve space in immediates for the actual value to be plugged in later: */
                       if (variant->compiler->gen >= 5)
                          add_const((yyvsp[-1].num), 0, 0, 0, 0);
}
#line 3165 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 32: /* branchstack_header: T_A_BRANCHSTACK const_val  */
#line 768 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { variant->branchstack = (yyvsp[0].unum); }
#line 3171 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 33: /* pvtmem_header: T_A_PVTMEM const_val  */
#line 770 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                    { variant->pvtmem_size = (yyvsp[0].unum); }
#line 3177 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 34: /* earlypreamble_header: T_A_EARLYPREAMBLE  */
#line 772 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                        { info->early_preamble = 1; }
#line 3183 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 35: /* in_header: T_A_IN '(' T_REGISTER ')' T_IDENTIFIER '(' T_IDENTIFIER '=' integer ')'  */
#line 775 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                           { }
#line 3189 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 36: /* out_header: T_A_OUT '(' T_REGISTER ')' T_IDENTIFIER '(' T_IDENTIFIER '=' integer ')'  */
#line 777 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                            { }
#line 3195 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 37: /* tex_header: T_A_TEX '(' T_REGISTER ')' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer ',' T_IDENTIFIER '=' integer  */
#line 784 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                              { }
#line 3201 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 38: /* iflag: T_SY  */
#line 786 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SY; }
#line 3207 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 39: /* iflag: T_SS  */
#line 787 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SS; }
#line 3213 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 40: /* iflag: T_JP  */
#line 788 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_JP; }
#line 3219 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 41: /* iflag: T_SAT  */
#line 789 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_SAT; }
#line 3225 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 42: /* iflag: T_RPT  */
#line 790 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { iflags.repeat = (yyvsp[0].num); }
#line 3231 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 43: /* iflag: T_UL  */
#line 791 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { iflags.flags |= IR3_INSTR_UL; }
#line 3237 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 44: /* iflag: T_NOP  */
#line 792 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { iflags.nop = (yyvsp[0].tok); }
#line 3243 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 54: /* instr: iflags cat5_instr  */
#line 805 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                     { fixup_cat5_s2en(); }
#line 3249 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 58: /* label: T_IDENTIFIER ':'  */
#line 810 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                    { new_label((yyvsp[-1].str)); }
#line 3255 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 59: /* cat0_src1: '!' T_P0  */
#line 812 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.inv1 = true; instr->cat0.comp1 = (yyvsp[0].num) >> 1; }
#line 3261 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 60: /* cat0_src1: T_P0  */
#line 813 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.comp1 = (yyvsp[0].num) >> 1; }
#line 3267 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 61: /* cat0_src2: '!' T_P0  */
#line 815 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.inv2 = true; instr->cat0.comp2 = (yyvsp[0].num) >> 1; }
#line 3273 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 62: /* cat0_src2: T_P0  */
#line 816 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.comp2 = (yyvsp[0].num) >> 1; }
#line 3279 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 63: /* cat0_immed: '#' integer  */
#line 818 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { instr->cat0.immed = (yyvsp[0].num); }
#line 3285 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 64: /* cat0_immed: '#' T_IDENTIFIER  */
#line 819 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                    { ralloc_steal(instr, (void *)(yyvsp[0].str)); instr->cat0.target_label = (yyvsp[0].str); }
#line 3291 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 65: /* cat0_instr: T_OP_NOP  */
#line 821 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_NOP); }
#line 3297 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 66: /* $@3: %empty  */
#line 822 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_PLAIN; }
#line 3303 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 68: /* $@4: %empty  */
#line 823 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_OR;    }
#line 3309 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 70: /* $@5: %empty  */
#line 824 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_AND;    }
#line 3315 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 72: /* $@6: %empty  */
#line 825 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                         { new_instr(OPC_B)->cat0.brtype = BRANCH_CONST; instr->cat0.idx = (yyvsp[0].num); }
#line 3321 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 74: /* $@7: %empty  */
#line 826 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_ANY; }
#line 3327 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 76: /* $@8: %empty  */
#line 827 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_ALL; }
#line 3333 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 78: /* $@9: %empty  */
#line 828 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_B)->cat0.brtype = BRANCH_X; }
#line 3339 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 80: /* $@10: %empty  */
#line 829 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_JUMP); }
#line 3345 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 82: /* $@11: %empty  */
#line 830 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CALL); }
#line 3351 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 84: /* cat0_instr: T_OP_RET  */
#line 831 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_RET); }
#line 3357 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 85: /* $@12: %empty  */
#line 832 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_KILL); }
#line 3363 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 87: /* cat0_instr: T_OP_END  */
#line 833 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_END); }
#line 3369 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 88: /* cat0_instr: T_OP_EMIT  */
#line 834 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_EMIT); }
#line 3375 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 89: /* cat0_instr: T_OP_CUT  */
#line 835 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CUT); }
#line 3381 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 90: /* cat0_instr: T_OP_CHMASK  */
#line 836 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CHMASK); }
#line 3387 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 91: /* cat0_instr: T_OP_CHSH  */
#line 837 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_CHSH); }
#line 3393 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 92: /* cat0_instr: T_OP_FLOW_REV  */
#line 838 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_FLOW_REV); }
#line 3399 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 93: /* $@13: %empty  */
#line 839 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_BKT); }
#line 3405 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 95: /* cat0_instr: T_OP_STKS  */
#line 840 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_STKS); }
#line 3411 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 96: /* cat0_instr: T_OP_STKR  */
#line 841 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_STKR); }
#line 3417 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 97: /* cat0_instr: T_OP_XSET  */
#line 842 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_XSET); }
#line 3423 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 98: /* cat0_instr: T_OP_XCLR  */
#line 843 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_XCLR); }
#line 3429 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 99: /* $@14: %empty  */
#line 844 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_GETONE); }
#line 3435 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 101: /* cat0_instr: T_OP_DBG  */
#line 845 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_DBG); }
#line 3441 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 102: /* $@15: %empty  */
#line 846 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_SHPS); }
#line 3447 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 104: /* cat0_instr: T_OP_SHPE  */
#line 847 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_SHPE); }
#line 3453 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 105: /* $@16: %empty  */
#line 848 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDT); }
#line 3459 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 107: /* $@17: %empty  */
#line 849 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDF); }
#line 3465 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 109: /* cat0_instr: T_OP_PREDE  */
#line 850 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_PREDE); }
#line 3471 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 110: /* $@18: %empty  */
#line 851 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                        { new_instr(OPC_GETLAST); }
#line 3477 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 112: /* cat1_opc: T_OP_MOV '.' T_CAT1_TYPE_TYPE  */
#line 853 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                 {
                       parse_type_type(new_instr(OPC_MOV), (yyvsp[0].str));
}
#line 3485 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 113: /* cat1_opc: T_OP_COV '.' T_CAT1_TYPE_TYPE  */
#line 856 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                 {
                       parse_type_type(new_instr(OPC_MOV), (yyvsp[0].str));
}
#line 3493 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 116: /* $@19: %empty  */
#line 863 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       {
                       new_instr(OPC_MOVMSK);
                       instr->cat1.src_type = TYPE_U32;
                       instr->cat1.dst_type = TYPE_U32;
                   }
#line 3503 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 117: /* cat1_movmsk: T_OP_MOVMSK '.' T_W $@19 dst_reg  */
#line 867 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             {
                       if (((yyvsp[-2].num) % 32) != 0)
                          yyerror("w# must be multiple of 32");
                       if ((yyvsp[-2].num) < 32)
                          yyerror("w# must be at least 32");

                       int num = (yyvsp[-2].num) / 32;

                       instr->repeat = num - 1;
                       instr->dsts[0]->wrmask = (1 << num) - 1;
                   }
#line 3519 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 118: /* $@20: %empty  */
#line 879 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       {
                       new_instr(OPC_MOV);
                       instr->cat1.src_type = TYPE_U16;
                       instr->cat1.dst_type = TYPE_U16;
                       new_dst((61 << 3) + 2, IR3_REG_HALF);
                   }
#line 3530 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 120: /* $@21: %empty  */
#line 886 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                      {
                       new_instr(OPC_MOV);
                       instr->cat1.src_type = TYPE_S16;
                       instr->cat1.dst_type = TYPE_S16;
                       new_dst((61 << 3), IR3_REG_HALF);
                   }
#line 3541 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 122: /* $@22: %empty  */
#line 893 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_SWZ), (yyvsp[0].str)); }
#line 3547 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 124: /* $@23: %empty  */
#line 895 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_GAT), (yyvsp[0].str)); }
#line 3553 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 126: /* $@24: %empty  */
#line 897 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                 { parse_type_type(new_instr(OPC_SCT), (yyvsp[0].str)); }
#line 3559 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 136: /* cat2_opc_1src: T_OP_ABSNEG_F  */
#line 909 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ABSNEG_F); }
#line 3565 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 137: /* cat2_opc_1src: T_OP_ABSNEG_S  */
#line 910 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ABSNEG_S); }
#line 3571 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 138: /* cat2_opc_1src: T_OP_CLZ_B  */
#line 911 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CLZ_B); }
#line 3577 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 139: /* cat2_opc_1src: T_OP_CLZ_S  */
#line 912 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CLZ_S); }
#line 3583 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 140: /* cat2_opc_1src: T_OP_SIGN_F  */
#line 913 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SIGN_F); }
#line 3589 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 141: /* cat2_opc_1src: T_OP_FLOOR_F  */
#line 914 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_FLOOR_F); }
#line 3595 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 142: /* cat2_opc_1src: T_OP_CEIL_F  */
#line 915 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CEIL_F); }
#line 3601 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 143: /* cat2_opc_1src: T_OP_RNDNE_F  */
#line 916 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RNDNE_F); }
#line 3607 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 144: /* cat2_opc_1src: T_OP_RNDAZ_F  */
#line 917 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RNDAZ_F); }
#line 3613 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 145: /* cat2_opc_1src: T_OP_TRUNC_F  */
#line 918 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_TRUNC_F); }
#line 3619 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 146: /* cat2_opc_1src: T_OP_NOT_B  */
#line 919 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_NOT_B); }
#line 3625 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 147: /* cat2_opc_1src: T_OP_BFREV_B  */
#line 920 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BFREV_B); }
#line 3631 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 148: /* cat2_opc_1src: T_OP_SETRM  */
#line 921 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SETRM); }
#line 3637 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 149: /* cat2_opc_1src: T_OP_CBITS_B  */
#line 922 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CBITS_B); }
#line 3643 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 150: /* cat2_opc_2src_cnd: T_OP_CMPS_F  */
#line 924 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_F); }
#line 3649 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 151: /* cat2_opc_2src_cnd: T_OP_CMPS_U  */
#line 925 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_U); }
#line 3655 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 152: /* cat2_opc_2src_cnd: T_OP_CMPS_S  */
#line 926 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPS_S); }
#line 3661 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 153: /* cat2_opc_2src_cnd: T_OP_CMPV_F  */
#line 927 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_F); }
#line 3667 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 154: /* cat2_opc_2src_cnd: T_OP_CMPV_U  */
#line 928 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_U); }
#line 3673 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 155: /* cat2_opc_2src_cnd: T_OP_CMPV_S  */
#line 929 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CMPV_S); }
#line 3679 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 156: /* cat2_opc_2src: T_OP_ADD_F  */
#line 931 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_F); }
#line 3685 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 157: /* cat2_opc_2src: T_OP_MIN_F  */
#line 932 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_F); }
#line 3691 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 158: /* cat2_opc_2src: T_OP_MAX_F  */
#line 933 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_F); }
#line 3697 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 159: /* cat2_opc_2src: T_OP_MUL_F  */
#line 934 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_F); }
#line 3703 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 160: /* cat2_opc_2src: T_OP_ADD_U  */
#line 935 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_U); }
#line 3709 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 161: /* cat2_opc_2src: T_OP_ADD_S  */
#line 936 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ADD_S); }
#line 3715 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 162: /* cat2_opc_2src: T_OP_SUB_U  */
#line 937 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SUB_U); }
#line 3721 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 163: /* cat2_opc_2src: T_OP_SUB_S  */
#line 938 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SUB_S); }
#line 3727 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 164: /* cat2_opc_2src: T_OP_MIN_U  */
#line 939 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_U); }
#line 3733 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 165: /* cat2_opc_2src: T_OP_MIN_S  */
#line 940 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MIN_S); }
#line 3739 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 166: /* cat2_opc_2src: T_OP_MAX_U  */
#line 941 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_U); }
#line 3745 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 167: /* cat2_opc_2src: T_OP_MAX_S  */
#line 942 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAX_S); }
#line 3751 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 168: /* cat2_opc_2src: T_OP_AND_B  */
#line 943 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_AND_B); }
#line 3757 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 169: /* cat2_opc_2src: T_OP_OR_B  */
#line 944 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_OR_B); }
#line 3763 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 170: /* cat2_opc_2src: T_OP_XOR_B  */
#line 945 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_XOR_B); }
#line 3769 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 171: /* cat2_opc_2src: T_OP_MUL_U24  */
#line 946 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_U24); }
#line 3775 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 172: /* cat2_opc_2src: T_OP_MUL_S24  */
#line 947 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MUL_S24); }
#line 3781 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 173: /* cat2_opc_2src: T_OP_MULL_U  */
#line 948 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MULL_U); }
#line 3787 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 174: /* cat2_opc_2src: T_OP_SHL_B  */
#line 949 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHL_B); }
#line 3793 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 175: /* cat2_opc_2src: T_OP_SHR_B  */
#line 950 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHR_B); }
#line 3799 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 176: /* cat2_opc_2src: T_OP_ASHR_B  */
#line 951 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ASHR_B); }
#line 3805 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 177: /* cat2_opc_2src: T_OP_BARY_F  */
#line 952 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BARY_F); }
#line 3811 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 178: /* cat2_opc_2src: T_OP_FLAT_B  */
#line 953 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_FLAT_B); }
#line 3817 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 179: /* cat2_opc_2src: T_OP_MGEN_B  */
#line 954 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MGEN_B); }
#line 3823 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 180: /* cat2_opc_2src: T_OP_GETBIT_B  */
#line 955 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETBIT_B); }
#line 3829 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 181: /* cat2_opc_2src: T_OP_SHB  */
#line 956 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHB); }
#line 3835 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 182: /* cat2_opc_2src: T_OP_MSAD  */
#line 957 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MSAD); }
#line 3841 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 183: /* cond: T_LT  */
#line 959 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_LT; }
#line 3847 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 184: /* cond: T_LE  */
#line 960 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_LE; }
#line 3853 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 185: /* cond: T_GT  */
#line 961 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_GT; }
#line 3859 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 186: /* cond: T_GE  */
#line 962 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_GE; }
#line 3865 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 187: /* cond: T_EQ  */
#line 963 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_EQ; }
#line 3871 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 188: /* cond: T_NE  */
#line 964 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat2.condition = IR3_COND_NE; }
#line 3877 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 192: /* cat3_dp_signedness: '.' T_MIXED  */
#line 970 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.signedness = IR3_SRC_MIXED; }
#line 3883 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 193: /* cat3_dp_signedness: '.' T_UNSIGNED  */
#line 971 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.signedness = IR3_SRC_UNSIGNED; }
#line 3889 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 194: /* cat3_dp_pack: '.' T_LOW  */
#line 973 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.packed = IR3_SRC_PACKED_LOW; }
#line 3895 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 195: /* cat3_dp_pack: '.' T_HIGH  */
#line 974 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                 { instr->cat3.packed = IR3_SRC_PACKED_HIGH; }
#line 3901 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 196: /* cat3_opc: T_OP_MAD_U16  */
#line 976 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_U16); }
#line 3907 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 197: /* cat3_opc: T_OP_MADSH_U16  */
#line 977 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MADSH_U16); }
#line 3913 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 198: /* cat3_opc: T_OP_MAD_S16  */
#line 978 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_S16); }
#line 3919 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 199: /* cat3_opc: T_OP_MADSH_M16  */
#line 979 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MADSH_M16); }
#line 3925 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 200: /* cat3_opc: T_OP_MAD_U24  */
#line 980 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_U24); }
#line 3931 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 201: /* cat3_opc: T_OP_MAD_S24  */
#line 981 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_S24); }
#line 3937 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 202: /* cat3_opc: T_OP_MAD_F16  */
#line 982 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_F16); }
#line 3943 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 203: /* cat3_opc: T_OP_MAD_F32  */
#line 983 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_MAD_F32); }
#line 3949 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 204: /* cat3_opc: T_OP_SEL_B16  */
#line 984 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_B16); }
#line 3955 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 205: /* cat3_opc: T_OP_SEL_B32  */
#line 985 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_B32); }
#line 3961 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 206: /* cat3_opc: T_OP_SEL_S16  */
#line 986 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_S16); }
#line 3967 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 207: /* cat3_opc: T_OP_SEL_S32  */
#line 987 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_S32); }
#line 3973 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 208: /* cat3_opc: T_OP_SEL_F16  */
#line 988 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_F16); }
#line 3979 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 209: /* cat3_opc: T_OP_SEL_F32  */
#line 989 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SEL_F32); }
#line 3985 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 210: /* cat3_opc: T_OP_SAD_S16  */
#line 990 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAD_S16); }
#line 3991 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 211: /* cat3_opc: T_OP_SAD_S32  */
#line 991 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAD_S32); }
#line 3997 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 212: /* cat3_imm_reg_opc: T_OP_SHRM  */
#line 993 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHRM); }
#line 4003 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 213: /* cat3_imm_reg_opc: T_OP_SHLM  */
#line 994 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHLM); }
#line 4009 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 214: /* cat3_imm_reg_opc: T_OP_SHRG  */
#line 995 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHRG); }
#line 4015 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 215: /* cat3_imm_reg_opc: T_OP_SHLG  */
#line 996 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SHLG); }
#line 4021 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 216: /* cat3_imm_reg_opc: T_OP_ANDG  */
#line 997 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ANDG); }
#line 4027 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 217: /* cat3_wmm: T_OP_WMM  */
#line 999 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_WMM); }
#line 4033 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 218: /* cat3_wmm: T_OP_WMM_ACCU  */
#line 1000 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_WMM_ACCU); }
#line 4039 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 219: /* cat3_dp: T_OP_DP2ACC  */
#line 1002 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DP2ACC); }
#line 4045 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 220: /* cat3_dp: T_OP_DP4ACC  */
#line 1003 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DP4ACC); }
#line 4051 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 225: /* cat4_opc: T_OP_RCP  */
#line 1010 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RCP); }
#line 4057 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 226: /* cat4_opc: T_OP_RSQ  */
#line 1011 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RSQ); }
#line 4063 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 227: /* cat4_opc: T_OP_LOG2  */
#line 1012 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_LOG2); }
#line 4069 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 228: /* cat4_opc: T_OP_EXP2  */
#line 1013 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_EXP2); }
#line 4075 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 229: /* cat4_opc: T_OP_SIN  */
#line 1014 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SIN); }
#line 4081 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 230: /* cat4_opc: T_OP_COS  */
#line 1015 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_COS); }
#line 4087 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 231: /* cat4_opc: T_OP_SQRT  */
#line 1016 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SQRT); }
#line 4093 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 232: /* cat4_opc: T_OP_HRSQ  */
#line 1017 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HRSQ); }
#line 4099 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 233: /* cat4_opc: T_OP_HLOG2  */
#line 1018 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HLOG2); }
#line 4105 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 234: /* cat4_opc: T_OP_HEXP2  */
#line 1019 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_HEXP2); }
#line 4111 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 236: /* cat5_opc_dsxypp: T_OP_DSXPP_1  */
#line 1023 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSXPP_1)->cat5.type = TYPE_F32; }
#line 4117 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 237: /* cat5_opc_dsxypp: T_OP_DSYPP_1  */
#line 1024 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSYPP_1)->cat5.type = TYPE_F32; }
#line 4123 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 238: /* cat5_opc: T_OP_ISAM  */
#line 1026 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAM); }
#line 4129 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 239: /* cat5_opc: T_OP_ISAML  */
#line 1027 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAML); }
#line 4135 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 240: /* cat5_opc: T_OP_ISAMM  */
#line 1028 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_ISAMM); }
#line 4141 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 241: /* cat5_opc: T_OP_SAM  */
#line 1029 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAM); }
#line 4147 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 242: /* cat5_opc: T_OP_SAMB  */
#line 1030 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMB); }
#line 4153 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 243: /* cat5_opc: T_OP_SAML  */
#line 1031 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAML); }
#line 4159 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 244: /* cat5_opc: T_OP_SAMGQ  */
#line 1032 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGQ); }
#line 4165 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 245: /* cat5_opc: T_OP_GETLOD  */
#line 1033 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETLOD); }
#line 4171 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 246: /* cat5_opc: T_OP_CONV  */
#line 1034 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CONV); }
#line 4177 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 247: /* cat5_opc: T_OP_CONVM  */
#line 1035 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_CONVM); }
#line 4183 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 248: /* cat5_opc: T_OP_GETSIZE  */
#line 1036 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETSIZE); }
#line 4189 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 249: /* cat5_opc: T_OP_GETBUF  */
#line 1037 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETBUF); }
#line 4195 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 250: /* cat5_opc: T_OP_GETPOS  */
#line 1038 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETPOS); }
#line 4201 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 251: /* cat5_opc: T_OP_GETINFO  */
#line 1039 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GETINFO); }
#line 4207 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 252: /* cat5_opc: T_OP_DSX  */
#line 1040 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSX); }
#line 4213 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 253: /* cat5_opc: T_OP_DSY  */
#line 1041 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_DSY); }
#line 4219 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 254: /* cat5_opc: T_OP_GATHER4R  */
#line 1042 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4R); }
#line 4225 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 255: /* cat5_opc: T_OP_GATHER4G  */
#line 1043 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4G); }
#line 4231 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 256: /* cat5_opc: T_OP_GATHER4B  */
#line 1044 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4B); }
#line 4237 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 257: /* cat5_opc: T_OP_GATHER4A  */
#line 1045 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_GATHER4A); }
#line 4243 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 258: /* cat5_opc: T_OP_SAMGP0  */
#line 1046 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP0); }
#line 4249 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 259: /* cat5_opc: T_OP_SAMGP1  */
#line 1047 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP1); }
#line 4255 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 260: /* cat5_opc: T_OP_SAMGP2  */
#line 1048 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP2); }
#line 4261 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 261: /* cat5_opc: T_OP_SAMGP3  */
#line 1049 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_SAMGP3); }
#line 4267 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 262: /* cat5_opc: T_OP_RGETPOS  */
#line 1050 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RGETPOS); }
#line 4273 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 263: /* cat5_opc: T_OP_RGETINFO  */
#line 1051 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RGETINFO); }
#line 4279 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 264: /* cat5_opc: T_OP_BRCST_A  */
#line 1052 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_BRCST_ACTIVE); }
#line 4285 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 265: /* cat5_opc: T_OP_QSHUFFLE_BRCST  */
#line 1053 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_BRCST); }
#line 4291 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 266: /* cat5_opc: T_OP_QSHUFFLE_H  */
#line 1054 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_HORIZ); }
#line 4297 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 267: /* cat5_opc: T_OP_QSHUFFLE_V  */
#line 1055 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_VERT); }
#line 4303 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 268: /* cat5_opc: T_OP_QSHUFFLE_DIAG  */
#line 1056 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_QUAD_SHUFFLE_DIAG); }
#line 4309 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 269: /* cat5_flag: '.' T_3D  */
#line 1058 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_3D; }
#line 4315 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 270: /* cat5_flag: '.' 'a'  */
#line 1059 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_A; }
#line 4321 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 271: /* cat5_flag: '.' 'o'  */
#line 1060 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_O; }
#line 4327 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 272: /* cat5_flag: '.' 'p'  */
#line 1061 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_P; }
#line 4333 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 273: /* cat5_flag: '.' 's'  */
#line 1062 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_S; }
#line 4339 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 274: /* cat5_flag: '.' T_S2EN  */
#line 1063 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_S2EN; }
#line 4345 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 275: /* cat5_flag: '.' T_UNIFORM  */
#line 1064 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { }
#line 4351 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 276: /* cat5_flag: '.' T_NONUNIFORM  */
#line 1065 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                     { instr->flags |= IR3_INSTR_NONUNIF; }
#line 4357 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 277: /* cat5_flag: '.' T_BASE  */
#line 1066 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_B; instr->cat5.tex_base = (yyvsp[0].tok); }
#line 4363 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 278: /* cat5_flag: '.' T_W  */
#line 1067 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.cluster_size = (yyvsp[0].num); }
#line 4369 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 281: /* cat5_samp: T_SAMP  */
#line 1071 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.samp = (yyvsp[0].tok); }
#line 4375 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 282: /* cat5_tex: T_TEX  */
#line 1072 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.tex = (yyvsp[0].tok); }
#line 4381 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 283: /* cat5_type: '(' type ')'  */
#line 1073 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat5.type = (yyvsp[-1].type); }
#line 4387 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 284: /* cat5_a1: src_reg  */
#line 1074 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->flags |= IR3_INSTR_A1EN; }
#line 4393 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 300: /* cat6_typed: '.' T_UNTYPED  */
#line 1092 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat6.typed = 0; }
#line 4399 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 301: /* cat6_typed: '.' T_TYPED  */
#line 1093 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat6.typed = 1; }
#line 4405 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 302: /* cat6_dim: '.' T_1D  */
#line 1095 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 1; }
#line 4411 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 303: /* cat6_dim: '.' T_2D  */
#line 1096 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 2; }
#line 4417 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 304: /* cat6_dim: '.' T_3D  */
#line 1097 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 3; }
#line 4423 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 305: /* cat6_dim: '.' T_4D  */
#line 1098 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.d = 4; }
#line 4429 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 306: /* cat6_type: '.' type  */
#line 1100 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.type = (yyvsp[0].type); }
#line 4435 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 307: /* cat6_imm_offset: offset  */
#line 1101 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 4441 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 310: /* cat6_dst_offset: offset  */
#line 1104 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.dst_offset = (yyvsp[0].num); }
#line 4447 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 312: /* cat6_immed: integer  */
#line 1107 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { instr->cat6.iim_val = (yyvsp[0].num); }
#line 4453 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 313: /* cat6_stg_ldg_a6xx_offset: '+' '(' src offset ')' '<' '<' integer  */
#line 1110 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                           {
                        assert((yyvsp[0].num) == 2);
                        new_src(0, IR3_REG_IMMED)->uim_val = 0;
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-4].num);
                    }
#line 4463 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 314: /* cat6_stg_ldg_a6xx_offset: '+' src '<' '<' integer offset '<' '<' integer  */
#line 1115 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                  {
                        assert((yyvsp[0].num) == 2);
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-4].num) - 2;
                        new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[-3].num);
                    }
#line 4473 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 315: /* $@25: %empty  */
#line 1121 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDG); }
#line 4479 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 317: /* $@26: %empty  */
#line 1122 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDG_A); }
#line 4485 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 319: /* $@27: %empty  */
#line 1123 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDP); }
#line 4491 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 321: /* $@28: %empty  */
#line 1124 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDL); }
#line 4497 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 323: /* $@29: %empty  */
#line 1125 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDLW); }
#line 4503 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 325: /* $@30: %empty  */
#line 1126 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_LDLV); }
#line 4509 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 326: /* $@31: %empty  */
#line 1126 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                                  {
                       new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[-1].num);
                   }
#line 4517 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 328: /* $@32: %empty  */
#line 1130 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_STG); dummy_dst(); }
#line 4523 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 330: /* $@33: %empty  */
#line 1131 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { new_instr(OPC_STG_A); dummy_dst(); }
#line 4529 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 332: /* $@34: %empty  */
#line 1132 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STP); dummy_dst(); }
#line 4535 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 334: /* $@35: %empty  */
#line 1133 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STL); dummy_dst(); }
#line 4541 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 336: /* $@36: %empty  */
#line 1134 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STLW); dummy_dst(); }
#line 4547 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 338: /* $@37: %empty  */
#line 1136 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_LDIB); }
#line 4553 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 340: /* $@38: %empty  */
#line 1137 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                             { new_instr(OPC_STIB); dummy_dst(); }
#line 4559 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 342: /* $@39: %empty  */
#line 1139 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                 { new_instr(OPC_PREFETCH); new_dst(0,0); /* dummy dst */ }
#line 4565 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 344: /* cat6_atomic_opc: T_OP_ATOMIC_ADD  */
#line 1141 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_ADD); }
#line 4571 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 345: /* cat6_atomic_opc: T_OP_ATOMIC_SUB  */
#line 1142 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_SUB); }
#line 4577 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 346: /* cat6_atomic_opc: T_OP_ATOMIC_XCHG  */
#line 1143 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_XCHG); }
#line 4583 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 347: /* cat6_atomic_opc: T_OP_ATOMIC_INC  */
#line 1144 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_INC); }
#line 4589 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 348: /* cat6_atomic_opc: T_OP_ATOMIC_DEC  */
#line 1145 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_DEC); }
#line 4595 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 349: /* cat6_atomic_opc: T_OP_ATOMIC_CMPXCHG  */
#line 1146 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_CMPXCHG); }
#line 4601 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 350: /* cat6_atomic_opc: T_OP_ATOMIC_MIN  */
#line 1147 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_MIN); }
#line 4607 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 351: /* cat6_atomic_opc: T_OP_ATOMIC_MAX  */
#line 1148 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_MAX); }
#line 4613 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 352: /* cat6_atomic_opc: T_OP_ATOMIC_AND  */
#line 1149 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_AND); }
#line 4619 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 353: /* cat6_atomic_opc: T_OP_ATOMIC_OR  */
#line 1150 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_OR); }
#line 4625 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 354: /* cat6_atomic_opc: T_OP_ATOMIC_XOR  */
#line 1151 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_instr(OPC_ATOMIC_XOR); }
#line 4631 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 355: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_ADD  */
#line 1153 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_ADD); }
#line 4637 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 356: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_SUB  */
#line 1154 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_SUB); }
#line 4643 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 357: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_XCHG  */
#line 1155 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_XCHG); }
#line 4649 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 358: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_INC  */
#line 1156 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_INC); }
#line 4655 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 359: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_DEC  */
#line 1157 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_DEC); }
#line 4661 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 360: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_CMPXCHG  */
#line 1158 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_CMPXCHG); }
#line 4667 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 361: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_MIN  */
#line 1159 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_MIN); }
#line 4673 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 362: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_MAX  */
#line 1160 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_MAX); }
#line 4679 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 363: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_AND  */
#line 1161 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_AND); }
#line 4685 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 364: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_OR  */
#line 1162 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_OR); }
#line 4691 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 365: /* cat6_a3xx_atomic_opc: T_OP_ATOMIC_S_XOR  */
#line 1163 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_S_XOR); }
#line 4697 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 366: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_ADD  */
#line 1165 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_ADD); }
#line 4703 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 367: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_SUB  */
#line 1166 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_SUB); }
#line 4709 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 368: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_XCHG  */
#line 1167 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_XCHG); }
#line 4715 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 369: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_INC  */
#line 1168 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_INC); }
#line 4721 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 370: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_DEC  */
#line 1169 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_DEC); }
#line 4727 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 371: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_CMPXCHG  */
#line 1170 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_CMPXCHG); }
#line 4733 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 372: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_MIN  */
#line 1171 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_MIN); }
#line 4739 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 373: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_MAX  */
#line 1172 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_MAX); }
#line 4745 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 374: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_AND  */
#line 1173 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_AND); }
#line 4751 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 375: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_OR  */
#line 1174 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_OR); }
#line 4757 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 376: /* cat6_a6xx_atomic_opc: T_OP_ATOMIC_G_XOR  */
#line 1175 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                              { new_instr(OPC_ATOMIC_G_XOR); }
#line 4763 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 383: /* cat6_ibo_opc_1src: T_OP_RESINFO  */
#line 1187 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_RESINFO); }
#line 4769 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 384: /* cat6_ibo_opc_ldgb: T_OP_LDGB  */
#line 1189 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_LDGB); }
#line 4775 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 385: /* cat6_ibo_opc_stgb: T_OP_STGB  */
#line 1190 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { new_instr(OPC_STGB); }
#line 4781 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 388: /* $@40: %empty  */
#line 1194 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                  { dummy_dst(); }
#line 4787 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 390: /* cat6_id_opc: T_OP_GETSPID  */
#line 1197 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                { new_instr(OPC_GETSPID); }
#line 4793 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 391: /* cat6_id_opc: T_OP_GETWID  */
#line 1198 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                { new_instr(OPC_GETWID); }
#line 4799 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 392: /* cat6_id_opc: T_OP_GETFIBERID  */
#line 1199 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_instr(OPC_GETFIBERID); }
#line 4805 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 395: /* cat6_bindless_base: '.' T_BASE  */
#line 1204 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                              { instr->flags |= IR3_INSTR_B; instr->cat6.base = (yyvsp[0].tok); }
#line 4811 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 398: /* cat6_bindless_mode: T_NONUNIFORM cat6_bindless_base  */
#line 1208 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                   { instr->flags |= IR3_INSTR_NONUNIF; }
#line 4817 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 400: /* cat6_reg_or_immed: integer  */
#line 1211 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                           { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 4823 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 401: /* cat6_bindless_ibo_opc_1src: T_OP_RESINFO_B  */
#line 1213 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                 { new_instr(OPC_RESINFO); }
#line 4829 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 402: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_ADD  */
#line 1215 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                     { new_instr(OPC_ATOMIC_B_ADD); dummy_dst(); }
#line 4835 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 403: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_SUB  */
#line 1216 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_SUB); dummy_dst(); }
#line 4841 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 404: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_XCHG  */
#line 1217 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_XCHG); dummy_dst(); }
#line 4847 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 405: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_INC  */
#line 1218 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_INC); dummy_dst(); }
#line 4853 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 406: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_DEC  */
#line 1219 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_DEC); dummy_dst(); }
#line 4859 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 407: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_CMPXCHG  */
#line 1220 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_CMPXCHG); dummy_dst(); }
#line 4865 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 408: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_MIN  */
#line 1221 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_MIN); dummy_dst(); }
#line 4871 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 409: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_MAX  */
#line 1222 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_MAX); dummy_dst(); }
#line 4877 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 410: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_AND  */
#line 1223 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_AND); dummy_dst(); }
#line 4883 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 411: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_OR  */
#line 1224 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_OR); dummy_dst(); }
#line 4889 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 412: /* cat6_bindless_ibo_opc_2src: T_OP_ATOMIC_B_XOR  */
#line 1225 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_ATOMIC_B_XOR); dummy_dst(); }
#line 4895 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 413: /* cat6_bindless_ibo_opc_2src: T_OP_STIB_B  */
#line 1226 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_STIB); dummy_dst(); }
#line 4901 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 414: /* cat6_bindless_ibo_opc_2src_dst: T_OP_LDIB_B  */
#line 1228 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                         { new_instr(OPC_LDIB); }
#line 4907 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 416: /* cat6_bindless_ibo: cat6_bindless_ibo_opc_2src cat6_typed cat6_dim cat6_type '.' cat6_immed '.' cat6_bindless_mode src_reg ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1231 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                                      { swap(instr->srcs[0], instr->srcs[2]); }
#line 4913 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 417: /* cat6_bindless_ibo: cat6_bindless_ibo_opc_2src_dst cat6_typed cat6_dim cat6_type '.' cat6_immed '.' cat6_bindless_mode dst_reg ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1232 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                                                                                                          { swap(instr->srcs[0], instr->srcs[1]); }
#line 4919 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 418: /* cat6_bindless_ldc_opc: T_OP_LDC  */
#line 1234 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                 { new_instr(OPC_LDC); }
#line 4925 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 419: /* cat6_bindless_ldc_middle: T_OFFSET '.' cat6_immed '.' cat6_bindless_mode dst_reg  */
#line 1238 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                               { instr->cat6.d = (yyvsp[-5].tok); }
#line 4931 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 420: /* cat6_bindless_ldc_middle: cat6_immed '.' 'k' '.' cat6_bindless_mode 'c' '[' T_A1 ']'  */
#line 1239 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                   { instr->opc = OPC_LDC_K; }
#line 4937 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 421: /* cat6_bindless_ldc: cat6_bindless_ldc_opc '.' cat6_bindless_ldc_middle ',' cat6_reg_or_immed ',' cat6_reg_or_immed  */
#line 1241 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                                                                                                  {
                      instr->cat6.type = TYPE_U32;
                      /* TODO cleanup ir3 src order: */
                      swap(instr->srcs[0], instr->srcs[1]);
                   }
#line 4947 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 422: /* stc_dst: integer  */
#line 1247 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                          { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 4953 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 423: /* stc_dst: T_A1  */
#line 1248 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                       { new_src(0, IR3_REG_IMMED)->iim_val = 0; instr->flags |= IR3_INSTR_A1EN; }
#line 4959 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 424: /* stc_dst: T_A1 '+' integer  */
#line 1249 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                   { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); instr->flags |= IR3_INSTR_A1EN; }
#line 4965 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 425: /* $@41: %empty  */
#line 1251 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                   { new_instr(OPC_STC); }
#line 4971 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 427: /* cat6_todo: T_OP_G2L  */
#line 1253 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_G2L); }
#line 4977 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 428: /* cat6_todo: T_OP_L2G  */
#line 1254 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_L2G); }
#line 4983 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 429: /* cat6_todo: T_OP_RESFMT  */
#line 1255 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_instr(OPC_RESFMT); }
#line 4989 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 442: /* cat7_scope: '.' 'w'  */
#line 1270 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.w = true; }
#line 4995 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 443: /* cat7_scope: '.' 'r'  */
#line 1271 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.r = true; }
#line 5001 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 444: /* cat7_scope: '.' 'l'  */
#line 1272 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.l = true; }
#line 5007 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 445: /* cat7_scope: '.' 'g'  */
#line 1273 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                            { instr->cat7.g = true; }
#line 5013 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 448: /* $@42: %empty  */
#line 1278 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_BAR); }
#line 5019 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 450: /* $@43: %empty  */
#line 1279 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                           { new_instr(OPC_FENCE); }
#line 5025 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 453: /* src: T_REGISTER  */
#line 1283 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((yyvsp[0].num), 0); }
#line 5031 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 454: /* src: T_A0  */
#line 1284 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((61 << 3), IR3_REG_HALF); }
#line 5037 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 455: /* src: T_A1  */
#line 1285 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((61 << 3) + 1, IR3_REG_HALF); }
#line 5043 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 456: /* src: T_P0  */
#line 1286 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((62 << 3) + (yyvsp[0].num), 0); }
#line 5049 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 457: /* dst: T_REGISTER  */
#line 1288 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((yyvsp[0].num), 0); }
#line 5055 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 458: /* dst: T_A0  */
#line 1289 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((61 << 3), IR3_REG_HALF); }
#line 5061 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 459: /* dst: T_A1  */
#line 1290 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((61 << 3) + 1, IR3_REG_HALF); }
#line 5067 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 460: /* dst: T_P0  */
#line 1291 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_dst((62 << 3) + (yyvsp[0].num), 0); }
#line 5073 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 461: /* const: T_CONSTANT  */
#line 1293 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { (yyval.reg) = new_src((yyvsp[0].num), IR3_REG_CONST); }
#line 5079 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 462: /* dst_reg_flag: T_EVEN  */
#line 1295 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_EVEN; }
#line 5085 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 463: /* dst_reg_flag: T_POS_INFINITY  */
#line 1296 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_POS_INF; }
#line 5091 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 464: /* dst_reg_flag: T_NEG_INFINITY  */
#line 1297 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { instr->cat1.round = ROUND_NEG_INF; }
#line 5097 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 465: /* dst_reg_flag: T_EI  */
#line 1298 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_EI; }
#line 5103 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 466: /* dst_reg_flag: T_WRMASK  */
#line 1299 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.wrmask = (yyvsp[0].num); }
#line 5109 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 469: /* dst_reg: dst  */
#line 1305 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { (yyvsp[0].reg)->flags |= IR3_REG_R; }
#line 5115 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 470: /* dst_reg: dst_reg_flags dst  */
#line 1306 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { (yyvsp[0].reg)->flags |= IR3_REG_R; }
#line 5121 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 471: /* src_reg_flag: T_ABSNEG  */
#line 1308 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_ABS|IR3_REG_NEGATE; }
#line 5127 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 472: /* src_reg_flag: T_NEG  */
#line 1309 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_NEGATE; }
#line 5133 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 473: /* src_reg_flag: T_ABS  */
#line 1310 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_ABS; }
#line 5139 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 474: /* src_reg_flag: T_R  */
#line 1311 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                  { rflags.flags |= IR3_REG_R; }
#line 5145 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 494: /* offset: %empty  */
#line 1340 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                   { (yyval.num) = 0; }
#line 5151 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 495: /* offset: '+' integer  */
#line 1341 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].num); }
#line 5157 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 496: /* offset: '-' integer  */
#line 1342 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = -(yyvsp[0].num); }
#line 5163 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 497: /* relative_gpr_src: 'r' '<' T_A0 offset '>'  */
#line 1344 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_src(0, IR3_REG_RELATIV)->array.offset = (yyvsp[-1].num); }
#line 5169 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 498: /* relative_gpr_src: T_HR '<' T_A0 offset '>'  */
#line 1345 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                             { new_src(0, IR3_REG_RELATIV | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5175 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 499: /* relative_gpr_dst: 'r' '<' T_A0 offset '>'  */
#line 1347 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_dst(0, IR3_REG_RELATIV)->array.offset = (yyvsp[-1].num); }
#line 5181 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 500: /* relative_gpr_dst: T_HR '<' T_A0 offset '>'  */
#line 1348 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                             { new_dst(0, IR3_REG_RELATIV | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5187 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 501: /* relative_const: 'c' '<' T_A0 offset '>'  */
#line 1350 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                            { new_src(0, IR3_REG_RELATIV | IR3_REG_CONST)->array.offset = (yyvsp[-1].num); }
#line 5193 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 502: /* relative_const: T_HC '<' T_A0 offset '>'  */
#line 1351 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                             { new_src(0, IR3_REG_RELATIV | IR3_REG_CONST | IR3_REG_HALF)->array.offset = (yyvsp[-1].num); }
#line 5199 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 505: /* immediate_cat1: integer  */
#line 1360 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = type_size(instr->cat1.src_type) < 32 ? (yyvsp[0].num) & 0xffff : (yyvsp[0].num); }
#line 5205 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 506: /* immediate_cat1: '(' integer ')'  */
#line 1361 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = (yyvsp[-1].num); }
#line 5211 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 507: /* immediate_cat1: '(' float ')'  */
#line 1362 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = (yyvsp[-1].flt); }
#line 5217 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 508: /* immediate_cat1: 'h' '(' integer ')'  */
#line 1363 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->iim_val = (yyvsp[-1].num) & 0xffff; }
#line 5223 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 509: /* immediate_cat1: 'h' '(' float ')'  */
#line 1364 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->uim_val = _mesa_float_to_half((yyvsp[-1].flt)); }
#line 5229 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 510: /* immediate_cat1: '(' T_NAN ')'  */
#line 1365 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = NAN; }
#line 5235 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 511: /* immediate_cat1: '(' T_INF ')'  */
#line 1366 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = INFINITY; }
#line 5241 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 512: /* immediate: integer  */
#line 1368 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->iim_val = (yyvsp[0].num); }
#line 5247 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 513: /* immediate: '(' integer ')'  */
#line 1369 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->fim_val = (yyvsp[-1].num); }
#line 5253 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 514: /* immediate: flut_immed  */
#line 1370 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED)->uim_val = (yyvsp[0].num); }
#line 5259 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 515: /* immediate: 'h' '(' integer ')'  */
#line 1371 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->iim_val = (yyvsp[-1].num); }
#line 5265 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 516: /* immediate: 'h' flut_immed  */
#line 1372 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                                       { new_src(0, IR3_REG_IMMED | IR3_REG_HALF)->uim_val = (yyvsp[0].num); }
#line 5271 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 529: /* integer: T_INT  */
#line 1388 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].num); }
#line 5277 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 530: /* integer: '-' T_INT  */
#line 1389 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = -(yyvsp[0].num); }
#line 5283 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 531: /* integer: T_HEX  */
#line 1390 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = (yyvsp[0].unum); }
#line 5289 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 532: /* integer: '-' T_HEX  */
#line 1391 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.num) = -(yyvsp[0].unum); }
#line 5295 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 533: /* float: T_FLOAT  */
#line 1393 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.flt) = (yyvsp[0].flt); }
#line 5301 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 534: /* float: '-' T_FLOAT  */
#line 1394 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.flt) = -(yyvsp[0].flt); }
#line 5307 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 535: /* type: T_TYPE_F16  */
#line 1396 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_F16; }
#line 5313 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 536: /* type: T_TYPE_F32  */
#line 1397 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_F32; }
#line 5319 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 537: /* type: T_TYPE_U16  */
#line 1398 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_U16; }
#line 5325 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 538: /* type: T_TYPE_U32  */
#line 1399 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_U32; }
#line 5331 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 539: /* type: T_TYPE_S16  */
#line 1400 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_S16; }
#line 5337 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 540: /* type: T_TYPE_S32  */
#line 1401 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_S32; }
#line 5343 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 541: /* type: T_TYPE_U8  */
#line 1402 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_U8;  }
#line 5349 "src/freedreno/ir3/ir3_parser.c"
    break;

  case 542: /* type: T_TYPE_S8  */
#line 1403 "../mesa-22.2.1/src/freedreno/ir3/ir3_parser.y"
                               { (yyval.type) = TYPE_S8;  }
#line 5355 "src/freedreno/ir3/ir3_parser.c"
    break;


#line 5359 "src/freedreno/ir3/ir3_parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

