/* gkr-item.c generated by valac 0.56.1, the Vala compiler
 * generated from gkr-item.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2020 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-gkr.h"
#include <libsecret/secret.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "seahorse-common.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define SEAHORSE_GKR_GENERIC_SECRET "org.freedesktop.Secret.Generic"
#define SEAHORSE_GKR_KEYRING_NOTE "org.gnome.keyring.Note"
#define SEAHORSE_GKR_CHAINED_KEYRING "org.gnome.keyring.ChainedKeyring"
#define SEAHORSE_GKR_ENCRYPTION_KEY "org.gnome.keyring.EncryptionKey"
#define SEAHORSE_GKR_PK_STORAGE "org.gnome.keyring.PkStorage"
#define SEAHORSE_GKR_NETWORK_MANAGER_SECRET "org.freedesktop.NetworkManager"
#define SEAHORSE_GKR_NETWORK_PASSWORD "org.gnome.keyring.NetworkPassword"
#define SEAHORSE_GKR_EPIPHANY_PASSWORD "x.internal.Epiphany"
#define SEAHORSE_GKR_CHROME_PASSWORD "x.internal.Chrome"
#define SEAHORSE_GKR_GOA_PASSWORD "org.gnome.OnlineAccounts"
#define SEAHORSE_GKR_TELEPATHY_PASSWORD "org.freedesktop.Telepathy"
#define SEAHORSE_GKR_EMPATHY_PASSWORD "org.freedesktop.Empathy"
#define SEAHORSE_GKR_NETWORK_MANAGER_CONNECTION "org.freedesktop.NetworkManager.Connection"

enum  {
	SEAHORSE_GKR_ITEM_0_PROPERTY,
	SEAHORSE_GKR_ITEM_DESCRIPTION_PROPERTY,
	SEAHORSE_GKR_ITEM_USE_PROPERTY,
	SEAHORSE_GKR_ITEM_HAS_SECRET_PROPERTY,
	SEAHORSE_GKR_ITEM_PLACE_PROPERTY,
	SEAHORSE_GKR_ITEM_OBJECT_FLAGS_PROPERTY,
	SEAHORSE_GKR_ITEM_ICON_PROPERTY,
	SEAHORSE_GKR_ITEM_LABEL_PROPERTY,
	SEAHORSE_GKR_ITEM_MARKUP_PROPERTY,
	SEAHORSE_GKR_ITEM_USAGE_PROPERTY,
	SEAHORSE_GKR_ITEM_DELETABLE_PROPERTY,
	SEAHORSE_GKR_ITEM_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_NUM_PROPERTIES];
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_ITEM_DELETER (seahorse_gkr_item_deleter_get_type ())
#define SEAHORSE_GKR_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter))
#define SEAHORSE_GKR_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))
#define SEAHORSE_GKR_IS_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_IS_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_ITEM_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))

typedef struct _SeahorseGkrItemDeleter SeahorseGkrItemDeleter;
typedef struct _SeahorseGkrItemDeleterClass SeahorseGkrItemDeleterClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SeahorseGkrItemLoadItemSecretData SeahorseGkrItemLoadItemSecretData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseGkrItemSetSecretData SeahorseGkrItemSetSecretData;
typedef struct _SeahorseGkrItemCopySecretToClipboardData SeahorseGkrItemCopySecretToClipboardData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define SEAHORSE_GKR_TYPE_MAPPING_ENTRY (seahorse_gkr_mapping_entry_get_type ())
typedef struct _SeahorseGkrMappingEntry SeahorseGkrMappingEntry;
typedef struct _SeahorseGkrItemDeleterPrivate SeahorseGkrItemDeleterPrivate;
enum  {
	SEAHORSE_GKR_ITEM_DELETER_0_PROPERTY,
	SEAHORSE_GKR_ITEM_DELETER_NUM_PROPERTIES
};
static GParamSpec* seahorse_gkr_item_deleter_properties[SEAHORSE_GKR_ITEM_DELETER_NUM_PROPERTIES];
typedef struct _SeahorseGkrItemDeleterDeleteData SeahorseGkrItemDeleterDeleteData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseGkrItemPrivate {
	SecretValue* _item_secret;
	SeahorseGkrItemInfo* _info;
	GWeakRef _place;
	GCancellable* _req_secret;
};

struct _SeahorseGkrItemLoadItemSecretData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrItem* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	SecretValue* _tmp3_;
	GError* _inner_error0_;
};

struct _SeahorseGkrItemSetSecretData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrItem* self;
	SecretValue* value;
	GCancellable* cancellable;
	gboolean result;
	SecretValue* _tmp0_;
	GError* _inner_error0_;
};

struct _SeahorseGkrItemCopySecretToClipboardData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrItem* self;
	GtkClipboard* clipboard;
	SecretValue* _tmp0_;
	SecretValue* _tmp1_;
	const gchar* password;
	SecretValue* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _SeahorseGkrMappingEntry {
	const gchar* item_type;
	const gchar* mapped_type;
	const gchar* match_attribute;
	const gchar* match_pattern;
};

struct _SeahorseGkrItemDeleter {
	SeahorseDeleter parent_instance;
	SeahorseGkrItemDeleterPrivate * priv;
};

struct _SeahorseGkrItemDeleterClass {
	SeahorseDeleterClass parent_class;
};

struct _SeahorseGkrItemDeleterPrivate {
	GList* _items;
};

struct _SeahorseGkrItemDeleterDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseGkrItemDeleter* self;
	GCancellable* cancellable;
	gboolean result;
	GList* items;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* item_collection;
	GList* item_it;
	SeahorseGkrItem* item;
	SeahorseGkrItem* _tmp3_;
	GError* _inner_error0_;
};

static gint SeahorseGkrItem_private_offset;
static gpointer seahorse_gkr_item_parent_class = NULL;
static SeahorseDeletableIface * seahorse_gkr_item_seahorse_deletable_parent_iface = NULL;
static SeahorseViewableIface * seahorse_gkr_item_seahorse_viewable_parent_iface = NULL;
static gint SeahorseGkrItemDeleter_private_offset;
static gpointer seahorse_gkr_item_deleter_parent_class = NULL;

static void seahorse_gkr_item_real_dispose (GObject* base);
static SeahorseDeleter* seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base);
VALA_EXTERN SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_new (SeahorseGkrItem* item);
VALA_EXTERN SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_construct (GType object_type,
                                                             SeahorseGkrItem* item);
VALA_EXTERN GType seahorse_gkr_item_deleter_get_type (void) G_GNUC_CONST ;
static GtkWindow* seahorse_gkr_item_real_create_viewer (SeahorseViewable* base,
                                                 GtkWindow* parent);
static void seahorse_gkr_item_ensure_item_info (SeahorseGkrItem* self);
VALA_EXTERN const gchar* seahorse_gkr_map_item_type_to_specific (const gchar* item_type,
                                                     GHashTable* attrs);
static SeahorseGkrItemInfo* seahorse_gkr_item_item_type_to_item_info (SeahorseGkrItem* self,
                                                               const gchar* item_type,
                                                               const gchar* label,
                                                               GHashTable* attrs);
static void seahorse_gkr_item_load_item_secret_data_free (gpointer _data);
static void seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void seahorse_gkr_item_load_item_secret_finish (SeahorseGkrItem* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static gboolean seahorse_gkr_item_load_item_secret_co (SeahorseGkrItemLoadItemSecretData* _data_);
static void seahorse_gkr_item_load_item_secret_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void __lambda6_ (SeahorseGkrItem* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void ___lambda8_ (SeahorseGkrItem* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda8__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void seahorse_gkr_item_set_secret_data_free (gpointer _data);
static gboolean seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_);
static void seahorse_gkr_item_set_secret_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void seahorse_gkr_item_copy_secret_to_clipboard_data_free (gpointer _data);
static gboolean seahorse_gkr_item_copy_secret_to_clipboard_co (SeahorseGkrItemCopySecretToClipboardData* _data_);
static void seahorse_gkr_item_copy_secret_to_clipboard_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static GObject * seahorse_gkr_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _seahorse_gkr_item___lambda12_ (SeahorseGkrItem* self,
                                     GVariant* changed_properties,
                                     gchar** invalidated_properties);
static void __seahorse_gkr_item___lambda12__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                        GVariant* changed_properties,
                                                                        gchar** invalidated_properties,
                                                                        gpointer self);
static void seahorse_gkr_item_finalize (GObject * obj);
static GType seahorse_gkr_item_get_type_once (void);
static void _vala_seahorse_gkr_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_seahorse_gkr_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
VALA_EXTERN GType seahorse_gkr_mapping_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SeahorseGkrMappingEntry* seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self);
VALA_EXTERN void seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GtkDialog* seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base,
                                                          GtkWindow* parent);
static GList* seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base);
static gboolean seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base,
                                                    GObject* obj);
static void seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data);
static void seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_);
static void seahorse_gkr_item_deleter_delete_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void seahorse_gkr_item_deleter_finalize (GObject * obj);
static GType seahorse_gkr_item_deleter_get_type_once (void);

const SeahorseGkrMappingEntry SEAHORSE_GKR_MAPPING_ENTRIES[10] = {{"org.gnome.Polari.Identify", "org.gnome.Polari"}, {"_chrome_dummy_schema_for_unlocking", "google-chrome"}, {"chrome_libsecret_os_crypt_password_v2", "chromium-browser"}, {"org.epiphany.FormPassword", SEAHORSE_GKR_EPIPHANY_PASSWORD}, {"chrome_libsecret_password_schema", SEAHORSE_GKR_CHROME_PASSWORD}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_CHROME_PASSWORD, "application", "chrome*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_GOA_PASSWORD, "goa-identity", NULL}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_TELEPATHY_PASSWORD, "account", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_EMPATHY_PASSWORD, "account-id", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_NETWORK_MANAGER_SECRET, "connection-uuid", NULL}};

 G_GNUC_NO_INLINE static GType
seahorse_gkr_use_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_GKR_USE_OTHER, "SEAHORSE_GKR_USE_OTHER", "other"}, {SEAHORSE_GKR_USE_NETWORK, "SEAHORSE_GKR_USE_NETWORK", "network"}, {SEAHORSE_GKR_USE_WEB, "SEAHORSE_GKR_USE_WEB", "web"}, {SEAHORSE_GKR_USE_PGP, "SEAHORSE_GKR_USE_PGP", "pgp"}, {SEAHORSE_GKR_USE_SSH, "SEAHORSE_GKR_USE_SSH", "ssh"}, {0, NULL, NULL}};
	GType seahorse_gkr_use_type_id;
	seahorse_gkr_use_type_id = g_enum_register_static ("SeahorseGkrUse", values);
	return seahorse_gkr_use_type_id;
}

GType
seahorse_gkr_use_get_type (void)
{
	static volatile gsize seahorse_gkr_use_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_use_type_id__once)) {
		GType seahorse_gkr_use_type_id;
		seahorse_gkr_use_type_id = seahorse_gkr_use_get_type_once ();
		g_once_init_leave (&seahorse_gkr_use_type_id__once, seahorse_gkr_use_type_id);
	}
	return seahorse_gkr_use_type_id__once;
}

static inline gpointer
seahorse_gkr_item_get_instance_private (SeahorseGkrItem* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrItem_private_offset);
}

static void
seahorse_gkr_item_real_dispose (GObject* base)
{
	SeahorseGkrItem * self;
	GCancellable* _tmp0_;
	self = (SeahorseGkrItem*) base;
	_tmp0_ = self->priv->_req_secret;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->_req_secret;
		g_cancellable_cancel (_tmp1_);
	}
	_g_object_unref0 (self->priv->_req_secret);
	self->priv->_req_secret = NULL;
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
}

static SeahorseDeleter*
seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base)
{
	SeahorseGkrItem * self;
	SeahorseGkrItemDeleter* _tmp0_;
	SeahorseDeleter* result;
	self = (SeahorseGkrItem*) base;
	_tmp0_ = seahorse_gkr_item_deleter_new (self);
	result = (SeahorseDeleter*) _tmp0_;
	return result;
}

static GtkWindow*
seahorse_gkr_item_real_create_viewer (SeahorseViewable* base,
                                      GtkWindow* parent)
{
	SeahorseGkrItem * self;
	SeahorseGkrItemProperties* _tmp0_;
	GtkWindow* result;
	self = (SeahorseGkrItem*) base;
	_tmp0_ = seahorse_gkr_item_properties_new (self, parent);
	g_object_ref_sink (_tmp0_);
	result = (GtkWindow*) _tmp0_;
	return result;
}

static void
seahorse_gkr_item_ensure_item_info (SeahorseGkrItem* self)
{
	SeahorseGkrItemInfo* _tmp0_;
	const gchar* item_type = NULL;
	GHashTable* attrs = NULL;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	const gchar* _tmp6_;
	GHashTable* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* label = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GHashTable* _tmp13_;
	SeahorseGkrItemInfo* _tmp14_;
	SeahorseGkrItemInfo* _tmp15_;
	GIcon* _tmp16_;
	GIcon* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info;
	if (_tmp0_ != NULL) {
		return;
	}
	item_type = NULL;
	g_object_get ((SecretRetrievable*) self, "attributes", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	attrs = _tmp2_;
	_tmp3_ = attrs;
	if (_tmp3_ != NULL) {
		GHashTable* _tmp4_;
		gconstpointer _tmp5_;
		_tmp4_ = attrs;
		_tmp5_ = g_hash_table_lookup (_tmp4_, "xdg:schema");
		item_type = (const gchar*) _tmp5_;
	}
	_tmp6_ = item_type;
	_tmp7_ = attrs;
	_tmp8_ = seahorse_gkr_map_item_type_to_specific (_tmp6_, _tmp7_);
	item_type = _tmp8_;
	_tmp9_ = item_type;
	_vala_assert (_tmp9_ != NULL, "item_type != null");
	_tmp10_ = secret_item_get_label (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
	label = _tmp10_;
	_tmp11_ = item_type;
	_tmp12_ = label;
	_tmp13_ = attrs;
	_tmp14_ = seahorse_gkr_item_item_type_to_item_info (self, _tmp11_, _tmp12_, _tmp13_);
	_g_object_unref0 (self->priv->_info);
	self->priv->_info = _tmp14_;
	_tmp15_ = self->priv->_info;
	_tmp16_ = seahorse_gkr_item_info_get_icon (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == NULL) {
		SeahorseGkrItemInfo* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = self->priv->_info;
		_tmp19_ = item_type;
		seahorse_gkr_item_info_query_installed_apps (_tmp18_, _tmp19_);
	}
	_g_free0 (label);
	_g_hash_table_unref0 (attrs);
}

static SeahorseGkrItemInfo*
seahorse_gkr_item_item_type_to_item_info (SeahorseGkrItem* self,
                                          const gchar* item_type,
                                          const gchar* label,
                                          GHashTable* attrs)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	SeahorseGkrItemInfo* _tmp16_;
	SeahorseGkrItemInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_type != NULL, NULL);
	_tmp0_ = item_type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (SEAHORSE_GKR_GENERIC_SECRET)))) {
		switch (0) {
			default:
			{
				SeahorseGkrItemInfo* _tmp3_;
				_tmp3_ = seahorse_gkr_item_info_new (label, attrs, NULL);
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (SEAHORSE_GKR_KEYRING_NOTE)))) {
		switch (0) {
			default:
			{
				SeahorseGkrItemInfo* _tmp4_;
				_tmp4_ = seahorse_gkr_item_info_new (label, attrs, _ ("Stored note"));
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (SEAHORSE_GKR_CHAINED_KEYRING)))) {
		switch (0) {
			default:
			{
				SeahorseGkrItemInfo* _tmp5_;
				_tmp5_ = seahorse_gkr_item_info_new (label, attrs, _ ("Keyring password"));
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (SEAHORSE_GKR_ENCRYPTION_KEY)))) {
		switch (0) {
			default:
			{
				SeahorseGkrItemInfo* _tmp6_;
				_tmp6_ = seahorse_gkr_item_info_new (label, attrs, _ ("Encryption key password"));
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string (SEAHORSE_GKR_PK_STORAGE)))) {
		switch (0) {
			default:
			{
				SeahorseGkrItemInfo* _tmp7_;
				_tmp7_ = seahorse_gkr_item_info_new (label, attrs, _ ("Key storage password"));
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string (SEAHORSE_GKR_NETWORK_MANAGER_SECRET)))) {
		switch (0) {
			default:
			{
				SeahorseGkrItemInfo* _tmp8_;
				_tmp8_ = seahorse_gkr_item_info_new (label, attrs, _ ("Network Manager secret"));
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string (SEAHORSE_GKR_NETWORK_PASSWORD)))) {
		switch (0) {
			default:
			{
				SeahorseGkrGkrNetworkPassInfo* _tmp9_;
				_tmp9_ = seahorse_gkr_gkr_network_pass_info_new (label, attrs);
				result = (SeahorseGkrItemInfo*) _tmp9_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string (SEAHORSE_GKR_EPIPHANY_PASSWORD)))) {
		switch (0) {
			default:
			{
				SeahorseGkrEpiphanyPassInfo* _tmp10_;
				_tmp10_ = seahorse_gkr_epiphany_pass_info_new (label, attrs);
				result = (SeahorseGkrItemInfo*) _tmp10_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string (SEAHORSE_GKR_CHROME_PASSWORD)))) {
		switch (0) {
			default:
			{
				SeahorseGkrChromePassInfo* _tmp11_;
				_tmp11_ = seahorse_gkr_chrome_pass_info_new (label, attrs);
				result = (SeahorseGkrItemInfo*) _tmp11_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string (SEAHORSE_GKR_GOA_PASSWORD)))) {
		switch (0) {
			default:
			{
				SeahorseGkrGoaInfo* _tmp12_;
				_tmp12_ = seahorse_gkr_goa_info_new (label, attrs);
				result = (SeahorseGkrItemInfo*) _tmp12_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string (SEAHORSE_GKR_TELEPATHY_PASSWORD)))) {
		switch (0) {
			default:
			{
				SeahorseGkrTelepathyInfo* _tmp13_;
				_tmp13_ = seahorse_gkr_telepathy_info_new (label, attrs);
				result = (SeahorseGkrItemInfo*) _tmp13_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string (SEAHORSE_GKR_EMPATHY_PASSWORD)))) {
		switch (0) {
			default:
			{
				SeahorseGkrEmpathyInfo* _tmp14_;
				_tmp14_ = seahorse_gkr_empathy_info_new (label, attrs);
				result = (SeahorseGkrItemInfo*) _tmp14_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string (SEAHORSE_GKR_NETWORK_MANAGER_CONNECTION)))) {
		switch (0) {
			default:
			{
				SeahorseGkrNmConnectionInfo* _tmp15_;
				_tmp15_ = seahorse_gkr_nm_connection_info_new (label, attrs);
				result = (SeahorseGkrItemInfo*) _tmp15_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp16_ = seahorse_gkr_item_info_new (label, attrs, NULL);
	result = _tmp16_;
	return result;
}

static void
seahorse_gkr_item_load_item_secret_data_free (gpointer _data)
{
	SeahorseGkrItemLoadItemSecretData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemLoadItemSecretData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SeahorseGkrItemLoadItemSecretData* _data_;
	SeahorseGkrItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SeahorseGkrItemLoadItemSecretData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_item_load_item_secret_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	seahorse_gkr_item_load_item_secret_co (_data_);
}

static void
seahorse_gkr_item_load_item_secret_finish (SeahorseGkrItem* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	SeahorseGkrItemLoadItemSecretData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
seahorse_gkr_item_load_item_secret_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	SeahorseGkrItemLoadItemSecretData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_load_item_secret_co (_data_);
}

static gboolean
seahorse_gkr_item_load_item_secret_co (SeahorseGkrItemLoadItemSecretData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_req_secret;
	if (_data_->_tmp0_ != NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->_req_secret);
	_data_->self->priv->_req_secret = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_req_secret;
	_data_->_state_ = 1;
	secret_item_load_secret ((SecretItem*) _data_->self, _data_->_tmp2_, seahorse_gkr_item_load_item_secret_ready, _data_);
	return FALSE;
	_state_1:
	secret_item_load_secret_finish ((SecretItem*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->_req_secret);
	_data_->self->priv->_req_secret = NULL;
	_data_->_tmp3_ = secret_item_get_secret (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem));
	_secret_value_unref0 (_data_->self->priv->_item_secret);
	_data_->self->priv->_item_secret = _data_->_tmp3_;
	g_object_notify ((GObject*) _data_->self, "has-secret");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda6_ (SeahorseGkrItem* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		seahorse_gkr_item_load_item_secret_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("gkr-item.vala:217: Couldn't load secret: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ ((SeahorseGkrItem*) self, source_object, res);
	g_object_unref (self);
}

void
seahorse_gkr_item_refresh (SeahorseGkrItem* self)
{
	SecretValue* _tmp0_;
	g_return_if_fail (self != NULL);
	secret_item_refresh (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
	_tmp0_ = self->priv->_item_secret;
	if (_tmp0_ != NULL) {
		return;
	}
	seahorse_gkr_item_load_item_secret (self, ___lambda6__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda8_ (SeahorseGkrItem* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		seahorse_gkr_item_load_item_secret_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("gkr-item.vala:228: Couldn't load secret: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda8__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda8_ ((SeahorseGkrItem*) self, source_object, res);
	g_object_unref (self);
}

static gpointer
_secret_value_ref0 (gpointer self)
{
	return self ? secret_value_ref (self) : NULL;
}

SecretValue*
seahorse_gkr_item_get_secret (SeahorseGkrItem* self)
{
	SecretValue* _tmp0_;
	SecretValue* _tmp1_;
	SecretValue* _tmp2_;
	SecretValue* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item_secret;
	if (_tmp0_ == NULL) {
		seahorse_gkr_item_load_item_secret (self, ____lambda8__gasync_ready_callback, g_object_ref (self));
	}
	_tmp1_ = self->priv->_item_secret;
	_tmp2_ = _secret_value_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
seahorse_gkr_item_get_attribute (SeahorseGkrItem* self,
                                 const gchar* name)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	gboolean _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_object_get ((SecretRetrievable*) self, "attributes", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_hash_table_unref0 (_tmp2_);
	if (_tmp3_) {
		result = NULL;
		return result;
	}
	g_object_get ((SecretRetrievable*) self, "attributes", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_hash_table_lookup (_tmp6_, name);
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_hash_table_unref0 (_tmp6_);
	result = _tmp9_;
	return result;
}

static void
seahorse_gkr_item_set_secret_data_free (gpointer _data)
{
	SeahorseGkrItemSetSecretData* _data_;
	_data_ = _data;
	_secret_value_unref0 (_data_->value);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemSetSecretData, _data_);
}

void
seahorse_gkr_item_set_secret (SeahorseGkrItem* self,
                              SecretValue* value,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	SeahorseGkrItemSetSecretData* _data_;
	SeahorseGkrItem* _tmp0_;
	SecretValue* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_data_ = g_slice_new0 (SeahorseGkrItemSetSecretData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_item_set_secret_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _secret_value_ref0 (value);
	_secret_value_unref0 (_data_->value);
	_data_->value = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_gkr_item_set_secret_co (_data_);
}

gboolean
seahorse_gkr_item_set_secret_finish (SeahorseGkrItem* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gboolean result;
	SeahorseGkrItemSetSecretData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_gkr_item_set_secret_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	SeahorseGkrItemSetSecretData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_set_secret_co (_data_);
}

static gboolean
seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	secret_item_set_secret (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->value, _data_->cancellable, seahorse_gkr_item_set_secret_ready, _data_);
	return FALSE;
	_state_1:
	secret_item_set_secret_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _secret_value_ref0 (_data_->value);
	_secret_value_unref0 (_data_->self->priv->_item_secret);
	_data_->self->priv->_item_secret = _data_->_tmp0_;
	g_object_notify ((GObject*) _data_->self, "has-secret");
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_item_copy_secret_to_clipboard_data_free (gpointer _data)
{
	SeahorseGkrItemCopySecretToClipboardData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->clipboard);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemCopySecretToClipboardData, _data_);
}

void
seahorse_gkr_item_copy_secret_to_clipboard (SeahorseGkrItem* self,
                                            GtkClipboard* clipboard,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SeahorseGkrItemCopySecretToClipboardData* _data_;
	SeahorseGkrItem* _tmp0_;
	GtkClipboard* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	_data_ = g_slice_new0 (SeahorseGkrItemCopySecretToClipboardData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_item_copy_secret_to_clipboard_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (clipboard);
	_g_object_unref0 (_data_->clipboard);
	_data_->clipboard = _tmp1_;
	seahorse_gkr_item_copy_secret_to_clipboard_co (_data_);
}

void
seahorse_gkr_item_copy_secret_to_clipboard_finish (SeahorseGkrItem* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	SeahorseGkrItemCopySecretToClipboardData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
seahorse_gkr_item_copy_secret_to_clipboard_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	SeahorseGkrItemCopySecretToClipboardData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_copy_secret_to_clipboard_co (_data_);
}

static gboolean
seahorse_gkr_item_copy_secret_to_clipboard_co (SeahorseGkrItemCopySecretToClipboardData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_item_secret;
	if (_data_->_tmp0_ == NULL) {
		_data_->_state_ = 1;
		seahorse_gkr_item_load_item_secret (_data_->self, seahorse_gkr_item_copy_secret_to_clipboard_ready, _data_);
		return FALSE;
		_state_1:
		seahorse_gkr_item_load_item_secret_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = _data_->self->priv->_item_secret;
	if (_data_->_tmp1_ == NULL) {
		g_debug ("gkr-item.vala:254: Can't copy to clipboard: secret is NULL");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_item_secret;
	_data_->_tmp3_ = secret_value_get_text (_data_->_tmp2_);
	_data_->password = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->password;
	if (_data_->_tmp4_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->password;
	gtk_clipboard_set_text (_data_->clipboard, _data_->_tmp5_, -1);
	g_debug ("gkr-item.vala:263: Succesfully copied secret to clipboard");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseGkrItem*
seahorse_gkr_item_construct (GType object_type)
{
	SeahorseGkrItem * self = NULL;
	self = (SeahorseGkrItem*) g_object_new (object_type, NULL);
	return self;
}

SeahorseGkrItem*
seahorse_gkr_item_new (void)
{
	return seahorse_gkr_item_construct (SEAHORSE_GKR_TYPE_ITEM);
}

gchar*
seahorse_gkr_item_get_description (SeahorseGkrItem* self)
{
	gchar* result;
	SeahorseGkrItemInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	seahorse_gkr_item_ensure_item_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = seahorse_gkr_item_info_get_description (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

SeahorseGkrUse
seahorse_gkr_item_get_use (SeahorseGkrItem* self)
{
	SeahorseGkrUse result;
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = seahorse_gkr_item_get_attribute (self, "xdg:schema");
	schema_name = _tmp0_;
	_tmp2_ = schema_name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = schema_name;
		_tmp1_ = g_strcmp0 (_tmp3_, SEAHORSE_GKR_NETWORK_PASSWORD) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = SEAHORSE_GKR_USE_NETWORK;
		_g_free0 (schema_name);
		return result;
	}
	result = SEAHORSE_GKR_USE_OTHER;
	_g_free0 (schema_name);
	return result;
}

gboolean
seahorse_gkr_item_get_has_secret (SeahorseGkrItem* self)
{
	gboolean result;
	SecretValue* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_item_secret;
	result = _tmp0_ != NULL;
	return result;
}

SeahorseGkrKeyring*
seahorse_gkr_item_get_place (SeahorseGkrItem* self)
{
	SeahorseGkrKeyring* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_place);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	return result;
}

void
seahorse_gkr_item_set_place (SeahorseGkrItem* self,
                             SeahorseGkrKeyring* value)
{
	g_return_if_fail (self != NULL);
	g_weak_ref_set (&self->priv->_place, (GObject*) value);
	g_object_notify_by_pspec ((GObject *) self, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_PLACE_PROPERTY]);
}

SeahorseFlags
seahorse_gkr_item_get_object_flags (SeahorseGkrItem* self)
{
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = SEAHORSE_FLAG_DELETABLE | SEAHORSE_FLAG_PERSONAL;
	return result;
}

GIcon*
seahorse_gkr_item_get_icon (SeahorseGkrItem* self)
{
	GIcon* result;
	GIcon* _tmp0_ = NULL;
	SeahorseGkrItemInfo* _tmp1_;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	seahorse_gkr_item_ensure_item_info (self);
	_tmp1_ = self->priv->_info;
	_tmp2_ = seahorse_gkr_item_info_get_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		GThemedIcon* _tmp5_;
		_tmp5_ = (GThemedIcon*) g_themed_icon_new (SEAHORSE_ICON_PASSWORD);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GIcon*) _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_object_unref0 (_tmp0_);
	return result;
}

gchar*
seahorse_gkr_item_get_label (SeahorseGkrItem* self)
{
	gchar* result;
	SeahorseGkrItemInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	seahorse_gkr_item_ensure_item_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = seahorse_gkr_item_info_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gchar*
seahorse_gkr_item_get_markup (SeahorseGkrItem* self)
{
	gchar* result;
	GString* _result_ = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SeahorseGkrItemInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	SeahorseGkrItemInfo* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GString* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	seahorse_gkr_item_ensure_item_info (self);
	_tmp0_ = g_string_new ("");
	_result_ = _tmp0_;
	_tmp2_ = self->priv->_info;
	_tmp3_ = seahorse_gkr_item_info_get_label (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = _tmp4_;
	if (_tmp1_ == NULL) {
		_tmp1_ = "";
	}
	_tmp5_ = _result_;
	_tmp6_ = g_markup_escape_text (_tmp1_, (gssize) -1);
	_tmp7_ = _tmp6_;
	g_string_append (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp9_ = self->priv->_info;
	_tmp10_ = seahorse_gkr_item_info_get_details (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		SeahorseGkrItemInfo* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = self->priv->_info;
		_tmp13_ = seahorse_gkr_item_info_get_details (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp8_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GString* _tmp15_;
		GString* _tmp16_;
		SeahorseGkrItemInfo* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		GString* _tmp20_;
		_tmp15_ = _result_;
		g_string_append (_tmp15_, "<span size='small' rise='0' foreground='#555555'>\n");
		_tmp16_ = _result_;
		_tmp17_ = self->priv->_info;
		_tmp18_ = seahorse_gkr_item_info_get_details (_tmp17_);
		_tmp19_ = _tmp18_;
		g_string_append (_tmp16_, _tmp19_);
		_tmp20_ = _result_;
		g_string_append (_tmp20_, "</span>");
	}
	_tmp21_ = _result_;
	_tmp22_ = _tmp21_->str;
	_tmp23_ = g_strdup (_tmp22_);
	result = _tmp23_;
	_g_string_free0 (_result_);
	return result;
}

SeahorseUsage
seahorse_gkr_item_get_usage (SeahorseGkrItem* self)
{
	SeahorseUsage result;
	g_return_val_if_fail (self != NULL, 0);
	result = SEAHORSE_USAGE_CREDENTIALS;
	return result;
}

static gboolean
seahorse_gkr_item_real_get_deletable (SeahorseDeletable* base)
{
	gboolean result;
	SeahorseGkrItem* self;
	self = (SeahorseGkrItem*) base;
	result = TRUE;
	return result;
}

static void
_seahorse_gkr_item___lambda12_ (SeahorseGkrItem* self,
                                GVariant* changed_properties,
                                gchar** invalidated_properties)
{
	g_return_if_fail (changed_properties != NULL);
	_g_object_unref0 (self->priv->_info);
	self->priv->_info = NULL;
	g_object_freeze_notify ((GObject*) self);
	g_object_notify ((GObject*) self, "has-secret");
	g_object_notify ((GObject*) self, "use");
	g_object_notify ((GObject*) self, "label");
	g_object_notify ((GObject*) self, "icon");
	g_object_notify ((GObject*) self, "markup");
	g_object_notify ((GObject*) self, "description");
	g_object_notify ((GObject*) self, "object-flags");
	g_object_thaw_notify ((GObject*) self);
}

static void
__seahorse_gkr_item___lambda12__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                   GVariant* changed_properties,
                                                                   gchar** invalidated_properties,
                                                                   gpointer self)
{
	_seahorse_gkr_item___lambda12_ ((SeahorseGkrItem*) self, changed_properties, invalidated_properties);
}

static GObject *
seahorse_gkr_item_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrItem * self;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	g_signal_connect_object ((GDBusProxy*) self, "g-properties-changed", (GCallback) __seahorse_gkr_item___lambda12__g_dbus_proxy_g_properties_changed, self, 0);
	return obj;
}

static void
seahorse_gkr_item_class_init (SeahorseGkrItemClass * klass,
                              gpointer klass_data)
{
	seahorse_gkr_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrItem_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) seahorse_gkr_item_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DESCRIPTION_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USE_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_USE_PROPERTY] = g_param_spec_enum ("use", "use", "use", SEAHORSE_GKR_TYPE_USE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_HAS_SECRET_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_HAS_SECRET_PROPERTY] = g_param_spec_boolean ("has-secret", "has-secret", "has-secret", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_PLACE_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_PLACE_PROPERTY] = g_param_spec_object ("place", "place", "place", SEAHORSE_GKR_TYPE_KEYRING, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_OBJECT_FLAGS_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_OBJECT_FLAGS_PROPERTY] = g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_ICON_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_LABEL_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_MARKUP_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_MARKUP_PROPERTY] = g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USAGE_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_USAGE_PROPERTY] = g_param_spec_enum ("usage", "usage", "usage", SEAHORSE_TYPE_USAGE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DELETABLE_PROPERTY, seahorse_gkr_item_properties[SEAHORSE_GKR_ITEM_DELETABLE_PROPERTY] = g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_gkr_item_seahorse_deletable_interface_init (SeahorseDeletableIface * iface,
                                                     gpointer iface_data)
{
	seahorse_gkr_item_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_deleter = (SeahorseDeleter* (*) (SeahorseDeletable*)) seahorse_gkr_item_real_create_deleter;
	iface->get_deletable = seahorse_gkr_item_real_get_deletable;
}

static void
seahorse_gkr_item_seahorse_viewable_interface_init (SeahorseViewableIface * iface,
                                                    gpointer iface_data)
{
	seahorse_gkr_item_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_viewer = (GtkWindow* (*) (SeahorseViewable*, GtkWindow*)) seahorse_gkr_item_real_create_viewer;
}

static void
seahorse_gkr_item_instance_init (SeahorseGkrItem * self,
                                 gpointer klass)
{
	self->priv = seahorse_gkr_item_get_instance_private (self);
	self->priv->_item_secret = NULL;
	self->priv->_info = NULL;
	self->priv->_req_secret = NULL;
}

static void
seahorse_gkr_item_finalize (GObject * obj)
{
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	_secret_value_unref0 (self->priv->_item_secret);
	_g_object_unref0 (self->priv->_info);
	g_weak_ref_clear (&self->priv->_place);
	_g_object_unref0 (self->priv->_req_secret);
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->finalize (obj);
}

/**
 * The Seahorse-specific class for entries in a libsecret keyring.
 *
 * Since libsecret creates the object for us, we can't really add stuff using a
 * constructor, so to add specific info for certain categories of items, we
 * stuff everything into the {@link ItemInfo} field.
 */
 G_GNUC_NO_INLINE static GType
seahorse_gkr_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItem), 0, (GInstanceInitFunc) seahorse_gkr_item_instance_init, NULL };
	static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_gkr_item_type_id;
	seahorse_gkr_item_type_id = g_type_register_static (secret_item_get_type (), "SeahorseGkrItem", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
	g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
	SeahorseGkrItem_private_offset = g_type_add_instance_private (seahorse_gkr_item_type_id, sizeof (SeahorseGkrItemPrivate));
	return seahorse_gkr_item_type_id;
}

GType
seahorse_gkr_item_get_type (void)
{
	static volatile gsize seahorse_gkr_item_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_item_type_id__once)) {
		GType seahorse_gkr_item_type_id;
		seahorse_gkr_item_type_id = seahorse_gkr_item_get_type_once ();
		g_once_init_leave (&seahorse_gkr_item_type_id__once, seahorse_gkr_item_type_id);
	}
	return seahorse_gkr_item_type_id__once;
}

static void
_vala_seahorse_gkr_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_DESCRIPTION_PROPERTY:
		g_value_take_string (value, seahorse_gkr_item_get_description (self));
		break;
		case SEAHORSE_GKR_ITEM_USE_PROPERTY:
		g_value_set_enum (value, seahorse_gkr_item_get_use (self));
		break;
		case SEAHORSE_GKR_ITEM_HAS_SECRET_PROPERTY:
		g_value_set_boolean (value, seahorse_gkr_item_get_has_secret (self));
		break;
		case SEAHORSE_GKR_ITEM_PLACE_PROPERTY:
		g_value_take_object (value, seahorse_gkr_item_get_place (self));
		break;
		case SEAHORSE_GKR_ITEM_OBJECT_FLAGS_PROPERTY:
		g_value_set_flags (value, seahorse_gkr_item_get_object_flags (self));
		break;
		case SEAHORSE_GKR_ITEM_ICON_PROPERTY:
		g_value_take_object (value, seahorse_gkr_item_get_icon (self));
		break;
		case SEAHORSE_GKR_ITEM_LABEL_PROPERTY:
		g_value_take_string (value, seahorse_gkr_item_get_label (self));
		break;
		case SEAHORSE_GKR_ITEM_MARKUP_PROPERTY:
		g_value_take_string (value, seahorse_gkr_item_get_markup (self));
		break;
		case SEAHORSE_GKR_ITEM_USAGE_PROPERTY:
		g_value_set_enum (value, seahorse_gkr_item_get_usage (self));
		break;
		case SEAHORSE_GKR_ITEM_DELETABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_gkr_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_PLACE_PROPERTY:
		seahorse_gkr_item_set_place (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

SeahorseGkrMappingEntry*
seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self)
{
	SeahorseGkrMappingEntry* dup;
	dup = g_new0 (SeahorseGkrMappingEntry, 1);
	memcpy (dup, self, sizeof (SeahorseGkrMappingEntry));
	return dup;
}

void
seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_mapping_entry_get_type_once (void)
{
	GType seahorse_gkr_mapping_entry_type_id;
	seahorse_gkr_mapping_entry_type_id = g_boxed_type_register_static ("SeahorseGkrMappingEntry", (GBoxedCopyFunc) seahorse_gkr_mapping_entry_dup, (GBoxedFreeFunc) seahorse_gkr_mapping_entry_free);
	return seahorse_gkr_mapping_entry_type_id;
}

GType
seahorse_gkr_mapping_entry_get_type (void)
{
	static volatile gsize seahorse_gkr_mapping_entry_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_mapping_entry_type_id__once)) {
		GType seahorse_gkr_mapping_entry_type_id;
		seahorse_gkr_mapping_entry_type_id = seahorse_gkr_mapping_entry_get_type_once ();
		g_once_init_leave (&seahorse_gkr_mapping_entry_type_id__once, seahorse_gkr_mapping_entry_type_id);
	}
	return seahorse_gkr_mapping_entry_type_id__once;
}

const gchar*
seahorse_gkr_map_item_type_to_specific (const gchar* item_type,
                                        GHashTable* attrs)
{
	const gchar* result;
	if (item_type == NULL) {
		result = SEAHORSE_GKR_GENERIC_SECRET;
		return result;
	}
	if (attrs == NULL) {
		result = item_type;
		return result;
	}
	{
		SeahorseGkrMappingEntry* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = SEAHORSE_GKR_MAPPING_ENTRIES;
		mapping_collection_length1 = G_N_ELEMENTS (SEAHORSE_GKR_MAPPING_ENTRIES);
		for (mapping_it = 0; mapping_it < mapping_collection_length1; mapping_it = mapping_it + 1) {
			SeahorseGkrMappingEntry mapping = {0};
			mapping = mapping_collection[mapping_it];
			{
				SeahorseGkrMappingEntry _tmp0_;
				const gchar* _tmp1_;
				SeahorseGkrMappingEntry _tmp2_;
				const gchar* _tmp3_;
				const gchar* value = NULL;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				_tmp0_ = mapping;
				_tmp1_ = _tmp0_.item_type;
				if (g_strcmp0 (item_type, _tmp1_) != 0) {
					continue;
				}
				_tmp2_ = mapping;
				_tmp3_ = _tmp2_.match_attribute;
				if (_tmp3_ == NULL) {
					SeahorseGkrMappingEntry _tmp4_;
					const gchar* _tmp5_;
					_tmp4_ = mapping;
					_tmp5_ = _tmp4_.mapped_type;
					result = _tmp5_;
					return result;
				}
				value = NULL;
				if (attrs != NULL) {
					SeahorseGkrMappingEntry _tmp6_;
					const gchar* _tmp7_;
					gconstpointer _tmp8_;
					_tmp6_ = mapping;
					_tmp7_ = _tmp6_.match_attribute;
					_tmp8_ = g_hash_table_lookup (attrs, _tmp7_);
					value = (const gchar*) _tmp8_;
				}
				_tmp10_ = value;
				if (_tmp10_ != NULL) {
					SeahorseGkrMappingEntry _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = mapping;
					_tmp12_ = _tmp11_.match_pattern;
					_tmp9_ = _tmp12_ != NULL;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					SeahorseGkrMappingEntry _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp13_ = mapping;
					_tmp14_ = _tmp13_.match_pattern;
					_tmp15_ = value;
					if (g_pattern_match_simple (_tmp14_, _tmp15_)) {
						SeahorseGkrMappingEntry _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = mapping;
						_tmp17_ = _tmp16_.mapped_type;
						result = _tmp17_;
						return result;
					}
				} else {
					const gchar* _tmp18_;
					_tmp18_ = value;
					if (_tmp18_ != NULL) {
						SeahorseGkrMappingEntry _tmp19_;
						const gchar* _tmp20_;
						_tmp19_ = mapping;
						_tmp20_ = _tmp19_.mapped_type;
						result = _tmp20_;
						return result;
					}
				}
			}
		}
	}
	result = item_type;
	return result;
}

static inline gpointer
seahorse_gkr_item_deleter_get_instance_private (SeahorseGkrItemDeleter* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseGkrItemDeleter_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GtkDialog*
seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base,
                                               GtkWindow* parent)
{
	SeahorseGkrItemDeleter * self;
	guint num = 0U;
	GList* _tmp0_;
	GtkDialog* result;
	self = (SeahorseGkrItemDeleter*) base;
	_tmp0_ = self->priv->_items;
	num = g_list_length (_tmp0_);
	if (num == ((guint) 1)) {
		gchar* label = NULL;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		SeahorseDeleteDialog* _tmp6_;
		_tmp1_ = self->priv->_items;
		_tmp2_ = _tmp1_->data;
		g_object_get ((SecretRetrievable*) G_TYPE_CHECK_INSTANCE_CAST ((SeahorseGkrItem*) _tmp2_, secret_item_get_type (), SecretItem), "label", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		label = _tmp4_;
		_tmp5_ = label;
		_tmp6_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (parent, _ ("Are you sure you want to delete the password “%s”?"), _tmp5_, NULL);
		g_object_ref_sink (_tmp6_);
		result = (GtkDialog*) _tmp6_;
		_g_free0 (label);
		return result;
	} else {
		SeahorseDeleteDialog* _tmp7_;
		_tmp7_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (parent, ngettext ("Are you sure you want to delete %d password?", "Are you sure you want to delete %d passwords?", (gulong) num), num, NULL);
		g_object_ref_sink (_tmp7_);
		result = (GtkDialog*) _tmp7_;
		return result;
	}
}

SeahorseGkrItemDeleter*
seahorse_gkr_item_deleter_construct (GType object_type,
                                     SeahorseGkrItem* item)
{
	SeahorseGkrItemDeleter * self = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	self = (SeahorseGkrItemDeleter*) seahorse_deleter_construct (object_type);
	if (!seahorse_deleter_add_object ((SeahorseDeleter*) self, (GObject*) item)) {
		g_assert_not_reached ();
	}
	return self;
}

SeahorseGkrItemDeleter*
seahorse_gkr_item_deleter_new (SeahorseGkrItem* item)
{
	return seahorse_gkr_item_deleter_construct (SEAHORSE_GKR_TYPE_ITEM_DELETER, item);
}

static GList*
seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base)
{
	SeahorseGkrItemDeleter * self;
	GList* _tmp0_;
	GList* result;
	self = (SeahorseGkrItemDeleter*) base;
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}

static gboolean
seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base,
                                           GObject* obj)
{
	SeahorseGkrItemDeleter * self;
	gboolean result;
	self = (SeahorseGkrItemDeleter*) base;
	g_return_val_if_fail (obj != NULL, FALSE);
	if (SEAHORSE_GKR_IS_ITEM (obj)) {
		SeahorseGkrItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
		self->priv->_items = g_list_append (self->priv->_items, _tmp0_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data)
{
	SeahorseGkrItemDeleterDeleteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemDeleterDeleteData, _data_);
}

static void
seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	SeahorseGkrItemDeleter * self;
	SeahorseGkrItemDeleterDeleteData* _data_;
	SeahorseGkrItemDeleter* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorseGkrItemDeleter*) base;
	_data_ = g_slice_new0 (SeahorseGkrItemDeleterDeleteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_gkr_item_deleter_real_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_gkr_item_deleter_real_delete_co (_data_);
}

static gboolean
seahorse_gkr_item_deleter_delete_finish (SeahorseDeleter* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	gboolean result;
	SeahorseGkrItemDeleterDeleteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_gkr_item_deleter_delete_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SeahorseGkrItemDeleterDeleteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_deleter_real_delete_co (_data_);
}

static gboolean
seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_items;
	_data_->_tmp1_ = g_list_copy (_data_->_tmp0_);
	_data_->items = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->items;
	{
		_data_->item_collection = _data_->_tmp2_;
		for (_data_->item_it = _data_->item_collection; _data_->item_it != NULL; _data_->item_it = _data_->item_it->next) {
			_data_->item = (SeahorseGkrItem*) _data_->item_it->data;
			{
				_data_->_tmp3_ = _data_->item;
				_data_->_state_ = 1;
				secret_item_delete ((SecretItem*) _data_->_tmp3_, _data_->cancellable, seahorse_gkr_item_deleter_delete_ready, _data_);
				return FALSE;
				_state_1:
				secret_item_delete_finish ((SecretItem*) _data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					(_data_->items == NULL) ? NULL : (_data_->items = (g_list_free (_data_->items), NULL));
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
	_data_->result = TRUE;
	(_data_->items == NULL) ? NULL : (_data_->items = (g_list_free (_data_->items), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_gkr_item_deleter_class_init (SeahorseGkrItemDeleterClass * klass,
                                      gpointer klass_data)
{
	seahorse_gkr_item_deleter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseGkrItemDeleter_private_offset);
	((SeahorseDeleterClass *) klass)->create_confirm = (GtkDialog* (*) (SeahorseDeleter*, GtkWindow*)) seahorse_gkr_item_deleter_real_create_confirm;
	((SeahorseDeleterClass *) klass)->get_objects = (GList* (*) (SeahorseDeleter*)) seahorse_gkr_item_deleter_real_get_objects;
	((SeahorseDeleterClass *) klass)->add_object = (gboolean (*) (SeahorseDeleter*, GObject*)) seahorse_gkr_item_deleter_real_add_object;
	((SeahorseDeleterClass *) klass)->delete = (void (*) (SeahorseDeleter*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_gkr_item_deleter_real_delete;
	((SeahorseDeleterClass *) klass)->delete_finish = (gboolean (*) (SeahorseDeleter*, GAsyncResult*, GError**)) seahorse_gkr_item_deleter_delete_finish;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_deleter_finalize;
}

static void
seahorse_gkr_item_deleter_instance_init (SeahorseGkrItemDeleter * self,
                                         gpointer klass)
{
	self->priv = seahorse_gkr_item_deleter_get_instance_private (self);
}

static void
seahorse_gkr_item_deleter_finalize (GObject * obj)
{
	SeahorseGkrItemDeleter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter);
	(self->priv->_items == NULL) ? NULL : (self->priv->_items = (_g_list_free__g_object_unref0_ (self->priv->_items), NULL));
	G_OBJECT_CLASS (seahorse_gkr_item_deleter_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_gkr_item_deleter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemDeleterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_deleter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemDeleter), 0, (GInstanceInitFunc) seahorse_gkr_item_deleter_instance_init, NULL };
	GType seahorse_gkr_item_deleter_type_id;
	seahorse_gkr_item_deleter_type_id = g_type_register_static (SEAHORSE_TYPE_DELETER, "SeahorseGkrItemDeleter", &g_define_type_info, 0);
	SeahorseGkrItemDeleter_private_offset = g_type_add_instance_private (seahorse_gkr_item_deleter_type_id, sizeof (SeahorseGkrItemDeleterPrivate));
	return seahorse_gkr_item_deleter_type_id;
}

GType
seahorse_gkr_item_deleter_get_type (void)
{
	static volatile gsize seahorse_gkr_item_deleter_type_id__once = 0;
	if (g_once_init_enter (&seahorse_gkr_item_deleter_type_id__once)) {
		GType seahorse_gkr_item_deleter_type_id;
		seahorse_gkr_item_deleter_type_id = seahorse_gkr_item_deleter_get_type_once ();
		g_once_init_leave (&seahorse_gkr_item_deleter_type_id__once, seahorse_gkr_item_deleter_type_id);
	}
	return seahorse_gkr_item_deleter_type_id__once;
}

