/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;

public final class IntCounter
extends PrimitiveCounter {
    private int size;
    private final int[] keys;
    private final int[] counts;

    public IntCounter(int bufferSize) {
        bufferSize = bufferSize * 9 / 8;
        this.keys = new int[bufferSize];
        this.counts = new int[bufferSize];
    }

    public void count(int key) {
        int idx;
        int index = idx = this.hash(key);
        while (this.keys[index] != key && this.counts[index] != 0) {
            if ((index = this.incIndex(index)) != idx) continue;
            throw new RuntimeException("Full when counting " + key);
        }
        if (this.counts[index] == 0) {
            this.keys[index] = key;
            ++this.size;
        }
        int n = index;
        this.counts[n] = this.counts[n] + 1;
    }

    @Override
    public void count(String value) {
        this.count(Integer.parseInt(value));
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    private int hash(int key) {
        return Math.abs(key % this.keys.length);
    }

    private int incIndex(int index) {
        return ++index < this.keys.length ? index : 0;
    }

    public final class Iterator
    implements java.util.Iterator<Record> {
        private int index;
        private int count;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IntCounter.this.size;
        }

        @Override
        public Record next() {
            Record entry = new Record();
            entry.count = IntCounter.this.counts[this.index];
            while (entry.count == 0) {
                entry.count = IntCounter.this.counts[++this.index];
            }
            entry.value = IntCounter.this.keys[this.index++];
            ++this.count;
            return entry;
        }
    }

    public static final class Record
    extends PrimitiveCounter.Record {
        private int value;
        private int count;

        private Record() {
        }

        public int getPrimitive() {
            return this.value;
        }

        @Override
        public String getValue() {
            return Integer.toString(this.value);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            return this.value == ((Record)o).value;
        }
    }
}

