/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.jdk89acesses;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JarIndexAccess {
    private static Class<?> jarIndexClass;
    private final Object parent;

    private JarIndexAccess(Object parent) {
        if (parent == null) {
            throw new RuntimeException("JarFile can notbe null!");
        }
        this.parent = parent;
    }

    public static JarIndexAccess getJarIndex(JarFile jarFile) throws IOException {
        try {
            return JarIndexAccess.getJarIndexImpl(jarFile);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static JarIndexAccess getJarIndexImpl(JarFile jarFile) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = jarIndexClass.getMethod("getJarIndex", JarFile.class);
        Object o = method.invoke(null, jarFile);
        if (o == null) {
            return null;
        }
        return new JarIndexAccess(o);
    }

    public LinkedList<String> get(String replace) {
        try {
            return this.getImpl(replace);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public LinkedList<String> getImpl(String replace) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = jarIndexClass.getMethod("get", String.class);
        Object o = method.invoke(this.parent, replace);
        return (LinkedList)o;
    }

    static {
        try {
            jarIndexClass = Class.forName("sun.misc.JarIndex");
        }
        catch (ClassNotFoundException ex) {
            try {
                OutputController.getLogger().log(ex);
                OutputController.getLogger().log("Running jdk9+ ?");
                jarIndexClass = Class.forName("jdk.internal.util.jar.JarIndex");
            }
            catch (ClassNotFoundException exx) {
                OutputController.getLogger().log(exx);
                throw new RuntimeException("JarIndex not found!");
            }
        }
    }
}

