/* settings.c generated by valac 0.56.3, the Vala compiler
 * generated from settings.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2017-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>
#include <libnotify/notify.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_POWER_SCREEN (budgie_power_screen_get_type ())
#define BUDGIE_POWER_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_POWER_SCREEN, BudgiePowerScreen))
#define BUDGIE_IS_POWER_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_POWER_SCREEN))
#define BUDGIE_POWER_SCREEN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_POWER_SCREEN, BudgiePowerScreenIface))

typedef struct _BudgiePowerScreen BudgiePowerScreen;
typedef struct _BudgiePowerScreenIface BudgiePowerScreenIface;

#define BUDGIE_TYPE_POWER_SCREEN_PROXY (budgie_power_screen_proxy_get_type ())
typedef GDBusProxy BudgiePowerScreenProxy;
typedef GDBusProxyClass BudgiePowerScreenProxyClass;
typedef enum  {
	BUDGIE_BUTTON_POSITION_LEFT = 1 << 0,
	BUDGIE_BUTTON_POSITION_TRADITIONAL = 1 << 1
} BudgieButtonPosition;

#define BUDGIE_TYPE_BUTTON_POSITION (budgie_button_position_get_type ())

#define BUDGIE_TYPE_SETTINGS_MANAGER (budgie_settings_manager_get_type ())
#define BUDGIE_SETTINGS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_MANAGER, BudgieSettingsManager))
#define BUDGIE_SETTINGS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_MANAGER, BudgieSettingsManagerClass))
#define BUDGIE_IS_SETTINGS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_MANAGER))
#define BUDGIE_IS_SETTINGS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_MANAGER))
#define BUDGIE_SETTINGS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_MANAGER, BudgieSettingsManagerClass))

typedef struct _BudgieSettingsManager BudgieSettingsManager;
typedef struct _BudgieSettingsManagerClass BudgieSettingsManagerClass;
typedef struct _BudgieSettingsManagerPrivate BudgieSettingsManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _BudgieParamSpecSettingsManager BudgieParamSpecSettingsManager;

struct _BudgiePowerScreenIface {
	GTypeInterface parent_iface;
	gint32 (*get_brightness) (BudgiePowerScreen* self);
	void (*set_brightness) (BudgiePowerScreen* self, gint32 value);
};

struct _BudgieSettingsManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieSettingsManagerPrivate * priv;
};

struct _BudgieSettingsManagerClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieSettingsManager *self);
};

struct _BudgieSettingsManagerPrivate {
	GApplication* _parent_app;
	GSettings* mutter_settings;
	GSettings* gnome_desktop_settings;
	GSettings* gnome_power_settings;
	BudgiePowerScreen* gnome_power_props;
	GSettings* gnome_session_settings;
	GSettings* gnome_sound_settings;
	GSettings* gnome_wm_settings;
	GSettings* raven_settings;
	GSettings* wm_settings;
	GSettings* xoverrides;
	gint32* default_brightness;
	guint32* default_idle_delay;
	gboolean* default_idle_dim;
	gint* default_sleep_inactive_ac_timeout;
	gint* default_sleep_inactive_battery_timeout;
	gchar* caffeine_full_cup;
	gchar* caffeine_empty_cup;
	NotifyNotification* caffeine_notification;
	gboolean temporary_notification_disabled;
};

struct _BudgieParamSpecSettingsManager {
	GParamSpec parent_instance;
};

static gint BudgieSettingsManager_private_offset;
static gpointer budgie_settings_manager_parent_class = NULL;

VALA_EXTERN GType budgie_power_screen_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePowerScreen, g_object_unref)
VALA_EXTERN GType budgie_power_screen_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_power_screen_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN gint32 budgie_power_screen_get_brightness (BudgiePowerScreen* self);
VALA_EXTERN void budgie_power_screen_set_brightness (BudgiePowerScreen* self,
                                         gint32 value);
static GType budgie_power_screen_get_type_once (void);
static void budgie_power_screen_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static gint32 budgie_power_screen_dbus_proxy_get_brightness (BudgiePowerScreen* self);
static void budgie_power_screen_dbus_proxy_set_brightness (BudgiePowerScreen* self,
                                                    gint32 value);
static void budgie_power_screen_proxy_budgie_power_screen_interface_init (BudgiePowerScreenIface* iface);
static void budgie_power_screen_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_power_screen_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static GVariant* _dbus_budgie_power_screen_get_brightness (BudgiePowerScreen* self);
static gboolean budgie_power_screen_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_budgie_power_screen_set_brightness (BudgiePowerScreen* self,
                                               GVariant* _value);
static void _budgie_power_screen_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_button_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer budgie_settings_manager_ref (gpointer instance);
VALA_EXTERN void budgie_settings_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_settings_manager (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void budgie_value_set_settings_manager (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void budgie_value_take_settings_manager (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_settings_manager (const GValue* value);
VALA_EXTERN GType budgie_settings_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsManager, budgie_settings_manager_unref)
static gint32* _int32_dup (gint32* self);
static guint32* _uint32_dup (guint32* self);
static gboolean* _bool_dup (gboolean* self);
static gint* _int_dup (gint* self);
VALA_EXTERN BudgieSettingsManager* budgie_settings_manager_new (void);
VALA_EXTERN BudgieSettingsManager* budgie_settings_manager_construct (GType object_type);
static void budgie_settings_manager_set_supported_caffeine_icons (BudgieSettingsManager* self);
static void budgie_settings_manager_fetch_defaults (BudgieSettingsManager* self);
static void budgie_settings_manager_enforce_mutter_settings (BudgieSettingsManager* self);
static void budgie_settings_manager_on_raven_sound_overdrive_change (BudgieSettingsManager* self);
static void _budgie_settings_manager_on_raven_sound_overdrive_change_g_settings_changed (GSettings* _sender,
                                                                                  const gchar* key,
                                                                                  gpointer self);
static void budgie_settings_manager_update_idle_delay (BudgieSettingsManager* self);
static void _budgie_settings_manager_update_idle_delay_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self);
static void budgie_settings_manager_update_idle_dim (BudgieSettingsManager* self);
static void _budgie_settings_manager_update_idle_dim_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self);
static void budgie_settings_manager_update_ac_timeout (BudgieSettingsManager* self);
static void _budgie_settings_manager_update_ac_timeout_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self);
static void budgie_settings_manager_update_battery_timeout (BudgieSettingsManager* self);
static void _budgie_settings_manager_update_battery_timeout_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self);
static void budgie_settings_manager_on_wm_settings_changed (BudgieSettingsManager* self,
                                                     const gchar* key);
static void _budgie_settings_manager_on_wm_settings_changed_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self);
static void budgie_settings_manager_caffeine_settings_sync (BudgieSettingsManager* self);
static void budgie_settings_manager_change_brightness (BudgieSettingsManager* self,
                                                gint32 value);
static gboolean budgie_settings_manager_do_disable (BudgieSettingsManager* self);
static gboolean budgie_settings_manager_get_caffeine_mode (BudgieSettingsManager* self);
static void budgie_settings_manager_reset_values (BudgieSettingsManager* self);
VALA_EXTERN void budgie_settings_manager_do_disable_quietly (BudgieSettingsManager* self);
static void budgie_settings_manager_get_power_defaults (BudgieSettingsManager* self);
static GVariant* budgie_settings_manager_new_filtered_xsetting (BudgieSettingsManager* self,
                                                         const gchar* button_layout);
static void budgie_settings_manager_set_button_style (BudgieSettingsManager* self,
                                               BudgieButtonPosition style);
static void budgie_settings_manager_set_caffeine_mode (BudgieSettingsManager* self,
                                                gboolean enabled,
                                                gboolean disable_notification);
static void budgie_settings_manager_set_focus_mode (BudgieSettingsManager* self,
                                             gboolean enable);
static GVariant* _variant_new1 (const gchar* value);
static gboolean ____lambda26_ (BudgieSettingsManager* self);
static gboolean _____lambda26__gsource_func (gpointer self);
static gboolean _budgie_settings_manager_do_disable_gsource_func (gpointer self);
static gboolean ___lambda27_ (BudgieSettingsManager* self);
static gboolean ____lambda27__gsource_func (gpointer self);
static gboolean ___lambda28_ (BudgieSettingsManager* self);
static gboolean ____lambda28__gsource_func (gpointer self);
static GVariant* _variant_new2 (const gchar* value);
VALA_EXTERN GApplication* budgie_settings_manager_get_parent_app (BudgieSettingsManager* self);
VALA_EXTERN void budgie_settings_manager_set_parent_app (BudgieSettingsManager* self,
                                             GApplication* value);
static void budgie_settings_manager_finalize (BudgieSettingsManager * obj);
static GType budgie_settings_manager_get_type_once (void);

static const GDBusMethodInfo * const _budgie_power_screen_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _budgie_power_screen_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _budgie_power_screen_dbus_property_info_brightness = {-1, "Brightness", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _budgie_power_screen_dbus_property_info[] = {&_budgie_power_screen_dbus_property_info_brightness, NULL};
static const GDBusInterfaceInfo _budgie_power_screen_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Power.Screen", (GDBusMethodInfo **) (&_budgie_power_screen_dbus_method_info), (GDBusSignalInfo **) (&_budgie_power_screen_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_power_screen_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_power_screen_dbus_interface_vtable = {budgie_power_screen_dbus_interface_method_call, budgie_power_screen_dbus_interface_get_property, budgie_power_screen_dbus_interface_set_property};

gint32
budgie_power_screen_get_brightness (BudgiePowerScreen* self)
{
	BudgiePowerScreenIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = BUDGIE_POWER_SCREEN_GET_INTERFACE (self);
	if (_iface_->get_brightness) {
		return _iface_->get_brightness (self);
	}
	return -1;
}

void
budgie_power_screen_set_brightness (BudgiePowerScreen* self,
                                    gint32 value)
{
	BudgiePowerScreenIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BUDGIE_POWER_SCREEN_GET_INTERFACE (self);
	if (_iface_->set_brightness) {
		_iface_->set_brightness (self, value);
	}
}

static void
budgie_power_screen_default_init (BudgiePowerScreenIface * iface,
                                  gpointer iface_data)
{
}

static GType
budgie_power_screen_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePowerScreenIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_power_screen_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_power_screen_type_id;
	budgie_power_screen_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgiePowerScreen", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_power_screen_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_power_screen_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_power_screen_proxy_get_type);
	g_type_set_qdata (budgie_power_screen_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Power.Screen");
	g_type_set_qdata (budgie_power_screen_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_power_screen_dbus_interface_info));
	g_type_set_qdata (budgie_power_screen_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_power_screen_register_object);
	return budgie_power_screen_type_id;
}

GType
budgie_power_screen_get_type (void)
{
	static volatile gsize budgie_power_screen_type_id__once = 0;
	if (g_once_init_enter (&budgie_power_screen_type_id__once)) {
		GType budgie_power_screen_type_id;
		budgie_power_screen_type_id = budgie_power_screen_get_type_once ();
		g_once_init_leave (&budgie_power_screen_type_id__once, budgie_power_screen_type_id);
	}
	return budgie_power_screen_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgiePowerScreenProxy, budgie_power_screen_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_POWER_SCREEN, budgie_power_screen_proxy_budgie_power_screen_interface_init) )
static void
budgie_power_screen_proxy_class_init (BudgiePowerScreenProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_power_screen_proxy_g_signal;
}

static void
budgie_power_screen_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
budgie_power_screen_proxy_init (BudgiePowerScreenProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_power_screen_dbus_interface_info));
}

static gint32
budgie_power_screen_dbus_proxy_get_brightness (BudgiePowerScreen* self)
{
	GVariant *_inner_reply;
	gint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Brightness");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint32 _tmp45_ = 0;
			return _tmp45_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
budgie_power_screen_dbus_proxy_set_brightness (BudgiePowerScreen* self,
                                               gint32 value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
budgie_power_screen_proxy_budgie_power_screen_interface_init (BudgiePowerScreenIface* iface)
{
	iface->get_brightness = budgie_power_screen_dbus_proxy_get_brightness;
	iface->set_brightness = budgie_power_screen_dbus_proxy_set_brightness;
}

static void
budgie_power_screen_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_budgie_power_screen_get_brightness (BudgiePowerScreen* self)
{
	gint32 result;
	GVariant* _reply;
	result = budgie_power_screen_get_brightness (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
budgie_power_screen_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		return _dbus_budgie_power_screen_get_brightness (object);
	}
	return NULL;
}

static void
_dbus_budgie_power_screen_set_brightness (BudgiePowerScreen* self,
                                          GVariant* _value)
{
	gint32 value = 0;
	value = g_variant_get_int32 (_value);
	budgie_power_screen_set_brightness (self, value);
}

static gboolean
budgie_power_screen_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		_dbus_budgie_power_screen_set_brightness (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
budgie_power_screen_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_power_screen_dbus_interface_info), &_budgie_power_screen_dbus_interface_vtable, data, _budgie_power_screen_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_power_screen_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

/**
* The button layout style as set in budgie
*/
static GType
budgie_button_position_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_BUTTON_POSITION_LEFT, "BUDGIE_BUTTON_POSITION_LEFT", "left"}, {BUDGIE_BUTTON_POSITION_TRADITIONAL, "BUDGIE_BUTTON_POSITION_TRADITIONAL", "traditional"}, {0, NULL, NULL}};
	GType budgie_button_position_type_id;
	budgie_button_position_type_id = g_enum_register_static ("BudgieButtonPosition", values);
	return budgie_button_position_type_id;
}

GType
budgie_button_position_get_type (void)
{
	static volatile gsize budgie_button_position_type_id__once = 0;
	if (g_once_init_enter (&budgie_button_position_type_id__once)) {
		GType budgie_button_position_type_id;
		budgie_button_position_type_id = budgie_button_position_get_type_once ();
		g_once_init_leave (&budgie_button_position_type_id__once, budgie_button_position_type_id);
	}
	return budgie_button_position_type_id__once;
}

static inline gpointer
budgie_settings_manager_get_instance_private (BudgieSettingsManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSettingsManager_private_offset);
}

static gint32*
_int32_dup (gint32* self)
{
	gint32* dup;
	dup = g_new0 (gint32, 1);
	memcpy (dup, self, sizeof (gint32));
	return dup;
}

static gpointer
__int32_dup0 (gpointer self)
{
	return self ? _int32_dup (self) : NULL;
}

static guint32*
_uint32_dup (guint32* self)
{
	guint32* dup;
	dup = g_new0 (guint32, 1);
	memcpy (dup, self, sizeof (guint32));
	return dup;
}

static gpointer
__uint32_dup0 (gpointer self)
{
	return self ? _uint32_dup (self) : NULL;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
_budgie_settings_manager_on_raven_sound_overdrive_change_g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self)
{
	budgie_settings_manager_on_raven_sound_overdrive_change ((BudgieSettingsManager*) self);
}

static void
_budgie_settings_manager_update_idle_delay_g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self)
{
	budgie_settings_manager_update_idle_delay ((BudgieSettingsManager*) self);
}

static void
_budgie_settings_manager_update_idle_dim_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self)
{
	budgie_settings_manager_update_idle_dim ((BudgieSettingsManager*) self);
}

static void
_budgie_settings_manager_update_ac_timeout_g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self)
{
	budgie_settings_manager_update_ac_timeout ((BudgieSettingsManager*) self);
}

static void
_budgie_settings_manager_update_battery_timeout_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self)
{
	budgie_settings_manager_update_battery_timeout ((BudgieSettingsManager*) self);
}

static void
_budgie_settings_manager_on_wm_settings_changed_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self)
{
	budgie_settings_manager_on_wm_settings_changed ((BudgieSettingsManager*) self, key);
}

BudgieSettingsManager*
budgie_settings_manager_construct (GType object_type)
{
	BudgieSettingsManager* self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GError* _inner_error0_ = NULL;
	self = (BudgieSettingsManager*) g_type_create_instance (object_type);
	notify_init ("com.solus-project.budgie-daemon");
	budgie_settings_manager_set_supported_caffeine_icons (self);
	_tmp0_ = g_settings_new ("org.gnome.mutter");
	_g_object_unref0 (self->priv->mutter_settings);
	self->priv->mutter_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->gnome_desktop_settings);
	self->priv->gnome_desktop_settings = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.settings-daemon.plugins.power");
	_g_object_unref0 (self->priv->gnome_power_settings);
	self->priv->gnome_power_settings = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.desktop.session");
	_g_object_unref0 (self->priv->gnome_session_settings);
	self->priv->gnome_session_settings = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.desktop.sound");
	_g_object_unref0 (self->priv->gnome_sound_settings);
	self->priv->gnome_sound_settings = _tmp4_;
	_tmp5_ = g_settings_new ("org.gnome.desktop.wm.preferences");
	_g_object_unref0 (self->priv->gnome_wm_settings);
	self->priv->gnome_wm_settings = _tmp5_;
	_tmp6_ = g_settings_new ("com.solus-project.budgie-raven");
	_g_object_unref0 (self->priv->raven_settings);
	self->priv->raven_settings = _tmp6_;
	_tmp7_ = g_settings_new ("org.gnome.settings-daemon.plugins.xsettings");
	_g_object_unref0 (self->priv->xoverrides);
	self->priv->xoverrides = _tmp7_;
	_tmp8_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->wm_settings);
	self->priv->wm_settings = _tmp8_;
	{
		BudgiePowerScreen* _tmp9_ = NULL;
		BudgiePowerScreen* _tmp10_;
		BudgiePowerScreen* _tmp11_;
		_tmp10_ = (BudgiePowerScreen*) g_initable_new (BUDGIE_TYPE_POWER_SCREEN_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.gnome.SettingsDaemon.Power", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SettingsDaemon/Power", "g-interface-name", "org.gnome.SettingsDaemon.Power.Screen", NULL);
		_tmp9_ = (BudgiePowerScreen*) _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp11_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (self->priv->gnome_power_props);
		self->priv->gnome_power_props = _tmp11_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("settings.vala:86: Failed to acquire bus for org.gnome.SettingsDaemon.P" \
"ower: %s\n", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	budgie_settings_manager_fetch_defaults (self);
	budgie_settings_manager_enforce_mutter_settings (self);
	_tmp14_ = self->priv->raven_settings;
	g_signal_connect (_tmp14_, "changed::allow-volume-overdrive", (GCallback) _budgie_settings_manager_on_raven_sound_overdrive_change_g_settings_changed, self);
	_tmp15_ = self->priv->gnome_session_settings;
	g_signal_connect (_tmp15_, "changed::idle-delay", (GCallback) _budgie_settings_manager_update_idle_delay_g_settings_changed, self);
	_tmp16_ = self->priv->gnome_power_settings;
	g_signal_connect (_tmp16_, "changed::idle-dim", (GCallback) _budgie_settings_manager_update_idle_dim_g_settings_changed, self);
	_tmp17_ = self->priv->gnome_power_settings;
	g_signal_connect (_tmp17_, "changed::sleep-inactive-ac-timeout", (GCallback) _budgie_settings_manager_update_ac_timeout_g_settings_changed, self);
	_tmp18_ = self->priv->gnome_power_settings;
	g_signal_connect (_tmp18_, "changed::sleep-inactive-battery-timeout", (GCallback) _budgie_settings_manager_update_battery_timeout_g_settings_changed, self);
	_tmp19_ = self->priv->wm_settings;
	g_signal_connect (_tmp19_, "changed", (GCallback) _budgie_settings_manager_on_wm_settings_changed_g_settings_changed, self);
	budgie_settings_manager_on_wm_settings_changed (self, "button-style");
	return self;
}

BudgieSettingsManager*
budgie_settings_manager_new (void)
{
	return budgie_settings_manager_construct (BUDGIE_TYPE_SETTINGS_MANAGER);
}

/**
* caffeine_settings_sync will call to sync / ensure write operations for session and power, which are relevant to Caffeine Mode
*/
static void
budgie_settings_manager_caffeine_settings_sync (BudgieSettingsManager* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gnome_session_settings;
	g_settings_apply (_tmp0_);
	_tmp1_ = self->priv->gnome_power_settings;
	g_settings_apply (_tmp1_);
	g_settings_sync ();
	g_settings_sync ();
}

/**
* change_brightness will attempt to change our brightness in the power properties
*/
static void
budgie_settings_manager_change_brightness (BudgieSettingsManager* self,
                                           gint32 value)
{
	BudgiePowerScreen* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gnome_power_props;
	if (_tmp0_ != NULL) {
		{
			BudgiePowerScreen* _tmp1_;
			_tmp1_ = self->priv->gnome_power_props;
			budgie_power_screen_set_brightness (_tmp1_, value);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("settings.vala:121: Error: Failed to change change the brightness durin" \
"g Caffeine Mode toggle.");
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
* do_disable is triggered when our timeout is called
*/
static gboolean
budgie_settings_manager_do_disable (BudgieSettingsManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (budgie_settings_manager_get_caffeine_mode (self)) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->wm_settings;
		g_settings_set_boolean (_tmp0_, "caffeine-mode", FALSE);
		g_settings_sync ();
		budgie_settings_manager_reset_values (self);
	}
	result = FALSE;
	return result;
}

/**
* do_disable_quietly will quietly disable Caffeine Mode
*/
void
budgie_settings_manager_do_disable_quietly (BudgieSettingsManager* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->temporary_notification_disabled = TRUE;
	_tmp0_ = self->priv->wm_settings;
	g_settings_set_boolean (_tmp0_, "caffeine-mode", FALSE);
	g_settings_sync ();
	budgie_settings_manager_reset_values (self);
}

/**
* enforce_mutter_settings will apply Mutter schema changes to BudgieWM for supported keys
*/
static void
budgie_settings_manager_enforce_mutter_settings (BudgieSettingsManager* self)
{
	gboolean center_windows = FALSE;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mutter_settings;
	center_windows = g_settings_get_boolean (_tmp0_, "center-new-windows");
	_tmp1_ = self->priv->wm_settings;
	g_settings_set_boolean (_tmp1_, "center-windows", center_windows);
}

/**
* fetch_defaults will fetch the default values for various idle, sleep, and brightness settings
*/
static void
budgie_settings_manager_fetch_defaults (BudgieSettingsManager* self)
{
	BudgiePowerScreen* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (budgie_settings_manager_get_caffeine_mode (self)) {
		GSettings* _tmp0_;
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp0_ = self->priv->gnome_session_settings;
		g_settings_reset (_tmp0_, "idle-delay");
		_tmp1_ = self->priv->gnome_power_settings;
		g_settings_reset (_tmp1_, "idle-dim");
		_tmp2_ = self->priv->gnome_power_settings;
		g_settings_reset (_tmp2_, "sleep-inactive-ac-timeout");
		_tmp3_ = self->priv->gnome_power_settings;
		g_settings_reset (_tmp3_, "sleep-inactive-battery-timeout");
		budgie_settings_manager_caffeine_settings_sync (self);
		self->priv->temporary_notification_disabled = TRUE;
		_tmp4_ = self->priv->wm_settings;
		g_settings_set_boolean (_tmp4_, "caffeine-mode", FALSE);
		g_settings_sync ();
	}
	budgie_settings_manager_get_power_defaults (self);
	_tmp5_ = self->priv->gnome_power_props;
	if (_tmp5_ != NULL) {
		{
			BudgiePowerScreen* _tmp6_;
			gint32 _tmp7_;
			gint32 _tmp8_;
			gint32* _tmp9_;
			_tmp6_ = self->priv->gnome_power_props;
			_tmp7_ = budgie_power_screen_get_brightness (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = __int32_dup0 (&_tmp8_);
			_g_free0 (self->priv->default_brightness);
			self->priv->default_brightness = _tmp9_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("settings.vala:180: Could not set default value.");
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
* get_caffeine_mode will get the current Caffeine Mode status
*/
static gboolean
budgie_settings_manager_get_caffeine_mode (BudgieSettingsManager* self)
{
	GSettings* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->wm_settings;
	result = g_settings_get_boolean (_tmp0_, "caffeine-mode");
	return result;
}

/**
* get_power_defaults will call all of our update defaults functions
*/
static void
budgie_settings_manager_get_power_defaults (BudgieSettingsManager* self)
{
	g_return_if_fail (self != NULL);
	budgie_settings_manager_update_ac_timeout (self);
	budgie_settings_manager_update_battery_timeout (self);
	budgie_settings_manager_update_idle_delay (self);
	budgie_settings_manager_update_idle_dim (self);
}

/**
* Create a new xsettings override based on the *Existing* key so that
* we don't dump any settings like Gdk/ScaleFactor, etc.
*/
static GVariant*
budgie_settings_manager_new_filtered_xsetting (BudgieSettingsManager* self,
                                               const gchar* button_layout)
{
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariantBuilder* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* existing_vars = NULL;
	GSettings* _tmp10_;
	GVariant* _tmp11_;
	GVariantIter* it = NULL;
	GVariant* _tmp12_;
	GVariantIter* _tmp13_;
	gchar* k = NULL;
	GVariant* v = NULL;
	GVariantBuilder* _tmp21_;
	GVariant* _tmp22_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (button_layout != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a{sv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	_tmp4_ = builder;
	_tmp5_ = g_variant_new_int32 ((gint32) 0);
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	g_variant_builder_add (_tmp4_, "{sv}", "Gtk/ShellShowsAppMenu", _tmp6_, NULL);
	_g_variant_unref0 (_tmp6_);
	_tmp7_ = builder;
	_tmp8_ = g_variant_new_string (button_layout);
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	g_variant_builder_add (_tmp7_, "{sv}", "Gtk/DecorationLayout", _tmp9_, NULL);
	_g_variant_unref0 (_tmp9_);
	_tmp10_ = self->priv->xoverrides;
	_tmp11_ = g_settings_get_value (_tmp10_, "overrides");
	existing_vars = _tmp11_;
	_tmp12_ = existing_vars;
	_tmp13_ = g_variant_iter_new (_tmp12_);
	it = _tmp13_;
	k = NULL;
	v = NULL;
	while (TRUE) {
		GVariantIter* _tmp14_;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_;
		GVariantBuilder* _tmp18_;
		const gchar* _tmp19_;
		GVariant* _tmp20_;
		_tmp14_ = it;
		if (!g_variant_iter_next (_tmp14_, "{sv}", &k, &v, NULL)) {
			break;
		}
		_tmp16_ = k;
		if (g_strcmp0 (_tmp16_, "Gtk/ShellShowsAppMenu") == 0) {
			_tmp15_ = TRUE;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = k;
			_tmp15_ = g_strcmp0 (_tmp17_, "Gtk/DecorationLayout") == 0;
		}
		if (_tmp15_) {
			continue;
		}
		_tmp18_ = builder;
		_tmp19_ = k;
		_tmp20_ = v;
		g_variant_builder_add (_tmp18_, "{sv}", _tmp19_, _tmp20_, NULL);
	}
	_tmp21_ = builder;
	_tmp22_ = g_variant_builder_end (_tmp21_);
	g_variant_ref_sink (_tmp22_);
	result = _tmp22_;
	_g_variant_unref0 (v);
	_g_free0 (k);
	_g_variant_iter_free0 (it);
	_g_variant_unref0 (existing_vars);
	_g_variant_builder_unref0 (builder);
	return result;
}

static void
budgie_settings_manager_on_raven_sound_overdrive_change (BudgieSettingsManager* self)
{
	gboolean allow_volume_overdrive = FALSE;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_settings;
	allow_volume_overdrive = g_settings_get_boolean (_tmp0_, "allow-volume-overdrive");
	_tmp1_ = self->priv->gnome_sound_settings;
	g_settings_set_boolean (_tmp1_, "allow-volume-above-100-percent", allow_volume_overdrive);
}

static void
budgie_settings_manager_on_wm_settings_changed (BudgieSettingsManager* self,
                                                const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("attach-modal-dialogs")))) {
		switch (0) {
			default:
			{
				gboolean attach = FALSE;
				GSettings* _tmp3_;
				GSettings* _tmp4_;
				_tmp3_ = self->priv->wm_settings;
				attach = g_settings_get_boolean (_tmp3_, key);
				_tmp4_ = self->priv->mutter_settings;
				g_settings_set_boolean (_tmp4_, "attach-modal-dialogs", attach);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("button-style")))) {
		switch (0) {
			default:
			{
				BudgieButtonPosition style = 0;
				GSettings* _tmp5_;
				_tmp5_ = self->priv->wm_settings;
				style = (BudgieButtonPosition) g_settings_get_enum (_tmp5_, key);
				budgie_settings_manager_set_button_style (self, style);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("center-windows")))) {
		switch (0) {
			default:
			{
				gboolean center = FALSE;
				GSettings* _tmp6_;
				GSettings* _tmp7_;
				_tmp6_ = self->priv->wm_settings;
				center = g_settings_get_boolean (_tmp6_, key);
				_tmp7_ = self->priv->mutter_settings;
				g_settings_set_boolean (_tmp7_, "center-new-windows", center);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("caffeine-mode")))) {
		switch (0) {
			default:
			{
				gboolean enabled = FALSE;
				GSettings* _tmp8_;
				_tmp8_ = self->priv->wm_settings;
				enabled = g_settings_get_boolean (_tmp8_, key);
				budgie_settings_manager_set_caffeine_mode (self, enabled, FALSE);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("edge-tiling")))) {
		switch (0) {
			default:
			{
				gboolean edge_setting = FALSE;
				GSettings* _tmp9_;
				GSettings* _tmp10_;
				_tmp9_ = self->priv->wm_settings;
				edge_setting = g_settings_get_boolean (_tmp9_, key);
				_tmp10_ = self->priv->mutter_settings;
				g_settings_set_boolean (_tmp10_, "edge-tiling", edge_setting);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("focus-mode")))) {
		switch (0) {
			default:
			{
				gboolean mode = FALSE;
				GSettings* _tmp11_;
				_tmp11_ = self->priv->wm_settings;
				mode = g_settings_get_boolean (_tmp11_, key);
				budgie_settings_manager_set_focus_mode (self, mode);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

/**
* reset_values will reset select power and session keys
*/
static void
budgie_settings_manager_reset_values (BudgieSettingsManager* self)
{
	GSettings* _tmp0_;
	guint32* _tmp1_;
	GSettings* _tmp2_;
	gboolean* _tmp3_;
	GSettings* _tmp4_;
	gint* _tmp5_;
	GSettings* _tmp6_;
	gint* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gnome_session_settings;
	_tmp1_ = self->priv->default_idle_delay;
	g_settings_set_uint (_tmp0_, "idle-delay", *_tmp1_);
	_tmp2_ = self->priv->gnome_power_settings;
	_tmp3_ = self->priv->default_idle_dim;
	g_settings_set_boolean (_tmp2_, "idle-dim", *_tmp3_);
	_tmp4_ = self->priv->gnome_power_settings;
	_tmp5_ = self->priv->default_sleep_inactive_ac_timeout;
	g_settings_set_int (_tmp4_, "sleep-inactive-ac-timeout", *_tmp5_);
	_tmp6_ = self->priv->gnome_power_settings;
	_tmp7_ = self->priv->default_sleep_inactive_battery_timeout;
	g_settings_set_int (_tmp6_, "sleep-inactive-battery-timeout", *_tmp7_);
	budgie_settings_manager_caffeine_settings_sync (self);
}

/**
* Set the button layout to one of left or traditional
*/
static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
budgie_settings_manager_set_button_style (BudgieSettingsManager* self,
                                          BudgieButtonPosition style)
{
	GVariant* xset = NULL;
	gchar* wm_set = NULL;
	GSettings* _tmp4_;
	GVariant* _tmp5_;
	GSettings* _tmp6_;
	const gchar* _tmp7_;
	GSettings* _tmp8_;
	const gchar* _tmp9_;
	GVariant* _tmp10_;
	g_return_if_fail (self != NULL);
	xset = NULL;
	wm_set = NULL;
	switch (style) {
		case BUDGIE_BUTTON_POSITION_LEFT:
		{
			GVariant* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = budgie_settings_manager_new_filtered_xsetting (self, "close,minimize,maximize:menu");
			_g_variant_unref0 (xset);
			xset = _tmp0_;
			_tmp1_ = g_strdup ("close,minimize,maximize:appmenu");
			_g_free0 (wm_set);
			wm_set = _tmp1_;
			break;
		}
		default:
		case BUDGIE_BUTTON_POSITION_TRADITIONAL:
		{
			GVariant* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = budgie_settings_manager_new_filtered_xsetting (self, "menu:minimize,maximize,close");
			_g_variant_unref0 (xset);
			xset = _tmp2_;
			_tmp3_ = g_strdup ("appmenu:minimize,maximize,close");
			_g_free0 (wm_set);
			wm_set = _tmp3_;
			break;
		}
	}
	_tmp4_ = self->priv->xoverrides;
	_tmp5_ = xset;
	g_settings_set_value (_tmp4_, "overrides", _tmp5_);
	_tmp6_ = self->priv->wm_settings;
	_tmp7_ = wm_set;
	g_settings_set_string (_tmp6_, "button-layout", _tmp7_);
	_tmp8_ = self->priv->gnome_wm_settings;
	_tmp9_ = wm_set;
	_tmp10_ = _variant_new1 (_tmp9_);
	g_settings_set_value (_tmp8_, "button-layout", _tmp10_);
	_g_variant_unref0 (_tmp10_);
	_g_free0 (wm_set);
	_g_variant_unref0 (xset);
}

/**
* set_caffeine_mode will set our various settings for caffeine mode
*/
static gboolean
____lambda26_ (BudgieSettingsManager* self)
{
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	_tmp1_ = self->priv->gnome_session_settings;
	_tmp2_ = g_settings_get_has_unapplied (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GSettings* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->gnome_power_settings;
		_tmp5_ = g_settings_get_has_unapplied (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		budgie_settings_manager_reset_values (self);
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

static gboolean
_____lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda26_ ((BudgieSettingsManager*) self);
	return result;
}

static gboolean
_budgie_settings_manager_do_disable_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_settings_manager_do_disable ((BudgieSettingsManager*) self);
	return result;
}

static gboolean
___lambda27_ (BudgieSettingsManager* self)
{
	gint countdown = 0;
	GSettings* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->wm_settings;
	countdown = g_settings_get_int (_tmp0_, "caffeine-mode-timer");
	if (countdown != 0) {
		GSettings* _tmp1_;
		countdown -= 1;
		_tmp1_ = self->priv->wm_settings;
		g_settings_set_int (_tmp1_, "caffeine-mode-timer", countdown);
	}
	result = countdown != 0;
	return result;
}

static gboolean
____lambda27__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda27_ ((BudgieSettingsManager*) self);
	return result;
}

static gboolean
___lambda28_ (BudgieSettingsManager* self)
{
	gboolean result;
	self->priv->temporary_notification_disabled = FALSE;
	result = FALSE;
	return result;
}

static gboolean
____lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda28_ ((BudgieSettingsManager*) self);
	return result;
}

static void
budgie_settings_manager_set_caffeine_mode (BudgieSettingsManager* self,
                                           gboolean enabled,
                                           gboolean disable_notification)
{
	GSettings* _tmp11_;
	gint time = 0;
	GSettings* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GSettings* _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (enabled) {
		GSettings* _tmp0_;
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		GSettings* _tmp3_;
		_tmp0_ = self->priv->gnome_power_settings;
		g_settings_set_boolean (_tmp0_, "idle-dim", FALSE);
		_tmp1_ = self->priv->gnome_power_settings;
		g_settings_set_int (_tmp1_, "sleep-inactive-ac-timeout", 0);
		_tmp2_ = self->priv->gnome_power_settings;
		g_settings_set_int (_tmp2_, "sleep-inactive-battery-timeout", 0);
		_tmp3_ = self->priv->gnome_session_settings;
		g_settings_set_uint (_tmp3_, "idle-delay", (guint) 0);
		budgie_settings_manager_caffeine_settings_sync (self);
	} else {
		gboolean _tmp4_ = FALSE;
		GSettings* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->gnome_session_settings;
		_tmp6_ = g_settings_get_has_unapplied (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			_tmp4_ = TRUE;
		} else {
			GSettings* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = self->priv->gnome_power_settings;
			_tmp9_ = g_settings_get_has_unapplied (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = _tmp10_;
		}
		if (_tmp4_) {
			g_timeout_add_seconds_full (G_PRIORITY_HIGH, (guint) 1, _____lambda26__gsource_func, budgie_settings_manager_ref (self), budgie_settings_manager_unref);
		} else {
			budgie_settings_manager_reset_values (self);
		}
	}
	_tmp11_ = self->priv->wm_settings;
	if (g_settings_get_boolean (_tmp11_, "caffeine-mode-toggle-brightness")) {
		gint32 set_brightness = 0;
		GSettings* _tmp12_;
		gint32 _tmp13_ = 0;
		_tmp12_ = self->priv->wm_settings;
		set_brightness = (gint32) g_settings_get_int (_tmp12_, "caffeine-mode-screen-brightness");
		if (enabled) {
			_tmp13_ = set_brightness;
		} else {
			gint32* _tmp14_;
			_tmp14_ = self->priv->default_brightness;
			_tmp13_ = *_tmp14_;
		}
		budgie_settings_manager_change_brightness (self, _tmp13_);
	}
	_tmp15_ = self->priv->wm_settings;
	time = g_settings_get_int (_tmp15_, "caffeine-mode-timer");
	if (enabled) {
		_tmp16_ = time > 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		g_timeout_add_seconds_full (G_PRIORITY_HIGH, (guint) (time * 60), _budgie_settings_manager_do_disable_gsource_func, budgie_settings_manager_ref (self), budgie_settings_manager_unref);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 60, ____lambda27__gsource_func, budgie_settings_manager_ref (self), budgie_settings_manager_unref);
	}
	_tmp20_ = self->priv->wm_settings;
	if (g_settings_get_boolean (_tmp20_, "caffeine-mode-notification")) {
		_tmp19_ = !disable_notification;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		_tmp18_ = !self->priv->temporary_notification_disabled;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = notify_is_initted ();
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		const gchar* _tmp21_ = NULL;
		gchar* title = NULL;
		gchar* _tmp22_;
		gchar* body = NULL;
		gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* icon = NULL;
		gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		NotifyNotification* _tmp33_;
		if (enabled) {
			_tmp21_ = _ ("Turned on Caffeine Boost");
		} else {
			_tmp21_ = _ ("Turned off Caffeine Boost");
		}
		_tmp22_ = g_strdup (_tmp21_);
		title = _tmp22_;
		_tmp23_ = g_strdup ("");
		body = _tmp23_;
		if (enabled) {
			const gchar* _tmp25_;
			_tmp25_ = self->priv->caffeine_full_cup;
			_tmp24_ = _tmp25_;
		} else {
			const gchar* _tmp26_;
			_tmp26_ = self->priv->caffeine_empty_cup;
			_tmp24_ = _tmp26_;
		}
		_tmp27_ = g_strdup (_tmp24_);
		icon = _tmp27_;
		if (enabled) {
			_tmp28_ = time > 0;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			gchar* duration = NULL;
			gchar* _tmp29_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp29_ = g_strdup (_ ("Will turn off in a minute"));
			duration = _tmp29_;
			if (time > 1) {
				gchar* _tmp30_;
				_tmp30_ = g_strdup_printf (_ ("Will turn off in %d minutes"), time);
				_g_free0 (duration);
				duration = _tmp30_;
			}
			_tmp31_ = duration;
			_tmp32_ = g_strdup (_tmp31_);
			_g_free0 (body);
			body = _tmp32_;
			_g_free0 (duration);
		}
		_tmp33_ = self->priv->caffeine_notification;
		if (_tmp33_ == NULL) {
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			NotifyNotification* _tmp37_;
			NotifyNotification* _tmp38_;
			_tmp34_ = title;
			_tmp35_ = body;
			_tmp36_ = icon;
			_tmp37_ = notify_notification_new (_tmp34_, _tmp35_, _tmp36_);
			_g_object_unref0 (self->priv->caffeine_notification);
			self->priv->caffeine_notification = _tmp37_;
			_tmp38_ = self->priv->caffeine_notification;
			notify_notification_set_urgency (_tmp38_, NOTIFY_URGENCY_CRITICAL);
		} else {
			NotifyNotification* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			{
				NotifyNotification* _tmp39_;
				_tmp39_ = self->priv->caffeine_notification;
				notify_notification_close (_tmp39_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp40_;
				const gchar* _tmp41_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp40_ = e;
				_tmp41_ = _tmp40_->message;
				g_warning ("settings.vala:362: Failed to close previous notification: %s", _tmp41_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (icon);
				_g_free0 (body);
				_g_free0 (title);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp42_ = self->priv->caffeine_notification;
			_tmp43_ = title;
			_tmp44_ = body;
			_tmp45_ = icon;
			notify_notification_update (_tmp42_, _tmp43_, _tmp44_, _tmp45_);
		}
		{
			NotifyNotification* _tmp46_;
			_tmp46_ = self->priv->caffeine_notification;
			notify_notification_show (_tmp46_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp47_;
			const gchar* _tmp48_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp47_ = e;
			_tmp48_ = _tmp47_->message;
			g_warning ("settings.vala:371: Failed to send our Caffeine notification: %s", _tmp48_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (icon);
			_g_free0 (body);
			_g_free0 (title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (icon);
		_g_free0 (body);
		_g_free0 (title);
	}
	if (self->priv->temporary_notification_disabled) {
		g_timeout_add_seconds_full (G_PRIORITY_HIGH, (guint) 60, ____lambda28__gsource_func, budgie_settings_manager_ref (self), budgie_settings_manager_unref);
	}
}

/**
* set_focus_mode will set the window focus mode
*/
static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
budgie_settings_manager_set_focus_mode (BudgieSettingsManager* self,
                                        gboolean enable)
{
	gchar* gfocus_mode = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint raise_delay = 0;
	GSettings* _tmp3_;
	const gchar* _tmp4_;
	GVariant* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("click");
	gfocus_mode = _tmp0_;
	if (enable) {
		_tmp1_ = 0;
	} else {
		_tmp1_ = 250;
	}
	raise_delay = _tmp1_;
	if (enable) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("mouse");
		_g_free0 (gfocus_mode);
		gfocus_mode = _tmp2_;
	}
	_tmp3_ = self->priv->gnome_wm_settings;
	_tmp4_ = gfocus_mode;
	_tmp5_ = _variant_new2 (_tmp4_);
	g_settings_set_value (_tmp3_, "focus-mode", _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = self->priv->gnome_wm_settings;
	g_settings_set_boolean (_tmp6_, "auto-raise", enable);
	_tmp7_ = self->priv->gnome_wm_settings;
	g_settings_set_int (_tmp7_, "auto-raise-delay", raise_delay);
	_g_free0 (gfocus_mode);
}

/**
* set_supported_caffeine_icons will determine whether or not to use the current IconTheme's caffeine icons, if supported.
* If it is not supported, it will fall back to our budgie vendored icons.
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_settings_manager_set_supported_caffeine_icons (BudgieSettingsManager* self)
{
	GtkIconTheme* current_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	gchar* full = NULL;
	gchar* _tmp2_;
	gchar* empty = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	GtkIconTheme* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	GtkIconTheme* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current_theme = _tmp1_;
	_tmp2_ = g_strdup ("caffeine-cup-full");
	full = _tmp2_;
	_tmp3_ = g_strdup ("caffeine-cup-empty");
	empty = _tmp3_;
	_tmp5_ = current_theme;
	_tmp6_ = full;
	if (gtk_icon_theme_has_icon (_tmp5_, _tmp6_)) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = full;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp8_;
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = full;
		_tmp10_ = g_strconcat ("budgie-", _tmp9_, NULL);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->caffeine_full_cup);
	self->priv->caffeine_full_cup = _tmp11_;
	_tmp13_ = current_theme;
	_tmp14_ = empty;
	if (gtk_icon_theme_has_icon (_tmp13_, _tmp14_)) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = empty;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp16_;
	} else {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = empty;
		_tmp18_ = g_strconcat ("budgie-", _tmp17_, NULL);
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp18_;
	}
	_tmp19_ = g_strdup (_tmp12_);
	_g_free0 (self->priv->caffeine_empty_cup);
	self->priv->caffeine_empty_cup = _tmp19_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp4_);
	_g_free0 (empty);
	_g_free0 (full);
	_g_object_unref0 (current_theme);
}

/**
* update_ac_timeout will update our default sleep inactive ac timeout value, if it is a non-Caffeine mode value
*/
static void
budgie_settings_manager_update_ac_timeout (BudgieSettingsManager* self)
{
	gint current_ac_timeout = 0;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gnome_power_settings;
	current_ac_timeout = g_settings_get_int (_tmp0_, "sleep-inactive-ac-timeout");
	if (current_ac_timeout != 0) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (current_ac_timeout == 0) {
			_tmp2_ = !budgie_settings_manager_get_caffeine_mode (self);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		gint* _tmp3_;
		_tmp3_ = __int_dup0 (&current_ac_timeout);
		_g_free0 (self->priv->default_sleep_inactive_ac_timeout);
		self->priv->default_sleep_inactive_ac_timeout = _tmp3_;
	}
}

/**
* update_battery_timeout will update our default sleep inactive battery timeout, if it is a non-Caffeine mode value
*/
static void
budgie_settings_manager_update_battery_timeout (BudgieSettingsManager* self)
{
	gint current_battery_timeout = 0;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gnome_power_settings;
	current_battery_timeout = g_settings_get_int (_tmp0_, "sleep-inactive-battery-timeout");
	if (current_battery_timeout != 0) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (current_battery_timeout == 0) {
			_tmp2_ = !budgie_settings_manager_get_caffeine_mode (self);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		gint* _tmp3_;
		_tmp3_ = __int_dup0 (&current_battery_timeout);
		_g_free0 (self->priv->default_sleep_inactive_battery_timeout);
		self->priv->default_sleep_inactive_battery_timeout = _tmp3_;
	}
}

/**
* update_idle_delay will update our default idle delay, if it is a non-Caffeine mode value
*/
static void
budgie_settings_manager_update_idle_delay (BudgieSettingsManager* self)
{
	guint current_idle_delay = 0U;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gnome_session_settings;
	current_idle_delay = g_settings_get_uint (_tmp0_, "idle-delay");
	if (current_idle_delay != ((guint) 0)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (current_idle_delay == ((guint) 0)) {
			_tmp2_ = !budgie_settings_manager_get_caffeine_mode (self);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		guint32 _tmp3_;
		guint32* _tmp4_;
		_tmp3_ = (guint32) current_idle_delay;
		_tmp4_ = __uint32_dup0 (&_tmp3_);
		_g_free0 (self->priv->default_idle_delay);
		self->priv->default_idle_delay = _tmp4_;
	}
}

/**
* update_idle_dim will update our default idle dim, if we are not in Caffeine Mode
*/
static void
budgie_settings_manager_update_idle_dim (BudgieSettingsManager* self)
{
	g_return_if_fail (self != NULL);
	if (!budgie_settings_manager_get_caffeine_mode (self)) {
		GSettings* _tmp0_;
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp0_ = self->priv->gnome_power_settings;
		_tmp1_ = g_settings_get_boolean (_tmp0_, "idle-dim");
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->default_idle_dim);
		self->priv->default_idle_dim = _tmp2_;
	}
}

GApplication*
budgie_settings_manager_get_parent_app (BudgieSettingsManager* self)
{
	GApplication* result;
	GApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_app;
	result = _tmp0_;
	return result;
}

void
budgie_settings_manager_set_parent_app (BudgieSettingsManager* self,
                                        GApplication* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_parent_app = value;
}

static void
budgie_value_settings_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_settings_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_settings_manager_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_settings_manager_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_settings_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_settings_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_settings_manager_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieSettingsManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_settings_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_settings_manager_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	BudgieSettingsManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_settings_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_settings_manager (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	BudgieParamSpecSettingsManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_SETTINGS_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_settings_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SETTINGS_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_settings_manager (GValue* value,
                                   gpointer v_object)
{
	BudgieSettingsManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SETTINGS_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_SETTINGS_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_settings_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_settings_manager_unref (old);
	}
}

void
budgie_value_take_settings_manager (GValue* value,
                                    gpointer v_object)
{
	BudgieSettingsManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_SETTINGS_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_SETTINGS_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_settings_manager_unref (old);
	}
}

static void
budgie_settings_manager_class_init (BudgieSettingsManagerClass * klass,
                                    gpointer klass_data)
{
	budgie_settings_manager_parent_class = g_type_class_peek_parent (klass);
	((BudgieSettingsManagerClass *) klass)->finalize = budgie_settings_manager_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieSettingsManager_private_offset);
}

static void
budgie_settings_manager_instance_init (BudgieSettingsManager * self,
                                       gpointer klass)
{
	gint32 _tmp0_;
	gint32* _tmp1_;
	guint32 _tmp2_;
	guint32* _tmp3_;
	gboolean _tmp4_;
	gboolean* _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gint _tmp8_;
	gint* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	self->priv = budgie_settings_manager_get_instance_private (self);
	self->priv->_parent_app = NULL;
	self->priv->mutter_settings = NULL;
	self->priv->gnome_desktop_settings = NULL;
	self->priv->gnome_power_settings = NULL;
	self->priv->gnome_power_props = NULL;
	self->priv->gnome_session_settings = NULL;
	self->priv->gnome_sound_settings = NULL;
	self->priv->gnome_wm_settings = NULL;
	self->priv->raven_settings = NULL;
	self->priv->wm_settings = NULL;
	self->priv->xoverrides = NULL;
	_tmp0_ = (gint32) 30;
	_tmp1_ = __int32_dup0 (&_tmp0_);
	self->priv->default_brightness = _tmp1_;
	_tmp2_ = (guint32) 0;
	_tmp3_ = __uint32_dup0 (&_tmp2_);
	self->priv->default_idle_delay = _tmp3_;
	_tmp4_ = FALSE;
	_tmp5_ = __bool_dup0 (&_tmp4_);
	self->priv->default_idle_dim = _tmp5_;
	_tmp6_ = 0;
	_tmp7_ = __int_dup0 (&_tmp6_);
	self->priv->default_sleep_inactive_ac_timeout = _tmp7_;
	_tmp8_ = 0;
	_tmp9_ = __int_dup0 (&_tmp8_);
	self->priv->default_sleep_inactive_battery_timeout = _tmp9_;
	_tmp10_ = g_strdup ("");
	self->priv->caffeine_full_cup = _tmp10_;
	_tmp11_ = g_strdup ("");
	self->priv->caffeine_empty_cup = _tmp11_;
	self->priv->caffeine_notification = NULL;
	self->priv->temporary_notification_disabled = FALSE;
	self->ref_count = 1;
}

static void
budgie_settings_manager_finalize (BudgieSettingsManager * obj)
{
	BudgieSettingsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_MANAGER, BudgieSettingsManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->mutter_settings);
	_g_object_unref0 (self->priv->gnome_desktop_settings);
	_g_object_unref0 (self->priv->gnome_power_settings);
	_g_object_unref0 (self->priv->gnome_power_props);
	_g_object_unref0 (self->priv->gnome_session_settings);
	_g_object_unref0 (self->priv->gnome_sound_settings);
	_g_object_unref0 (self->priv->gnome_wm_settings);
	_g_object_unref0 (self->priv->raven_settings);
	_g_object_unref0 (self->priv->wm_settings);
	_g_object_unref0 (self->priv->xoverrides);
	_g_free0 (self->priv->default_brightness);
	_g_free0 (self->priv->default_idle_delay);
	_g_free0 (self->priv->default_idle_dim);
	_g_free0 (self->priv->default_sleep_inactive_ac_timeout);
	_g_free0 (self->priv->default_sleep_inactive_battery_timeout);
	_g_free0 (self->priv->caffeine_full_cup);
	_g_free0 (self->priv->caffeine_empty_cup);
	_g_object_unref0 (self->priv->caffeine_notification);
}

/**
* The SettingsManager currently only has a very simple job, and looks for
* session wide settings changes to respond to
*/
static GType
budgie_settings_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_settings_manager_init, budgie_value_settings_manager_free_value, budgie_value_settings_manager_copy_value, budgie_value_settings_manager_peek_pointer, "p", budgie_value_settings_manager_collect_value, "p", budgie_value_settings_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsManager), 0, (GInstanceInitFunc) budgie_settings_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_settings_manager_type_id;
	budgie_settings_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieSettingsManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BudgieSettingsManager_private_offset = g_type_add_instance_private (budgie_settings_manager_type_id, sizeof (BudgieSettingsManagerPrivate));
	return budgie_settings_manager_type_id;
}

GType
budgie_settings_manager_get_type (void)
{
	static volatile gsize budgie_settings_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_manager_type_id__once)) {
		GType budgie_settings_manager_type_id;
		budgie_settings_manager_type_id = budgie_settings_manager_get_type_once ();
		g_once_init_leave (&budgie_settings_manager_type_id__once, budgie_settings_manager_type_id);
	}
	return budgie_settings_manager_type_id__once;
}

gpointer
budgie_settings_manager_ref (gpointer instance)
{
	BudgieSettingsManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_settings_manager_unref (gpointer instance)
{
	BudgieSettingsManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_SETTINGS_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

