/* LockKeysApplet.c generated by valac 0.56.3, the Vala compiler
 * generated from LockKeysApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "lockkeysapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

enum  {
	LOCK_KEYS_PLUGIN_0_PROPERTY,
	LOCK_KEYS_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* lock_keys_plugin_properties[LOCK_KEYS_PLUGIN_NUM_PROPERTIES];
enum  {
	LOCK_KEYS_APPLET_0_PROPERTY,
	LOCK_KEYS_APPLET_NUM_PROPERTIES
};
static GParamSpec* lock_keys_applet_properties[LOCK_KEYS_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _LockKeysAppletPrivate {
	GtkBox* widget;
	GtkImage* caps;
	GtkImage* num;
	GtkEventBox* caps_box;
	GtkEventBox* num_box;
	GdkKeymap* map;
};

static gpointer lock_keys_plugin_parent_class = NULL;
static BudgiePluginIface * lock_keys_plugin_budgie_plugin_parent_iface = NULL;
static GType lock_keys_plugin_type_id = 0;
static gint LockKeysApplet_private_offset;
static gpointer lock_keys_applet_parent_class = NULL;
static GType lock_keys_applet_type_id = 0;

static BudgieApplet* lock_keys_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                      const gchar* uuid);
static gboolean __lambda4_ (LockKeysApplet* self,
                     GdkEventButton* eventbutton);
static gboolean ___lambda4__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static gboolean __lambda5_ (LockKeysApplet* self,
                     GdkEventButton* eventbutton);
static gboolean ___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void _lock_keys_applet_on_state_changed_gdk_keymap_state_changed (GdkKeymap* _sender,
                                                                  gpointer self);
static void lock_keys_applet_real_panel_position_changed (BudgieApplet* base,
                                                   BudgiePanelPosition position);
static void lock_keys_applet_finalize (GObject * obj);

static BudgieApplet*
lock_keys_plugin_real_get_panel_widget (BudgiePlugin* base,
                                        const gchar* uuid)
{
	LockKeysPlugin * self;
	LockKeysApplet* _tmp0_;
	BudgieApplet* result;
	self = (LockKeysPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = lock_keys_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

LockKeysPlugin*
lock_keys_plugin_construct (GType object_type)
{
	LockKeysPlugin * self = NULL;
	self = (LockKeysPlugin*) g_object_new (object_type, NULL);
	return self;
}

LockKeysPlugin*
lock_keys_plugin_new (void)
{
	return lock_keys_plugin_construct (TYPE_LOCK_KEYS_PLUGIN);
}

static void
lock_keys_plugin_class_init (LockKeysPluginClass * klass,
                             gpointer klass_data)
{
	lock_keys_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
lock_keys_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                               gpointer iface_data)
{
	lock_keys_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) lock_keys_plugin_real_get_panel_widget;
}

static void
lock_keys_plugin_instance_init (LockKeysPlugin * self,
                                gpointer klass)
{
}

GType
lock_keys_plugin_get_type (void)
{
	return lock_keys_plugin_type_id;
}

GType
lock_keys_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (LockKeysPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lock_keys_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LockKeysPlugin), 0, (GInstanceInitFunc) lock_keys_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) lock_keys_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	lock_keys_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "LockKeysPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, lock_keys_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return lock_keys_plugin_type_id;
}

static inline gpointer
lock_keys_applet_get_instance_private (LockKeysApplet* self)
{
	return G_STRUCT_MEMBER_P (self, LockKeysApplet_private_offset);
}

static gboolean
__lambda4_ (LockKeysApplet* self,
            GdkEventButton* eventbutton)
{
	gboolean result;
	g_return_val_if_fail (eventbutton != NULL, FALSE);
	result = lock_keys_applet_on_panel_widget_clicked (self, eventbutton, "Caps_Lock");
	return result;
}

static gboolean
___lambda4__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda4_ ((LockKeysApplet*) self, event);
	return result;
}

static gboolean
__lambda5_ (LockKeysApplet* self,
            GdkEventButton* eventbutton)
{
	gboolean result;
	g_return_val_if_fail (eventbutton != NULL, FALSE);
	result = lock_keys_applet_on_panel_widget_clicked (self, eventbutton, "Num_Lock");
	return result;
}

static gboolean
___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	gboolean result;
	result = __lambda5_ ((LockKeysApplet*) self, event);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_lock_keys_applet_on_state_changed_gdk_keymap_state_changed (GdkKeymap* _sender,
                                                             gpointer self)
{
	lock_keys_applet_on_state_changed ((LockKeysApplet*) self);
}

LockKeysApplet*
lock_keys_applet_construct (GType object_type)
{
	LockKeysApplet * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkEventBox* _tmp5_;
	GtkEventBox* _tmp6_;
	GtkEventBox* _tmp7_;
	GtkImage* _tmp8_;
	GtkEventBox* _tmp9_;
	GtkImage* _tmp10_;
	GtkBox* _tmp11_;
	GtkEventBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkEventBox* _tmp14_;
	GtkEventBox* _tmp15_;
	GtkEventBox* _tmp16_;
	GdkDisplay* _tmp17_;
	GdkKeymap* _tmp18_;
	GdkKeymap* _tmp19_;
	GdkKeymap* _tmp20_;
	self = (LockKeysApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp0_;
	_tmp1_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "lock-keys");
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name ("caps-lock-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->caps);
	self->priv->caps = _tmp3_;
	_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name ("num-lock-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->num);
	self->priv->num = _tmp4_;
	_tmp5_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->caps_box);
	self->priv->caps_box = _tmp5_;
	_tmp6_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->num_box);
	self->priv->num_box = _tmp6_;
	_tmp7_ = self->priv->caps_box;
	_tmp8_ = self->priv->caps;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->num_box;
	_tmp10_ = self->priv->num;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->widget;
	_tmp12_ = self->priv->caps_box;
	gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 0);
	_tmp13_ = self->priv->widget;
	_tmp14_ = self->priv->num_box;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = self->priv->caps_box;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "button-press-event", (GCallback) ___lambda4__gtk_widget_button_press_event, self, 0);
	_tmp16_ = self->priv->num_box;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "button-press-event", (GCallback) ___lambda5__gtk_widget_button_press_event, self, 0);
	_tmp17_ = gdk_display_get_default ();
	_tmp18_ = gdk_keymap_get_for_display (_tmp17_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_g_object_unref0 (self->priv->map);
	self->priv->map = _tmp19_;
	_tmp20_ = self->priv->map;
	g_signal_connect_object (_tmp20_, "state-changed", (GCallback) _lock_keys_applet_on_state_changed_gdk_keymap_state_changed, self, 0);
	lock_keys_applet_on_state_changed (self);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

LockKeysApplet*
lock_keys_applet_new (void)
{
	return lock_keys_applet_construct (TYPE_LOCK_KEYS_APPLET);
}

static void
lock_keys_applet_real_panel_position_changed (BudgieApplet* base,
                                              BudgiePanelPosition position)
{
	LockKeysApplet * self;
	GtkOrientation orient = 0;
	gboolean _tmp0_ = FALSE;
	GtkBox* _tmp1_;
	self = (LockKeysApplet*) base;
	orient = GTK_ORIENTATION_HORIZONTAL;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		orient = GTK_ORIENTATION_VERTICAL;
	}
	_tmp1_ = self->priv->widget;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, orient);
}

void
lock_keys_applet_toggle_caps (LockKeysApplet* self)
{
	GtkImage* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->caps;
	_tmp1_ = self->priv->map;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, gdk_keymap_get_caps_lock_state (_tmp1_));
	_tmp2_ = self->priv->map;
	if (gdk_keymap_get_caps_lock_state (_tmp2_)) {
		GtkImage* _tmp3_;
		GtkImage* _tmp4_;
		GtkStyleContext* _tmp5_;
		_tmp3_ = self->priv->caps;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Caps lock is active"));
		_tmp4_ = self->priv->caps;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		gtk_style_context_remove_class (_tmp5_, "dim-label");
	} else {
		GtkImage* _tmp6_;
		GtkImage* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp6_ = self->priv->caps;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Caps lock is not active"));
		_tmp7_ = self->priv->caps;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_add_class (_tmp8_, "dim-label");
	}
}

void
lock_keys_applet_toggle_num (LockKeysApplet* self)
{
	GtkImage* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->num;
	_tmp1_ = self->priv->map;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, gdk_keymap_get_num_lock_state (_tmp1_));
	_tmp2_ = self->priv->map;
	if (gdk_keymap_get_num_lock_state (_tmp2_)) {
		GtkImage* _tmp3_;
		GtkImage* _tmp4_;
		GtkStyleContext* _tmp5_;
		_tmp3_ = self->priv->num;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Num lock is active"));
		_tmp4_ = self->priv->num;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		gtk_style_context_remove_class (_tmp5_, "dim-label");
	} else {
		GtkImage* _tmp6_;
		GtkImage* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp6_ = self->priv->num;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Num lock is not active"));
		_tmp7_ = self->priv->num;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_add_class (_tmp8_, "dim-label");
	}
}

gboolean
lock_keys_applet_on_panel_widget_clicked (LockKeysApplet* self,
                                          GdkEventButton* eventbutton,
                                          const gchar* button)
{
	gchar* xdotool = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (eventbutton != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	_tmp0_ = g_find_program_in_path ("xdotool");
	xdotool = _tmp0_;
	_tmp2_ = xdotool;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = eventbutton->button != ((guint) 1);
	}
	if (_tmp1_) {
		result = GDK_EVENT_PROPAGATE;
		_g_free0 (xdotool);
		return result;
	}
	{
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = xdotool;
		_tmp4_ = g_strjoin (" ", _tmp3_, "key", button, NULL);
		_tmp5_ = _tmp4_;
		g_spawn_command_line_async (_tmp5_, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (xdotool);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("LockKeysApplet.vala:97: Failed to run xdotool: %s", _tmp8_);
		result = GDK_EVENT_PROPAGATE;
		_g_error_free0 (e);
		_g_free0 (xdotool);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_free0 (xdotool);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = GDK_EVENT_STOP;
	_g_free0 (xdotool);
	return result;
}

void
lock_keys_applet_on_state_changed (LockKeysApplet* self)
{
	g_return_if_fail (self != NULL);
	lock_keys_applet_toggle_caps (self);
	lock_keys_applet_toggle_num (self);
}

static void
lock_keys_applet_class_init (LockKeysAppletClass * klass,
                             gpointer klass_data)
{
	lock_keys_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LockKeysApplet_private_offset);
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) lock_keys_applet_real_panel_position_changed;
	G_OBJECT_CLASS (klass)->finalize = lock_keys_applet_finalize;
}

static void
lock_keys_applet_instance_init (LockKeysApplet * self,
                                gpointer klass)
{
	self->priv = lock_keys_applet_get_instance_private (self);
}

static void
lock_keys_applet_finalize (GObject * obj)
{
	LockKeysApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOCK_KEYS_APPLET, LockKeysApplet);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->caps);
	_g_object_unref0 (self->priv->num);
	_g_object_unref0 (self->priv->caps_box);
	_g_object_unref0 (self->priv->num_box);
	_g_object_unref0 (self->priv->map);
	G_OBJECT_CLASS (lock_keys_applet_parent_class)->finalize (obj);
}

GType
lock_keys_applet_get_type (void)
{
	return lock_keys_applet_type_id;
}

GType
lock_keys_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (LockKeysAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lock_keys_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LockKeysApplet), 0, (GInstanceInitFunc) lock_keys_applet_instance_init, NULL };
	lock_keys_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "LockKeysApplet", &g_define_type_info, 0);
	LockKeysApplet_private_offset = sizeof (LockKeysAppletPrivate);
	return lock_keys_applet_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	lock_keys_plugin_register_type (module);
	lock_keys_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_LOCK_KEYS_PLUGIN);
	_g_object_unref0 (objmodule);
}

