/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.ReflectTypeElement;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
final class ReflectGenericPlaceholderElement
extends ReflectTypeElement<TypeVariable<?>>
implements GenericPlaceholderElement,
ArrayableClassElement {
    private final int arrayDimensions;

    ReflectGenericPlaceholderElement(TypeVariable<?> typeVariable, int arrayDimensions) {
        super(typeVariable);
        this.arrayDimensions = arrayDimensions;
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new ReflectGenericPlaceholderElement((TypeVariable)this.type, arrayDimensions);
    }

    @Override
    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    @NonNull
    public List<? extends ClassElement> getBounds() {
        return Arrays.stream(((TypeVariable)this.type).getBounds()).map(ClassElement::of).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public String getVariableName() {
        return ((TypeVariable)this.type).getName();
    }

    @Override
    public Optional<Element> getDeclaringElement() {
        Object declaration = ((TypeVariable)this.type).getGenericDeclaration();
        if (declaration instanceof Class) {
            return Optional.of(ClassElement.of((Class)declaration));
        }
        return Optional.empty();
    }
}

