/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/InitializerCallReplacer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "replacementCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "initializerCall", "getInitializerCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "setInitializerCall", "visitCall", "expression", "ir.backend.common"})
public final class InitializerCallReplacer
extends IrElementTransformerVoid {
    @NotNull
    private final IrCall replacementCall;
    @Nullable
    private IrCall initializerCall;

    public InitializerCallReplacer(@NotNull IrCall replacementCall) {
        Intrinsics.checkNotNullParameter(replacementCall, "replacementCall");
        this.replacementCall = replacementCall;
    }

    @Nullable
    public final IrCall getInitializerCall() {
        return this.initializerCall;
    }

    public final void setInitializerCall(@Nullable IrCall irCall) {
        this.initializerCall = irCall;
    }

    @Override
    @NotNull
    public IrCall visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (this.initializerCall != null) {
            StringBuilder stringBuilder2 = new StringBuilder().append("Multiple initializer calls found. First: ");
            IrCall irCall = this.initializerCall;
            Intrinsics.checkNotNull(irCall);
            throw new IllegalStateException(stringBuilder2.append(RenderIrElementKt.render(irCall)).append("\nSecond: ").append(RenderIrElementKt.render(expression2)).toString());
        }
        this.initializerCall = expression2;
        return this.replacementCall;
    }
}

