/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirModuleVisibilityChecker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JB\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JT\u0010\u0011\u001a\u00020\u00042\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J2\u0010\u0018\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JJ\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JT\u0010 \u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u0016JT\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H$J\u0016\u0010%\u001a\u0004\u0018\u00010&*\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010%\u001a\u0004\u0018\u00010&*\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\rH\u0002J\f\u0010(\u001a\u00020\u0004*\u00020)H\u0002J\u0014\u0010*\u001a\u00020\u0004*\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J$\u0010-\u001a\u00020\u0004*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010.\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010.\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010/\u001a\u000200*\u0006\u0012\u0002\b\u00030\u0006H\u0004\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "()V", "canSeePrivateMemberOf", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "containingDeclarationOfUseSite", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "ownerLookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "isVariableOrNamedFunction", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "canSeeProtectedMemberOf", "containingUseSiteClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "isSyntheticProperty", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "usedSymbol", "doesReceiverFitForProtectedVisibility", "isSpecificDeclarationVisible", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "isCallToPropertySetter", "isVisible", "skipCheckForContainingClassVisibility", "platformVisibilityCheck", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "containingNonLocalClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "dispatchReceiverValue", "isAllowedToBeAccessedFromOutside", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "isSame", "Lorg/jetbrains/kotlin/name/ClassId;", "other", "isSubClass", "ownerIfCompanion", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Default", "providers"})
public abstract class FirVisibilityChecker
implements FirSessionComponent {
    public final boolean isVisible(@NotNull FirMemberDeclaration declaration, @NotNull FirSession session2, @NotNull FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @Nullable ReceiverValue dispatchReceiver, boolean isCallToPropertySetter, boolean skipCheckForContainingClassVisibility, @NotNull SupertypeSupplier supertypeSupplier) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(useSiteFile, "useSiteFile");
            Intrinsics.checkNotNullParameter(containingDeclarations, "containingDeclarations");
            Intrinsics.checkNotNullParameter(supertypeSupplier, "supertypeSupplier");
            if (!this.isSpecificDeclarationVisible(declaration, session2, useSiteFile, containingDeclarations, dispatchReceiver, isCallToPropertySetter, supertypeSupplier)) {
                return false;
            }
            if (skipCheckForContainingClassVisibility) {
                return true;
            }
            FirClassLikeDeclaration firClassLikeDeclaration = this.containingNonLocalClass(declaration, session2, dispatchReceiver);
            if (firClassLikeDeclaration == null) {
                return true;
            }
            FirClassLikeDeclaration parentClass = firClassLikeDeclaration;
            Sequence<FirClassLikeDeclaration> $this$all$iv = SequencesKt.generateSequence(parentClass, (Function1)new Function1<FirClassLikeDeclaration, FirClassLikeDeclaration>(this, session2){
                final /* synthetic */ FirVisibilityChecker this$0;
                final /* synthetic */ FirSession $session;
                {
                    this.this$0 = $receiver;
                    this.$session = $session;
                    super(1);
                }

                @Nullable
                public final FirClassLikeDeclaration invoke(@NotNull FirClassLikeDeclaration it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return FirVisibilityChecker.access$containingNonLocalClass(this.this$0, it, this.$session);
                }
            });
            boolean $i$f$all = false;
            Iterator<FirClassLikeDeclaration> iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                FirClassLikeDeclaration element$iv;
                FirClassLikeDeclaration parent2 = element$iv = iterator2.next();
                boolean bl2 = false;
                if (this.isSpecificDeclarationVisible(parent2, session2, useSiteFile, containingDeclarations, null, isCallToPropertySetter, supertypeSupplier)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        return bl;
    }

    public static /* synthetic */ boolean isVisible$default(FirVisibilityChecker firVisibilityChecker, FirMemberDeclaration firMemberDeclaration, FirSession firSession, FirFile firFile, List list2, ReceiverValue receiverValue, boolean bl, boolean bl2, SupertypeSupplier supertypeSupplier, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isVisible");
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            supertypeSupplier = SupertypeSupplier.Default.INSTANCE;
        }
        return firVisibilityChecker.isVisible(firMemberDeclaration, firSession, firFile, list2, receiverValue, bl, bl2, supertypeSupplier);
    }

    private final FirClassLikeDeclaration containingNonLocalClass(FirMemberDeclaration $this$containingNonLocalClass, FirSession session2, ReceiverValue dispatchReceiverValue2) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        FirMemberDeclaration firMemberDeclaration = $this$containingNonLocalClass;
        if (firMemberDeclaration instanceof FirCallableDeclaration) {
            Object object;
            if (dispatchReceiverValue2 != null && ((FirCallableDeclaration)$this$containingNonLocalClass).getDispatchReceiverType() != null) {
                FirClassLikeDeclaration firClassLikeDeclaration2;
                FirClassLikeSymbol<?> firClassLikeSymbol;
                ConeKotlinType coneKotlinType = dispatchReceiverValue2.getType();
                ConeSimpleKotlinType coneSimpleKotlinType = ((FirCallableDeclaration)$this$containingNonLocalClass).getDispatchReceiverType();
                Intrinsics.checkNotNull(coneSimpleKotlinType);
                ConeClassLikeLookupTag coneClassLikeLookupTag = LookupTagUtilsKt.findClassRepresentation(coneKotlinType, coneSimpleKotlinType, session2);
                if (coneClassLikeLookupTag != null && (firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2)) != null && (firClassLikeDeclaration2 = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) != null) {
                    FirClassLikeDeclaration it = firClassLikeDeclaration2;
                    boolean bl = false;
                    return it;
                }
            }
            firClassLikeDeclaration = (object = ClassMembersKt.containingClass((FirCallableDeclaration)$this$containingNonLocalClass)) != null && (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, session2)) != null ? (FirClassLikeDeclaration)((FirBasedSymbol)object).getFir() : null;
        } else if (firMemberDeclaration instanceof FirClassLikeDeclaration) {
            firClassLikeDeclaration = this.containingNonLocalClass((FirClassLikeDeclaration)$this$containingNonLocalClass, session2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firClassLikeDeclaration;
    }

    private final FirClassLikeDeclaration containingNonLocalClass(FirClassLikeDeclaration $this$containingNonLocalClass, FirSession session2) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        FirClassLikeDeclaration firClassLikeDeclaration2 = $this$containingNonLocalClass;
        if (firClassLikeDeclaration2 instanceof FirClass) {
            FirClassLikeDeclaration $this$isLocal$iv = $this$containingNonLocalClass;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                return null;
            }
            ClassId classId = FirDeclarationUtilKt.getClassId((FirClass)$this$containingNonLocalClass).getOuterClassId();
            if (classId != null) {
                ClassId it = classId;
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(session2).getClassLikeSymbolByClassId(it);
                firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            } else {
                firClassLikeDeclaration = null;
            }
        } else if (firClassLikeDeclaration2 instanceof FirTypeAlias) {
            firClassLikeDeclaration = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firClassLikeDeclaration;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean isSpecificDeclarationVisible(FirMemberDeclaration declaration, FirSession session2, FirFile useSiteFile, List<? extends FirDeclaration> containingDeclarations, ReceiverValue dispatchReceiver, boolean isCallToPropertySetter, SupertypeSupplier supertypeSupplier) {
        boolean bl;
        FirBasedSymbol<? extends FirDeclaration> symbol2 = declaration.getSymbol();
        FirProvider provider2 = FirProviderKt.getFirProvider(session2);
        FirMemberDeclaration $this$visibility$iv = declaration;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        if (Intrinsics.areEqual(visibility2, Visibilities.Internal.INSTANCE)) {
            if (Intrinsics.areEqual(declaration.getModuleData(), FirModuleDataKt.getModuleData(session2))) return true;
            FirModuleVisibilityChecker firModuleVisibilityChecker = FirVisibilityCheckerKt.getModuleVisibilityChecker(session2);
            if (firModuleVisibilityChecker == null) return false;
            if (!firModuleVisibilityChecker.isInFriendModule(declaration)) return false;
            return true;
        }
        if (Intrinsics.areEqual(visibility2, Visibilities.Private.INSTANCE) ? true : Intrinsics.areEqual(visibility2, Visibilities.PrivateToThis.INSTANCE)) {
            ConeClassLikeLookupTag ownerLookupTag = FirVisibilityCheckerKt.getOwnerLookupTag(symbol2);
            if (Intrinsics.areEqual(declaration.getModuleData(), FirModuleDataKt.getModuleData(session2))) {
                if (ownerLookupTag == null) {
                    FirFile firFile;
                    FirBasedSymbol<? extends FirDeclaration> firBasedSymbol = symbol2;
                    if (firBasedSymbol instanceof FirSyntheticFunctionSymbol) {
                        ClassId classId = new ClassId(((FirSyntheticFunctionSymbol)symbol2).getCallableId().getPackageName(), ((FirSyntheticFunctionSymbol)symbol2).getCallableId().getCallableName());
                        firFile = provider2.getFirClassifierContainerFile(classId);
                    } else {
                        firFile = firBasedSymbol instanceof FirClassLikeSymbol ? provider2.getFirClassifierContainerFileIfAny((FirClassLikeSymbol)symbol2) : (firBasedSymbol instanceof FirCallableSymbol ? provider2.getFirCallableContainerFile((FirCallableSymbol)symbol2) : null);
                    }
                    FirFile candidateFile = firFile;
                    bl = Intrinsics.areEqual(candidateFile, useSiteFile);
                    return bl;
                }
                if (declaration instanceof FirConstructor) {
                    FirMemberDeclaration $this$isFromSealedClass$iv = declaration;
                    boolean $i$f$isFromSealedClass = false;
                    if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                        bl = Intrinsics.areEqual(((FirConstructor)declaration).getSymbol().getCallableId().getPackageName(), UtilsKt.getPackageFqName(useSiteFile));
                        return bl;
                    }
                }
                bl = this.canSeePrivateMemberOf(symbol2, containingDeclarations, ownerLookupTag, dispatchReceiver, FirVisibilityCheckerKt.isVariableOrNamedFunction(symbol2), session2);
                return bl;
            }
            if (!(declaration instanceof FirSimpleFunction)) return false;
            if (!this.isAllowedToBeAccessedFromOutside((FirSimpleFunction)declaration)) return false;
            return true;
        }
        if (!Intrinsics.areEqual(visibility2, Visibilities.Protected.INSTANCE)) {
            $this$visibility$iv = declaration;
            $i$f$getVisibility = false;
            bl = this.platformVisibilityCheck($this$visibility$iv.getStatus().getVisibility(), symbol2, useSiteFile, containingDeclarations, dispatchReceiver, session2, isCallToPropertySetter, supertypeSupplier);
            return bl;
        }
        ConeClassLikeLookupTag ownerId = FirVisibilityCheckerKt.getOwnerLookupTag(symbol2);
        if (ownerId == null) return false;
        if (!this.canSeeProtectedMemberOf(symbol2, containingDeclarations, dispatchReceiver, ownerId, session2, FirVisibilityCheckerKt.isVariableOrNamedFunction(symbol2), symbol2.getFir() instanceof FirSyntheticPropertyAccessor, supertypeSupplier)) return false;
        return true;
    }

    protected abstract boolean platformVisibilityCheck(@NotNull Visibility var1, @NotNull FirBasedSymbol<?> var2, @NotNull FirFile var3, @NotNull List<? extends FirDeclaration> var4, @Nullable ReceiverValue var5, @NotNull FirSession var6, boolean var7, @NotNull SupertypeSupplier var8);

    private final boolean canSeePrivateMemberOf(FirBasedSymbol<?> symbol2, List<? extends FirDeclaration> containingDeclarationOfUseSite, ConeClassLikeLookupTag ownerLookupTag, ReceiverValue dispatchReceiver, boolean isVariableOrNamedFunction, FirSession session2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = this.ownerIfCompanion(ownerLookupTag, session2);
        if (coneClassLikeLookupTag != null) {
            ConeClassLikeLookupTag companionOwnerLookupTag = coneClassLikeLookupTag;
            boolean bl = false;
            return this.canSeePrivateMemberOf(symbol2, containingDeclarationOfUseSite, companionOwnerLookupTag, dispatchReceiver, isVariableOrNamedFunction, session2);
        }
        if (dispatchReceiver != null) {
            ConeStarProjection[] coneStarProjectionArray;
            ConeClassLikeLookupTag coneClassLikeLookupTag2;
            FirCallableDeclaration firCallableDeclaration;
            FirCallableDeclaration firCallableDeclaration2;
            Object companionOwnerLookupTag = symbol2.getFir();
            FirCallableDeclaration firCallableDeclaration3 = firCallableDeclaration2 = companionOwnerLookupTag instanceof FirCallableDeclaration ? (FirCallableDeclaration)companionOwnerLookupTag : null;
            if (firCallableDeclaration2 == null || (companionOwnerLookupTag = ClassMembersKt.getPropertyIfAccessor(firCallableDeclaration2)) == null || (firCallableDeclaration = ClassMembersKt.getPropertyIfBackingField(companionOwnerLookupTag)) == null || (coneClassLikeLookupTag2 = ClassMembersKt.dispatchReceiverClassOrNull(firCallableDeclaration)) == null || (coneStarProjectionArray = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag2, session2)) == null) {
                return true;
            }
            ConeStarProjection[] dispatchReceiverParameterClassSymbol = coneStarProjectionArray;
            ConeClassLikeLookupTag coneClassLikeLookupTag3 = dispatchReceiverParameterClassSymbol.toLookupTag();
            int n = 0;
            int n2 = ((FirClassLikeDeclaration)dispatchReceiverParameterClassSymbol.getFir()).getTypeParameters().size();
            coneStarProjectionArray = new ConeStarProjection[n2];
            ConeClassLikeLookupTag coneClassLikeLookupTag4 = coneClassLikeLookupTag3;
            ConeKotlinType coneKotlinType = dispatchReceiver.getType();
            while (n < n2) {
                int n3 = n++;
                coneStarProjectionArray[n3] = ConeStarProjection.INSTANCE;
            }
            ConeClassLikeLookupTag dispatchReceiverValueOwnerLookupTag = LookupTagUtilsKt.findClassRepresentation(coneKotlinType, TypeConstructionUtilsKt.constructClassType$default(coneClassLikeLookupTag4, coneStarProjectionArray, true, null, 4, null), session2);
            if (!Intrinsics.areEqual(coneClassLikeLookupTag3, dispatchReceiverValueOwnerLookupTag)) {
                return false;
            }
        }
        for (FirDeclaration firDeclaration : containingDeclarationOfUseSite) {
            FirClassSymbol<? extends FirClass> boundSymbol;
            if (!(firDeclaration instanceof FirClass) || !this.isSame((boundSymbol = ((FirClass)firDeclaration).getSymbol()).getClassId(), ownerLookupTag.getClassId())) continue;
            return true;
        }
        return false;
    }

    private final boolean isSame(ClassId $this$isSame, ClassId other) {
        return Intrinsics.areEqual($this$isSame.getPackageFqName(), other.getPackageFqName()) && Intrinsics.areEqual($this$isSame.getRelativeClassName(), other.getRelativeClassName());
    }

    private final ConeClassLikeLookupTag ownerIfCompanion(ConeClassLikeLookupTag $this$ownerIfCompanion, FirSession session2) {
        boolean bl;
        if ($this$ownerIfCompanion.getClassId().isLocal()) {
            return null;
        }
        ClassId classId = $this$ownerIfCompanion.getClassId().getOuterClassId();
        if (classId == null) {
            return null;
        }
        ClassId outerClassId = classId;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$ownerIfCompanion, session2);
        FirRegularClassSymbol ownerSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        Object object = ownerSymbol;
        if (object != null && (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) != null) {
            Object $this$isCompanion$iv = object;
            boolean $i$f$isCompanion = false;
            bl = ((FirRegularClass)$this$isCompanion$iv).getStatus().isCompanion();
        } else {
            bl = false;
        }
        if (bl) {
            return new ConeClassLikeLookupTagImpl(outerClassId);
        }
        return null;
    }

    private final boolean canSeeProtectedMemberOf(FirClass containingUseSiteClass, ReceiverValue dispatchReceiver, ConeClassLikeLookupTag ownerLookupTag, FirSession session2, boolean isVariableOrNamedFunction, boolean isSyntheticProperty, SupertypeSupplier supertypeSupplier) {
        Object object = dispatchReceiver;
        if (object != null && (object = this.ownerIfCompanion((ReceiverValue)object, session2)) != null) {
            Object companionOwnerLookupTag = object;
            boolean bl = false;
            if (this.isSubClass(containingUseSiteClass, (ConeClassLikeLookupTag)companionOwnerLookupTag, session2, supertypeSupplier)) {
                return true;
            }
        }
        return !this.isSubClass(containingUseSiteClass, ownerLookupTag, session2, supertypeSupplier) ? false : (isVariableOrNamedFunction ? this.doesReceiverFitForProtectedVisibility(dispatchReceiver, containingUseSiteClass, ownerLookupTag, isSyntheticProperty, session2) : true);
    }

    private final boolean doesReceiverFitForProtectedVisibility(ReceiverValue dispatchReceiver, FirClass containingUseSiteClass, ConeClassLikeLookupTag ownerLookupTag, boolean isSyntheticProperty, FirSession session2) {
        TypeCheckerState typeCheckerState2;
        FirExpression explicitReceiver;
        if (dispatchReceiver == null) {
            return true;
        }
        ConeKotlinType dispatchReceiverType = dispatchReceiver.getType();
        if (dispatchReceiver instanceof ExpressionReceiverValue && (explicitReceiver = ((ExpressionReceiverValue)dispatchReceiver).getExplicitReceiver()) instanceof FirPropertyAccessExpression && ((FirPropertyAccessExpression)explicitReceiver).getCalleeReference() instanceof FirSuperReference) {
            dispatchReceiverType = FirTypeUtilsKt.getConeType(((FirPropertyAccessExpression)explicitReceiver).getDispatchReceiver().getTypeRef());
        }
        if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2 = TypeComponentsKt.getTypeContext(session2).newTypeCheckerState(false, false), (KotlinTypeMarker)TypeExpansionUtilsKt.fullyExpandedType(dispatchReceiverType, session2), (KotlinTypeMarker)ScopeUtilsKt.typeWithStarProjections(containingUseSiteClass), false, 8, null)) {
            return true;
        }
        if (isSyntheticProperty) {
            return FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.ImproveReportingDiagnosticsOnProtectedMembersOfBaseClass) ? Intrinsics.areEqual(FirDeclarationUtilKt.getClassId(containingUseSiteClass).getPackageFqName(), ownerLookupTag.getClassId().getPackageFqName()) : true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSubClass(FirClass $this$isSubClass, ConeClassLikeLookupTag ownerLookupTag, FirSession session2, SupertypeSupplier supertypeSupplier) {
        boolean bl;
        block4: {
            void $this$any$iv;
            if (this.isSame(FirDeclarationUtilKt.getClassId($this$isSubClass), ownerLookupTag.getClassId())) {
                return true;
            }
            Iterable iterable = SupertypeUtilsKt.lookupSuperTypes($this$isSubClass, true, true, session2, false, supertypeSupplier);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType superType2 = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    Object object = superType2 instanceof ConeClassLikeType ? superType2 : null;
                    boolean bl3 = object != null && (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)object, session2, null, 2, null)) != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? this.isSame((ClassId)object, ownerLookupTag.getClassId()) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final ConeClassLikeLookupTag ownerIfCompanion(ReceiverValue $this$ownerIfCompanion, FirSession session2) {
        ReceiverValue receiverValue = $this$ownerIfCompanion;
        ConeKotlinType coneKotlinType = receiverValue != null ? receiverValue.getType() : null;
        Object object = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        return object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? this.ownerIfCompanion((ConeClassLikeLookupTag)object, session2) : null;
    }

    private final boolean isAllowedToBeAccessedFromOutside(FirSimpleFunction $this$isAllowedToBeAccessedFromOutside) {
        FirDeclaration $this$isFromLibrary$iv = $this$isAllowedToBeAccessedFromOutside;
        boolean $i$f$isFromLibrary = false;
        if (!(Intrinsics.areEqual($this$isFromLibrary$iv.getOrigin(), FirDeclarationOrigin.Library.INSTANCE) || Intrinsics.areEqual($this$isFromLibrary$iv.getOrigin(), FirDeclarationOrigin.Java.Library.INSTANCE))) {
            return false;
        }
        String string2 = $this$isAllowedToBeAccessedFromOutside.getSymbol().getCallableId().getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "symbol.callableId.packageName.asString()");
        String packageName = string2;
        String string3 = $this$isAllowedToBeAccessedFromOutside.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string3, "name.asString()");
        String name = string3;
        return Intrinsics.areEqual(packageName, "kotlin.jvm.internal.unsafe") && (Intrinsics.areEqual(name, "monitorEnter") || Intrinsics.areEqual(name, "monitorExit"));
    }

    protected final boolean canSeeProtectedMemberOf(@NotNull FirBasedSymbol<?> usedSymbol, @NotNull List<? extends FirDeclaration> containingDeclarationOfUseSite, @Nullable ReceiverValue dispatchReceiver, @NotNull ConeClassLikeLookupTag ownerLookupTag, @NotNull FirSession session2, boolean isVariableOrNamedFunction, boolean isSyntheticProperty, @NotNull SupertypeSupplier supertypeSupplier) {
        Intrinsics.checkNotNullParameter(usedSymbol, "usedSymbol");
        Intrinsics.checkNotNullParameter(containingDeclarationOfUseSite, "containingDeclarationOfUseSite");
        Intrinsics.checkNotNullParameter(ownerLookupTag, "ownerLookupTag");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(supertypeSupplier, "supertypeSupplier");
        if (this.canSeePrivateMemberOf(usedSymbol, containingDeclarationOfUseSite, ownerLookupTag, dispatchReceiver, isVariableOrNamedFunction, session2)) {
            return true;
        }
        for (FirDeclaration firDeclaration : containingDeclarationOfUseSite) {
            FirClassSymbol<? extends FirClass> boundSymbol;
            if (!(firDeclaration instanceof FirClass ? this.canSeeProtectedMemberOf((FirClass)(boundSymbol = ((FirClass)firDeclaration).getSymbol()).getFir(), dispatchReceiver, ownerLookupTag, session2, isVariableOrNamedFunction, isSyntheticProperty, supertypeSupplier) : firDeclaration instanceof FirFile && isSyntheticProperty && FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.ImproveReportingDiagnosticsOnProtectedMembersOfBaseClass) && Intrinsics.areEqual(UtilsKt.getPackageFqName((FirFile)firDeclaration), ownerLookupTag.getClassId().getPackageFqName()))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected final FqName packageFqName(@NotNull FirBasedSymbol<?> $this$packageFqName) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$packageFqName, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$packageFqName;
        if (firBasedSymbol instanceof FirClassLikeSymbol) {
            FqName fqName3 = ((FirClassLikeSymbol)$this$packageFqName).getClassId().getPackageFqName();
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue(fqName3, "classId.packageFqName");
        } else if (firBasedSymbol instanceof FirCallableSymbol) {
            fqName2 = ((FirCallableSymbol)$this$packageFqName).getCallableId().getPackageName();
        } else {
            throw new IllegalStateException(("No package fq name for " + $this$packageFqName).toString());
        }
        return fqName2;
    }

    public static final /* synthetic */ FirClassLikeDeclaration access$containingNonLocalClass(FirVisibilityChecker $this, FirClassLikeDeclaration $receiver, FirSession session2) {
        return $this.containingNonLocalClass($receiver, session2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/FirVisibilityChecker$Default;", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "()V", "platformVisibilityCheck", "", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isCallToPropertySetter", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "providers"})
    public static final class Default
    extends FirVisibilityChecker {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        protected boolean platformVisibilityCheck(@NotNull Visibility declarationVisibility, @NotNull FirBasedSymbol<?> symbol2, @NotNull FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @Nullable ReceiverValue dispatchReceiver, @NotNull FirSession session2, boolean isCallToPropertySetter, @NotNull SupertypeSupplier supertypeSupplier) {
            Intrinsics.checkNotNullParameter(declarationVisibility, "declarationVisibility");
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            Intrinsics.checkNotNullParameter(useSiteFile, "useSiteFile");
            Intrinsics.checkNotNullParameter(containingDeclarations, "containingDeclarations");
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(supertypeSupplier, "supertypeSupplier");
            return true;
        }
    }
}

