/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeKind;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EnterNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ExitNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.UnionFunctionCallArgumentsNode;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0001'B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\u00020\u0015*\u00020\nH\u0002J\u0014\u0010!\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020\u0015*\u00020\u0012H\u0002J\u0014\u0010%\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0014\u0010&\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\nH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderLevels", "", "(Ljava/lang/StringBuilder;Z)V", "allGraphs", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "clusterCounter", "", "indices", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "nodeCounter", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "topLevelGraphs", "initializeNodes", "", "graph", "visitControlFlowGraphReference", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "collectNodes", "enterCluster", "color", "", "exitCluster", "renderEdges", "renderNodes", "Companion", "resolve"})
public final class FirControlFlowGraphRenderVisitor
extends FirVisitorVoid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean renderLevels;
    @NotNull
    private final Printer printer;
    private int nodeCounter;
    private int clusterCounter;
    @NotNull
    private final Map<CFGNode<?>, Integer> indices;
    @NotNull
    private final Set<ControlFlowGraph> topLevelGraphs;
    @NotNull
    private final Set<ControlFlowGraph> allGraphs;
    @NotNull
    private static final Regex DIGIT_REGEX = new Regex("\\d");
    @NotNull
    private static final EnumMap<EdgeKind, String> EDGE_STYLE;

    public FirControlFlowGraphRenderVisitor(@NotNull StringBuilder builder2, boolean renderLevels) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        this.renderLevels = renderLevels;
        this.printer = new Printer(builder2);
        this.indices = new LinkedHashMap();
        this.topLevelGraphs = new LinkedHashSet();
        this.allGraphs = new LinkedHashSet();
    }

    public /* synthetic */ FirControlFlowGraphRenderVisitor(StringBuilder stringBuilder2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(stringBuilder2, bl);
    }

    @Override
    public void visitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        String name = StringsKt.replace$default(file2.getName(), ".", "_", false, 4, null);
        if (DIGIT_REGEX.matches(String.valueOf(StringsKt.first(name)))) {
            name = '_' + name;
        }
        Object object = new Object[]{"digraph " + name + " {"};
        Printer printer = this.printer.println((Object[])object).pushIndent();
        object = new Object[]{"graph [nodesep=3]"};
        Printer printer2 = printer.println((Object[])object);
        object = new Object[]{"node [shape=box penwidth=2]"};
        Printer printer3 = printer2.println((Object[])object);
        object = new Object[]{"edge [penwidth=2]"};
        printer3.println((Object[])object).println(new Object[0]);
        this.visitElement(file2);
        for (ControlFlowGraph topLevelGraph : this.topLevelGraphs) {
            this.renderNodes(this.printer, topLevelGraph);
            this.renderEdges(this.printer, topLevelGraph);
            this.printer.println(new Object[0]);
        }
        object = new Object[]{"}"};
        this.printer.popIndent().println((Object[])object);
    }

    private final void collectNodes(ControlFlowGraph $this$collectNodes) {
        for (CFGNode<?> node : $this$collectNodes.getNodes()) {
            Map<CFGNode<?>, Integer> map = this.indices;
            int n = this.nodeCounter;
            this.nodeCounter = n + 1;
            Integer n2 = n;
            map.put(node, n2);
        }
    }

    private final void renderNodes(Printer $this$renderNodes, ControlFlowGraph graph2) {
        String color = "red";
        List sortedNodes2 = ControlFlowGraphRendererKt.access$sortedNodes(graph2);
        for (CFGNode node : sortedNodes2) {
            String label;
            Object[] objectArray;
            if (node instanceof EnterNodeMarker) {
                this.enterCluster($this$renderNodes, color);
                color = "blue";
            }
            List attributes2 = new ArrayList();
            Object[] $this$renderNodes_u24lambda_u240 = objectArray = new StringBuilder();
            boolean bl = false;
            $this$renderNodes_u24lambda_u240.append(StringsKt.replace$default(CFGNodeRendererKt.render(node), "\"", "", false, 4, null));
            if (this.renderLevels) {
                $this$renderNodes_u24lambda_u240.append(" [" + node.getLevel() + ']');
            }
            Intrinsics.checkNotNullExpressionValue(objectArray.toString(), "StringBuilder().apply(builderAction).toString()");
            ((Collection)attributes2).add("label=\"" + label + '\"');
            if (Intrinsics.areEqual(node, node.getOwner().getEnterNode()) || Intrinsics.areEqual(node, node.getOwner().getExitNode())) {
                FirControlFlowGraphRenderVisitor.renderNodes$fillColor(attributes2, "red");
            }
            if (node.isDead()) {
                FirControlFlowGraphRenderVisitor.renderNodes$fillColor(attributes2, "gray");
            } else if (node instanceof UnionFunctionCallArgumentsNode) {
                FirControlFlowGraphRenderVisitor.renderNodes$fillColor(attributes2, "yellow");
            }
            objectArray = new Object[]{MapsKt.getValue(this.indices, node), CollectionsKt.joinToString$default(attributes2, " ", " [", "];", 0, null, null, 56, null)};
            $this$renderNodes.println(objectArray);
            if (!(node instanceof ExitNodeMarker)) continue;
            this.exitCluster($this$renderNodes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderEdges(Printer $this$renderEdges, ControlFlowGraph graph2) {
        for (CFGNode<?> node : graph2.getNodes()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            List<ControlFlowGraph> subNodes;
            if (node.getFollowingNodes().isEmpty()) continue;
            for (EdgeKind kind : EdgeKind.values()) {
                FirControlFlowGraphRenderVisitor.renderEdges$renderEdges(node, $this$renderEdges, this, kind);
            }
            if (!(node instanceof CFGNodeWithSubgraphs) || !(!((Collection)(subNodes = ((CFGNodeWithSubgraphs)node).getSubGraphs())).isEmpty())) continue;
            Object[] objectArray = new Object[3];
            objectArray[0] = MapsKt.getValue(this.indices, node);
            objectArray[1] = " -> ";
            Iterable iterable = subNodes;
            int n = 2;
            Object[] objectArray2 = objectArray;
            Printer printer = $this$renderEdges;
            boolean $i$f$mapNotNull = false;
            void var9_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ControlFlowGraph it = (ControlFlowGraph)element$iv$iv;
                boolean bl2 = false;
                if (this.indices.get(it.getEnterNode()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            objectArray2[n] = CollectionsKt.joinToString$default(list2, " ", "{", "}", 0, null, null, 56, null);
            printer.print(objectArray);
            objectArray = new Object[]{" [style=dashed]"};
            $this$renderEdges.printWithNoIndent(objectArray);
            objectArray = new Object[]{";"};
            $this$renderEdges.printlnWithNoIndent(objectArray);
        }
        for (ControlFlowGraph subGraph : graph2.getSubGraphs()) {
            this.renderEdges($this$renderEdges, subGraph);
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        element.acceptChildren(this);
    }

    @Override
    public void visitControlFlowGraphReference(@NotNull FirControlFlowGraphReference controlFlowGraphReference) {
        Intrinsics.checkNotNullParameter(controlFlowGraphReference, "controlFlowGraphReference");
        Object object = controlFlowGraphReference instanceof FirControlFlowGraphReferenceImpl ? (FirControlFlowGraphReferenceImpl)controlFlowGraphReference : null;
        if (object == null || (object = ((FirControlFlowGraphReferenceImpl)object).getControlFlowGraph()) == null) {
            return;
        }
        Object controlFlowGraph = object;
        this.initializeNodes((ControlFlowGraph)controlFlowGraph);
    }

    private final void initializeNodes(ControlFlowGraph graph2) {
        if (this.allGraphs.contains(graph2)) {
            return;
        }
        this.collectNodes(graph2);
        if (graph2.getOwner() == null) {
            ((Collection)this.topLevelGraphs).add(graph2);
        }
        ((Collection)this.allGraphs).add(graph2);
        for (ControlFlowGraph subGraph : graph2.getSubGraphs()) {
            this.initializeNodes(subGraph);
        }
    }

    private final void enterCluster(Printer $this$enterCluster, String color) {
        Object[] objectArray = new Object[1];
        int n = this.clusterCounter;
        this.clusterCounter = n + 1;
        objectArray[0] = "subgraph cluster_" + n + " {";
        $this$enterCluster.println(objectArray);
        $this$enterCluster.pushIndent();
        objectArray = new Object[]{"color=" + color};
        $this$enterCluster.println(objectArray);
    }

    private final void exitCluster(Printer $this$exitCluster) {
        $this$exitCluster.popIndent();
        Object[] objectArray = new Object[]{"}"};
        $this$exitCluster.println(objectArray);
    }

    private static final void renderNodes$fillColor(List<String> attributes2, String color) {
        ((Collection)attributes2).add("style=\"filled\"");
        ((Collection)attributes2).add("fillcolor=" + color);
    }

    private static final void renderEdges$renderEdges$renderEdgesWithoutLabel(Printer $this_renderEdges, FirControlFlowGraphRenderVisitor this$0, CFGNode<?> node, EdgeKind $kind, List<? extends CFGNode<?>> edges) {
        Object[] objectArray = new Object[]{MapsKt.getValue(this$0.indices, node), " -> ", CollectionsKt.joinToString$default(edges, " ", "{", "}", 0, null, new Function1<CFGNode<?>, CharSequence>(this$0){
            final /* synthetic */ FirControlFlowGraphRenderVisitor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull CFGNode<?> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return String.valueOf(((Number)MapsKt.getValue(FirControlFlowGraphRenderVisitor.access$getIndices$p(this.this$0), it)).intValue());
            }
        }, 24, null)};
        $this_renderEdges.print(objectArray);
        Object v = MapsKt.getValue((Map)EDGE_STYLE, $kind);
        String it = (String)v;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue(it, "it");
        String string2 = (String)(!StringsKt.isBlank(it) ? v : null);
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            Object[] objectArray2 = new Object[]{' ' + it};
            $this_renderEdges.printWithNoIndent(objectArray2);
        }
        objectArray = new Object[]{";"};
        $this_renderEdges.printlnWithNoIndent(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final void renderEdges$renderEdges(CFGNode<?> node, Printer $this_renderEdges, FirControlFlowGraphRenderVisitor this$0, EdgeKind kind) {
        boolean bl;
        List edges;
        block13: {
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = node.getFollowingNodes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                CFGNode it = (CFGNode)element$iv$iv;
                boolean bl2 = false;
                if (!(MapsKt.getValue(node.getOutgoingEdges(), it).getKind() == kind)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            edges = (List)destination$iv$iv;
            if (edges.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = edges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CFGNode it = (CFGNode)element$iv;
                    boolean bl3 = false;
                    Object object = node.getOutgoingEdges().get(it);
                    if (!((object != null && (object = ((Edge)object).getLabel()) != null ? ((EdgeLabel)object).getLabel() : null) != null)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$groupByTo$iv$iv;
            Object element$iv;
            Iterable $this$groupBy$iv = edges;
            boolean $i$f$groupBy = false;
            element$iv = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                CFGNode it = (CFGNode)element$iv$iv;
                boolean bl4 = false;
                Object object2 = node.getOutgoingEdges().get(it);
                Boolean key$iv$iv = (object2 != null && (object2 = ((Edge)object2).getLabel()) != null ? ((EdgeLabel)object2).getLabel() : null) != null;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map edgeGroups = destination$iv$iv;
            List list2 = (List)edgeGroups.get(false);
            if (list2 != null) {
                List it = list2;
                boolean bl6 = false;
                FirControlFlowGraphRenderVisitor.renderEdges$renderEdges$renderEdgesWithoutLabel($this_renderEdges, this$0, node, kind, it);
            }
            Object v = edgeGroups.get(true);
            Intrinsics.checkNotNull(v);
            for (CFGNode edge : (List)v) {
                Object[] objectArray = new Object[]{MapsKt.getValue(this$0.indices, node), " -> ", "{", MapsKt.getValue(this$0.indices, edge), "}"};
                $this_renderEdges.print(objectArray);
                Object v2 = MapsKt.getValue((Map)EDGE_STYLE, kind);
                String it = (String)v2;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                String string2 = (String)(!StringsKt.isBlank(it) ? v2 : null);
                if (string2 != null) {
                    it = string2;
                    boolean bl8 = false;
                    Object[] objectArray2 = new Object[]{' ' + it};
                    $this_renderEdges.printWithNoIndent(objectArray2);
                }
                objectArray = new Object[1];
                StringBuilder stringBuilder2 = new StringBuilder().append("[label=");
                Edge edge2 = node.getOutgoingEdges().get(edge);
                Intrinsics.checkNotNull(edge2);
                objectArray[0] = stringBuilder2.append(edge2.getLabel()).append(']').toString();
                $this_renderEdges.print(objectArray);
                objectArray = new Object[]{";"};
                $this_renderEdges.printlnWithNoIndent(objectArray);
            }
        } else {
            FirControlFlowGraphRenderVisitor.renderEdges$renderEdges$renderEdgesWithoutLabel($this_renderEdges, this$0, node, kind, edges);
        }
    }

    public static final /* synthetic */ Map access$getIndices$p(FirControlFlowGraphRenderVisitor $this) {
        return $this.indices;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(EdgeKind.Forward, ""), TuplesKt.to(EdgeKind.DeadForward, "[style=dotted]"), TuplesKt.to(EdgeKind.CfgForward, "[color=green]"), TuplesKt.to(EdgeKind.DfgForward, "[color=red]"), TuplesKt.to(EdgeKind.CfgBackward, "[color=green style=dashed]"), TuplesKt.to(EdgeKind.DeadBackward, "[color=green style=dotted]")};
        EDGE_STYLE = new EnumMap(MapsKt.mapOf(pairArray));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor$Companion;", "", "()V", "BLUE", "", "DIGIT_REGEX", "Lkotlin/text/Regex;", "EDGE", "EDGE_STYLE", "Ljava/util/EnumMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeKind;", "kotlin.jvm.PlatformType", "RED", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

