/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/EnumTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "entries", "", "psi", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/List;Lcom/intellij/psi/PsiElement;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getEntries", "()Ljava/util/List;", "createFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateStandardMethods", "", "generateValueOfFunction", "generateValuesFunction", "js.translator"})
public final class EnumTranslator
extends AbstractTranslator {
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final List<ClassDescriptor> entries;
    @NotNull
    private final PsiElement psi;

    public EnumTranslator(@NotNull TranslationContext context, @NotNull ClassDescriptor descriptor2, @NotNull List<? extends ClassDescriptor> entries, @NotNull PsiElement psi) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(entries, "entries");
        Intrinsics.checkNotNullParameter(psi, "psi");
        super(context);
        this.descriptor = descriptor2;
        this.entries = entries;
        this.psi = psi;
    }

    @NotNull
    public final ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final List<ClassDescriptor> getEntries() {
        return this.entries;
    }

    public final void generateStandardMethods() {
        this.generateValuesFunction();
        this.generateValueOfFunction();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValuesFunction() {
        void $this$mapTo$iv$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), StandardNames.ENUM_VALUES);
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getFunctionByName(descri\u2026tandardNames.ENUM_VALUES)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassDescriptor classDescriptor = (ClassDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)it), null), new JsExpression[0]).source(this.psi));
        }
        List values2 = (List)destination$iv$iv;
        List<JsStatement> list2 = function2.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "function.body.statements");
        Collection collection = list2;
        Object $this$generateValuesFunction_u24lambda_u241 = object = new JsReturn(new JsArrayLiteral(values2).source(this.psi));
        boolean bl = false;
        ((SourceInfoAwareJsNode)$this$generateValuesFunction_u24lambda_u241).setSource(this.psi);
        collection.add(object);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateValueOfFunction() {
        void $this$mapTo$iv$iv;
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(this.descriptor.getStaticScope(), StandardNames.ENUM_VALUE_OF);
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getFunctionByName(descri\u2026ndardNames.ENUM_VALUE_OF)");
        JsFunction function2 = this.createFunction(functionDescriptor);
        JsName jsName = JsScope.declareTemporaryName("name");
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(\"name\")");
        JsName nameParam = jsName;
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "function.parameters");
        Collection collection = list2;
        collection.add(new JsParameter(nameParam));
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        JsExpression[] destination$iv$iv = (JsExpression[])new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsReturn jsReturn;
            void entry;
            JsCase jsCase;
            ClassDescriptor classDescriptor = (ClassDescriptor)item$iv$iv;
            JsExpression[] jsExpressionArray = destination$iv$iv;
            boolean bl = false;
            JsCase $this$generateValueOfFunction_u24lambda_u244_u24lambda_u243 = jsCase = new JsCase();
            boolean bl2 = false;
            $this$generateValueOfFunction_u24lambda_u244_u24lambda_u243.setCaseExpression(new JsStringLiteral(entry.getName().asString()).source(this.psi));
            List<JsStatement> list3 = $this$generateValueOfFunction_u24lambda_u244_u24lambda_u243.getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "statements");
            Collection collection2 = list3;
            JsReturn $this$generateValueOfFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242 = jsReturn = new JsReturn((JsExpression)new JsInvocation((JsExpression)JsAstUtils.pureFqn(this.context().getNameForObjectInstance((ClassDescriptor)entry), null), new JsExpression[0]).source(this.psi));
            boolean bl3 = false;
            $this$generateValueOfFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setSource(this.psi);
            collection2.add(jsReturn);
            $this$generateValueOfFunction_u24lambda_u244_u24lambda_u243.setSource(this.psi);
            jsExpressionArray.add(jsCase);
        }
        List clauses = (List)destination$iv$iv;
        JsBinaryOperation message = new JsBinaryOperation(JsBinaryOperator.ADD, new JsStringLiteral("No enum constant " + DescriptorUtilsKt.getFqNameSafe(this.descriptor) + '.'), nameParam.makeRef());
        JsExpression jsExpression = this.context().getReferenceToIntrinsic("throwISE");
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context().getReferenceTo\u2026STATE_EXCEPTION_FUN_NAME)");
        JsExpression throwFunction = jsExpression;
        destination$iv$iv = new JsExpression[]{message};
        JsExpressionStatement throwStatement = new JsExpressionStatement((JsExpression)new JsInvocation(throwFunction, destination$iv$iv).source(this.psi));
        if (!((Collection)clauses).isEmpty()) {
            JsSwitch jsSwitch;
            JsDefault jsDefault;
            JsDefault $this$generateValueOfFunction_u24lambda_u245 = jsDefault = new JsDefault();
            boolean bl = false;
            List<JsStatement> list4 = $this$generateValueOfFunction_u24lambda_u245.getStatements();
            Intrinsics.checkNotNullExpressionValue(list4, "statements");
            ((Collection)list4).add(throwStatement);
            $this$generateValueOfFunction_u24lambda_u245.setSource(this.psi);
            JsDefault defaultCase = jsDefault;
            List<JsStatement> list5 = function2.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list5, "function.body.statements");
            Collection collection3 = list5;
            JsSwitch $this$generateValueOfFunction_u24lambda_u246 = jsSwitch = new JsSwitch(nameParam.makeRef().source(this.psi), CollectionsKt.plus((Collection)clauses, defaultCase));
            boolean bl4 = false;
            $this$generateValueOfFunction_u24lambda_u246.setSource(this.psi);
            collection3.add(jsSwitch);
        } else {
            List<JsStatement> list6 = function2.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list6, "function.body.statements");
            ((Collection)list6).add(throwStatement);
        }
    }

    private final JsFunction createFunction(FunctionDescriptor functionDescriptor) {
        JsFunction jsFunction = this.context().getFunctionObject(functionDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsFunction, "context().getFunctionObject(functionDescriptor)");
        JsFunction function2 = jsFunction;
        function2.setName(this.context().getInnerNameForDescriptor(functionDescriptor));
        function2.setSource(this.psi);
        this.context().addDeclarationStatement(function2.makeStmt());
        JsExpression jsExpression = this.context().getInnerReference(this.descriptor);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context().getInnerReference(descriptor)");
        JsExpression classRef = jsExpression;
        JsNameRef jsNameRef = function2.getName().makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "function.name.makeRef()");
        JsNameRef functionRef = jsNameRef;
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(new JsNameRef(this.context().getNameForDescriptor(functionDescriptor), classRef), functionRef);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "assignment(JsNameRef(con\u2026, classRef), functionRef)");
        JsBinaryOperation assignment = jsBinaryOperation;
        this.context().addDeclarationStatement(assignment.makeStmt());
        return function2;
    }
}

