/*
 * Decompiled with CFR 0.152.
 */
package org.jpeg.jpegxl.wrapper;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jpeg.jpegxl.wrapper.DecoderJni;
import org.jpeg.jpegxl.wrapper.ImageData;
import org.jpeg.jpegxl.wrapper.PixelFormat;
import org.jpeg.jpegxl.wrapper.Status;
import org.jpeg.jpegxl.wrapper.StreamInfo;

public class Decoder {
    private Decoder() {
    }

    public static ImageData decode(Buffer buffer, PixelFormat pixelFormat) {
        ByteBuffer byteBuffer;
        StreamInfo streamInfo = DecoderJni.getBasicInfo(buffer, pixelFormat);
        if (streamInfo.status != Status.OK) {
            throw new IllegalStateException("Decoding failed");
        }
        if (streamInfo.width < 0 || streamInfo.height < 0 || streamInfo.pixelsSize < 0 || streamInfo.iccSize < 0) {
            throw new IllegalStateException("JNI has returned negative size");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(streamInfo.pixelsSize);
        Status status = DecoderJni.getPixels(buffer, byteBuffer2, byteBuffer = ByteBuffer.allocateDirect(streamInfo.iccSize), pixelFormat);
        if (status != Status.OK) {
            throw new IllegalStateException("Decoding failed");
        }
        return new ImageData(streamInfo.width, streamInfo.height, byteBuffer2, byteBuffer, pixelFormat);
    }

    public static StreamInfo decodeInfo(Buffer buffer) {
        return DecoderJni.getBasicInfo(buffer, null);
    }
}

