/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.clsdescriptioneditor;

import java.util.Collections;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.model.parser.ParserUtil;
import org.protege.editor.owl.model.parser.ProtegeOWLEntityChecker;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserImpl;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

class OWLClassAxiomChecker
implements OWLExpressionChecker<OWLClassAxiom> {
    private OWLModelManager mngr;

    public OWLClassAxiomChecker(OWLModelManager mngr) {
        this.mngr = mngr;
    }

    @Override
    public void check(String text) throws OWLExpressionParserException {
        this.createObject(text);
    }

    @Override
    public OWLClassAxiom createObject(String text) throws OWLExpressionParserException {
        ManchesterOWLSyntaxParserImpl parser = new ManchesterOWLSyntaxParserImpl(OWLOntologyLoaderConfiguration::new, this.mngr.getOWLDataFactory());
        parser.setOWLEntityChecker((OWLEntityChecker)new ProtegeOWLEntityChecker(this.mngr.getOWLEntityFinder()));
        parser.setStringToParse(text);
        try {
            OWLAxiom ax = parser.parseAxiom();
            if (ax instanceof OWLClassAxiom) {
                return (OWLClassAxiom)ax;
            }
            throw new OWLExpressionParserException("Expected a class axiom of the form C SubClassOf D, C EquivalentTo D, or C DisjointWith D", 0, 0, true, true, true, false, false, false, Collections.emptySet());
        }
        catch (ParserException e) {
            throw ParserUtil.convertException(e);
        }
    }
}

