/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import org.semanticweb.owlapi.util.StringAnnotationVisitor;

public class AnnotationValueShortFormProvider
implements ShortFormProvider {
    @Nonnull
    private final OWLOntologySetProvider ontologySetProvider;
    @Nonnull
    private final ShortFormProvider alternateShortFormProvider;
    @Nonnull
    private final IRIShortFormProvider alternateIRIShortFormProvider;
    @Nonnull
    private final List<OWLAnnotationProperty> annotationProperties;
    @Nonnull
    private final Map<OWLAnnotationProperty, List<String>> preferredLanguageMap;
    @Nonnull
    private StringAnnotationVisitor literalRenderer = new StringAnnotationVisitor();

    public AnnotationValueShortFormProvider(@Nonnull List<OWLAnnotationProperty> annotationProperties, @Nonnull Map<OWLAnnotationProperty, List<String>> preferredLanguageMap, @Nonnull OWLOntologySetProvider ontologySetProvider) {
        this(annotationProperties, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public AnnotationValueShortFormProvider(@Nonnull List<OWLAnnotationProperty> annotationProperties, @Nonnull Map<OWLAnnotationProperty, List<String>> preferredLanguageMap, @Nonnull OWLOntologySetProvider ontologySetProvider, @Nonnull ShortFormProvider alternateShortFormProvider) {
        this(ontologySetProvider, alternateShortFormProvider, new SimpleIRIShortFormProvider(), annotationProperties, preferredLanguageMap);
    }

    public AnnotationValueShortFormProvider(@Nonnull OWLOntologySetProvider ontologySetProvider, @Nonnull ShortFormProvider alternateShortFormProvider, @Nonnull IRIShortFormProvider alternateIRIShortFormProvider, @Nonnull List<OWLAnnotationProperty> annotationProperties, @Nonnull Map<OWLAnnotationProperty, List<String>> preferredLanguageMap) {
        this.ontologySetProvider = OWLAPIPreconditions.checkNotNull(ontologySetProvider, "ontologySetProvider cannot be null");
        this.alternateShortFormProvider = OWLAPIPreconditions.checkNotNull(alternateShortFormProvider, "alternateShortFormProvider cannot be null");
        this.alternateIRIShortFormProvider = OWLAPIPreconditions.checkNotNull(alternateIRIShortFormProvider, "alternateIRIShortFormProvider cannot be null");
        this.annotationProperties = OWLAPIPreconditions.checkNotNull(annotationProperties, "annotationProperties cannot be null");
        this.preferredLanguageMap = OWLAPIPreconditions.checkNotNull(preferredLanguageMap, "preferredLanguageMap cannot be null");
    }

    @Override
    @Nonnull
    public String getShortForm(@Nonnull OWLEntity entity) {
        for (OWLAnnotationProperty prop : this.annotationProperties) {
            AnnotationLanguageFilter checker = new AnnotationLanguageFilter(prop, this.preferredLanguageMap.get(prop));
            for (OWLOntology ontology : this.ontologySetProvider.getOntologies()) {
                for (OWLOntology o : ontology.getImportsClosure()) {
                    for (OWLAxiom oWLAxiom : o.getAnnotationAssertionAxioms(entity.getIRI())) {
                        oWLAxiom.accept(checker);
                    }
                }
            }
            OWLObject match = checker.getMatch();
            if (match == null) continue;
            return this.getRendering(match);
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    @Nonnull
    private String getRendering(@Nonnull OWLObject object) {
        if (object instanceof OWLLiteral) {
            return this.literalRenderer.visit((OWLLiteral)object);
        }
        if (object instanceof IRI) {
            return this.alternateIRIShortFormProvider.getShortForm((IRI)object);
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    @Nonnull
    public List<OWLAnnotationProperty> getAnnotationProperties() {
        return this.annotationProperties;
    }

    @Nonnull
    public Map<OWLAnnotationProperty, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    @Override
    public void dispose() {
    }

    public void setLiteralRenderer(@Nonnull StringAnnotationVisitor literalRenderer) {
        this.literalRenderer = OWLAPIPreconditions.checkNotNull(literalRenderer);
    }

    private static class AnnotationLanguageFilter
    extends OWLObjectVisitorAdapter {
        private final OWLAnnotationProperty prop;
        private final List<String> preferredLanguages;
        @Nullable
        OWLObject candidateValue = null;
        int lastLangMatchIndex = Integer.MAX_VALUE;

        AnnotationLanguageFilter(OWLAnnotationProperty prop, List<String> preferredLanguages) {
            this.prop = prop;
            this.preferredLanguages = preferredLanguages;
        }

        @Nullable
        public OWLObject getMatch() {
            return this.candidateValue;
        }

        @Override
        public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
            if (this.lastLangMatchIndex > 0 && axiom.getProperty().equals(this.prop)) {
                axiom.getValue().accept(this);
            }
        }

        @Override
        public void visit(@Nonnull OWLLiteral node) {
            if (this.preferredLanguages == null || this.preferredLanguages.isEmpty()) {
                this.lastLangMatchIndex = 0;
                this.candidateValue = node;
            } else {
                int index = this.preferredLanguages.indexOf(node.getLang());
                if (index >= 0 && index < this.lastLangMatchIndex) {
                    this.lastLangMatchIndex = index;
                    this.candidateValue = node;
                }
            }
        }

        @Override
        public void visit(IRI iri) {
            this.candidateValue = iri;
        }
    }
}

