from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.TColgp import *
from OCC.Core.TColStd import *
from OCC.Core.Message import *


class Plate_Array1OfPinpointConstraint:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Plate_PinpointConstraint: ...
    def __setitem__(self, index: int, value: Plate_PinpointConstraint) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Plate_PinpointConstraint]: ...
    def next(self) -> Plate_PinpointConstraint: ...
    __next__ = next
    def Init(self, theValue: Plate_PinpointConstraint) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Plate_PinpointConstraint: ...
    def Last(self) -> Plate_PinpointConstraint: ...
    def Value(self, theIndex: int) -> Plate_PinpointConstraint: ...
    def SetValue(self, theIndex: int, theValue: Plate_PinpointConstraint) -> None: ...

class Plate_SequenceOfLinearScalarConstraint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Plate_LinearScalarConstraint: ...
    def Last(self) -> Plate_LinearScalarConstraint: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Plate_LinearScalarConstraint) -> Plate_LinearScalarConstraint: ...
    def Prepend(self, theItem: Plate_LinearScalarConstraint) -> Plate_LinearScalarConstraint: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Plate_LinearScalarConstraint: ...
    def SetValue(self, theIndex: int, theValue: Plate_LinearScalarConstraint) -> None: ...

class Plate_SequenceOfLinearXYZConstraint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Plate_LinearXYZConstraint: ...
    def Last(self) -> Plate_LinearXYZConstraint: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Plate_LinearXYZConstraint) -> Plate_LinearXYZConstraint: ...
    def Prepend(self, theItem: Plate_LinearXYZConstraint) -> Plate_LinearXYZConstraint: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Plate_LinearXYZConstraint: ...
    def SetValue(self, theIndex: int, theValue: Plate_LinearXYZConstraint) -> None: ...

class Plate_SequenceOfPinpointConstraint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Plate_PinpointConstraint: ...
    def Last(self) -> Plate_PinpointConstraint: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Plate_PinpointConstraint) -> Plate_PinpointConstraint: ...
    def Prepend(self, theItem: Plate_PinpointConstraint) -> Plate_PinpointConstraint: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Plate_PinpointConstraint: ...
    def SetValue(self, theIndex: int, theValue: Plate_PinpointConstraint) -> None: ...

class Plate_D1:
    @overload
    def __init__(self, du: gp_XYZ, dv: gp_XYZ) -> None: ...
    @overload
    def __init__(self, ref: Plate_D1) -> None: ...
    def DU(self) -> gp_XYZ: ...
    def DV(self) -> gp_XYZ: ...

class Plate_D2:
    @overload
    def __init__(self, duu: gp_XYZ, duv: gp_XYZ, dvv: gp_XYZ) -> None: ...
    @overload
    def __init__(self, ref: Plate_D2) -> None: ...

class Plate_D3:
    @overload
    def __init__(self, duuu: gp_XYZ, duuv: gp_XYZ, duvv: gp_XYZ, dvvv: gp_XYZ) -> None: ...
    @overload
    def __init__(self, ref: Plate_D3) -> None: ...

class Plate_FreeGtoCConstraint:
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, IncrementalLoad: Optional[float] = 1.0, orientation: Optional[int] = 0) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, D2S: Plate_D2, D2T: Plate_D2, IncrementalLoad: Optional[float] = 1.0, orientation: Optional[int] = 0) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, D2S: Plate_D2, D2T: Plate_D2, D3S: Plate_D3, D3T: Plate_D3, IncrementalLoad: Optional[float] = 1.0, orientation: Optional[int] = 0) -> None: ...
    def GetPPC(self, Index: int) -> Plate_PinpointConstraint: ...
    def LSC(self, Index: int) -> Plate_LinearScalarConstraint: ...
    def nb_LSC(self) -> int: ...
    def nb_PPC(self) -> int: ...

class Plate_GlobalTranslationConstraint:
    def __init__(self, SOfXY: TColgp_SequenceOfXY) -> None: ...
    def LXYZC(self) -> Plate_LinearXYZConstraint: ...

class Plate_GtoCConstraint:
    @overload
    def __init__(self, ref: Plate_GtoCConstraint) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, nP: gp_XYZ) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, D2S: Plate_D2, D2T: Plate_D2) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, D2S: Plate_D2, D2T: Plate_D2, nP: gp_XYZ) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, D2S: Plate_D2, D2T: Plate_D2, D3S: Plate_D3, D3T: Plate_D3) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, D1S: Plate_D1, D1T: Plate_D1, D2S: Plate_D2, D2T: Plate_D2, D3S: Plate_D3, D3T: Plate_D3, nP: gp_XYZ) -> None: ...
    def D1SurfInit(self) -> Plate_D1: ...
    def GetPPC(self, Index: int) -> Plate_PinpointConstraint: ...
    def nb_PPC(self) -> int: ...

class Plate_LineConstraint:
    def __init__(self, point2d: gp_XY, lin: gp_Lin, iu: Optional[int] = 0, iv: Optional[int] = 0) -> None: ...
    def LSC(self) -> Plate_LinearScalarConstraint: ...

class Plate_LinearScalarConstraint:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, thePPC1: Plate_PinpointConstraint, theCoeff: gp_XYZ) -> None: ...
    @overload
    def __init__(self, thePPC: Plate_Array1OfPinpointConstraint, theCoeff: TColgp_Array1OfXYZ) -> None: ...
    @overload
    def __init__(self, thePPC: Plate_Array1OfPinpointConstraint, theCoeff: TColgp_Array2OfXYZ) -> None: ...
    @overload
    def __init__(self, ColLen: int, RowLen: int) -> None: ...
    def Coeff(self) -> TColgp_Array2OfXYZ: ...
    def GetPPC(self) -> Plate_Array1OfPinpointConstraint: ...
    def SetCoeff(self, Row: int, Col: int, Value: gp_XYZ) -> None: ...
    def SetPPC(self, Index: int, Value: Plate_PinpointConstraint) -> None: ...

class Plate_LinearXYZConstraint:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, thePPC: Plate_Array1OfPinpointConstraint, theCoeff: TColStd_Array1OfReal) -> None: ...
    @overload
    def __init__(self, thePPC: Plate_Array1OfPinpointConstraint, theCoeff: TColStd_Array2OfReal) -> None: ...
    @overload
    def __init__(self, ColLen: int, RowLen: int) -> None: ...
    def Coeff(self) -> TColStd_Array2OfReal: ...
    def GetPPC(self) -> Plate_Array1OfPinpointConstraint: ...
    def SetCoeff(self, Row: int, Col: int, Value: float) -> None: ...
    def SetPPC(self, Index: int, Value: Plate_PinpointConstraint) -> None: ...

class Plate_PinpointConstraint:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, point2d: gp_XY, ImposedValue: gp_XYZ, iu: Optional[int] = 0, iv: Optional[int] = 0) -> None: ...
    def Idu(self) -> int: ...
    def Idv(self) -> int: ...
    def Pnt2d(self) -> gp_XY: ...
    def Value(self) -> gp_XYZ: ...

class Plate_PlaneConstraint:
    def __init__(self, point2d: gp_XY, pln: gp_Pln, iu: Optional[int] = 0, iv: Optional[int] = 0) -> None: ...
    def LSC(self) -> Plate_LinearScalarConstraint: ...

class Plate_Plate:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ref: Plate_Plate) -> None: ...
    def CoefPol(self, Coefs: TColgp_HArray2OfXYZ) -> None: ...
    def Continuity(self) -> int: ...
    def Copy(self, Ref: Plate_Plate) -> Plate_Plate: ...
    def Evaluate(self, point2d: gp_XY) -> gp_XYZ: ...
    def EvaluateDerivative(self, point2d: gp_XY, iu: int, iv: int) -> gp_XYZ: ...
    def Init(self) -> None: ...
    def IsDone(self) -> bool: ...
    @overload
    def Load(self, PConst: Plate_PinpointConstraint) -> None: ...
    @overload
    def Load(self, LXYZConst: Plate_LinearXYZConstraint) -> None: ...
    @overload
    def Load(self, LScalarConst: Plate_LinearScalarConstraint) -> None: ...
    @overload
    def Load(self, GTConst: Plate_GlobalTranslationConstraint) -> None: ...
    @overload
    def Load(self, LConst: Plate_LineConstraint) -> None: ...
    @overload
    def Load(self, PConst: Plate_PlaneConstraint) -> None: ...
    @overload
    def Load(self, SCConst: Plate_SampledCurveConstraint) -> None: ...
    @overload
    def Load(self, GtoCConst: Plate_GtoCConstraint) -> None: ...
    @overload
    def Load(self, FGtoCConst: Plate_FreeGtoCConstraint) -> None: ...
    def SetPolynomialPartOnly(self, PPOnly: Optional[bool] = True) -> None: ...
    def SolveTI(self, ord: Optional[int] = 4, anisotropie: Optional[float] = 1.0, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def UVBox(self) -> Tuple[float, float, float, float]: ...
    def UVConstraints(self, Seq: TColgp_SequenceOfXY) -> None: ...
    def destroy(self) -> None: ...

class Plate_SampledCurveConstraint:
    def __init__(self, SOPPC: Plate_SequenceOfPinpointConstraint, n: int) -> None: ...
    def LXYZC(self) -> Plate_LinearXYZConstraint: ...

# harray1 classes

class Plate_HArray1OfPinpointConstraint(Plate_Array1OfPinpointConstraint, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> Plate_Array1OfPinpointConstraint: ...

# harray2 classes
# hsequence classes

