% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.print-functions.R
\name{rk.capture.output}
\alias{rk.capture.output}
\alias{rk.end.capture.output}
\title{Capture output including system commands}
\usage{
rk.capture.output(
  capture.messages = TRUE,
  capture.output = TRUE,
  suppress.messages = FALSE,
  suppress.output = FALSE,
  allow.nesting = TRUE
)

rk.end.capture.output(highlight = FALSE)
}
\arguments{
\item{suppress.output}{output / message are not sent on, neither to surrounding captures, nor as regular output}

\item{allow.nesting}{if false, output / message is not sent to surrounding captures, but is sent to regular output (unless suppressed)

\code{rk.capture.output} Starts capturing output.

\code{rk.end.capture.output} Stops capturing output, and returns the recorded output in a string.}

\item{LANG}{language code to use. "C" for no translation, i.e. generally English}
}
\description{
This feature records and / or redirects output similar to the \code{\link{sink}} and \code{\link{capture.output}}
commands provided with R. Contrary to these two, \code{rk.capture.output} can also capture output generated by external
programs running via \code{\link{system}} (on both Windows and Unix platforms). Further it allows to capture both
warning messages and regular output to the same channel. Output can be passed on for printing, or suppressed,
with the default being to print it.
}
\details{
And arbitrary number of ouptut captures can be started and stopped, and these will form a push/pop stack.
}
