/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.ProfilerTopComponent;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.HelpCtx;

public final class ComponentDetailsProvider
extends DetailsProvider.Basic {
    private static final String JLABEL_MASK = "javax.swing.JLabel+";
    private static final String ABSTRACTBUTTON_MASK = "javax.swing.AbstractButton+";
    private static final String JTOOLTIP_MASK = "javax.swing.JToolTip+";
    private static final String JFILECHOOSER_MASK = "javax.swing.JFileChooser+";
    private static final String TABLECOLUMN_MASK = "javax.swing.table.TableColumn+";
    private static final String JPANEL_MASK = "javax.swing.JPanel+";
    private static final String JPROGRESSBAR_MASK = "javax.swing.JProgressBar+";
    private static final String JINTERNALFRAME_MASK = "javax.swing.JInternalFrame+";
    private static final String FRAME_MASK = "java.awt.Frame+";
    private static final String DIALOG_MASK = "java.awt.Dialog+";
    private static final String COMPONENT_MASK = "java.awt.Component+";

    public ComponentDetailsProvider() {
        super(JLABEL_MASK, ABSTRACTBUTTON_MASK, JTOOLTIP_MASK, JFILECHOOSER_MASK, JINTERNALFRAME_MASK, TABLECOLUMN_MASK, JPANEL_MASK, JPROGRESSBAR_MASK, FRAME_MASK, DIALOG_MASK, COMPONENT_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        boolean b;
        String string = null;
        if (JLABEL_MASK.equals(className) || ABSTRACTBUTTON_MASK.equals(className)) {
            string = DetailsUtils.getInstanceFieldString(instance, "text");
        } else if (JTOOLTIP_MASK.equals(className)) {
            string = DetailsUtils.getInstanceFieldString(instance, "tipText");
        } else if (JFILECHOOSER_MASK.equals(className)) {
            string = DetailsUtils.getInstanceFieldString(instance, "dialogTitle");
        } else if (JINTERNALFRAME_MASK.equals(className) || FRAME_MASK.equals(className) || DIALOG_MASK.equals(className)) {
            string = DetailsUtils.getInstanceFieldString(instance, "title");
        } else if (TABLECOLUMN_MASK.equals(className)) {
            string = DetailsUtils.getInstanceFieldString(instance, "headerValue");
        } else if (JPROGRESSBAR_MASK.equals(className) && (b = DetailsUtils.getBooleanFieldValue(instance, "paintString", false))) {
            string = DetailsUtils.getInstanceFieldString(instance, "progressString");
        }
        if (string == null) {
            string = ComponentDetailsProvider.getStringField(instance, "displayName");
            if (string == null) {
                string = ComponentDetailsProvider.getStringField(instance, "label");
            }
            if (string == null) {
                string = ComponentDetailsProvider.getStringField(instance, "name");
            }
            if (string != null && string.trim().isEmpty()) {
                string = null;
            }
        }
        if (string != null && !(b = DetailsUtils.getBooleanFieldValue(instance, "visible", false))) {
            string = Bundle.ComponentDetailsProvider_InvisibleComponentPrefix() + " " + string;
        }
        return string;
    }

    @Override
    public DetailsProvider.View getDetailsView(String className, Instance instance) {
        return new ComponentView(instance);
    }

    private static String getStringField(Instance instance, String field) {
        Object string = instance.getValueOfField(field);
        if (string instanceof Instance && String.class.getName().equals(((Instance)string).getJavaClass().getName())) {
            return DetailsUtils.getInstanceString((Instance)string);
        }
        return null;
    }

    private static class ComponentTopComponent
    extends ProfilerTopComponent {
        private static final String HELP_CTX_KEY = "HeapWalker.ComponentPreview.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("HeapWalker.ComponentPreview.HelpCtx");

        ComponentTopComponent(Component c, String className, int instanceNumber) {
            this.setName(BrowserUtils.getSimpleType(className) + " #" + instanceNumber);
            this.setToolTipText("Preview of " + className + " #" + instanceNumber);
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(c), "Center");
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }

    private static class ComponentView
    extends Utils.View<ComponentBuilders.ComponentBuilder> {
        private ComponentBuilders.ComponentBuilder builder;
        private Component component;
        private Component hover;
        private final MouseHandler mouse;
        private JComponent glassPane;
        private final String className;
        private final int instanceNumber;
        private final boolean enableNewWindow;
        private final boolean enableInteraction;

        ComponentView(Instance instance) {
            this(instance, null, true, false);
        }

        private ComponentView(Instance instance, ComponentBuilders.ComponentBuilder builder, boolean enableNewWindow, boolean enableInteraction) {
            super(instance);
            this.builder = builder;
            this.enableNewWindow = enableNewWindow;
            this.enableInteraction = enableInteraction;
            if (enableNewWindow || enableInteraction) {
                this.mouse = new MouseHandler();
                this.addMouseListener(this.mouse);
            } else {
                this.mouse = null;
            }
            if (enableNewWindow) {
                this.className = instance.getJavaClass().getName();
                this.instanceNumber = instance.getInstanceNumber();
            } else {
                this.className = null;
                this.instanceNumber = -1;
            }
        }

        @Override
        protected ComponentBuilders.ComponentBuilder getBuilder(Instance instance) {
            if (this.builder == null) {
                this.builder = ComponentBuilders.getBuilder(instance);
            }
            return this.builder;
        }

        @Override
        protected Component getComponent(ComponentBuilders.ComponentBuilder builder) {
            this.component = builder.createPresenter();
            if (this.component != null) {
                this.component.setVisible(true);
            }
            return this.component;
        }

        @Override
        protected void setupGlassPane(JPanel glassPane) {
            this.glassPane = glassPane;
            if (this.mouse != null) {
                glassPane.addMouseListener(this.mouse);
                if (this.enableInteraction) {
                    glassPane.addMouseMotionListener(this.mouse);
                }
            }
        }

        private void hoverChanged() {
            String toolTipText;
            if (this.hover != null) {
                JComponent jc = this.hover instanceof JComponent ? (JComponent)this.hover : null;
                Object cn = jc == null ? null : jc.getClientProperty("className");
                String name = cn == null ? "" : cn.toString();
                toolTipText = name.isEmpty() ? null : name;
            } else {
                toolTipText = null;
            }
            if (toolTipText == null) {
                ToolTipManager.sharedInstance().mousePressed(null);
            }
            this.glassPane.setToolTipText(toolTipText);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.hover != null) {
                Rectangle b = SwingUtilities.convertRectangle(this.hover.getParent(), this.hover.getBounds(), this);
                g.setColor(Color.RED);
                g.drawRect(b.x, b.y, b.width, b.height);
            }
        }

        static Component componentAt(Component comp, int x, int y) {
            if (!comp.contains(x, y)) {
                return null;
            }
            if (comp instanceof Container) {
                for (Component c : ((Container)comp).getComponents()) {
                    Component at;
                    if (c == null || !c.isVisible() || (at = ComponentView.componentAt(c, x - c.getX(), y - c.getY())) == null) continue;
                    return at;
                }
            }
            return comp;
        }

        private void showPopup(MouseEvent e) {
            if (!this.enableNewWindow || this.builder == null || this.component == null) {
                return;
            }
            JMenuItem test = new JMenuItem(Bundle.ComponentDetailsProvider_NewWindow()){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    this.openNewWindow();
                }
            };
            JPopupMenu popup = new JPopupMenu();
            popup.add(test);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }

        private void openNewWindow() {
            ComponentView c = new ComponentView(null, this.builder, false, true);
            ComponentTopComponent ctc = new ComponentTopComponent(c, this.className, this.instanceNumber);
            ctc.open();
            ctc.requestActive();
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ComponentView.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ComponentView.this.showPopup(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Component at;
                Component component = at = e == null ? null : ComponentView.componentAt(ComponentView.this.component, e.getX(), e.getY());
                if (ComponentView.this.hover == at) {
                    return;
                }
                ComponentView.this.hover = at;
                ComponentView.this.hoverChanged();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!ComponentView.this.enableInteraction) {
                    return;
                }
                this.mouseMoved(null);
            }
        }
    }
}

