/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.atom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class AtomWithMargin
extends AbstractAtom
implements Atom {
    private final double marginY1;
    private final double marginY2;
    private final Atom atom;

    public AtomWithMargin(Atom atom, double marginY1, double marginY2) {
        this.atom = atom;
        this.marginY1 = marginY1;
        this.marginY2 = marginY2;
    }

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        ArrayList<AtomWithMargin> result = new ArrayList<AtomWithMargin>();
        List<Atom> list = this.atom.splitInTwo(stringBounder, width);
        for (Atom a : list) {
            double y1 = this.marginY1;
            double y2 = this.marginY2;
            if (list.size() == 2 && result.size() == 0) {
                y2 = 0.0;
            }
            if (list.size() == 2 && result.size() == 1) {
                y1 = 0.0;
            }
            result.add(new AtomWithMargin(a, y1, y2));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.atom.calculateDimension(stringBounder), 0.0, this.marginY1 + this.marginY2);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.atom.getStartingAltitude(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.atom.drawU(ug.apply(UTranslate.dy(this.marginY1)));
    }
}

