/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.List;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.SquareLinker;
import net.sourceforge.plantuml.cucadiagram.SquareMaker;

class Magma {
    private final CucaDiagram diagram;
    private final List<ILeaf> standalones;
    private final LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();

    public Magma(CucaDiagram system, List<ILeaf> standalones) {
        this.diagram = system;
        this.standalones = standalones;
    }

    public void putInSquare() {
        SquareLinker<ILeaf> linker = new SquareLinker<ILeaf>(){

            @Override
            public void topDown(ILeaf top, ILeaf down) {
                Magma.this.diagram.addLink(new Link(Magma.this.diagram.getSkinParam().getCurrentStyleBuilder(), top, down, Magma.this.linkType, Display.NULL, 2));
            }

            @Override
            public void leftRight(ILeaf left, ILeaf right) {
                Magma.this.diagram.addLink(new Link(Magma.this.diagram.getSkinParam().getCurrentStyleBuilder(), left, right, Magma.this.linkType, Display.NULL, 1));
            }
        };
        new SquareMaker<ILeaf>().putInSquare(this.standalones, linker);
    }

    public IGroup getContainer() {
        IGroup parent = this.standalones.get(0).getParentContainer();
        if (parent == null) {
            return null;
        }
        return parent.getParentContainer();
    }

    public boolean isComplete() {
        IGroup parent = this.getContainer();
        if (parent == null) {
            return false;
        }
        return parent.size() == this.standalones.size();
    }

    private int squareSize() {
        return SquareMaker.computeBranch(this.standalones.size());
    }

    private ILeaf getTopLeft() {
        return this.standalones.get(0);
    }

    private ILeaf getBottomLeft() {
        int result = SquareMaker.getBottomLeft(this.standalones.size());
        return this.standalones.get(result);
    }

    private ILeaf getTopRight() {
        int s = this.squareSize();
        return this.standalones.get(s - 1);
    }

    public String toString() {
        return this.standalones.get(0).getParentContainer() + " " + this.standalones.toString() + " " + this.isComplete();
    }

    public void linkToDown(Magma down) {
        this.diagram.addLink(new Link(this.diagram.getSkinParam().getCurrentStyleBuilder(), this.getBottomLeft(), down.getTopLeft(), this.linkType, Display.NULL, 2));
    }

    public void linkToRight(Magma right) {
        this.diagram.addLink(new Link(this.diagram.getSkinParam().getCurrentStyleBuilder(), this.getTopRight(), right.getTopLeft(), this.linkType, Display.NULL, 1));
    }
}

