/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class ComponentRoseGroupingElse
extends AbstractTextualComponent {
    private final HColor groupBorder;
    private final HColor backgroundColor;
    private final double roundCorner;

    public ComponentRoseGroupingElse(Style style, CharSequence comment, ISkinSimple spriteContainer) {
        super(style, LineBreakStrategy.NONE, 5, 5, 1, spriteContainer, comment == null ? null : "[" + comment + "]");
        this.roundCorner = style.value(PName.RoundCorner).asInt();
        this.groupBorder = style.value(PName.LineColor).asColor(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        this.backgroundColor = style.value(PName.BackGroundColor).asColor(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        AbstractShadowable rect;
        if (HColors.isTransparent(this.backgroundColor)) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(HColors.none()).apply(this.backgroundColor.bg());
        double width = dimensionToUse.getWidth();
        double height = dimensionToUse.getHeight();
        if (this.roundCorner == 0.0) {
            rect = new URectangle(width, height);
        } else {
            UPath path = new UPath();
            path.moveTo(0.0, 0.0);
            path.lineTo(width, 0.0);
            path.lineTo(width, height - this.roundCorner / 2.0);
            path.arcTo(this.roundCorner / 2.0, this.roundCorner / 2.0, 0.0, 0.0, 1.0, width - this.roundCorner / 2.0, height);
            path.lineTo(this.roundCorner / 2.0, height);
            path.arcTo(this.roundCorner / 2.0, this.roundCorner / 2.0, 0.0, 0.0, 1.0, 0.0, height - this.roundCorner / 2.0);
            path.lineTo(0.0, 0.0);
            rect = path;
        }
        ug.draw(rect);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ArrowConfiguration.stroke(ug, 2.0, 2.0, 1.0).apply(this.groupBorder);
        ug.apply(UTranslate.dy(1.0)).draw(ULine.hline(dimensionToUse.getWidth()));
        ug = ug.apply(new UStroke());
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

