/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorAbstract;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class HColorScheme
extends HColorAbstract
implements HColor {
    private final HColor colorForLight;
    private final HColor colorForDark;
    private final HColor colorForTransparent;

    public HColorScheme(HColor colorForLight, HColor colorForDark, HColor colorForTransparent) {
        this.colorForLight = colorForLight;
        this.colorForDark = colorForDark;
        this.colorForTransparent = colorForTransparent;
    }

    public HColor getAppropriateColor(HColor back) {
        if (back == null || HColors.isTransparent(back)) {
            if (this.colorForTransparent != null) {
                return this.colorForTransparent;
            }
            return ((HColorSimple)this.colorForLight).withDark(this.colorForDark);
        }
        if (back.isDark()) {
            return this.colorForDark;
        }
        return this.colorForLight;
    }
}

