/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDumpInstance;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.HeapProgress;
import org.graalvm.visualvm.lib.jfluid.heap.HprofFieldObjectValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.HprofInstanceObjectValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.InstanceDump;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.LongBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.LongMap;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayDump;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;

class NearestGCRoot {
    private static final int BUFFER_SIZE = 8192;
    private static final String[] REF_CLASSES = new String[]{"java.lang.ref.WeakReference", "java.lang.ref.SoftReference", "java.lang.ref.FinalReference", "java.lang.ref.PhantomReference"};
    private static final String JAVA_LANG_REF_REFERENCE = "java.lang.ref.Reference";
    private static final String REFERENT_FIELD_NAME = "referent";
    private static final String SVM_REFFERENCE = "com.oracle.svm.core.heap.heapImpl.DiscoverableReference";
    private static final String SVM_REFFERENCE_1 = "com.oracle.svm.core.heap.DiscoverableReference";
    private static final String SVM_REFERENT_FIELD_NAME = "rawReferent";
    private Field referentField;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private LongBuffer leaves;
    private LongBuffer multipleParents;
    private Set<JavaClass> referenceClasses;
    private boolean gcRootsComputed;
    private long allInstances;
    private long processedInstances;

    NearestGCRoot(HprofHeap h) {
        this.heap = h;
    }

    Instance getNearestGCRootPointer(Instance instance) {
        if (this.heap.isGCRoot(instance)) {
            return instance;
        }
        this.computeGCRoots();
        long nextGCPathId = this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
        return this.heap.getInstanceByID(nextGCPathId);
    }

    private boolean isSpecialReference(FieldValue value, Instance instance) {
        Field f = value.getField();
        return f.equals(this.referentField) && this.referenceClasses.contains(instance.getJavaClass());
    }

    private synchronized void computeGCRoots() {
        if (this.gcRootsComputed) {
            return;
        }
        HeapProgress.progressStart();
        if (!this.initHotSpotReference() && !this.initSVMReference()) {
            throw new IllegalArgumentException("reference field not found");
        }
        this.heap.computeReferences();
        this.heap.cacheDirectory.setDirty(true);
        this.allInstances = this.heap.getSummary().getTotalLiveInstances();
        HashSet processedClasses = new HashSet(this.heap.getAllClasses().size() * 4 / 3);
        try {
            this.createBuffers();
            this.fillZeroLevel();
            do {
                this.switchBuffers();
                this.computeOneLevel(processedClasses);
            } while (this.hasMoreLevels());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.deleteBuffers();
        this.heap.idToOffsetMap.flush();
        this.gcRootsComputed = true;
        this.heap.writeToFile();
        HeapProgress.progressFinish();
    }

    private boolean initHotSpotReference() {
        this.referentField = this.computeReferentField(JAVA_LANG_REF_REFERENCE, REFERENT_FIELD_NAME);
        if (this.referentField != null) {
            this.referenceClasses = new HashSet<JavaClass>();
            for (int i = 0; i < REF_CLASSES.length; ++i) {
                JavaClass ref = this.heap.getJavaClassByName(REF_CLASSES[i]);
                if (ref == null) continue;
                this.referenceClasses.add(ref);
                this.referenceClasses.addAll(ref.getSubClasses());
            }
            return this.referenceClasses.size() >= REF_CLASSES.length;
        }
        return false;
    }

    private boolean initSVMReference() {
        this.referentField = this.computeReferentField(SVM_REFFERENCE, SVM_REFERENT_FIELD_NAME);
        if (this.referentField == null) {
            this.referentField = this.computeReferentField(SVM_REFFERENCE_1, SVM_REFERENT_FIELD_NAME);
        }
        if (this.referentField != null) {
            JavaClass ref = this.referentField.getDeclaringClass();
            this.referenceClasses = new HashSet<JavaClass>();
            this.referenceClasses.add(ref);
            this.referenceClasses.addAll(ref.getSubClasses());
            return !this.referenceClasses.isEmpty();
        }
        return false;
    }

    private void computeOneLevel(Set processedClasses) throws IOException {
        int idSize = this.heap.dumpBuffer.getIDSize();
        while (true) {
            List<FieldValue> fieldValues;
            long instanceOffset = this.readLong();
            boolean hasValues = false;
            if (instanceOffset == 0L) break;
            HeapProgress.progress(this.processedInstances++, this.allInstances);
            Instance instance = this.heap.getInstanceByOffset(new long[]{instanceOffset});
            if (instance instanceof ObjectArrayInstance) {
                ObjectArrayDump array = (ObjectArrayDump)instance;
                int size = array.getLength();
                long offset = array.getOffset();
                long instanceId = instance.getInstanceId();
                for (int i = 0; i < size; ++i) {
                    long referenceId = this.heap.dumpBuffer.getID(offset + (long)(i * idSize));
                    if (!this.writeConnection(instanceId, referenceId)) continue;
                    hasValues = true;
                }
                if (hasValues) continue;
                this.writeLeaf(instanceId, instance.getSize());
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                this.writeLeaf(instance.getInstanceId(), instance.getSize());
                continue;
            }
            if (instance instanceof ClassDumpInstance) {
                ClassDump javaClass = ((ClassDumpInstance)instance).classDump;
                fieldValues = javaClass.getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                fieldValues = instance.getFieldValues();
            } else {
                if (instance == null) {
                    System.err.println("HeapWalker Warning - null instance for " + this.heap.dumpBuffer.getID(instanceOffset + 1L));
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            long instanceId = instance.getInstanceId();
            for (FieldValue val : fieldValues) {
                long refInstanceId;
                if (!(val instanceof ObjectFieldValue) || this.isSpecialReference(val, instance) || !this.writeConnection(instanceId, refInstanceId = val instanceof HprofFieldObjectValue ? ((HprofFieldObjectValue)val).getInstanceID() : ((HprofInstanceObjectValue)val).getInstanceId())) continue;
                hasValues = true;
            }
            if (this.writeClassConnection(processedClasses, instanceId, instance.getJavaClass())) {
                hasValues = true;
            }
            if (hasValues) continue;
            this.writeLeaf(instanceId, instance.getSize());
        }
    }

    private Field computeReferentField(String className, String fieldName) {
        JavaClass reference = this.heap.getJavaClassByName(className);
        if (reference != null) {
            for (Field f : reference.getFields()) {
                if (!f.getName().equals(fieldName)) continue;
                return f;
            }
        }
        return null;
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192, this.heap.cacheDirectory);
        this.writeBuffer = new LongBuffer(8192, this.heap.cacheDirectory);
        this.leaves = new LongBuffer(8192, this.heap.cacheDirectory);
        this.multipleParents = new LongBuffer(8192, this.heap.cacheDirectory);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private void fillZeroLevel() throws IOException {
        for (HprofGCRoot hprofGCRoot : this.heap.getGCRoots()) {
            long id = hprofGCRoot.getInstanceId();
            LongMap.Entry entry = this.heap.idToOffsetMap.get(id);
            if (entry == null) continue;
            this.writeLong(entry.getOffset());
        }
    }

    private boolean hasMoreLevels() {
        return this.writeBuffer.hasData();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() throws IOException {
        LongBuffer b = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = b;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private boolean writeClassConnection(Set processedClasses, long instanceId, JavaClass jcls) throws IOException {
        if (!processedClasses.contains(jcls)) {
            long jclsId = jcls.getJavaClassId();
            processedClasses.add(jcls);
            if (this.writeConnection(instanceId, jclsId, true)) {
                return true;
            }
        }
        return false;
    }

    private boolean writeConnection(long instanceId, long refInstanceId) throws IOException {
        return this.writeConnection(instanceId, refInstanceId, false);
    }

    private boolean writeConnection(long instanceId, long refInstanceId, boolean addRefInstanceId) throws IOException {
        if (refInstanceId != 0L) {
            LongMap.Entry entry = this.heap.idToOffsetMap.get(refInstanceId);
            if (entry != null && entry.getNearestGCRootPointer() == 0L && this.heap.gcRoots.getGCRoots(refInstanceId) == null) {
                this.writeLong(entry.getOffset());
                if (addRefInstanceId && !this.checkReferences(refInstanceId, instanceId)) {
                    entry.addReference(instanceId);
                }
                entry.setNearestGCRootPointer(instanceId);
                if (!entry.hasOnlyOneReference()) {
                    this.multipleParents.writeLong(refInstanceId);
                }
                return true;
            }
            return !addRefInstanceId && entry != null;
        }
        return false;
    }

    private boolean checkReferences(long refInstanceId, long instanceId) {
        Instance instance = this.heap.getInstanceByID(instanceId);
        for (FieldValue field : instance.getFieldValues()) {
            HprofInstanceObjectValue objectValue;
            if (!(field instanceof HprofInstanceObjectValue) || (objectValue = (HprofInstanceObjectValue)field).getInstanceId() != refInstanceId) continue;
            return true;
        }
        return false;
    }

    private void writeLong(long instanceOffset) throws IOException {
        this.writeBuffer.writeLong(instanceOffset);
    }

    private void writeLeaf(long instanceId, long size) throws IOException {
        LongMap.Entry gcRootPointerEntry;
        long gcRootPointer;
        LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceId);
        entry.setTreeObj();
        entry.setRetainedSize(size);
        if (entry.hasOnlyOneReference() && (gcRootPointer = entry.getNearestGCRootPointer()) != 0L && (gcRootPointerEntry = this.heap.idToOffsetMap.get(gcRootPointer)).getRetainedSize() == 0L) {
            gcRootPointerEntry.setRetainedSize(-1L);
            this.leaves.writeLong(gcRootPointer);
        }
    }

    LongBuffer getLeaves() {
        this.computeGCRoots();
        return this.leaves;
    }

    LongBuffer getMultipleParents() {
        this.computeGCRoots();
        return this.multipleParents;
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeBoolean(this.gcRootsComputed);
        if (this.gcRootsComputed) {
            this.leaves.writeToStream(out);
            this.multipleParents.writeToStream(out);
        }
    }

    NearestGCRoot(HprofHeap h, DataInputStream dis) throws IOException {
        this(h);
        this.gcRootsComputed = dis.readBoolean();
        if (this.gcRootsComputed) {
            this.leaves = new LongBuffer(dis, this.heap.cacheDirectory);
            this.multipleParents = new LongBuffer(dis, this.heap.cacheDirectory);
        }
    }
}

