/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.SplashScreen;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.FreeColSeed;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColRules;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.logging.DefaultHandler;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.OSUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.Controller;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class FreeCol {
    private static final Logger logger;
    private static final String FREECOL_VERSION = "0.13.0";
    private static final String FREECOL_PROTOCOL_VERSION = "0.1.6";
    private static final String[] DIFFICULTIES;
    public static final String FREECOL_SAVE_EXTENSION = "fsg";
    public static final String FREECOL_MAP_EXTENSION = "fsm";
    private static final String JAVA_VERSION;
    private static final long MEMORY_MAX;
    private static final long MEGA = 1000000L;
    public static final String CLIENT_THREAD = "FreeColClient:";
    public static final String SERVER_THREAD = "FreeColServer:";
    public static final String METASERVER_THREAD = "FreeColMetaServer:";
    private static String freeColRevision;
    private static Locale locale;
    private static final NationOptions.Advantages ADVANTAGES_DEFAULT;
    private static final String DIFFICULTY_DEFAULT = "model.difficulty.medium";
    private static final int EUROPEANS_DEFAULT = 4;
    private static final int EUROPEANS_MIN = 1;
    public static final float GUI_SCALE_DEFAULT = 1.0f;
    private static final int GUI_SCALE_MIN_PCT = 100;
    private static final int GUI_SCALE_MAX_PCT = 200;
    public static final float GUI_SCALE_MIN = 1.0f;
    public static final float GUI_SCALE_MAX = 2.0f;
    private static final int GUI_SCALE_STEP_PCT = 25;
    public static final float GUI_SCALE_STEP = 0.25f;
    private static final Level LOGLEVEL_DEFAULT;
    private static final String JAVA_VERSION_MIN = "11";
    private static final long MEMORY_MIN = 512000000L;
    private static final String META_SERVER_ADDRESS = "meta.freecol.org";
    private static final int META_SERVER_PORT = 3540;
    private static final int PORT_DEFAULT = 3541;
    private static final String SPLASH_DEFAULT = "splash.jpg";
    private static final String TC_DEFAULT = "default";
    private static final String RULES_DEFAULT = "freecol";
    public static final long TIMEOUT_DEFAULT = 60L;
    public static final long TIMEOUT_MIN = 10L;
    public static final long TIMEOUT_MAX = 3600000L;
    private static final Dimension WINDOWSIZE_FALLBACK;
    private static boolean checkIntegrity;
    private static boolean consoleLogging;
    private static boolean debugStart;
    private static boolean fastStart;
    private static boolean headless;
    private static boolean introVideo;
    private static boolean javaCheck;
    private static boolean memoryCheck;
    private static boolean publicServer;
    private static boolean sound;
    private static boolean standAloneServer;
    private static NationOptions.Advantages advantages;
    private static String difficulty;
    private static int europeanCount;
    private static String fontName;
    private static final List<LogLevel> logLevels;
    private static String metaServerAddress;
    private static int metaServerPort;
    private static String name;
    private static InetAddress serverAddress;
    private static int serverPort;
    private static String serverName;
    private static InputStream splashStream;
    private static String tc;
    private static String rules;
    private static long timeout;
    private static Dimension windowSize;
    private static Map<String, String> specialOptions;
    private static String argDir;
    private static String argFile;
    private static String[][] optionsTable;

    private FreeCol() {
    }

    public static void main(String[] args) {
        String cLang;
        StringTemplate key;
        String dataDirectoryArg;
        String err;
        JarURLConnection juc;
        freeColRevision = FREECOL_VERSION;
        try {
            juc = FreeCol.getJarURLConnection(FreeCol.class);
        }
        catch (ClassCastException cce) {
            juc = null;
            System.err.println("Unable to cast class properly: " + cce.getMessage());
        }
        catch (IOException ioe) {
            juc = null;
            System.err.println("Unable to open class jar: " + ioe.getMessage());
        }
        if (juc != null) {
            try {
                String revision = FreeCol.readVersion(juc);
                if (revision != null) {
                    freeColRevision = freeColRevision + " (Revision: " + revision + ")";
                }
            }
            catch (Exception e2) {
                System.err.println("Unable to load Manifest: " + e2.getMessage());
            }
            try {
                splashStream = FreeCol.getDefaultSplashStream(juc);
            }
            catch (Exception e3) {
                System.err.println("Unable to open default splash: " + e3.getMessage());
            }
        }
        if ((err = FreeColDirectories.setDataDirectory(dataDirectoryArg = FreeCol.findArg("--freecol-data", args))) != null) {
            FreeCol.fatal(err);
        }
        String localeArg = FreeCol.findArg("--default-locale", args);
        FreeCol.setLocale(localeArg);
        Messages.loadMessageBundle(FreeCol.getLocale());
        FreeCol.handleArgs(args);
        if (javaCheck && JAVA_VERSION_MIN.compareTo(JAVA_VERSION) > 0) {
            FreeCol.fatal(((StringTemplate)StringTemplate.template("main.javaVersion").addName("%version%", JAVA_VERSION)).addName("%minVersion%", JAVA_VERSION_MIN));
        }
        if (memoryCheck && MEMORY_MAX < 512000000L) {
            FreeCol.fatal(((StringTemplate)StringTemplate.template("main.memory").addAmount("%memory%", MEMORY_MAX)).addAmount("%minMemory%", 512L));
        }
        if ((key = FreeColDirectories.setUserDirectories()) != null) {
            FreeCol.fatal(key);
        }
        Logger baseLogger = Logger.getLogger("");
        for (Handler handler : baseLogger.getHandlers()) {
            baseLogger.removeHandler(handler);
        }
        try {
            Writer writer = FreeColDirectories.getLogWriter();
            baseLogger.addHandler(new DefaultHandler(consoleLogging, writer));
            for (LogLevel ll : logLevels) {
                ll.buildLogger();
            }
        }
        catch (FreeColException e4) {
            System.err.println("Logging initialization failure: " + e4);
        }
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> baseLogger.log(Level.WARNING, "Uncaught exception from thread: " + thread, e));
        try {
            specialOptions = ClientOptions.getSpecialOptions();
        }
        catch (FreeColException fce) {
            specialOptions = new HashMap<String, String>();
            logger.log(Level.WARNING, "Special options unavailable", fce);
        }
        if (localeArg == null && (cLang = specialOptions.get("model.option.languageOption")) != null && !"automatic".equalsIgnoreCase(cLang) && FreeCol.setLocale(cLang)) {
            Locale loc = FreeCol.getLocale();
            Messages.loadMessageBundle(loc);
            logger.info("Loaded messages for " + loc);
        }
        FreeColRules.loadRules();
        FreeColModFile.loadMods();
        Messages.loadModMessageBundle(FreeCol.getLocale());
        headless |= Utils.isHeadless();
        FreeCol.processSpecialOptions();
        logger.info(FreeCol.getConfiguration().toString());
        if (standAloneServer) {
            FreeCol.startServer();
        } else {
            if (headless && (!FreeColDebugger.isInDebugMode() || FreeColDebugger.getDebugRunTurns() <= 0)) {
                FreeCol.fatal(logger, Messages.message("client.headlessDebug"));
            }
            FreeCol.startClient();
        }
    }

    private static void processSpecialOptions() {
        LogBuilder lb = new LogBuilder(64);
        String pmoffscreen = "sun.java2d.pmoffscreen";
        String pmoValue = System.getProperty("sun.java2d.pmoffscreen");
        if (pmoValue == null) {
            String usePixmaps = specialOptions.get("model.option.usePixmaps");
            if (usePixmaps != null) {
                System.setProperty("sun.java2d.pmoffscreen", usePixmaps);
                lb.add("sun.java2d.pmoffscreen", " using client option: ", usePixmaps);
            } else {
                lb.add("sun.java2d.pmoffscreen", " unset/ignored: ");
            }
        } else {
            lb.add("sun.java2d.pmoffscreen", " overrides client option: ", pmoValue);
        }
        String openGL = "sun.java2d.opengl";
        String openGLValue = System.getProperty("sun.java2d.opengl");
        if (openGLValue == null) {
            String useOpenGL = specialOptions.get("model.option.useOpenGL");
            if (useOpenGL != null) {
                System.setProperty("sun.java2d.opengl", useOpenGL);
                lb.add(", ", "sun.java2d.opengl", " using client option: ", useOpenGL);
            } else {
                lb.add(", ", "sun.java2d.opengl", " unset/ignored");
            }
        } else {
            lb.add(", ", "sun.java2d.opengl", " overrides client option: ", openGLValue);
        }
        if (OSUtils.onUnix()) {
            String xrender = "sun.java2d.xrender";
            String xrValue = System.getProperty("sun.java2d.xrender");
            if (xrValue == null) {
                String useXR = specialOptions.get("model.option.useXRender");
                if (useXR != null) {
                    System.setProperty("sun.java2d.xrender", useXR);
                    lb.add(", ", "sun.java2d.xrender", " using client option: ", useXR);
                } else {
                    lb.add(", ", "sun.java2d.xrender", " unset/ignored");
                }
            } else {
                lb.add(", ", "sun.java2d.xrender", " overrides client option: ", xrValue);
            }
        }
        lb.log(logger, Level.INFO);
    }

    private static JarURLConnection getJarURLConnection(Class c) throws IOException {
        String resourceName = "/" + c.getName().replace('.', '/') + ".class";
        URL url = c.getResource(resourceName);
        return (JarURLConnection)url.openConnection();
    }

    private static String readVersion(JarURLConnection juc) throws IOException {
        Manifest mf = juc.getManifest();
        return mf == null ? null : mf.getMainAttributes().getValue("Package-Version");
    }

    private static InputStream getDefaultSplashStream(JarURLConnection juc) throws IOException {
        JarFile jf = juc.getJarFile();
        ZipEntry ze = jf.getEntry(SPLASH_DEFAULT);
        return jf.getInputStream(ze);
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Deliberate")
    public static void quit(int status) {
        System.exit(status);
    }

    public static void fatal(Logger logger, String err) {
        if (logger != null) {
            logger.log(Level.SEVERE, err);
        }
        FreeCol.fatal(err);
    }

    private static void fatal(StringTemplate template) {
        FreeCol.fatal(Messages.message(template));
    }

    private static void fatal(String err) {
        if (err == null || err.isEmpty()) {
            err = "Bogus null fatal error message";
            Thread.dumpStack();
        }
        System.err.println(err);
        FreeCol.quit(1);
    }

    private static void gripe(StringTemplate template) {
        System.err.println(Messages.message(template));
    }

    private static void gripe(String key) {
        System.err.println(Messages.message(key));
    }

    public static void trace(Logger logger, String warn) {
        FreeColDebugger.trace(logger, warn);
    }

    private static String findArg(String option, String[] args) {
        for (int i = args.length - 2; i >= 0; --i) {
            if (!option.equals(args[i])) continue;
            return args[i + 1];
        }
        return null;
    }

    private static void handleArgs(String[] args) {
        Options options = new Options();
        for (String[] o : optionsTable) {
            String arg = o[3];
            Option op = new Option(o[0], o[1], arg != null, o[2].startsWith("cli.") ? Messages.message(o[2]) : o[2]);
            if (arg != null) {
                boolean optional = false;
                if (arg.startsWith("!")) {
                    optional = true;
                    arg = arg.substring(1, arg.length());
                }
                if (arg.startsWith(argDir) || arg.startsWith(argFile)) {
                    op.setType(File.class);
                }
                if (arg.startsWith("cli.")) {
                    arg = Messages.message(arg);
                }
                op.setArgName(arg);
                op.setOptionalArg(optional);
            }
            options.addOption(op);
        }
        DefaultParser parser = new DefaultParser();
        boolean usageError = false;
        try {
            String arg;
            String errMsg;
            boolean seeded;
            int e;
            String difficulty;
            String fileName;
            String arg2;
            NationOptions.Advantages a;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help") || line.hasOption("usage")) {
                FreeCol.printUsage(options, 0);
            }
            if (line.hasOption("advantages") && (a = FreeCol.selectAdvantages(arg2 = line.getOptionValue("advantages"))) == null) {
                FreeCol.fatal(((StringTemplate)StringTemplate.template("cli.error.advantages").addName("%advantages%", FreeCol.getValidAdvantages())).addName("%arg%", arg2));
            }
            if (line.hasOption("check-savegame")) {
                arg2 = line.getOptionValue("check-savegame");
                if (!FreeColDirectories.setSavegameFile(arg2)) {
                    FreeCol.fatal(StringTemplate.template("cli.err.save").addName("%string%", arg2));
                }
                checkIntegrity = true;
                standAloneServer = true;
            }
            if (line.hasOption("clientOptions") && !FreeColDirectories.setClientOptionsFile(fileName = line.getOptionValue("clientOptions"))) {
                FreeCol.gripe(StringTemplate.template("cli.error.clientOptions").addName("%string%", fileName));
            }
            if (line.hasOption("debug")) {
                arg2 = line.getOptionValue("debug");
                if (arg2 == null || arg2.isEmpty()) {
                    arg2 = FreeColDebugger.DebugMode.MENUS.toString();
                }
                if (!FreeColDebugger.setDebugModes(arg2)) {
                    FreeCol.gripe(StringTemplate.template("cli.error.debug").addName("%modes%", FreeColDebugger.getDebugModes()));
                }
                logLevels.add(new LogLevel("", Level.FINEST));
            }
            if (line.hasOption("debug-run")) {
                FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
                FreeColDebugger.configureDebugRun(line.getOptionValue("debug-run"));
            }
            if (line.hasOption("debug-start")) {
                debugStart = true;
                FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
            }
            if (line.hasOption("difficulty") && (difficulty = FreeCol.selectDifficulty(arg2 = line.getOptionValue("difficulty"))) == null) {
                FreeCol.fatal(((StringTemplate)StringTemplate.template("cli.error.difficulties").addName("%difficulties%", FreeCol.getValidDifficulties())).addName("%arg%", arg2));
            }
            if (line.hasOption("europeans") && (e = FreeCol.selectEuropeanCount(line.getOptionValue("europeans"))) < 0) {
                FreeCol.gripe(StringTemplate.template("cli.error.europeans").addAmount("%min%", 1));
            }
            if (line.hasOption("fast")) {
                fastStart = true;
                introVideo = false;
            }
            if (line.hasOption("font")) {
                fontName = line.getOptionValue("font");
            }
            if (line.hasOption("full-screen")) {
                windowSize = null;
            }
            if (line.hasOption("headless")) {
                headless = true;
            }
            if (line.hasOption("load-savegame") && !FreeColDirectories.setSavegameFile(arg = line.getOptionValue("load-savegame"))) {
                FreeCol.fatal(StringTemplate.template("cli.error.save").addName("%string%", arg));
            }
            if (line.hasOption("log-console")) {
                consoleLogging = true;
            }
            if (line.hasOption("log-file")) {
                FreeColDirectories.setLogFilePath(line.getOptionValue("log-file"));
            }
            if (line.hasOption("log-level")) {
                for (String value : line.getOptionValues("log-level")) {
                    String[] s = value.split(":");
                    logLevels.add(s.length == 1 ? new LogLevel("", Level.parse(StringUtils.upCase(s[0]))) : new LogLevel(s[0], Level.parse(StringUtils.upCase(s[1]))));
                }
            }
            if (line.hasOption("meta-server") && !FreeCol.setMetaServer(arg = line.getOptionValue("meta-server"))) {
                FreeCol.gripe(StringTemplate.template("cli.error.meta-server").addName("%arg%", arg));
            }
            if (line.hasOption("name")) {
                FreeCol.setName(line.getOptionValue("name"));
            }
            if (line.hasOption("no-intro")) {
                introVideo = false;
            }
            if (line.hasOption("no-java-check")) {
                javaCheck = false;
            }
            if (line.hasOption("no-memory-check")) {
                memoryCheck = false;
            }
            if (line.hasOption("no-sound")) {
                sound = false;
            }
            if (line.hasOption("no-splash")) {
                splashStream = null;
            }
            if (line.hasOption("private")) {
                publicServer = false;
            }
            if (line.hasOption("server")) {
                standAloneServer = true;
            }
            if (line.hasOption("server-name")) {
                serverName = line.getOptionValue("server-name");
            }
            if (line.hasOption("server-port") && !FreeCol.setServerPort(arg = line.getOptionValue("server-port"))) {
                FreeCol.fatal(StringTemplate.template("cli.error.serverPort").addName("%string%", arg));
            }
            if (line.hasOption("server-ip") && !FreeCol.setServerAddress(arg = line.getOptionValue("server-ip"))) {
                FreeCol.fatal(StringTemplate.template("cli.error.serverIp").addName("%string%", arg));
            }
            boolean bl = seeded = line.hasOption("seed") && FreeColSeed.setFreeColSeed(line.getOptionValue("seed"));
            if (!seeded) {
                FreeColSeed.generateFreeColSeed();
            }
            if (line.hasOption("splash")) {
                String splash = line.getOptionValue("splash");
                try {
                    InputStream fis;
                    splashStream = fis = Files.newInputStream(Paths.get(splash, new String[0]), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    FreeCol.gripe(StringTemplate.template("cli.error.splash").addName("%name%", splash));
                }
            }
            if (line.hasOption("tc")) {
                FreeCol.setTc(line.getOptionValue("tc"));
            }
            if (line.hasOption("rules")) {
                FreeCol.setRules(line.getOptionValue("rules"));
            }
            if (line.hasOption("timeout")) {
                String arg3 = line.getOptionValue("timeout");
                try {
                    FreeCol.setTimeout(arg3);
                }
                catch (NumberFormatException nfe) {
                    FreeCol.gripe(((StringTemplate)StringTemplate.template("cli.error.timeout").addName("%string%", arg3)).addName("%minimum%", Long.toString(10L)));
                }
            }
            if (line.hasOption("user-cache-directory") && (errMsg = FreeColDirectories.setUserCacheDirectory(arg = line.getOptionValue("user-cache-directory"))) != null) {
                FreeCol.gripe(StringTemplate.template(errMsg).addName("%string%", arg));
            }
            if (line.hasOption("user-config-directory") && (errMsg = FreeColDirectories.setUserConfigDirectory(arg = line.getOptionValue("user-config-directory"))) != null) {
                FreeCol.gripe(StringTemplate.template(errMsg).addName("%string%", arg));
            }
            if (line.hasOption("user-data-directory") && (errMsg = FreeColDirectories.setUserDataDirectory(arg = line.getOptionValue("user-data-directory"))) != null) {
                FreeCol.fatal(StringTemplate.template(errMsg).addName("%string%", arg));
            }
            if (line.hasOption("version")) {
                System.out.println("FreeCol " + FreeCol.getVersion());
                FreeCol.quit(0);
            }
            if (line.hasOption("windowed")) {
                arg = line.getOptionValue("windowed");
                FreeCol.setWindowSize(arg);
            }
        }
        catch (ParseException e) {
            System.err.println("\n" + e.getMessage() + "\n");
            usageError = true;
        }
        if (usageError) {
            FreeCol.printUsage(options, 1);
        }
    }

    private static void printUsage(Options options, int status) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -Xmx1G -jar freecol.jar [OPTIONS]", options);
        FreeCol.quit(status);
    }

    public static Specification loadSpecification(FreeColModFile rulesFile, NationOptions.Advantages advantages, String difficulty) {
        Specification spec = null;
        try {
            if (rulesFile != null) {
                spec = rulesFile.getSpecification();
            }
        }
        catch (IOException | XMLStreamException ex) {
            System.err.println("Spec read failed in " + rulesFile.getId() + ": " + ex.getMessage() + "\n");
        }
        if (spec != null) {
            spec.prepare(advantages, difficulty);
        }
        return spec;
    }

    private static Specification getRulesSpecification() {
        Specification spec = FreeCol.loadSpecification(FreeCol.getRulesFile(), FreeCol.getAdvantages(), FreeCol.getDifficulty());
        if (spec == null) {
            FreeCol.fatal(StringTemplate.template("cli.error.badTC").addName("%tc%", FreeCol.getRules()));
        }
        return spec;
    }

    public static boolean getHeadless() {
        return headless;
    }

    public static void setHeadless(boolean newHeadless) {
        headless = newHeadless;
    }

    public static NationOptions.Advantages getAdvantages() {
        return advantages == null ? ADVANTAGES_DEFAULT : advantages;
    }

    private static NationOptions.Advantages selectAdvantages(String as) {
        NationOptions.Advantages a = (NationOptions.Advantages)CollectionUtils.find(NationOptions.Advantages.values(), Messages.matchesNamed(as));
        if (a != null) {
            FreeCol.setAdvantages(a);
        }
        return a;
    }

    public static void setAdvantages(NationOptions.Advantages advantages) {
        FreeCol.advantages = advantages;
    }

    private static String getValidAdvantages() {
        return CollectionUtils.transform(NationOptions.Advantages.values(), CollectionUtils.alwaysTrue(), a -> Messages.getName(a), Collectors.joining(","));
    }

    private static String getAdvantagesDescription() {
        return Messages.message(StringTemplate.template("cli.advantages").addName("%advantages%", FreeCol.getValidAdvantages()));
    }

    private static String getDebugDescription() {
        return Messages.message(StringTemplate.template("cli.debug").addName("%modes%", FreeColDebugger.getDebugModes()));
    }

    public static String getDifficulty() {
        return difficulty == null ? DIFFICULTY_DEFAULT : difficulty;
    }

    private static String selectDifficulty(String arg) {
        String difficulty = CollectionUtils.find(CollectionUtils.map(DIFFICULTIES, d -> "model.difficulty." + d), Messages.matchesName(arg));
        if (difficulty != null) {
            FreeCol.setDifficulty(difficulty);
        }
        return difficulty;
    }

    public static void setDifficulty(OptionGroup difficulty) {
        FreeCol.setDifficulty(difficulty.getId());
    }

    public static void setDifficulty(String difficulty) {
        FreeCol.difficulty = difficulty;
    }

    public static String getValidDifficulties() {
        return CollectionUtils.transform(DIFFICULTIES, CollectionUtils.alwaysTrue(), d -> Messages.getName("model.difficulty." + d), Collectors.joining(","));
    }

    public static int getEuropeanCount() {
        return europeanCount;
    }

    public static void setEuropeanCount(int n) {
        europeanCount = n;
    }

    public static String getValidGUIScales() {
        StringBuilder sb = new StringBuilder(64);
        for (int i = 100; i <= 200; i += 25) {
            sb.append(i).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static int selectEuropeanCount(String arg) {
        try {
            int n = Integer.parseInt(arg);
            if (n >= 1) {
                FreeCol.setEuropeanCount(n);
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static String getMetaServerAddress() {
        return metaServerAddress;
    }

    public static int getMetaServerPort() {
        return metaServerPort;
    }

    private static boolean setMetaServer(String arg) {
        String[] s = arg.split(":");
        int port = -1;
        try {
            port = s.length == 2 ? Integer.parseInt(s[1]) : -1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (s.length != 2 || s[0] == null || "".equals(s[0])) {
            return false;
        }
        metaServerAddress = s[0];
        metaServerPort = port;
        return true;
    }

    public static String getName() {
        return name != null ? name : System.getProperty("user.name", Messages.message("main.defaultPlayerName"));
    }

    public static void setName(String name) {
        FreeCol.name = name;
        logger.info("Set FreeCol.name = " + name);
    }

    public static Locale getLocale() {
        return locale == null ? Locale.getDefault() : locale;
    }

    @SuppressFBWarnings(value={"MDM_SETDEFAULTLOCALE"}, justification="Locale can be reset by user")
    public static boolean setLocale(String localeArg) {
        Locale newLocale = null;
        if (localeArg == null) {
            newLocale = Locale.getDefault();
        } else {
            int index = localeArg.indexOf(46);
            if (index > 0) {
                localeArg = localeArg.substring(0, index);
            }
            newLocale = Messages.getLocale(localeArg);
        }
        if (newLocale != locale) {
            locale = newLocale;
            Locale.setDefault(newLocale);
            return true;
        }
        return false;
    }

    public static String getRevision() {
        return freeColRevision;
    }

    public static String getServerHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            return InetAddress.getLoopbackAddress().getHostAddress();
        }
    }

    public static int getServerPort() {
        return serverPort < 0 ? 3541 : serverPort;
    }

    public static InetAddress getServerName() {
        try {
            return serverAddress == null ? InetAddress.getByName("0.0.0.0") : serverAddress;
        }
        catch (UnknownHostException e) {
            return Inet4Address.getLoopbackAddress();
        }
    }

    private static boolean setServerPort(String arg) {
        if (arg == null) {
            return false;
        }
        try {
            serverPort = Integer.parseInt(arg);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static boolean setServerAddress(String arg) {
        if (arg == null) {
            return false;
        }
        try {
            serverAddress = InetAddress.getByName(arg);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return true;
    }

    public static String getTc() {
        return tc == null ? TC_DEFAULT : tc;
    }

    public static void setTc(String tc) {
        FreeCol.tc = tc;
    }

    public static String getRules() {
        return rules == null ? RULES_DEFAULT : rules;
    }

    public static void setRules(String tc) {
        rules = tc;
    }

    public static FreeColModFile getRulesFile() {
        return FreeColRules.getFreeColRulesFile(FreeCol.getRules());
    }

    public static long getTimeout(boolean singlePlayer) {
        if (timeout < 0L) {
            timeout = singlePlayer ? 3600000L : 60L;
        }
        return timeout;
    }

    public static void setTimeout(String timeout) {
        long result = Long.parseLong(timeout);
        if (10L <= result && result <= 3600000L) {
            FreeCol.timeout = result;
        }
    }

    public static String getVersion() {
        return FREECOL_VERSION;
    }

    public static String getFreeColProtocolVersion() {
        return FREECOL_PROTOCOL_VERSION;
    }

    private static void setWindowSize(String arg) {
        String[] xy;
        windowSize = WINDOWSIZE_FALLBACK;
        if (arg != null && (xy = arg.split("[^0-9]")).length == 2) {
            try {
                windowSize = new Dimension(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static StringTemplate badFile(String messageId, File file) {
        return StringTemplate.template(messageId).addName("%name%", file == null ? "-" : file.getPath());
    }

    public static StringTemplate errorFromException(Exception ex, String fallbackKey) {
        return FreeCol.errorFromException(ex, StringTemplate.template(fallbackKey));
    }

    public static StringTemplate errorFromException(Exception ex, StringTemplate fallback) {
        String msg;
        return ex == null || (msg = ex.getMessage()) == null ? fallback : (Messages.containsKey(msg) ? StringTemplate.template(msg) : (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? StringTemplate.name(msg) : fallback));
    }

    public static StringBuilder getConfiguration() {
        File autosave = FreeColDirectories.getAutosaveDirectory();
        File clientOptionsFile = FreeColDirectories.getClientOptionsFile();
        File save = FreeColDirectories.getSaveDirectory();
        File userConfig = FreeColDirectories.getUserConfigDirectory();
        File userData = FreeColDirectories.getUserDataDirectory();
        File userMods = FreeColDirectories.getUserModsDirectory();
        StringBuilder sb = new StringBuilder(256);
        sb.append("Configuration:").append("\n  version     ").append(FreeCol.getRevision()).append("\n  java:       ").append(JAVA_VERSION).append("\n  memory:     ").append(MEMORY_MAX).append("\n  locale:     ").append(FreeCol.getLocale()).append("\n  data:       ").append(FreeColDirectories.getDataDirectory().getPath()).append("\n  userConfig: ").append(userConfig == null ? "NONE" : userConfig.getPath()).append("\n  userData:   ").append(userData == null ? "NONE" : userData.getPath()).append("\n  autosave:   ").append(autosave == null ? "NONE" : autosave.getPath()).append("\n  logFile:    ").append(FreeColDirectories.getLogFilePath()).append("\n  options:    ").append(clientOptionsFile == null ? "NONE" : clientOptionsFile.getPath()).append("\n  save:       ").append(save == null ? "NONE" : save.getPath()).append("\n  userMods:   ").append(userMods == null ? "NONE" : userMods.getPath()).append("\n  seed:       ").append(FreeColSeed.getFreeColSeed()).append("\n  debug:      ").append(FreeColDebugger.getDebugModes());
        return sb;
    }

    private static void startClient() {
        SwingUtilities.invokeLater(() -> {
            SplashScreen splashScreen = FreeCol.createSplashScreen();
            SwingUtilities.invokeLater(() -> {
                Specification spec = null;
                File savegame = FreeColDirectories.getSavegameFile();
                if (debugStart) {
                    spec = FreeCol.getRulesSpecification();
                } else if (fastStart && savegame == null && (savegame = FreeColDirectories.getLastSaveGameFile()) == null) {
                    spec = FreeCol.getRulesSpecification();
                }
                new FreeColClient(splashScreen, fontName, windowSize, null, sound, introVideo, savegame, spec);
            });
        });
    }

    private static SplashScreen createSplashScreen() {
        SplashScreen splashScreen = null;
        if (splashStream != null) {
            try {
                GraphicsDevice defaultScreenDevice = Utils.getGoodGraphicsDevice();
                splashScreen = new SplashScreen(defaultScreenDevice, splashStream);
                splashScreen.setVisible(true);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Splash screen failure", e);
            }
        }
        return splashScreen;
    }

    public static FreeColClient startTestClient(Specification spec) {
        FreeCol.setHeadless(true);
        return new FreeColClient(null, null, null, null, false, false, null, spec);
    }

    private static void checkServerIntegrity(FreeColServer freeColServer) {
        int ret;
        String key;
        Constants.IntegrityType integ = Constants.IntegrityType.INTEGRITY_GOOD;
        if (freeColServer == null) {
            logger.warning("Integrity test blocked");
            integ = integ.fail();
        } else {
            integ = freeColServer.getIntegrity();
        }
        switch (integ) {
            case INTEGRITY_GOOD: {
                key = "cli.check-savegame.success";
                ret = 0;
                break;
            }
            case INTEGRITY_FIXED: {
                key = "cli.check-savegame.fixed";
                ret = 2;
                break;
            }
            default: {
                key = "cli.check-savegame.failed";
                ret = 3;
            }
        }
        FreeCol.gripe(StringTemplate.template(key).add("%log%", FreeColDirectories.getLogFilePath()));
        FreeCol.quit(ret);
    }

    private static void startServer() {
        FreeColServer freeColServer;
        logger.info("Starting stand-alone server.");
        File saveGame = FreeColDirectories.getSavegameFile();
        if (saveGame != null) {
            try {
                FreeColSavegameFile fis = new FreeColSavegameFile(saveGame);
                freeColServer = new FreeColServer(fis, null, serverAddress, serverPort, serverName);
                freeColServer.setPublicServer(publicServer);
                if (!freeColServer.registerWithMetaServer()) {
                    FreeCol.fatal(Messages.message("server.noRouteToServer"));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Load fail", e);
                FreeCol.fatal(Messages.message(FreeCol.badFile("error.couldNotLoad", saveGame)) + ": " + e);
                freeColServer = null;
            }
            if (checkIntegrity) {
                FreeCol.checkServerIntegrity(freeColServer);
            }
            if (freeColServer == null) {
                return;
            }
        } else {
            Specification spec = FreeCol.getRulesSpecification();
            try {
                freeColServer = new FreeColServer(publicServer, false, spec, serverAddress, serverPort, serverName);
                if (!freeColServer.registerWithMetaServer()) {
                    FreeCol.fatal(Messages.message("server.noRouteToServer"));
                }
            }
            catch (Exception e) {
                FreeCol.fatal(Messages.message("server.initialize") + ": " + e.getMessage());
                return;
            }
            if (publicServer && !freeColServer.getPublicServer()) {
                FreeCol.gripe(Messages.message("server.noRouteToServer"));
            }
        }
        String quit = "FreeColServer:Quit Game";
        final Controller controller = freeColServer.getController();
        Runtime.getRuntime().addShutdownHook(new Thread(quit){

            @Override
            public void run() {
                controller.shutdown();
            }
        });
    }

    static {
        System.setProperty("sun.java2d.uiScale", "1.0");
        System.setProperty("sun.java2d.uiScale.enabled", "false");
        logger = Logger.getLogger(FreeCol.class.getName());
        DIFFICULTIES = new String[]{"veryEasy", "easy", "medium", "hard", "veryHard"};
        JAVA_VERSION = System.getProperty("java.version");
        MEMORY_MAX = Runtime.getRuntime().maxMemory();
        freeColRevision = null;
        locale = null;
        ADVANTAGES_DEFAULT = NationOptions.Advantages.SELECTABLE;
        LOGLEVEL_DEFAULT = Level.INFO;
        WINDOWSIZE_FALLBACK = new Dimension(-1, -1);
        checkIntegrity = false;
        consoleLogging = false;
        debugStart = false;
        fastStart = false;
        headless = false;
        introVideo = true;
        javaCheck = true;
        memoryCheck = true;
        publicServer = true;
        sound = true;
        standAloneServer = false;
        advantages = null;
        difficulty = null;
        europeanCount = 4;
        fontName = null;
        logLevels = new ArrayList<LogLevel>();
        logLevels.add(new LogLevel("", LOGLEVEL_DEFAULT));
        metaServerAddress = META_SERVER_ADDRESS;
        metaServerPort = 3540;
        name = null;
        serverAddress = null;
        serverPort = -1;
        serverName = null;
        tc = null;
        rules = null;
        timeout = -1L;
        windowSize = WINDOWSIZE_FALLBACK;
        specialOptions = null;
        argDir = "cli.arg.directory";
        argFile = "cli.arg.file";
        optionsTable = new String[][]{{"?", "usage", "cli.help", null}, {"@", "help", "cli.help", null}, {"d", "freecol-data", "cli.freecol-data", argDir}, {"L", "default-locale", "cli.default-locale", "cli.arg.locale"}, {"a", "advantages", FreeCol.getAdvantagesDescription(), "cli.arg.advantages"}, {null, "check-savegame", "cli.check-savegame", argFile}, {"O", "clientOptions", "cli.clientOptions", "cli.arg.clientOptions"}, {null, "debug", FreeCol.getDebugDescription(), "cli.arg.debug"}, {"R", "debug-run", "cli.debug-run", "cli.arg.debugRun"}, {"S", "debug-start", "cli.debug-start", null}, {"D", "difficulty", "cli.difficulty", "cli.arg.difficulty"}, {"e", "europeans", "cli.european-count", "cli.arg.europeans"}, {null, "fast", "cli.fast", null}, {"f", "font", "cli.font", "cli.arg.font"}, {"F", "full-screen", "cli.full-screen", null}, {"H", "headless", "cli.headless", null}, {"l", "load-savegame", "cli.load-savegame", argFile}, {null, "log-console", "cli.log-console", null}, {null, "log-file", "cli.log-file", "cli.arg.name"}, {null, "log-level", "cli.log-level", "cli.arg.loglevel"}, {"m", "meta-server", "cli.meta-server", "cli.arg.metaServer"}, {"n", "name", "cli.name", "cli.arg.name"}, {null, "no-intro", "cli.no-intro", null}, {null, "no-java-check", "cli.no-java-check", null}, {null, "no-memory-check", "cli.no-memory-check", null}, {null, "no-sound", "cli.no-sound", null}, {null, "no-splash", "cli.no-splash", null}, {"p", "private", "cli.private", null}, {"r", "rules", "cli.rules", "cli.arg.name"}, {"Z", "seed", "cli.seed", "cli.arg.seed"}, {null, "server", "cli.server", null}, {null, "server-name", "cli.server-name", "cli.arg.name"}, {null, "server-ip", "cli.server-ip", "cli.arg.serverIp"}, {null, "server-port", "cli.server-port", "cli.arg.port"}, {"s", "splash", "cli.splash", "!" + argFile}, {"t", "tc", "cli.tc", "cli.arg.name"}, {"T", "timeout", "cli.timeout", "cli.arg.timeout"}, {"C", "user-cache-directory", "cli.user-cache-directory", argDir}, {"c", "user-config-directory", "cli.user-config-directory", argDir}, {"u", "user-data-directory", "cli.user-data-directory", argDir}, {"v", "version", "cli.version", null}, {"w", "windowed", "cli.windowed", "!cli.arg.dimensions"}};
    }

    private static class LogLevel {
        public final String name;
        public final Level level;
        public Logger logger;

        public LogLevel(String name, Level level) {
            this.name = name;
            this.level = level;
            this.logger = null;
        }

        public void buildLogger() {
            this.logger = Logger.getLogger("net.sf.freecol" + (String)(this.name.isEmpty() ? "" : "." + this.name));
            this.logger.setLevel(this.level);
        }
    }
}

