from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Convert import *
from OCC.Core.gp import *
from OCC.Core.TColgp import *
from OCC.Core.TColStd import *
from OCC.Core.Geom import *
from OCC.Core.AppBlend import *
from OCC.Core.GeomAbs import *
from OCC.Core.Approx import *
from OCC.Core.Adaptor3d import *
from OCC.Core.Law import *
from OCC.Core.math import *
from OCC.Core.Geom2d import *
from OCC.Core.TColGeom import *


class GeomFill_Array1OfLocationLaw:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class GeomFill_Array1OfSectionLaw:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class GeomFill_SequenceOfAx2:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Ax2: ...
    def Last(self) -> gp_Ax2: ...
    def Length(self) -> int: ...
    def Append(self, theItem: gp_Ax2) -> gp_Ax2: ...
    def Prepend(self, theItem: gp_Ax2) -> gp_Ax2: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> gp_Ax2: ...
    def SetValue(self, theIndex: int, theValue: gp_Ax2) -> None: ...

class GeomFill_SequenceOfTrsf:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> gp_Trsf: ...
    def Last(self) -> gp_Trsf: ...
    def Length(self) -> int: ...
    def Append(self, theItem: gp_Trsf) -> gp_Trsf: ...
    def Prepend(self, theItem: gp_Trsf) -> gp_Trsf: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> gp_Trsf: ...
    def SetValue(self, theIndex: int, theValue: gp_Trsf) -> None: ...

class GeomFill_ApproxStyle(IntEnum):
    GeomFill_Section: int = ...
    GeomFill_Location: int = ...

GeomFill_Section = GeomFill_ApproxStyle.GeomFill_Section
GeomFill_Location = GeomFill_ApproxStyle.GeomFill_Location

class GeomFill_Trihedron(IntEnum):
    GeomFill_IsCorrectedFrenet: int = ...
    GeomFill_IsFixed: int = ...
    GeomFill_IsFrenet: int = ...
    GeomFill_IsConstantNormal: int = ...
    GeomFill_IsDarboux: int = ...
    GeomFill_IsGuideAC: int = ...
    GeomFill_IsGuidePlan: int = ...
    GeomFill_IsGuideACWithContact: int = ...
    GeomFill_IsGuidePlanWithContact: int = ...
    GeomFill_IsDiscreteTrihedron: int = ...

GeomFill_IsCorrectedFrenet = GeomFill_Trihedron.GeomFill_IsCorrectedFrenet
GeomFill_IsFixed = GeomFill_Trihedron.GeomFill_IsFixed
GeomFill_IsFrenet = GeomFill_Trihedron.GeomFill_IsFrenet
GeomFill_IsConstantNormal = GeomFill_Trihedron.GeomFill_IsConstantNormal
GeomFill_IsDarboux = GeomFill_Trihedron.GeomFill_IsDarboux
GeomFill_IsGuideAC = GeomFill_Trihedron.GeomFill_IsGuideAC
GeomFill_IsGuidePlan = GeomFill_Trihedron.GeomFill_IsGuidePlan
GeomFill_IsGuideACWithContact = GeomFill_Trihedron.GeomFill_IsGuideACWithContact
GeomFill_IsGuidePlanWithContact = GeomFill_Trihedron.GeomFill_IsGuidePlanWithContact
GeomFill_IsDiscreteTrihedron = GeomFill_Trihedron.GeomFill_IsDiscreteTrihedron

class GeomFill_FillingStyle(IntEnum):
    GeomFill_StretchStyle: int = ...
    GeomFill_CoonsStyle: int = ...
    GeomFill_CurvedStyle: int = ...

GeomFill_StretchStyle = GeomFill_FillingStyle.GeomFill_StretchStyle
GeomFill_CoonsStyle = GeomFill_FillingStyle.GeomFill_CoonsStyle
GeomFill_CurvedStyle = GeomFill_FillingStyle.GeomFill_CurvedStyle

class GeomFill_PipeError(IntEnum):
    GeomFill_PipeOk: int = ...
    GeomFill_PipeNotOk: int = ...
    GeomFill_PlaneNotIntersectGuide: int = ...
    GeomFill_ImpossibleContact: int = ...

GeomFill_PipeOk = GeomFill_PipeError.GeomFill_PipeOk
GeomFill_PipeNotOk = GeomFill_PipeError.GeomFill_PipeNotOk
GeomFill_PlaneNotIntersectGuide = GeomFill_PipeError.GeomFill_PlaneNotIntersectGuide
GeomFill_ImpossibleContact = GeomFill_PipeError.GeomFill_ImpossibleContact

class geomfill:
    @overload
    @staticmethod
    def GetCircle(TConv: Convert_ParameterisationType, ns1: gp_Vec, ns2: gp_Vec, nplan: gp_Vec, pt1: gp_Pnt, pt2: gp_Pnt, Rayon: float, Center: gp_Pnt, Poles: TColgp_Array1OfPnt, Weigths: TColStd_Array1OfReal) -> None: ...
    @overload
    @staticmethod
    def GetCircle(TConv: Convert_ParameterisationType, ns1: gp_Vec, ns2: gp_Vec, dn1w: gp_Vec, dn2w: gp_Vec, nplan: gp_Vec, dnplan: gp_Vec, pts1: gp_Pnt, pts2: gp_Pnt, tang1: gp_Vec, tang2: gp_Vec, Rayon: float, DRayon: float, Center: gp_Pnt, DCenter: gp_Vec, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    @overload
    @staticmethod
    def GetCircle(TConv: Convert_ParameterisationType, ns1: gp_Vec, ns2: gp_Vec, dn1w: gp_Vec, dn2w: gp_Vec, d2n1w: gp_Vec, d2n2w: gp_Vec, nplan: gp_Vec, dnplan: gp_Vec, d2nplan: gp_Vec, pts1: gp_Pnt, pts2: gp_Pnt, tang1: gp_Vec, tang2: gp_Vec, Dtang1: gp_Vec, Dtang2: gp_Vec, Rayon: float, DRayon: float, D2Rayon: float, Center: gp_Pnt, DCenter: gp_Vec, D2Center: gp_Vec, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal, D2Weigths: TColStd_Array1OfReal) -> bool: ...
    @staticmethod
    def GetMinimalWeights(TConv: Convert_ParameterisationType, AngleMin: float, AngleMax: float, Weigths: TColStd_Array1OfReal) -> None: ...
    @staticmethod
    def GetShape(MaxAng: float, TypeConv: Convert_ParameterisationType) -> Tuple[int, int, int]: ...
    @staticmethod
    def GetTolerance(TConv: Convert_ParameterisationType, AngleMin: float, Radius: float, AngularTol: float, SpatialTol: float) -> float: ...
    @staticmethod
    def Knots(TypeConv: Convert_ParameterisationType, TKnots: TColStd_Array1OfReal) -> None: ...
    @staticmethod
    def Mults(TypeConv: Convert_ParameterisationType, TMults: TColStd_Array1OfInteger) -> None: ...
    @staticmethod
    def Surface(Curve1: Geom_Curve, Curve2: Geom_Curve) -> Geom_Surface: ...

class GeomFill_AppSurf(AppBlend_Approx):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Degmin: int, Degmax: int, Tol3d: float, Tol2d: float, NbIt: int, KnownParameters: Optional[bool] = False) -> None: ...
    def Continuity(self) -> GeomAbs_Shape: ...
    def CriteriumWeight(self) -> Tuple[float, float, float]: ...
    def Curve2d(self, Index: int, TPoles: TColgp_Array1OfPnt2d, TKnots: TColStd_Array1OfReal, TMults: TColStd_Array1OfInteger) -> None: ...
    def Curve2dPoles(self, Index: int) -> TColgp_Array1OfPnt2d: ...
    def Curves2dDegree(self) -> int: ...
    def Curves2dKnots(self) -> TColStd_Array1OfReal: ...
    def Curves2dMults(self) -> TColStd_Array1OfInteger: ...
    def Curves2dShape(self) -> Tuple[int, int, int]: ...
    def Init(self, Degmin: int, Degmax: int, Tol3d: float, Tol2d: float, NbIt: int, KnownParameters: Optional[bool] = False) -> None: ...
    def IsDone(self) -> bool: ...
    def NbCurves2d(self) -> int: ...
    def ParType(self) -> Approx_ParametrizationType: ...
    @overload
    def Perform(self, Lin: GeomFill_Line, SecGen: GeomFill_SectionGenerator, SpApprox: Optional[bool] = False) -> None: ...
    @overload
    def Perform(self, Lin: GeomFill_Line, SecGen: GeomFill_SectionGenerator, NbMaxP: int) -> None: ...
    def PerformSmoothing(self, Lin: GeomFill_Line, SecGen: GeomFill_SectionGenerator) -> None: ...
    def SetContinuity(self, C: GeomAbs_Shape) -> None: ...
    def SetCriteriumWeight(self, W1: float, W2: float, W3: float) -> None: ...
    def SetParType(self, ParType: Approx_ParametrizationType) -> None: ...
    def SurfPoles(self) -> TColgp_Array2OfPnt: ...
    def SurfShape(self) -> Tuple[int, int, int, int, int, int]: ...
    def SurfUKnots(self) -> TColStd_Array1OfReal: ...
    def SurfUMults(self) -> TColStd_Array1OfInteger: ...
    def SurfVKnots(self) -> TColStd_Array1OfReal: ...
    def SurfVMults(self) -> TColStd_Array1OfInteger: ...
    def SurfWeights(self) -> TColStd_Array2OfReal: ...
    def Surface(self, TPoles: TColgp_Array2OfPnt, TWeights: TColStd_Array2OfReal, TUKnots: TColStd_Array1OfReal, TVKnots: TColStd_Array1OfReal, TUMults: TColStd_Array1OfInteger, TVMults: TColStd_Array1OfInteger) -> None: ...
    def TolCurveOnSurf(self, Index: int) -> float: ...
    def TolReached(self) -> Tuple[float, float]: ...
    def UDegree(self) -> int: ...
    def VDegree(self) -> int: ...

class GeomFill_AppSweep(AppBlend_Approx):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Degmin: int, Degmax: int, Tol3d: float, Tol2d: float, NbIt: int, KnownParameters: Optional[bool] = False) -> None: ...
    def Continuity(self) -> GeomAbs_Shape: ...
    def CriteriumWeight(self) -> Tuple[float, float, float]: ...
    def Curve2d(self, Index: int, TPoles: TColgp_Array1OfPnt2d, TKnots: TColStd_Array1OfReal, TMults: TColStd_Array1OfInteger) -> None: ...
    def Curve2dPoles(self, Index: int) -> TColgp_Array1OfPnt2d: ...
    def Curves2dDegree(self) -> int: ...
    def Curves2dKnots(self) -> TColStd_Array1OfReal: ...
    def Curves2dMults(self) -> TColStd_Array1OfInteger: ...
    def Curves2dShape(self) -> Tuple[int, int, int]: ...
    def Init(self, Degmin: int, Degmax: int, Tol3d: float, Tol2d: float, NbIt: int, KnownParameters: Optional[bool] = False) -> None: ...
    def IsDone(self) -> bool: ...
    def NbCurves2d(self) -> int: ...
    def ParType(self) -> Approx_ParametrizationType: ...
    @overload
    def Perform(self, Lin: GeomFill_Line, SecGen: GeomFill_SweepSectionGenerator, SpApprox: Optional[bool] = False) -> None: ...
    @overload
    def Perform(self, Lin: GeomFill_Line, SecGen: GeomFill_SweepSectionGenerator, NbMaxP: int) -> None: ...
    def PerformSmoothing(self, Lin: GeomFill_Line, SecGen: GeomFill_SweepSectionGenerator) -> None: ...
    def SetContinuity(self, C: GeomAbs_Shape) -> None: ...
    def SetCriteriumWeight(self, W1: float, W2: float, W3: float) -> None: ...
    def SetParType(self, ParType: Approx_ParametrizationType) -> None: ...
    def SurfPoles(self) -> TColgp_Array2OfPnt: ...
    def SurfShape(self) -> Tuple[int, int, int, int, int, int]: ...
    def SurfUKnots(self) -> TColStd_Array1OfReal: ...
    def SurfUMults(self) -> TColStd_Array1OfInteger: ...
    def SurfVKnots(self) -> TColStd_Array1OfReal: ...
    def SurfVMults(self) -> TColStd_Array1OfInteger: ...
    def SurfWeights(self) -> TColStd_Array2OfReal: ...
    def Surface(self, TPoles: TColgp_Array2OfPnt, TWeights: TColStd_Array2OfReal, TUKnots: TColStd_Array1OfReal, TVKnots: TColStd_Array1OfReal, TUMults: TColStd_Array1OfInteger, TVMults: TColStd_Array1OfInteger) -> None: ...
    def TolCurveOnSurf(self, Index: int) -> float: ...
    def TolReached(self) -> Tuple[float, float]: ...
    def UDegree(self) -> int: ...
    def VDegree(self) -> int: ...

class GeomFill_BSplineCurves:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C1: Geom_BSplineCurve, C2: Geom_BSplineCurve, C3: Geom_BSplineCurve, C4: Geom_BSplineCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def __init__(self, C1: Geom_BSplineCurve, C2: Geom_BSplineCurve, C3: Geom_BSplineCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def __init__(self, C1: Geom_BSplineCurve, C2: Geom_BSplineCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def Init(self, C1: Geom_BSplineCurve, C2: Geom_BSplineCurve, C3: Geom_BSplineCurve, C4: Geom_BSplineCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def Init(self, C1: Geom_BSplineCurve, C2: Geom_BSplineCurve, C3: Geom_BSplineCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def Init(self, C1: Geom_BSplineCurve, C2: Geom_BSplineCurve, Type: GeomFill_FillingStyle) -> None: ...
    def Surface(self) -> Geom_BSplineSurface: ...

class GeomFill_BezierCurves:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C1: Geom_BezierCurve, C2: Geom_BezierCurve, C3: Geom_BezierCurve, C4: Geom_BezierCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def __init__(self, C1: Geom_BezierCurve, C2: Geom_BezierCurve, C3: Geom_BezierCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def __init__(self, C1: Geom_BezierCurve, C2: Geom_BezierCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def Init(self, C1: Geom_BezierCurve, C2: Geom_BezierCurve, C3: Geom_BezierCurve, C4: Geom_BezierCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def Init(self, C1: Geom_BezierCurve, C2: Geom_BezierCurve, C3: Geom_BezierCurve, Type: GeomFill_FillingStyle) -> None: ...
    @overload
    def Init(self, C1: Geom_BezierCurve, C2: Geom_BezierCurve, Type: GeomFill_FillingStyle) -> None: ...
    def Surface(self) -> Geom_BezierSurface: ...

class GeomFill_Boundary(Standard_Transient):
    def Bounds(self) -> Tuple[float, float]: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def D1Norm(self, U: float, N: gp_Vec, DN: gp_Vec) -> None: ...
    def HasNormals(self) -> bool: ...
    def IsDegenerated(self) -> bool: ...
    def Norm(self, U: float) -> gp_Vec: ...
    def Points(self, PFirst: gp_Pnt, PLast: gp_Pnt) -> None: ...
    def Reparametrize(self, First: float, Last: float, HasDF: bool, HasDL: bool, DF: float, DL: float, Rev: bool) -> None: ...
    @overload
    def Tol3d(self) -> float: ...
    @overload
    def Tol3d(self, Tol: float) -> None: ...
    @overload
    def Tolang(self) -> float: ...
    @overload
    def Tolang(self, Tol: float) -> None: ...
    def Value(self, U: float) -> gp_Pnt: ...

class GeomFill_CircularBlendFunc(Approx_SweepFunction):
    def __init__(self, Path: Adaptor3d_HCurve, Curve1: Adaptor3d_HCurve, Curve2: Adaptor3d_HCurve, Radius: float, Polynomial: Optional[bool] = False) -> None: ...
    def BarycentreOfSurf(self) -> gp_Pnt: ...
    def D0(self, Param: float, First: float, Last: float, Poles: TColgp_Array1OfPnt, Poles2d: TColgp_Array1OfPnt2d, Weigths: TColStd_Array1OfReal) -> bool: ...
    def D1(self, Param: float, First: float, Last: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    def D2(self, Param: float, First: float, Last: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, D2Poles2d: TColgp_Array1OfVec2d, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal, D2Weigths: TColStd_Array1OfReal) -> bool: ...
    def GetMinimalWeight(self, Weigths: TColStd_Array1OfReal) -> None: ...
    def GetTolerance(self, BoundTol: float, SurfTol: float, AngleTol: float, Tol3d: TColStd_Array1OfReal) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsRational(self) -> bool: ...
    def Knots(self, TKnots: TColStd_Array1OfReal) -> None: ...
    def MaximalSection(self) -> float: ...
    def Mults(self, TMults: TColStd_Array1OfInteger) -> None: ...
    def Nb2dCurves(self) -> int: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SectionShape(self) -> Tuple[int, int, int]: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetTolerance(self, Tol3d: float, Tol2d: float) -> None: ...

class GeomFill_ConstrainedFilling:
    def __init__(self, MaxDeg: int, MaxSeg: int) -> None: ...
    def Boundary(self, I: int) -> GeomFill_Boundary: ...
    def CheckApprox(self, I: int) -> None: ...
    def CheckCoonsAlgPatch(self, I: int) -> None: ...
    def CheckResult(self, I: int) -> None: ...
    def CheckTgteField(self, I: int) -> None: ...
    def Eval(self, W: float, Ord: int) -> Tuple[int, float]: ...
    @overload
    def Init(self, B1: GeomFill_Boundary, B2: GeomFill_Boundary, B3: GeomFill_Boundary, NoCheck: Optional[bool] = False) -> None: ...
    @overload
    def Init(self, B1: GeomFill_Boundary, B2: GeomFill_Boundary, B3: GeomFill_Boundary, B4: GeomFill_Boundary, NoCheck: Optional[bool] = False) -> None: ...
    def ReBuild(self) -> None: ...
    def SetDomain(self, l: float, B: GeomFill_BoundWithSurf) -> None: ...
    def Surface(self) -> Geom_BSplineSurface: ...

class GeomFill_CoonsAlgPatch(Standard_Transient):
    def __init__(self, B1: GeomFill_Boundary, B2: GeomFill_Boundary, B3: GeomFill_Boundary, B4: GeomFill_Boundary) -> None: ...
    def Bound(self, I: int) -> GeomFill_Boundary: ...
    def Corner(self, I: int) -> gp_Pnt: ...
    def D1U(self, U: float, V: float) -> gp_Vec: ...
    def D1V(self, U: float, V: float) -> gp_Vec: ...
    def DUV(self, U: float, V: float) -> gp_Vec: ...
    @overload
    def Func(self, f1: Law_Function, f2: Law_Function) -> None: ...
    @overload
    def Func(self, I: int) -> Law_Function: ...
    def SetFunc(self, f1: Law_Function, f2: Law_Function) -> None: ...
    def Value(self, U: float, V: float) -> gp_Pnt: ...

class GeomFill_CornerState:
    def __init__(self) -> None: ...
    def Constraint(self) -> None: ...
    def DoKill(self, Scal: float) -> None: ...
    @overload
    def Gap(self) -> float: ...
    @overload
    def Gap(self, G: float) -> None: ...
    def HasConstraint(self) -> bool: ...
    def IsToKill(self) -> Tuple[bool, float]: ...
    @overload
    def NorAng(self) -> float: ...
    @overload
    def NorAng(self, Ang: float) -> None: ...
    @overload
    def TgtAng(self) -> float: ...
    @overload
    def TgtAng(self, Ang: float) -> None: ...

class GeomFill_Filling:
    def __init__(self) -> None: ...
    def NbUPoles(self) -> int: ...
    def NbVPoles(self) -> int: ...
    def Poles(self, Poles: TColgp_Array2OfPnt) -> None: ...
    def Weights(self, Weights: TColStd_Array2OfReal) -> None: ...
    def isRational(self) -> bool: ...

class GeomFill_FunctionDraft(math_FunctionSetWithDerivatives):
    def __init__(self, S: Adaptor3d_HSurface, C: Adaptor3d_HCurve) -> None: ...
    def Deriv2T(self, C: Adaptor3d_HCurve, Param: float, W: float, d2N: gp_Vec, teta: float, F: math_Vector) -> bool: ...
    def Deriv2X(self, X: math_Vector, T: GeomFill_Tensor) -> bool: ...
    def DerivT(self, C: Adaptor3d_HCurve, Param: float, W: float, dN: gp_Vec, teta: float, F: math_Vector) -> bool: ...
    def DerivTX(self, dN: gp_Vec, teta: float, D: math_Matrix) -> bool: ...
    def Derivatives(self, X: math_Vector, D: math_Matrix) -> bool: ...
    def NbEquations(self) -> int: ...
    def NbVariables(self) -> int: ...
    def Value(self, X: math_Vector, F: math_Vector) -> bool: ...
    def Values(self, X: math_Vector, F: math_Vector, D: math_Matrix) -> bool: ...

class GeomFill_FunctionGuide(math_FunctionSetWithDerivatives):
    def __init__(self, S: GeomFill_SectionLaw, Guide: Adaptor3d_HCurve, ParamOnLaw: Optional[float] = 0.0) -> None: ...
    def DerivT(self, X: math_Vector, DCentre: gp_XYZ, DDir: gp_XYZ, DFDT: math_Vector) -> bool: ...
    def Derivatives(self, X: math_Vector, D: math_Matrix) -> bool: ...
    def NbEquations(self) -> int: ...
    def NbVariables(self) -> int: ...
    def SetParam(self, Param: float, Centre: gp_Pnt, Dir: gp_XYZ, XDir: gp_XYZ) -> None: ...
    def Value(self, X: math_Vector, F: math_Vector) -> bool: ...
    def Values(self, X: math_Vector, F: math_Vector, D: math_Matrix) -> bool: ...

class GeomFill_Line(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, NbPoints: int) -> None: ...
    def NbPoints(self) -> int: ...
    def Point(self, Index: int) -> int: ...

class GeomFill_LocFunction:
    def __init__(self, Law: GeomFill_LocationLaw) -> None: ...
    def D0(self, Param: float, First: float, Last: float) -> bool: ...
    def D1(self, Param: float, First: float, Last: float) -> bool: ...
    def D2(self, Param: float, First: float, Last: float) -> bool: ...
    def DN(self, Param: float, First: float, Last: float, Order: int) -> Tuple[float, int]: ...

class GeomFill_LocationLaw(Standard_Transient):
    def Copy(self) -> GeomFill_LocationLaw: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec) -> bool: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d) -> bool: ...
    def D1(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d) -> bool: ...
    def D2(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, D2M: gp_Mat, D2V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, D2Poles2d: TColgp_Array1OfVec2d) -> bool: ...
    def ErrorStatus(self) -> GeomFill_PipeError: ...
    def GetAverageLaw(self, AM: gp_Mat, AV: gp_Vec) -> None: ...
    def GetCurve(self) -> Adaptor3d_HCurve: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMaximalNorm(self) -> float: ...
    def HasFirstRestriction(self) -> bool: ...
    def HasLastRestriction(self) -> bool: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsRotation(self) -> Tuple[bool, float]: ...
    def IsTranslation(self) -> Tuple[bool, float]: ...
    def Nb2dCurves(self) -> int: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Resolution(self, Index: int, Tol: float) -> Tuple[float, float]: ...
    def Rotation(self, Center: gp_Pnt) -> None: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetTolerance(self, Tol3d: float, Tol2d: float) -> None: ...
    def SetTrsf(self, Transfo: gp_Mat) -> None: ...
    def TraceNumber(self) -> int: ...

class GeomFill_Pipe:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Path: Geom_Curve, Radius: float) -> None: ...
    @overload
    def __init__(self, Path: Geom_Curve, FirstSect: Geom_Curve, Option: Optional[GeomFill_Trihedron] = GeomFill_IsCorrectedFrenet) -> None: ...
    @overload
    def __init__(self, Path: Geom2d_Curve, Support: Geom_Surface, FirstSect: Geom_Curve) -> None: ...
    @overload
    def __init__(self, Path: Geom_Curve, FirstSect: Geom_Curve, Dir: gp_Dir) -> None: ...
    @overload
    def __init__(self, Path: Geom_Curve, FirstSect: Geom_Curve, LastSect: Geom_Curve) -> None: ...
    @overload
    def __init__(self, Path: Geom_Curve, NSections: TColGeom_SequenceOfCurve) -> None: ...
    @overload
    def __init__(self, Path: Geom_Curve, Curve1: Geom_Curve, Curve2: Geom_Curve, Radius: float) -> None: ...
    @overload
    def __init__(self, Path: Adaptor3d_HCurve, Curve1: Adaptor3d_HCurve, Curve2: Adaptor3d_HCurve, Radius: float) -> None: ...
    @overload
    def __init__(self, Path: Geom_Curve, Guide: Adaptor3d_HCurve, FirstSect: Geom_Curve, ByACR: bool, rotat: bool) -> None: ...
    def ErrorOnSurf(self) -> float: ...
    def ExchangeUV(self) -> bool: ...
    @overload
    def GenerateParticularCase(self, B: bool) -> None: ...
    @overload
    def GenerateParticularCase(self) -> bool: ...
    @overload
    def Init(self, Path: Geom_Curve, Radius: float) -> None: ...
    @overload
    def Init(self, Path: Geom_Curve, FirstSect: Geom_Curve, Option: Optional[GeomFill_Trihedron] = GeomFill_IsCorrectedFrenet) -> None: ...
    @overload
    def Init(self, Path: Geom2d_Curve, Support: Geom_Surface, FirstSect: Geom_Curve) -> None: ...
    @overload
    def Init(self, Path: Geom_Curve, FirstSect: Geom_Curve, Dir: gp_Dir) -> None: ...
    @overload
    def Init(self, Path: Geom_Curve, FirstSect: Geom_Curve, LastSect: Geom_Curve) -> None: ...
    @overload
    def Init(self, Path: Geom_Curve, NSections: TColGeom_SequenceOfCurve) -> None: ...
    @overload
    def Init(self, Path: Adaptor3d_HCurve, Curve1: Adaptor3d_HCurve, Curve2: Adaptor3d_HCurve, Radius: float) -> None: ...
    @overload
    def Init(self, Path: Geom_Curve, Guide: Adaptor3d_HCurve, FirstSect: Geom_Curve, ByACR: bool, rotat: bool) -> None: ...
    def IsDone(self) -> bool: ...
    @overload
    def Perform(self, WithParameters: Optional[bool] = False, myPolynomial: Optional[bool] = False) -> None: ...
    @overload
    def Perform(self, Tol: float, Polynomial: bool, Conti: Optional[GeomAbs_Shape] = GeomAbs_C1, MaxDegree: Optional[int] = 11, NbMaxSegment: Optional[int] = 30) -> None: ...
    def Surface(self) -> Geom_Surface: ...

class GeomFill_PlanFunc(math_FunctionWithDerivative):
    def __init__(self, P: gp_Pnt, V: gp_Vec, C: Adaptor3d_HCurve) -> None: ...
    def D2(self, X: float) -> Tuple[float, float, float]: ...
    def D2E(self, X: float, DP: gp_Vec, D2P: gp_Vec, DV: gp_Vec, D2V: gp_Vec) -> Tuple[float, float, float]: ...
    def DEDT(self, X: float, DP: gp_Vec, DV: gp_Vec) -> float: ...
    def Derivative(self, X: float) -> Tuple[bool, float]: ...
    def Value(self, X: float) -> Tuple[bool, float]: ...
    def Values(self, X: float) -> Tuple[bool, float, float]: ...

class GeomFill_PolynomialConvertor:
    def __init__(self) -> None: ...
    def Init(self) -> None: ...
    def Initialized(self) -> bool: ...
    @overload
    def Section(self, FirstPnt: gp_Pnt, Center: gp_Pnt, Dir: gp_Vec, Angle: float, Poles: TColgp_Array1OfPnt) -> None: ...
    @overload
    def Section(self, FirstPnt: gp_Pnt, DFirstPnt: gp_Vec, Center: gp_Pnt, DCenter: gp_Vec, Dir: gp_Vec, DDir: gp_Vec, Angle: float, DAngle: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec) -> None: ...
    @overload
    def Section(self, FirstPnt: gp_Pnt, DFirstPnt: gp_Vec, D2FirstPnt: gp_Vec, Center: gp_Pnt, DCenter: gp_Vec, D2Center: gp_Vec, Dir: gp_Vec, DDir: gp_Vec, D2Dir: gp_Vec, Angle: float, DAngle: float, D2Angle: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec) -> None: ...

class GeomFill_Profiler:
    def __init__(self) -> None: ...
    def AddCurve(self, Curve: Geom_Curve) -> None: ...
    def Curve(self, Index: int) -> Geom_Curve: ...
    def Degree(self) -> int: ...
    def IsPeriodic(self) -> bool: ...
    def KnotsAndMults(self, Knots: TColStd_Array1OfReal, Mults: TColStd_Array1OfInteger) -> None: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def Perform(self, PTol: float) -> None: ...
    def Poles(self, Index: int, Poles: TColgp_Array1OfPnt) -> None: ...
    def Weights(self, Index: int, Weights: TColStd_Array1OfReal) -> None: ...

class GeomFill_QuasiAngularConvertor:
    def __init__(self) -> None: ...
    def Init(self) -> None: ...
    def Initialized(self) -> bool: ...
    @overload
    def Section(self, FirstPnt: gp_Pnt, Center: gp_Pnt, Dir: gp_Vec, Angle: float, Poles: TColgp_Array1OfPnt, Weights: TColStd_Array1OfReal) -> None: ...
    @overload
    def Section(self, FirstPnt: gp_Pnt, DFirstPnt: gp_Vec, Center: gp_Pnt, DCenter: gp_Vec, Dir: gp_Vec, DDir: gp_Vec, Angle: float, DAngle: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Weights: TColStd_Array1OfReal, DWeights: TColStd_Array1OfReal) -> None: ...
    @overload
    def Section(self, FirstPnt: gp_Pnt, DFirstPnt: gp_Vec, D2FirstPnt: gp_Vec, Center: gp_Pnt, DCenter: gp_Vec, D2Center: gp_Vec, Dir: gp_Vec, DDir: gp_Vec, D2Dir: gp_Vec, Angle: float, DAngle: float, D2Angle: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Weights: TColStd_Array1OfReal, DWeights: TColStd_Array1OfReal, D2Weights: TColStd_Array1OfReal) -> None: ...

class GeomFill_SectionLaw(Standard_Transient):
    def BSplineSurface(self) -> Geom_BSplineSurface: ...
    def BarycentreOfSurf(self) -> gp_Pnt: ...
    def CirclSection(self, Param: float) -> Geom_Curve: ...
    def ConstantSection(self) -> Geom_Curve: ...
    def D0(self, Param: float, Poles: TColgp_Array1OfPnt, Weigths: TColStd_Array1OfReal) -> bool: ...
    def D1(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    def D2(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal, D2Weigths: TColStd_Array1OfReal) -> bool: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMinimalWeight(self, Weigths: TColStd_Array1OfReal) -> None: ...
    def GetTolerance(self, BoundTol: float, SurfTol: float, AngleTol: float, Tol3d: TColStd_Array1OfReal) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConicalLaw(self) -> Tuple[bool, float]: ...
    def IsConstant(self) -> Tuple[bool, float]: ...
    def IsRational(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def Knots(self, TKnots: TColStd_Array1OfReal) -> None: ...
    def MaximalSection(self) -> float: ...
    def Mults(self, TMults: TColStd_Array1OfInteger) -> None: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SectionShape(self) -> Tuple[int, int, int]: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetTolerance(self, Tol3d: float, Tol2d: float) -> None: ...

class GeomFill_SectionPlacement:
    def __init__(self, L: GeomFill_LocationLaw, Section: Geom_Geometry) -> None: ...
    def Angle(self) -> float: ...
    def Distance(self) -> float: ...
    def IsDone(self) -> bool: ...
    def ModifiedSection(self, WithTranslation: bool) -> Geom_Curve: ...
    def ParameterOnPath(self) -> float: ...
    def ParameterOnSection(self) -> float: ...
    @overload
    def Perform(self, Tol: float) -> None: ...
    @overload
    def Perform(self, Path: Adaptor3d_HCurve, Tol: float) -> None: ...
    @overload
    def Perform(self, ParamOnPath: float, Tol: float) -> None: ...
    def Section(self, WithTranslation: bool) -> Geom_Curve: ...
    def SetLocation(self, L: GeomFill_LocationLaw) -> None: ...
    def Transformation(self, WithTranslation: bool, WithCorrection: Optional[bool] = False) -> gp_Trsf: ...

class GeomFill_SnglrFunc(Adaptor3d_Curve):
    def __init__(self, HC: Adaptor3d_HCurve) -> None: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
    def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
    def DN(self, U: float, N: int) -> gp_Vec: ...
    def FirstParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_CurveType: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsPeriodic(self) -> bool: ...
    def LastParameter(self) -> float: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Period(self) -> float: ...
    def Resolution(self, R3d: float) -> float: ...
    def SetRatio(self, Ratio: float) -> None: ...
    def Value(self, U: float) -> gp_Pnt: ...

class GeomFill_Sweep:
    def __init__(self, Location: GeomFill_LocationLaw, WithKpart: Optional[bool] = True) -> None: ...
    def Build(self, Section: GeomFill_SectionLaw, Methode: Optional[GeomFill_ApproxStyle] = GeomFill_Location, Continuity: Optional[GeomAbs_Shape] = GeomAbs_C2, Degmax: Optional[int] = 10, Segmax: Optional[int] = 30) -> None: ...
    def ErrorOnRestriction(self, IsFirst: bool) -> Tuple[float, float]: ...
    def ErrorOnSurface(self) -> float: ...
    def ErrorOnTrace(self, IndexOfTrace: int) -> Tuple[float, float]: ...
    def ExchangeUV(self) -> bool: ...
    def IsDone(self) -> bool: ...
    def NumberOfTrace(self) -> int: ...
    def Restriction(self, IsFirst: bool) -> Geom2d_Curve: ...
    def SetDomain(self, First: float, Last: float, SectionFirst: float, SectionLast: float) -> None: ...
    def SetForceApproxC1(self, ForceApproxC1: bool) -> None: ...
    def SetTolerance(self, Tol3d: float, BoundTol: Optional[float] = 1.0, Tol2d: Optional[float] = 1.0e-5, TolAngular: Optional[float] = 1.0) -> None: ...
    def Surface(self) -> Geom_Surface: ...
    def Trace(self, IndexOfTrace: int) -> Geom2d_Curve: ...
    def UReversed(self) -> bool: ...
    def VReversed(self) -> bool: ...

class GeomFill_SweepFunction(Approx_SweepFunction):
    def __init__(self, Section: GeomFill_SectionLaw, Location: GeomFill_LocationLaw, FirstParameter: float, FirstParameterOnS: float, RatioParameterOnS: float) -> None: ...
    def BarycentreOfSurf(self) -> gp_Pnt: ...
    def D0(self, Param: float, First: float, Last: float, Poles: TColgp_Array1OfPnt, Poles2d: TColgp_Array1OfPnt2d, Weigths: TColStd_Array1OfReal) -> bool: ...
    def D1(self, Param: float, First: float, Last: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    def D2(self, Param: float, First: float, Last: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, D2Poles2d: TColgp_Array1OfVec2d, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal, D2Weigths: TColStd_Array1OfReal) -> bool: ...
    def GetMinimalWeight(self, Weigths: TColStd_Array1OfReal) -> None: ...
    def GetTolerance(self, BoundTol: float, SurfTol: float, AngleTol: float, Tol3d: TColStd_Array1OfReal) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsRational(self) -> bool: ...
    def Knots(self, TKnots: TColStd_Array1OfReal) -> None: ...
    def MaximalSection(self) -> float: ...
    def Mults(self, TMults: TColStd_Array1OfInteger) -> None: ...
    def Nb2dCurves(self) -> int: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Resolution(self, Index: int, Tol: float) -> Tuple[float, float]: ...
    def SectionShape(self) -> Tuple[int, int, int]: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetTolerance(self, Tol3d: float, Tol2d: float) -> None: ...

class GeomFill_Tensor:
    def __init__(self, NbRow: int, NbCol: int, NbMat: int) -> None: ...
    def GetChangeValue(self, Row: int, Col: int, Mat: int) -> float: ...
    def SetChangeValue(self, Row: int, Col: int, Mat: int, value: float) -> None: ...
    def Init(self, InitialValue: float) -> None: ...
    def Multiply(self, Right: math_Vector, Product: math_Matrix) -> None: ...
    def Value(self, Row: int, Col: int, Mat: int) -> float: ...

class GeomFill_TgtField(Standard_Transient):
    @overload
    def D1(self, W: float) -> gp_Vec: ...
    @overload
    def D1(self, W: float, V: gp_Vec, DV: gp_Vec) -> None: ...
    def IsScalable(self) -> bool: ...
    def Scale(self, Func: Law_BSpline) -> None: ...
    def Value(self, W: float) -> gp_Vec: ...

class GeomFill_TrihedronLaw(Standard_Transient):
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def ErrorStatus(self) -> GeomFill_PipeError: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...

class GeomFill_BoundWithSurf(GeomFill_Boundary):
    def __init__(self, CurveOnSurf: Adaptor3d_CurveOnSurface, Tol3d: float, Tolang: float) -> None: ...
    def Bounds(self) -> Tuple[float, float]: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def D1Norm(self, U: float, N: gp_Vec, DN: gp_Vec) -> None: ...
    def HasNormals(self) -> bool: ...
    def IsDegenerated(self) -> bool: ...
    def Norm(self, U: float) -> gp_Vec: ...
    def Reparametrize(self, First: float, Last: float, HasDF: bool, HasDL: bool, DF: float, DL: float, Rev: bool) -> None: ...
    def Value(self, U: float) -> gp_Pnt: ...

class GeomFill_ConstantBiNormal(GeomFill_TrihedronLaw):
    def __init__(self, BiNormal: gp_Dir) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...

class GeomFill_Coons(GeomFill_Filling):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal, W3: TColStd_Array1OfReal, W4: TColStd_Array1OfReal) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal, W3: TColStd_Array1OfReal, W4: TColStd_Array1OfReal) -> None: ...

class GeomFill_CorrectedFrenet(GeomFill_TrihedronLaw):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, ForEvaluation: bool) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def EvaluateBestMode(self) -> GeomFill_Trihedron: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...

class GeomFill_CurveAndTrihedron(GeomFill_LocationLaw):
    def __init__(self, Trihedron: GeomFill_TrihedronLaw) -> None: ...
    def Copy(self) -> GeomFill_LocationLaw: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec) -> bool: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d) -> bool: ...
    def D1(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d) -> bool: ...
    def D2(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, D2M: gp_Mat, D2V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, D2Poles2d: TColgp_Array1OfVec2d) -> bool: ...
    def GetAverageLaw(self, AM: gp_Mat, AV: gp_Vec) -> None: ...
    def GetCurve(self) -> Adaptor3d_HCurve: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMaximalNorm(self) -> float: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsRotation(self) -> Tuple[bool, float]: ...
    def IsTranslation(self) -> Tuple[bool, float]: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Rotation(self, Center: gp_Pnt) -> None: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetTrsf(self, Transfo: gp_Mat) -> None: ...

class GeomFill_Curved(GeomFill_Filling):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal, W3: TColStd_Array1OfReal, W4: TColStd_Array1OfReal) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal, W3: TColStd_Array1OfReal, W4: TColStd_Array1OfReal) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal) -> None: ...

class GeomFill_Darboux(GeomFill_TrihedronLaw):
    def __init__(self) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...

class GeomFill_DegeneratedBound(GeomFill_Boundary):
    def __init__(self, Point: gp_Pnt, First: float, Last: float, Tol3d: float, Tolang: float) -> None: ...
    def Bounds(self) -> Tuple[float, float]: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def IsDegenerated(self) -> bool: ...
    def Reparametrize(self, First: float, Last: float, HasDF: bool, HasDL: bool, DF: float, DL: float, Rev: bool) -> None: ...
    def Value(self, U: float) -> gp_Pnt: ...

class GeomFill_DiscreteTrihedron(GeomFill_TrihedronLaw):
    def __init__(self) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Init(self) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...

class GeomFill_DraftTrihedron(GeomFill_TrihedronLaw):
    def __init__(self, BiNormal: gp_Vec, Angle: float) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SetAngle(self, Angle: float) -> None: ...

class GeomFill_EvolvedSection(GeomFill_SectionLaw):
    def __init__(self, C: Geom_Curve, L: Law_Function) -> None: ...
    def BSplineSurface(self) -> Geom_BSplineSurface: ...
    def BarycentreOfSurf(self) -> gp_Pnt: ...
    def ConstantSection(self) -> Geom_Curve: ...
    def D0(self, Param: float, Poles: TColgp_Array1OfPnt, Weigths: TColStd_Array1OfReal) -> bool: ...
    def D1(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    def D2(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal, D2Weigths: TColStd_Array1OfReal) -> bool: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMinimalWeight(self, Weigths: TColStd_Array1OfReal) -> None: ...
    def GetTolerance(self, BoundTol: float, SurfTol: float, AngleTol: float, Tol3d: TColStd_Array1OfReal) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> Tuple[bool, float]: ...
    def IsRational(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def Knots(self, TKnots: TColStd_Array1OfReal) -> None: ...
    def MaximalSection(self) -> float: ...
    def Mults(self, TMults: TColStd_Array1OfInteger) -> None: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SectionShape(self) -> Tuple[int, int, int]: ...
    def SetInterval(self, First: float, Last: float) -> None: ...

class GeomFill_Fixed(GeomFill_TrihedronLaw):
    def __init__(self, Tangent: gp_Vec, Normal: gp_Vec) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...

class GeomFill_Frenet(GeomFill_TrihedronLaw):
    def __init__(self) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Init(self) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...

class GeomFill_Generator(GeomFill_Profiler):
    def __init__(self) -> None: ...
    def Perform(self, PTol: float) -> None: ...
    def Surface(self) -> Geom_Surface: ...

class GeomFill_LocationDraft(GeomFill_LocationLaw):
    def __init__(self, Direction: gp_Dir, Angle: float) -> None: ...
    def Copy(self) -> GeomFill_LocationLaw: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec) -> bool: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d) -> bool: ...
    def D1(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d) -> bool: ...
    def D2(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, D2M: gp_Mat, D2V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, D2Poles2d: TColgp_Array1OfVec2d) -> bool: ...
    def Direction(self) -> gp_Dir: ...
    def GetAverageLaw(self, AM: gp_Mat, AV: gp_Vec) -> None: ...
    def GetCurve(self) -> Adaptor3d_HCurve: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMaximalNorm(self) -> float: ...
    def HasFirstRestriction(self) -> bool: ...
    def HasLastRestriction(self) -> bool: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsIntersec(self) -> bool: ...
    def IsRotation(self) -> Tuple[bool, float]: ...
    def IsTranslation(self) -> Tuple[bool, float]: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Resolution(self, Index: int, Tol: float) -> Tuple[float, float]: ...
    def Rotation(self, Center: gp_Pnt) -> None: ...
    def SetAngle(self, Angle: float) -> None: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetStopSurf(self, Surf: Adaptor3d_HSurface) -> None: ...
    def SetTrsf(self, Transfo: gp_Mat) -> None: ...
    def TraceNumber(self) -> int: ...

class GeomFill_LocationGuide(GeomFill_LocationLaw):
    def __init__(self, Triedre: GeomFill_TrihedronWithGuide) -> None: ...
    def ComputeAutomaticLaw(self, ParAndRad: TColgp_HArray1OfPnt2d) -> GeomFill_PipeError: ...
    def Copy(self) -> GeomFill_LocationLaw: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec) -> bool: ...
    @overload
    def D0(self, Param: float, M: gp_Mat, V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d) -> bool: ...
    def D1(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d) -> bool: ...
    def D2(self, Param: float, M: gp_Mat, V: gp_Vec, DM: gp_Mat, DV: gp_Vec, D2M: gp_Mat, D2V: gp_Vec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, D2Poles2d: TColgp_Array1OfVec2d) -> bool: ...
    def EraseRotation(self) -> None: ...
    def ErrorStatus(self) -> GeomFill_PipeError: ...
    def GetAverageLaw(self, AM: gp_Mat, AV: gp_Vec) -> None: ...
    def GetCurve(self) -> Adaptor3d_HCurve: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMaximalNorm(self) -> float: ...
    def Guide(self) -> Adaptor3d_HCurve: ...
    def HasFirstRestriction(self) -> bool: ...
    def HasLastRestriction(self) -> bool: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsRotation(self) -> Tuple[bool, float]: ...
    def IsTranslation(self) -> Tuple[bool, float]: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Resolution(self, Index: int, Tol: float) -> Tuple[float, float]: ...
    def Rotation(self, Center: gp_Pnt) -> None: ...
    def Section(self) -> Geom_Curve: ...
    def Set(self, Section: GeomFill_SectionLaw, rotat: bool, SFirst: float, SLast: float, PrecAngle: float) -> float: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetOrigine(self, Param1: float, Param2: float) -> None: ...
    def SetTolerance(self, Tol3d: float, Tol2d: float) -> None: ...
    def SetTrsf(self, Transfo: gp_Mat) -> None: ...
    def TraceNumber(self) -> int: ...

class GeomFill_NSections(GeomFill_SectionLaw):
    @overload
    def __init__(self, NC: TColGeom_SequenceOfCurve) -> None: ...
    @overload
    def __init__(self, NC: TColGeom_SequenceOfCurve, NP: TColStd_SequenceOfReal) -> None: ...
    @overload
    def __init__(self, NC: TColGeom_SequenceOfCurve, NP: TColStd_SequenceOfReal, UF: float, UL: float, VF: float, VL: float) -> None: ...
    @overload
    def __init__(self, NC: TColGeom_SequenceOfCurve, Trsfs: GeomFill_SequenceOfTrsf, NP: TColStd_SequenceOfReal, UF: float, UL: float, VF: float, VL: float, Surf: Geom_BSplineSurface) -> None: ...
    def BSplineSurface(self) -> Geom_BSplineSurface: ...
    def BarycentreOfSurf(self) -> gp_Pnt: ...
    def CirclSection(self, Param: float) -> Geom_Curve: ...
    def ComputeSurface(self) -> None: ...
    def ConstantSection(self) -> Geom_Curve: ...
    def D0(self, Param: float, Poles: TColgp_Array1OfPnt, Weigths: TColStd_Array1OfReal) -> bool: ...
    def D1(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    def D2(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal, D2Weigths: TColStd_Array1OfReal) -> bool: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMinimalWeight(self, Weigths: TColStd_Array1OfReal) -> None: ...
    def GetTolerance(self, BoundTol: float, SurfTol: float, AngleTol: float, Tol3d: TColStd_Array1OfReal) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConicalLaw(self) -> Tuple[bool, float]: ...
    def IsConstant(self) -> Tuple[bool, float]: ...
    def IsRational(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def Knots(self, TKnots: TColStd_Array1OfReal) -> None: ...
    def MaximalSection(self) -> float: ...
    def Mults(self, TMults: TColStd_Array1OfInteger) -> None: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SectionShape(self) -> Tuple[int, int, int]: ...
    def SetInterval(self, First: float, Last: float) -> None: ...
    def SetSurface(self, RefSurf: Geom_BSplineSurface) -> None: ...

class GeomFill_SectionGenerator(GeomFill_Profiler):
    def __init__(self) -> None: ...
    def GetShape(self) -> Tuple[int, int, int, int]: ...
    def Knots(self, TKnots: TColStd_Array1OfReal) -> None: ...
    def Mults(self, TMults: TColStd_Array1OfInteger) -> None: ...
    def Parameter(self, P: int) -> float: ...
    @overload
    def Section(self, P: int, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Poles2d: TColgp_Array1OfPnt2d, DPoles2d: TColgp_Array1OfVec2d, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    @overload
    def Section(self, P: int, Poles: TColgp_Array1OfPnt, Poles2d: TColgp_Array1OfPnt2d, Weigths: TColStd_Array1OfReal) -> None: ...
    def SetParam(self, Params: TColStd_HArray1OfReal) -> None: ...

class GeomFill_SimpleBound(GeomFill_Boundary):
    def __init__(self, Curve: Adaptor3d_HCurve, Tol3d: float, Tolang: float) -> None: ...
    def Bounds(self) -> Tuple[float, float]: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def IsDegenerated(self) -> bool: ...
    def Reparametrize(self, First: float, Last: float, HasDF: bool, HasDL: bool, DF: float, DL: float, Rev: bool) -> None: ...
    def Value(self, U: float) -> gp_Pnt: ...

class GeomFill_Stretch(GeomFill_Filling):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt) -> None: ...
    @overload
    def __init__(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal, W3: TColStd_Array1OfReal, W4: TColStd_Array1OfReal) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt) -> None: ...
    @overload
    def Init(self, P1: TColgp_Array1OfPnt, P2: TColgp_Array1OfPnt, P3: TColgp_Array1OfPnt, P4: TColgp_Array1OfPnt, W1: TColStd_Array1OfReal, W2: TColStd_Array1OfReal, W3: TColStd_Array1OfReal, W4: TColStd_Array1OfReal) -> None: ...

class GeomFill_TgtOnCoons(GeomFill_TgtField):
    def __init__(self, K: GeomFill_CoonsAlgPatch, I: int) -> None: ...
    @overload
    def D1(self, W: float) -> gp_Vec: ...
    @overload
    def D1(self, W: float, T: gp_Vec, DT: gp_Vec) -> None: ...
    def Value(self, W: float) -> gp_Vec: ...

class GeomFill_TrihedronWithGuide(GeomFill_TrihedronLaw):
    def CurrentPointOnGuide(self) -> gp_Pnt: ...
    def Guide(self) -> Adaptor3d_HCurve: ...
    def Origine(self, Param1: float, Param2: float) -> None: ...

class GeomFill_UniformSection(GeomFill_SectionLaw):
    def __init__(self, C: Geom_Curve, FirstParameter: Optional[float] = 0.0, LastParameter: Optional[float] = 1.0) -> None: ...
    def BSplineSurface(self) -> Geom_BSplineSurface: ...
    def BarycentreOfSurf(self) -> gp_Pnt: ...
    def ConstantSection(self) -> Geom_Curve: ...
    def D0(self, Param: float, Poles: TColgp_Array1OfPnt, Weigths: TColStd_Array1OfReal) -> bool: ...
    def D1(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal) -> bool: ...
    def D2(self, Param: float, Poles: TColgp_Array1OfPnt, DPoles: TColgp_Array1OfVec, D2Poles: TColgp_Array1OfVec, Weigths: TColStd_Array1OfReal, DWeigths: TColStd_Array1OfReal, D2Weigths: TColStd_Array1OfReal) -> bool: ...
    def GetDomain(self) -> Tuple[float, float]: ...
    def GetInterval(self) -> Tuple[float, float]: ...
    def GetMinimalWeight(self, Weigths: TColStd_Array1OfReal) -> None: ...
    def GetTolerance(self, BoundTol: float, SurfTol: float, AngleTol: float, Tol3d: TColStd_Array1OfReal) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> Tuple[bool, float]: ...
    def IsRational(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def Knots(self, TKnots: TColStd_Array1OfReal) -> None: ...
    def MaximalSection(self) -> float: ...
    def Mults(self, TMults: TColStd_Array1OfInteger) -> None: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def SectionShape(self) -> Tuple[int, int, int]: ...
    def SetInterval(self, First: float, Last: float) -> None: ...

class GeomFill_GuideTrihedronAC(GeomFill_TrihedronWithGuide):
    def __init__(self, guide: Adaptor3d_HCurve) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Guide(self) -> Adaptor3d_HCurve: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Origine(self, OrACR1: float, OrACR2: float) -> None: ...
    def SetCurve(self, C: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...

class GeomFill_GuideTrihedronPlan(GeomFill_TrihedronWithGuide):
    def __init__(self, theGuide: Adaptor3d_HCurve) -> None: ...
    def Copy(self) -> GeomFill_TrihedronLaw: ...
    def D0(self, Param: float, Tangent: gp_Vec, Normal: gp_Vec, BiNormal: gp_Vec) -> bool: ...
    def D1(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec) -> bool: ...
    def D2(self, Param: float, Tangent: gp_Vec, DTangent: gp_Vec, D2Tangent: gp_Vec, Normal: gp_Vec, DNormal: gp_Vec, D2Normal: gp_Vec, BiNormal: gp_Vec, DBiNormal: gp_Vec, D2BiNormal: gp_Vec) -> bool: ...
    def ErrorStatus(self) -> GeomFill_PipeError: ...
    def GetAverageLaw(self, ATangent: gp_Vec, ANormal: gp_Vec, ABiNormal: gp_Vec) -> None: ...
    def Guide(self) -> Adaptor3d_HCurve: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsConstant(self) -> bool: ...
    def IsOnlyBy3dCurve(self) -> bool: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def Origine(self, OrACR1: float, OrACR2: float) -> None: ...
    def SetCurve(self, thePath: Adaptor3d_HCurve) -> None: ...
    def SetInterval(self, First: float, Last: float) -> None: ...

#classnotwrapped
class GeomFill_SweepSectionGenerator: ...

# harray1 classes

class GeomFill_HArray1OfLocationLaw(GeomFill_Array1OfLocationLaw, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> GeomFill_Array1OfLocationLaw: ...


class GeomFill_HArray1OfSectionLaw(GeomFill_Array1OfSectionLaw, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> GeomFill_Array1OfSectionLaw: ...

# harray2 classes
# hsequence classes

class GeomFill_HSequenceOfAx2(GeomFill_SequenceOfAx2, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GeomFill_SequenceOfAx2) -> None: ...
    def Sequence(self) -> GeomFill_SequenceOfAx2: ...
    def Append(self, theSequence: GeomFill_SequenceOfAx2) -> None: ...


geomfill_GetCircle = geomfill.GetCircle
geomfill_GetCircle = geomfill.GetCircle
geomfill_GetCircle = geomfill.GetCircle
geomfill_GetMinimalWeights = geomfill.GetMinimalWeights
geomfill_GetShape = geomfill.GetShape
geomfill_GetTolerance = geomfill.GetTolerance
geomfill_Knots = geomfill.Knots
geomfill_Mults = geomfill.Mults
geomfill_Surface = geomfill.Surface
