/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "rauc-installer-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface de.pengutronix.rauc.Installer
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:RInstaller
 * @title: RInstaller
 * @short_description: Generated C code for the de.pengutronix.rauc.Installer D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-de-pengutronix-rauc-Installer.top_of_page">de.pengutronix.rauc.Installer</link> D-Bus interface in C.
 */

/* ---- Introspection data for de.pengutronix.rauc.Installer ---- */

static const _ExtendedGDBusArgInfo _r_installer_method_info_install_IN_ARG_source =
{
  {
    -1,
    (gchar *) "source",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_install_IN_ARG_pointers[] =
{
  &_r_installer_method_info_install_IN_ARG_source.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _r_installer_method_info_install =
{
  {
    -1,
    (gchar *) "Install",
    (GDBusArgInfo **) &_r_installer_method_info_install_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-install",
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_install_bundle_IN_ARG_source =
{
  {
    -1,
    (gchar *) "source",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_install_bundle_IN_ARG_args =
{
  {
    -1,
    (gchar *) "args",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_install_bundle_IN_ARG_pointers[] =
{
  &_r_installer_method_info_install_bundle_IN_ARG_source.parent_struct,
  &_r_installer_method_info_install_bundle_IN_ARG_args.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _r_installer_method_install_bundle_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _r_installer_method_install_bundle_annotation_info_pointers[] =
{
  &_r_installer_method_install_bundle_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _r_installer_method_info_install_bundle =
{
  {
    -1,
    (gchar *) "InstallBundle",
    (GDBusArgInfo **) &_r_installer_method_info_install_bundle_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_r_installer_method_install_bundle_annotation_info_pointers
  },
  "handle-install-bundle",
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_info_IN_ARG_bundle =
{
  {
    -1,
    (gchar *) "bundle",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_info_IN_ARG_pointers[] =
{
  &_r_installer_method_info_info_IN_ARG_bundle.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_info_OUT_ARG_compatible =
{
  {
    -1,
    (gchar *) "compatible",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_info_OUT_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_info_OUT_ARG_pointers[] =
{
  &_r_installer_method_info_info_OUT_ARG_compatible.parent_struct,
  &_r_installer_method_info_info_OUT_ARG_version.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _r_installer_method_info_info =
{
  {
    -1,
    (gchar *) "Info",
    (GDBusArgInfo **) &_r_installer_method_info_info_IN_ARG_pointers,
    (GDBusArgInfo **) &_r_installer_method_info_info_OUT_ARG_pointers,
    NULL
  },
  "handle-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_mark_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_mark_IN_ARG_slot_identifier =
{
  {
    -1,
    (gchar *) "slot_identifier",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_mark_IN_ARG_pointers[] =
{
  &_r_installer_method_info_mark_IN_ARG_state.parent_struct,
  &_r_installer_method_info_mark_IN_ARG_slot_identifier.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_mark_OUT_ARG_slot_name =
{
  {
    -1,
    (gchar *) "slot_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_mark_OUT_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_mark_OUT_ARG_pointers[] =
{
  &_r_installer_method_info_mark_OUT_ARG_slot_name.parent_struct,
  &_r_installer_method_info_mark_OUT_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _r_installer_method_info_mark =
{
  {
    -1,
    (gchar *) "Mark",
    (GDBusArgInfo **) &_r_installer_method_info_mark_IN_ARG_pointers,
    (GDBusArgInfo **) &_r_installer_method_info_mark_OUT_ARG_pointers,
    NULL
  },
  "handle-mark",
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_get_slot_status_OUT_ARG_slot_status_array =
{
  {
    -1,
    (gchar *) "slot_status_array",
    (gchar *) "a(sa{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_get_slot_status_OUT_ARG_pointers[] =
{
  &_r_installer_method_info_get_slot_status_OUT_ARG_slot_status_array.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _r_installer_method_get_slot_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out0",
  (gchar *) "RaucSlotStatusArray",
  NULL
};

static const GDBusAnnotationInfo * const _r_installer_method_get_slot_status_annotation_info_pointers[] =
{
  &_r_installer_method_get_slot_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _r_installer_method_info_get_slot_status =
{
  {
    -1,
    (gchar *) "GetSlotStatus",
    NULL,
    (GDBusArgInfo **) &_r_installer_method_info_get_slot_status_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_r_installer_method_get_slot_status_annotation_info_pointers
  },
  "handle-get-slot-status",
  FALSE
};

static const _ExtendedGDBusArgInfo _r_installer_method_info_get_primary_OUT_ARG_primary =
{
  {
    -1,
    (gchar *) "primary",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_method_info_get_primary_OUT_ARG_pointers[] =
{
  &_r_installer_method_info_get_primary_OUT_ARG_primary.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _r_installer_method_info_get_primary =
{
  {
    -1,
    (gchar *) "GetPrimary",
    NULL,
    (GDBusArgInfo **) &_r_installer_method_info_get_primary_OUT_ARG_pointers,
    NULL
  },
  "handle-get-primary",
  FALSE
};

static const GDBusMethodInfo * const _r_installer_method_info_pointers[] =
{
  &_r_installer_method_info_install.parent_struct,
  &_r_installer_method_info_install_bundle.parent_struct,
  &_r_installer_method_info_info.parent_struct,
  &_r_installer_method_info_mark.parent_struct,
  &_r_installer_method_info_get_slot_status.parent_struct,
  &_r_installer_method_info_get_primary.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _r_installer_signal_info_completed_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _r_installer_signal_info_completed_ARG_pointers[] =
{
  &_r_installer_signal_info_completed_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _r_installer_signal_info_completed =
{
  {
    -1,
    (gchar *) "Completed",
    (GDBusArgInfo **) &_r_installer_signal_info_completed_ARG_pointers,
    NULL
  },
  "completed"
};

static const GDBusSignalInfo * const _r_installer_signal_info_pointers[] =
{
  &_r_installer_signal_info_completed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _r_installer_property_info_operation =
{
  {
    -1,
    (gchar *) "Operation",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "operation",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _r_installer_property_info_last_error =
{
  {
    -1,
    (gchar *) "LastError",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "last-error",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _r_installer_property_progress_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName",
  (gchar *) "RaucProgress",
  NULL
};

static const GDBusAnnotationInfo * const _r_installer_property_progress_annotation_info_pointers[] =
{
  &_r_installer_property_progress_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _r_installer_property_info_progress =
{
  {
    -1,
    (gchar *) "Progress",
    (gchar *) "(isi)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_r_installer_property_progress_annotation_info_pointers
  },
  "progress",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _r_installer_property_info_compatible =
{
  {
    -1,
    (gchar *) "Compatible",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "compatible",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _r_installer_property_info_variant =
{
  {
    -1,
    (gchar *) "Variant",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "variant",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _r_installer_property_info_boot_slot =
{
  {
    -1,
    (gchar *) "BootSlot",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "boot-slot",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _r_installer_property_info_pointers[] =
{
  &_r_installer_property_info_operation.parent_struct,
  &_r_installer_property_info_last_error.parent_struct,
  &_r_installer_property_info_progress.parent_struct,
  &_r_installer_property_info_compatible.parent_struct,
  &_r_installer_property_info_variant.parent_struct,
  &_r_installer_property_info_boot_slot.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _r_installer_interface_info =
{
  {
    -1,
    (gchar *) "de.pengutronix.rauc.Installer",
    (GDBusMethodInfo **) &_r_installer_method_info_pointers,
    (GDBusSignalInfo **) &_r_installer_signal_info_pointers,
    (GDBusPropertyInfo **) &_r_installer_property_info_pointers,
    NULL
  },
  "installer",
};


/**
 * r_installer_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-de-pengutronix-rauc-Installer.top_of_page">de.pengutronix.rauc.Installer</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
r_installer_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_r_installer_interface_info.parent_struct;
}

/**
 * r_installer_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #RInstaller interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
r_installer_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "operation");
  g_object_class_override_property (klass, property_id_begin++, "last-error");
  g_object_class_override_property (klass, property_id_begin++, "progress");
  g_object_class_override_property (klass, property_id_begin++, "compatible");
  g_object_class_override_property (klass, property_id_begin++, "variant");
  g_object_class_override_property (klass, property_id_begin++, "boot-slot");
  return property_id_begin - 1;
}



/**
 * RInstaller:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-de-pengutronix-rauc-Installer.top_of_page">de.pengutronix.rauc.Installer</link>.
 */

/**
 * RInstallerIface:
 * @parent_iface: The parent interface.
 * @handle_get_primary: Handler for the #RInstaller::handle-get-primary signal.
 * @handle_get_slot_status: Handler for the #RInstaller::handle-get-slot-status signal.
 * @handle_info: Handler for the #RInstaller::handle-info signal.
 * @handle_install: Handler for the #RInstaller::handle-install signal.
 * @handle_install_bundle: Handler for the #RInstaller::handle-install-bundle signal.
 * @handle_mark: Handler for the #RInstaller::handle-mark signal.
 * @get_boot_slot: Getter for the #RInstaller:boot-slot property.
 * @get_compatible: Getter for the #RInstaller:compatible property.
 * @get_last_error: Getter for the #RInstaller:last-error property.
 * @get_operation: Getter for the #RInstaller:operation property.
 * @get_progress: Getter for the #RInstaller:progress property.
 * @get_variant: Getter for the #RInstaller:variant property.
 * @completed: Handler for the #RInstaller::completed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-de-pengutronix-rauc-Installer.top_of_page">de.pengutronix.rauc.Installer</link>.
 */

typedef RInstallerIface RInstallerInterface;
G_DEFINE_INTERFACE (RInstaller, r_installer, G_TYPE_OBJECT)

static void
r_installer_default_init (RInstallerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * RInstaller::handle-install:
   * @object: A #RInstaller.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_source: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Install">Install()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call r_installer_complete_install() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-install",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RInstallerIface, handle_install),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * RInstaller::handle-install-bundle:
   * @object: A #RInstaller.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_source: Argument passed by remote caller.
   * @arg_args: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.InstallBundle">InstallBundle()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call r_installer_complete_install_bundle() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-install-bundle",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RInstallerIface, handle_install_bundle),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * RInstaller::handle-info:
   * @object: A #RInstaller.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_bundle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Info">Info()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call r_installer_complete_info() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RInstallerIface, handle_info),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * RInstaller::handle-mark:
   * @object: A #RInstaller.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_state: Argument passed by remote caller.
   * @arg_slot_identifier: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Mark">Mark()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call r_installer_complete_mark() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mark",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RInstallerIface, handle_mark),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * RInstaller::handle-get-slot-status:
   * @object: A #RInstaller.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetSlotStatus">GetSlotStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call r_installer_complete_get_slot_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-slot-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RInstallerIface, handle_get_slot_status),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * RInstaller::handle-get-primary:
   * @object: A #RInstaller.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetPrimary">GetPrimary()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call r_installer_complete_get_primary() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-primary",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RInstallerIface, handle_get_primary),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * RInstaller::completed:
   * @object: A #RInstaller.
   * @arg_result: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-de-pengutronix-rauc-Installer.Completed">"Completed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("completed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RInstallerIface, completed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_INT);

  /* GObject properties for D-Bus properties: */
  /**
   * RInstaller:operation:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Operation">"Operation"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("operation", "Operation", "Operation", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RInstaller:last-error:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-de-pengutronix-rauc-Installer.LastError">"LastError"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("last-error", "LastError", "LastError", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RInstaller:progress:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Progress">"Progress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("progress", "Progress", "Progress", G_VARIANT_TYPE ("(isi)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RInstaller:compatible:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Compatible">"Compatible"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("compatible", "Compatible", "Compatible", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RInstaller:variant:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Variant">"Variant"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("variant", "Variant", "Variant", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RInstaller:boot-slot:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-de-pengutronix-rauc-Installer.BootSlot">"BootSlot"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("boot-slot", "BootSlot", "BootSlot", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * r_installer_get_operation: (skip)
 * @object: A #RInstaller.
 *
 * Gets the value of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Operation">"Operation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use r_installer_dup_operation() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
r_installer_get_operation (RInstaller *object)
{
  return R_INSTALLER_GET_IFACE (object)->get_operation (object);
}

/**
 * r_installer_dup_operation: (skip)
 * @object: A #RInstaller.
 *
 * Gets a copy of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Operation">"Operation"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
r_installer_dup_operation (RInstaller *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "operation", &value, NULL);
  return value;
}

/**
 * r_installer_set_operation: (skip)
 * @object: A #RInstaller.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Operation">"Operation"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
r_installer_set_operation (RInstaller *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "operation", value, NULL);
}

/**
 * r_installer_get_last_error: (skip)
 * @object: A #RInstaller.
 *
 * Gets the value of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.LastError">"LastError"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use r_installer_dup_last_error() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
r_installer_get_last_error (RInstaller *object)
{
  return R_INSTALLER_GET_IFACE (object)->get_last_error (object);
}

/**
 * r_installer_dup_last_error: (skip)
 * @object: A #RInstaller.
 *
 * Gets a copy of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.LastError">"LastError"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
r_installer_dup_last_error (RInstaller *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "last-error", &value, NULL);
  return value;
}

/**
 * r_installer_set_last_error: (skip)
 * @object: A #RInstaller.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.LastError">"LastError"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
r_installer_set_last_error (RInstaller *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "last-error", value, NULL);
}

/**
 * r_installer_get_progress: (skip)
 * @object: A #RInstaller.
 *
 * Gets the value of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Progress">"Progress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use r_installer_dup_progress() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
r_installer_get_progress (RInstaller *object)
{
  return R_INSTALLER_GET_IFACE (object)->get_progress (object);
}

/**
 * r_installer_dup_progress: (skip)
 * @object: A #RInstaller.
 *
 * Gets a copy of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Progress">"Progress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
r_installer_dup_progress (RInstaller *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "progress", &value, NULL);
  return value;
}

/**
 * r_installer_set_progress: (skip)
 * @object: A #RInstaller.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Progress">"Progress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
r_installer_set_progress (RInstaller *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "progress", value, NULL);
}

/**
 * r_installer_get_compatible: (skip)
 * @object: A #RInstaller.
 *
 * Gets the value of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Compatible">"Compatible"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use r_installer_dup_compatible() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
r_installer_get_compatible (RInstaller *object)
{
  return R_INSTALLER_GET_IFACE (object)->get_compatible (object);
}

/**
 * r_installer_dup_compatible: (skip)
 * @object: A #RInstaller.
 *
 * Gets a copy of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Compatible">"Compatible"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
r_installer_dup_compatible (RInstaller *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "compatible", &value, NULL);
  return value;
}

/**
 * r_installer_set_compatible: (skip)
 * @object: A #RInstaller.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Compatible">"Compatible"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
r_installer_set_compatible (RInstaller *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "compatible", value, NULL);
}

/**
 * r_installer_get_variant: (skip)
 * @object: A #RInstaller.
 *
 * Gets the value of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Variant">"Variant"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use r_installer_dup_variant() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
r_installer_get_variant (RInstaller *object)
{
  return R_INSTALLER_GET_IFACE (object)->get_variant (object);
}

/**
 * r_installer_dup_variant: (skip)
 * @object: A #RInstaller.
 *
 * Gets a copy of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Variant">"Variant"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
r_installer_dup_variant (RInstaller *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "variant", &value, NULL);
  return value;
}

/**
 * r_installer_set_variant: (skip)
 * @object: A #RInstaller.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.Variant">"Variant"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
r_installer_set_variant (RInstaller *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "variant", value, NULL);
}

/**
 * r_installer_get_boot_slot: (skip)
 * @object: A #RInstaller.
 *
 * Gets the value of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.BootSlot">"BootSlot"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use r_installer_dup_boot_slot() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
r_installer_get_boot_slot (RInstaller *object)
{
  return R_INSTALLER_GET_IFACE (object)->get_boot_slot (object);
}

/**
 * r_installer_dup_boot_slot: (skip)
 * @object: A #RInstaller.
 *
 * Gets a copy of the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.BootSlot">"BootSlot"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
r_installer_dup_boot_slot (RInstaller *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "boot-slot", &value, NULL);
  return value;
}

/**
 * r_installer_set_boot_slot: (skip)
 * @object: A #RInstaller.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-de-pengutronix-rauc-Installer.BootSlot">"BootSlot"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
r_installer_set_boot_slot (RInstaller *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "boot-slot", value, NULL);
}

/**
 * r_installer_emit_completed:
 * @object: A #RInstaller.
 * @arg_result: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-de-pengutronix-rauc-Installer.Completed">"Completed"</link> D-Bus signal.
 */
void
r_installer_emit_completed (
    RInstaller *object,
    gint arg_result)
{
  g_signal_emit_by_name (object, "completed", arg_result);
}

/**
 * r_installer_call_install:
 * @proxy: A #RInstallerProxy.
 * @arg_source: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Install">Install()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_call_install_finish() to get the result of the operation.
 *
 * See r_installer_call_install_sync() for the synchronous, blocking version of this method.
 */
void
r_installer_call_install (
    RInstaller *proxy,
    const gchar *arg_source,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(s)",
                   arg_source),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * r_installer_call_install_finish:
 * @proxy: A #RInstallerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_call_install().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with r_installer_call_install().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_install_finish (
    RInstaller *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_install_sync:
 * @proxy: A #RInstallerProxy.
 * @arg_source: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Install">Install()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See r_installer_call_install() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_install_sync (
    RInstaller *proxy,
    const gchar *arg_source,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(s)",
                   arg_source),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_install_bundle:
 * @proxy: A #RInstallerProxy.
 * @arg_source: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.InstallBundle">InstallBundle()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_call_install_bundle_finish() to get the result of the operation.
 *
 * See r_installer_call_install_bundle_sync() for the synchronous, blocking version of this method.
 */
void
r_installer_call_install_bundle (
    RInstaller *proxy,
    const gchar *arg_source,
    GVariant *arg_args,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InstallBundle",
    g_variant_new ("(s@a{sv})",
                   arg_source,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * r_installer_call_install_bundle_finish:
 * @proxy: A #RInstallerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_call_install_bundle().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with r_installer_call_install_bundle().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_install_bundle_finish (
    RInstaller *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_install_bundle_sync:
 * @proxy: A #RInstallerProxy.
 * @arg_source: Argument to pass with the method invocation.
 * @arg_args: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.InstallBundle">InstallBundle()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See r_installer_call_install_bundle() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_install_bundle_sync (
    RInstaller *proxy,
    const gchar *arg_source,
    GVariant *arg_args,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InstallBundle",
    g_variant_new ("(s@a{sv})",
                   arg_source,
                   arg_args),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_info:
 * @proxy: A #RInstallerProxy.
 * @arg_bundle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Info">Info()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_call_info_finish() to get the result of the operation.
 *
 * See r_installer_call_info_sync() for the synchronous, blocking version of this method.
 */
void
r_installer_call_info (
    RInstaller *proxy,
    const gchar *arg_bundle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(s)",
                   arg_bundle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * r_installer_call_info_finish:
 * @proxy: A #RInstallerProxy.
 * @out_compatible: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_call_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with r_installer_call_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_info_finish (
    RInstaller *proxy,
    gchar **out_compatible,
    gchar **out_version,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_compatible,
                 out_version);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_info_sync:
 * @proxy: A #RInstallerProxy.
 * @arg_bundle: Argument to pass with the method invocation.
 * @out_compatible: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Info">Info()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See r_installer_call_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_info_sync (
    RInstaller *proxy,
    const gchar *arg_bundle,
    gchar **out_compatible,
    gchar **out_version,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(s)",
                   arg_bundle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_compatible,
                 out_version);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_mark:
 * @proxy: A #RInstallerProxy.
 * @arg_state: Argument to pass with the method invocation.
 * @arg_slot_identifier: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Mark">Mark()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_call_mark_finish() to get the result of the operation.
 *
 * See r_installer_call_mark_sync() for the synchronous, blocking version of this method.
 */
void
r_installer_call_mark (
    RInstaller *proxy,
    const gchar *arg_state,
    const gchar *arg_slot_identifier,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Mark",
    g_variant_new ("(ss)",
                   arg_state,
                   arg_slot_identifier),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * r_installer_call_mark_finish:
 * @proxy: A #RInstallerProxy.
 * @out_slot_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_message: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_call_mark().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with r_installer_call_mark().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_mark_finish (
    RInstaller *proxy,
    gchar **out_slot_name,
    gchar **out_message,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_slot_name,
                 out_message);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_mark_sync:
 * @proxy: A #RInstallerProxy.
 * @arg_state: Argument to pass with the method invocation.
 * @arg_slot_identifier: Argument to pass with the method invocation.
 * @out_slot_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_message: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Mark">Mark()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See r_installer_call_mark() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_mark_sync (
    RInstaller *proxy,
    const gchar *arg_state,
    const gchar *arg_slot_identifier,
    gchar **out_slot_name,
    gchar **out_message,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Mark",
    g_variant_new ("(ss)",
                   arg_state,
                   arg_slot_identifier),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_slot_name,
                 out_message);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_get_slot_status:
 * @proxy: A #RInstallerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetSlotStatus">GetSlotStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_call_get_slot_status_finish() to get the result of the operation.
 *
 * See r_installer_call_get_slot_status_sync() for the synchronous, blocking version of this method.
 */
void
r_installer_call_get_slot_status (
    RInstaller *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSlotStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * r_installer_call_get_slot_status_finish:
 * @proxy: A #RInstallerProxy.
 * @out_slot_status_array: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_call_get_slot_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with r_installer_call_get_slot_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_get_slot_status_finish (
    RInstaller *proxy,
    GVariant **out_slot_status_array,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sa{sv}))",
                 out_slot_status_array);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_get_slot_status_sync:
 * @proxy: A #RInstallerProxy.
 * @out_slot_status_array: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetSlotStatus">GetSlotStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See r_installer_call_get_slot_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_get_slot_status_sync (
    RInstaller *proxy,
    GVariant **out_slot_status_array,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSlotStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sa{sv}))",
                 out_slot_status_array);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_get_primary:
 * @proxy: A #RInstallerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetPrimary">GetPrimary()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_call_get_primary_finish() to get the result of the operation.
 *
 * See r_installer_call_get_primary_sync() for the synchronous, blocking version of this method.
 */
void
r_installer_call_get_primary (
    RInstaller *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPrimary",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * r_installer_call_get_primary_finish:
 * @proxy: A #RInstallerProxy.
 * @out_primary: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_call_get_primary().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with r_installer_call_get_primary().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_get_primary_finish (
    RInstaller *proxy,
    gchar **out_primary,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_primary);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_call_get_primary_sync:
 * @proxy: A #RInstallerProxy.
 * @out_primary: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetPrimary">GetPrimary()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See r_installer_call_get_primary() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
r_installer_call_get_primary_sync (
    RInstaller *proxy,
    gchar **out_primary,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPrimary",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_primary);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * r_installer_complete_install:
 * @object: A #RInstaller.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Install">Install()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
r_installer_complete_install (
    RInstaller *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * r_installer_complete_install_bundle:
 * @object: A #RInstaller.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.InstallBundle">InstallBundle()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
r_installer_complete_install_bundle (
    RInstaller *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * r_installer_complete_info:
 * @object: A #RInstaller.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @compatible: Parameter to return.
 * @version: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Info">Info()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
r_installer_complete_info (
    RInstaller *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *compatible,
    const gchar *version)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ss)",
                   compatible,
                   version));
}

/**
 * r_installer_complete_mark:
 * @object: A #RInstaller.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @slot_name: Parameter to return.
 * @message: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.Mark">Mark()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
r_installer_complete_mark (
    RInstaller *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *slot_name,
    const gchar *message)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ss)",
                   slot_name,
                   message));
}

/**
 * r_installer_complete_get_slot_status:
 * @object: A #RInstaller.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @slot_status_array: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetSlotStatus">GetSlotStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
r_installer_complete_get_slot_status (
    RInstaller *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *slot_status_array)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sa{sv}))",
                   slot_status_array));
}

/**
 * r_installer_complete_get_primary:
 * @object: A #RInstaller.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @primary: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-de-pengutronix-rauc-Installer.GetPrimary">GetPrimary()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
r_installer_complete_get_primary (
    RInstaller *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *primary)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   primary));
}

/* ------------------------------------------------------------------------ */

/**
 * RInstallerProxy:
 *
 * The #RInstallerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RInstallerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RInstallerProxy.
 */

struct _RInstallerProxyPrivate
{
  GData *qdata;
};

static void r_installer_proxy_iface_init (RInstallerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RInstallerProxy, r_installer_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (RInstallerProxy)
                         G_IMPLEMENT_INTERFACE (R_TYPE_INSTALLER, r_installer_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RInstallerProxy, r_installer_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (R_TYPE_INSTALLER, r_installer_proxy_iface_init))

#endif
static void
r_installer_proxy_finalize (GObject *object)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (r_installer_proxy_parent_class)->finalize (object);
}

static void
r_installer_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  info = (const _ExtendedGDBusPropertyInfo *) _r_installer_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
r_installer_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface de.pengutronix.rauc.Installer: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
r_installer_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  info = (const _ExtendedGDBusPropertyInfo *) _r_installer_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "de.pengutronix.rauc.Installer", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) r_installer_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
r_installer_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_r_installer_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], R_TYPE_INSTALLER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, R_TYPE_INSTALLER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
r_installer_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_r_installer_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_r_installer_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
r_installer_proxy_get_operation (RInstaller *object)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Operation");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
r_installer_proxy_get_last_error (RInstaller *object)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LastError");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
r_installer_proxy_get_progress (RInstaller *object)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Progress");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
r_installer_proxy_get_compatible (RInstaller *object)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Compatible");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
r_installer_proxy_get_variant (RInstaller *object)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Variant");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
r_installer_proxy_get_boot_slot (RInstaller *object)
{
  RInstallerProxy *proxy = R_INSTALLER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "BootSlot");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
r_installer_proxy_init (RInstallerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = r_installer_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, R_TYPE_INSTALLER_PROXY, RInstallerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), r_installer_interface_info ());
}

static void
r_installer_proxy_class_init (RInstallerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = r_installer_proxy_finalize;
  gobject_class->get_property = r_installer_proxy_get_property;
  gobject_class->set_property = r_installer_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = r_installer_proxy_g_signal;
  proxy_class->g_properties_changed = r_installer_proxy_g_properties_changed;

  r_installer_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RInstallerProxyPrivate));
#endif
}

static void
r_installer_proxy_iface_init (RInstallerIface *iface)
{
  iface->get_operation = r_installer_proxy_get_operation;
  iface->get_last_error = r_installer_proxy_get_last_error;
  iface->get_progress = r_installer_proxy_get_progress;
  iface->get_compatible = r_installer_proxy_get_compatible;
  iface->get_variant = r_installer_proxy_get_variant;
  iface->get_boot_slot = r_installer_proxy_get_boot_slot;
}

/**
 * r_installer_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-de-pengutronix-rauc-Installer.top_of_page">de.pengutronix.rauc.Installer</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_proxy_new_finish() to get the result of the operation.
 *
 * See r_installer_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
r_installer_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (R_TYPE_INSTALLER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "de.pengutronix.rauc.Installer", NULL);
}

/**
 * r_installer_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with r_installer_proxy_new().
 *
 * Returns: (transfer full) (type RInstallerProxy): The constructed proxy object or %NULL if @error is set.
 */
RInstaller *
r_installer_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return R_INSTALLER (ret);
  else
    return NULL;
}

/**
 * r_installer_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-de-pengutronix-rauc-Installer.top_of_page">de.pengutronix.rauc.Installer</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See r_installer_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RInstallerProxy): The constructed proxy object or %NULL if @error is set.
 */
RInstaller *
r_installer_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (R_TYPE_INSTALLER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "de.pengutronix.rauc.Installer", NULL);
  if (ret != NULL)
    return R_INSTALLER (ret);
  else
    return NULL;
}


/**
 * r_installer_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like r_installer_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call r_installer_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See r_installer_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
r_installer_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (R_TYPE_INSTALLER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "de.pengutronix.rauc.Installer", NULL);
}

/**
 * r_installer_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to r_installer_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with r_installer_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type RInstallerProxy): The constructed proxy object or %NULL if @error is set.
 */
RInstaller *
r_installer_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return R_INSTALLER (ret);
  else
    return NULL;
}

/**
 * r_installer_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like r_installer_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See r_installer_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RInstallerProxy): The constructed proxy object or %NULL if @error is set.
 */
RInstaller *
r_installer_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (R_TYPE_INSTALLER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "de.pengutronix.rauc.Installer", NULL);
  if (ret != NULL)
    return R_INSTALLER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * RInstallerSkeleton:
 *
 * The #RInstallerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RInstallerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RInstallerSkeleton.
 */

struct _RInstallerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_r_installer_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], R_TYPE_INSTALLER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, R_TYPE_INSTALLER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_r_installer_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_r_installer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_r_installer_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_r_installer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _r_installer_skeleton_vtable =
{
  _r_installer_skeleton_handle_method_call,
  _r_installer_skeleton_handle_get_property,
  _r_installer_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
r_installer_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return r_installer_interface_info ();
}

static GDBusInterfaceVTable *
r_installer_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_r_installer_skeleton_vtable;
}

static GVariant *
r_installer_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_r_installer_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _r_installer_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _r_installer_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _r_installer_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "de.pengutronix.rauc.Installer", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _r_installer_emit_changed (gpointer user_data);

static void
r_installer_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _r_installer_emit_changed (skeleton);
}

static void
_r_installer_on_signal_completed (
    RInstaller *object,
    gint arg_result)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_result));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "de.pengutronix.rauc.Installer", "Completed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void r_installer_skeleton_iface_init (RInstallerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RInstallerSkeleton, r_installer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (RInstallerSkeleton)
                         G_IMPLEMENT_INTERFACE (R_TYPE_INSTALLER, r_installer_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RInstallerSkeleton, r_installer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (R_TYPE_INSTALLER, r_installer_skeleton_iface_init))

#endif
static void
r_installer_skeleton_finalize (GObject *object)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  guint n;
  for (n = 0; n < 6; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (r_installer_skeleton_parent_class)->finalize (object);
}

static void
r_installer_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_r_installer_emit_changed (gpointer user_data)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "de.pengutronix.rauc.Installer",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_r_installer_schedule_emit_changed (RInstallerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
r_installer_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _r_installer_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _r_installer_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
r_installer_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  info = (const _ExtendedGDBusPropertyInfo *) _r_installer_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _r_installer_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
r_installer_skeleton_init (RInstallerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = r_installer_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, R_TYPE_INSTALLER_SKELETON, RInstallerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 6);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
}

static const gchar *
r_installer_skeleton_get_operation (RInstaller *object)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
r_installer_skeleton_get_last_error (RInstaller *object)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
r_installer_skeleton_get_progress (RInstaller *object)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
r_installer_skeleton_get_compatible (RInstaller *object)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
r_installer_skeleton_get_variant (RInstaller *object)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
r_installer_skeleton_get_boot_slot (RInstaller *object)
{
  RInstallerSkeleton *skeleton = R_INSTALLER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
r_installer_skeleton_class_init (RInstallerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = r_installer_skeleton_finalize;
  gobject_class->get_property = r_installer_skeleton_get_property;
  gobject_class->set_property = r_installer_skeleton_set_property;
  gobject_class->notify       = r_installer_skeleton_notify;


  r_installer_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = r_installer_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = r_installer_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = r_installer_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = r_installer_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RInstallerSkeletonPrivate));
#endif
}

static void
r_installer_skeleton_iface_init (RInstallerIface *iface)
{
  iface->completed = _r_installer_on_signal_completed;
  iface->get_operation = r_installer_skeleton_get_operation;
  iface->get_last_error = r_installer_skeleton_get_last_error;
  iface->get_progress = r_installer_skeleton_get_progress;
  iface->get_compatible = r_installer_skeleton_get_compatible;
  iface->get_variant = r_installer_skeleton_get_variant;
  iface->get_boot_slot = r_installer_skeleton_get_boot_slot;
}

/**
 * r_installer_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-de-pengutronix-rauc-Installer.top_of_page">de.pengutronix.rauc.Installer</link>.
 *
 * Returns: (transfer full) (type RInstallerSkeleton): The skeleton object.
 */
RInstaller *
r_installer_skeleton_new (void)
{
  return R_INSTALLER (g_object_new (R_TYPE_INSTALLER_SKELETON, NULL));
}

