/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "./common/flatpak-dbus-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Flatpak.Authenticator
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FlatpakAuthenticator
 * @title: FlatpakAuthenticator
 * @short_description: Generated C code for the org.freedesktop.Flatpak.Authenticator D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Flatpak-Authenticator.top_of_page">org.freedesktop.Flatpak.Authenticator</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Flatpak.Authenticator ---- */

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_handle_token =
{
  {
    -1,
    (gchar *) "handle_token",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_authenticator_options =
{
  {
    -1,
    (gchar *) "authenticator_options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_remote_uri =
{
  {
    -1,
    (gchar *) "remote_uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_refs =
{
  {
    -1,
    (gchar *) "refs",
    (gchar *) "a(ssia{sv})",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_pointers[] =
{
  &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_handle_token.parent_struct,
  &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_authenticator_options.parent_struct,
  &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_remote.parent_struct,
  &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_remote_uri.parent_struct,
  &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_refs.parent_struct,
  &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_options.parent_struct,
  &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_parent_window.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_method_info_request_ref_tokens_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_authenticator_method_info_request_ref_tokens_OUT_ARG_pointers[] =
{
  &_flatpak_authenticator_method_info_request_ref_tokens_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_authenticator_method_info_request_ref_tokens =
{
  {
    -1,
    (gchar *) "RequestRefTokens",
    (GDBusArgInfo **) &_flatpak_authenticator_method_info_request_ref_tokens_IN_ARG_pointers,
    (GDBusArgInfo **) &_flatpak_authenticator_method_info_request_ref_tokens_OUT_ARG_pointers,
    NULL
  },
  "handle-request-ref-tokens",
  FALSE
};

static const GDBusMethodInfo * const _flatpak_authenticator_method_info_pointers[] =
{
  &_flatpak_authenticator_method_info_request_ref_tokens.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _flatpak_authenticator_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _flatpak_authenticator_property_info_pointers[] =
{
  &_flatpak_authenticator_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _flatpak_authenticator_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Flatpak.Authenticator",
    (GDBusMethodInfo **) &_flatpak_authenticator_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_flatpak_authenticator_property_info_pointers,
    NULL
  },
  "authenticator",
};


/**
 * flatpak_authenticator_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Flatpak-Authenticator.top_of_page">org.freedesktop.Flatpak.Authenticator</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
flatpak_authenticator_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_flatpak_authenticator_interface_info.parent_struct;
}

/**
 * flatpak_authenticator_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FlatpakAuthenticator interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
flatpak_authenticator_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * FlatpakAuthenticator:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Authenticator.top_of_page">org.freedesktop.Flatpak.Authenticator</link>.
 */

/**
 * FlatpakAuthenticatorIface:
 * @parent_iface: The parent interface.
 * @handle_request_ref_tokens: Handler for the #FlatpakAuthenticator::handle-request-ref-tokens signal.
 * @get_version: Getter for the #FlatpakAuthenticator:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Authenticator.top_of_page">org.freedesktop.Flatpak.Authenticator</link>.
 */

typedef FlatpakAuthenticatorIface FlatpakAuthenticatorInterface;
G_DEFINE_INTERFACE (FlatpakAuthenticator, flatpak_authenticator, G_TYPE_OBJECT)

static void
flatpak_authenticator_default_init (FlatpakAuthenticatorIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FlatpakAuthenticator::handle-request-ref-tokens:
   * @object: A #FlatpakAuthenticator.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle_token: Argument passed by remote caller.
   * @arg_authenticator_options: Argument passed by remote caller.
   * @arg_remote: Argument passed by remote caller.
   * @arg_remote_uri: Argument passed by remote caller.
   * @arg_refs: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-Authenticator.RequestRefTokens">RequestRefTokens()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_authenticator_complete_request_ref_tokens() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-ref-tokens",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakAuthenticatorIface, handle_request_ref_tokens),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * FlatpakAuthenticator:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Flatpak-Authenticator.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * flatpak_authenticator_get_version: (skip)
 * @object: A #FlatpakAuthenticator.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Flatpak-Authenticator.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
flatpak_authenticator_get_version (FlatpakAuthenticator *object)
{
  return FLATPAK_AUTHENTICATOR_GET_IFACE (object)->get_version (object);
}

/**
 * flatpak_authenticator_set_version: (skip)
 * @object: A #FlatpakAuthenticator.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Flatpak-Authenticator.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
flatpak_authenticator_set_version (FlatpakAuthenticator *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * flatpak_authenticator_call_request_ref_tokens:
 * @proxy: A #FlatpakAuthenticatorProxy.
 * @arg_handle_token: Argument to pass with the method invocation.
 * @arg_authenticator_options: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_remote_uri: Argument to pass with the method invocation.
 * @arg_refs: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-Authenticator.RequestRefTokens">RequestRefTokens()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_authenticator_call_request_ref_tokens_finish() to get the result of the operation.
 *
 * See flatpak_authenticator_call_request_ref_tokens_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_authenticator_call_request_ref_tokens (
    FlatpakAuthenticator *proxy,
    const gchar *arg_handle_token,
    GVariant *arg_authenticator_options,
    const gchar *arg_remote,
    const gchar *arg_remote_uri,
    GVariant *arg_refs,
    GVariant *arg_options,
    const gchar *arg_parent_window,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestRefTokens",
    g_variant_new ("(s@a{sv}ss@a(ssia{sv})@a{sv}s)",
                   arg_handle_token,
                   arg_authenticator_options,
                   arg_remote,
                   arg_remote_uri,
                   arg_refs,
                   arg_options,
                   arg_parent_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_authenticator_call_request_ref_tokens_finish:
 * @proxy: A #FlatpakAuthenticatorProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_authenticator_call_request_ref_tokens().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_authenticator_call_request_ref_tokens().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_authenticator_call_request_ref_tokens_finish (
    FlatpakAuthenticator *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_authenticator_call_request_ref_tokens_sync:
 * @proxy: A #FlatpakAuthenticatorProxy.
 * @arg_handle_token: Argument to pass with the method invocation.
 * @arg_authenticator_options: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_remote_uri: Argument to pass with the method invocation.
 * @arg_refs: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-Authenticator.RequestRefTokens">RequestRefTokens()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_authenticator_call_request_ref_tokens() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_authenticator_call_request_ref_tokens_sync (
    FlatpakAuthenticator *proxy,
    const gchar *arg_handle_token,
    GVariant *arg_authenticator_options,
    const gchar *arg_remote,
    const gchar *arg_remote_uri,
    GVariant *arg_refs,
    GVariant *arg_options,
    const gchar *arg_parent_window,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestRefTokens",
    g_variant_new ("(s@a{sv}ss@a(ssia{sv})@a{sv}s)",
                   arg_handle_token,
                   arg_authenticator_options,
                   arg_remote,
                   arg_remote_uri,
                   arg_refs,
                   arg_options,
                   arg_parent_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_authenticator_complete_request_ref_tokens:
 * @object: A #FlatpakAuthenticator.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-Authenticator.RequestRefTokens">RequestRefTokens()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_authenticator_complete_request_ref_tokens (
    FlatpakAuthenticator *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/* ------------------------------------------------------------------------ */

/**
 * FlatpakAuthenticatorProxy:
 *
 * The #FlatpakAuthenticatorProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakAuthenticatorProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakAuthenticatorProxy.
 */

struct _FlatpakAuthenticatorProxyPrivate
{
  GData *qdata;
};

static void flatpak_authenticator_proxy_iface_init (FlatpakAuthenticatorIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorProxy, flatpak_authenticator_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FlatpakAuthenticatorProxy)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR, flatpak_authenticator_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorProxy, flatpak_authenticator_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR, flatpak_authenticator_proxy_iface_init))

#endif
static void
flatpak_authenticator_proxy_finalize (GObject *object)
{
  FlatpakAuthenticatorProxy *proxy = FLATPAK_AUTHENTICATOR_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (flatpak_authenticator_proxy_parent_class)->finalize (object);
}

static void
flatpak_authenticator_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_authenticator_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
flatpak_authenticator_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Flatpak.Authenticator: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
flatpak_authenticator_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_authenticator_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Flatpak.Authenticator", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) flatpak_authenticator_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
flatpak_authenticator_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_flatpak_authenticator_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FLATPAK_TYPE_AUTHENTICATOR);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_AUTHENTICATOR);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
flatpak_authenticator_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FlatpakAuthenticatorProxy *proxy = FLATPAK_AUTHENTICATOR_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
flatpak_authenticator_proxy_get_version (FlatpakAuthenticator *object)
{
  FlatpakAuthenticatorProxy *proxy = FLATPAK_AUTHENTICATOR_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
flatpak_authenticator_proxy_init (FlatpakAuthenticatorProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = flatpak_authenticator_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FLATPAK_TYPE_AUTHENTICATOR_PROXY, FlatpakAuthenticatorProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), flatpak_authenticator_interface_info ());
}

static void
flatpak_authenticator_proxy_class_init (FlatpakAuthenticatorProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = flatpak_authenticator_proxy_finalize;
  gobject_class->get_property = flatpak_authenticator_proxy_get_property;
  gobject_class->set_property = flatpak_authenticator_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = flatpak_authenticator_proxy_g_signal;
  proxy_class->g_properties_changed = flatpak_authenticator_proxy_g_properties_changed;

  flatpak_authenticator_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakAuthenticatorProxyPrivate));
#endif
}

static void
flatpak_authenticator_proxy_iface_init (FlatpakAuthenticatorIface *iface)
{
  iface->get_version = flatpak_authenticator_proxy_get_version;
}

/**
 * flatpak_authenticator_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Authenticator.top_of_page">org.freedesktop.Flatpak.Authenticator</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_authenticator_proxy_new_finish() to get the result of the operation.
 *
 * See flatpak_authenticator_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_authenticator_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_AUTHENTICATOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Authenticator", NULL);
}

/**
 * flatpak_authenticator_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_authenticator_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_authenticator_proxy_new().
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticator *
flatpak_authenticator_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR (ret);
  else
    return NULL;
}

/**
 * flatpak_authenticator_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Authenticator.top_of_page">org.freedesktop.Flatpak.Authenticator</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_authenticator_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticator *
flatpak_authenticator_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_AUTHENTICATOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Authenticator", NULL);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR (ret);
  else
    return NULL;
}


/**
 * flatpak_authenticator_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like flatpak_authenticator_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_authenticator_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See flatpak_authenticator_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_authenticator_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_AUTHENTICATOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Authenticator", NULL);
}

/**
 * flatpak_authenticator_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_authenticator_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_authenticator_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticator *
flatpak_authenticator_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR (ret);
  else
    return NULL;
}

/**
 * flatpak_authenticator_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like flatpak_authenticator_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_authenticator_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticator *
flatpak_authenticator_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_AUTHENTICATOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Authenticator", NULL);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FlatpakAuthenticatorSkeleton:
 *
 * The #FlatpakAuthenticatorSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakAuthenticatorSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakAuthenticatorSkeleton.
 */

struct _FlatpakAuthenticatorSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_flatpak_authenticator_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FLATPAK_TYPE_AUTHENTICATOR);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_AUTHENTICATOR);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_flatpak_authenticator_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_flatpak_authenticator_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _flatpak_authenticator_skeleton_vtable =
{
  _flatpak_authenticator_skeleton_handle_method_call,
  _flatpak_authenticator_skeleton_handle_get_property,
  _flatpak_authenticator_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
flatpak_authenticator_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return flatpak_authenticator_interface_info ();
}

static GDBusInterfaceVTable *
flatpak_authenticator_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_flatpak_authenticator_skeleton_vtable;
}

static GVariant *
flatpak_authenticator_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_flatpak_authenticator_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _flatpak_authenticator_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _flatpak_authenticator_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _flatpak_authenticator_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.Authenticator", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _flatpak_authenticator_emit_changed (gpointer user_data);

static void
flatpak_authenticator_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _flatpak_authenticator_emit_changed (skeleton);
}

static void flatpak_authenticator_skeleton_iface_init (FlatpakAuthenticatorIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorSkeleton, flatpak_authenticator_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FlatpakAuthenticatorSkeleton)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR, flatpak_authenticator_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorSkeleton, flatpak_authenticator_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR, flatpak_authenticator_skeleton_iface_init))

#endif
static void
flatpak_authenticator_skeleton_finalize (GObject *object)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (flatpak_authenticator_skeleton_parent_class)->finalize (object);
}

static void
flatpak_authenticator_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_flatpak_authenticator_emit_changed (gpointer user_data)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Flatpak.Authenticator",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_flatpak_authenticator_schedule_emit_changed (FlatpakAuthenticatorSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
flatpak_authenticator_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _flatpak_authenticator_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _flatpak_authenticator_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
flatpak_authenticator_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_authenticator_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _flatpak_authenticator_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
flatpak_authenticator_skeleton_init (FlatpakAuthenticatorSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = flatpak_authenticator_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FLATPAK_TYPE_AUTHENTICATOR_SKELETON, FlatpakAuthenticatorSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
flatpak_authenticator_skeleton_get_version (FlatpakAuthenticator *object)
{
  FlatpakAuthenticatorSkeleton *skeleton = FLATPAK_AUTHENTICATOR_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
flatpak_authenticator_skeleton_class_init (FlatpakAuthenticatorSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = flatpak_authenticator_skeleton_finalize;
  gobject_class->get_property = flatpak_authenticator_skeleton_get_property;
  gobject_class->set_property = flatpak_authenticator_skeleton_set_property;
  gobject_class->notify       = flatpak_authenticator_skeleton_notify;


  flatpak_authenticator_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = flatpak_authenticator_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = flatpak_authenticator_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = flatpak_authenticator_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = flatpak_authenticator_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakAuthenticatorSkeletonPrivate));
#endif
}

static void
flatpak_authenticator_skeleton_iface_init (FlatpakAuthenticatorIface *iface)
{
  iface->get_version = flatpak_authenticator_skeleton_get_version;
}

/**
 * flatpak_authenticator_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Authenticator.top_of_page">org.freedesktop.Flatpak.Authenticator</link>.
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorSkeleton): The skeleton object.
 */
FlatpakAuthenticator *
flatpak_authenticator_skeleton_new (void)
{
  return FLATPAK_AUTHENTICATOR (g_object_new (FLATPAK_TYPE_AUTHENTICATOR_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Flatpak.AuthenticatorRequest
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FlatpakAuthenticatorRequest
 * @title: FlatpakAuthenticatorRequest
 * @short_description: Generated C code for the org.freedesktop.Flatpak.AuthenticatorRequest D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Flatpak-AuthenticatorRequest.top_of_page">org.freedesktop.Flatpak.AuthenticatorRequest</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Flatpak.AuthenticatorRequest ---- */

static const _ExtendedGDBusMethodInfo _flatpak_authenticator_request_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_user =
{
  {
    -1,
    (gchar *) "user",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_password =
{
  {
    -1,
    (gchar *) "password",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_pointers[] =
{
  &_flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_user.parent_struct,
  &_flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_password.parent_struct,
  &_flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_authenticator_request_method_info_basic_auth_reply =
{
  {
    -1,
    (gchar *) "BasicAuthReply",
    (GDBusArgInfo **) &_flatpak_authenticator_request_method_info_basic_auth_reply_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-basic-auth-reply",
  FALSE
};

static const GDBusMethodInfo * const _flatpak_authenticator_request_method_info_pointers[] =
{
  &_flatpak_authenticator_request_method_info_close.parent_struct,
  &_flatpak_authenticator_request_method_info_basic_auth_reply.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_signal_info_webflow_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_signal_info_webflow_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_authenticator_request_signal_info_webflow_ARG_pointers[] =
{
  &_flatpak_authenticator_request_signal_info_webflow_ARG_uri.parent_struct,
  &_flatpak_authenticator_request_signal_info_webflow_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _flatpak_authenticator_request_signal_info_webflow =
{
  {
    -1,
    (gchar *) "Webflow",
    (GDBusArgInfo **) &_flatpak_authenticator_request_signal_info_webflow_ARG_pointers,
    NULL
  },
  "webflow"
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_signal_info_webflow_done_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_authenticator_request_signal_info_webflow_done_ARG_pointers[] =
{
  &_flatpak_authenticator_request_signal_info_webflow_done_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _flatpak_authenticator_request_signal_info_webflow_done =
{
  {
    -1,
    (gchar *) "WebflowDone",
    (GDBusArgInfo **) &_flatpak_authenticator_request_signal_info_webflow_done_ARG_pointers,
    NULL
  },
  "webflow-done"
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_signal_info_basic_auth_ARG_realm =
{
  {
    -1,
    (gchar *) "realm",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_signal_info_basic_auth_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_authenticator_request_signal_info_basic_auth_ARG_pointers[] =
{
  &_flatpak_authenticator_request_signal_info_basic_auth_ARG_realm.parent_struct,
  &_flatpak_authenticator_request_signal_info_basic_auth_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _flatpak_authenticator_request_signal_info_basic_auth =
{
  {
    -1,
    (gchar *) "BasicAuth",
    (GDBusArgInfo **) &_flatpak_authenticator_request_signal_info_basic_auth_ARG_pointers,
    NULL
  },
  "basic-auth"
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_signal_info_response_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_authenticator_request_signal_info_response_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_authenticator_request_signal_info_response_ARG_pointers[] =
{
  &_flatpak_authenticator_request_signal_info_response_ARG_response.parent_struct,
  &_flatpak_authenticator_request_signal_info_response_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _flatpak_authenticator_request_signal_info_response =
{
  {
    -1,
    (gchar *) "Response",
    (GDBusArgInfo **) &_flatpak_authenticator_request_signal_info_response_ARG_pointers,
    NULL
  },
  "response"
};

static const GDBusSignalInfo * const _flatpak_authenticator_request_signal_info_pointers[] =
{
  &_flatpak_authenticator_request_signal_info_webflow.parent_struct,
  &_flatpak_authenticator_request_signal_info_webflow_done.parent_struct,
  &_flatpak_authenticator_request_signal_info_basic_auth.parent_struct,
  &_flatpak_authenticator_request_signal_info_response.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _flatpak_authenticator_request_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Flatpak.AuthenticatorRequest",
    (GDBusMethodInfo **) &_flatpak_authenticator_request_method_info_pointers,
    (GDBusSignalInfo **) &_flatpak_authenticator_request_signal_info_pointers,
    NULL,
    NULL
  },
  "authenticator-request",
};


/**
 * flatpak_authenticator_request_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Flatpak-AuthenticatorRequest.top_of_page">org.freedesktop.Flatpak.AuthenticatorRequest</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
flatpak_authenticator_request_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_flatpak_authenticator_request_interface_info.parent_struct;
}

/**
 * flatpak_authenticator_request_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FlatpakAuthenticatorRequest interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
flatpak_authenticator_request_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * FlatpakAuthenticatorRequest:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-AuthenticatorRequest.top_of_page">org.freedesktop.Flatpak.AuthenticatorRequest</link>.
 */

/**
 * FlatpakAuthenticatorRequestIface:
 * @parent_iface: The parent interface.
 * @handle_basic_auth_reply: Handler for the #FlatpakAuthenticatorRequest::handle-basic-auth-reply signal.
 * @handle_close: Handler for the #FlatpakAuthenticatorRequest::handle-close signal.
 * @basic_auth: Handler for the #FlatpakAuthenticatorRequest::basic-auth signal.
 * @response: Handler for the #FlatpakAuthenticatorRequest::response signal.
 * @webflow: Handler for the #FlatpakAuthenticatorRequest::webflow signal.
 * @webflow_done: Handler for the #FlatpakAuthenticatorRequest::webflow-done signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-AuthenticatorRequest.top_of_page">org.freedesktop.Flatpak.AuthenticatorRequest</link>.
 */

typedef FlatpakAuthenticatorRequestIface FlatpakAuthenticatorRequestInterface;
G_DEFINE_INTERFACE (FlatpakAuthenticatorRequest, flatpak_authenticator_request, G_TYPE_OBJECT)

static void
flatpak_authenticator_request_default_init (FlatpakAuthenticatorRequestIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FlatpakAuthenticatorRequest::handle-close:
   * @object: A #FlatpakAuthenticatorRequest.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_authenticator_request_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakAuthenticatorRequestIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * FlatpakAuthenticatorRequest::handle-basic-auth-reply:
   * @object: A #FlatpakAuthenticatorRequest.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_user: Argument passed by remote caller.
   * @arg_password: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.BasicAuthReply">BasicAuthReply()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_authenticator_request_complete_basic_auth_reply() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-basic-auth-reply",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakAuthenticatorRequestIface, handle_basic_auth_reply),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * FlatpakAuthenticatorRequest::webflow:
   * @object: A #FlatpakAuthenticatorRequest.
   * @arg_uri: Argument.
   * @arg_options: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.Webflow">"Webflow"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("webflow",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakAuthenticatorRequestIface, webflow),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * FlatpakAuthenticatorRequest::webflow-done:
   * @object: A #FlatpakAuthenticatorRequest.
   * @arg_options: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.WebflowDone">"WebflowDone"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("webflow-done",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakAuthenticatorRequestIface, webflow_done),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * FlatpakAuthenticatorRequest::basic-auth:
   * @object: A #FlatpakAuthenticatorRequest.
   * @arg_realm: Argument.
   * @arg_options: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.BasicAuth">"BasicAuth"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("basic-auth",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakAuthenticatorRequestIface, basic_auth),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * FlatpakAuthenticatorRequest::response:
   * @object: A #FlatpakAuthenticatorRequest.
   * @arg_response: Argument.
   * @arg_results: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.Response">"Response"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("response",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakAuthenticatorRequestIface, response),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_VARIANT);

}

/**
 * flatpak_authenticator_request_emit_webflow:
 * @object: A #FlatpakAuthenticatorRequest.
 * @arg_uri: Argument to pass with the signal.
 * @arg_options: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.Webflow">"Webflow"</link> D-Bus signal.
 */
void
flatpak_authenticator_request_emit_webflow (
    FlatpakAuthenticatorRequest *object,
    const gchar *arg_uri,
    GVariant *arg_options)
{
  g_signal_emit_by_name (object, "webflow", arg_uri, arg_options);
}

/**
 * flatpak_authenticator_request_emit_webflow_done:
 * @object: A #FlatpakAuthenticatorRequest.
 * @arg_options: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.WebflowDone">"WebflowDone"</link> D-Bus signal.
 */
void
flatpak_authenticator_request_emit_webflow_done (
    FlatpakAuthenticatorRequest *object,
    GVariant *arg_options)
{
  g_signal_emit_by_name (object, "webflow-done", arg_options);
}

/**
 * flatpak_authenticator_request_emit_basic_auth:
 * @object: A #FlatpakAuthenticatorRequest.
 * @arg_realm: Argument to pass with the signal.
 * @arg_options: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.BasicAuth">"BasicAuth"</link> D-Bus signal.
 */
void
flatpak_authenticator_request_emit_basic_auth (
    FlatpakAuthenticatorRequest *object,
    const gchar *arg_realm,
    GVariant *arg_options)
{
  g_signal_emit_by_name (object, "basic-auth", arg_realm, arg_options);
}

/**
 * flatpak_authenticator_request_emit_response:
 * @object: A #FlatpakAuthenticatorRequest.
 * @arg_response: Argument to pass with the signal.
 * @arg_results: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Flatpak-AuthenticatorRequest.Response">"Response"</link> D-Bus signal.
 */
void
flatpak_authenticator_request_emit_response (
    FlatpakAuthenticatorRequest *object,
    guint arg_response,
    GVariant *arg_results)
{
  g_signal_emit_by_name (object, "response", arg_response, arg_results);
}

/**
 * flatpak_authenticator_request_call_close:
 * @proxy: A #FlatpakAuthenticatorRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_authenticator_request_call_close_finish() to get the result of the operation.
 *
 * See flatpak_authenticator_request_call_close_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_authenticator_request_call_close (
    FlatpakAuthenticatorRequest *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_authenticator_request_call_close_finish:
 * @proxy: A #FlatpakAuthenticatorRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_authenticator_request_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_authenticator_request_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_authenticator_request_call_close_finish (
    FlatpakAuthenticatorRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_authenticator_request_call_close_sync:
 * @proxy: A #FlatpakAuthenticatorRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_authenticator_request_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_authenticator_request_call_close_sync (
    FlatpakAuthenticatorRequest *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_authenticator_request_call_basic_auth_reply:
 * @proxy: A #FlatpakAuthenticatorRequestProxy.
 * @arg_user: Argument to pass with the method invocation.
 * @arg_password: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.BasicAuthReply">BasicAuthReply()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_authenticator_request_call_basic_auth_reply_finish() to get the result of the operation.
 *
 * See flatpak_authenticator_request_call_basic_auth_reply_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_authenticator_request_call_basic_auth_reply (
    FlatpakAuthenticatorRequest *proxy,
    const gchar *arg_user,
    const gchar *arg_password,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "BasicAuthReply",
    g_variant_new ("(ss@a{sv})",
                   arg_user,
                   arg_password,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_authenticator_request_call_basic_auth_reply_finish:
 * @proxy: A #FlatpakAuthenticatorRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_authenticator_request_call_basic_auth_reply().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_authenticator_request_call_basic_auth_reply().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_authenticator_request_call_basic_auth_reply_finish (
    FlatpakAuthenticatorRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_authenticator_request_call_basic_auth_reply_sync:
 * @proxy: A #FlatpakAuthenticatorRequestProxy.
 * @arg_user: Argument to pass with the method invocation.
 * @arg_password: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.BasicAuthReply">BasicAuthReply()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_authenticator_request_call_basic_auth_reply() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_authenticator_request_call_basic_auth_reply_sync (
    FlatpakAuthenticatorRequest *proxy,
    const gchar *arg_user,
    const gchar *arg_password,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "BasicAuthReply",
    g_variant_new ("(ss@a{sv})",
                   arg_user,
                   arg_password,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_authenticator_request_complete_close:
 * @object: A #FlatpakAuthenticatorRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_authenticator_request_complete_close (
    FlatpakAuthenticatorRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_authenticator_request_complete_basic_auth_reply:
 * @object: A #FlatpakAuthenticatorRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-AuthenticatorRequest.BasicAuthReply">BasicAuthReply()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_authenticator_request_complete_basic_auth_reply (
    FlatpakAuthenticatorRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * FlatpakAuthenticatorRequestProxy:
 *
 * The #FlatpakAuthenticatorRequestProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakAuthenticatorRequestProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakAuthenticatorRequestProxy.
 */

struct _FlatpakAuthenticatorRequestProxyPrivate
{
  GData *qdata;
};

static void flatpak_authenticator_request_proxy_iface_init (FlatpakAuthenticatorRequestIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorRequestProxy, flatpak_authenticator_request_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FlatpakAuthenticatorRequestProxy)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR_REQUEST, flatpak_authenticator_request_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorRequestProxy, flatpak_authenticator_request_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR_REQUEST, flatpak_authenticator_request_proxy_iface_init))

#endif
static void
flatpak_authenticator_request_proxy_finalize (GObject *object)
{
  FlatpakAuthenticatorRequestProxy *proxy = FLATPAK_AUTHENTICATOR_REQUEST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (flatpak_authenticator_request_proxy_parent_class)->finalize (object);
}

static void
flatpak_authenticator_request_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
flatpak_authenticator_request_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
flatpak_authenticator_request_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_flatpak_authenticator_request_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FLATPAK_TYPE_AUTHENTICATOR_REQUEST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_AUTHENTICATOR_REQUEST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
flatpak_authenticator_request_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FlatpakAuthenticatorRequestProxy *proxy = FLATPAK_AUTHENTICATOR_REQUEST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_request_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_request_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
flatpak_authenticator_request_proxy_init (FlatpakAuthenticatorRequestProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = flatpak_authenticator_request_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FLATPAK_TYPE_AUTHENTICATOR_REQUEST_PROXY, FlatpakAuthenticatorRequestProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), flatpak_authenticator_request_interface_info ());
}

static void
flatpak_authenticator_request_proxy_class_init (FlatpakAuthenticatorRequestProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = flatpak_authenticator_request_proxy_finalize;
  gobject_class->get_property = flatpak_authenticator_request_proxy_get_property;
  gobject_class->set_property = flatpak_authenticator_request_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = flatpak_authenticator_request_proxy_g_signal;
  proxy_class->g_properties_changed = flatpak_authenticator_request_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakAuthenticatorRequestProxyPrivate));
#endif
}

static void
flatpak_authenticator_request_proxy_iface_init (FlatpakAuthenticatorRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * flatpak_authenticator_request_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-AuthenticatorRequest.top_of_page">org.freedesktop.Flatpak.AuthenticatorRequest</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_authenticator_request_proxy_new_finish() to get the result of the operation.
 *
 * See flatpak_authenticator_request_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_authenticator_request_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_AUTHENTICATOR_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.AuthenticatorRequest", NULL);
}

/**
 * flatpak_authenticator_request_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_authenticator_request_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_authenticator_request_proxy_new().
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticatorRequest *
flatpak_authenticator_request_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR_REQUEST (ret);
  else
    return NULL;
}

/**
 * flatpak_authenticator_request_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-AuthenticatorRequest.top_of_page">org.freedesktop.Flatpak.AuthenticatorRequest</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_authenticator_request_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticatorRequest *
flatpak_authenticator_request_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_AUTHENTICATOR_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.AuthenticatorRequest", NULL);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR_REQUEST (ret);
  else
    return NULL;
}


/**
 * flatpak_authenticator_request_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like flatpak_authenticator_request_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_authenticator_request_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See flatpak_authenticator_request_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_authenticator_request_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_AUTHENTICATOR_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.AuthenticatorRequest", NULL);
}

/**
 * flatpak_authenticator_request_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_authenticator_request_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_authenticator_request_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticatorRequest *
flatpak_authenticator_request_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR_REQUEST (ret);
  else
    return NULL;
}

/**
 * flatpak_authenticator_request_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like flatpak_authenticator_request_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_authenticator_request_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakAuthenticatorRequest *
flatpak_authenticator_request_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_AUTHENTICATOR_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.AuthenticatorRequest", NULL);
  if (ret != NULL)
    return FLATPAK_AUTHENTICATOR_REQUEST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FlatpakAuthenticatorRequestSkeleton:
 *
 * The #FlatpakAuthenticatorRequestSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakAuthenticatorRequestSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakAuthenticatorRequestSkeleton.
 */

struct _FlatpakAuthenticatorRequestSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_flatpak_authenticator_request_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FLATPAK_TYPE_AUTHENTICATOR_REQUEST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_AUTHENTICATOR_REQUEST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_flatpak_authenticator_request_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_flatpak_authenticator_request_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_authenticator_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _flatpak_authenticator_request_skeleton_vtable =
{
  _flatpak_authenticator_request_skeleton_handle_method_call,
  _flatpak_authenticator_request_skeleton_handle_get_property,
  _flatpak_authenticator_request_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
flatpak_authenticator_request_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return flatpak_authenticator_request_interface_info ();
}

static GDBusInterfaceVTable *
flatpak_authenticator_request_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_flatpak_authenticator_request_skeleton_vtable;
}

static GVariant *
flatpak_authenticator_request_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_flatpak_authenticator_request_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _flatpak_authenticator_request_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _flatpak_authenticator_request_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _flatpak_authenticator_request_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.AuthenticatorRequest", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
flatpak_authenticator_request_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_flatpak_authenticator_request_on_signal_webflow (
    FlatpakAuthenticatorRequest *object,
    const gchar *arg_uri,
    GVariant *arg_options)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@a{sv})",
                   arg_uri,
                   arg_options));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.AuthenticatorRequest", "Webflow",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_flatpak_authenticator_request_on_signal_webflow_done (
    FlatpakAuthenticatorRequest *object,
    GVariant *arg_options)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_options));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.AuthenticatorRequest", "WebflowDone",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_flatpak_authenticator_request_on_signal_basic_auth (
    FlatpakAuthenticatorRequest *object,
    const gchar *arg_realm,
    GVariant *arg_options)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@a{sv})",
                   arg_realm,
                   arg_options));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.AuthenticatorRequest", "BasicAuth",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_flatpak_authenticator_request_on_signal_response (
    FlatpakAuthenticatorRequest *object,
    guint arg_response,
    GVariant *arg_results)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u@a{sv})",
                   arg_response,
                   arg_results));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.AuthenticatorRequest", "Response",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void flatpak_authenticator_request_skeleton_iface_init (FlatpakAuthenticatorRequestIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorRequestSkeleton, flatpak_authenticator_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FlatpakAuthenticatorRequestSkeleton)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR_REQUEST, flatpak_authenticator_request_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakAuthenticatorRequestSkeleton, flatpak_authenticator_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_AUTHENTICATOR_REQUEST, flatpak_authenticator_request_skeleton_iface_init))

#endif
static void
flatpak_authenticator_request_skeleton_finalize (GObject *object)
{
  FlatpakAuthenticatorRequestSkeleton *skeleton = FLATPAK_AUTHENTICATOR_REQUEST_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (flatpak_authenticator_request_skeleton_parent_class)->finalize (object);
}

static void
flatpak_authenticator_request_skeleton_init (FlatpakAuthenticatorRequestSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = flatpak_authenticator_request_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FLATPAK_TYPE_AUTHENTICATOR_REQUEST_SKELETON, FlatpakAuthenticatorRequestSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
flatpak_authenticator_request_skeleton_class_init (FlatpakAuthenticatorRequestSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = flatpak_authenticator_request_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = flatpak_authenticator_request_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = flatpak_authenticator_request_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = flatpak_authenticator_request_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = flatpak_authenticator_request_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakAuthenticatorRequestSkeletonPrivate));
#endif
}

static void
flatpak_authenticator_request_skeleton_iface_init (FlatpakAuthenticatorRequestIface *iface)
{
  iface->webflow = _flatpak_authenticator_request_on_signal_webflow;
  iface->webflow_done = _flatpak_authenticator_request_on_signal_webflow_done;
  iface->basic_auth = _flatpak_authenticator_request_on_signal_basic_auth;
  iface->response = _flatpak_authenticator_request_on_signal_response;
}

/**
 * flatpak_authenticator_request_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-AuthenticatorRequest.top_of_page">org.freedesktop.Flatpak.AuthenticatorRequest</link>.
 *
 * Returns: (transfer full) (type FlatpakAuthenticatorRequestSkeleton): The skeleton object.
 */
FlatpakAuthenticatorRequest *
flatpak_authenticator_request_skeleton_new (void)
{
  return FLATPAK_AUTHENTICATOR_REQUEST (g_object_new (FLATPAK_TYPE_AUTHENTICATOR_REQUEST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Flatpak.SessionHelper
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FlatpakSessionHelper
 * @title: FlatpakSessionHelper
 * @short_description: Generated C code for the org.freedesktop.Flatpak.SessionHelper D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Flatpak-SessionHelper.top_of_page">org.freedesktop.Flatpak.SessionHelper</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Flatpak.SessionHelper ---- */

static const _ExtendedGDBusArgInfo _flatpak_session_helper_method_info_request_session_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_session_helper_method_info_request_session_OUT_ARG_pointers[] =
{
  &_flatpak_session_helper_method_info_request_session_OUT_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_session_helper_method_info_request_session =
{
  {
    -1,
    (gchar *) "RequestSession",
    NULL,
    (GDBusArgInfo **) &_flatpak_session_helper_method_info_request_session_OUT_ARG_pointers,
    NULL
  },
  "handle-request-session",
  FALSE
};

static const GDBusMethodInfo * const _flatpak_session_helper_method_info_pointers[] =
{
  &_flatpak_session_helper_method_info_request_session.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _flatpak_session_helper_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _flatpak_session_helper_property_info_pointers[] =
{
  &_flatpak_session_helper_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _flatpak_session_helper_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Flatpak.SessionHelper",
    (GDBusMethodInfo **) &_flatpak_session_helper_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_flatpak_session_helper_property_info_pointers,
    NULL
  },
  "session-helper",
};


/**
 * flatpak_session_helper_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Flatpak-SessionHelper.top_of_page">org.freedesktop.Flatpak.SessionHelper</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
flatpak_session_helper_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_flatpak_session_helper_interface_info.parent_struct;
}

/**
 * flatpak_session_helper_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FlatpakSessionHelper interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
flatpak_session_helper_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * FlatpakSessionHelper:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SessionHelper.top_of_page">org.freedesktop.Flatpak.SessionHelper</link>.
 */

/**
 * FlatpakSessionHelperIface:
 * @parent_iface: The parent interface.
 * @handle_request_session: Handler for the #FlatpakSessionHelper::handle-request-session signal.
 * @get_version: Getter for the #FlatpakSessionHelper:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SessionHelper.top_of_page">org.freedesktop.Flatpak.SessionHelper</link>.
 */

typedef FlatpakSessionHelperIface FlatpakSessionHelperInterface;
G_DEFINE_INTERFACE (FlatpakSessionHelper, flatpak_session_helper, G_TYPE_OBJECT)

static void
flatpak_session_helper_default_init (FlatpakSessionHelperIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FlatpakSessionHelper::handle-request-session:
   * @object: A #FlatpakSessionHelper.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SessionHelper.RequestSession">RequestSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_session_helper_complete_request_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSessionHelperIface, handle_request_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * FlatpakSessionHelper:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Flatpak-SessionHelper.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * flatpak_session_helper_get_version: (skip)
 * @object: A #FlatpakSessionHelper.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Flatpak-SessionHelper.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
flatpak_session_helper_get_version (FlatpakSessionHelper *object)
{
  return FLATPAK_SESSION_HELPER_GET_IFACE (object)->get_version (object);
}

/**
 * flatpak_session_helper_set_version: (skip)
 * @object: A #FlatpakSessionHelper.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Flatpak-SessionHelper.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
flatpak_session_helper_set_version (FlatpakSessionHelper *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * flatpak_session_helper_call_request_session:
 * @proxy: A #FlatpakSessionHelperProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SessionHelper.RequestSession">RequestSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_session_helper_call_request_session_finish() to get the result of the operation.
 *
 * See flatpak_session_helper_call_request_session_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_session_helper_call_request_session (
    FlatpakSessionHelper *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_session_helper_call_request_session_finish:
 * @proxy: A #FlatpakSessionHelperProxy.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_session_helper_call_request_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_session_helper_call_request_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_session_helper_call_request_session_finish (
    FlatpakSessionHelper *proxy,
    GVariant **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_session_helper_call_request_session_sync:
 * @proxy: A #FlatpakSessionHelperProxy.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SessionHelper.RequestSession">RequestSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_session_helper_call_request_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_session_helper_call_request_session_sync (
    FlatpakSessionHelper *proxy,
    GVariant **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_session_helper_complete_request_session:
 * @object: A #FlatpakSessionHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SessionHelper.RequestSession">RequestSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_session_helper_complete_request_session (
    FlatpakSessionHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   data));
}

/* ------------------------------------------------------------------------ */

/**
 * FlatpakSessionHelperProxy:
 *
 * The #FlatpakSessionHelperProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakSessionHelperProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakSessionHelperProxy.
 */

struct _FlatpakSessionHelperProxyPrivate
{
  GData *qdata;
};

static void flatpak_session_helper_proxy_iface_init (FlatpakSessionHelperIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakSessionHelperProxy, flatpak_session_helper_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FlatpakSessionHelperProxy)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SESSION_HELPER, flatpak_session_helper_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakSessionHelperProxy, flatpak_session_helper_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SESSION_HELPER, flatpak_session_helper_proxy_iface_init))

#endif
static void
flatpak_session_helper_proxy_finalize (GObject *object)
{
  FlatpakSessionHelperProxy *proxy = FLATPAK_SESSION_HELPER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (flatpak_session_helper_proxy_parent_class)->finalize (object);
}

static void
flatpak_session_helper_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_session_helper_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
flatpak_session_helper_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Flatpak.SessionHelper: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
flatpak_session_helper_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_session_helper_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Flatpak.SessionHelper", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) flatpak_session_helper_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
flatpak_session_helper_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_flatpak_session_helper_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FLATPAK_TYPE_SESSION_HELPER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_SESSION_HELPER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
flatpak_session_helper_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FlatpakSessionHelperProxy *proxy = FLATPAK_SESSION_HELPER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_session_helper_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_session_helper_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
flatpak_session_helper_proxy_get_version (FlatpakSessionHelper *object)
{
  FlatpakSessionHelperProxy *proxy = FLATPAK_SESSION_HELPER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
flatpak_session_helper_proxy_init (FlatpakSessionHelperProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = flatpak_session_helper_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FLATPAK_TYPE_SESSION_HELPER_PROXY, FlatpakSessionHelperProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), flatpak_session_helper_interface_info ());
}

static void
flatpak_session_helper_proxy_class_init (FlatpakSessionHelperProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = flatpak_session_helper_proxy_finalize;
  gobject_class->get_property = flatpak_session_helper_proxy_get_property;
  gobject_class->set_property = flatpak_session_helper_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = flatpak_session_helper_proxy_g_signal;
  proxy_class->g_properties_changed = flatpak_session_helper_proxy_g_properties_changed;

  flatpak_session_helper_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakSessionHelperProxyPrivate));
#endif
}

static void
flatpak_session_helper_proxy_iface_init (FlatpakSessionHelperIface *iface)
{
  iface->get_version = flatpak_session_helper_proxy_get_version;
}

/**
 * flatpak_session_helper_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SessionHelper.top_of_page">org.freedesktop.Flatpak.SessionHelper</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_session_helper_proxy_new_finish() to get the result of the operation.
 *
 * See flatpak_session_helper_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_session_helper_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_SESSION_HELPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SessionHelper", NULL);
}

/**
 * flatpak_session_helper_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_session_helper_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_session_helper_proxy_new().
 *
 * Returns: (transfer full) (type FlatpakSessionHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSessionHelper *
flatpak_session_helper_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_SESSION_HELPER (ret);
  else
    return NULL;
}

/**
 * flatpak_session_helper_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SessionHelper.top_of_page">org.freedesktop.Flatpak.SessionHelper</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_session_helper_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakSessionHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSessionHelper *
flatpak_session_helper_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_SESSION_HELPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SessionHelper", NULL);
  if (ret != NULL)
    return FLATPAK_SESSION_HELPER (ret);
  else
    return NULL;
}


/**
 * flatpak_session_helper_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like flatpak_session_helper_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_session_helper_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See flatpak_session_helper_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_session_helper_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_SESSION_HELPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SessionHelper", NULL);
}

/**
 * flatpak_session_helper_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_session_helper_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_session_helper_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FlatpakSessionHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSessionHelper *
flatpak_session_helper_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_SESSION_HELPER (ret);
  else
    return NULL;
}

/**
 * flatpak_session_helper_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like flatpak_session_helper_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_session_helper_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakSessionHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSessionHelper *
flatpak_session_helper_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_SESSION_HELPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SessionHelper", NULL);
  if (ret != NULL)
    return FLATPAK_SESSION_HELPER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FlatpakSessionHelperSkeleton:
 *
 * The #FlatpakSessionHelperSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakSessionHelperSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakSessionHelperSkeleton.
 */

struct _FlatpakSessionHelperSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_flatpak_session_helper_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FLATPAK_TYPE_SESSION_HELPER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_SESSION_HELPER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_flatpak_session_helper_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_session_helper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_flatpak_session_helper_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_session_helper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _flatpak_session_helper_skeleton_vtable =
{
  _flatpak_session_helper_skeleton_handle_method_call,
  _flatpak_session_helper_skeleton_handle_get_property,
  _flatpak_session_helper_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
flatpak_session_helper_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return flatpak_session_helper_interface_info ();
}

static GDBusInterfaceVTable *
flatpak_session_helper_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_flatpak_session_helper_skeleton_vtable;
}

static GVariant *
flatpak_session_helper_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_flatpak_session_helper_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _flatpak_session_helper_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _flatpak_session_helper_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _flatpak_session_helper_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.SessionHelper", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _flatpak_session_helper_emit_changed (gpointer user_data);

static void
flatpak_session_helper_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _flatpak_session_helper_emit_changed (skeleton);
}

static void flatpak_session_helper_skeleton_iface_init (FlatpakSessionHelperIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakSessionHelperSkeleton, flatpak_session_helper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FlatpakSessionHelperSkeleton)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SESSION_HELPER, flatpak_session_helper_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakSessionHelperSkeleton, flatpak_session_helper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SESSION_HELPER, flatpak_session_helper_skeleton_iface_init))

#endif
static void
flatpak_session_helper_skeleton_finalize (GObject *object)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (flatpak_session_helper_skeleton_parent_class)->finalize (object);
}

static void
flatpak_session_helper_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_flatpak_session_helper_emit_changed (gpointer user_data)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Flatpak.SessionHelper",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_flatpak_session_helper_schedule_emit_changed (FlatpakSessionHelperSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
flatpak_session_helper_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _flatpak_session_helper_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _flatpak_session_helper_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
flatpak_session_helper_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_session_helper_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _flatpak_session_helper_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
flatpak_session_helper_skeleton_init (FlatpakSessionHelperSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = flatpak_session_helper_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FLATPAK_TYPE_SESSION_HELPER_SKELETON, FlatpakSessionHelperSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
flatpak_session_helper_skeleton_get_version (FlatpakSessionHelper *object)
{
  FlatpakSessionHelperSkeleton *skeleton = FLATPAK_SESSION_HELPER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
flatpak_session_helper_skeleton_class_init (FlatpakSessionHelperSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = flatpak_session_helper_skeleton_finalize;
  gobject_class->get_property = flatpak_session_helper_skeleton_get_property;
  gobject_class->set_property = flatpak_session_helper_skeleton_set_property;
  gobject_class->notify       = flatpak_session_helper_skeleton_notify;


  flatpak_session_helper_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = flatpak_session_helper_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = flatpak_session_helper_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = flatpak_session_helper_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = flatpak_session_helper_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakSessionHelperSkeletonPrivate));
#endif
}

static void
flatpak_session_helper_skeleton_iface_init (FlatpakSessionHelperIface *iface)
{
  iface->get_version = flatpak_session_helper_skeleton_get_version;
}

/**
 * flatpak_session_helper_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SessionHelper.top_of_page">org.freedesktop.Flatpak.SessionHelper</link>.
 *
 * Returns: (transfer full) (type FlatpakSessionHelperSkeleton): The skeleton object.
 */
FlatpakSessionHelper *
flatpak_session_helper_skeleton_new (void)
{
  return FLATPAK_SESSION_HELPER (g_object_new (FLATPAK_TYPE_SESSION_HELPER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Flatpak.Development
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FlatpakDevelopment
 * @title: FlatpakDevelopment
 * @short_description: Generated C code for the org.freedesktop.Flatpak.Development D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Flatpak-Development.top_of_page">org.freedesktop.Flatpak.Development</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Flatpak.Development ---- */

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_IN_ARG_cwd_path =
{
  {
    -1,
    (gchar *) "cwd_path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_IN_ARG_argv =
{
  {
    -1,
    (gchar *) "argv",
    (gchar *) "aay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_IN_ARG_fds =
{
  {
    -1,
    (gchar *) "fds",
    (gchar *) "a{uh}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_IN_ARG_envs =
{
  {
    -1,
    (gchar *) "envs",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_development_method_info_host_command_IN_ARG_pointers[] =
{
  &_flatpak_development_method_info_host_command_IN_ARG_cwd_path.parent_struct,
  &_flatpak_development_method_info_host_command_IN_ARG_argv.parent_struct,
  &_flatpak_development_method_info_host_command_IN_ARG_fds.parent_struct,
  &_flatpak_development_method_info_host_command_IN_ARG_envs.parent_struct,
  &_flatpak_development_method_info_host_command_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_OUT_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_development_method_info_host_command_OUT_ARG_pointers[] =
{
  &_flatpak_development_method_info_host_command_OUT_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_development_method_info_host_command =
{
  {
    -1,
    (gchar *) "HostCommand",
    (GDBusArgInfo **) &_flatpak_development_method_info_host_command_IN_ARG_pointers,
    (GDBusArgInfo **) &_flatpak_development_method_info_host_command_OUT_ARG_pointers,
    NULL
  },
  "handle-host-command",
  TRUE
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_signal_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_signal_IN_ARG_signal =
{
  {
    -1,
    (gchar *) "signal",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_development_method_info_host_command_signal_IN_ARG_to_process_group =
{
  {
    -1,
    (gchar *) "to_process_group",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_development_method_info_host_command_signal_IN_ARG_pointers[] =
{
  &_flatpak_development_method_info_host_command_signal_IN_ARG_pid.parent_struct,
  &_flatpak_development_method_info_host_command_signal_IN_ARG_signal.parent_struct,
  &_flatpak_development_method_info_host_command_signal_IN_ARG_to_process_group.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_development_method_info_host_command_signal =
{
  {
    -1,
    (gchar *) "HostCommandSignal",
    (GDBusArgInfo **) &_flatpak_development_method_info_host_command_signal_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-host-command-signal",
  FALSE
};

static const GDBusMethodInfo * const _flatpak_development_method_info_pointers[] =
{
  &_flatpak_development_method_info_host_command.parent_struct,
  &_flatpak_development_method_info_host_command_signal.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _flatpak_development_signal_info_host_command_exited_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_development_signal_info_host_command_exited_ARG_exit_status =
{
  {
    -1,
    (gchar *) "exit_status",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_development_signal_info_host_command_exited_ARG_pointers[] =
{
  &_flatpak_development_signal_info_host_command_exited_ARG_pid.parent_struct,
  &_flatpak_development_signal_info_host_command_exited_ARG_exit_status.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _flatpak_development_signal_info_host_command_exited =
{
  {
    -1,
    (gchar *) "HostCommandExited",
    (GDBusArgInfo **) &_flatpak_development_signal_info_host_command_exited_ARG_pointers,
    NULL
  },
  "host-command-exited"
};

static const GDBusSignalInfo * const _flatpak_development_signal_info_pointers[] =
{
  &_flatpak_development_signal_info_host_command_exited.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _flatpak_development_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _flatpak_development_property_info_pointers[] =
{
  &_flatpak_development_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _flatpak_development_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Flatpak.Development",
    (GDBusMethodInfo **) &_flatpak_development_method_info_pointers,
    (GDBusSignalInfo **) &_flatpak_development_signal_info_pointers,
    (GDBusPropertyInfo **) &_flatpak_development_property_info_pointers,
    NULL
  },
  "development",
};


/**
 * flatpak_development_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Flatpak-Development.top_of_page">org.freedesktop.Flatpak.Development</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
flatpak_development_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_flatpak_development_interface_info.parent_struct;
}

/**
 * flatpak_development_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FlatpakDevelopment interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
flatpak_development_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * FlatpakDevelopment:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Development.top_of_page">org.freedesktop.Flatpak.Development</link>.
 */

/**
 * FlatpakDevelopmentIface:
 * @parent_iface: The parent interface.
 * @handle_host_command: Handler for the #FlatpakDevelopment::handle-host-command signal.
 * @handle_host_command_signal: Handler for the #FlatpakDevelopment::handle-host-command-signal signal.
 * @get_version: Getter for the #FlatpakDevelopment:version property.
 * @host_command_exited: Handler for the #FlatpakDevelopment::host-command-exited signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Development.top_of_page">org.freedesktop.Flatpak.Development</link>.
 */

typedef FlatpakDevelopmentIface FlatpakDevelopmentInterface;
G_DEFINE_INTERFACE (FlatpakDevelopment, flatpak_development, G_TYPE_OBJECT)

static void
flatpak_development_default_init (FlatpakDevelopmentIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FlatpakDevelopment::handle-host-command:
   * @object: A #FlatpakDevelopment.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_cwd_path: Argument passed by remote caller.
   * @arg_argv: Argument passed by remote caller.
   * @arg_fds: Argument passed by remote caller.
   * @arg_envs: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommand">HostCommand()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_development_complete_host_command() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-host-command",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakDevelopmentIface, handle_host_command),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_UINT);

  /**
   * FlatpakDevelopment::handle-host-command-signal:
   * @object: A #FlatpakDevelopment.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   * @arg_signal: Argument passed by remote caller.
   * @arg_to_process_group: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommandSignal">HostCommandSignal()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_development_complete_host_command_signal() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-host-command-signal",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakDevelopmentIface, handle_host_command_signal),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /* GObject signals for received D-Bus signals: */
  /**
   * FlatpakDevelopment::host-command-exited:
   * @object: A #FlatpakDevelopment.
   * @arg_pid: Argument.
   * @arg_exit_status: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Flatpak-Development.HostCommandExited">"HostCommandExited"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("host-command-exited",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakDevelopmentIface, host_command_exited),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * FlatpakDevelopment:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Flatpak-Development.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * flatpak_development_get_version: (skip)
 * @object: A #FlatpakDevelopment.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Flatpak-Development.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
flatpak_development_get_version (FlatpakDevelopment *object)
{
  return FLATPAK_DEVELOPMENT_GET_IFACE (object)->get_version (object);
}

/**
 * flatpak_development_set_version: (skip)
 * @object: A #FlatpakDevelopment.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Flatpak-Development.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
flatpak_development_set_version (FlatpakDevelopment *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * flatpak_development_emit_host_command_exited:
 * @object: A #FlatpakDevelopment.
 * @arg_pid: Argument to pass with the signal.
 * @arg_exit_status: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Flatpak-Development.HostCommandExited">"HostCommandExited"</link> D-Bus signal.
 */
void
flatpak_development_emit_host_command_exited (
    FlatpakDevelopment *object,
    guint arg_pid,
    guint arg_exit_status)
{
  g_signal_emit_by_name (object, "host-command-exited", arg_pid, arg_exit_status);
}

/**
 * flatpak_development_call_host_command:
 * @proxy: A #FlatpakDevelopmentProxy.
 * @arg_cwd_path: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_envs: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommand">HostCommand()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_development_call_host_command_finish() to get the result of the operation.
 *
 * See flatpak_development_call_host_command_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_development_call_host_command (
    FlatpakDevelopment *proxy,
    const gchar *arg_cwd_path,
    const gchar *const *arg_argv,
    GVariant *arg_fds,
    GVariant *arg_envs,
    guint arg_flags,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "HostCommand",
    g_variant_new ("(^ay^aay@a{uh}@a{ss}u)",
                   arg_cwd_path,
                   arg_argv,
                   arg_fds,
                   arg_envs,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_development_call_host_command_finish:
 * @proxy: A #FlatpakDevelopmentProxy.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_development_call_host_command().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_development_call_host_command().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_development_call_host_command_finish (
    FlatpakDevelopment *proxy,
    guint *out_pid,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_development_call_host_command_sync:
 * @proxy: A #FlatpakDevelopmentProxy.
 * @arg_cwd_path: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_envs: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommand">HostCommand()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_development_call_host_command() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_development_call_host_command_sync (
    FlatpakDevelopment *proxy,
    const gchar *arg_cwd_path,
    const gchar *const *arg_argv,
    GVariant *arg_fds,
    GVariant *arg_envs,
    guint arg_flags,
    GUnixFDList  *fd_list,
    guint *out_pid,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "HostCommand",
    g_variant_new ("(^ay^aay@a{uh}@a{ss}u)",
                   arg_cwd_path,
                   arg_argv,
                   arg_fds,
                   arg_envs,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_development_call_host_command_signal:
 * @proxy: A #FlatpakDevelopmentProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @arg_to_process_group: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommandSignal">HostCommandSignal()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_development_call_host_command_signal_finish() to get the result of the operation.
 *
 * See flatpak_development_call_host_command_signal_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_development_call_host_command_signal (
    FlatpakDevelopment *proxy,
    guint arg_pid,
    guint arg_signal,
    gboolean arg_to_process_group,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HostCommandSignal",
    g_variant_new ("(uub)",
                   arg_pid,
                   arg_signal,
                   arg_to_process_group),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_development_call_host_command_signal_finish:
 * @proxy: A #FlatpakDevelopmentProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_development_call_host_command_signal().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_development_call_host_command_signal().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_development_call_host_command_signal_finish (
    FlatpakDevelopment *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_development_call_host_command_signal_sync:
 * @proxy: A #FlatpakDevelopmentProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @arg_to_process_group: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommandSignal">HostCommandSignal()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_development_call_host_command_signal() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_development_call_host_command_signal_sync (
    FlatpakDevelopment *proxy,
    guint arg_pid,
    guint arg_signal,
    gboolean arg_to_process_group,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HostCommandSignal",
    g_variant_new ("(uub)",
                   arg_pid,
                   arg_signal,
                   arg_to_process_group),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_development_complete_host_command:
 * @object: A #FlatpakDevelopment.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @pid: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommand">HostCommand()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_development_complete_host_command (
    FlatpakDevelopment *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    guint pid)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(u)",
                   pid),
    fd_list);
}

/**
 * flatpak_development_complete_host_command_signal:
 * @object: A #FlatpakDevelopment.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-Development.HostCommandSignal">HostCommandSignal()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_development_complete_host_command_signal (
    FlatpakDevelopment *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * FlatpakDevelopmentProxy:
 *
 * The #FlatpakDevelopmentProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakDevelopmentProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakDevelopmentProxy.
 */

struct _FlatpakDevelopmentProxyPrivate
{
  GData *qdata;
};

static void flatpak_development_proxy_iface_init (FlatpakDevelopmentIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakDevelopmentProxy, flatpak_development_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FlatpakDevelopmentProxy)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_DEVELOPMENT, flatpak_development_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakDevelopmentProxy, flatpak_development_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_DEVELOPMENT, flatpak_development_proxy_iface_init))

#endif
static void
flatpak_development_proxy_finalize (GObject *object)
{
  FlatpakDevelopmentProxy *proxy = FLATPAK_DEVELOPMENT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (flatpak_development_proxy_parent_class)->finalize (object);
}

static void
flatpak_development_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_development_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
flatpak_development_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Flatpak.Development: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
flatpak_development_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_development_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Flatpak.Development", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) flatpak_development_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
flatpak_development_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_flatpak_development_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FLATPAK_TYPE_DEVELOPMENT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_DEVELOPMENT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
flatpak_development_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FlatpakDevelopmentProxy *proxy = FLATPAK_DEVELOPMENT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_development_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_development_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
flatpak_development_proxy_get_version (FlatpakDevelopment *object)
{
  FlatpakDevelopmentProxy *proxy = FLATPAK_DEVELOPMENT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
flatpak_development_proxy_init (FlatpakDevelopmentProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = flatpak_development_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FLATPAK_TYPE_DEVELOPMENT_PROXY, FlatpakDevelopmentProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), flatpak_development_interface_info ());
}

static void
flatpak_development_proxy_class_init (FlatpakDevelopmentProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = flatpak_development_proxy_finalize;
  gobject_class->get_property = flatpak_development_proxy_get_property;
  gobject_class->set_property = flatpak_development_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = flatpak_development_proxy_g_signal;
  proxy_class->g_properties_changed = flatpak_development_proxy_g_properties_changed;

  flatpak_development_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakDevelopmentProxyPrivate));
#endif
}

static void
flatpak_development_proxy_iface_init (FlatpakDevelopmentIface *iface)
{
  iface->get_version = flatpak_development_proxy_get_version;
}

/**
 * flatpak_development_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Development.top_of_page">org.freedesktop.Flatpak.Development</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_development_proxy_new_finish() to get the result of the operation.
 *
 * See flatpak_development_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_development_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_DEVELOPMENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Development", NULL);
}

/**
 * flatpak_development_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_development_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_development_proxy_new().
 *
 * Returns: (transfer full) (type FlatpakDevelopmentProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakDevelopment *
flatpak_development_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_DEVELOPMENT (ret);
  else
    return NULL;
}

/**
 * flatpak_development_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Development.top_of_page">org.freedesktop.Flatpak.Development</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_development_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakDevelopmentProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakDevelopment *
flatpak_development_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_DEVELOPMENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Development", NULL);
  if (ret != NULL)
    return FLATPAK_DEVELOPMENT (ret);
  else
    return NULL;
}


/**
 * flatpak_development_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like flatpak_development_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_development_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See flatpak_development_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_development_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_DEVELOPMENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Development", NULL);
}

/**
 * flatpak_development_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_development_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_development_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FlatpakDevelopmentProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakDevelopment *
flatpak_development_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_DEVELOPMENT (ret);
  else
    return NULL;
}

/**
 * flatpak_development_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like flatpak_development_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_development_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakDevelopmentProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakDevelopment *
flatpak_development_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_DEVELOPMENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.Development", NULL);
  if (ret != NULL)
    return FLATPAK_DEVELOPMENT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FlatpakDevelopmentSkeleton:
 *
 * The #FlatpakDevelopmentSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakDevelopmentSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakDevelopmentSkeleton.
 */

struct _FlatpakDevelopmentSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_flatpak_development_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FLATPAK_TYPE_DEVELOPMENT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_DEVELOPMENT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_flatpak_development_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_development_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_flatpak_development_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_development_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _flatpak_development_skeleton_vtable =
{
  _flatpak_development_skeleton_handle_method_call,
  _flatpak_development_skeleton_handle_get_property,
  _flatpak_development_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
flatpak_development_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return flatpak_development_interface_info ();
}

static GDBusInterfaceVTable *
flatpak_development_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_flatpak_development_skeleton_vtable;
}

static GVariant *
flatpak_development_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_flatpak_development_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _flatpak_development_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _flatpak_development_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _flatpak_development_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.Development", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _flatpak_development_emit_changed (gpointer user_data);

static void
flatpak_development_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _flatpak_development_emit_changed (skeleton);
}

static void
_flatpak_development_on_signal_host_command_exited (
    FlatpakDevelopment *object,
    guint arg_pid,
    guint arg_exit_status)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu)",
                   arg_pid,
                   arg_exit_status));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.Development", "HostCommandExited",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void flatpak_development_skeleton_iface_init (FlatpakDevelopmentIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakDevelopmentSkeleton, flatpak_development_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FlatpakDevelopmentSkeleton)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_DEVELOPMENT, flatpak_development_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakDevelopmentSkeleton, flatpak_development_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_DEVELOPMENT, flatpak_development_skeleton_iface_init))

#endif
static void
flatpak_development_skeleton_finalize (GObject *object)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (flatpak_development_skeleton_parent_class)->finalize (object);
}

static void
flatpak_development_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_flatpak_development_emit_changed (gpointer user_data)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Flatpak.Development",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_flatpak_development_schedule_emit_changed (FlatpakDevelopmentSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
flatpak_development_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _flatpak_development_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _flatpak_development_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
flatpak_development_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_development_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _flatpak_development_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
flatpak_development_skeleton_init (FlatpakDevelopmentSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = flatpak_development_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FLATPAK_TYPE_DEVELOPMENT_SKELETON, FlatpakDevelopmentSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
flatpak_development_skeleton_get_version (FlatpakDevelopment *object)
{
  FlatpakDevelopmentSkeleton *skeleton = FLATPAK_DEVELOPMENT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
flatpak_development_skeleton_class_init (FlatpakDevelopmentSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = flatpak_development_skeleton_finalize;
  gobject_class->get_property = flatpak_development_skeleton_get_property;
  gobject_class->set_property = flatpak_development_skeleton_set_property;
  gobject_class->notify       = flatpak_development_skeleton_notify;


  flatpak_development_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = flatpak_development_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = flatpak_development_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = flatpak_development_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = flatpak_development_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakDevelopmentSkeletonPrivate));
#endif
}

static void
flatpak_development_skeleton_iface_init (FlatpakDevelopmentIface *iface)
{
  iface->host_command_exited = _flatpak_development_on_signal_host_command_exited;
  iface->get_version = flatpak_development_skeleton_get_version;
}

/**
 * flatpak_development_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-Development.top_of_page">org.freedesktop.Flatpak.Development</link>.
 *
 * Returns: (transfer full) (type FlatpakDevelopmentSkeleton): The skeleton object.
 */
FlatpakDevelopment *
flatpak_development_skeleton_new (void)
{
  return FLATPAK_DEVELOPMENT (g_object_new (FLATPAK_TYPE_DEVELOPMENT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Flatpak.SystemHelper
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:FlatpakSystemHelper
 * @title: FlatpakSystemHelper
 * @short_description: Generated C code for the org.freedesktop.Flatpak.SystemHelper D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Flatpak-SystemHelper.top_of_page">org.freedesktop.Flatpak.SystemHelper</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Flatpak.SystemHelper ---- */

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_IN_ARG_repo_path =
{
  {
    -1,
    (gchar *) "repo_path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_IN_ARG_ref =
{
  {
    -1,
    (gchar *) "ref",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_IN_ARG_origin =
{
  {
    -1,
    (gchar *) "origin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_IN_ARG_subpaths =
{
  {
    -1,
    (gchar *) "subpaths",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_IN_ARG_previous_ids =
{
  {
    -1,
    (gchar *) "previous_ids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_deploy_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_deploy_IN_ARG_repo_path.parent_struct,
  &_flatpak_system_helper_method_info_deploy_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_deploy_IN_ARG_ref.parent_struct,
  &_flatpak_system_helper_method_info_deploy_IN_ARG_origin.parent_struct,
  &_flatpak_system_helper_method_info_deploy_IN_ARG_subpaths.parent_struct,
  &_flatpak_system_helper_method_info_deploy_IN_ARG_previous_ids.parent_struct,
  &_flatpak_system_helper_method_info_deploy_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_deploy =
{
  {
    -1,
    (gchar *) "Deploy",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_deploy_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-deploy",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_appstream_IN_ARG_repo_path =
{
  {
    -1,
    (gchar *) "repo_path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_appstream_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_appstream_IN_ARG_origin =
{
  {
    -1,
    (gchar *) "origin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_appstream_IN_ARG_arch =
{
  {
    -1,
    (gchar *) "arch",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_deploy_appstream_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_deploy_appstream_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_deploy_appstream_IN_ARG_repo_path.parent_struct,
  &_flatpak_system_helper_method_info_deploy_appstream_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_deploy_appstream_IN_ARG_origin.parent_struct,
  &_flatpak_system_helper_method_info_deploy_appstream_IN_ARG_arch.parent_struct,
  &_flatpak_system_helper_method_info_deploy_appstream_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_deploy_appstream =
{
  {
    -1,
    (gchar *) "DeployAppstream",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_deploy_appstream_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-deploy-appstream",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_uninstall_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_uninstall_IN_ARG_ref =
{
  {
    -1,
    (gchar *) "ref",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_uninstall_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_uninstall_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_uninstall_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_uninstall_IN_ARG_ref.parent_struct,
  &_flatpak_system_helper_method_info_uninstall_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_uninstall =
{
  {
    -1,
    (gchar *) "Uninstall",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_uninstall_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-uninstall",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_install_bundle_IN_ARG_bundle_path =
{
  {
    -1,
    (gchar *) "bundle_path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_install_bundle_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_install_bundle_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_install_bundle_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_install_bundle_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_install_bundle_IN_ARG_bundle_path.parent_struct,
  &_flatpak_system_helper_method_info_install_bundle_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_install_bundle_IN_ARG_remote.parent_struct,
  &_flatpak_system_helper_method_info_install_bundle_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_install_bundle_OUT_ARG_ref =
{
  {
    -1,
    (gchar *) "ref",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_install_bundle_OUT_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_install_bundle_OUT_ARG_ref.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_install_bundle =
{
  {
    -1,
    (gchar *) "InstallBundle",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_install_bundle_IN_ARG_pointers,
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_install_bundle_OUT_ARG_pointers,
    NULL
  },
  "handle-install-bundle",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_remote_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_remote_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_remote_IN_ARG_config =
{
  {
    -1,
    (gchar *) "config",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_remote_IN_ARG_gpg_key =
{
  {
    -1,
    (gchar *) "gpg_key",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_remote_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_configure_remote_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_configure_remote_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_configure_remote_IN_ARG_remote.parent_struct,
  &_flatpak_system_helper_method_info_configure_remote_IN_ARG_config.parent_struct,
  &_flatpak_system_helper_method_info_configure_remote_IN_ARG_gpg_key.parent_struct,
  &_flatpak_system_helper_method_info_configure_remote_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_configure_remote =
{
  {
    -1,
    (gchar *) "ConfigureRemote",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_configure_remote_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-configure-remote",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_configure_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_configure_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_configure_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_configure_IN_ARG_key.parent_struct,
  &_flatpak_system_helper_method_info_configure_IN_ARG_value.parent_struct,
  &_flatpak_system_helper_method_info_configure_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_configure =
{
  {
    -1,
    (gchar *) "Configure",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_configure_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-configure",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_update_remote_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_update_remote_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_update_remote_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_update_remote_IN_ARG_summary_path =
{
  {
    -1,
    (gchar *) "summary_path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_update_remote_IN_ARG_summary_sig_path =
{
  {
    -1,
    (gchar *) "summary_sig_path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_update_remote_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_update_remote_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_update_remote_IN_ARG_remote.parent_struct,
  &_flatpak_system_helper_method_info_update_remote_IN_ARG_installation.parent_struct,
  &_flatpak_system_helper_method_info_update_remote_IN_ARG_summary_path.parent_struct,
  &_flatpak_system_helper_method_info_update_remote_IN_ARG_summary_sig_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_update_remote =
{
  {
    -1,
    (gchar *) "UpdateRemote",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_update_remote_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-remote",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_remove_local_ref_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_remove_local_ref_IN_ARG_remote =
{
  {
    -1,
    (gchar *) "remote",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_remove_local_ref_IN_ARG_ref =
{
  {
    -1,
    (gchar *) "ref",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_remove_local_ref_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_remove_local_ref_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_remove_local_ref_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_remove_local_ref_IN_ARG_remote.parent_struct,
  &_flatpak_system_helper_method_info_remove_local_ref_IN_ARG_ref.parent_struct,
  &_flatpak_system_helper_method_info_remove_local_ref_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_remove_local_ref =
{
  {
    -1,
    (gchar *) "RemoveLocalRef",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_remove_local_ref_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-local-ref",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_prune_local_repo_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_prune_local_repo_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_prune_local_repo_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_prune_local_repo_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_prune_local_repo_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_prune_local_repo =
{
  {
    -1,
    (gchar *) "PruneLocalRepo",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_prune_local_repo_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-prune-local-repo",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_run_triggers_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_run_triggers_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_run_triggers_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_run_triggers_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_run_triggers_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_run_triggers =
{
  {
    -1,
    (gchar *) "RunTriggers",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_run_triggers_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-run-triggers",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_ensure_repo_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_ensure_repo_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_ensure_repo_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_ensure_repo_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_ensure_repo_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_ensure_repo =
{
  {
    -1,
    (gchar *) "EnsureRepo",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_ensure_repo_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-ensure-repo",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_update_summary_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_update_summary_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_update_summary_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_update_summary_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_update_summary_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_update_summary =
{
  {
    -1,
    (gchar *) "UpdateSummary",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_update_summary_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-summary",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_origin =
{
  {
    -1,
    (gchar *) "origin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_origin.parent_struct,
  &_flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_generate_oci_summary =
{
  {
    -1,
    (gchar *) "GenerateOciSummary",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_generate_oci_summary_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-generate-oci-summary",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_cancel_pull_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_cancel_pull_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_cancel_pull_IN_ARG_src_dir =
{
  {
    -1,
    (gchar *) "src_dir",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_cancel_pull_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_cancel_pull_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_cancel_pull_IN_ARG_installation.parent_struct,
  &_flatpak_system_helper_method_info_cancel_pull_IN_ARG_src_dir.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_cancel_pull =
{
  {
    -1,
    (gchar *) "CancelPull",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_cancel_pull_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-cancel-pull",
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_get_revokefs_fd_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_get_revokefs_fd_IN_ARG_installation =
{
  {
    -1,
    (gchar *) "installation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_get_revokefs_fd_IN_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_get_revokefs_fd_IN_ARG_flags.parent_struct,
  &_flatpak_system_helper_method_info_get_revokefs_fd_IN_ARG_installation.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_get_revokefs_fd_OUT_ARG_fd_index =
{
  {
    -1,
    (gchar *) "fd_index",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _flatpak_system_helper_method_info_get_revokefs_fd_OUT_ARG_src_dir =
{
  {
    -1,
    (gchar *) "src_dir",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _flatpak_system_helper_method_info_get_revokefs_fd_OUT_ARG_pointers[] =
{
  &_flatpak_system_helper_method_info_get_revokefs_fd_OUT_ARG_fd_index.parent_struct,
  &_flatpak_system_helper_method_info_get_revokefs_fd_OUT_ARG_src_dir.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _flatpak_system_helper_method_info_get_revokefs_fd =
{
  {
    -1,
    (gchar *) "GetRevokefsFd",
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_get_revokefs_fd_IN_ARG_pointers,
    (GDBusArgInfo **) &_flatpak_system_helper_method_info_get_revokefs_fd_OUT_ARG_pointers,
    NULL
  },
  "handle-get-revokefs-fd",
  TRUE
};

static const GDBusMethodInfo * const _flatpak_system_helper_method_info_pointers[] =
{
  &_flatpak_system_helper_method_info_deploy.parent_struct,
  &_flatpak_system_helper_method_info_deploy_appstream.parent_struct,
  &_flatpak_system_helper_method_info_uninstall.parent_struct,
  &_flatpak_system_helper_method_info_install_bundle.parent_struct,
  &_flatpak_system_helper_method_info_configure_remote.parent_struct,
  &_flatpak_system_helper_method_info_configure.parent_struct,
  &_flatpak_system_helper_method_info_update_remote.parent_struct,
  &_flatpak_system_helper_method_info_remove_local_ref.parent_struct,
  &_flatpak_system_helper_method_info_prune_local_repo.parent_struct,
  &_flatpak_system_helper_method_info_run_triggers.parent_struct,
  &_flatpak_system_helper_method_info_ensure_repo.parent_struct,
  &_flatpak_system_helper_method_info_update_summary.parent_struct,
  &_flatpak_system_helper_method_info_generate_oci_summary.parent_struct,
  &_flatpak_system_helper_method_info_cancel_pull.parent_struct,
  &_flatpak_system_helper_method_info_get_revokefs_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _flatpak_system_helper_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _flatpak_system_helper_property_info_pointers[] =
{
  &_flatpak_system_helper_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _flatpak_system_helper_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Flatpak.SystemHelper",
    (GDBusMethodInfo **) &_flatpak_system_helper_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_flatpak_system_helper_property_info_pointers,
    NULL
  },
  "system-helper",
};


/**
 * flatpak_system_helper_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Flatpak-SystemHelper.top_of_page">org.freedesktop.Flatpak.SystemHelper</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
flatpak_system_helper_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_flatpak_system_helper_interface_info.parent_struct;
}

/**
 * flatpak_system_helper_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #FlatpakSystemHelper interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
flatpak_system_helper_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * FlatpakSystemHelper:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SystemHelper.top_of_page">org.freedesktop.Flatpak.SystemHelper</link>.
 */

/**
 * FlatpakSystemHelperIface:
 * @parent_iface: The parent interface.
 * @handle_cancel_pull: Handler for the #FlatpakSystemHelper::handle-cancel-pull signal.
 * @handle_configure: Handler for the #FlatpakSystemHelper::handle-configure signal.
 * @handle_configure_remote: Handler for the #FlatpakSystemHelper::handle-configure-remote signal.
 * @handle_deploy: Handler for the #FlatpakSystemHelper::handle-deploy signal.
 * @handle_deploy_appstream: Handler for the #FlatpakSystemHelper::handle-deploy-appstream signal.
 * @handle_ensure_repo: Handler for the #FlatpakSystemHelper::handle-ensure-repo signal.
 * @handle_generate_oci_summary: Handler for the #FlatpakSystemHelper::handle-generate-oci-summary signal.
 * @handle_get_revokefs_fd: Handler for the #FlatpakSystemHelper::handle-get-revokefs-fd signal.
 * @handle_install_bundle: Handler for the #FlatpakSystemHelper::handle-install-bundle signal.
 * @handle_prune_local_repo: Handler for the #FlatpakSystemHelper::handle-prune-local-repo signal.
 * @handle_remove_local_ref: Handler for the #FlatpakSystemHelper::handle-remove-local-ref signal.
 * @handle_run_triggers: Handler for the #FlatpakSystemHelper::handle-run-triggers signal.
 * @handle_uninstall: Handler for the #FlatpakSystemHelper::handle-uninstall signal.
 * @handle_update_remote: Handler for the #FlatpakSystemHelper::handle-update-remote signal.
 * @handle_update_summary: Handler for the #FlatpakSystemHelper::handle-update-summary signal.
 * @get_version: Getter for the #FlatpakSystemHelper:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SystemHelper.top_of_page">org.freedesktop.Flatpak.SystemHelper</link>.
 */

typedef FlatpakSystemHelperIface FlatpakSystemHelperInterface;
G_DEFINE_INTERFACE (FlatpakSystemHelper, flatpak_system_helper, G_TYPE_OBJECT)

static void
flatpak_system_helper_default_init (FlatpakSystemHelperIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * FlatpakSystemHelper::handle-deploy:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_repo_path: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_ref: Argument passed by remote caller.
   * @arg_origin: Argument passed by remote caller.
   * @arg_subpaths: Argument passed by remote caller.
   * @arg_previous_ids: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Deploy">Deploy()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_deploy() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-deploy",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_deploy),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRV, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-deploy-appstream:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_repo_path: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_origin: Argument passed by remote caller.
   * @arg_arch: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.DeployAppstream">DeployAppstream()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_deploy_appstream() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-deploy-appstream",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_deploy_appstream),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-uninstall:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_ref: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Uninstall">Uninstall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_uninstall() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-uninstall",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_uninstall),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-install-bundle:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_bundle_path: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_remote: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.InstallBundle">InstallBundle()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_install_bundle() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-install-bundle",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_install_bundle),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-configure-remote:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_remote: Argument passed by remote caller.
   * @arg_config: Argument passed by remote caller.
   * @arg_gpg_key: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.ConfigureRemote">ConfigureRemote()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_configure_remote() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-configure-remote",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_configure_remote),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-configure:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_key: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Configure">Configure()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_configure() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-configure",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_configure),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-update-remote:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_remote: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   * @arg_summary_path: Argument passed by remote caller.
   * @arg_summary_sig_path: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateRemote">UpdateRemote()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_update_remote() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-remote",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_update_remote),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-remove-local-ref:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_remote: Argument passed by remote caller.
   * @arg_ref: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RemoveLocalRef">RemoveLocalRef()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_remove_local_ref() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-local-ref",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_remove_local_ref),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-prune-local-repo:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.PruneLocalRepo">PruneLocalRepo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_prune_local_repo() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prune-local-repo",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_prune_local_repo),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-run-triggers:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RunTriggers">RunTriggers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_run_triggers() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-run-triggers",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_run_triggers),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-ensure-repo:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.EnsureRepo">EnsureRepo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_ensure_repo() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-ensure-repo",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_ensure_repo),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-update-summary:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateSummary">UpdateSummary()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_update_summary() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-summary",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_update_summary),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-generate-oci-summary:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_origin: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GenerateOciSummary">GenerateOciSummary()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_generate_oci_summary() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-generate-oci-summary",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_generate_oci_summary),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-cancel-pull:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   * @arg_src_dir: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.CancelPull">CancelPull()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_cancel_pull() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel-pull",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_cancel_pull),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * FlatpakSystemHelper::handle-get-revokefs-fd:
   * @object: A #FlatpakSystemHelper.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_flags: Argument passed by remote caller.
   * @arg_installation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GetRevokefsFd">GetRevokefsFd()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call flatpak_system_helper_complete_get_revokefs_fd() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-revokefs-fd",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (FlatpakSystemHelperIface, handle_get_revokefs_fd),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_UINT, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * FlatpakSystemHelper:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Flatpak-SystemHelper.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * flatpak_system_helper_get_version: (skip)
 * @object: A #FlatpakSystemHelper.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Flatpak-SystemHelper.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
flatpak_system_helper_get_version (FlatpakSystemHelper *object)
{
  return FLATPAK_SYSTEM_HELPER_GET_IFACE (object)->get_version (object);
}

/**
 * flatpak_system_helper_set_version: (skip)
 * @object: A #FlatpakSystemHelper.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Flatpak-SystemHelper.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
flatpak_system_helper_set_version (FlatpakSystemHelper *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * flatpak_system_helper_call_deploy:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_repo_path: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_ref: Argument to pass with the method invocation.
 * @arg_origin: Argument to pass with the method invocation.
 * @arg_subpaths: Argument to pass with the method invocation.
 * @arg_previous_ids: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Deploy">Deploy()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_deploy_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_deploy_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_deploy (
    FlatpakSystemHelper *proxy,
    const gchar *arg_repo_path,
    guint arg_flags,
    const gchar *arg_ref,
    const gchar *arg_origin,
    const gchar *const *arg_subpaths,
    const gchar *const *arg_previous_ids,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Deploy",
    g_variant_new ("(^ayuss^as^ass)",
                   arg_repo_path,
                   arg_flags,
                   arg_ref,
                   arg_origin,
                   arg_subpaths,
                   arg_previous_ids,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_deploy_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_deploy().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_deploy().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_deploy_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_deploy_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_repo_path: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_ref: Argument to pass with the method invocation.
 * @arg_origin: Argument to pass with the method invocation.
 * @arg_subpaths: Argument to pass with the method invocation.
 * @arg_previous_ids: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Deploy">Deploy()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_deploy() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_deploy_sync (
    FlatpakSystemHelper *proxy,
    const gchar *arg_repo_path,
    guint arg_flags,
    const gchar *arg_ref,
    const gchar *arg_origin,
    const gchar *const *arg_subpaths,
    const gchar *const *arg_previous_ids,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Deploy",
    g_variant_new ("(^ayuss^as^ass)",
                   arg_repo_path,
                   arg_flags,
                   arg_ref,
                   arg_origin,
                   arg_subpaths,
                   arg_previous_ids,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_deploy_appstream:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_repo_path: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_origin: Argument to pass with the method invocation.
 * @arg_arch: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.DeployAppstream">DeployAppstream()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_deploy_appstream_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_deploy_appstream_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_deploy_appstream (
    FlatpakSystemHelper *proxy,
    const gchar *arg_repo_path,
    guint arg_flags,
    const gchar *arg_origin,
    const gchar *arg_arch,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeployAppstream",
    g_variant_new ("(^ayusss)",
                   arg_repo_path,
                   arg_flags,
                   arg_origin,
                   arg_arch,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_deploy_appstream_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_deploy_appstream().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_deploy_appstream().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_deploy_appstream_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_deploy_appstream_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_repo_path: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_origin: Argument to pass with the method invocation.
 * @arg_arch: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.DeployAppstream">DeployAppstream()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_deploy_appstream() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_deploy_appstream_sync (
    FlatpakSystemHelper *proxy,
    const gchar *arg_repo_path,
    guint arg_flags,
    const gchar *arg_origin,
    const gchar *arg_arch,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeployAppstream",
    g_variant_new ("(^ayusss)",
                   arg_repo_path,
                   arg_flags,
                   arg_origin,
                   arg_arch,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_uninstall:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_ref: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Uninstall">Uninstall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_uninstall_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_uninstall_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_uninstall (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_ref,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Uninstall",
    g_variant_new ("(uss)",
                   arg_flags,
                   arg_ref,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_uninstall_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_uninstall().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_uninstall().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_uninstall_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_uninstall_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_ref: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Uninstall">Uninstall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_uninstall() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_uninstall_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_ref,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Uninstall",
    g_variant_new ("(uss)",
                   arg_flags,
                   arg_ref,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_install_bundle:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_bundle_path: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.InstallBundle">InstallBundle()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_install_bundle_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_install_bundle_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_install_bundle (
    FlatpakSystemHelper *proxy,
    const gchar *arg_bundle_path,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InstallBundle",
    g_variant_new ("(^ayuss)",
                   arg_bundle_path,
                   arg_flags,
                   arg_remote,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_install_bundle_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @out_ref: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_install_bundle().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_install_bundle().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_install_bundle_finish (
    FlatpakSystemHelper *proxy,
    gchar **out_ref,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_ref);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_install_bundle_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_bundle_path: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @out_ref: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.InstallBundle">InstallBundle()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_install_bundle() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_install_bundle_sync (
    FlatpakSystemHelper *proxy,
    const gchar *arg_bundle_path,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_installation,
    gchar **out_ref,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InstallBundle",
    g_variant_new ("(^ayuss)",
                   arg_bundle_path,
                   arg_flags,
                   arg_remote,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_ref);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_configure_remote:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_config: Argument to pass with the method invocation.
 * @arg_gpg_key: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.ConfigureRemote">ConfigureRemote()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_configure_remote_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_configure_remote_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_configure_remote (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_config,
    GVariant *arg_gpg_key,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ConfigureRemote",
    g_variant_new ("(uss@ays)",
                   arg_flags,
                   arg_remote,
                   arg_config,
                   arg_gpg_key,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_configure_remote_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_configure_remote().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_configure_remote().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_configure_remote_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_configure_remote_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_config: Argument to pass with the method invocation.
 * @arg_gpg_key: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.ConfigureRemote">ConfigureRemote()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_configure_remote() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_configure_remote_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_config,
    GVariant *arg_gpg_key,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ConfigureRemote",
    g_variant_new ("(uss@ays)",
                   arg_flags,
                   arg_remote,
                   arg_config,
                   arg_gpg_key,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_configure:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Configure">Configure()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_configure_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_configure_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_configure (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_key,
    const gchar *arg_value,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Configure",
    g_variant_new ("(usss)",
                   arg_flags,
                   arg_key,
                   arg_value,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_configure_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_configure().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_configure().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_configure_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_configure_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Configure">Configure()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_configure() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_configure_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_key,
    const gchar *arg_value,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Configure",
    g_variant_new ("(usss)",
                   arg_flags,
                   arg_key,
                   arg_value,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_update_remote:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @arg_summary_path: Argument to pass with the method invocation.
 * @arg_summary_sig_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateRemote">UpdateRemote()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_update_remote_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_update_remote_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_update_remote (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_installation,
    const gchar *arg_summary_path,
    const gchar *arg_summary_sig_path,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateRemote",
    g_variant_new ("(uss^ay^ay)",
                   arg_flags,
                   arg_remote,
                   arg_installation,
                   arg_summary_path,
                   arg_summary_sig_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_update_remote_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_update_remote().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_update_remote().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_update_remote_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_update_remote_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @arg_summary_path: Argument to pass with the method invocation.
 * @arg_summary_sig_path: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateRemote">UpdateRemote()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_update_remote() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_update_remote_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_installation,
    const gchar *arg_summary_path,
    const gchar *arg_summary_sig_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateRemote",
    g_variant_new ("(uss^ay^ay)",
                   arg_flags,
                   arg_remote,
                   arg_installation,
                   arg_summary_path,
                   arg_summary_sig_path),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_remove_local_ref:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_ref: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RemoveLocalRef">RemoveLocalRef()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_remove_local_ref_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_remove_local_ref_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_remove_local_ref (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_ref,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveLocalRef",
    g_variant_new ("(usss)",
                   arg_flags,
                   arg_remote,
                   arg_ref,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_remove_local_ref_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_remove_local_ref().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_remove_local_ref().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_remove_local_ref_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_remove_local_ref_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_remote: Argument to pass with the method invocation.
 * @arg_ref: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RemoveLocalRef">RemoveLocalRef()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_remove_local_ref() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_remove_local_ref_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_remote,
    const gchar *arg_ref,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveLocalRef",
    g_variant_new ("(usss)",
                   arg_flags,
                   arg_remote,
                   arg_ref,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_prune_local_repo:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.PruneLocalRepo">PruneLocalRepo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_prune_local_repo_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_prune_local_repo_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_prune_local_repo (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PruneLocalRepo",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_prune_local_repo_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_prune_local_repo().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_prune_local_repo().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_prune_local_repo_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_prune_local_repo_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.PruneLocalRepo">PruneLocalRepo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_prune_local_repo() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_prune_local_repo_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PruneLocalRepo",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_run_triggers:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RunTriggers">RunTriggers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_run_triggers_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_run_triggers_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_run_triggers (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RunTriggers",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_run_triggers_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_run_triggers().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_run_triggers().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_run_triggers_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_run_triggers_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RunTriggers">RunTriggers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_run_triggers() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_run_triggers_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RunTriggers",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_ensure_repo:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.EnsureRepo">EnsureRepo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_ensure_repo_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_ensure_repo_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_ensure_repo (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnsureRepo",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_ensure_repo_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_ensure_repo().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_ensure_repo().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_ensure_repo_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_ensure_repo_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.EnsureRepo">EnsureRepo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_ensure_repo() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_ensure_repo_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnsureRepo",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_update_summary:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateSummary">UpdateSummary()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_update_summary_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_update_summary_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_update_summary (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateSummary",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_update_summary_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_update_summary().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_update_summary().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_update_summary_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_update_summary_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateSummary">UpdateSummary()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_update_summary() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_update_summary_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateSummary",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_generate_oci_summary:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_origin: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GenerateOciSummary">GenerateOciSummary()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_generate_oci_summary_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_generate_oci_summary_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_generate_oci_summary (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_origin,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GenerateOciSummary",
    g_variant_new ("(uss)",
                   arg_flags,
                   arg_origin,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_generate_oci_summary_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_generate_oci_summary().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_generate_oci_summary().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_generate_oci_summary_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_generate_oci_summary_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_origin: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GenerateOciSummary">GenerateOciSummary()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_generate_oci_summary() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_generate_oci_summary_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_origin,
    const gchar *arg_installation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GenerateOciSummary",
    g_variant_new ("(uss)",
                   arg_flags,
                   arg_origin,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_cancel_pull:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @arg_src_dir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.CancelPull">CancelPull()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_cancel_pull_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_cancel_pull_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_cancel_pull (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    const gchar *arg_src_dir,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CancelPull",
    g_variant_new ("(uss)",
                   arg_flags,
                   arg_installation,
                   arg_src_dir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_cancel_pull_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_cancel_pull().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_cancel_pull().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_cancel_pull_finish (
    FlatpakSystemHelper *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_cancel_pull_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @arg_src_dir: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.CancelPull">CancelPull()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_cancel_pull() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_cancel_pull_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    const gchar *arg_src_dir,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CancelPull",
    g_variant_new ("(uss)",
                   arg_flags,
                   arg_installation,
                   arg_src_dir),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_get_revokefs_fd:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GetRevokefsFd">GetRevokefsFd()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_call_get_revokefs_fd_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_call_get_revokefs_fd_sync() for the synchronous, blocking version of this method.
 */
void
flatpak_system_helper_call_get_revokefs_fd (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "GetRevokefsFd",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * flatpak_system_helper_call_get_revokefs_fd_finish:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @out_fd_index: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_src_dir: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_call_get_revokefs_fd().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with flatpak_system_helper_call_get_revokefs_fd().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_get_revokefs_fd_finish (
    FlatpakSystemHelper *proxy,
    GVariant **out_fd_index,
    gchar **out_src_dir,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hs)",
                 out_fd_index,
                 out_src_dir);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_call_get_revokefs_fd_sync:
 * @proxy: A #FlatpakSystemHelperProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_installation: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_index: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_src_dir: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GetRevokefsFd">GetRevokefsFd()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_call_get_revokefs_fd() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
flatpak_system_helper_call_get_revokefs_fd_sync (
    FlatpakSystemHelper *proxy,
    guint arg_flags,
    const gchar *arg_installation,
    GUnixFDList  *fd_list,
    GVariant **out_fd_index,
    gchar **out_src_dir,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "GetRevokefsFd",
    g_variant_new ("(us)",
                   arg_flags,
                   arg_installation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hs)",
                 out_fd_index,
                 out_src_dir);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * flatpak_system_helper_complete_deploy:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Deploy">Deploy()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_deploy (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_deploy_appstream:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.DeployAppstream">DeployAppstream()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_deploy_appstream (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_uninstall:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Uninstall">Uninstall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_uninstall (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_install_bundle:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @ref: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.InstallBundle">InstallBundle()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_install_bundle (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *ref)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   ref));
}

/**
 * flatpak_system_helper_complete_configure_remote:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.ConfigureRemote">ConfigureRemote()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_configure_remote (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_configure:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.Configure">Configure()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_configure (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_update_remote:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateRemote">UpdateRemote()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_update_remote (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_remove_local_ref:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RemoveLocalRef">RemoveLocalRef()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_remove_local_ref (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_prune_local_repo:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.PruneLocalRepo">PruneLocalRepo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_prune_local_repo (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_run_triggers:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.RunTriggers">RunTriggers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_run_triggers (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_ensure_repo:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.EnsureRepo">EnsureRepo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_ensure_repo (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_update_summary:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.UpdateSummary">UpdateSummary()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_update_summary (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_generate_oci_summary:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GenerateOciSummary">GenerateOciSummary()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_generate_oci_summary (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_cancel_pull:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.CancelPull">CancelPull()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_cancel_pull (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * flatpak_system_helper_complete_get_revokefs_fd:
 * @object: A #FlatpakSystemHelper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd_index: Parameter to return.
 * @src_dir: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Flatpak-SystemHelper.GetRevokefsFd">GetRevokefsFd()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
flatpak_system_helper_complete_get_revokefs_fd (
    FlatpakSystemHelper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd_index,
    const gchar *src_dir)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hs)",
                   fd_index,
                   src_dir),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * FlatpakSystemHelperProxy:
 *
 * The #FlatpakSystemHelperProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakSystemHelperProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakSystemHelperProxy.
 */

struct _FlatpakSystemHelperProxyPrivate
{
  GData *qdata;
};

static void flatpak_system_helper_proxy_iface_init (FlatpakSystemHelperIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakSystemHelperProxy, flatpak_system_helper_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (FlatpakSystemHelperProxy)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SYSTEM_HELPER, flatpak_system_helper_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakSystemHelperProxy, flatpak_system_helper_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SYSTEM_HELPER, flatpak_system_helper_proxy_iface_init))

#endif
static void
flatpak_system_helper_proxy_finalize (GObject *object)
{
  FlatpakSystemHelperProxy *proxy = FLATPAK_SYSTEM_HELPER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (flatpak_system_helper_proxy_parent_class)->finalize (object);
}

static void
flatpak_system_helper_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_system_helper_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
flatpak_system_helper_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Flatpak.SystemHelper: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
flatpak_system_helper_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_system_helper_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Flatpak.SystemHelper", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) flatpak_system_helper_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
flatpak_system_helper_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_flatpak_system_helper_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], FLATPAK_TYPE_SYSTEM_HELPER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_SYSTEM_HELPER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
flatpak_system_helper_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  FlatpakSystemHelperProxy *proxy = FLATPAK_SYSTEM_HELPER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_system_helper_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_system_helper_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
flatpak_system_helper_proxy_get_version (FlatpakSystemHelper *object)
{
  FlatpakSystemHelperProxy *proxy = FLATPAK_SYSTEM_HELPER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
flatpak_system_helper_proxy_init (FlatpakSystemHelperProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = flatpak_system_helper_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, FLATPAK_TYPE_SYSTEM_HELPER_PROXY, FlatpakSystemHelperProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), flatpak_system_helper_interface_info ());
}

static void
flatpak_system_helper_proxy_class_init (FlatpakSystemHelperProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = flatpak_system_helper_proxy_finalize;
  gobject_class->get_property = flatpak_system_helper_proxy_get_property;
  gobject_class->set_property = flatpak_system_helper_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = flatpak_system_helper_proxy_g_signal;
  proxy_class->g_properties_changed = flatpak_system_helper_proxy_g_properties_changed;

  flatpak_system_helper_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakSystemHelperProxyPrivate));
#endif
}

static void
flatpak_system_helper_proxy_iface_init (FlatpakSystemHelperIface *iface)
{
  iface->get_version = flatpak_system_helper_proxy_get_version;
}

/**
 * flatpak_system_helper_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SystemHelper.top_of_page">org.freedesktop.Flatpak.SystemHelper</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_proxy_new_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_system_helper_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_SYSTEM_HELPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SystemHelper", NULL);
}

/**
 * flatpak_system_helper_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_system_helper_proxy_new().
 *
 * Returns: (transfer full) (type FlatpakSystemHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSystemHelper *
flatpak_system_helper_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_SYSTEM_HELPER (ret);
  else
    return NULL;
}

/**
 * flatpak_system_helper_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SystemHelper.top_of_page">org.freedesktop.Flatpak.SystemHelper</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakSystemHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSystemHelper *
flatpak_system_helper_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_SYSTEM_HELPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SystemHelper", NULL);
  if (ret != NULL)
    return FLATPAK_SYSTEM_HELPER (ret);
  else
    return NULL;
}


/**
 * flatpak_system_helper_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like flatpak_system_helper_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call flatpak_system_helper_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See flatpak_system_helper_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
flatpak_system_helper_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (FLATPAK_TYPE_SYSTEM_HELPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SystemHelper", NULL);
}

/**
 * flatpak_system_helper_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to flatpak_system_helper_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with flatpak_system_helper_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type FlatpakSystemHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSystemHelper *
flatpak_system_helper_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return FLATPAK_SYSTEM_HELPER (ret);
  else
    return NULL;
}

/**
 * flatpak_system_helper_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like flatpak_system_helper_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See flatpak_system_helper_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type FlatpakSystemHelperProxy): The constructed proxy object or %NULL if @error is set.
 */
FlatpakSystemHelper *
flatpak_system_helper_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (FLATPAK_TYPE_SYSTEM_HELPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Flatpak.SystemHelper", NULL);
  if (ret != NULL)
    return FLATPAK_SYSTEM_HELPER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * FlatpakSystemHelperSkeleton:
 *
 * The #FlatpakSystemHelperSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * FlatpakSystemHelperSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #FlatpakSystemHelperSkeleton.
 */

struct _FlatpakSystemHelperSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_flatpak_system_helper_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], FLATPAK_TYPE_SYSTEM_HELPER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, FLATPAK_TYPE_SYSTEM_HELPER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_flatpak_system_helper_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_system_helper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_flatpak_system_helper_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_flatpak_system_helper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _flatpak_system_helper_skeleton_vtable =
{
  _flatpak_system_helper_skeleton_handle_method_call,
  _flatpak_system_helper_skeleton_handle_get_property,
  _flatpak_system_helper_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
flatpak_system_helper_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return flatpak_system_helper_interface_info ();
}

static GDBusInterfaceVTable *
flatpak_system_helper_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_flatpak_system_helper_skeleton_vtable;
}

static GVariant *
flatpak_system_helper_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_flatpak_system_helper_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _flatpak_system_helper_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _flatpak_system_helper_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _flatpak_system_helper_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Flatpak.SystemHelper", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _flatpak_system_helper_emit_changed (gpointer user_data);

static void
flatpak_system_helper_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _flatpak_system_helper_emit_changed (skeleton);
}

static void flatpak_system_helper_skeleton_iface_init (FlatpakSystemHelperIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (FlatpakSystemHelperSkeleton, flatpak_system_helper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (FlatpakSystemHelperSkeleton)
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SYSTEM_HELPER, flatpak_system_helper_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (FlatpakSystemHelperSkeleton, flatpak_system_helper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (FLATPAK_TYPE_SYSTEM_HELPER, flatpak_system_helper_skeleton_iface_init))

#endif
static void
flatpak_system_helper_skeleton_finalize (GObject *object)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (flatpak_system_helper_skeleton_parent_class)->finalize (object);
}

static void
flatpak_system_helper_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_flatpak_system_helper_emit_changed (gpointer user_data)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Flatpak.SystemHelper",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_flatpak_system_helper_schedule_emit_changed (FlatpakSystemHelperSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
flatpak_system_helper_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _flatpak_system_helper_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _flatpak_system_helper_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
flatpak_system_helper_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _flatpak_system_helper_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _flatpak_system_helper_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
flatpak_system_helper_skeleton_init (FlatpakSystemHelperSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = flatpak_system_helper_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, FLATPAK_TYPE_SYSTEM_HELPER_SKELETON, FlatpakSystemHelperSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
flatpak_system_helper_skeleton_get_version (FlatpakSystemHelper *object)
{
  FlatpakSystemHelperSkeleton *skeleton = FLATPAK_SYSTEM_HELPER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
flatpak_system_helper_skeleton_class_init (FlatpakSystemHelperSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = flatpak_system_helper_skeleton_finalize;
  gobject_class->get_property = flatpak_system_helper_skeleton_get_property;
  gobject_class->set_property = flatpak_system_helper_skeleton_set_property;
  gobject_class->notify       = flatpak_system_helper_skeleton_notify;


  flatpak_system_helper_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = flatpak_system_helper_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = flatpak_system_helper_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = flatpak_system_helper_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = flatpak_system_helper_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (FlatpakSystemHelperSkeletonPrivate));
#endif
}

static void
flatpak_system_helper_skeleton_iface_init (FlatpakSystemHelperIface *iface)
{
  iface->get_version = flatpak_system_helper_skeleton_get_version;
}

/**
 * flatpak_system_helper_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Flatpak-SystemHelper.top_of_page">org.freedesktop.Flatpak.SystemHelper</link>.
 *
 * Returns: (transfer full) (type FlatpakSystemHelperSkeleton): The skeleton object.
 */
FlatpakSystemHelper *
flatpak_system_helper_skeleton_new (void)
{
  return FLATPAK_SYSTEM_HELPER (g_object_new (FLATPAK_TYPE_SYSTEM_HELPER_SKELETON, NULL));
}

