
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 1953
 * transforms:
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul', 'a@16', 0.0) => 0.0
 *    ('fmul', 'a@32', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('f2f16', ('f2f32', 'a@16')) => a
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('f2f16', ('f2f64', 'a@16')) => a
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('f2f32', ('f2f64', 'a@32')) => a
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a')
 *    ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z'))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z'))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z'))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z'))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', 0) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', True) => True
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0)
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('i2b', ('ubfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('i2b', ('ibfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ufind_msb', 'value') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('pack_32_2x16_split', 'a@16', 'b@16') => ('ior', ('ishl', ('u2u32', 'b'), 16), ('u2u32', 'a'))
 *    ('unpack_32_2x16_split_x', 'a@32') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a@32') => ('u2u16', ('ushr', 'a', 16))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('fcsel', ('slt', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('fcsel', ('slt', 'a', 0), 'b', 'c') => ('fcsel_gt', ('fneg', 'a'), 'b', 'c')
 *    ('fcsel', ('sge', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('fcsel', ('sge', 0, 'a'), 'b', 'c') => ('fcsel_ge', ('fneg', 'a'), 'b', 'c')
 *    ('bcsel', ('ilt', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('ilt', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('ige', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('ige', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('flt', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('flt', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_gt', ('fneg', 'a'), 'b', 'c')
 *    ('bcsel', ('fge', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('fge', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_ge', ('fneg', 'a'), 'b', 'c')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b8', ('b2f', 'a@8')) => a
 *    ('i2b8', ('b2i', 'a@8')) => a
 *    ('f2b16', ('b2f', 'a@16')) => a
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80 /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 6, 7 },
      -1,
   } },

   /* replace1_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7 /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 9 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000 /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 11, 12 },
      -1,
   } },

   /* replace2_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xf /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 14 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000 /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 17 },
      -1,
   } },

   /* replace3_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1f /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 19 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 22 },
      -1,
   } },

   /* replace4_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3f /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 24 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search5_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 26 },
      -1,
   } },

   /* replace5_0_0 -> 0 in the cache */
   /* replace5_0_1_0_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 28 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 30 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 33 },
      -1,
   } },

   /* replace6_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 35, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 37 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search7_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 39 },
      -1,
   } },

   /* replace7_0_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 42 },
      -1,
   } },
   /* replace7_1_0 -> 21 in the cache */
   /* replace7_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 43, 45 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search8_0_0 -> 16 in the cache */
   /* search8_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 47 },
      -1,
   } },

   /* replace8_0 -> 16 in the cache */
   /* replace8_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search9_0_0 -> 16 in the cache */
   /* search9_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 50 },
      -1,
   } },

   /* replace9_0 -> 16 in the cache */
   /* replace9_1 -> 36 in the cache */
   /* replace9 -> 49 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search10_0 -> 16 in the cache */
   /* search10_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace10_0_0 -> 16 in the cache */
   /* replace10_0_1 -> 36 in the cache */
   /* replace10_0 -> 49 in the cache */
   /* replace10_1_0 -> 16 in the cache */
   /* replace10_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 53 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search11_0 -> 16 in the cache */
   /* search11_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace11_0_0 -> 16 in the cache */
   /* replace11_0_1 -> 36 in the cache */
   /* replace11_0 -> 49 in the cache */
   /* replace11_1_0 -> 16 in the cache */
   /* replace11_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 56 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search12_0 -> 32 in the cache */
   /* search12_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace12 -> 32 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search13_0 -> 32 in the cache */
   /* search13_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace13 -> 32 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search14_0 -> 32 in the cache */
   /* search14_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0 /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search15_0 -> 32 in the cache */
   /* search15_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace15 -> 61 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search16_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace16 -> 61 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search17_0 -> 32 in the cache */
   /* search17_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace17 -> 61 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search18_0 -> 32 in the cache */
   /* search18_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace18 -> 61 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search19_0 -> 0 in the cache */
   /* search19_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace19_0 -> 0 in the cache */
   /* replace19_1_0 -> 3 in the cache */
   /* replace19_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search20_0 -> 0 in the cache */
   /* search20_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace20_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_1_0 -> 3 in the cache */
   /* replace20_1_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 4 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 72 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search21_0 -> 0 in the cache */
   /* search21_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace21_0_0_0 -> 0 in the cache */
   /* replace21_0_0 -> 70 in the cache */
   /* replace21_0_1_0_0 -> 0 in the cache */
   /* replace21_0_1_0 -> 71 in the cache */
   /* replace21_0_1_1_0_0 -> 3 in the cache */
   /* replace21_0_1_1_0 -> 28 in the cache */
   /* replace21_0_1_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 75 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 76 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search22_0 -> 0 in the cache */
   /* search22_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace22_0 -> 0 in the cache */
   /* replace22_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 3, 79 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 80 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 3 in the cache */
   /* replace23_1_1 -> 79 in the cache */
   /* replace23_1 -> 80 in the cache */
   /* replace23 -> 81 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace24_0_0_0 -> 0 in the cache */
   /* replace24_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* replace24_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 84, 3 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   /* replace24_2_0 -> 0 in the cache */
   /* replace24_2_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 85, 86, 87 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace25_0 -> 0 in the cache */
   /* replace25_1_0_0_0 -> 0 in the cache */
   /* replace25_1_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 86 },
      -1,
   } },
   /* replace25_1_0_1_0 -> 0 in the cache */
   /* replace25_1_0_1_1_0 -> 3 in the cache */
   /* replace25_1_0_1_1_1 -> 79 in the cache */
   /* replace25_1_0_1_1 -> 80 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 80 },
      -1,
   } },
   /* replace25_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 90, 91, 0 },
      -1,
   } },
   /* replace25_1_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 92, 93 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 94 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 3 in the cache */
   /* replace26_1 -> 28 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 28 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search27_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace27 -> 32 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search28_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace28 -> 32 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search29_0_0 -> 32 in the cache */
   /* search29_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace29_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search30_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 104 },
      -1,
   } },

   /* replace30_0 -> 32 in the cache */
   /* replace30 -> 104 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search31_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 106 },
      -1,
   } },

   /* replace31_0 -> 32 in the cache */
   /* replace31 -> 106 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search32_0_0 -> 32 in the cache */
   /* search32_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace32_0 -> 32 in the cache */
   /* replace32 -> 106 in the cache */

   /* ('f2b', ('fneg', 'a')) => ('f2b', 'a') */
   /* search33_0_0 -> 32 in the cache */
   /* search33_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace33_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2b', ('ineg', 'a')) => ('i2b', 'a') */
   /* search34_0_0 -> 32 in the cache */
   /* search34_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace34_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~fadd', 'a', 0.0) => a */
   /* search35_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace35 -> 32 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a */
   /* search36_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 115 },
      1,
   } },

   /* replace36 -> 11 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a */
   /* search37_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 117 },
      1,
   } },

   /* replace37 -> 16 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search38_0 -> 32 in the cache */
   /* search38_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace38 -> 32 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search39_0 -> 32 in the cache */
   /* search39_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace39 -> 32 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search40_0 -> 32 in the cache */
   /* search40_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_isub_sat,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* replace40 -> 32 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search41_0 -> 32 in the cache */
   /* search41_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace41 -> 32 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search42_0 -> 32 in the cache */
   /* search42_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_usub_sat,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* replace42 -> 32 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search43_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 124 },
      -1,
   } },

   /* replace43 -> 16 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search44_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 126 },
      -1,
   } },

   /* replace44 -> 126 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search45_1_0 -> 128 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 130, 132 },
      -1,
   } },

   /* replace45_0 -> 128 in the cache */
   /* replace45_1_0 -> 129 in the cache */
   /* replace45_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 128, 134 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search46_0_0 -> 16 in the cache */
   /* search46_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* search46_1_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 16, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 136, 138 },
      -1,
   } },

   /* replace46_0 -> 16 in the cache */
   /* replace46_1_0 -> 36 in the cache */
   /* replace46_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 16, 140 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search47_0 -> 0 in the cache */
   /* search47_1 -> 3 in the cache */
   /* search47_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 142, 143 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 144 },
      -1,
   } },

   /* replace47_0 -> 0 in the cache */
   /* replace47_1_0 -> 3 in the cache */
   /* replace47_1_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 3, 142 },
      -1,
   } },
   /* replace47_2 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 146, 143 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search48_0 -> 0 in the cache */
   /* search48_1 -> 3 in the cache */
   /* search48_2_0 -> 0 in the cache */
   /* search48_2_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 142 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 148 },
      -1,
   } },

   /* replace48_0 -> 0 in the cache */
   /* replace48_1_0 -> 3 in the cache */
   /* replace48_1_1 -> 142 in the cache */
   /* replace48_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 146 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 151, 152 },
      0,
   } },
   /* search49_1_0 -> 151 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 151, 154, 155 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 153, 156 },
      -1,
   } },

   /* replace49_0 -> 151 in the cache */
   /* replace49_1_0 -> 152 in the cache */
   /* replace49_1_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 152, 154 },
      -1,
   } },
   /* replace49_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 151, 158, 155 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search50_0 -> 151 in the cache */
   /* search50_1_0 -> 152 in the cache */
   /* search50_1_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 152, 154 },
      0,
   } },
   /* search50_2_0 -> 152 in the cache */
   /* search50_2_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 152, 155 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 151, 160, 161 },
      -1,
   } },

   /* replace50_0 -> 152 in the cache */
   /* replace50_1_0 -> 151 in the cache */
   /* replace50_1_1 -> 154 in the cache */
   /* replace50_1_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 151, 154, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 152, 163 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search51_0 -> 16 in the cache */
   /* search51_1 -> 36 in the cache */
   /* search51_2_0 -> 16 in the cache */
   /* search51_2_1 -> 137 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 137, 165 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 166 },
      -1,
   } },

   /* replace51_0 -> 16 in the cache */
   /* replace51_1_0 -> 36 in the cache */
   /* replace51_1_1 -> 137 in the cache */
   /* replace51_1 -> 140 in the cache */
   /* replace51_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 140, 165 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search52_0 -> 16 in the cache */
   /* search52_1 -> 36 in the cache */
   /* search52_2_0 -> 16 in the cache */
   /* search52_2_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 137 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 169 },
      -1,
   } },

   /* replace52_0 -> 16 in the cache */
   /* replace52_1_0 -> 36 in the cache */
   /* replace52_1_1 -> 137 in the cache */
   /* replace52_1 -> 140 in the cache */
   /* replace52 -> 141 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search53_0_0 -> 16 in the cache */
   /* search53_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      0,
   } },
   /* search53_1_0 -> 16 in the cache */
   /* search53_1_1 -> 137 in the cache */
   /* search53_1_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 16, 137, 165 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 171, 172 },
      -1,
   } },

   /* replace53_0 -> 16 in the cache */
   /* replace53_1_0 -> 36 in the cache */
   /* replace53_1_1 -> 137 in the cache */
   /* replace53_1 -> 140 in the cache */
   /* replace53_2 -> 165 in the cache */
   /* replace53 -> 168 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search54_0 -> 16 in the cache */
   /* search54_1_0 -> 36 in the cache */
   /* search54_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 36, 137 },
      0,
   } },
   /* search54_2_0 -> 36 in the cache */
   /* search54_2_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 36, 165 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 16, 174, 175 },
      -1,
   } },

   /* replace54_0 -> 36 in the cache */
   /* replace54_1_0 -> 16 in the cache */
   /* replace54_1_1 -> 137 in the cache */
   /* replace54_1_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 137, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 36, 177 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search55_0_0 -> 128 in the cache */
   /* search55_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search55_1_0 -> 128 in the cache */
   /* search55_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 179, 180 },
      -1,
   } },

   /* replace55_0 -> 128 in the cache */
   /* replace55_1_0 -> 129 in the cache */
   /* replace55_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 128, 182 },
      -1,
   } },

   /* ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search56_0_0 -> 128 in the cache */
   /* search56_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search56_1_0 -> 128 in the cache */
   /* search56_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 184, 185 },
      -1,
   } },

   /* replace56_0 -> 128 in the cache */
   /* replace56_1_0 -> 129 in the cache */
   /* replace56_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 128, 187 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search57_0_0 -> 128 in the cache */
   /* search57_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* search57_1_0 -> 128 in the cache */
   /* search57_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 189, 190 },
      -1,
   } },

   /* replace57_0 -> 128 in the cache */
   /* replace57_1_0 -> 129 in the cache */
   /* replace57_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 128, 192 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search58_0_0 -> 32 in the cache */
   /* search58_0 -> 98 in the cache */
   /* search58_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace58 -> 113 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search59_0_0 -> 32 in the cache */
   /* search59_0 -> 100 in the cache */
   /* search59_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 100, 32 },
      -1,
   } },

   /* replace59 -> 61 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search60_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search60_1_0 -> 0 in the cache */
   /* search60_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 196, 197 },
      -1,
   } },

   /* replace60 -> 3 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search61_0 -> 0 in the cache */
   /* search61_1_0_0 -> 0 in the cache */
   /* search61_1_0 -> 196 in the cache */
   /* search61_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 196, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 199 },
      -1,
   } },

   /* replace61 -> 3 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search62_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search62_1_0 -> 0 in the cache */
   /* search62_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 201, 202 },
      -1,
   } },

   /* replace62 -> 3 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search63_0 -> 0 in the cache */
   /* search63_1_0_0 -> 0 in the cache */
   /* search63_1_0 -> 201 in the cache */
   /* search63_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 201, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 204 },
      -1,
   } },

   /* replace63 -> 3 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search64_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search64_1_0_0 -> 32 in the cache */
   /* search64_1_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 206, 207 },
      -1,
   } },

   /* replace64_0_0 -> 32 in the cache */
   /* replace64_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 103 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search65_0 -> 32 in the cache */
   /* search65_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace65 -> 113 in the cache */

   /* ('fmul', 'a@16', 0.0) => 0.0 */
   /* search66_0 -> 11 in the cache */
   /* search66_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 115 },
      -1,
   } },

   /* replace66 -> 115 in the cache */

   /* ('fmul', 'a@32', 0.0) => 0.0 */
   /* search67_0 -> 16 in the cache */
   /* search67_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace67 -> 117 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search68_0 -> 16 in the cache */
   /* search68_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace68 -> 117 in the cache */

   /* ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search69_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 214 },
      -1,
   } },

   /* replace69_0 -> 16 in the cache */
   /* replace69_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 217, 218 },
      -1,
   } },

   /* replace70_0 -> 16 in the cache */
   /* replace70_1 -> 36 in the cache */
   /* replace70 -> 216 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search71_0 -> 16 in the cache */
   /* search71_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* replace71_0 -> 16 in the cache */
   /* replace71_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search72_0 -> 16 in the cache */
   /* search72_1 -> 214 in the cache */
   /* search72_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 214, 137 },
      -1,
   } },

   /* replace72_0 -> 16 in the cache */
   /* replace72_1 -> 36 in the cache */
   /* replace72_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search73_0 -> 217 in the cache */
   /* search73_1 -> 218 in the cache */
   /* search73_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 217, 218, 137 },
      -1,
   } },

   /* replace73_0 -> 16 in the cache */
   /* replace73_1 -> 36 in the cache */
   /* replace73_2 -> 137 in the cache */
   /* replace73 -> 223 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search74_0 -> 16 in the cache */
   /* search74_1 -> 16 in the cache */
   /* search74_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* replace74_0 -> 16 in the cache */
   /* replace74_1 -> 16 in the cache */
   /* replace74_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search75_0 -> 32 in the cache */
   /* search75_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace75 -> 61 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search76_0 -> 16 in the cache */
   /* search76_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 124 },
      -1,
   } },

   /* replace76 -> 124 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search77_0 -> 16 in the cache */
   /* search77_1 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 126 },
      -1,
   } },

   /* replace77 -> 16 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search78_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 230 },
      -1,
   } },

   /* replace78 -> 32 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search79_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 232 },
      -1,
   } },

   /* replace79 -> 16 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search80_0 -> 32 in the cache */
   /* search80_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 230 },
      1,
   } },

   /* replace80 -> 32 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search81_0 -> 32 in the cache */
   /* search81_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 35 },
      -1,
   } },

   /* replace81 -> 32 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search82_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 236 },
      -1,
   } },

   /* replace82_0 -> 32 in the cache */
   /* replace82 -> 98 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search83_0 -> 32 in the cache */
   /* search83_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace83_0 -> 32 in the cache */
   /* replace83 -> 100 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search84_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search84_1_0 -> 32 in the cache */
   /* search84_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 239, 240 },
      -1,
   } },

   /* replace84_0_0 -> 32 in the cache */
   /* replace84_0 -> 103 in the cache */
   /* replace84_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 103, 32 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search85_0_0_0 -> 32 in the cache */
   /* search85_0_0 -> 239 in the cache */
   /* search85_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 239, 32 },
      -1,
   } },
   /* search85_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 243, 32 },
      -1,
   } },

   /* replace85_0_0 -> 32 in the cache */
   /* replace85_0 -> 103 in the cache */
   /* replace85_1 -> 32 in the cache */
   /* replace85 -> 242 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search86_1 -> 0 in the cache */
   /* search86_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 245, 0, 3 },
      -1,
   } },

   /* replace86 -> 3 in the cache */

   /* ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search87_0 -> 115 in the cache */
   /* search87_1 -> 11 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 115, 11, 247 },
      1,
   } },

   /* replace87 -> 247 in the cache */

   /* ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search88_0 -> 117 in the cache */
   /* search88_1 -> 16 in the cache */
   /* search88_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 117, 16, 36 },
      1,
   } },

   /* replace88 -> 36 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search89_0 -> 117 in the cache */
   /* search89_1 -> 16 in the cache */
   /* search89_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 117, 16, 36 },
      -1,
   } },

   /* replace89_0 -> 117 in the cache */
   /* replace89_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 117, 36 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search90_0 -> 0 in the cache */
   /* search90_1 -> 3 in the cache */
   /* search90_2 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 3, 245 },
      -1,
   } },

   /* replace90_0 -> 0 in the cache */
   /* replace90_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search91_0 -> 11 in the cache */
   /* search91_1 -> 247 in the cache */
   /* search91_2 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 247, 115 },
      -1,
   } },

   /* replace91_0 -> 11 in the cache */
   /* replace91_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 247 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search92_0 -> 16 in the cache */
   /* search92_1 -> 36 in the cache */
   /* search92_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace92_0 -> 16 in the cache */
   /* replace92_1 -> 36 in the cache */
   /* replace92 -> 216 in the cache */

   /* ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search93_0 -> 16 in the cache */
   /* search93_1 -> 36 in the cache */
   /* search93_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace93_0 -> 16 in the cache */
   /* replace93_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search94_1 -> 0 in the cache */
   /* search94_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 259, 0, 3 },
      -1,
   } },

   /* replace94_0 -> 0 in the cache */
   /* replace94_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search95_0 -> 232 in the cache */
   /* search95_1 -> 16 in the cache */
   /* search95_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 232, 16, 36 },
      -1,
   } },

   /* replace95_0 -> 16 in the cache */
   /* replace95_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search96_1 -> 0 in the cache */
   /* search96_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 264, 0, 3 },
      -1,
   } },

   /* replace96_0_0 -> 0 in the cache */
   /* replace96_0 -> 201 in the cache */
   /* replace96_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 201, 3 },
      -1,
   } },

   /* ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search97_1 -> 16 in the cache */
   /* search97_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 267, 16, 36 },
      -1,
   } },

   /* replace97_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 16 },
      -1,
   } },
   /* replace97_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 269, 36 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search98_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 271, 272, 131 },
      -1,
   } },

   /* replace98_0_0 -> 128 in the cache */
   /* replace98_0_1 -> 129 in the cache */
   /* replace98_0 -> 130 in the cache */
   /* replace98_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 130, 131 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search99_1 -> 33 in the cache */
   /* search99_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 275, 33, 137 },
      -1,
   } },

   /* replace99_0_0 -> 16 in the cache */
   /* replace99_0_1 -> 36 in the cache */
   /* replace99_0 -> 136 in the cache */
   /* replace99_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 136, 137 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search100_0 -> 0 in the cache */
   /* search100_1 -> 3 in the cache */
   /* search100_2 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 245 },
      -1,
   } },

   /* replace100 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search101_0 -> 0 in the cache */
   /* search101_1 -> 3 in the cache */
   /* search101_2 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 259 },
      -1,
   } },

   /* replace101 -> 3 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search102_0 -> 0 in the cache */
   /* search102_1 -> 0 in the cache */
   /* search102_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 3 },
      -1,
   } },

   /* replace102 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search103_0 -> 245 in the cache */
   /* search103_1 -> 0 in the cache */
   /* search103_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 245, 0, 3 },
      -1,
   } },

   /* replace103_0 -> 0 in the cache */
   /* replace103_1 -> 3 in the cache */
   /* replace103 -> 253 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search104_0 -> 128 in the cache */
   /* search104_1_0 -> 128 in the cache */
   /* search104_1_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 128, 129 },
      0,
   } },
   /* search104_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 128, 282, 131 },
      -1,
   } },

   /* replace104_0_0 -> 129 in the cache */
   /* replace104_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 129, 131 },
      -1,
   } },
   /* replace104_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 284, 128 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search105_0 -> 16 in the cache */
   /* search105_1 -> 124 in the cache */
   /* search105_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace105 -> 36 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search106_0 -> 16 in the cache */
   /* search106_1 -> 124 in the cache */
   /* search106_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace106 -> 36 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search107_0 -> 16 in the cache */
   /* search107_1 -> 124 in the cache */
   /* search107_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace107 -> 36 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search108_0 -> 16 in the cache */
   /* search108_1 -> 124 in the cache */
   /* search108_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace108 -> 36 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search109_0 -> 16 in the cache */
   /* search109_1 -> 124 in the cache */
   /* search109_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace109 -> 36 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search110_0 -> 16 in the cache */
   /* search110_1 -> 124 in the cache */
   /* search110_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace110 -> 36 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search111_0 -> 16 in the cache */
   /* search111_1 -> 124 in the cache */
   /* search111_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace111 -> 36 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search112_0 -> 16 in the cache */
   /* search112_1 -> 124 in the cache */
   /* search112_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 124, 36 },
      -1,
   } },

   /* replace112 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search113_0 -> 16 in the cache */
   /* search113_1 -> 124 in the cache */
   /* search113_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 124, 36 },
      -1,
   } },

   /* replace113 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search114_0 -> 124 in the cache */
   /* search114_1 -> 16 in the cache */
   /* search114_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 124, 16, 36 },
      -1,
   } },

   /* replace114 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search115_0 -> 16 in the cache */
   /* search115_1 -> 124 in the cache */
   /* search115_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 124, 36 },
      -1,
   } },

   /* replace115 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search116_0 -> 124 in the cache */
   /* search116_1 -> 16 in the cache */
   /* search116_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 124, 16, 36 },
      -1,
   } },

   /* replace116 -> 36 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search117_0_0 -> 16 in the cache */
   /* search117_0_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 298 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 299, 300 },
      -1,
   } },

   /* replace117_0 -> 16 in the cache */
   /* replace117_1 -> 36 in the cache */
   /* replace117_2_0 -> 137 in the cache */
   /* replace117_2_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 137, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 16, 36, 302 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search118_0_0 -> 16 in the cache */
   /* search118_0_1 -> 36 in the cache */
   /* search118_0_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 298 },
      0,
   } },
   /* search118_1 -> 300 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 304, 300 },
      -1,
   } },

   /* replace118_0 -> 16 in the cache */
   /* replace118_1 -> 36 in the cache */
   /* replace118_2_0 -> 137 in the cache */
   /* replace118_2_1 -> 165 in the cache */
   /* replace118_2 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 16, 36, 302 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search119_0_0 -> 16 in the cache */
   /* search119_0_1 -> 36 in the cache */
   /* search119_0_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 298 },
      0,
   } },
   /* search119_1 -> 300 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 307, 300 },
      -1,
   } },

   /* replace119_0 -> 16 in the cache */
   /* replace119_1 -> 36 in the cache */
   /* replace119_2_0 -> 137 in the cache */
   /* replace119_2_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 137, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 16, 36, 309 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search120_0_0 -> 16 in the cache */
   /* search120_0_1 -> 36 in the cache */
   /* search120_0_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 298 },
      0,
   } },
   /* search120_1 -> 300 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 311, 300 },
      -1,
   } },

   /* replace120_0 -> 16 in the cache */
   /* replace120_1 -> 36 in the cache */
   /* replace120_2_0 -> 137 in the cache */
   /* replace120_2_1 -> 165 in the cache */
   /* replace120_2 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 16, 36, 302 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search121_0_0 -> 16 in the cache */
   /* search121_0_1 -> 36 in the cache */
   /* search121_0_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 298 },
      0,
   } },
   /* search121_1 -> 300 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 314, 300 },
      -1,
   } },

   /* replace121_0 -> 16 in the cache */
   /* replace121_1 -> 36 in the cache */
   /* replace121_2_0 -> 137 in the cache */
   /* replace121_2_1 -> 165 in the cache */
   /* replace121_2 -> 302 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 16, 36, 302 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search122_0_1 -> 36 in the cache */
   /* search122_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 317, 36, 124 },
      -1,
   } },
   /* search122_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 318, 137 },
      -1,
   } },

   /* replace122_0 -> 16 in the cache */
   /* replace122_1 -> 36 in the cache */
   /* replace122_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search123_0_0 -> 317 in the cache */
   /* search123_0_1 -> 36 in the cache */
   /* search123_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 317, 36, 124 },
      -1,
   } },
   /* search123_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 321, 137 },
      -1,
   } },

   /* replace123_0 -> 16 in the cache */
   /* replace123_1 -> 36 in the cache */
   /* replace123_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search124_0_0 -> 317 in the cache */
   /* search124_0_1 -> 36 in the cache */
   /* search124_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 317, 36, 124 },
      -1,
   } },
   /* search124_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 324, 137 },
      -1,
   } },

   /* replace124_0 -> 16 in the cache */
   /* replace124_1 -> 36 in the cache */
   /* replace124_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search125_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search125_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 327, 124 },
      -1,
   } },
   /* search125_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 328, 137 },
      -1,
   } },

   /* replace125_0 -> 16 in the cache */
   /* replace125_1 -> 36 in the cache */
   /* replace125_2 -> 137 in the cache */
   /* replace125 -> 326 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search126_0_0 -> 317 in the cache */
   /* search126_0_1 -> 36 in the cache */
   /* search126_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 317, 36, 124 },
      -1,
   } },
   /* search126_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 330, 137 },
      -1,
   } },

   /* replace126_0 -> 16 in the cache */
   /* replace126_1 -> 36 in the cache */
   /* replace126_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search127_0_0 -> 317 in the cache */
   /* search127_0_1 -> 36 in the cache */
   /* search127_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 317, 36, 124 },
      -1,
   } },
   /* search127_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 333, 137 },
      -1,
   } },

   /* replace127_0 -> 16 in the cache */
   /* replace127_1 -> 36 in the cache */
   /* replace127_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search128_0 -> 275 in the cache */
   /* search128_1 -> 33 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace128_0_0 -> 16 in the cache */
   /* replace128_0_1 -> 36 in the cache */
   /* replace128_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace128_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 338, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search129_0 -> 275 in the cache */
   /* search129_1 -> 33 in the cache */
   /* search129_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace129_0_0 -> 16 in the cache */
   /* replace129_0_1 -> 36 in the cache */
   /* replace129_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace129_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 341, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search130_0 -> 275 in the cache */
   /* search130_1 -> 33 in the cache */
   /* search130_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 275, 33, 336 },
      -1,
   } },

   /* replace130_0_0 -> 16 in the cache */
   /* replace130_0_1 -> 36 in the cache */
   /* replace130_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 124 },
      -1,
   } },
   /* replace130_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 344, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search131_0 -> 275 in the cache */
   /* search131_1 -> 33 in the cache */
   /* search131_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace131_0_0 -> 16 in the cache */
   /* replace131_0_1 -> 36 in the cache */
   /* replace131_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace131_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 347, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search132_0 -> 275 in the cache */
   /* search132_1 -> 33 in the cache */
   /* search132_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace132_0_0 -> 16 in the cache */
   /* replace132_0_1 -> 36 in the cache */
   /* replace132_0_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 124 },
      -1,
   } },
   /* replace132_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 350, 137 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search133_0 -> 275 in the cache */
   /* search133_1 -> 33 in the cache */
   /* search133_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace133_0_0 -> 16 in the cache */
   /* replace133_0_1 -> 36 in the cache */
   /* replace133_0_2 -> 124 in the cache */
   /* replace133_0 -> 338 in the cache */
   /* replace133_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 338, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search134_0 -> 275 in the cache */
   /* search134_1 -> 33 in the cache */
   /* search134_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace134_0_0 -> 16 in the cache */
   /* replace134_0_1 -> 36 in the cache */
   /* replace134_0_2 -> 124 in the cache */
   /* replace134_0 -> 341 in the cache */
   /* replace134_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 341, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search135_0 -> 275 in the cache */
   /* search135_1 -> 33 in the cache */
   /* search135_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 275, 33, 336 },
      -1,
   } },

   /* replace135_0_0 -> 16 in the cache */
   /* replace135_0_1 -> 36 in the cache */
   /* replace135_0_2 -> 124 in the cache */
   /* replace135_0 -> 344 in the cache */
   /* replace135_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 344, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search136_0 -> 275 in the cache */
   /* search136_1 -> 33 in the cache */
   /* search136_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace136_0_0 -> 16 in the cache */
   /* replace136_0_1 -> 36 in the cache */
   /* replace136_0_2 -> 124 in the cache */
   /* replace136_0 -> 347 in the cache */
   /* replace136_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 347, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search137_0 -> 275 in the cache */
   /* search137_1 -> 33 in the cache */
   /* search137_2 -> 336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 275, 33, 336 },
      -1,
   } },

   /* replace137_0_0 -> 16 in the cache */
   /* replace137_0_1 -> 36 in the cache */
   /* replace137_0_2 -> 124 in the cache */
   /* replace137_0 -> 350 in the cache */
   /* replace137_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 350, 137 },
      -1,
   } },

   /* ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search138_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 362, 117 },
      -1,
   } },
   /* search138_0_1 -> 117 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 363, 117, 364 },
      -1,
   } },
   /* search138_1_0_0 -> 364 in the cache */
   /* search138_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      2, 1,
      { 364, 117 },
      -1,
   } },
   /* search138_1_1 -> 117 in the cache */
   /* search138_1_2 -> 362 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 366, 117, 362 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 365, 367 },
      -1,
   } },

   /* replace138_0 -> 364 in the cache */
   /* replace138_1 -> 362 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 364, 362 },
      -1,
   } },

   /* ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search139_0 -> 16 in the cache */
   /* search139_1_0_0 -> 16 in the cache */
   /* search139_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 16, 117 },
      -1,
   } },
   /* search139_1_1 -> 117 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 370, 117, 371 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 16, 372 },
      -1,
   } },

   /* replace139_0 -> 16 in the cache */
   /* replace139_1 -> 36 in the cache */
   /* replace139 -> 258 in the cache */

   /* ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search140_0_0_0 -> 362 in the cache */
   /* search140_0_0_1 -> 117 in the cache */
   /* search140_0_0 -> 363 in the cache */
   /* search140_0_1 -> 117 in the cache */
   /* search140_0_2 -> 364 in the cache */
   /* search140_0 -> 365 in the cache */
   /* search140_1_0_0 -> 364 in the cache */
   /* search140_1_0_1 -> 117 in the cache */
   /* search140_1_0 -> 366 in the cache */
   /* search140_1_1 -> 117 in the cache */
   /* search140_1_2 -> 362 in the cache */
   /* search140_1 -> 367 in the cache */
   /* search140_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 365, 367, 137 },
      -1,
   } },

   /* replace140_0 -> 364 in the cache */
   /* replace140_1 -> 362 in the cache */
   /* replace140_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 364, 362, 137 },
      -1,
   } },

   /* ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search141_0 -> 16 in the cache */
   /* search141_1_0_0 -> 16 in the cache */
   /* search141_1_0_1 -> 117 in the cache */
   /* search141_1_0 -> 370 in the cache */
   /* search141_1_1 -> 117 in the cache */
   /* search141_1_2 -> 371 in the cache */
   /* search141_1 -> 372 in the cache */
   /* search141_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 16, 372, 137 },
      -1,
   } },

   /* replace141_0 -> 16 in the cache */
   /* replace141_1 -> 36 in the cache */
   /* replace141_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search142_0 -> 16 in the cache */
   /* search142_1 -> 36 in the cache */
   /* search142_2 -> 137 in the cache */
   /* search142 -> 320 in the cache */

   /* replace142_0_0_0_0_0 -> 16 in the cache */
   /* replace142_0_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace142_0_0_0_1_0 -> 36 in the cache */
   /* replace142_0_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 378, 379 },
      -1,
   } },
   /* replace142_0_0_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 381 },
      -1,
   } },
   /* replace142_0_0_1_1_0 -> 36 in the cache */
   /* replace142_0_0_1_1_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 381 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 382, 383 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 380, 384 },
      -1,
   } },
   /* replace142_0_1_0_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 386 },
      -1,
   } },
   /* replace142_0_1_0_1_0 -> 36 in the cache */
   /* replace142_0_1_0_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 387, 388 },
      -1,
   } },
   /* replace142_0_1_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 390 },
      -1,
   } },
   /* replace142_0_1_1_1_0 -> 36 in the cache */
   /* replace142_0_1_1_1_1 -> 390 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 390 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 391, 392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 389, 393 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 385, 394 },
      -1,
   } },
   /* replace142_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 395, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search143_0 -> 16 in the cache */
   /* search143_1 -> 36 in the cache */
   /* search143_2 -> 137 in the cache */
   /* search143 -> 323 in the cache */

   /* replace143_0_0_0_0_0 -> 16 in the cache */
   /* replace143_0_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace143_0_0_0_1_0 -> 36 in the cache */
   /* replace143_0_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 397, 398 },
      -1,
   } },
   /* replace143_0_0_1_0_0 -> 16 in the cache */
   /* replace143_0_0_1_0_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 381 },
      -1,
   } },
   /* replace143_0_0_1_1_0 -> 36 in the cache */
   /* replace143_0_0_1_1_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 381 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 400, 401 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 399, 402 },
      -1,
   } },
   /* replace143_0_1_0_0_0 -> 16 in the cache */
   /* replace143_0_1_0_0_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 386 },
      -1,
   } },
   /* replace143_0_1_0_1_0 -> 36 in the cache */
   /* replace143_0_1_0_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 404, 405 },
      -1,
   } },
   /* replace143_0_1_1_0_0 -> 16 in the cache */
   /* replace143_0_1_1_0_1 -> 390 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 390 },
      -1,
   } },
   /* replace143_0_1_1_1_0 -> 36 in the cache */
   /* replace143_0_1_1_1_1 -> 390 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 390 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 407, 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 406, 409 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 403, 410 },
      -1,
   } },
   /* replace143_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 411, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search144_0 -> 16 in the cache */
   /* search144_1 -> 36 in the cache */
   /* search144_2 -> 137 in the cache */
   /* search144 -> 326 in the cache */

   /* replace144_0_0_0_0_0 -> 16 in the cache */
   /* replace144_0_0_0_0_1 -> 124 in the cache */
   /* replace144_0_0_0_0 -> 378 in the cache */
   /* replace144_0_0_0_1_0 -> 36 in the cache */
   /* replace144_0_0_0_1_1 -> 124 in the cache */
   /* replace144_0_0_0_1 -> 398 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 378, 398 },
      -1,
   } },
   /* replace144_0_0_1_0_0 -> 16 in the cache */
   /* replace144_0_0_1_0_1 -> 381 in the cache */
   /* replace144_0_0_1_0 -> 382 in the cache */
   /* replace144_0_0_1_1_0 -> 36 in the cache */
   /* replace144_0_0_1_1_1 -> 381 in the cache */
   /* replace144_0_0_1_1 -> 401 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 382, 401 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 413, 414 },
      -1,
   } },
   /* replace144_0_1_0_0_0 -> 16 in the cache */
   /* replace144_0_1_0_0_1 -> 386 in the cache */
   /* replace144_0_1_0_0 -> 387 in the cache */
   /* replace144_0_1_0_1_0 -> 36 in the cache */
   /* replace144_0_1_0_1_1 -> 386 in the cache */
   /* replace144_0_1_0_1 -> 405 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 387, 405 },
      -1,
   } },
   /* replace144_0_1_1_0_0 -> 16 in the cache */
   /* replace144_0_1_1_0_1 -> 390 in the cache */
   /* replace144_0_1_1_0 -> 391 in the cache */
   /* replace144_0_1_1_1_0 -> 36 in the cache */
   /* replace144_0_1_1_1_1 -> 390 in the cache */
   /* replace144_0_1_1_1 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 391, 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 416, 417 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 415, 418 },
      -1,
   } },
   /* replace144_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 419, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search145_0 -> 16 in the cache */
   /* search145_1 -> 36 in the cache */
   /* search145_2 -> 137 in the cache */
   /* search145 -> 332 in the cache */

   /* replace145_0_0_0_0 -> 16 in the cache */
   /* replace145_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace145_0_0_1_0 -> 36 in the cache */
   /* replace145_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 421, 422 },
      -1,
   } },
   /* replace145_0_1_0_0 -> 16 in the cache */
   /* replace145_0_1_0_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 381 },
      -1,
   } },
   /* replace145_0_1_1_0 -> 36 in the cache */
   /* replace145_0_1_1_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 381 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 424, 425 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 423, 426 },
      -1,
   } },
   /* replace145_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 427, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search146_0 -> 16 in the cache */
   /* search146_1 -> 36 in the cache */
   /* search146_2 -> 137 in the cache */
   /* search146 -> 335 in the cache */

   /* replace146_0_0_0_0 -> 16 in the cache */
   /* replace146_0_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   /* replace146_0_0_1_0 -> 36 in the cache */
   /* replace146_0_0_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 429, 430 },
      -1,
   } },
   /* replace146_0_1_0_0 -> 16 in the cache */
   /* replace146_0_1_0_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 381 },
      -1,
   } },
   /* replace146_0_1_1_0 -> 36 in the cache */
   /* replace146_0_1_1_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 381 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 432, 433 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 431, 434 },
      -1,
   } },
   /* replace146_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 435, 137 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search147_0 -> 16 in the cache */
   /* search147_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 437 },
      -1,
   } },

   /* replace147_0 -> 16 in the cache */
   /* replace147_1 -> 36 in the cache */
   /* replace147_2 -> 137 in the cache */
   /* replace147 -> 323 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search148_0 -> 16 in the cache */
   /* search148_1 -> 36 in the cache */
   /* search148_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace148_0_0_0_0_0 -> 16 in the cache */
   /* replace148_0_0_0_0_1 -> 124 in the cache */
   /* replace148_0_0_0_0 -> 397 in the cache */
   /* replace148_0_0_0_1_0 -> 36 in the cache */
   /* replace148_0_0_0_1_1 -> 124 in the cache */
   /* replace148_0_0_0_1 -> 398 in the cache */
   /* replace148_0_0_0 -> 399 in the cache */
   /* replace148_0_0_1_0_0 -> 16 in the cache */
   /* replace148_0_0_1_0_1 -> 381 in the cache */
   /* replace148_0_0_1_0 -> 400 in the cache */
   /* replace148_0_0_1_1_0 -> 36 in the cache */
   /* replace148_0_0_1_1_1 -> 381 in the cache */
   /* replace148_0_0_1_1 -> 401 in the cache */
   /* replace148_0_0_1 -> 402 in the cache */
   /* replace148_0_0 -> 403 in the cache */
   /* replace148_0_1_0_0_0 -> 16 in the cache */
   /* replace148_0_1_0_0_1 -> 386 in the cache */
   /* replace148_0_1_0_0 -> 404 in the cache */
   /* replace148_0_1_0_1_0 -> 36 in the cache */
   /* replace148_0_1_0_1_1 -> 386 in the cache */
   /* replace148_0_1_0_1 -> 405 in the cache */
   /* replace148_0_1_0 -> 406 in the cache */
   /* replace148_0_1_1_0_0 -> 16 in the cache */
   /* replace148_0_1_1_0_1 -> 390 in the cache */
   /* replace148_0_1_1_0 -> 407 in the cache */
   /* replace148_0_1_1_1_0 -> 36 in the cache */
   /* replace148_0_1_1_1_1 -> 390 in the cache */
   /* replace148_0_1_1_1 -> 408 in the cache */
   /* replace148_0_1_1 -> 409 in the cache */
   /* replace148_0_1 -> 410 in the cache */
   /* replace148_0 -> 411 in the cache */
   /* replace148_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 8,
      { 411, 137 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search149_0 -> 16 in the cache */
   /* search149_1 -> 36 in the cache */
   /* search149_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace149_0_0_0_0_0 -> 16 in the cache */
   /* replace149_0_0_0_0_1 -> 124 in the cache */
   /* replace149_0_0_0_0 -> 378 in the cache */
   /* replace149_0_0_0_1_0 -> 36 in the cache */
   /* replace149_0_0_0_1_1 -> 124 in the cache */
   /* replace149_0_0_0_1 -> 379 in the cache */
   /* replace149_0_0_0 -> 380 in the cache */
   /* replace149_0_0_1_0_0 -> 16 in the cache */
   /* replace149_0_0_1_0_1 -> 381 in the cache */
   /* replace149_0_0_1_0 -> 382 in the cache */
   /* replace149_0_0_1_1_0 -> 36 in the cache */
   /* replace149_0_0_1_1_1 -> 381 in the cache */
   /* replace149_0_0_1_1 -> 383 in the cache */
   /* replace149_0_0_1 -> 384 in the cache */
   /* replace149_0_0 -> 385 in the cache */
   /* replace149_0_1_0_0_0 -> 16 in the cache */
   /* replace149_0_1_0_0_1 -> 386 in the cache */
   /* replace149_0_1_0_0 -> 387 in the cache */
   /* replace149_0_1_0_1_0 -> 36 in the cache */
   /* replace149_0_1_0_1_1 -> 386 in the cache */
   /* replace149_0_1_0_1 -> 388 in the cache */
   /* replace149_0_1_0 -> 389 in the cache */
   /* replace149_0_1_1_0_0 -> 16 in the cache */
   /* replace149_0_1_1_0_1 -> 390 in the cache */
   /* replace149_0_1_1_0 -> 391 in the cache */
   /* replace149_0_1_1_1_0 -> 36 in the cache */
   /* replace149_0_1_1_1_1 -> 390 in the cache */
   /* replace149_0_1_1_1 -> 392 in the cache */
   /* replace149_0_1_1 -> 393 in the cache */
   /* replace149_0_1 -> 394 in the cache */
   /* replace149_0 -> 395 in the cache */
   /* replace149_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 395, 137 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search150_0 -> 16 in the cache */
   /* search150_1 -> 36 in the cache */
   /* search150_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 36, 137 },
      -1,
   } },

   /* replace150_0_0_0_0_0 -> 16 in the cache */
   /* replace150_0_0_0_0_1 -> 124 in the cache */
   /* replace150_0_0_0_0 -> 378 in the cache */
   /* replace150_0_0_0_1_0 -> 36 in the cache */
   /* replace150_0_0_0_1_1 -> 124 in the cache */
   /* replace150_0_0_0_1 -> 398 in the cache */
   /* replace150_0_0_0 -> 413 in the cache */
   /* replace150_0_0_1_0_0 -> 16 in the cache */
   /* replace150_0_0_1_0_1 -> 381 in the cache */
   /* replace150_0_0_1_0 -> 382 in the cache */
   /* replace150_0_0_1_1_0 -> 36 in the cache */
   /* replace150_0_0_1_1_1 -> 381 in the cache */
   /* replace150_0_0_1_1 -> 401 in the cache */
   /* replace150_0_0_1 -> 414 in the cache */
   /* replace150_0_0 -> 415 in the cache */
   /* replace150_0_1_0_0_0 -> 16 in the cache */
   /* replace150_0_1_0_0_1 -> 386 in the cache */
   /* replace150_0_1_0_0 -> 387 in the cache */
   /* replace150_0_1_0_1_0 -> 36 in the cache */
   /* replace150_0_1_0_1_1 -> 386 in the cache */
   /* replace150_0_1_0_1 -> 405 in the cache */
   /* replace150_0_1_0 -> 416 in the cache */
   /* replace150_0_1_1_0_0 -> 16 in the cache */
   /* replace150_0_1_1_0_1 -> 390 in the cache */
   /* replace150_0_1_1_0 -> 391 in the cache */
   /* replace150_0_1_1_1_0 -> 36 in the cache */
   /* replace150_0_1_1_1_1 -> 390 in the cache */
   /* replace150_0_1_1_1 -> 408 in the cache */
   /* replace150_0_1_1 -> 417 in the cache */
   /* replace150_0_1 -> 418 in the cache */
   /* replace150_0 -> 419 in the cache */
   /* replace150_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 419, 137 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search151_0 -> 16 in the cache */
   /* search151_1 -> 36 in the cache */
   /* search151_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace151_0_0_0_0 -> 16 in the cache */
   /* replace151_0_0_0_1 -> 124 in the cache */
   /* replace151_0_0_0 -> 429 in the cache */
   /* replace151_0_0_1_0 -> 36 in the cache */
   /* replace151_0_0_1_1 -> 124 in the cache */
   /* replace151_0_0_1 -> 430 in the cache */
   /* replace151_0_0 -> 431 in the cache */
   /* replace151_0_1_0_0 -> 16 in the cache */
   /* replace151_0_1_0_1 -> 381 in the cache */
   /* replace151_0_1_0 -> 432 in the cache */
   /* replace151_0_1_1_0 -> 36 in the cache */
   /* replace151_0_1_1_1 -> 381 in the cache */
   /* replace151_0_1_1 -> 433 in the cache */
   /* replace151_0_1 -> 434 in the cache */
   /* replace151_0 -> 435 in the cache */
   /* replace151_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 435, 137 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search152_0 -> 16 in the cache */
   /* search152_1 -> 36 in the cache */
   /* search152_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace152_0_0_0_0 -> 16 in the cache */
   /* replace152_0_0_0_1 -> 124 in the cache */
   /* replace152_0_0_0 -> 421 in the cache */
   /* replace152_0_0_1_0 -> 36 in the cache */
   /* replace152_0_0_1_1 -> 124 in the cache */
   /* replace152_0_0_1 -> 422 in the cache */
   /* replace152_0_0 -> 423 in the cache */
   /* replace152_0_1_0_0 -> 16 in the cache */
   /* replace152_0_1_0_1 -> 381 in the cache */
   /* replace152_0_1_0 -> 424 in the cache */
   /* replace152_0_1_1_0 -> 36 in the cache */
   /* replace152_0_1_1_1 -> 381 in the cache */
   /* replace152_0_1_1 -> 425 in the cache */
   /* replace152_0_1 -> 426 in the cache */
   /* replace152_0 -> 427 in the cache */
   /* replace152_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 427, 137 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search153_0 -> 11 in the cache */
   /* search153_1 -> 247 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 449 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 247, 450 },
      -1,
   } },

   /* replace153_0 -> 449 in the cache */
   /* replace153_1 -> 247 in the cache */
   /* replace153_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 449, 247, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search154_0 -> 11 in the cache */
   /* search154_1_0 -> 11 in the cache */
   /* search154_1_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 247 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 453, 454 },
      -1,
   } },

   /* replace154_0_0 -> 247 in the cache */
   /* replace154_0_1 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 247, 454 },
      -1,
   } },
   /* replace154_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 456, 11 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search155_0_0 -> 11 in the cache */
   /* search155_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 247 },
      0,
   } },
   /* search155_1_0 -> 11 in the cache */
   /* search155_1_1 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 454 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 458, 459, 460 },
      -1,
   } },

   /* replace155_0_0 -> 247 in the cache */
   /* replace155_0_1 -> 454 in the cache */
   /* replace155_0_2 -> 460 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 247, 454, 460 },
      -1,
   } },
   /* replace155_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 462, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search156_0 -> 11 in the cache */
   /* search156_1_0 -> 11 in the cache */
   /* search156_1_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 247 },
      0,
   } },
   /* search156_2 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 464, 454 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace156_0_1 -> 247 in the cache */
   /* replace156_0_2 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 466, 247, 454 },
      -1,
   } },
   /* replace156_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 467, 11 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search157_0_0 -> 11 in the cache */
   /* search157_0_1_0 -> 466 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 466, 470 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 471 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search157_1_1 -> 469 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 473, 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 472, 474 },
      -1,
   } },

   /* replace157_0 -> 11 in the cache */
   /* replace157_1 -> 473 in the cache */
   /* replace157_2 -> 469 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 473, 469 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search158_0_0 -> 11 in the cache */
   /* search158_0_1_0_0 -> 466 in the cache */
   /* search158_0_1_0_1_0 -> 469 in the cache */
   /* search158_0_1_0_1 -> 470 in the cache */
   /* search158_0_1_0 -> 471 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 471 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 477 },
      -1,
   } },
   /* search158_1_0 -> 473 in the cache */
   /* search158_1_1_0 -> 469 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 473, 479 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 478, 480 },
      -1,
   } },

   /* replace158_0 -> 11 in the cache */
   /* replace158_1 -> 473 in the cache */
   /* replace158_2_0 -> 469 in the cache */
   /* replace158_2 -> 479 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 473, 479 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search159_0 -> 11 in the cache */
   /* search159_1_0 -> 469 in the cache */
   /* search159_1_1_0 -> 473 in the cache */
   /* search159_1_1_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 473, 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 469, 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 485 },
      -1,
   } },

   /* replace159_0 -> 11 in the cache */
   /* replace159_1 -> 473 in the cache */
   /* replace159_2 -> 469 in the cache */
   /* replace159 -> 476 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search160_0_0 -> 11 in the cache */
   /* search160_0_1_0 -> 466 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 488 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 466, 489 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 490 },
      -1,
   } },
   /* search160_1_0 -> 473 in the cache */
   /* search160_1_1_0 -> 487 in the cache */
   /* search160_1_1 -> 488 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 473, 488 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 491, 492 },
      -1,
   } },

   /* replace160_0 -> 487 in the cache */
   /* replace160_1 -> 473 in the cache */
   /* replace160_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 487, 473, 11 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search161_0 -> 11 in the cache */
   /* search161_1_0_0 -> 487 in the cache */
   /* search161_1_0 -> 488 in the cache */
   /* search161_1_1_0 -> 473 in the cache */
   /* search161_1_1_1_0 -> 11 in the cache */
   /* search161_1_1_1 -> 483 in the cache */
   /* search161_1_1 -> 484 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 488, 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 495 },
      -1,
   } },

   /* replace161_0 -> 487 in the cache */
   /* replace161_1 -> 473 in the cache */
   /* replace161_2 -> 11 in the cache */
   /* replace161 -> 494 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search162_0 -> 11 in the cache */
   /* search162_1_0 -> 466 in the cache */
   /* search162_1_1_0_0 -> 487 in the cache */
   /* search162_1_1_0 -> 488 in the cache */
   /* search162_1_1 -> 489 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 466, 489 },
      -1,
   } },
   /* search162_2_0 -> 473 in the cache */
   /* search162_2_1_0 -> 487 in the cache */
   /* search162_2_1 -> 488 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 473, 488 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 11, 497, 498 },
      -1,
   } },

   /* replace162_0 -> 487 in the cache */
   /* replace162_1 -> 473 in the cache */
   /* replace162_2 -> 11 in the cache */
   /* replace162 -> 494 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search163_1_0 -> 487 in the cache */
   /* search163_1 -> 488 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 501 },
      -1,
   } },
   /* search163_2_1_0 -> 487 in the cache */
   /* search163_2_1 -> 488 in the cache */
   /* search163_2_2 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 502, 488, 501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 500, 488, 503 },
      -1,
   } },

   /* replace163_0 -> 487 in the cache */
   /* replace163_1 -> 500 in the cache */
   /* replace163_2 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 487, 500, 501 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 506 },
      -1,
   } },
   /* search164_1_0 -> 247 in the cache */
   /* search164_1_1_0 -> 501 in the cache */
   /* search164_1_1 -> 502 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 247, 502 },
      -1,
   } },
   /* search164_2 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 507, 508, 501 },
      -1,
   } },

   /* replace164_0 -> 506 in the cache */
   /* replace164_1 -> 247 in the cache */
   /* replace164_2 -> 501 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 506, 247, 501 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search165_0_0 -> 506 in the cache */
   /* search165_0 -> 507 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 511 },
      -1,
   } },
   /* search165_1_1 -> 473 in the cache */
   /* search165_1_2 -> 460 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 512, 473, 460 },
      -1,
   } },
   /* search165_2_0 -> 511 in the cache */
   /* search165_2_1 -> 473 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 511, 473 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 507, 513, 514 },
      -1,
   } },

   /* replace165_0 -> 506 in the cache */
   /* replace165_1 -> 460 in the cache */
   /* replace165_2_0 -> 511 in the cache */
   /* replace165_2_1 -> 473 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 511, 473 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 506, 460, 516 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search166_0 -> 466 in the cache */
   /* search166_1_0_0_0 -> 466 in the cache */
   /* search166_1_0_0_1_0 -> 11 in the cache */
   /* search166_1_0_0_1 -> 483 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 466, 483 },
      -1,
   } },
   /* search166_1_0_1_0 -> 466 in the cache */
   /* search166_1_0_1_1_0 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 247 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 466, 519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 518, 520 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 521 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 466, 522 },
      -1,
   } },

   /* replace166_0 -> 247 in the cache */
   /* replace166_1 -> 466 in the cache */
   /* replace166_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 247, 466, 11 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search167_0 -> 16 in the cache */
   /* search167_1 -> 36 in the cache */
   /* search167_2_0 -> 449 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 449 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 36, 525 },
      -1,
   } },

   /* replace167_0 -> 449 in the cache */
   /* replace167_1 -> 36 in the cache */
   /* replace167_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 449, 36, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search168_0 -> 16 in the cache */
   /* search168_1_0 -> 16 in the cache */
   /* search168_1_1 -> 36 in the cache */
   /* search168_1 -> 263 in the cache */
   /* search168_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 263, 137 },
      -1,
   } },

   /* replace168_0_0 -> 36 in the cache */
   /* replace168_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 36, 137 },
      -1,
   } },
   /* replace168_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 529, 16 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search169_0_0 -> 16 in the cache */
   /* search169_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search169_1_0 -> 16 in the cache */
   /* search169_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 16, 137 },
      0,
   } },
   /* search169_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 531, 532, 165 },
      -1,
   } },

   /* replace169_0_0 -> 36 in the cache */
   /* replace169_0_1 -> 137 in the cache */
   /* replace169_0_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 137, 165 },
      -1,
   } },
   /* replace169_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 534, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search170_0 -> 16 in the cache */
   /* search170_1_0 -> 16 in the cache */
   /* search170_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search170_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 536, 137 },
      -1,
   } },

   /* replace170_0_0 -> 232 in the cache */
   /* replace170_0_1 -> 36 in the cache */
   /* replace170_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 232, 36, 137 },
      -1,
   } },
   /* replace170_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 538, 16 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search171_0_0 -> 16 in the cache */
   /* search171_0_1_0 -> 232 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 540 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 232, 541 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 542 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search171_1_1 -> 540 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 544, 540 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 543, 545 },
      -1,
   } },

   /* replace171_0 -> 16 in the cache */
   /* replace171_1 -> 544 in the cache */
   /* replace171_2 -> 540 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 544, 540 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search172_0_0 -> 16 in the cache */
   /* search172_0_1_0_0 -> 232 in the cache */
   /* search172_0_1_0_1_0 -> 540 in the cache */
   /* search172_0_1_0_1 -> 541 in the cache */
   /* search172_0_1_0 -> 542 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 542 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 548 },
      -1,
   } },
   /* search172_1_0 -> 544 in the cache */
   /* search172_1_1_0 -> 540 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 540 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 544, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 549, 551 },
      -1,
   } },

   /* replace172_0 -> 16 in the cache */
   /* replace172_1 -> 544 in the cache */
   /* replace172_2_0 -> 540 in the cache */
   /* replace172_2 -> 550 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 544, 550 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search173_0 -> 16 in the cache */
   /* search173_1_0 -> 540 in the cache */
   /* search173_1_1_0 -> 544 in the cache */
   /* search173_1_1_1_0 -> 16 in the cache */
   /* search173_1_1_1 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 544, 269 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 540, 554 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 555 },
      -1,
   } },

   /* replace173_0 -> 16 in the cache */
   /* replace173_1 -> 544 in the cache */
   /* replace173_2 -> 540 in the cache */
   /* replace173 -> 547 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search174_0_0 -> 16 in the cache */
   /* search174_0_1_0 -> 232 in the cache */
   /* search174_0_1_1_0_0 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 232, 558 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 559 },
      -1,
   } },
   /* search174_1_0 -> 544 in the cache */
   /* search174_1_1_0 -> 487 in the cache */
   /* search174_1_1 -> 557 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 544, 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 560, 561 },
      -1,
   } },

   /* replace174_0 -> 487 in the cache */
   /* replace174_1 -> 544 in the cache */
   /* replace174_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 487, 544, 16 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search175_0 -> 16 in the cache */
   /* search175_1_0_0 -> 487 in the cache */
   /* search175_1_0 -> 557 in the cache */
   /* search175_1_1_0 -> 544 in the cache */
   /* search175_1_1_1_0 -> 16 in the cache */
   /* search175_1_1_1 -> 269 in the cache */
   /* search175_1_1 -> 554 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 557, 554 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 564 },
      -1,
   } },

   /* replace175_0 -> 487 in the cache */
   /* replace175_1 -> 544 in the cache */
   /* replace175_2 -> 16 in the cache */
   /* replace175 -> 563 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search176_0 -> 16 in the cache */
   /* search176_1_0 -> 232 in the cache */
   /* search176_1_1_0_0 -> 487 in the cache */
   /* search176_1_1_0 -> 557 in the cache */
   /* search176_1_1 -> 558 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 232, 558 },
      -1,
   } },
   /* search176_2_0 -> 544 in the cache */
   /* search176_2_1_0 -> 487 in the cache */
   /* search176_2_1 -> 557 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 544, 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 16, 566, 567 },
      -1,
   } },

   /* replace176_0 -> 487 in the cache */
   /* replace176_1 -> 544 in the cache */
   /* replace176_2 -> 16 in the cache */
   /* replace176 -> 563 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search177_0 -> 362 in the cache */
   /* search177_1_0 -> 487 in the cache */
   /* search177_1 -> 557 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 569 },
      -1,
   } },
   /* search177_2_1_0 -> 487 in the cache */
   /* search177_2_1 -> 557 in the cache */
   /* search177_2_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 570, 557, 569 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 362, 557, 571 },
      -1,
   } },

   /* replace177_0 -> 487 in the cache */
   /* replace177_1 -> 362 in the cache */
   /* replace177_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 487, 362, 569 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search178_0_0 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 506 },
      -1,
   } },
   /* search178_1_0 -> 36 in the cache */
   /* search178_1_1_0 -> 569 in the cache */
   /* search178_1_1 -> 570 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 570 },
      -1,
   } },
   /* search178_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 574, 575, 569 },
      -1,
   } },

   /* replace178_0 -> 506 in the cache */
   /* replace178_1 -> 36 in the cache */
   /* replace178_2 -> 569 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 506, 36, 569 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search179_0_0 -> 506 in the cache */
   /* search179_0 -> 574 in the cache */
   /* search179_1_0_0 -> 364 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 364 },
      -1,
   } },
   /* search179_1_1 -> 544 in the cache */
   /* search179_1_2 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 578, 544, 165 },
      -1,
   } },
   /* search179_2_0 -> 364 in the cache */
   /* search179_2_1 -> 544 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 364, 544 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 574, 579, 580 },
      -1,
   } },

   /* replace179_0 -> 506 in the cache */
   /* replace179_1 -> 165 in the cache */
   /* replace179_2_0 -> 364 in the cache */
   /* replace179_2_1 -> 544 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 364, 544 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 506, 165, 582 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search180_0 -> 232 in the cache */
   /* search180_1_0_0_0 -> 232 in the cache */
   /* search180_1_0_0_1_0 -> 16 in the cache */
   /* search180_1_0_0_1 -> 269 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 232, 269 },
      -1,
   } },
   /* search180_1_0_1_0 -> 232 in the cache */
   /* search180_1_0_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 232, 585 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 584, 586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 587 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 232, 588 },
      -1,
   } },

   /* replace180_0 -> 36 in the cache */
   /* replace180_1 -> 232 in the cache */
   /* replace180_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 232, 16 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search181_0 -> 21 in the cache */
   /* search181_1 -> 41 in the cache */
   /* search181_2_0 -> 449 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 449 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 41, 591 },
      -1,
   } },

   /* replace181_0 -> 449 in the cache */
   /* replace181_1 -> 41 in the cache */
   /* replace181_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 449, 41, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search182_0 -> 21 in the cache */
   /* search182_1_0 -> 21 in the cache */
   /* search182_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 594, 595 },
      -1,
   } },

   /* replace182_0_0 -> 41 in the cache */
   /* replace182_0_1 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 41, 595 },
      -1,
   } },
   /* replace182_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 597, 21 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search183_0_0 -> 21 in the cache */
   /* search183_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search183_1_0 -> 21 in the cache */
   /* search183_1_1 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 21, 595 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 599, 600, 601 },
      -1,
   } },

   /* replace183_0_0 -> 41 in the cache */
   /* replace183_0_1 -> 595 in the cache */
   /* replace183_0_2 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 595, 601 },
      -1,
   } },
   /* replace183_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 603, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search184_0 -> 21 in the cache */
   /* search184_1_0 -> 21 in the cache */
   /* search184_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search184_2 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 605, 595 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace184_0_1 -> 41 in the cache */
   /* replace184_0_2 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 607, 41, 595 },
      -1,
   } },
   /* replace184_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 608, 21 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search185_0_0 -> 21 in the cache */
   /* search185_0_1_0 -> 607 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 607, 611 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 612 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search185_1_1 -> 610 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 614, 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 613, 615 },
      -1,
   } },

   /* replace185_0 -> 21 in the cache */
   /* replace185_1 -> 614 in the cache */
   /* replace185_2 -> 610 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 614, 610 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search186_0_0 -> 21 in the cache */
   /* search186_0_1_0_0 -> 607 in the cache */
   /* search186_0_1_0_1_0 -> 610 in the cache */
   /* search186_0_1_0_1 -> 611 in the cache */
   /* search186_0_1_0 -> 612 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 612 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 618 },
      -1,
   } },
   /* search186_1_0 -> 614 in the cache */
   /* search186_1_1_0 -> 610 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 614, 620 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 619, 621 },
      -1,
   } },

   /* replace186_0 -> 21 in the cache */
   /* replace186_1 -> 614 in the cache */
   /* replace186_2_0 -> 610 in the cache */
   /* replace186_2 -> 620 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 614, 620 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search187_0 -> 21 in the cache */
   /* search187_1_0 -> 610 in the cache */
   /* search187_1_1_0 -> 614 in the cache */
   /* search187_1_1_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 614, 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 610, 625 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 626 },
      -1,
   } },

   /* replace187_0 -> 21 in the cache */
   /* replace187_1 -> 614 in the cache */
   /* replace187_2 -> 610 in the cache */
   /* replace187 -> 617 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search188_0_0 -> 21 in the cache */
   /* search188_0_1_0 -> 607 in the cache */
   /* search188_0_1_1_0_0 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 628 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 607, 629 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 630 },
      -1,
   } },
   /* search188_1_0 -> 614 in the cache */
   /* search188_1_1_0 -> 487 in the cache */
   /* search188_1_1 -> 628 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 614, 628 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 631, 632 },
      -1,
   } },

   /* replace188_0 -> 487 in the cache */
   /* replace188_1 -> 614 in the cache */
   /* replace188_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 487, 614, 21 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search189_0 -> 21 in the cache */
   /* search189_1_0_0 -> 487 in the cache */
   /* search189_1_0 -> 628 in the cache */
   /* search189_1_1_0 -> 614 in the cache */
   /* search189_1_1_1_0 -> 21 in the cache */
   /* search189_1_1_1 -> 624 in the cache */
   /* search189_1_1 -> 625 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 628, 625 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 635 },
      -1,
   } },

   /* replace189_0 -> 487 in the cache */
   /* replace189_1 -> 614 in the cache */
   /* replace189_2 -> 21 in the cache */
   /* replace189 -> 634 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search190_0 -> 21 in the cache */
   /* search190_1_0 -> 607 in the cache */
   /* search190_1_1_0_0 -> 487 in the cache */
   /* search190_1_1_0 -> 628 in the cache */
   /* search190_1_1 -> 629 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 607, 629 },
      -1,
   } },
   /* search190_2_0 -> 614 in the cache */
   /* search190_2_1_0 -> 487 in the cache */
   /* search190_2_1 -> 628 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 614, 628 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 21, 637, 638 },
      -1,
   } },

   /* replace190_0 -> 487 in the cache */
   /* replace190_1 -> 614 in the cache */
   /* replace190_2 -> 21 in the cache */
   /* replace190 -> 634 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search191_1_0 -> 487 in the cache */
   /* search191_1 -> 628 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 641 },
      -1,
   } },
   /* search191_2_1_0 -> 487 in the cache */
   /* search191_2_1 -> 628 in the cache */
   /* search191_2_2 -> 641 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 642, 628, 641 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 640, 628, 643 },
      -1,
   } },

   /* replace191_0 -> 487 in the cache */
   /* replace191_1 -> 640 in the cache */
   /* replace191_2 -> 641 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 487, 640, 641 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search192_0_0 -> 506 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 506 },
      -1,
   } },
   /* search192_1_0 -> 41 in the cache */
   /* search192_1_1_0 -> 641 in the cache */
   /* search192_1_1 -> 642 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 41, 642 },
      -1,
   } },
   /* search192_2 -> 641 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 646, 647, 641 },
      -1,
   } },

   /* replace192_0 -> 506 in the cache */
   /* replace192_1 -> 41 in the cache */
   /* replace192_2 -> 641 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 506, 41, 641 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search193_0_0 -> 506 in the cache */
   /* search193_0 -> 646 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 650 },
      -1,
   } },
   /* search193_1_1 -> 614 in the cache */
   /* search193_1_2 -> 601 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 651, 614, 601 },
      -1,
   } },
   /* search193_2_0 -> 650 in the cache */
   /* search193_2_1 -> 614 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 650, 614 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 646, 652, 653 },
      -1,
   } },

   /* replace193_0 -> 506 in the cache */
   /* replace193_1 -> 601 in the cache */
   /* replace193_2_0 -> 650 in the cache */
   /* replace193_2_1 -> 614 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 650, 614 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 506, 601, 655 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search194_0 -> 607 in the cache */
   /* search194_1_0_0_0 -> 607 in the cache */
   /* search194_1_0_0_1_0 -> 21 in the cache */
   /* search194_1_0_0_1 -> 624 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 607, 624 },
      -1,
   } },
   /* search194_1_0_1_0 -> 607 in the cache */
   /* search194_1_0_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 607, 658 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 657, 659 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 660 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 607, 661 },
      -1,
   } },

   /* replace194_0 -> 41 in the cache */
   /* replace194_1 -> 607 in the cache */
   /* replace194_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 607, 21 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search195_0_0 -> 151 in the cache */
   /* search195_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 151, 152 },
      0,
   } },
   /* search195_1_0 -> 151 in the cache */
   /* search195_1_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 151, 154 },
      0,
   } },
   /* search195_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 664, 665, 155 },
      -1,
   } },

   /* replace195_0_0 -> 152 in the cache */
   /* replace195_0_1 -> 154 in the cache */
   /* replace195_0_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 152, 154, 155 },
      -1,
   } },
   /* replace195_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 667, 151 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search196_0 -> 0 in the cache */
   /* search196_1 -> 245 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 245, 669 },
      -1,
   } },

   /* replace196_0_0_0 -> 0 in the cache */
   /* replace196_0_0 -> 201 in the cache */
   /* replace196_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 201, 669 },
      -1,
   } },
   /* replace196_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 671, 0 },
      -1,
   } },

   /* ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search197_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace197_0_0 -> 32 in the cache */
   /* replace197_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 113 },
      -1,
   } },
   /* replace197_1_0_0_0 -> 32 in the cache */
   /* replace197_1_0_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 103 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 675 },
      -1,
   } },
   /* replace197_2_0_0 -> 32 in the cache */
   /* replace197_2_0 -> 103 in the cache */
   /* replace197_2 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 674, 676, 675 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search198_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 11 },
      -1,
   } },

   /* replace198_0 -> 11 in the cache */
   /* replace198_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 11, 679 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search199_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 16 },
      -1,
   } },

   /* replace199_0 -> 16 in the cache */
   /* replace199_1_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 16, 682 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search200_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 21 },
      -1,
   } },

   /* replace200_0 -> 21 in the cache */
   /* replace200_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 21, 685 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search201_0 -> 11 in the cache */
   /* search201_1_0_0 -> 11 in the cache */
   /* search201_1_0 -> 679 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 679 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 687 },
      -1,
   } },

   /* replace201_0 -> 11 in the cache */
   /* replace201 -> 678 in the cache */

   /* ('fadd@32', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search202_0 -> 16 in the cache */
   /* search202_1_0_0 -> 16 in the cache */
   /* search202_1_0 -> 682 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 682 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 689 },
      -1,
   } },

   /* replace202_0 -> 16 in the cache */
   /* replace202 -> 681 in the cache */

   /* ('fadd@64', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search203_0 -> 21 in the cache */
   /* search203_1_0_0 -> 21 in the cache */
   /* search203_1_0 -> 685 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 685 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 691 },
      -1,
   } },

   /* replace203_0 -> 21 in the cache */
   /* replace203 -> 684 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search204_0 -> 11 in the cache */
   /* search204 -> 679 in the cache */

   /* replace204_0 -> 11 in the cache */
   /* replace204_1_0 -> 11 in the cache */
   /* replace204_1 -> 678 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 11, 678 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search205_0 -> 16 in the cache */
   /* search205 -> 682 in the cache */

   /* replace205_0 -> 16 in the cache */
   /* replace205_1_0 -> 16 in the cache */
   /* replace205_1 -> 681 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 16, 681 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search206_0 -> 21 in the cache */
   /* search206 -> 685 in the cache */

   /* replace206_0 -> 21 in the cache */
   /* replace206_1_0 -> 21 in the cache */
   /* replace206_1 -> 684 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 21, 684 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search207_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace207_0_0_0 -> 32 in the cache */
   /* replace207_0_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 697 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search208_0 -> 11 in the cache */
   /* search208_1 -> 247 in the cache */
   /* search208_2 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 247, 454 },
      -1,
   } },

   /* replace208_0_0 -> 11 in the cache */
   /* replace208_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 11, 247 },
      -1,
   } },
   /* replace208_1 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 700, 454 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search209_0 -> 16 in the cache */
   /* search209_1 -> 36 in the cache */
   /* search209_2 -> 137 in the cache */
   /* search209 -> 223 in the cache */

   /* replace209_0_0 -> 16 in the cache */
   /* replace209_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace209_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 702, 137 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search210_0 -> 21 in the cache */
   /* search210_1 -> 41 in the cache */
   /* search210_2 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 595 },
      -1,
   } },

   /* replace210_0_0 -> 21 in the cache */
   /* replace210_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace210_1 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 705, 595 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search211_0 -> 16 in the cache */
   /* search211_1 -> 36 in the cache */
   /* search211_2 -> 137 in the cache */
   /* search211 -> 377 in the cache */

   /* replace211_0_0 -> 16 in the cache */
   /* replace211_0_1 -> 36 in the cache */
   /* replace211_0 -> 136 in the cache */
   /* replace211_1 -> 137 in the cache */
   /* replace211 -> 277 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search212_0 -> 11 in the cache */
   /* search212_1 -> 247 in the cache */
   /* search212_2 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 247, 454 },
      -1,
   } },

   /* replace212_0_0 -> 11 in the cache */
   /* replace212_0_1 -> 247 in the cache */
   /* replace212_0 -> 700 in the cache */
   /* replace212_1 -> 454 in the cache */
   /* replace212 -> 701 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search213_0 -> 16 in the cache */
   /* search213_1 -> 36 in the cache */
   /* search213_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace213_0_0 -> 16 in the cache */
   /* replace213_0_1 -> 36 in the cache */
   /* replace213_0 -> 702 in the cache */
   /* replace213_1 -> 137 in the cache */
   /* replace213 -> 703 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search214_0 -> 21 in the cache */
   /* search214_1 -> 41 in the cache */
   /* search214_2 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 595 },
      -1,
   } },

   /* replace214_0_0 -> 21 in the cache */
   /* replace214_0_1 -> 41 in the cache */
   /* replace214_0 -> 705 in the cache */
   /* replace214_1 -> 595 in the cache */
   /* replace214 -> 706 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search215_0 -> 16 in the cache */
   /* search215_1 -> 36 in the cache */
   /* search215_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 137 },
      -1,
   } },

   /* replace215_0_0 -> 16 in the cache */
   /* replace215_0_1 -> 36 in the cache */
   /* replace215_0 -> 136 in the cache */
   /* replace215_1 -> 137 in the cache */
   /* replace215 -> 277 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 711 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 712 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 714, 715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 713, 716 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 717, 718 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 719, 720 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace216_1_0_0_0 -> 714 in the cache */
   /* replace216_1_0_0_1 -> 715 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 714, 715 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 723, 724 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 725, 726 },
      -1,
   } },
   /* replace216_2_0 -> 724 in the cache */
   /* replace216_2_1 -> 726 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 724, 726 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 722, 727, 728 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search217_0 -> 0 in the cache */
   /* search217_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace217_0_3 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 731, 732, 733, 259 },
      -1,
   } },
   /* replace217_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 734, 3 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search218_0_0 -> 151 in the cache */
   /* search218_0_1 -> 152 in the cache */
   /* search218_0_2 -> 154 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 151, 152, 154, 736 },
      -1,
   } },
   /* search218_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 737, 155 },
      -1,
   } },

   /* replace218_0_0 -> 151 in the cache */
   /* replace218_0_1 -> 152 in the cache */
   /* replace218_0_2 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 151, 152, 154 },
      -1,
   } },
   /* replace218_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 739, 155 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search219_0_0 -> 0 in the cache */
   /* search219_0_1 -> 245 in the cache */
   /* search219_0_2 -> 245 in the cache */
   /* search219_0_3 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 245, 245, 245 },
      -1,
   } },
   /* search219_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 741, 3 },
      -1,
   } },

   /* replace219_0 -> 0 in the cache */
   /* replace219_1 -> 3 in the cache */
   /* replace219 -> 253 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search220_0_0 -> 128 in the cache */
   /* search220_0_1 -> 129 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search220_0_3 -> 743 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 128, 129, 743, 743 },
      -1,
   } },
   /* search220_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 744, 131 },
      -1,
   } },

   /* replace220_0_0 -> 128 in the cache */
   /* replace220_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace220_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 746, 131 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search221_0_0 -> 151 in the cache */
   /* search221_0_1 -> 152 in the cache */
   /* search221_0_2 -> 154 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 151, 152, 154, 748 },
      -1,
   } },
   /* search221_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 749, 155 },
      -1,
   } },

   /* replace221_0_0 -> 151 in the cache */
   /* replace221_0_1 -> 152 in the cache */
   /* replace221_0_2 -> 154 in the cache */
   /* replace221_0 -> 739 in the cache */
   /* replace221_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 739, 155 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search222_0_0 -> 0 in the cache */
   /* search222_0_1 -> 245 in the cache */
   /* search222_0_2 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 245, 245 },
      -1,
   } },
   /* search222_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 752, 3 },
      -1,
   } },

   /* replace222_0 -> 0 in the cache */
   /* replace222_1 -> 3 in the cache */
   /* replace222 -> 253 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search223_0_0 -> 128 in the cache */
   /* search223_0_1 -> 129 in the cache */
   /* search223_0_2 -> 743 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 128, 129, 743 },
      -1,
   } },
   /* search223_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 754, 131 },
      -1,
   } },

   /* replace223_0_0 -> 128 in the cache */
   /* replace223_0_1 -> 129 in the cache */
   /* replace223_0 -> 746 in the cache */
   /* replace223_1 -> 131 in the cache */
   /* replace223 -> 747 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search224_0_0 -> 0 in the cache */
   /* search224_0_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 245 },
      -1,
   } },
   /* search224_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 756, 3 },
      -1,
   } },

   /* replace224_0 -> 0 in the cache */
   /* replace224_1 -> 3 in the cache */
   /* replace224 -> 253 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search225_0 -> 32 in the cache */
   /* search225_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 32, 230 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 759, 760 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search226_0 -> 0 in the cache */
   /* search226_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace226_0_0 -> 0 in the cache */
   /* replace226_0_1 -> 3 in the cache */
   /* replace226_0 -> 253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 253 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search227_0 -> 0 in the cache */
   /* search227_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace227_0_0 -> 0 in the cache */
   /* replace227_0_1 -> 3 in the cache */
   /* replace227_0 -> 253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 253 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search228_0 -> 0 in the cache */
   /* search228_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace228_0_0 -> 0 in the cache */
   /* replace228_0_1 -> 3 in the cache */
   /* replace228_0 -> 253 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 253 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search229_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace229_0 -> 759 in the cache */
   /* replace229_1 -> 760 in the cache */
   /* replace229 -> 761 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 769 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 770 },
      0,
   } },
   /* search230_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 771, 230 },
      -1,
   } },

   /* replace230_0_0 -> 230 in the cache */
   /* replace230_0_1_0 -> 32 in the cache */
   /* replace230_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 230, 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 773 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search231_0_0_0 -> 128 in the cache */
   /* search231_0_0_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 272 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 775, 776 },
      -1,
   } },
   /* search231_1 -> 300 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 777, 300 },
      -1,
   } },

   /* replace231_0_0 -> 128 in the cache */
   /* replace231_0_1_0 -> 129 in the cache */
   /* replace231_0_1_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 129, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 779 },
      -1,
   } },
   /* replace231_1_0 -> 131 in the cache */
   /* replace231_1_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 131, 165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 780, 781 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search232_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 783 },
      -1,
   } },
   /* search232_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 784, 298 },
      -1,
   } },

   /* replace232_0 -> 0 in the cache */
   /* replace232_1_0 -> 3 in the cache */
   /* replace232_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 3, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 786 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search233_0_0 -> 6 in the cache */
   /* search233_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search233_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 788, 298 },
      -1,
   } },

   /* replace233_0_0_0_0 -> 36 in the cache */
   /* replace233_0_0_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 9 },
      -1,
   } },
   /* replace233_0_0_1_0 -> 137 in the cache */
   /* replace233_0_0_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 790, 791 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8 /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 792, 793 },
      -1,
   } },
   /* replace233_1_0 -> 6 in the cache */
   /* replace233_1_1_0 -> 36 in the cache */
   /* replace233_1_1_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 36, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 795 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 794, 796, 797 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search234_0_0 -> 6 in the cache */
   /* search234_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search234_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 799, 298 },
      -1,
   } },

   /* replace234_0_0_0_0 -> 36 in the cache */
   /* replace234_0_0_0_1 -> 9 in the cache */
   /* replace234_0_0_0 -> 790 in the cache */
   /* replace234_0_0_1_0 -> 137 in the cache */
   /* replace234_0_0_1_1 -> 9 in the cache */
   /* replace234_0_0_1 -> 791 in the cache */
   /* replace234_0_0 -> 792 in the cache */
   /* replace234_0_1 -> 793 in the cache */
   /* replace234_0 -> 794 in the cache */
   /* replace234_1_0 -> 6 in the cache */
   /* replace234_1_1_0 -> 36 in the cache */
   /* replace234_1_1_1 -> 137 in the cache */
   /* replace234_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 795 },
      -1,
   } },
   /* replace234_2 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 794, 801, 797 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search235_0_0 -> 6 in the cache */
   /* search235_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search235_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 803, 298 },
      -1,
   } },

   /* replace235_0 -> 6 in the cache */
   /* replace235_1_0_0_0 -> 36 in the cache */
   /* replace235_1_0_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 9 },
      -1,
   } },
   /* replace235_1_0_1_0 -> 137 in the cache */
   /* replace235_1_0_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 805, 806 },
      -1,
   } },
   /* replace235_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 807, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 6, 808 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search236_0_0 -> 11 in the cache */
   /* search236_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search236_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 810, 298 },
      -1,
   } },

   /* replace236_0_0_0_0 -> 36 in the cache */
   /* replace236_0_0_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 14 },
      -1,
   } },
   /* replace236_0_0_1_0 -> 137 in the cache */
   /* replace236_0_0_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 812, 813 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10 /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 814, 815 },
      -1,
   } },
   /* replace236_1_0 -> 11 in the cache */
   /* replace236_1_1_0 -> 36 in the cache */
   /* replace236_1_1_1 -> 137 in the cache */
   /* replace236_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 795 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 816, 817, 818 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search237_0_0 -> 11 in the cache */
   /* search237_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search237_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 820, 298 },
      -1,
   } },

   /* replace237_0_0_0_0 -> 36 in the cache */
   /* replace237_0_0_0_1 -> 14 in the cache */
   /* replace237_0_0_0 -> 812 in the cache */
   /* replace237_0_0_1_0 -> 137 in the cache */
   /* replace237_0_0_1_1 -> 14 in the cache */
   /* replace237_0_0_1 -> 813 in the cache */
   /* replace237_0_0 -> 814 in the cache */
   /* replace237_0_1 -> 815 in the cache */
   /* replace237_0 -> 816 in the cache */
   /* replace237_1_0 -> 11 in the cache */
   /* replace237_1_1_0 -> 36 in the cache */
   /* replace237_1_1_1 -> 137 in the cache */
   /* replace237_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 795 },
      -1,
   } },
   /* replace237_2 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 816, 822, 818 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search238_0_0 -> 11 in the cache */
   /* search238_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search238_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 824, 298 },
      -1,
   } },

   /* replace238_0 -> 11 in the cache */
   /* replace238_1_0_0_0 -> 36 in the cache */
   /* replace238_1_0_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 14 },
      -1,
   } },
   /* replace238_1_0_1_0 -> 137 in the cache */
   /* replace238_1_0_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 826, 827 },
      -1,
   } },
   /* replace238_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 828, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 11, 829 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search239_0_0 -> 16 in the cache */
   /* search239_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search239_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 831, 298 },
      -1,
   } },

   /* replace239_0_0_0_0 -> 36 in the cache */
   /* replace239_0_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 19 },
      -1,
   } },
   /* replace239_0_0_1_0 -> 137 in the cache */
   /* replace239_0_0_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 833, 834 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20 /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 835, 836 },
      -1,
   } },
   /* replace239_1_0 -> 16 in the cache */
   /* replace239_1_1_0 -> 36 in the cache */
   /* replace239_1_1_1 -> 137 in the cache */
   /* replace239_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 795 },
      -1,
   } },
   /* replace239_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 837, 838, 124 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search240_0_0 -> 16 in the cache */
   /* search240_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search240_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 840, 298 },
      -1,
   } },

   /* replace240_0_0_0_0 -> 36 in the cache */
   /* replace240_0_0_0_1 -> 19 in the cache */
   /* replace240_0_0_0 -> 833 in the cache */
   /* replace240_0_0_1_0 -> 137 in the cache */
   /* replace240_0_0_1_1 -> 19 in the cache */
   /* replace240_0_0_1 -> 834 in the cache */
   /* replace240_0_0 -> 835 in the cache */
   /* replace240_0_1 -> 836 in the cache */
   /* replace240_0 -> 837 in the cache */
   /* replace240_1_0 -> 16 in the cache */
   /* replace240_1_1_0 -> 36 in the cache */
   /* replace240_1_1_1 -> 137 in the cache */
   /* replace240_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 795 },
      -1,
   } },
   /* replace240_2 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 837, 842, 124 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search241_0_0 -> 16 in the cache */
   /* search241_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search241_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 844, 298 },
      -1,
   } },

   /* replace241_0 -> 16 in the cache */
   /* replace241_1_0_0_0 -> 36 in the cache */
   /* replace241_1_0_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 19 },
      -1,
   } },
   /* replace241_1_0_1_0 -> 137 in the cache */
   /* replace241_1_0_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 846, 847 },
      -1,
   } },
   /* replace241_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 848, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 16, 849 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search242_0_0 -> 21 in the cache */
   /* search242_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search242_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 851, 298 },
      -1,
   } },

   /* replace242_0_0_0_0 -> 36 in the cache */
   /* replace242_0_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 24 },
      -1,
   } },
   /* replace242_0_0_1_0 -> 137 in the cache */
   /* replace242_0_0_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 137, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 853, 854 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40 /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 855, 856 },
      -1,
   } },
   /* replace242_1_0 -> 21 in the cache */
   /* replace242_1_1_0 -> 36 in the cache */
   /* replace242_1_1_1 -> 137 in the cache */
   /* replace242_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 795 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 857, 858, 859 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search243_0_0 -> 21 in the cache */
   /* search243_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search243_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 861, 298 },
      -1,
   } },

   /* replace243_0_0_0_0 -> 36 in the cache */
   /* replace243_0_0_0_1 -> 24 in the cache */
   /* replace243_0_0_0 -> 853 in the cache */
   /* replace243_0_0_1_0 -> 137 in the cache */
   /* replace243_0_0_1_1 -> 24 in the cache */
   /* replace243_0_0_1 -> 854 in the cache */
   /* replace243_0_0 -> 855 in the cache */
   /* replace243_0_1 -> 856 in the cache */
   /* replace243_0 -> 857 in the cache */
   /* replace243_1_0 -> 21 in the cache */
   /* replace243_1_1_0 -> 36 in the cache */
   /* replace243_1_1_1 -> 137 in the cache */
   /* replace243_1_1 -> 795 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 795 },
      -1,
   } },
   /* replace243_2 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 857, 863, 859 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search244_0_0 -> 21 in the cache */
   /* search244_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search244_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 865, 298 },
      -1,
   } },

   /* replace244_0 -> 21 in the cache */
   /* replace244_1_0_0_0 -> 36 in the cache */
   /* replace244_1_0_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 24 },
      -1,
   } },
   /* replace244_1_0_1_0 -> 137 in the cache */
   /* replace244_1_0_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 137, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 867, 868 },
      -1,
   } },
   /* replace244_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 869, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 21, 870 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search245_0_0 -> 6 in the cache */
   /* search245_0_1 -> 33 in the cache */
   /* search245_0 -> 799 in the cache */
   /* search245_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 799, 36 },
      -1,
   } },

   /* replace245_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   /* replace245_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 873, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 874 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search246_0_0 -> 6 in the cache */
   /* search246_0_1 -> 33 in the cache */
   /* search246_0 -> 803 in the cache */
   /* search246_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 803, 36 },
      -1,
   } },

   /* replace246_0 -> 6 in the cache */
   /* replace246_1_0 -> 873 in the cache */
   /* replace246_1_1 -> 36 in the cache */
   /* replace246_1 -> 874 in the cache */
   /* replace246 -> 875 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search247_0_0 -> 6 in the cache */
   /* search247_0_1 -> 33 in the cache */
   /* search247_0 -> 788 in the cache */
   /* search247_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 788, 36 },
      -1,
   } },

   /* replace247_0 -> 6 in the cache */
   /* replace247_1_0 -> 873 in the cache */
   /* replace247_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 873, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 878 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search248_0_0 -> 11 in the cache */
   /* search248_0_1 -> 33 in the cache */
   /* search248_0 -> 820 in the cache */
   /* search248_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 820, 36 },
      -1,
   } },

   /* replace248_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   /* replace248_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 881, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 882 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search249_0_0 -> 11 in the cache */
   /* search249_0_1 -> 33 in the cache */
   /* search249_0 -> 824 in the cache */
   /* search249_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 824, 36 },
      -1,
   } },

   /* replace249_0 -> 11 in the cache */
   /* replace249_1_0 -> 881 in the cache */
   /* replace249_1_1 -> 36 in the cache */
   /* replace249_1 -> 882 in the cache */
   /* replace249 -> 883 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search250_0_0 -> 11 in the cache */
   /* search250_0_1 -> 33 in the cache */
   /* search250_0 -> 810 in the cache */
   /* search250_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 810, 36 },
      -1,
   } },

   /* replace250_0 -> 11 in the cache */
   /* replace250_1_0 -> 881 in the cache */
   /* replace250_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 881, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 886 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search251_0_0 -> 16 in the cache */
   /* search251_0_1 -> 33 in the cache */
   /* search251_0 -> 840 in the cache */
   /* search251_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 840, 36 },
      -1,
   } },

   /* replace251_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffff /* 4294967295 */ },
   } },
   /* replace251_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 889, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 890 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search252_0_0 -> 16 in the cache */
   /* search252_0_1 -> 33 in the cache */
   /* search252_0 -> 844 in the cache */
   /* search252_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 844, 36 },
      -1,
   } },

   /* replace252_0 -> 16 in the cache */
   /* replace252_1_0 -> 889 in the cache */
   /* replace252_1_1 -> 36 in the cache */
   /* replace252_1 -> 890 in the cache */
   /* replace252 -> 891 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search253_0_0 -> 16 in the cache */
   /* search253_0_1 -> 33 in the cache */
   /* search253_0 -> 831 in the cache */
   /* search253_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 831, 36 },
      -1,
   } },

   /* replace253_0 -> 16 in the cache */
   /* replace253_1_0 -> 889 in the cache */
   /* replace253_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 889, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 894 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search254_0_0 -> 21 in the cache */
   /* search254_0_1 -> 33 in the cache */
   /* search254_0 -> 861 in the cache */
   /* search254_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 861, 36 },
      -1,
   } },

   /* replace254_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
   } },
   /* replace254_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 897, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 898 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search255_0_0 -> 21 in the cache */
   /* search255_0_1 -> 33 in the cache */
   /* search255_0 -> 865 in the cache */
   /* search255_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 865, 36 },
      -1,
   } },

   /* replace255_0 -> 21 in the cache */
   /* replace255_1_0 -> 897 in the cache */
   /* replace255_1_1 -> 36 in the cache */
   /* replace255_1 -> 898 in the cache */
   /* replace255 -> 899 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search256_0_0 -> 21 in the cache */
   /* search256_0_1 -> 33 in the cache */
   /* search256_0 -> 851 in the cache */
   /* search256_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 851, 36 },
      -1,
   } },

   /* replace256_0 -> 21 in the cache */
   /* replace256_1_0 -> 897 in the cache */
   /* replace256_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 897, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 902 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search257_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 904 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 905, 906 },
      -1,
   } },

   /* replace257_0 -> 16 in the cache */
   /* replace257_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search258_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 909 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 910, 911 },
      -1,
   } },

   /* replace258_0 -> 0 in the cache */
   /* replace258_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search259_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 914 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffe /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 915, 916 },
      -1,
   } },

   /* replace259_0_0 -> 16 in the cache */
   /* replace259_0_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 916 },
      -1,
   } },
   /* replace259_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 918, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search260_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 920 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffc /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 921, 922 },
      -1,
   } },

   /* replace260_0_0 -> 16 in the cache */
   /* replace260_0_1 -> 922 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 922 },
      -1,
   } },
   /* replace260_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 924, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search261_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 926 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8 /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 927, 928 },
      -1,
   } },

   /* replace261_0_0 -> 16 in the cache */
   /* replace261_0_1 -> 928 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 928 },
      -1,
   } },
   /* replace261_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 930, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search262_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 932 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0 /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 933, 934 },
      -1,
   } },

   /* replace262_0_0 -> 16 in the cache */
   /* replace262_0_1 -> 934 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 934 },
      -1,
   } },
   /* replace262_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 936, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search263_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 938 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0 /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 939, 940 },
      -1,
   } },

   /* replace263_0_0 -> 16 in the cache */
   /* replace263_0_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 940 },
      -1,
   } },
   /* replace263_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 942, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search264_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 944 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0 /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 945, 946 },
      -1,
   } },

   /* replace264_0_0 -> 16 in the cache */
   /* replace264_0_1 -> 946 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 946 },
      -1,
   } },
   /* replace264_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 948, 36 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search265_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffff /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 950 },
      -1,
   } },
   /* search265_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 951, 381 },
      -1,
   } },

   /* replace265_0 -> 16 in the cache */
   /* replace265_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 381 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search266_0_0 -> 16 in the cache */
   /* search266_0_1 -> 381 in the cache */
   /* search266_0 -> 953 in the cache */
   /* search266_1 -> 916 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 953, 916 },
      -1,
   } },

   /* replace266_0 -> 16 in the cache */
   /* replace266_1 -> 381 in the cache */
   /* replace266 -> 953 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search267_0_0 -> 16 in the cache */
   /* search267_0_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 381 },
      -1,
   } },
   /* search267_1 -> 950 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 955, 950 },
      -1,
   } },

   /* replace267_0 -> 16 in the cache */
   /* replace267_1 -> 381 in the cache */
   /* replace267 -> 955 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search268_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffff /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 957 },
      -1,
   } },
   /* search268_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 958, 386 },
      -1,
   } },

   /* replace268_0 -> 16 in the cache */
   /* replace268_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 386 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search269_0_0 -> 16 in the cache */
   /* search269_0_1 -> 386 in the cache */
   /* search269_0 -> 960 in the cache */
   /* search269_1 -> 922 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 960, 922 },
      -1,
   } },

   /* replace269_0 -> 16 in the cache */
   /* replace269_1 -> 386 in the cache */
   /* replace269 -> 960 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search270_0_0 -> 16 in the cache */
   /* search270_0_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 386 },
      -1,
   } },
   /* search270_1 -> 957 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 962, 957 },
      -1,
   } },

   /* replace270_0 -> 16 in the cache */
   /* replace270_1 -> 386 in the cache */
   /* replace270 -> 962 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search271_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 964 },
      -1,
   } },
   /* search271_1 -> 815 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 965, 815 },
      -1,
   } },

   /* replace271_0 -> 16 in the cache */
   /* replace271_1 -> 815 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 815 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search272_0_0 -> 16 in the cache */
   /* search272_0_1 -> 815 in the cache */
   /* search272_0 -> 967 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000 /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 967, 968 },
      -1,
   } },

   /* replace272_0 -> 16 in the cache */
   /* replace272_1 -> 815 in the cache */
   /* replace272 -> 967 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search273_0_0 -> 16 in the cache */
   /* search273_0_1 -> 815 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 815 },
      -1,
   } },
   /* search273_1 -> 964 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 970, 964 },
      -1,
   } },

   /* replace273_0 -> 16 in the cache */
   /* replace273_1 -> 815 in the cache */
   /* replace273 -> 970 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search274_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 972 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18 /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 973, 974 },
      -1,
   } },

   /* replace274_0 -> 16 in the cache */
   /* replace274_1 -> 974 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 974 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search275_0_0 -> 16 in the cache */
   /* search275_0_1 -> 974 in the cache */
   /* search275_0 -> 976 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000 /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 976, 977 },
      -1,
   } },

   /* replace275_0 -> 16 in the cache */
   /* replace275_1 -> 974 in the cache */
   /* replace275 -> 976 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search276_0_0 -> 16 in the cache */
   /* search276_0_1 -> 974 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 974 },
      -1,
   } },
   /* search276_1 -> 972 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 979, 972 },
      -1,
   } },

   /* replace276_0 -> 16 in the cache */
   /* replace276_1 -> 974 in the cache */
   /* replace276 -> 979 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search277_0_0 -> 0 in the cache */
   /* search277_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 783 },
      -1,
   } },
   /* search277_1 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 981, 298 },
      -1,
   } },

   /* replace277_0_0 -> 0 in the cache */
   /* replace277_0_1 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 137 },
      -1,
   } },
   /* replace277_1_0 -> 3 in the cache */
   /* replace277_1_1 -> 137 in the cache */
   /* replace277_1 -> 786 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 983, 786 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search278_0_0 -> 128 in the cache */
   /* search278_0_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 128, 272 },
      0,
   } },
   /* search278_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 985, 776 },
      -1,
   } },

   /* replace278_0_0 -> 128 in the cache */
   /* replace278_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 128, 131 },
      -1,
   } },
   /* replace278_1_0 -> 129 in the cache */
   /* replace278_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 987, 988 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search279_0_0_0 -> 151 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 151, 990 },
      0,
   } },
   /* search279_0_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 991, 154 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 992, 993 },
      -1,
   } },

   /* replace279_0_0_0 -> 151 in the cache */
   /* replace279_0_0_1 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 151, 154 },
      -1,
   } },
   /* replace279_0_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 995, 155 },
      -1,
   } },
   /* replace279_1_0 -> 152 in the cache */
   /* replace279_1_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 152, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 996, 997 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search280_0_0_0 -> 128 in the cache */
   /* search280_0_0_1 -> 272 in the cache */
   /* search280_0_0 -> 985 in the cache */
   /* search280_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 985, 131 },
      0,
   } },
   /* search280_1 -> 300 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 999, 300 },
      -1,
   } },

   /* replace280_0_0_0 -> 128 in the cache */
   /* replace280_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 128, 131 },
      -1,
   } },
   /* replace280_0_1 -> 165 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1001, 165 },
      -1,
   } },
   /* replace280_1_0 -> 129 in the cache */
   /* replace280_1_1 -> 165 in the cache */
   /* replace280_1 -> 779 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 1002, 779 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1004, 1005 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1006 },
      -1,
   } },

   /* replace281_0 -> 0 in the cache */
   /* replace281_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search282_0_0 -> 1004 in the cache */
   /* search282_0_1 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1004, 1005 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1009 },
      -1,
   } },

   /* replace282_0 -> 0 in the cache */
   /* replace282_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search283_0_0 -> 0 in the cache */
   /* search283_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1012 },
      -1,
   } },

   /* replace283_0 -> 0 in the cache */
   /* replace283_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search284_0_0 -> 0 in the cache */
   /* search284_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1015 },
      -1,
   } },

   /* replace284_0 -> 0 in the cache */
   /* replace284_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search285_0_0 -> 0 in the cache */
   /* search285_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1018 },
      -1,
   } },

   /* replace285_0 -> 0 in the cache */
   /* replace285_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search286_0_0 -> 0 in the cache */
   /* search286_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1021 },
      -1,
   } },

   /* replace286_0 -> 0 in the cache */
   /* replace286_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search287_0_0 -> 0 in the cache */
   /* search287_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1024 },
      -1,
   } },

   /* replace287_0 -> 0 in the cache */
   /* replace287_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search288_0_0 -> 0 in the cache */
   /* search288_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1027 },
      -1,
   } },

   /* replace288_0 -> 0 in the cache */
   /* replace288_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search289_0_0 -> 0 in the cache */
   /* search289_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1030 },
      -1,
   } },

   /* replace289_0 -> 0 in the cache */
   /* replace289_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search290_0_0 -> 0 in the cache */
   /* search290_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1033 },
      -1,
   } },

   /* replace290_0 -> 0 in the cache */
   /* replace290_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search291_0_0 -> 0 in the cache */
   /* search291_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search291_1_0 -> 0 in the cache */
   /* search291_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1036, 1037 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search292_0_0 -> 0 in the cache */
   /* search292_0_1 -> 3 in the cache */
   /* search292_0 -> 1011 in the cache */
   /* search292_1_0 -> 3 in the cache */
   /* search292_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1011, 1040 },
      -1,
   } },

   /* replace292 -> 1039 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search293_0_0 -> 0 in the cache */
   /* search293_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search293_1_0 -> 0 in the cache */
   /* search293_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1042, 1043 },
      -1,
   } },

   /* replace293 -> 1039 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search294_0_0 -> 0 in the cache */
   /* search294_0_1 -> 3 in the cache */
   /* search294_0 -> 1026 in the cache */
   /* search294_1_0 -> 3 in the cache */
   /* search294_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1026, 1045 },
      -1,
   } },

   /* replace294 -> 1039 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search295_0_0 -> 0 in the cache */
   /* search295_0_1 -> 3 in the cache */
   /* search295_0 -> 1029 in the cache */
   /* search295_1_0 -> 3 in the cache */
   /* search295_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1029, 1047 },
      -1,
   } },

   /* replace295 -> 1039 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search296_0_0 -> 0 in the cache */
   /* search296_0 -> 201 in the cache */
   /* search296_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 201, 1049 },
      -1,
   } },

   /* replace296_0 -> 3 in the cache */
   /* replace296_1 -> 0 in the cache */
   /* replace296 -> 1040 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search297_0_0 -> 0 in the cache */
   /* search297_0 -> 201 in the cache */
   /* search297_1_0 -> 3 in the cache */
   /* search297_1 -> 1049 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 201, 1049 },
      -1,
   } },

   /* replace297_0 -> 3 in the cache */
   /* replace297_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search298_0_0 -> 0 in the cache */
   /* search298_0 -> 201 in the cache */
   /* search298_1_0 -> 3 in the cache */
   /* search298_1 -> 1049 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 201, 1049 },
      -1,
   } },

   /* replace298_0 -> 3 in the cache */
   /* replace298_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search299_0_0 -> 0 in the cache */
   /* search299_0 -> 201 in the cache */
   /* search299_1_0 -> 3 in the cache */
   /* search299_1 -> 1049 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 201, 1049 },
      -1,
   } },

   /* replace299_0 -> 3 in the cache */
   /* replace299_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a') */
   /* search300_0_0 -> 32 in the cache */
   /* search300_0 -> 98 in the cache */
   /* search300_1 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 98, 236 },
      -1,
   } },

   /* replace300_0 -> 230 in the cache */
   /* replace300_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 230, 32 },
      -1,
   } },

   /* ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0) */
   /* search301_0 -> 236 in the cache */
   /* search301_1_0 -> 32 in the cache */
   /* search301_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 236, 98 },
      -1,
   } },

   /* replace301_0 -> 32 in the cache */
   /* replace301_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 230 },
      -1,
   } },

   /* ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a') */
   /* search302_0_0 -> 32 in the cache */
   /* search302_0 -> 98 in the cache */
   /* search302_1 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 98, 236 },
      -1,
   } },

   /* replace302_0 -> 230 in the cache */
   /* replace302_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 230, 32 },
      -1,
   } },

   /* ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0) */
   /* search303_0 -> 236 in the cache */
   /* search303_1_0 -> 32 in the cache */
   /* search303_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 236, 98 },
      -1,
   } },

   /* replace303_0 -> 32 in the cache */
   /* replace303_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 230 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a') */
   /* search304_0_0 -> 32 in the cache */
   /* search304_0 -> 98 in the cache */
   /* search304_1 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 236 },
      -1,
   } },

   /* replace304_0 -> 230 in the cache */
   /* replace304_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 230, 32 },
      -1,
   } },

   /* ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0) */
   /* search305_0 -> 236 in the cache */
   /* search305_1_0 -> 32 in the cache */
   /* search305_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 236, 98 },
      -1,
   } },

   /* replace305_0 -> 32 in the cache */
   /* replace305_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 230 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1070 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1069, 1071 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace306_1 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1073, 1070 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search307_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1075, 1076 },
      -1,
   } },

   /* replace307_0 -> 0 in the cache */
   /* replace307_1 -> 3 in the cache */
   /* replace307 -> 1008 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search308_0_0 -> 0 in the cache */
   /* search308_0 -> 1075 in the cache */
   /* search308_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1075, 1076 },
      -1,
   } },

   /* replace308_0 -> 0 in the cache */
   /* replace308_1 -> 3 in the cache */
   /* replace308 -> 1017 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search309_0_0 -> 0 in the cache */
   /* search309_0 -> 1075 in the cache */
   /* search309_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1075, 1076 },
      -1,
   } },

   /* replace309_0 -> 0 in the cache */
   /* replace309_1 -> 3 in the cache */
   /* replace309 -> 1014 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search310_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      0,
   } },
   /* search310_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1080, 230 },
      -1,
   } },

   /* replace310_0 -> 32 in the cache */
   /* replace310_1 -> 230 in the cache */
   /* replace310 -> 1064 in the cache */

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search311_0 -> 113 in the cache */
   /* search311_1_0 -> 32 in the cache */
   /* search311_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 1080 },
      -1,
   } },

   /* replace311_0 -> 113 in the cache */
   /* replace311_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search312_1_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 722 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1084, 1085 },
      -1,
   } },

   /* replace312_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 722 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search313_0_0_0 -> 722 in the cache */
   /* search313_0_0 -> 1085 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1085 },
      -1,
   } },
   /* search313_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1088, 1084 },
      -1,
   } },

   /* replace313_0 -> 722 in the cache */
   /* replace313 -> 1087 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search314_0_0_0 -> 722 in the cache */
   /* search314_0_0 -> 1085 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1085, 1091 },
      -1,
   } },
   /* search314_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1092, 1084 },
      -1,
   } },

   /* replace314_0 -> 722 in the cache */
   /* replace314_1 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 722, 1090 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search315_0_0 -> 722 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search315_0_2_0 -> 1090 in the cache */
   /* search315_0_2 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1095, 1091 },
      -1,
   } },
   /* search315_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1096, 1084 },
      -1,
   } },

   /* replace315_0 -> 722 in the cache */
   /* replace315_1 -> 1090 in the cache */
   /* replace315 -> 1094 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search316_0_0 -> 722 in the cache */
   /* search316_0 -> 1085 in the cache */
   /* search316_1_0_0 -> 1090 in the cache */
   /* search316_1_0 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1091 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1085, 1098 },
      -1,
   } },

   /* replace316_0 -> 722 in the cache */
   /* replace316_1 -> 1090 in the cache */
   /* replace316 -> 1094 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search317_0_0_0 -> 722 in the cache */
   /* search317_0_0 -> 1085 in the cache */
   /* search317_0_1_0 -> 1090 in the cache */
   /* search317_0_1 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1085, 1091 },
      -1,
   } },
   /* search317_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1100, 1084 },
      -1,
   } },

   /* replace317_0 -> 722 in the cache */
   /* replace317_1 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 722, 1090 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search318_0_0 -> 722 in the cache */
   /* search318_0_1_0 -> 1090 in the cache */
   /* search318_0_1 -> 1091 in the cache */
   /* search318_0_2 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1091, 1084 },
      -1,
   } },
   /* search318_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1103, 1084 },
      -1,
   } },

   /* replace318_0 -> 722 in the cache */
   /* replace318_1 -> 1090 in the cache */
   /* replace318 -> 1102 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search319_0_0_0 -> 722 in the cache */
   /* search319_0_0 -> 1085 in the cache */
   /* search319_0_1_0_0 -> 1090 in the cache */
   /* search319_0_1_0 -> 1091 in the cache */
   /* search319_0_1 -> 1098 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1085, 1098 },
      -1,
   } },
   /* search319_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1105, 1084 },
      -1,
   } },

   /* replace319_0 -> 722 in the cache */
   /* replace319_1 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 722, 1090 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search320_0_0 -> 722 in the cache */
   /* search320_0 -> 1085 in the cache */
   /* search320_1_0 -> 1090 in the cache */
   /* search320_1 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1085, 1091 },
      -1,
   } },

   /* replace320_0 -> 722 in the cache */
   /* replace320_1 -> 1090 in the cache */
   /* replace320 -> 1107 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search321_0_0_0 -> 722 in the cache */
   /* search321_0_0 -> 1085 in the cache */
   /* search321_0 -> 1088 in the cache */
   /* search321_1_0_0 -> 1090 in the cache */
   /* search321_1_0 -> 1091 in the cache */
   /* search321_1 -> 1098 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1088, 1098 },
      -1,
   } },

   /* replace321_0 -> 722 in the cache */
   /* replace321_1 -> 1090 in the cache */
   /* replace321 -> 1107 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search322_0_0_0 -> 722 in the cache */
   /* search322_0_0 -> 1085 in the cache */
   /* search322_0_1_0 -> 1090 in the cache */
   /* search322_0_1 -> 1091 in the cache */
   /* search322_0 -> 1092 in the cache */
   /* search322_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1092, 1084 },
      -1,
   } },

   /* replace322_0_0 -> 722 in the cache */
   /* replace322_0_1 -> 1090 in the cache */
   /* replace322_0 -> 1094 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1094 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search323_0_0 -> 722 in the cache */
   /* search323_0_1 -> 1095 in the cache */
   /* search323_0_2_0 -> 1090 in the cache */
   /* search323_0_2 -> 1091 in the cache */
   /* search323_0 -> 1096 in the cache */
   /* search323_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1096, 1084 },
      -1,
   } },

   /* replace323_0_0 -> 722 in the cache */
   /* replace323_0_1 -> 1090 in the cache */
   /* replace323_0 -> 1094 in the cache */
   /* replace323 -> 1111 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search324_0_0 -> 722 in the cache */
   /* search324_0 -> 1085 in the cache */
   /* search324_1_0_0 -> 1090 in the cache */
   /* search324_1_0 -> 1091 in the cache */
   /* search324_1 -> 1098 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1085, 1098 },
      -1,
   } },

   /* replace324_0_0 -> 722 in the cache */
   /* replace324_0_1 -> 1090 in the cache */
   /* replace324_0 -> 1094 in the cache */
   /* replace324 -> 1111 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search325_0_0_0 -> 722 in the cache */
   /* search325_0_0 -> 1085 in the cache */
   /* search325_0_1_0 -> 1090 in the cache */
   /* search325_0_1 -> 1091 in the cache */
   /* search325_0 -> 1100 in the cache */
   /* search325_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1100, 1084 },
      -1,
   } },

   /* replace325_0_0 -> 722 in the cache */
   /* replace325_0_1 -> 1090 in the cache */
   /* replace325_0 -> 1102 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1102 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search326_0_0 -> 722 in the cache */
   /* search326_0_1_0 -> 1090 in the cache */
   /* search326_0_1 -> 1091 in the cache */
   /* search326_0_2 -> 1084 in the cache */
   /* search326_0 -> 1103 in the cache */
   /* search326_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1103, 1084 },
      -1,
   } },

   /* replace326_0_0 -> 722 in the cache */
   /* replace326_0_1 -> 1090 in the cache */
   /* replace326_0 -> 1102 in the cache */
   /* replace326 -> 1115 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search327_0_0_0 -> 722 in the cache */
   /* search327_0_0 -> 1085 in the cache */
   /* search327_0_1_0_0 -> 1090 in the cache */
   /* search327_0_1_0 -> 1091 in the cache */
   /* search327_0_1 -> 1098 in the cache */
   /* search327_0 -> 1105 in the cache */
   /* search327_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1105, 1084 },
      -1,
   } },

   /* replace327_0 -> 722 in the cache */
   /* replace327_1 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 722, 1090 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search328_0_0 -> 722 in the cache */
   /* search328_0 -> 1085 in the cache */
   /* search328_1_0 -> 1090 in the cache */
   /* search328_1 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1085, 1091 },
      -1,
   } },

   /* replace328_0 -> 722 in the cache */
   /* replace328_1 -> 1090 in the cache */
   /* replace328 -> 1118 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search329_0_0_0 -> 722 in the cache */
   /* search329_0_0 -> 1085 in the cache */
   /* search329_0 -> 1088 in the cache */
   /* search329_1_0_0 -> 1090 in the cache */
   /* search329_1_0 -> 1091 in the cache */
   /* search329_1 -> 1098 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1088, 1098 },
      -1,
   } },

   /* replace329_0 -> 722 in the cache */
   /* replace329_1 -> 1090 in the cache */
   /* replace329 -> 1118 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search330_0_0_0_0 -> 722 in the cache */
   /* search330_0_0_0 -> 1085 in the cache */
   /* search330_0_0_1_0 -> 1090 in the cache */
   /* search330_0_0_1 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1085, 1091 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1121 },
      -1,
   } },
   /* search330_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1122, 1084 },
      -1,
   } },

   /* replace330_0 -> 722 in the cache */
   /* replace330_1 -> 1090 in the cache */
   /* replace330 -> 1094 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search331_0 -> 1084 in the cache */
   /* search331_1_0_0 -> 722 in the cache */
   /* search331_1_0 -> 1085 in the cache */
   /* search331_1_1_0 -> 1090 in the cache */
   /* search331_1_1 -> 1091 in the cache */
   /* search331_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1084, 1121 },
      -1,
   } },

   /* replace331_0 -> 722 in the cache */
   /* replace331_1 -> 1090 in the cache */
   /* replace331 -> 1094 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search332_0_0_0_0 -> 722 in the cache */
   /* search332_0_0_0 -> 1085 in the cache */
   /* search332_0_0_1_0 -> 1090 in the cache */
   /* search332_0_0_1 -> 1091 in the cache */
   /* search332_0_0 -> 1121 in the cache */
   /* search332_0 -> 1122 in the cache */
   /* search332_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1122, 1084 },
      -1,
   } },

   /* replace332_0_0 -> 722 in the cache */
   /* replace332_0_1 -> 1090 in the cache */
   /* replace332_0 -> 1094 in the cache */
   /* replace332 -> 1111 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search333_0 -> 1084 in the cache */
   /* search333_1_0_0 -> 722 in the cache */
   /* search333_1_0 -> 1085 in the cache */
   /* search333_1_1_0 -> 1090 in the cache */
   /* search333_1_1 -> 1091 in the cache */
   /* search333_1 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1084, 1121 },
      -1,
   } },

   /* replace333_0_0 -> 722 in the cache */
   /* replace333_0_1 -> 1090 in the cache */
   /* replace333_0 -> 1094 in the cache */
   /* replace333 -> 1111 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search334_0 -> 32 in the cache */
   /* search334_1_0 -> 32 in the cache */
   /* search334_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace334_0 -> 32 in the cache */
   /* replace334_1 -> 113 in the cache */
   /* replace334 -> 674 in the cache */

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search335_0 -> 32 in the cache */
   /* search335_1_0 -> 32 in the cache */
   /* search335_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace335_0 -> 32 in the cache */
   /* replace335_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 113 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1131 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1132, 1134 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1135 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1130, 1136 },
      -1,
   } },
   /* search336_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1137, 113 },
      -1,
   } },

   /* replace336_0_0 -> 1130 in the cache */
   /* replace336_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1130, 113 },
      -1,
   } },
   /* replace336_1_0 -> 1131 in the cache */
   /* replace336_1_1 -> 1133 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1131, 1133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1139, 1140 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search337_0_0 -> 0 in the cache */
   /* search337_0_1 -> 3 in the cache */
   /* search337_0 -> 261 in the cache */
   /* search337_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 261, 0 },
      -1,
   } },

   /* replace337_0 -> 3 in the cache */
   /* replace337_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 245 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search338_0_0 -> 0 in the cache */
   /* search338_0_1 -> 3 in the cache */
   /* search338_0 -> 261 in the cache */
   /* search338_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 261, 0 },
      -1,
   } },

   /* replace338_0 -> 3 in the cache */
   /* replace338_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 245 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search339_0_0 -> 0 in the cache */
   /* search339_0_1 -> 3 in the cache */
   /* search339_0 -> 202 in the cache */
   /* search339_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 202, 0 },
      -1,
   } },

   /* replace339_0 -> 3 in the cache */
   /* replace339_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 245 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search340_0_0 -> 0 in the cache */
   /* search340_0_1 -> 3 in the cache */
   /* search340_0 -> 202 in the cache */
   /* search340_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 202, 0 },
      -1,
   } },

   /* replace340_0 -> 3 in the cache */
   /* replace340_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 245 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search341_0_0 -> 128 in the cache */
   /* search341_0_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 128, 272 },
      0,
   } },
   /* search341_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1150, 776 },
      -1,
   } },

   /* replace341_0 -> 128 in the cache */
   /* replace341_1_0 -> 131 in the cache */
   /* replace341_1_1_0 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 129 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 131, 1152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 128, 1153 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search342_0_0_0 -> 128 in the cache */
   /* search342_0_0_1 -> 272 in the cache */
   /* search342_0_0 -> 1150 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1150 },
      0,
   } },
   /* search342_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1155, 776 },
      -1,
   } },

   /* replace342_0_0_0 -> 131 in the cache */
   /* replace342_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 131, 129 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1157 },
      -1,
   } },
   /* replace342_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1158, 128 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search343_0_0 -> 128 in the cache */
   /* search343_0_1 -> 272 in the cache */
   /* search343_0 -> 1150 in the cache */
   /* search343_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1150, 776 },
      -1,
   } },

   /* replace343_0 -> 128 in the cache */
   /* replace343_1_0 -> 131 in the cache */
   /* replace343_1_1_0 -> 129 in the cache */
   /* replace343_1_1 -> 1152 in the cache */
   /* replace343_1 -> 1153 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 128, 1153 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search344_0_0_0 -> 128 in the cache */
   /* search344_0_0_1 -> 272 in the cache */
   /* search344_0_0 -> 1150 in the cache */
   /* search344_0 -> 1155 in the cache */
   /* search344_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1155, 776 },
      -1,
   } },

   /* replace344_0_0_0 -> 131 in the cache */
   /* replace344_0_0_1 -> 129 in the cache */
   /* replace344_0_0 -> 1157 in the cache */
   /* replace344_0 -> 1158 in the cache */
   /* replace344_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1158, 128 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search345_0_0 -> 128 in the cache */
   /* search345_0_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 128, 272 },
      0,
   } },
   /* search345_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1164, 776 },
      -1,
   } },

   /* replace345_0 -> 128 in the cache */
   /* replace345_1_0 -> 131 in the cache */
   /* replace345_1_1_0 -> 129 in the cache */
   /* replace345_1_1 -> 1152 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 131, 1152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 128, 1166 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search346_0_0_0 -> 128 in the cache */
   /* search346_0_0_1 -> 272 in the cache */
   /* search346_0_0 -> 1164 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1164 },
      0,
   } },
   /* search346_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1168, 776 },
      -1,
   } },

   /* replace346_0_0_0 -> 131 in the cache */
   /* replace346_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 131, 129 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1170 },
      -1,
   } },
   /* replace346_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1171, 128 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search347_0_0 -> 128 in the cache */
   /* search347_0_1 -> 272 in the cache */
   /* search347_0 -> 1164 in the cache */
   /* search347_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1164, 776 },
      -1,
   } },

   /* replace347_0 -> 128 in the cache */
   /* replace347_1_0 -> 131 in the cache */
   /* replace347_1_1_0 -> 129 in the cache */
   /* replace347_1_1 -> 1152 in the cache */
   /* replace347_1 -> 1166 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 128, 1166 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search348_0_0_0 -> 128 in the cache */
   /* search348_0_0_1 -> 272 in the cache */
   /* search348_0_0 -> 1164 in the cache */
   /* search348_0 -> 1168 in the cache */
   /* search348_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1168, 776 },
      -1,
   } },

   /* replace348_0_0_0 -> 131 in the cache */
   /* replace348_0_0_1 -> 129 in the cache */
   /* replace348_0_0 -> 1170 in the cache */
   /* replace348_0 -> 1171 in the cache */
   /* replace348_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1171, 128 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search349_0_0 -> 0 in the cache */
   /* search349_0_1 -> 3 in the cache */
   /* search349_0 -> 197 in the cache */
   /* search349_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 197, 0 },
      -1,
   } },

   /* replace349_0 -> 3 in the cache */
   /* replace349_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search350_0_0 -> 0 in the cache */
   /* search350_0_1 -> 3 in the cache */
   /* search350_0 -> 197 in the cache */
   /* search350_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 197, 0 },
      -1,
   } },

   /* replace350_0 -> 3 in the cache */
   /* replace350_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search351_0_0 -> 722 in the cache */
   /* search351_0 -> 1085 in the cache */
   /* search351_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1085, 1084 },
      -1,
   } },

   /* replace351_0 -> 722 in the cache */
   /* replace351 -> 1087 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search352_0_0 -> 722 in the cache */
   /* search352_0 -> 1085 in the cache */
   /* search352_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1085, 1084 },
      -1,
   } },

   /* replace352 -> 722 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search353_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 722 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1183, 1184 },
      -1,
   } },

   /* replace353_0 -> 722 in the cache */
   /* replace353 -> 1087 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search354_0_0 -> 722 in the cache */
   /* search354_0 -> 1183 in the cache */
   /* search354_1 -> 1184 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1183, 1184 },
      -1,
   } },

   /* replace354 -> 722 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search355_0_0 -> 32 in the cache */
   /* search355_0 -> 104 in the cache */
   /* search355_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 104, 1084 },
      -1,
   } },

   /* replace355_0 -> 32 in the cache */
   /* replace355_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search356_0_0 -> 32 in the cache */
   /* search356_0 -> 104 in the cache */
   /* search356_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 104, 1084 },
      -1,
   } },

   /* replace356_0 -> 32 in the cache */
   /* replace356_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search357_0_0 -> 32 in the cache */
   /* search357_0 -> 104 in the cache */
   /* search357_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 104, 1084 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search358_0 -> 1084 in the cache */
   /* search358_1_0 -> 32 in the cache */
   /* search358_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1084, 104 },
      -1,
   } },

   /* replace358_0 -> 61 in the cache */
   /* replace358_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search359_0_0 -> 32 in the cache */
   /* search359_0 -> 104 in the cache */
   /* search359_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 104, 1084 },
      -1,
   } },

   /* replace359 -> 1039 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search360_0 -> 1084 in the cache */
   /* search360_1_0 -> 32 in the cache */
   /* search360_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1084, 104 },
      -1,
   } },

   /* replace360_0 -> 61 in the cache */
   /* replace360_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search361_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search361_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1198, 1084 },
      -1,
   } },

   /* replace361_0 -> 32 in the cache */
   /* replace361_1 -> 61 in the cache */
   /* replace361 -> 1188 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search362_0_0 -> 32 in the cache */
   /* search362_0 -> 1198 in the cache */
   /* search362_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1198, 1084 },
      -1,
   } },

   /* replace362_0 -> 32 in the cache */
   /* replace362_1 -> 61 in the cache */
   /* replace362 -> 1190 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search363_0_0 -> 32 in the cache */
   /* search363_0 -> 1198 in the cache */
   /* search363_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1198, 1084 },
      -1,
   } },

   /* replace363_0 -> 32 in the cache */
   /* replace363_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search364_0 -> 1084 in the cache */
   /* search364_1_0 -> 32 in the cache */
   /* search364_1 -> 1198 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1084, 1198 },
      -1,
   } },

   /* replace364_0 -> 61 in the cache */
   /* replace364_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search365_0_0 -> 32 in the cache */
   /* search365_0 -> 1198 in the cache */
   /* search365_1 -> 1084 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1198, 1084 },
      -1,
   } },

   /* replace365_0 -> 32 in the cache */
   /* replace365_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search366_0 -> 1084 in the cache */
   /* search366_1_0 -> 32 in the cache */
   /* search366_1 -> 1198 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1084, 1198 },
      -1,
   } },

   /* replace366_0 -> 61 in the cache */
   /* replace366_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search367_0 -> 113 in the cache */
   /* search367_1_0 -> 32 in the cache */
   /* search367_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace367_0 -> 32 in the cache */
   /* replace367_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search368_0_0_0 -> 32 in the cache */
   /* search368_0_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 103 },
      -1,
   } },
   /* search368_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1211, 113 },
      -1,
   } },

   /* replace368_0 -> 32 in the cache */
   /* replace368_1 -> 113 in the cache */
   /* replace368 -> 1210 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search369_0 -> 113 in the cache */
   /* search369_1_0 -> 32 in the cache */
   /* search369_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace369_0 -> 32 in the cache */
   /* replace369_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search370_0_0_0 -> 32 in the cache */
   /* search370_0_0 -> 103 in the cache */
   /* search370_0 -> 1211 in the cache */
   /* search370_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1211, 113 },
      -1,
   } },

   /* replace370_0 -> 32 in the cache */
   /* replace370_1 -> 113 in the cache */
   /* replace370 -> 1214 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search371_0_0 -> 32 in the cache */
   /* search371_0_1 -> 113 in the cache */
   /* search371_0 -> 1129 in the cache */
   /* search371_1_0 -> 230 in the cache */
   /* search371_1_1 -> 32 in the cache */
   /* search371_1 -> 1062 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1129, 1062 },
      -1,
   } },

   /* replace371_0 -> 32 in the cache */
   /* replace371_1_0 -> 32 in the cache */
   /* replace371_1 -> 206 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 206 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search372_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 722 },
      0,
   } },
   /* search372_1_0 -> 1090 in the cache */
   /* search372_1 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1218, 1091 },
      -1,
   } },

   /* replace372_0_0 -> 722 in the cache */
   /* replace372_0_1 -> 1090 in the cache */
   /* replace372_0 -> 1094 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1094 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search373_0_0_0 -> 722 in the cache */
   /* search373_0_0 -> 1218 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1218 },
      0,
   } },
   /* search373_1_0_0 -> 1090 in the cache */
   /* search373_1_0 -> 1091 in the cache */
   /* search373_1 -> 1098 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1221, 1098 },
      -1,
   } },

   /* replace373_0_0_0 -> 722 in the cache */
   /* replace373_0_0_1 -> 1090 in the cache */
   /* replace373_0_0 -> 1102 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1102 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1223 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search374_0_0 -> 722 in the cache */
   /* search374_0 -> 1218 in the cache */
   /* search374_1_0 -> 1090 in the cache */
   /* search374_1 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1218, 1091 },
      -1,
   } },

   /* replace374_0_0 -> 722 in the cache */
   /* replace374_0_1 -> 1090 in the cache */
   /* replace374_0 -> 1102 in the cache */
   /* replace374 -> 1223 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search375_0_0_0 -> 722 in the cache */
   /* search375_0_0 -> 1218 in the cache */
   /* search375_0 -> 1221 in the cache */
   /* search375_1_0_0 -> 1090 in the cache */
   /* search375_1_0 -> 1091 in the cache */
   /* search375_1 -> 1098 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1221, 1098 },
      -1,
   } },

   /* replace375_0_0_0 -> 722 in the cache */
   /* replace375_0_0_1 -> 1090 in the cache */
   /* replace375_0_0 -> 1094 in the cache */
   /* replace375_0 -> 1220 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1220 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search376_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search376_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1228, 783 },
      -1,
   } },

   /* replace376_0 -> 722 in the cache */
   /* replace376_1_0 -> 3 in the cache */
   /* replace376_1_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 3, 259 },
      -1,
   } },
   /* replace376_2_0 -> 3 in the cache */
   /* replace376_2_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 3, 245 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 722, 1230, 1231 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search377_0_0 -> 0 in the cache */
   /* search377_0_1_0 -> 3 in the cache */
   /* search377_0_1 -> 1049 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1049 },
      0,
   } },
   /* search377_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1233, 245 },
      -1,
   } },

   /* replace377_0 -> 0 in the cache */
   /* replace377_1 -> 3 in the cache */
   /* replace377 -> 1011 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search378_0_0_0 -> 32 in the cache */
   /* search378_0_0 -> 103 in the cache */
   /* search378_0 -> 1211 in the cache */
   /* search378_1 -> 113 in the cache */
   /* search378 -> 1215 in the cache */

   /* replace378_0 -> 32 in the cache */
   /* replace378_1 -> 113 in the cache */
   /* replace378 -> 1214 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search379_0_0 -> 1073 in the cache */
   /* search379_0_1 -> 1070 in the cache */
   /* search379_0 -> 1074 in the cache */
   /* search379_1 -> 1073 in the cache */
   /* search379_2 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1074, 1073, 1070 },
      -1,
   } },

   /* replace379_0 -> 1070 in the cache */
   /* replace379_1 -> 1073 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1070, 1073 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search380_0_0 -> 0 in the cache */
   /* search380_0_1 -> 3 in the cache */
   /* search380_0 -> 1011 in the cache */
   /* search380_1 -> 3 in the cache */
   /* search380_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1011, 3, 0 },
      -1,
   } },

   /* replace380_0 -> 0 in the cache */
   /* replace380_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search381_0_0 -> 0 in the cache */
   /* search381_0_1 -> 3 in the cache */
   /* search381_0 -> 1008 in the cache */
   /* search381_1 -> 3 in the cache */
   /* search381_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1008, 3, 0 },
      -1,
   } },

   /* replace381_0 -> 0 in the cache */
   /* replace381_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search382_0_0 -> 1073 in the cache */
   /* search382_0_1 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1073, 1070 },
      -1,
   } },
   /* search382_1 -> 1073 in the cache */
   /* search382_2 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1241, 1073, 1070 },
      -1,
   } },

   /* replace382_0 -> 1070 in the cache */
   /* replace382_1 -> 1073 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1070, 1073 },
      -1,
   } },

   /* ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c') */
   /* search383_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search383_1 -> 129 in the cache */
   /* search383_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1244, 129, 131 },
      -1,
   } },

   /* replace383_0_0 -> 32 in the cache */
   /* replace383_0_1 -> 61 in the cache */
   /* replace383_0 -> 1188 in the cache */
   /* replace383_1 -> 129 in the cache */
   /* replace383_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 1188, 129, 131 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search384_0_0 -> 722 in the cache */
   /* search384_0 -> 1087 in the cache */
   /* search384_1 -> 129 in the cache */
   /* search384_2 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1087, 129, 131 },
      -1,
   } },

   /* replace384_0 -> 722 in the cache */
   /* replace384_1 -> 131 in the cache */
   /* replace384_2 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 131, 129 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search385_0 -> 722 in the cache */
   /* search385_1_0 -> 722 in the cache */
   /* search385_1_1 -> 152 in the cache */
   /* search385_1_2 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 152, 154 },
      -1,
   } },
   /* search385_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1249, 155 },
      -1,
   } },

   /* replace385_0 -> 722 in the cache */
   /* replace385_1 -> 152 in the cache */
   /* replace385_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 152, 155 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search386_0 -> 722 in the cache */
   /* search386_1 -> 152 in the cache */
   /* search386_2_0 -> 722 in the cache */
   /* search386_2_1 -> 154 in the cache */
   /* search386_2_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 154, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 152, 1252 },
      -1,
   } },

   /* replace386_0 -> 722 in the cache */
   /* replace386_1 -> 152 in the cache */
   /* replace386_2 -> 155 in the cache */
   /* replace386 -> 1251 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search387_0 -> 722 in the cache */
   /* search387_1_0 -> 1090 in the cache */
   /* search387_1_1 -> 715 in the cache */
   /* search387_1_2 -> 724 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 715, 724 },
      -1,
   } },
   /* search387_2_0 -> 1090 in the cache */
   /* search387_2_1 -> 715 in the cache */
   /* search387_2_2 -> 726 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 715, 726 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1254, 1255 },
      -1,
   } },

   /* replace387_0 -> 1090 in the cache */
   /* replace387_1 -> 715 in the cache */
   /* replace387_2_0 -> 722 in the cache */
   /* replace387_2_1 -> 724 in the cache */
   /* replace387_2_2 -> 726 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 724, 726 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 715, 1257 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search388_0 -> 722 in the cache */
   /* search388_1_0 -> 1090 in the cache */
   /* search388_1_1 -> 715 in the cache */
   /* search388_1_2 -> 724 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 715, 724 },
      0,
   } },
   /* search388_2_0 -> 1090 in the cache */
   /* search388_2_1 -> 715 in the cache */
   /* search388_2_2 -> 726 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 715, 726 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1259, 1260 },
      -1,
   } },

   /* replace388_0 -> 1090 in the cache */
   /* replace388_1 -> 715 in the cache */
   /* replace388_2_0 -> 722 in the cache */
   /* replace388_2_1 -> 724 in the cache */
   /* replace388_2_2 -> 726 in the cache */
   /* replace388_2 -> 1257 in the cache */
   /* replace388 -> 1258 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search389_0 -> 722 in the cache */
   /* search389_1_0 -> 1090 in the cache */
   /* search389_1_1 -> 154 in the cache */
   /* search389_1_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 154, 155 },
      -1,
   } },
   /* search389_2_0 -> 1090 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search389_2_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 1263, 155 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1262, 1264 },
      -1,
   } },

   /* replace389_0 -> 1090 in the cache */
   /* replace389_1_0 -> 722 in the cache */
   /* replace389_1_1 -> 154 in the cache */
   /* replace389_1_2 -> 1263 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 154, 1263 },
      -1,
   } },
   /* replace389_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 1266, 155 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search390_0 -> 722 in the cache */
   /* search390_1_0 -> 1090 in the cache */
   /* search390_1_1 -> 154 in the cache */
   /* search390_1_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 154, 155 },
      0,
   } },
   /* search390_2_0 -> 1090 in the cache */
   /* search390_2_1 -> 1263 in the cache */
   /* search390_2_2 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1090, 1263, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1268, 1269 },
      -1,
   } },

   /* replace390_0 -> 1090 in the cache */
   /* replace390_1_0 -> 722 in the cache */
   /* replace390_1_1 -> 154 in the cache */
   /* replace390_1_2 -> 1263 in the cache */
   /* replace390_1 -> 1266 in the cache */
   /* replace390_2 -> 155 in the cache */
   /* replace390 -> 1267 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search391_0 -> 722 in the cache */
   /* search391_1 -> 1192 in the cache */
   /* search391_2 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1192, 1090 },
      -1,
   } },

   /* replace391_0 -> 722 in the cache */
   /* replace391_1 -> 1090 in the cache */
   /* replace391 -> 1094 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search392_0 -> 722 in the cache */
   /* search392_1 -> 722 in the cache */
   /* search392_2 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 722, 1090 },
      -1,
   } },

   /* replace392_0 -> 722 in the cache */
   /* replace392_1 -> 1090 in the cache */
   /* replace392 -> 1094 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search393_0 -> 722 in the cache */
   /* search393_1 -> 1090 in the cache */
   /* search393_2 -> 1039 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1090, 1039 },
      -1,
   } },

   /* replace393_0 -> 722 in the cache */
   /* replace393_1 -> 1090 in the cache */
   /* replace393 -> 1102 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search394_0 -> 722 in the cache */
   /* search394_1 -> 1090 in the cache */
   /* search394_2 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1090, 722 },
      -1,
   } },

   /* replace394_0 -> 722 in the cache */
   /* replace394_1 -> 1090 in the cache */
   /* replace394 -> 1102 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search395_0 -> 32 in the cache */
   /* search395_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace395 -> 32 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search396_0 -> 32 in the cache */
   /* search396_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace396 -> 32 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search397_0 -> 32 in the cache */
   /* search397_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace397 -> 32 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search398_0 -> 32 in the cache */
   /* search398_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace398 -> 32 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search399_0 -> 32 in the cache */
   /* search399_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace399 -> 32 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search400_0 -> 32 in the cache */
   /* search400_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace400 -> 61 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search401_0 -> 32 in the cache */
   /* search401_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace401 -> 32 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search402_0 -> 32 in the cache */
   /* search402_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace402 -> 32 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search403_0 -> 32 in the cache */
   /* search403_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace403 -> 32 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search404_0 -> 32 in the cache */
   /* search404_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace404 -> 63 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search405_0_0 -> 0 in the cache */
   /* search405_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search405_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1285, 3 },
      -1,
   } },

   /* replace405_0 -> 0 in the cache */
   /* replace405_1 -> 3 in the cache */
   /* replace405 -> 1238 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search406_0_0 -> 0 in the cache */
   /* search406_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search406_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1287, 3 },
      -1,
   } },

   /* replace406_0 -> 0 in the cache */
   /* replace406_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search407_0_0 -> 0 in the cache */
   /* search407_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search407_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1290, 3 },
      -1,
   } },

   /* replace407_0 -> 0 in the cache */
   /* replace407_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search408_0_0 -> 0 in the cache */
   /* search408_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search408_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1293, 3 },
      -1,
   } },

   /* replace408_0 -> 0 in the cache */
   /* replace408_1 -> 3 in the cache */
   /* replace408 -> 1240 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search409_0_0 -> 0 in the cache */
   /* search409_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search409_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1295, 3 },
      -1,
   } },

   /* replace409_0 -> 0 in the cache */
   /* replace409_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search410_0_0 -> 0 in the cache */
   /* search410_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search410_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1298, 3 },
      -1,
   } },

   /* replace410_0 -> 0 in the cache */
   /* replace410_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search411_0_0_0 -> 128 in the cache */
   /* search411_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search411_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1301, 131 },
      -1,
   } },
   /* search411_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1302, 128 },
      -1,
   } },

   /* replace411_0_0 -> 128 in the cache */
   /* replace411_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace411_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1304, 131 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search412_0_0_0 -> 128 in the cache */
   /* search412_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search412_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1306, 131 },
      -1,
   } },
   /* search412_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1307, 128 },
      -1,
   } },

   /* replace412_0_0 -> 128 in the cache */
   /* replace412_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace412_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1309, 131 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search413_0_0_0 -> 128 in the cache */
   /* search413_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search413_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1311, 131 },
      -1,
   } },
   /* search413_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1312, 128 },
      -1,
   } },

   /* replace413_0_0 -> 128 in the cache */
   /* replace413_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace413_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1314, 131 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search414_0_0_0 -> 128 in the cache */
   /* search414_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search414_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1316, 131 },
      -1,
   } },
   /* search414_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1317, 128 },
      -1,
   } },

   /* replace414_0_0 -> 128 in the cache */
   /* replace414_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace414_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1319, 131 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search415_0_0_0 -> 128 in the cache */
   /* search415_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search415_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1321, 131 },
      -1,
   } },
   /* search415_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1322, 128 },
      -1,
   } },

   /* replace415_0_0 -> 128 in the cache */
   /* replace415_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace415_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1324, 131 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search416_0_0_0 -> 128 in the cache */
   /* search416_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 128, 129 },
      -1,
   } },
   /* search416_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1326, 131 },
      -1,
   } },
   /* search416_1 -> 128 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1327, 128 },
      -1,
   } },

   /* replace416_0_0 -> 128 in the cache */
   /* replace416_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 128, 129 },
      -1,
   } },
   /* replace416_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1329, 131 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search417_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search417_1_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1331, 1332 },
      -1,
   } },

   /* replace417_0 -> 722 in the cache */
   /* replace417_1 -> 1090 in the cache */
   /* replace417 -> 1118 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search418_0_0 -> 722 in the cache */
   /* search418_0 -> 1331 in the cache */
   /* search418_1_0 -> 1090 in the cache */
   /* search418_1 -> 1332 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1331, 1332 },
      -1,
   } },

   /* replace418_0 -> 722 in the cache */
   /* replace418_1 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 722, 1090 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search419_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search419_1_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1336, 1337 },
      -1,
   } },

   /* replace419_0 -> 722 in the cache */
   /* replace419_1 -> 1090 in the cache */
   /* replace419 -> 1118 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search420_0_0 -> 722 in the cache */
   /* search420_0 -> 1336 in the cache */
   /* search420_1_0 -> 1090 in the cache */
   /* search420_1 -> 1337 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1336, 1337 },
      -1,
   } },

   /* replace420_0 -> 722 in the cache */
   /* replace420_1 -> 1090 in the cache */
   /* replace420 -> 1335 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search421_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search421_1_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1340, 1341 },
      -1,
   } },

   /* replace421_0 -> 722 in the cache */
   /* replace421_1 -> 1090 in the cache */
   /* replace421 -> 1118 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search422_0_0 -> 722 in the cache */
   /* search422_0 -> 1340 in the cache */
   /* search422_1_0 -> 1090 in the cache */
   /* search422_1 -> 1341 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1340, 1341 },
      -1,
   } },

   /* replace422_0 -> 722 in the cache */
   /* replace422_1 -> 1090 in the cache */
   /* replace422 -> 1335 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search423_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search423_1_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1344, 1345 },
      -1,
   } },

   /* replace423_0 -> 722 in the cache */
   /* replace423_1 -> 1090 in the cache */
   /* replace423 -> 1118 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search424_0_0 -> 722 in the cache */
   /* search424_0 -> 1344 in the cache */
   /* search424_1_0 -> 1090 in the cache */
   /* search424_1 -> 1345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1344, 1345 },
      -1,
   } },

   /* replace424_0 -> 722 in the cache */
   /* replace424_1 -> 1090 in the cache */
   /* replace424 -> 1335 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search425_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search425_1_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1348, 1349 },
      -1,
   } },

   /* replace425_0 -> 722 in the cache */
   /* replace425_1 -> 1090 in the cache */
   /* replace425 -> 1118 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search426_0_0 -> 722 in the cache */
   /* search426_0 -> 1348 in the cache */
   /* search426_1_0 -> 1090 in the cache */
   /* search426_1 -> 1349 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1348, 1349 },
      -1,
   } },

   /* replace426_0 -> 722 in the cache */
   /* replace426_1 -> 1090 in the cache */
   /* replace426 -> 1335 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search427_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search427_1_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1352, 1353 },
      -1,
   } },

   /* replace427_0 -> 722 in the cache */
   /* replace427_1 -> 1090 in the cache */
   /* replace427 -> 1118 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search428_0_0 -> 722 in the cache */
   /* search428_0 -> 1352 in the cache */
   /* search428_1_0 -> 1090 in the cache */
   /* search428_1 -> 1353 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1352, 1353 },
      -1,
   } },

   /* replace428_0 -> 722 in the cache */
   /* replace428_1 -> 1090 in the cache */
   /* replace428 -> 1335 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search429_0_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 722 },
      -1,
   } },
   /* search429_1_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1356, 1357 },
      -1,
   } },

   /* replace429_0 -> 722 in the cache */
   /* replace429_1 -> 1090 in the cache */
   /* replace429 -> 1118 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search430_0_0 -> 722 in the cache */
   /* search430_0 -> 1356 in the cache */
   /* search430_1_0 -> 1090 in the cache */
   /* search430_1 -> 1357 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1356, 1357 },
      -1,
   } },

   /* replace430_0 -> 722 in the cache */
   /* replace430_1 -> 1090 in the cache */
   /* replace430 -> 1335 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search431_0 -> 6 in the cache */
   /* search431_1_0_0 -> 6 in the cache */
   /* search431_1_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1360 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 1361 },
      -1,
   } },

   /* replace431_0 -> 6 in the cache */
   /* replace431_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 6, 797 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search432_0_0 -> 6 in the cache */
   /* search432_0_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 6, 7 },
      -1,
   } },
   /* search432_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1364, 797 },
      -1,
   } },

   /* replace432_0 -> 6 in the cache */
   /* replace432_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 6, 797 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search433_0_0 -> 6 in the cache */
   /* search433_0_1 -> 7 in the cache */
   /* search433_0 -> 1364 in the cache */
   /* search433_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1364, 7 },
      -1,
   } },

   /* replace433_0 -> 6 in the cache */
   /* replace433_1 -> 797 in the cache */
   /* replace433 -> 1366 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search434_0_0 -> 6 in the cache */
   /* search434_0_1 -> 7 in the cache */
   /* search434_0 -> 1364 in the cache */
   /* search434_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1364, 797 },
      -1,
   } },

   /* replace434_0 -> 6 in the cache */
   /* replace434_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 6, 797 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search435_0_0 -> 6 in the cache */
   /* search435_0_1 -> 7 in the cache */
   /* search435_0 -> 1364 in the cache */
   /* search435_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1364, 7 },
      -1,
   } },

   /* replace435_0 -> 6 in the cache */
   /* replace435_1 -> 797 in the cache */
   /* replace435 -> 1369 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search436_0_0 -> 6 in the cache */
   /* search436_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   /* search436_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1371, 797 },
      -1,
   } },

   /* replace436_0 -> 6 in the cache */
   /* replace436_1 -> 797 in the cache */
   /* replace436 -> 1369 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search437_0_0 -> 6 in the cache */
   /* search437_0_1 -> 9 in the cache */
   /* search437_0 -> 1371 in the cache */
   /* search437_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1371, 797 },
      -1,
   } },

   /* replace437_0 -> 6 in the cache */
   /* replace437_1 -> 797 in the cache */
   /* replace437 -> 1366 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search438_0_0 -> 6 in the cache */
   /* search438_0_1 -> 9 in the cache */
   /* search438_0 -> 1371 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1371, 1374 },
      -1,
   } },

   /* replace438_0 -> 6 in the cache */
   /* replace438_1 -> 797 in the cache */
   /* replace438 -> 1369 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search439_0_0 -> 6 in the cache */
   /* search439_0_1 -> 9 in the cache */
   /* search439_0 -> 1371 in the cache */
   /* search439_1 -> 1374 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1371, 1374 },
      -1,
   } },

   /* replace439_0 -> 6 in the cache */
   /* replace439_1 -> 797 in the cache */
   /* replace439 -> 1366 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search440_0_0 -> 6 in the cache */
   /* search440_0_1 -> 9 in the cache */
   /* search440_0 -> 1360 in the cache */
   /* search440_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1360, 797 },
      -1,
   } },

   /* replace440_0 -> 6 in the cache */
   /* replace440_1 -> 797 in the cache */
   /* replace440 -> 1369 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search441_0_0 -> 6 in the cache */
   /* search441_0_1 -> 9 in the cache */
   /* search441_0 -> 1360 in the cache */
   /* search441_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1360, 797 },
      -1,
   } },

   /* replace441_0 -> 6 in the cache */
   /* replace441_1 -> 797 in the cache */
   /* replace441 -> 1366 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search442_0_0 -> 6 in the cache */
   /* search442_0_1 -> 9 in the cache */
   /* search442_0 -> 1360 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1360, 1379 },
      -1,
   } },

   /* replace442_0 -> 6 in the cache */
   /* replace442_1 -> 797 in the cache */
   /* replace442 -> 1369 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search443_0_0 -> 6 in the cache */
   /* search443_0_1 -> 9 in the cache */
   /* search443_0 -> 1360 in the cache */
   /* search443_1 -> 1379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1360, 1379 },
      -1,
   } },

   /* replace443_0 -> 6 in the cache */
   /* replace443_1 -> 797 in the cache */
   /* replace443 -> 1366 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search444_0 -> 11 in the cache */
   /* search444_1_0_0 -> 11 in the cache */
   /* search444_1_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1382 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1383 },
      -1,
   } },

   /* replace444_0 -> 11 in the cache */
   /* replace444_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 11, 818 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search445_0_0 -> 11 in the cache */
   /* search445_0_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 11, 12 },
      -1,
   } },
   /* search445_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1386, 818 },
      -1,
   } },

   /* replace445_0 -> 11 in the cache */
   /* replace445_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 11, 818 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search446_0_0 -> 11 in the cache */
   /* search446_0_1 -> 12 in the cache */
   /* search446_0 -> 1386 in the cache */
   /* search446_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1386, 12 },
      -1,
   } },

   /* replace446_0 -> 11 in the cache */
   /* replace446_1 -> 818 in the cache */
   /* replace446 -> 1388 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search447_0_0 -> 11 in the cache */
   /* search447_0_1 -> 12 in the cache */
   /* search447_0 -> 1386 in the cache */
   /* search447_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1386, 818 },
      -1,
   } },

   /* replace447_0 -> 11 in the cache */
   /* replace447_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 11, 818 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search448_0_0 -> 11 in the cache */
   /* search448_0_1 -> 12 in the cache */
   /* search448_0 -> 1386 in the cache */
   /* search448_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1386, 12 },
      -1,
   } },

   /* replace448_0 -> 11 in the cache */
   /* replace448_1 -> 818 in the cache */
   /* replace448 -> 1391 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search449_0_0 -> 11 in the cache */
   /* search449_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   /* search449_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1393, 818 },
      -1,
   } },

   /* replace449_0 -> 11 in the cache */
   /* replace449_1 -> 818 in the cache */
   /* replace449 -> 1391 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search450_0_0 -> 11 in the cache */
   /* search450_0_1 -> 14 in the cache */
   /* search450_0 -> 1393 in the cache */
   /* search450_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1393, 818 },
      -1,
   } },

   /* replace450_0 -> 11 in the cache */
   /* replace450_1 -> 818 in the cache */
   /* replace450 -> 1388 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search451_0_0 -> 11 in the cache */
   /* search451_0_1 -> 14 in the cache */
   /* search451_0 -> 1393 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1393, 1396 },
      -1,
   } },

   /* replace451_0 -> 11 in the cache */
   /* replace451_1 -> 818 in the cache */
   /* replace451 -> 1391 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search452_0_0 -> 11 in the cache */
   /* search452_0_1 -> 14 in the cache */
   /* search452_0 -> 1393 in the cache */
   /* search452_1 -> 1396 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1393, 1396 },
      -1,
   } },

   /* replace452_0 -> 11 in the cache */
   /* replace452_1 -> 818 in the cache */
   /* replace452 -> 1388 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search453_0_0 -> 11 in the cache */
   /* search453_0_1 -> 14 in the cache */
   /* search453_0 -> 1382 in the cache */
   /* search453_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1382, 818 },
      -1,
   } },

   /* replace453_0 -> 11 in the cache */
   /* replace453_1 -> 818 in the cache */
   /* replace453 -> 1391 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search454_0_0 -> 11 in the cache */
   /* search454_0_1 -> 14 in the cache */
   /* search454_0 -> 1382 in the cache */
   /* search454_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1382, 818 },
      -1,
   } },

   /* replace454_0 -> 11 in the cache */
   /* replace454_1 -> 818 in the cache */
   /* replace454 -> 1388 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search455_0_0 -> 11 in the cache */
   /* search455_0_1 -> 14 in the cache */
   /* search455_0 -> 1382 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1382, 1401 },
      -1,
   } },

   /* replace455_0 -> 11 in the cache */
   /* replace455_1 -> 818 in the cache */
   /* replace455 -> 1391 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search456_0_0 -> 11 in the cache */
   /* search456_0_1 -> 14 in the cache */
   /* search456_0 -> 1382 in the cache */
   /* search456_1 -> 1401 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1382, 1401 },
      -1,
   } },

   /* replace456_0 -> 11 in the cache */
   /* replace456_1 -> 818 in the cache */
   /* replace456 -> 1388 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search457_0 -> 16 in the cache */
   /* search457_1_0_0 -> 16 in the cache */
   /* search457_1_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1404 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1405 },
      -1,
   } },

   /* replace457_0 -> 16 in the cache */
   /* replace457_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 16, 124 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search458_0_0 -> 16 in the cache */
   /* search458_0_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 17 },
      -1,
   } },
   /* search458_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1408, 124 },
      -1,
   } },

   /* replace458_0 -> 16 in the cache */
   /* replace458_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 16, 124 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search459_0_0 -> 16 in the cache */
   /* search459_0_1 -> 17 in the cache */
   /* search459_0 -> 1408 in the cache */
   /* search459_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1408, 17 },
      -1,
   } },

   /* replace459_0 -> 16 in the cache */
   /* replace459_1 -> 124 in the cache */
   /* replace459 -> 1410 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search460_0_0 -> 16 in the cache */
   /* search460_0_1 -> 17 in the cache */
   /* search460_0 -> 1408 in the cache */
   /* search460_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1408, 124 },
      -1,
   } },

   /* replace460_0 -> 16 in the cache */
   /* replace460_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 16, 124 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search461_0_0 -> 16 in the cache */
   /* search461_0_1 -> 17 in the cache */
   /* search461_0 -> 1408 in the cache */
   /* search461_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1408, 17 },
      -1,
   } },

   /* replace461_0 -> 16 in the cache */
   /* replace461_1 -> 124 in the cache */
   /* replace461 -> 1413 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search462_0_0 -> 16 in the cache */
   /* search462_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   /* search462_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1415, 124 },
      -1,
   } },

   /* replace462_0 -> 16 in the cache */
   /* replace462_1 -> 124 in the cache */
   /* replace462 -> 1413 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search463_0_0 -> 16 in the cache */
   /* search463_0_1 -> 19 in the cache */
   /* search463_0 -> 1415 in the cache */
   /* search463_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1415, 124 },
      -1,
   } },

   /* replace463_0 -> 16 in the cache */
   /* replace463_1 -> 124 in the cache */
   /* replace463 -> 1410 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search464_0_0 -> 16 in the cache */
   /* search464_0_1 -> 19 in the cache */
   /* search464_0 -> 1415 in the cache */
   /* search464_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1415, 381 },
      -1,
   } },

   /* replace464_0 -> 16 in the cache */
   /* replace464_1 -> 124 in the cache */
   /* replace464 -> 1413 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search465_0_0 -> 16 in the cache */
   /* search465_0_1 -> 19 in the cache */
   /* search465_0 -> 1415 in the cache */
   /* search465_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1415, 381 },
      -1,
   } },

   /* replace465_0 -> 16 in the cache */
   /* replace465_1 -> 124 in the cache */
   /* replace465 -> 1410 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search466_0_0 -> 16 in the cache */
   /* search466_0_1 -> 19 in the cache */
   /* search466_0 -> 1404 in the cache */
   /* search466_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1404, 124 },
      -1,
   } },

   /* replace466_0 -> 16 in the cache */
   /* replace466_1 -> 124 in the cache */
   /* replace466 -> 1413 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search467_0_0 -> 16 in the cache */
   /* search467_0_1 -> 19 in the cache */
   /* search467_0 -> 1404 in the cache */
   /* search467_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1404, 124 },
      -1,
   } },

   /* replace467_0 -> 16 in the cache */
   /* replace467_1 -> 124 in the cache */
   /* replace467 -> 1410 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search468_0_0 -> 16 in the cache */
   /* search468_0_1 -> 19 in the cache */
   /* search468_0 -> 1404 in the cache */
   /* search468_1 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1404, 126 },
      -1,
   } },

   /* replace468_0 -> 16 in the cache */
   /* replace468_1 -> 124 in the cache */
   /* replace468 -> 1413 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search469_0_0 -> 16 in the cache */
   /* search469_0_1 -> 19 in the cache */
   /* search469_0 -> 1404 in the cache */
   /* search469_1 -> 126 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1404, 126 },
      -1,
   } },

   /* replace469_0 -> 16 in the cache */
   /* replace469_1 -> 124 in the cache */
   /* replace469 -> 1410 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search470_0 -> 21 in the cache */
   /* search470_1_0_0 -> 21 in the cache */
   /* search470_1_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1424 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 1425 },
      -1,
   } },

   /* replace470_0 -> 21 in the cache */
   /* replace470_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 21, 859 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search471_0_0 -> 21 in the cache */
   /* search471_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 21, 22 },
      -1,
   } },
   /* search471_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1428, 859 },
      -1,
   } },

   /* replace471_0 -> 21 in the cache */
   /* replace471_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 21, 859 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search472_0_0 -> 21 in the cache */
   /* search472_0_1 -> 22 in the cache */
   /* search472_0 -> 1428 in the cache */
   /* search472_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1428, 22 },
      -1,
   } },

   /* replace472_0 -> 21 in the cache */
   /* replace472_1 -> 859 in the cache */
   /* replace472 -> 1430 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search473_0_0 -> 21 in the cache */
   /* search473_0_1 -> 22 in the cache */
   /* search473_0 -> 1428 in the cache */
   /* search473_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1428, 859 },
      -1,
   } },

   /* replace473_0 -> 21 in the cache */
   /* replace473_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 21, 859 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search474_0_0 -> 21 in the cache */
   /* search474_0_1 -> 22 in the cache */
   /* search474_0 -> 1428 in the cache */
   /* search474_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1428, 22 },
      -1,
   } },

   /* replace474_0 -> 21 in the cache */
   /* replace474_1 -> 859 in the cache */
   /* replace474 -> 1433 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search475_0_0 -> 21 in the cache */
   /* search475_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   /* search475_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1435, 859 },
      -1,
   } },

   /* replace475_0 -> 21 in the cache */
   /* replace475_1 -> 859 in the cache */
   /* replace475 -> 1433 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search476_0_0 -> 21 in the cache */
   /* search476_0_1 -> 24 in the cache */
   /* search476_0 -> 1435 in the cache */
   /* search476_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1435, 859 },
      -1,
   } },

   /* replace476_0 -> 21 in the cache */
   /* replace476_1 -> 859 in the cache */
   /* replace476 -> 1430 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search477_0_0 -> 21 in the cache */
   /* search477_0_1 -> 24 in the cache */
   /* search477_0 -> 1435 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1435, 1438 },
      -1,
   } },

   /* replace477_0 -> 21 in the cache */
   /* replace477_1 -> 859 in the cache */
   /* replace477 -> 1433 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search478_0_0 -> 21 in the cache */
   /* search478_0_1 -> 24 in the cache */
   /* search478_0 -> 1435 in the cache */
   /* search478_1 -> 1438 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1435, 1438 },
      -1,
   } },

   /* replace478_0 -> 21 in the cache */
   /* replace478_1 -> 859 in the cache */
   /* replace478 -> 1430 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search479_0_0 -> 21 in the cache */
   /* search479_0_1 -> 24 in the cache */
   /* search479_0 -> 1424 in the cache */
   /* search479_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1424, 859 },
      -1,
   } },

   /* replace479_0 -> 21 in the cache */
   /* replace479_1 -> 859 in the cache */
   /* replace479 -> 1433 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search480_0_0 -> 21 in the cache */
   /* search480_0_1 -> 24 in the cache */
   /* search480_0 -> 1424 in the cache */
   /* search480_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1424, 859 },
      -1,
   } },

   /* replace480_0 -> 21 in the cache */
   /* replace480_1 -> 859 in the cache */
   /* replace480 -> 1430 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search481_0_0 -> 21 in the cache */
   /* search481_0_1 -> 24 in the cache */
   /* search481_0 -> 1424 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1424, 1443 },
      -1,
   } },

   /* replace481_0 -> 21 in the cache */
   /* replace481_1 -> 859 in the cache */
   /* replace481 -> 1433 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search482_0_0 -> 21 in the cache */
   /* search482_0_1 -> 24 in the cache */
   /* search482_0 -> 1424 in the cache */
   /* search482_1 -> 1443 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1424, 1443 },
      -1,
   } },

   /* replace482_0 -> 21 in the cache */
   /* replace482_1 -> 859 in the cache */
   /* replace482 -> 1430 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search483_0 -> 32 in the cache */
   /* search483_1_0 -> 32 in the cache */
   /* search483_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace483_0_0 -> 32 in the cache */
   /* replace483_0 -> 103 in the cache */
   /* replace483 -> 1211 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search484_0 -> 32 in the cache */
   /* search484_1_0 -> 32 in the cache */
   /* search484_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace484_0_0 -> 32 in the cache */
   /* replace484_0 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 106 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search485_0 -> 32 in the cache */
   /* search485_1_0_0 -> 32 in the cache */
   /* search485_1_0 -> 103 in the cache */
   /* search485_1 -> 1211 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 1211 },
      -1,
   } },

   /* replace485_0_0 -> 32 in the cache */
   /* replace485_0 -> 103 in the cache */
   /* replace485 -> 1211 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search486_0 -> 32 in the cache */
   /* search486_1_0_0 -> 32 in the cache */
   /* search486_1_0 -> 106 in the cache */
   /* search486_1 -> 1448 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 1448 },
      -1,
   } },

   /* replace486_0_0 -> 32 in the cache */
   /* replace486_0 -> 106 in the cache */
   /* replace486 -> 1448 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search487_0 -> 32 in the cache */
   /* search487_1_0 -> 32 in the cache */
   /* search487_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace487 -> 32 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search488_0 -> 32 in the cache */
   /* search488_1_0 -> 32 in the cache */
   /* search488_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace488 -> 32 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search489_0 -> 32 in the cache */
   /* search489_1_0_0 -> 32 in the cache */
   /* search489_1_0 -> 103 in the cache */
   /* search489_1 -> 1211 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 1211 },
      -1,
   } },

   /* replace489 -> 32 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search490_0 -> 32 in the cache */
   /* search490_1_0_0 -> 32 in the cache */
   /* search490_1_0 -> 106 in the cache */
   /* search490_1 -> 1448 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 1448 },
      -1,
   } },

   /* replace490 -> 32 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search491_0 -> 32 in the cache */
   /* search491_1_0 -> 32 in the cache */
   /* search491_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace491_0 -> 32 in the cache */
   /* replace491 -> 103 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search492_0 -> 32 in the cache */
   /* search492_1_0 -> 32 in the cache */
   /* search492_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace492_0 -> 32 in the cache */
   /* replace492 -> 106 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search493_0 -> 32 in the cache */
   /* search493_1_0 -> 32 in the cache */
   /* search493_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace493_0 -> 32 in the cache */
   /* replace493 -> 103 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search494_0 -> 32 in the cache */
   /* search494_1_0 -> 32 in the cache */
   /* search494_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace494_0 -> 32 in the cache */
   /* replace494 -> 106 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search495_0_0 -> 32 in the cache */
   /* search495_0 -> 103 in the cache */
   /* search495_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 103, 113 },
      -1,
   } },

   /* replace495_0 -> 32 in the cache */
   /* replace495 -> 103 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search496_0_0 -> 32 in the cache */
   /* search496_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search496_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1460, 230 },
      -1,
   } },

   /* replace496_0 -> 32 in the cache */
   /* replace496 -> 206 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search497_0_0 -> 32 in the cache */
   /* search497_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 230 },
      -1,
   } },
   /* search497_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1462, 113 },
      -1,
   } },

   /* replace497_0 -> 32 in the cache */
   /* replace497 -> 206 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search498_0_0 -> 32 in the cache */
   /* search498_0_1 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 236 },
      -1,
   } },
   /* search498_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1464, 113 },
      -1,
   } },

   /* replace498_0_0_0 -> 32 in the cache */
   /* replace498_0_0 -> 98 in the cache */
   /* replace498_0 -> 207 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 207 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search499_0_0 -> 32 in the cache */
   /* search499_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search499_1 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1467, 236 },
      -1,
   } },

   /* replace499_0_0_0 -> 32 in the cache */
   /* replace499_0_0 -> 98 in the cache */
   /* replace499_0 -> 207 in the cache */
   /* replace499 -> 1466 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search500_0_0 -> 32 in the cache */
   /* search500_0 -> 239 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 239 },
      -1,
   } },

   /* replace500_0_0 -> 113 in the cache */
   /* replace500_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1470 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search501_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1472 },
      -1,
   } },

   /* replace501_0 -> 32 in the cache */
   /* replace501 -> 1472 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search502_0 -> 32 in the cache */
   /* search502 -> 206 in the cache */

   /* replace502_0_0 -> 32 in the cache */
   /* replace502_0_1 -> 113 in the cache */
   /* replace502_0 -> 1460 in the cache */
   /* replace502_1 -> 230 in the cache */
   /* replace502 -> 1461 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search503_0_0 -> 32 in the cache */
   /* search503_0 -> 206 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 206 },
      -1,
   } },

   /* replace503_0 -> 32 in the cache */
   /* replace503 -> 206 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search504_0_0_0 -> 0 in the cache */
   /* search504_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1475 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1476 },
      -1,
   } },

   /* replace504_0_0_0 -> 0 in the cache */
   /* replace504_0_0 -> 201 in the cache */
   /* replace504_0_1_0 -> 3 in the cache */
   /* replace504_0_1 -> 1049 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 201, 1049 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1478 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search505_0_0_0 -> 0 in the cache */
   /* search505_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1480 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1481 },
      -1,
   } },

   /* replace505_0_0_0 -> 0 in the cache */
   /* replace505_0_0 -> 201 in the cache */
   /* replace505_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 201, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1483 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search506_0_0_0 -> 16 in the cache */
   /* search506_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1485 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1486 },
      -1,
   } },

   /* replace506_0_0_0 -> 16 in the cache */
   /* replace506_0_0 -> 269 in the cache */
   /* replace506_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 269, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1488 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search507_0_0_0 -> 0 in the cache */
   /* search507_0_0_1 -> 3 in the cache */
   /* search507_0_0 -> 1480 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1480 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1490 },
      -1,
   } },

   /* replace507_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace507_0_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1492, 1493 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1494 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search508_0_0_0_0 -> 128 in the cache */
   /* search508_0_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 128, 129 },
      -1,
   } },
   /* search508_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1496, 131 },
      -1,
   } },
   /* search508_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1497, 129 },
      -1,
   } },
   /* search508_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1498, 131 },
      -1,
   } },

   /* replace508_0_0 -> 128 in the cache */
   /* replace508_0_1 -> 129 in the cache */
   /* replace508_0 -> 1304 in the cache */
   /* replace508_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1304, 131 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search509_0_0_0_0 -> 128 in the cache */
   /* search509_0_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 128, 129 },
      -1,
   } },
   /* search509_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1501, 131 },
      -1,
   } },
   /* search509_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1502, 129 },
      -1,
   } },
   /* search509_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1503, 131 },
      -1,
   } },

   /* replace509_0_0 -> 128 in the cache */
   /* replace509_0_1 -> 129 in the cache */
   /* replace509_0 -> 1314 in the cache */
   /* replace509_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1314, 131 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search510_0_0_0_0 -> 128 in the cache */
   /* search510_0_0_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 128, 129 },
      -1,
   } },
   /* search510_0_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1506, 131 },
      -1,
   } },
   /* search510_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1507, 129 },
      -1,
   } },
   /* search510_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1508, 131 },
      -1,
   } },

   /* replace510_0_0 -> 128 in the cache */
   /* replace510_0_1 -> 129 in the cache */
   /* replace510_0 -> 1309 in the cache */
   /* replace510_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1309, 131 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search511_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1511, 1512 },
      -1,
   } },

   /* replace511_0_0 -> 0 in the cache */
   /* replace511_0_1 -> 3 in the cache */
   /* replace511_0 -> 1238 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1238 },
      -1,
   } },

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search512_0_0 -> 0 in the cache */
   /* search512_0 -> 1511 in the cache */
   /* search512_1 -> 1512 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1511, 1512 },
      -1,
   } },

   /* replace512_0_0 -> 0 in the cache */
   /* replace512_0_1 -> 3 in the cache */
   /* replace512_0 -> 1240 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1240 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search513_0_0_0 -> 1073 in the cache */
   /* search513_0_0_1 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1073, 1070 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1517 },
      -1,
   } },
   /* search513_1 -> 1073 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1518, 1073 },
      -1,
   } },

   /* replace513_0_0 -> 1073 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1073 },
      -1,
   } },
   /* replace513_1_0 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1070 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1520, 1521 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search514_0_0_0 -> 1073 in the cache */
   /* search514_0_0_1 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1073, 1070 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1523 },
      -1,
   } },
   /* search514_1 -> 1073 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1524, 1073 },
      -1,
   } },

   /* replace514_0_0_0 -> 1073 in the cache */
   /* replace514_0_0 -> 1520 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1520 },
      -1,
   } },
   /* replace514_1_0 -> 1070 in the cache */
   /* replace514_1 -> 1521 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1526, 1521 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1528 },
      -1,
   } },
   /* search515_0_1 -> 1512 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1529, 1512 },
      0,
   } },
   /* search515_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1530, 245 },
      -1,
   } },

   /* replace515_0_0_0 -> 0 in the cache */
   /* replace515_0_0 -> 201 in the cache */
   /* replace515_0_1 -> 3 in the cache */
   /* replace515_0 -> 266 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 266 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search516_0_0_0 -> 32 in the cache */
   /* search516_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 32, 61 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1533, 1534 },
      -1,
   } },
   /* search516_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1535, 61 },
      -1,
   } },

   /* replace516_0_0 -> 32 in the cache */
   /* replace516_0_1 -> 61 in the cache */
   /* replace516_0 -> 1533 in the cache */
   /* replace516_1 -> 1534 in the cache */
   /* replace516 -> 1535 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search517_0_0 -> 128 in the cache */
   /* search517_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search517_1_0 -> 128 in the cache */
   /* search517_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1537, 1538 },
      -1,
   } },

   /* replace517_0 -> 128 in the cache */
   /* replace517_1_0 -> 129 in the cache */
   /* replace517_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 128, 1540 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search518_0_0 -> 0 in the cache */
   /* search518_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 669 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search518_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1543, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1542, 1544 },
      -1,
   } },

   /* replace518_0_0 -> 0 in the cache */
   /* replace518_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace518_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1546, 669 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search519_0_0 -> 128 in the cache */
   /* search519_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search519_1_0 -> 128 in the cache */
   /* search519_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1548, 1549 },
      -1,
   } },

   /* replace519_0 -> 128 in the cache */
   /* replace519_1_0 -> 129 in the cache */
   /* replace519_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 128, 1551 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search520_0_0 -> 0 in the cache */
   /* search520_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 669 },
      0,
   } },
   /* search520_1_0 -> 1543 in the cache */
   /* search520_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1543, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1553, 1554 },
      -1,
   } },

   /* replace520_0_0 -> 0 in the cache */
   /* replace520_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace520_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1556, 669 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search521_0_0 -> 128 in the cache */
   /* search521_0_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 272 },
      -1,
   } },
   /* search521_1_0 -> 128 in the cache */
   /* search521_1_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 776 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1558, 1559 },
      -1,
   } },

   /* replace521_0 -> 128 in the cache */
   /* replace521_1_0 -> 129 in the cache */
   /* replace521_1_1 -> 131 in the cache */
   /* replace521_1 -> 1540 in the cache */
   /* replace521 -> 1541 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search522_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1561, 669 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search522_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1563, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1562, 1564 },
      -1,
   } },

   /* replace522_0_0 -> 0 in the cache */
   /* replace522_0_1 -> 1543 in the cache */
   /* replace522_0 -> 1546 in the cache */
   /* replace522_1 -> 669 in the cache */
   /* replace522 -> 1547 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search523_0_0 -> 128 in the cache */
   /* search523_0_1 -> 272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 272 },
      -1,
   } },
   /* search523_1_0 -> 128 in the cache */
   /* search523_1_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 776 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1566, 1567 },
      -1,
   } },

   /* replace523_0 -> 128 in the cache */
   /* replace523_1_0 -> 129 in the cache */
   /* replace523_1_1 -> 131 in the cache */
   /* replace523_1 -> 1551 in the cache */
   /* replace523 -> 1552 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search524_0_0 -> 1561 in the cache */
   /* search524_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1561, 669 },
      -1,
   } },
   /* search524_1_0 -> 1563 in the cache */
   /* search524_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1563, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1569, 1570 },
      -1,
   } },

   /* replace524_0_0 -> 0 in the cache */
   /* replace524_0_1 -> 1543 in the cache */
   /* replace524_0 -> 1556 in the cache */
   /* replace524_1 -> 669 in the cache */
   /* replace524 -> 1557 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search525_0_0 -> 128 in the cache */
   /* search525_0_1 -> 129 in the cache */
   /* search525_0 -> 1537 in the cache */
   /* search525_1_0 -> 128 in the cache */
   /* search525_1_1 -> 131 in the cache */
   /* search525_1 -> 1538 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1537, 1538 },
      -1,
   } },

   /* replace525_0 -> 128 in the cache */
   /* replace525_1_0 -> 129 in the cache */
   /* replace525_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 128, 1573 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search526_0_0 -> 0 in the cache */
   /* search526_0_1 -> 669 in the cache */
   /* search526_0 -> 1542 in the cache */
   /* search526_1_0 -> 1543 in the cache */
   /* search526_1_1 -> 669 in the cache */
   /* search526_1 -> 1544 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1542, 1544 },
      -1,
   } },

   /* replace526_0_0 -> 0 in the cache */
   /* replace526_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace526_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1576, 669 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search527_0_0 -> 128 in the cache */
   /* search527_0_1 -> 129 in the cache */
   /* search527_0 -> 1548 in the cache */
   /* search527_1_0 -> 128 in the cache */
   /* search527_1_1 -> 131 in the cache */
   /* search527_1 -> 1549 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1548, 1549 },
      -1,
   } },

   /* replace527_0 -> 128 in the cache */
   /* replace527_1_0 -> 129 in the cache */
   /* replace527_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 128, 1579 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search528_0_0 -> 0 in the cache */
   /* search528_0_1 -> 669 in the cache */
   /* search528_0 -> 1553 in the cache */
   /* search528_1_0 -> 1543 in the cache */
   /* search528_1_1 -> 669 in the cache */
   /* search528_1 -> 1554 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1553, 1554 },
      -1,
   } },

   /* replace528_0_0 -> 0 in the cache */
   /* replace528_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace528_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1582, 669 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search529_0_0 -> 128 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 1584 },
      -1,
   } },
   /* search529_1_0 -> 128 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 128, 1586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1585, 1587 },
      -1,
   } },

   /* replace529_0 -> 128 in the cache */
   /* replace529_1_0 -> 129 in the cache */
   /* replace529_1_1 -> 131 in the cache */
   /* replace529_1 -> 1573 in the cache */
   /* replace529 -> 1574 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search530_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1589, 669 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search530_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1591, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1590, 1592 },
      -1,
   } },

   /* replace530_0_0 -> 0 in the cache */
   /* replace530_0_1 -> 1543 in the cache */
   /* replace530_0 -> 1576 in the cache */
   /* replace530_1 -> 669 in the cache */
   /* replace530 -> 1577 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search531_0_0 -> 128 in the cache */
   /* search531_0_1 -> 1584 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 1584 },
      -1,
   } },
   /* search531_1_0 -> 128 in the cache */
   /* search531_1_1 -> 1586 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 128, 1586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1594, 1595 },
      -1,
   } },

   /* replace531_0 -> 128 in the cache */
   /* replace531_1_0 -> 129 in the cache */
   /* replace531_1_1 -> 131 in the cache */
   /* replace531_1 -> 1579 in the cache */
   /* replace531 -> 1580 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search532_0_0 -> 1589 in the cache */
   /* search532_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1589, 669 },
      -1,
   } },
   /* search532_1_0 -> 1591 in the cache */
   /* search532_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1591, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1597, 1598 },
      -1,
   } },

   /* replace532_0_0 -> 0 in the cache */
   /* replace532_0_1 -> 1543 in the cache */
   /* replace532_0 -> 1582 in the cache */
   /* replace532_1 -> 669 in the cache */
   /* replace532 -> 1583 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search533_0_0 -> 128 in the cache */
   /* search533_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search533_1_0 -> 128 in the cache */
   /* search533_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1600, 1601 },
      -1,
   } },

   /* replace533_0 -> 128 in the cache */
   /* replace533_1_0 -> 129 in the cache */
   /* replace533_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 128, 1603 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search534_0_0 -> 0 in the cache */
   /* search534_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 669 },
      0,
   } },
   /* search534_1_0 -> 1543 in the cache */
   /* search534_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1543, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1605, 1606 },
      -1,
   } },

   /* replace534_0_0 -> 0 in the cache */
   /* replace534_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace534_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1608, 669 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search535_0_0 -> 128 in the cache */
   /* search535_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search535_1_0 -> 128 in the cache */
   /* search535_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1610, 1611 },
      -1,
   } },

   /* replace535_0 -> 128 in the cache */
   /* replace535_1_0 -> 129 in the cache */
   /* replace535_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 128, 1613 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search536_0_0 -> 0 in the cache */
   /* search536_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 669 },
      0,
   } },
   /* search536_1_0 -> 1543 in the cache */
   /* search536_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1543, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1615, 1616 },
      -1,
   } },

   /* replace536_0_0 -> 0 in the cache */
   /* replace536_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace536_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1618, 669 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search537_0_0 -> 128 in the cache */
   /* search537_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search537_1_0 -> 128 in the cache */
   /* search537_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1620, 1621 },
      -1,
   } },

   /* replace537_0 -> 128 in the cache */
   /* replace537_1_0 -> 129 in the cache */
   /* replace537_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 128, 1623 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search538_0_0 -> 0 in the cache */
   /* search538_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 669 },
      0,
   } },
   /* search538_1_0 -> 1543 in the cache */
   /* search538_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1543, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1625, 1626 },
      -1,
   } },

   /* replace538_0_0 -> 0 in the cache */
   /* replace538_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace538_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1628, 669 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search539_0_0 -> 128 in the cache */
   /* search539_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 128, 129 },
      0,
   } },
   /* search539_1_0 -> 128 in the cache */
   /* search539_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 128, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1630, 1631 },
      -1,
   } },

   /* replace539_0 -> 128 in the cache */
   /* replace539_1_0 -> 129 in the cache */
   /* replace539_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 128, 1633 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search540_0_0 -> 0 in the cache */
   /* search540_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 669 },
      0,
   } },
   /* search540_1_0 -> 1543 in the cache */
   /* search540_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1543, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1635, 1636 },
      -1,
   } },

   /* replace540_0_0 -> 0 in the cache */
   /* replace540_0_1 -> 1543 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1543 },
      -1,
   } },
   /* replace540_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1638, 669 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search541_0_0 -> 128 in the cache */
   /* search541_0_1 -> 129 in the cache */
   /* search541_0 -> 1600 in the cache */
   /* search541_1_0 -> 128 in the cache */
   /* search541_1_1 -> 131 in the cache */
   /* search541_1 -> 1601 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1600, 1601 },
      -1,
   } },

   /* replace541_0 -> 128 in the cache */
   /* replace541_1_0 -> 129 in the cache */
   /* replace541_1_1 -> 131 in the cache */
   /* replace541_1 -> 1613 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 128, 1613 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search542_0_0 -> 0 in the cache */
   /* search542_0_1 -> 669 in the cache */
   /* search542_0 -> 1605 in the cache */
   /* search542_1_0 -> 1543 in the cache */
   /* search542_1_1 -> 669 in the cache */
   /* search542_1 -> 1606 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1605, 1606 },
      -1,
   } },

   /* replace542_0_0 -> 0 in the cache */
   /* replace542_0_1 -> 1543 in the cache */
   /* replace542_0 -> 1618 in the cache */
   /* replace542_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1618, 669 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search543_0_0 -> 128 in the cache */
   /* search543_0_1 -> 129 in the cache */
   /* search543_0 -> 1610 in the cache */
   /* search543_1_0 -> 128 in the cache */
   /* search543_1_1 -> 131 in the cache */
   /* search543_1 -> 1611 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1610, 1611 },
      -1,
   } },

   /* replace543_0 -> 128 in the cache */
   /* replace543_1_0 -> 129 in the cache */
   /* replace543_1_1 -> 131 in the cache */
   /* replace543_1 -> 1603 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 128, 1603 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search544_0_0 -> 0 in the cache */
   /* search544_0_1 -> 669 in the cache */
   /* search544_0 -> 1615 in the cache */
   /* search544_1_0 -> 1543 in the cache */
   /* search544_1_1 -> 669 in the cache */
   /* search544_1 -> 1616 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1615, 1616 },
      -1,
   } },

   /* replace544_0_0 -> 0 in the cache */
   /* replace544_0_1 -> 1543 in the cache */
   /* replace544_0 -> 1608 in the cache */
   /* replace544_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1608, 669 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search545_0_0 -> 128 in the cache */
   /* search545_0_1 -> 129 in the cache */
   /* search545_0 -> 1620 in the cache */
   /* search545_1_0 -> 128 in the cache */
   /* search545_1_1 -> 131 in the cache */
   /* search545_1 -> 1621 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1620, 1621 },
      -1,
   } },

   /* replace545_0 -> 128 in the cache */
   /* replace545_1_0 -> 129 in the cache */
   /* replace545_1_1 -> 131 in the cache */
   /* replace545_1 -> 1633 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 128, 1633 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search546_0_0 -> 0 in the cache */
   /* search546_0_1 -> 669 in the cache */
   /* search546_0 -> 1625 in the cache */
   /* search546_1_0 -> 1543 in the cache */
   /* search546_1_1 -> 669 in the cache */
   /* search546_1 -> 1626 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1625, 1626 },
      -1,
   } },

   /* replace546_0_0 -> 0 in the cache */
   /* replace546_0_1 -> 1543 in the cache */
   /* replace546_0 -> 1638 in the cache */
   /* replace546_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1638, 669 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search547_0_0 -> 128 in the cache */
   /* search547_0_1 -> 129 in the cache */
   /* search547_0 -> 1630 in the cache */
   /* search547_1_0 -> 128 in the cache */
   /* search547_1_1 -> 131 in the cache */
   /* search547_1 -> 1631 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1630, 1631 },
      -1,
   } },

   /* replace547_0 -> 128 in the cache */
   /* replace547_1_0 -> 129 in the cache */
   /* replace547_1_1 -> 131 in the cache */
   /* replace547_1 -> 1623 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 128, 1623 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search548_0_0 -> 0 in the cache */
   /* search548_0_1 -> 669 in the cache */
   /* search548_0 -> 1635 in the cache */
   /* search548_1_0 -> 1543 in the cache */
   /* search548_1_1 -> 669 in the cache */
   /* search548_1 -> 1636 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1635, 1636 },
      -1,
   } },

   /* replace548_0_0 -> 0 in the cache */
   /* replace548_0_1 -> 1543 in the cache */
   /* replace548_0 -> 1628 in the cache */
   /* replace548_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1628, 669 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search549_0_0_0 -> 0 in the cache */
   /* search549_0_0_1 -> 669 in the cache */
   /* search549_0_0 -> 1542 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1542, 1656 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search549_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1658, 669 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1657, 1659 },
      -1,
   } },

   /* replace549_0_0_0 -> 0 in the cache */
   /* replace549_0_0_1 -> 1658 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1658 },
      -1,
   } },
   /* replace549_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1661, 669 },
      -1,
   } },
   /* replace549_1 -> 1656 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1662, 1656 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search550_0_0_0 -> 0 in the cache */
   /* search550_0_0_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 669 },
      -1,
   } },
   /* search550_0_1 -> 1656 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1664, 1656 },
      0,
   } },
   /* search550_1_0 -> 1658 in the cache */
   /* search550_1_1 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1658, 669 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1665, 1666 },
      -1,
   } },

   /* replace550_0_0_0 -> 0 in the cache */
   /* replace550_0_0_1 -> 1658 in the cache */
   /* replace550_0_0 -> 1661 in the cache */
   /* replace550_0_1 -> 669 in the cache */
   /* replace550_0 -> 1662 in the cache */
   /* replace550_1 -> 1656 in the cache */
   /* replace550 -> 1663 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search551_0_0_0 -> 151 in the cache */
   /* search551_0_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 152 },
      0,
   } },
   /* search551_0_1 -> 1656 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1668, 1656 },
      0,
   } },
   /* search551_1_0 -> 151 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 1670 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1669, 1671 },
      -1,
   } },

   /* replace551_0_0 -> 151 in the cache */
   /* replace551_0_1_0 -> 152 in the cache */
   /* replace551_0_1_1 -> 1670 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      nir_op_fmax,
      1, 1,
      { 152, 1670 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 151, 1673 },
      -1,
   } },
   /* replace551_1 -> 1656 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1674, 1656 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search552_0_0_0 -> 151 in the cache */
   /* search552_0_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 152 },
      -1,
   } },
   /* search552_0_1 -> 1656 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1676, 1656 },
      0,
   } },
   /* search552_1_0 -> 151 in the cache */
   /* search552_1_1 -> 1670 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 151, 1670 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1677, 1678 },
      -1,
   } },

   /* replace552_0_0 -> 151 in the cache */
   /* replace552_0_1_0 -> 152 in the cache */
   /* replace552_0_1_1 -> 1670 in the cache */
   /* replace552_0_1 -> 1673 in the cache */
   /* replace552_0 -> 1674 in the cache */
   /* replace552_1 -> 1656 in the cache */
   /* replace552 -> 1675 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search553_0_0 -> 1004 in the cache */
   /* search553_0_1 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1004, 1005 },
      -1,
   } },
   /* search553_1_0 -> 3 in the cache */
   /* search553_1_1 -> 0 in the cache */
   /* search553_1 -> 1040 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1680, 1040 },
      -1,
   } },

   /* replace553_0 -> 0 in the cache */
   /* replace553_1 -> 3 in the cache */
   /* replace553 -> 1014 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search554_0_0 -> 115 in the cache */
   /* search554_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search554_1_0 -> 247 in the cache */
   /* search554_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 247, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1682, 1683 },
      -1,
   } },

   /* replace554_0 -> 115 in the cache */
   /* replace554_1_0 -> 11 in the cache */
   /* replace554_1_1_0 -> 247 in the cache */
   /* replace554_1_1 -> 519 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1685 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search555_0_0 -> 115 in the cache */
   /* search555_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search555_1_0 -> 247 in the cache */
   /* search555_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 247, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1687, 1688 },
      -1,
   } },

   /* replace555_0 -> 115 in the cache */
   /* replace555_1_0 -> 11 in the cache */
   /* replace555_1_1_0 -> 247 in the cache */
   /* replace555_1_1 -> 519 in the cache */
   /* replace555_1 -> 1685 in the cache */
   /* replace555 -> 1686 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search556_0_0 -> 115 in the cache */
   /* search556_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search556_1_0 -> 247 in the cache */
   /* search556_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 247, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1690, 1691 },
      -1,
   } },

   /* replace556_0 -> 115 in the cache */
   /* replace556_1_0 -> 11 in the cache */
   /* replace556_1_1_0 -> 247 in the cache */
   /* replace556_1_1 -> 519 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 11, 519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1693 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search557_0_0 -> 115 in the cache */
   /* search557_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search557_1_0 -> 247 in the cache */
   /* search557_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 247, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1695, 1696 },
      -1,
   } },

   /* replace557_0 -> 115 in the cache */
   /* replace557_1_0 -> 11 in the cache */
   /* replace557_1_1_0 -> 247 in the cache */
   /* replace557_1_1 -> 519 in the cache */
   /* replace557_1 -> 1693 in the cache */
   /* replace557 -> 1694 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search558_0_0 -> 115 in the cache */
   /* search558_0_1 -> 11 in the cache */
   /* search558_0 -> 1682 in the cache */
   /* search558_1_0 -> 247 in the cache */
   /* search558_1_1 -> 115 in the cache */
   /* search558_1 -> 1683 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1682, 1683 },
      -1,
   } },

   /* replace558_0 -> 115 in the cache */
   /* replace558_1_0 -> 11 in the cache */
   /* replace558_1_1_0 -> 247 in the cache */
   /* replace558_1_1 -> 519 in the cache */
   /* replace558_1 -> 1693 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1693 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search559_0_0 -> 115 in the cache */
   /* search559_0_1 -> 11 in the cache */
   /* search559_0 -> 1687 in the cache */
   /* search559_1_0 -> 247 in the cache */
   /* search559_1_1 -> 115 in the cache */
   /* search559_1 -> 1688 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1687, 1688 },
      -1,
   } },

   /* replace559_0 -> 115 in the cache */
   /* replace559_1_0 -> 11 in the cache */
   /* replace559_1_1_0 -> 247 in the cache */
   /* replace559_1_1 -> 519 in the cache */
   /* replace559_1 -> 1693 in the cache */
   /* replace559 -> 1699 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search560_0_0 -> 115 in the cache */
   /* search560_0_1 -> 11 in the cache */
   /* search560_0 -> 1690 in the cache */
   /* search560_1_0 -> 247 in the cache */
   /* search560_1_1 -> 115 in the cache */
   /* search560_1 -> 1691 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1690, 1691 },
      -1,
   } },

   /* replace560_0 -> 115 in the cache */
   /* replace560_1_0 -> 11 in the cache */
   /* replace560_1_1_0 -> 247 in the cache */
   /* replace560_1_1 -> 519 in the cache */
   /* replace560_1 -> 1685 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1685 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search561_0_0 -> 115 in the cache */
   /* search561_0_1 -> 11 in the cache */
   /* search561_0 -> 1695 in the cache */
   /* search561_1_0 -> 247 in the cache */
   /* search561_1_1 -> 115 in the cache */
   /* search561_1 -> 1696 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1695, 1696 },
      -1,
   } },

   /* replace561_0 -> 115 in the cache */
   /* replace561_1_0 -> 11 in the cache */
   /* replace561_1_1_0 -> 247 in the cache */
   /* replace561_1_1 -> 519 in the cache */
   /* replace561_1 -> 1685 in the cache */
   /* replace561 -> 1702 in the cache */

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search562_0_0 -> 11 in the cache */
   /* search562_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 115 },
      -1,
   } },
   /* search562_1 -> 466 in the cache */
   /* search562_2_0_0_0_0 -> 115 in the cache */
   /* search562_2_0_0_0_1 -> 11 in the cache */
   /* search562_2_0_0_0 -> 1687 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1687 },
      -1,
   } },
   /* search562_2_0_1_0_0_0 -> 11 in the cache */
   /* search562_2_0_1_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1706 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1707 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1705, 1708 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1709 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1704, 466, 1710 },
      -1,
   } },

   /* replace562_0_0_0_0 -> 11 in the cache */
   /* replace562_0_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1712 },
      -1,
   } },
   /* replace562_0_1_0_0_0 -> 11 in the cache */
   /* replace562_0_1_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1714 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1713, 1716 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1717 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search563_0 -> 722 in the cache */
   /* search563_1_0 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 247 },
      0,
   } },
   /* search563_2_0 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 454 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1719, 1720 },
      -1,
   } },

   /* replace563_0_0 -> 722 in the cache */
   /* replace563_0_1 -> 247 in the cache */
   /* replace563_0_2 -> 454 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 247, 454 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1722 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search564_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1724 },
      -1,
   } },

   /* replace564_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search565_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1727 },
      -1,
   } },

   /* replace565 -> 11 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search566_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1729 },
      -1,
   } },

   /* replace566 -> 11 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search567_0_0 -> 11 in the cache */
   /* search567_0 -> 1727 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1727 },
      -1,
   } },

   /* replace567 -> 11 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search568_0_0 -> 11 in the cache */
   /* search568_0 -> 1729 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1729 },
      -1,
   } },

   /* replace568 -> 11 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search569_0_0_0 -> 115 in the cache */
   /* search569_0_0_1 -> 11 in the cache */
   /* search569_0_0 -> 1687 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1687 },
      -1,
   } },
   /* search569_1_0_0_0 -> 11 in the cache */
   /* search569_1_0_0_1 -> 115 in the cache */
   /* search569_1_0_0 -> 1706 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1706 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1734 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1733, 1735 },
      -1,
   } },

   /* replace569_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search570_0_0_0 -> 818 in the cache */
   /* search570_0_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 818, 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1738 },
      -1,
   } },
   /* search570_1_0_0_0 -> 11 in the cache */
   /* search570_1_0_0_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 818 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1740 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1741 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1739, 1742 },
      -1,
   } },

   /* replace570_0_0 -> 11 in the cache */
   /* replace570_0 -> 1737 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1737 },
      -1,
   } },

   /* ('f2f16', ('f2f32', 'a@16')) => a */
   /* search571_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1745 },
      -1,
   } },

   /* replace571 -> 11 in the cache */

   /* ('i2i16', ('i2i32', 'a@16')) => a */
   /* search572_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1747 },
      -1,
   } },

   /* replace572 -> 11 in the cache */

   /* ('u2u16', ('u2u32', 'a@16')) => a */
   /* search573_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1749 },
      -1,
   } },

   /* replace573 -> 11 in the cache */

   /* ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a') */
   /* search574_0_0 -> 722 in the cache */
   /* search574_0 -> 1352 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1352 },
      -1,
   } },

   /* replace574_0 -> 722 in the cache */
   /* replace574 -> 1348 in the cache */

   /* ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search575_0_0 -> 722 in the cache */
   /* search575_0 -> 1340 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1340 },
      -1,
   } },

   /* replace575_0 -> 722 in the cache */
   /* replace575 -> 1336 in the cache */

   /* ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search576_0_0 -> 722 in the cache */
   /* search576_0 -> 1340 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1340 },
      -1,
   } },

   /* replace576_0 -> 722 in the cache */
   /* replace576 -> 1336 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search577_0_0 -> 11 in the cache */
   /* search577_0 -> 1745 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1745 },
      -1,
   } },

   /* replace577_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search578_0_0 -> 11 in the cache */
   /* search578_0 -> 1745 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1745 },
      -1,
   } },

   /* replace578_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search579_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1758 },
      -1,
   } },

   /* replace579_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search580_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1761 },
      -1,
   } },

   /* replace580_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a') */
   /* search581_0_0 -> 11 in the cache */
   /* search581_0 -> 1749 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 1749 },
      -1,
   } },

   /* replace581_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a') */
   /* search582_0_0 -> 11 in the cache */
   /* search582_0 -> 1747 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1747 },
      -1,
   } },

   /* replace582_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('f2f64', 'a@16')) => a */
   /* search583_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1768 },
      -1,
   } },

   /* replace583 -> 11 in the cache */

   /* ('i2i16', ('i2i64', 'a@16')) => a */
   /* search584_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1770 },
      -1,
   } },

   /* replace584 -> 11 in the cache */

   /* ('u2u16', ('u2u64', 'a@16')) => a */
   /* search585_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1772 },
      -1,
   } },

   /* replace585 -> 11 in the cache */

   /* ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a') */
   /* search586_0_0 -> 722 in the cache */
   /* search586_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1356 },
      -1,
   } },

   /* replace586_0 -> 722 in the cache */
   /* replace586 -> 1348 in the cache */

   /* ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search587_0_0 -> 722 in the cache */
   /* search587_0 -> 1344 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1344 },
      -1,
   } },

   /* replace587_0 -> 722 in the cache */
   /* replace587 -> 1336 in the cache */

   /* ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search588_0_0 -> 722 in the cache */
   /* search588_0 -> 1344 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1344 },
      -1,
   } },

   /* replace588_0 -> 722 in the cache */
   /* replace588 -> 1336 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search589_0_0 -> 11 in the cache */
   /* search589_0 -> 1768 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1768 },
      -1,
   } },

   /* replace589_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search590_0_0 -> 11 in the cache */
   /* search590_0 -> 1768 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1768 },
      -1,
   } },

   /* replace590_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search591_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1781 },
      -1,
   } },

   /* replace591_0 -> 32 in the cache */
   /* replace591 -> 1760 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search592_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1783 },
      -1,
   } },

   /* replace592_0 -> 32 in the cache */
   /* replace592 -> 1763 in the cache */

   /* ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a') */
   /* search593_0_0 -> 11 in the cache */
   /* search593_0 -> 1772 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1772 },
      -1,
   } },

   /* replace593_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a') */
   /* search594_0_0 -> 11 in the cache */
   /* search594_0 -> 1770 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1770 },
      -1,
   } },

   /* replace594_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search595_0_0 -> 117 in the cache */
   /* search595_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search595_1_0 -> 36 in the cache */
   /* search595_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1789, 1790 },
      -1,
   } },

   /* replace595_0 -> 117 in the cache */
   /* replace595_1_0 -> 16 in the cache */
   /* replace595_1_1_0 -> 36 in the cache */
   /* replace595_1_1 -> 585 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 16, 585 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1792 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search596_0_0 -> 117 in the cache */
   /* search596_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search596_1_0 -> 36 in the cache */
   /* search596_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1794, 1795 },
      -1,
   } },

   /* replace596_0 -> 117 in the cache */
   /* replace596_1_0 -> 16 in the cache */
   /* replace596_1_1_0 -> 36 in the cache */
   /* replace596_1_1 -> 585 in the cache */
   /* replace596_1 -> 1792 in the cache */
   /* replace596 -> 1793 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search597_0_0 -> 117 in the cache */
   /* search597_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search597_1_0 -> 36 in the cache */
   /* search597_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1797, 1798 },
      -1,
   } },

   /* replace597_0 -> 117 in the cache */
   /* replace597_1_0 -> 16 in the cache */
   /* replace597_1_1_0 -> 36 in the cache */
   /* replace597_1_1 -> 585 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 16, 585 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1800 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search598_0_0 -> 117 in the cache */
   /* search598_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search598_1_0 -> 36 in the cache */
   /* search598_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1802, 1803 },
      -1,
   } },

   /* replace598_0 -> 117 in the cache */
   /* replace598_1_0 -> 16 in the cache */
   /* replace598_1_1_0 -> 36 in the cache */
   /* replace598_1_1 -> 585 in the cache */
   /* replace598_1 -> 1800 in the cache */
   /* replace598 -> 1801 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search599_0_0 -> 117 in the cache */
   /* search599_0_1 -> 16 in the cache */
   /* search599_0 -> 1789 in the cache */
   /* search599_1_0 -> 36 in the cache */
   /* search599_1_1 -> 117 in the cache */
   /* search599_1 -> 1790 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1789, 1790 },
      -1,
   } },

   /* replace599_0 -> 117 in the cache */
   /* replace599_1_0 -> 16 in the cache */
   /* replace599_1_1_0 -> 36 in the cache */
   /* replace599_1_1 -> 585 in the cache */
   /* replace599_1 -> 1800 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1800 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search600_0_0 -> 117 in the cache */
   /* search600_0_1 -> 16 in the cache */
   /* search600_0 -> 1794 in the cache */
   /* search600_1_0 -> 36 in the cache */
   /* search600_1_1 -> 117 in the cache */
   /* search600_1 -> 1795 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1794, 1795 },
      -1,
   } },

   /* replace600_0 -> 117 in the cache */
   /* replace600_1_0 -> 16 in the cache */
   /* replace600_1_1_0 -> 36 in the cache */
   /* replace600_1_1 -> 585 in the cache */
   /* replace600_1 -> 1800 in the cache */
   /* replace600 -> 1806 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search601_0_0 -> 117 in the cache */
   /* search601_0_1 -> 16 in the cache */
   /* search601_0 -> 1797 in the cache */
   /* search601_1_0 -> 36 in the cache */
   /* search601_1_1 -> 117 in the cache */
   /* search601_1 -> 1798 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1797, 1798 },
      -1,
   } },

   /* replace601_0 -> 117 in the cache */
   /* replace601_1_0 -> 16 in the cache */
   /* replace601_1_1_0 -> 36 in the cache */
   /* replace601_1_1 -> 585 in the cache */
   /* replace601_1 -> 1792 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1792 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search602_0_0 -> 117 in the cache */
   /* search602_0_1 -> 16 in the cache */
   /* search602_0 -> 1802 in the cache */
   /* search602_1_0 -> 36 in the cache */
   /* search602_1_1 -> 117 in the cache */
   /* search602_1 -> 1803 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1802, 1803 },
      -1,
   } },

   /* replace602_0 -> 117 in the cache */
   /* replace602_1_0 -> 16 in the cache */
   /* replace602_1_1_0 -> 36 in the cache */
   /* replace602_1_1 -> 585 in the cache */
   /* replace602_1 -> 1792 in the cache */
   /* replace602 -> 1809 in the cache */

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search603_0_0 -> 16 in the cache */
   /* search603_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 16, 117 },
      -1,
   } },
   /* search603_1 -> 232 in the cache */
   /* search603_2_0_0_0_0 -> 117 in the cache */
   /* search603_2_0_0_0_1 -> 16 in the cache */
   /* search603_2_0_0_0 -> 1794 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1794 },
      -1,
   } },
   /* search603_2_0_1_0_0_0 -> 16 in the cache */
   /* search603_2_0_1_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1814 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1812, 1815 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1816 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1811, 232, 1817 },
      -1,
   } },

   /* replace603_0_0_0_0 -> 16 in the cache */
   /* replace603_0_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1819 },
      -1,
   } },
   /* replace603_0_1_0_0_0 -> 16 in the cache */
   /* replace603_0_1_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1821 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1822 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1820, 1823 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1824 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search604_0 -> 722 in the cache */
   /* search604_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 36 },
      0,
   } },
   /* search604_2_0 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1826, 1827 },
      -1,
   } },

   /* replace604_0_0 -> 722 in the cache */
   /* replace604_0_1 -> 36 in the cache */
   /* replace604_0_2 -> 137 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 36, 137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1829 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search605_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1831 },
      -1,
   } },

   /* replace605_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search606_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1834 },
      -1,
   } },

   /* replace606 -> 16 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search607_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1836 },
      -1,
   } },

   /* replace607 -> 16 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search608_0_0 -> 16 in the cache */
   /* search608_0 -> 1834 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1834 },
      -1,
   } },

   /* replace608 -> 16 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search609_0_0 -> 16 in the cache */
   /* search609_0 -> 1836 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1836 },
      -1,
   } },

   /* replace609 -> 16 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search610_0_0_0 -> 117 in the cache */
   /* search610_0_0_1 -> 16 in the cache */
   /* search610_0_0 -> 1794 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1794 },
      -1,
   } },
   /* search610_1_0_0_0 -> 16 in the cache */
   /* search610_1_0_0_1 -> 117 in the cache */
   /* search610_1_0_0 -> 1813 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1813 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1841 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1840, 1842 },
      -1,
   } },

   /* replace610_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search611_0_0_0 -> 124 in the cache */
   /* search611_0_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1845 },
      -1,
   } },
   /* search611_1_0_0_0 -> 16 in the cache */
   /* search611_1_0_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1847 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1848 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1846, 1849 },
      -1,
   } },

   /* replace611_0_0 -> 16 in the cache */
   /* replace611_0 -> 1844 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1844 },
      -1,
   } },

   /* ('f2f32', ('f2f64', 'a@32')) => a */
   /* search612_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1852 },
      -1,
   } },

   /* replace612 -> 16 in the cache */

   /* ('i2i32', ('i2i64', 'a@32')) => a */
   /* search613_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1854 },
      -1,
   } },

   /* replace613 -> 16 in the cache */

   /* ('u2u32', ('u2u64', 'a@32')) => a */
   /* search614_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1856 },
      -1,
   } },

   /* replace614 -> 16 in the cache */

   /* ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a') */
   /* search615_0_0 -> 722 in the cache */
   /* search615_0 -> 1356 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1356 },
      -1,
   } },

   /* replace615_0 -> 722 in the cache */
   /* replace615 -> 1352 in the cache */

   /* ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search616_0_0 -> 722 in the cache */
   /* search616_0 -> 1344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1344 },
      -1,
   } },

   /* replace616_0 -> 722 in the cache */
   /* replace616 -> 1340 in the cache */

   /* ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search617_0_0 -> 722 in the cache */
   /* search617_0 -> 1344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1344 },
      -1,
   } },

   /* replace617_0 -> 722 in the cache */
   /* replace617 -> 1340 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search618_0_0 -> 16 in the cache */
   /* search618_0 -> 1852 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1852 },
      -1,
   } },

   /* replace618_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search619_0_0 -> 16 in the cache */
   /* search619_0 -> 1852 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1852 },
      -1,
   } },

   /* replace619_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search620_0_0 -> 32 in the cache */
   /* search620_0 -> 1781 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1781 },
      -1,
   } },

   /* replace620_0 -> 32 in the cache */
   /* replace620 -> 1758 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search621_0_0 -> 32 in the cache */
   /* search621_0 -> 1783 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1783 },
      -1,
   } },

   /* replace621_0 -> 32 in the cache */
   /* replace621 -> 1761 in the cache */

   /* ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a') */
   /* search622_0_0 -> 16 in the cache */
   /* search622_0 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1856 },
      -1,
   } },

   /* replace622_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a') */
   /* search623_0_0 -> 16 in the cache */
   /* search623_0 -> 1854 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1854 },
      -1,
   } },

   /* replace623_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search624_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1871, 21 },
      0,
   } },
   /* search624_1_0 -> 41 in the cache */
   /* search624_1_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 1871 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1872, 1873 },
      -1,
   } },

   /* replace624_0 -> 1871 in the cache */
   /* replace624_1_0 -> 21 in the cache */
   /* replace624_1_1_0 -> 41 in the cache */
   /* replace624_1_1 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 21, 658 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1871, 1875 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search625_0_0 -> 1871 in the cache */
   /* search625_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1871, 21 },
      -1,
   } },
   /* search625_1_0 -> 41 in the cache */
   /* search625_1_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 1871 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1877, 1878 },
      -1,
   } },

   /* replace625_0 -> 1871 in the cache */
   /* replace625_1_0 -> 21 in the cache */
   /* replace625_1_1_0 -> 41 in the cache */
   /* replace625_1_1 -> 658 in the cache */
   /* replace625_1 -> 1875 in the cache */
   /* replace625 -> 1876 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search626_0_0 -> 1871 in the cache */
   /* search626_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1871, 21 },
      0,
   } },
   /* search626_1_0 -> 41 in the cache */
   /* search626_1_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 1871 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1880, 1881 },
      -1,
   } },

   /* replace626_0 -> 1871 in the cache */
   /* replace626_1_0 -> 21 in the cache */
   /* replace626_1_1_0 -> 41 in the cache */
   /* replace626_1_1 -> 658 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 21, 658 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1871, 1883 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search627_0_0 -> 1871 in the cache */
   /* search627_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1871, 21 },
      -1,
   } },
   /* search627_1_0 -> 41 in the cache */
   /* search627_1_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 1871 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1885, 1886 },
      -1,
   } },

   /* replace627_0 -> 1871 in the cache */
   /* replace627_1_0 -> 21 in the cache */
   /* replace627_1_1_0 -> 41 in the cache */
   /* replace627_1_1 -> 658 in the cache */
   /* replace627_1 -> 1883 in the cache */
   /* replace627 -> 1884 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search628_0_0 -> 1871 in the cache */
   /* search628_0_1 -> 21 in the cache */
   /* search628_0 -> 1872 in the cache */
   /* search628_1_0 -> 41 in the cache */
   /* search628_1_1 -> 1871 in the cache */
   /* search628_1 -> 1873 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1872, 1873 },
      -1,
   } },

   /* replace628_0 -> 1871 in the cache */
   /* replace628_1_0 -> 21 in the cache */
   /* replace628_1_1_0 -> 41 in the cache */
   /* replace628_1_1 -> 658 in the cache */
   /* replace628_1 -> 1883 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1871, 1883 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search629_0_0 -> 1871 in the cache */
   /* search629_0_1 -> 21 in the cache */
   /* search629_0 -> 1877 in the cache */
   /* search629_1_0 -> 41 in the cache */
   /* search629_1_1 -> 1871 in the cache */
   /* search629_1 -> 1878 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1877, 1878 },
      -1,
   } },

   /* replace629_0 -> 1871 in the cache */
   /* replace629_1_0 -> 21 in the cache */
   /* replace629_1_1_0 -> 41 in the cache */
   /* replace629_1_1 -> 658 in the cache */
   /* replace629_1 -> 1883 in the cache */
   /* replace629 -> 1889 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search630_0_0 -> 1871 in the cache */
   /* search630_0_1 -> 21 in the cache */
   /* search630_0 -> 1880 in the cache */
   /* search630_1_0 -> 41 in the cache */
   /* search630_1_1 -> 1871 in the cache */
   /* search630_1 -> 1881 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1880, 1881 },
      -1,
   } },

   /* replace630_0 -> 1871 in the cache */
   /* replace630_1_0 -> 21 in the cache */
   /* replace630_1_1_0 -> 41 in the cache */
   /* replace630_1_1 -> 658 in the cache */
   /* replace630_1 -> 1875 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1871, 1875 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search631_0_0 -> 1871 in the cache */
   /* search631_0_1 -> 21 in the cache */
   /* search631_0 -> 1885 in the cache */
   /* search631_1_0 -> 41 in the cache */
   /* search631_1_1 -> 1871 in the cache */
   /* search631_1 -> 1886 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1885, 1886 },
      -1,
   } },

   /* replace631_0 -> 1871 in the cache */
   /* replace631_1_0 -> 21 in the cache */
   /* replace631_1_1_0 -> 41 in the cache */
   /* replace631_1_1 -> 658 in the cache */
   /* replace631_1 -> 1875 in the cache */
   /* replace631 -> 1892 in the cache */

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search632_0_0 -> 21 in the cache */
   /* search632_0_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 21, 1871 },
      -1,
   } },
   /* search632_1 -> 607 in the cache */
   /* search632_2_0_0_0_0 -> 1871 in the cache */
   /* search632_2_0_0_0_1 -> 21 in the cache */
   /* search632_2_0_0_0 -> 1877 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1877 },
      -1,
   } },
   /* search632_2_0_1_0_0_0 -> 21 in the cache */
   /* search632_2_0_1_0_0_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 1871 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1896 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1897 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1895, 1898 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1899 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1894, 607, 1900 },
      -1,
   } },

   /* replace632_0_0_0_0 -> 21 in the cache */
   /* replace632_0_0_0_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 21, 1871 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1902 },
      -1,
   } },
   /* replace632_0_1_0_0_0 -> 21 in the cache */
   /* replace632_0_1_0_0_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 1871 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1904 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1905 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1903, 1906 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1907 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search633_0 -> 722 in the cache */
   /* search633_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 41 },
      0,
   } },
   /* search633_2_0 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 595 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1909, 1910 },
      -1,
   } },

   /* replace633_0_0 -> 722 in the cache */
   /* replace633_0_1 -> 41 in the cache */
   /* replace633_0_2 -> 595 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 41, 595 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1912 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search634_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1914 },
      -1,
   } },

   /* replace634_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search635_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1917 },
      -1,
   } },

   /* replace635 -> 21 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search636_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1919 },
      -1,
   } },

   /* replace636 -> 21 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search637_0_0 -> 21 in the cache */
   /* search637_0 -> 1917 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1917 },
      -1,
   } },

   /* replace637 -> 21 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search638_0_0 -> 21 in the cache */
   /* search638_0 -> 1919 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1919 },
      -1,
   } },

   /* replace638 -> 21 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search639_0_0_0 -> 1871 in the cache */
   /* search639_0_0_1 -> 21 in the cache */
   /* search639_0_0 -> 1877 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1877 },
      -1,
   } },
   /* search639_1_0_0_0 -> 21 in the cache */
   /* search639_1_0_0_1 -> 1871 in the cache */
   /* search639_1_0_0 -> 1896 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1896 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1924 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1923, 1925 },
      -1,
   } },

   /* replace639_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search640_0_0_0 -> 859 in the cache */
   /* search640_0_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 859, 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1928 },
      -1,
   } },
   /* search640_1_0_0_0 -> 21 in the cache */
   /* search640_1_0_0_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1930 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1931 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1929, 1932 },
      -1,
   } },

   /* replace640_0_0 -> 21 in the cache */
   /* replace640_0 -> 1927 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1927 },
      -1,
   } },

   /* ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a') */
   /* search641_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1935 },
      -1,
   } },

   /* replace641_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a') */
   /* search642_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1938 },
      -1,
   } },

   /* replace642_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a') */
   /* search643_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1941 },
      -1,
   } },

   /* replace643_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a') */
   /* search644_0_0 -> 16 in the cache */
   /* search644_0 -> 1941 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1941 },
      -1,
   } },

   /* replace644_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a') */
   /* search645_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1946 },
      -1,
   } },

   /* replace645_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a') */
   /* search646_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1949 },
      -1,
   } },

   /* replace646_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a') */
   /* search647_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 1952 },
      -1,
   } },

   /* replace647_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a') */
   /* search648_0_0 -> 16 in the cache */
   /* search648_0 -> 1952 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1952 },
      -1,
   } },

   /* replace648_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255)) */
   /* search649_0_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1957 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1958, 1959 },
      -1,
   } },

   /* replace649_0 -> 11 in the cache */
   /* replace649_1_0 -> 247 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 247, 1961 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 11, 1962 },
      -1,
   } },

   /* ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255)) */
   /* search650_0_0_0 -> 11 in the cache */
   /* search650_0_0_1 -> 1959 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1959 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1964 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 1,
      { 1965 },
      -1,
   } },

   /* replace650_0 -> 11 in the cache */
   /* replace650_1_0 -> 247 in the cache */
   /* replace650_1_1 -> 1961 in the cache */
   /* replace650_1 -> 1962 in the cache */
   /* replace650 -> 1963 in the cache */

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search651_0_0_0_0 -> 11 in the cache */
   /* search651_0_0_0 -> 1957 in the cache */
   /* search651_0_0 -> 1958 in the cache */
   /* search651_0_1_0_0 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 247 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1967 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1958, 1968 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1969 },
      -1,
   } },

   /* replace651_0_0 -> 11 in the cache */
   /* replace651_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 247 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1971 },
      -1,
   } },

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search652_0_0_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1973 },
      -1,
   } },
   /* search652_0_1_0_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1975 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1974, 1976 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1977 },
      -1,
   } },

   /* replace652_0_0 -> 16 in the cache */
   /* replace652_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1979 },
      -1,
   } },

   /* ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b') */
   /* search653_0_0 -> 0 in the cache */
   /* search653_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 0, 783 },
      -1,
   } },
   /* search653_1_0 -> 142 in the cache */
   /* search653_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1981, 1982 },
      -1,
   } },

   /* replace653_0_0 -> 0 in the cache */
   /* replace653_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 142 },
      -1,
   } },
   /* replace653_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 1984, 3 },
      -1,
   } },

   /* ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b') */
   /* search654_0_0 -> 0 in the cache */
   /* search654_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 0, 783 },
      -1,
   } },
   /* search654_1_0 -> 142 in the cache */
   /* search654_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1986, 1987 },
      -1,
   } },

   /* replace654_0_0 -> 0 in the cache */
   /* replace654_0_1 -> 142 in the cache */
   /* replace654_0 -> 1984 in the cache */
   /* replace654_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 1984, 3 },
      -1,
   } },

   /* ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b') */
   /* search655_0_0 -> 0 in the cache */
   /* search655_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 0, 783 },
      -1,
   } },
   /* search655_1_0 -> 142 in the cache */
   /* search655_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1990, 1991 },
      -1,
   } },

   /* replace655_0_0 -> 0 in the cache */
   /* replace655_0_1 -> 142 in the cache */
   /* replace655_0 -> 1984 in the cache */
   /* replace655_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 1984, 3 },
      -1,
   } },

   /* ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b') */
   /* search656_0_0 -> 0 in the cache */
   /* search656_0_1 -> 783 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 0, 783 },
      -1,
   } },
   /* search656_1_0 -> 142 in the cache */
   /* search656_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 142, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1994, 1995 },
      -1,
   } },

   /* replace656_0_0 -> 0 in the cache */
   /* replace656_0_1 -> 142 in the cache */
   /* replace656_0 -> 1984 in the cache */
   /* replace656_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 1984, 3 },
      -1,
   } },

   /* ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b') */
   /* search657_0_0 -> 128 in the cache */
   /* search657_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 128, 33 },
      0,
   } },
   /* search657_1_0 -> 131 in the cache */
   /* search657_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 131, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1998, 1999 },
      -1,
   } },

   /* replace657_0_0 -> 128 in the cache */
   /* replace657_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 128, 131 },
      -1,
   } },
   /* replace657_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2001, 36 },
      -1,
   } },

   /* ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b') */
   /* search658_0_0 -> 128 in the cache */
   /* search658_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 128, 33 },
      0,
   } },
   /* search658_1_0 -> 131 in the cache */
   /* search658_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 131, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2003, 2004 },
      -1,
   } },

   /* replace658_0_0 -> 128 in the cache */
   /* replace658_0_1 -> 131 in the cache */
   /* replace658_0 -> 2001 in the cache */
   /* replace658_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2001, 36 },
      -1,
   } },

   /* ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b') */
   /* search659_0_0 -> 128 in the cache */
   /* search659_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 128, 33 },
      0,
   } },
   /* search659_1_0 -> 131 in the cache */
   /* search659_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 131, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2007, 2008 },
      -1,
   } },

   /* replace659_0_0 -> 128 in the cache */
   /* replace659_0_1 -> 131 in the cache */
   /* replace659_0 -> 2001 in the cache */
   /* replace659_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2001, 36 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search660_0_0_0_0 -> 11 in the cache */
   /* search660_0_0_0 -> 1957 in the cache */
   /* search660_0_0 -> 1958 in the cache */
   /* search660_0_1_0_0 -> 247 in the cache */
   /* search660_0_1_0 -> 1967 in the cache */
   /* search660_0_1 -> 1968 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1958, 1968 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2011 },
      -1,
   } },

   /* replace660_0_0 -> 11 in the cache */
   /* replace660_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 11, 247 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2013 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search661_0_0_0_0 -> 16 in the cache */
   /* search661_0_0_0 -> 1973 in the cache */
   /* search661_0_0 -> 1974 in the cache */
   /* search661_0_1_0_0 -> 36 in the cache */
   /* search661_0_1_0 -> 1975 in the cache */
   /* search661_0_1 -> 1976 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1974, 1976 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2015 },
      -1,
   } },

   /* replace661_0_0 -> 16 in the cache */
   /* replace661_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2017 },
      -1,
   } },

   /* ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b') */
   /* search662_0_0 -> 0 in the cache */
   /* search662_0_1 -> 783 in the cache */
   /* search662_0 -> 1981 in the cache */
   /* search662_1_0 -> 142 in the cache */
   /* search662_1_1 -> 3 in the cache */
   /* search662_1 -> 1982 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1981, 1982 },
      -1,
   } },

   /* replace662_0_0 -> 0 in the cache */
   /* replace662_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 142 },
      -1,
   } },
   /* replace662_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2020, 3 },
      -1,
   } },

   /* ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b') */
   /* search663_0_0 -> 0 in the cache */
   /* search663_0_1 -> 783 in the cache */
   /* search663_0 -> 1986 in the cache */
   /* search663_1_0 -> 142 in the cache */
   /* search663_1_1 -> 3 in the cache */
   /* search663_1 -> 1987 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1986, 1987 },
      -1,
   } },

   /* replace663_0_0 -> 0 in the cache */
   /* replace663_0_1 -> 142 in the cache */
   /* replace663_0 -> 2020 in the cache */
   /* replace663_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2020, 3 },
      -1,
   } },

   /* ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b') */
   /* search664_0_0 -> 0 in the cache */
   /* search664_0_1 -> 783 in the cache */
   /* search664_0 -> 1990 in the cache */
   /* search664_1_0 -> 142 in the cache */
   /* search664_1_1 -> 3 in the cache */
   /* search664_1 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1990, 1991 },
      -1,
   } },

   /* replace664_0_0 -> 0 in the cache */
   /* replace664_0_1 -> 142 in the cache */
   /* replace664_0 -> 2020 in the cache */
   /* replace664_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2020, 3 },
      -1,
   } },

   /* ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b') */
   /* search665_0_0 -> 0 in the cache */
   /* search665_0_1 -> 783 in the cache */
   /* search665_0 -> 1994 in the cache */
   /* search665_1_0 -> 142 in the cache */
   /* search665_1_1 -> 3 in the cache */
   /* search665_1 -> 1995 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1994, 1995 },
      -1,
   } },

   /* replace665_0_0 -> 0 in the cache */
   /* replace665_0_1 -> 142 in the cache */
   /* replace665_0 -> 2020 in the cache */
   /* replace665_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2020, 3 },
      -1,
   } },

   /* ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b') */
   /* search666_0_0 -> 128 in the cache */
   /* search666_0_1 -> 33 in the cache */
   /* search666_0 -> 1998 in the cache */
   /* search666_1_0 -> 131 in the cache */
   /* search666_1_1 -> 36 in the cache */
   /* search666_1 -> 1999 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1998, 1999 },
      -1,
   } },

   /* replace666_0_0 -> 128 in the cache */
   /* replace666_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 128, 131 },
      -1,
   } },
   /* replace666_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2029, 36 },
      -1,
   } },

   /* ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b') */
   /* search667_0_0 -> 128 in the cache */
   /* search667_0_1 -> 33 in the cache */
   /* search667_0 -> 2003 in the cache */
   /* search667_1_0 -> 131 in the cache */
   /* search667_1_1 -> 36 in the cache */
   /* search667_1 -> 2004 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2003, 2004 },
      -1,
   } },

   /* replace667_0_0 -> 128 in the cache */
   /* replace667_0_1 -> 131 in the cache */
   /* replace667_0 -> 2029 in the cache */
   /* replace667_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2029, 36 },
      -1,
   } },

   /* ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b') */
   /* search668_0_0 -> 128 in the cache */
   /* search668_0_1 -> 33 in the cache */
   /* search668_0 -> 2007 in the cache */
   /* search668_1_0 -> 131 in the cache */
   /* search668_1_1 -> 36 in the cache */
   /* search668_1 -> 2008 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2007, 2008 },
      -1,
   } },

   /* replace668_0_0 -> 128 in the cache */
   /* replace668_0_1 -> 131 in the cache */
   /* replace668_0 -> 2029 in the cache */
   /* replace668_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2029, 36 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search669_0_0_0_0 -> 11 in the cache */
   /* search669_0_0_0 -> 1957 in the cache */
   /* search669_0_0 -> 1958 in the cache */
   /* search669_0_1_0_0 -> 247 in the cache */
   /* search669_0_1_0 -> 1967 in the cache */
   /* search669_0_1 -> 1968 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1958, 1968 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2035 },
      -1,
   } },

   /* replace669_0_0 -> 11 in the cache */
   /* replace669_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 11, 247 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2037 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search670_0_0_0_0 -> 16 in the cache */
   /* search670_0_0_0 -> 1973 in the cache */
   /* search670_0_0 -> 1974 in the cache */
   /* search670_0_1_0_0 -> 36 in the cache */
   /* search670_0_1_0 -> 1975 in the cache */
   /* search670_0_1 -> 1976 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1974, 1976 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2039 },
      -1,
   } },

   /* replace670_0_0 -> 16 in the cache */
   /* replace670_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2041 },
      -1,
   } },

   /* ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b') */
   /* search671_0_0 -> 0 in the cache */
   /* search671_0_1 -> 783 in the cache */
   /* search671_0 -> 1981 in the cache */
   /* search671_1_0 -> 142 in the cache */
   /* search671_1_1 -> 3 in the cache */
   /* search671_1 -> 1982 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1981, 1982 },
      -1,
   } },

   /* replace671_0_0 -> 0 in the cache */
   /* replace671_0_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 0, 142 },
      -1,
   } },
   /* replace671_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2044, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b') */
   /* search672_0_0 -> 0 in the cache */
   /* search672_0_1 -> 783 in the cache */
   /* search672_0 -> 1986 in the cache */
   /* search672_1_0 -> 142 in the cache */
   /* search672_1_1 -> 3 in the cache */
   /* search672_1 -> 1987 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1986, 1987 },
      -1,
   } },

   /* replace672_0_0 -> 0 in the cache */
   /* replace672_0_1 -> 142 in the cache */
   /* replace672_0 -> 2044 in the cache */
   /* replace672_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2044, 3 },
      -1,
   } },

   /* ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b') */
   /* search673_0_0 -> 0 in the cache */
   /* search673_0_1 -> 783 in the cache */
   /* search673_0 -> 1990 in the cache */
   /* search673_1_0 -> 142 in the cache */
   /* search673_1_1 -> 3 in the cache */
   /* search673_1 -> 1991 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1990, 1991 },
      -1,
   } },

   /* replace673_0_0 -> 0 in the cache */
   /* replace673_0_1 -> 142 in the cache */
   /* replace673_0 -> 2044 in the cache */
   /* replace673_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2044, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b') */
   /* search674_0_0 -> 0 in the cache */
   /* search674_0_1 -> 783 in the cache */
   /* search674_0 -> 1994 in the cache */
   /* search674_1_0 -> 142 in the cache */
   /* search674_1_1 -> 3 in the cache */
   /* search674_1 -> 1995 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1994, 1995 },
      -1,
   } },

   /* replace674_0_0 -> 0 in the cache */
   /* replace674_0_1 -> 142 in the cache */
   /* replace674_0 -> 2044 in the cache */
   /* replace674_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2044, 3 },
      -1,
   } },

   /* ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b') */
   /* search675_0_0 -> 128 in the cache */
   /* search675_0_1 -> 33 in the cache */
   /* search675_0 -> 1998 in the cache */
   /* search675_1_0 -> 131 in the cache */
   /* search675_1_1 -> 36 in the cache */
   /* search675_1 -> 1999 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1998, 1999 },
      -1,
   } },

   /* replace675_0_0 -> 128 in the cache */
   /* replace675_0_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 128, 131 },
      -1,
   } },
   /* replace675_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2053, 36 },
      -1,
   } },

   /* ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b') */
   /* search676_0_0 -> 128 in the cache */
   /* search676_0_1 -> 33 in the cache */
   /* search676_0 -> 2003 in the cache */
   /* search676_1_0 -> 131 in the cache */
   /* search676_1_1 -> 36 in the cache */
   /* search676_1 -> 2004 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2003, 2004 },
      -1,
   } },

   /* replace676_0_0 -> 128 in the cache */
   /* replace676_0_1 -> 131 in the cache */
   /* replace676_0 -> 2053 in the cache */
   /* replace676_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2053, 36 },
      -1,
   } },

   /* ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b') */
   /* search677_0_0 -> 128 in the cache */
   /* search677_0_1 -> 33 in the cache */
   /* search677_0 -> 2007 in the cache */
   /* search677_1_0 -> 131 in the cache */
   /* search677_1_1 -> 36 in the cache */
   /* search677_1 -> 2008 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 2007, 2008 },
      -1,
   } },

   /* replace677_0_0 -> 128 in the cache */
   /* replace677_0_1 -> 131 in the cache */
   /* replace677_0 -> 2053 in the cache */
   /* replace677_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2053, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search678_0_0 -> 6 in the cache */
   /* search678_0_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 6, 797 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search678_1_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 2060, 797 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2059, 2061 },
      -1,
   } },

   /* replace678_0_0 -> 6 in the cache */
   /* replace678_0_1 -> 2060 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 6, 2060 },
      -1,
   } },
   /* replace678_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2063, 797 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search679_0_0 -> 6 in the cache */
   /* search679_0_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 6, 797 },
      -1,
   } },
   /* search679_1_0 -> 2060 in the cache */
   /* search679_1_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 2060, 797 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2065, 2066 },
      -1,
   } },

   /* replace679_0_0 -> 6 in the cache */
   /* replace679_0_1 -> 2060 in the cache */
   /* replace679_0 -> 2063 in the cache */
   /* replace679_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2063, 797 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search680_0_0 -> 6 in the cache */
   /* search680_0_1 -> 797 in the cache */
   /* search680_0 -> 2059 in the cache */
   /* search680_1_0 -> 2060 in the cache */
   /* search680_1_1 -> 797 in the cache */
   /* search680_1 -> 2061 in the cache */
   /* search680 -> 2062 in the cache */

   /* replace680_0_0 -> 6 in the cache */
   /* replace680_0_1 -> 2060 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 6, 2060 },
      -1,
   } },
   /* replace680_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2069, 797 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search681_0_0 -> 6 in the cache */
   /* search681_0_1 -> 797 in the cache */
   /* search681_0 -> 2059 in the cache */
   /* search681_1_0 -> 2060 in the cache */
   /* search681_1_1 -> 797 in the cache */
   /* search681_1 -> 2061 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2059, 2061 },
      -1,
   } },

   /* replace681_0_0 -> 6 in the cache */
   /* replace681_0_1 -> 2060 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 6, 2060 },
      -1,
   } },
   /* replace681_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2072, 797 },
      -1,
   } },

   /* ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search682_0_0 -> 6 in the cache */
   /* search682_0_1 -> 797 in the cache */
   /* search682_0 -> 2065 in the cache */
   /* search682_1_0 -> 2060 in the cache */
   /* search682_1_1 -> 797 in the cache */
   /* search682_1 -> 2066 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2065, 2066 },
      -1,
   } },

   /* replace682_0_0 -> 6 in the cache */
   /* replace682_0_1 -> 2060 in the cache */
   /* replace682_0 -> 2072 in the cache */
   /* replace682_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2072, 797 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search683_0_0 -> 6 in the cache */
   /* search683_0_1 -> 797 in the cache */
   /* search683_0 -> 2065 in the cache */
   /* search683_1_0 -> 2060 in the cache */
   /* search683_1_1 -> 797 in the cache */
   /* search683_1 -> 2066 in the cache */
   /* search683 -> 2067 in the cache */

   /* replace683_0_0 -> 6 in the cache */
   /* replace683_0_1 -> 2060 in the cache */
   /* replace683_0 -> 2069 in the cache */
   /* replace683_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2069, 797 },
      -1,
   } },

   /* ('ineg', ('b2i8', 'a@8')) => a */
   /* search684_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2077 },
      -1,
   } },

   /* replace684 -> 6 in the cache */

   /* ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b') */
   /* search685_0 -> 6 in the cache */
   /* search685_1_0 -> 9 in the cache */
   /* search685_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 9, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 2079 },
      -1,
   } },

   /* replace685_0 -> 6 in the cache */
   /* replace685_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b') */
   /* search686_0 -> 6 in the cache */
   /* search686_1_0 -> 9 in the cache */
   /* search686_1_1 -> 36 in the cache */
   /* search686_1 -> 2079 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 6, 2079 },
      -1,
   } },

   /* replace686_0 -> 6 in the cache */
   /* replace686_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b') */
   /* search687_0 -> 6 in the cache */
   /* search687_1_0 -> 9 in the cache */
   /* search687_1_1 -> 36 in the cache */
   /* search687_1 -> 2079 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2079 },
      -1,
   } },

   /* replace687_0 -> 6 in the cache */
   /* replace687_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2)) */
   /* search688_0 -> 6 in the cache */
   /* search688_1_0_0 -> 36 in the cache */
   /* search688_1_0_1 -> 381 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 36, 381 },
      -1,
   } },
   /* search688_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2086, 386 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2087 },
      -1,
   } },

   /* replace688_0 -> 6 in the cache */
   /* replace688_1_0 -> 36 in the cache */
   /* replace688_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 2089 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search689_0_0 -> 11 in the cache */
   /* search689_0_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 11, 818 },
      -1,
   } },
   /* search689_1_0 -> 247 in the cache */
   /* search689_1_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 247, 818 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2091, 2092 },
      -1,
   } },

   /* replace689_0_0 -> 11 in the cache */
   /* replace689_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 11, 247 },
      -1,
   } },
   /* replace689_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2094, 818 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search690_0_0 -> 11 in the cache */
   /* search690_0_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 11, 818 },
      -1,
   } },
   /* search690_1_0 -> 247 in the cache */
   /* search690_1_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 247, 818 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2096, 2097 },
      -1,
   } },

   /* replace690_0_0 -> 11 in the cache */
   /* replace690_0_1 -> 247 in the cache */
   /* replace690_0 -> 2094 in the cache */
   /* replace690_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2094, 818 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search691_0_0 -> 11 in the cache */
   /* search691_0_1 -> 818 in the cache */
   /* search691_0 -> 2091 in the cache */
   /* search691_1_0 -> 247 in the cache */
   /* search691_1_1 -> 818 in the cache */
   /* search691_1 -> 2092 in the cache */
   /* search691 -> 2093 in the cache */

   /* replace691_0_0 -> 11 in the cache */
   /* replace691_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 11, 247 },
      -1,
   } },
   /* replace691_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2100, 818 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search692_0_0 -> 11 in the cache */
   /* search692_0_1 -> 818 in the cache */
   /* search692_0 -> 2091 in the cache */
   /* search692_1_0 -> 247 in the cache */
   /* search692_1_1 -> 818 in the cache */
   /* search692_1 -> 2092 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2091, 2092 },
      -1,
   } },

   /* replace692_0_0 -> 11 in the cache */
   /* replace692_0_1 -> 247 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 11, 247 },
      -1,
   } },
   /* replace692_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2103, 818 },
      -1,
   } },

   /* ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search693_0_0 -> 11 in the cache */
   /* search693_0_1 -> 818 in the cache */
   /* search693_0 -> 2096 in the cache */
   /* search693_1_0 -> 247 in the cache */
   /* search693_1_1 -> 818 in the cache */
   /* search693_1 -> 2097 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2096, 2097 },
      -1,
   } },

   /* replace693_0_0 -> 11 in the cache */
   /* replace693_0_1 -> 247 in the cache */
   /* replace693_0 -> 2103 in the cache */
   /* replace693_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2103, 818 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search694_0_0 -> 11 in the cache */
   /* search694_0_1 -> 818 in the cache */
   /* search694_0 -> 2096 in the cache */
   /* search694_1_0 -> 247 in the cache */
   /* search694_1_1 -> 818 in the cache */
   /* search694_1 -> 2097 in the cache */
   /* search694 -> 2098 in the cache */

   /* replace694_0_0 -> 11 in the cache */
   /* replace694_0_1 -> 247 in the cache */
   /* replace694_0 -> 2100 in the cache */
   /* replace694_1 -> 818 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2100, 818 },
      -1,
   } },

   /* ('ineg', ('b2i16', 'a@16')) => a */
   /* search695_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2108 },
      -1,
   } },

   /* replace695 -> 11 in the cache */

   /* ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b') */
   /* search696_0 -> 11 in the cache */
   /* search696_1_0 -> 14 in the cache */
   /* search696_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 14, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2110 },
      -1,
   } },

   /* replace696_0 -> 11 in the cache */
   /* replace696_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b') */
   /* search697_0 -> 11 in the cache */
   /* search697_1_0 -> 14 in the cache */
   /* search697_1_1 -> 36 in the cache */
   /* search697_1 -> 2110 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 11, 2110 },
      -1,
   } },

   /* replace697_0 -> 11 in the cache */
   /* replace697_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b') */
   /* search698_0 -> 11 in the cache */
   /* search698_1_0 -> 14 in the cache */
   /* search698_1_1 -> 36 in the cache */
   /* search698_1 -> 2110 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2110 },
      -1,
   } },

   /* replace698_0 -> 11 in the cache */
   /* replace698_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3)) */
   /* search699_0 -> 11 in the cache */
   /* search699_1_0_0 -> 36 in the cache */
   /* search699_1_0_1 -> 381 in the cache */
   /* search699_1_0 -> 2086 in the cache */
   /* search699_1_1 -> 390 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2086, 390 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2117 },
      -1,
   } },

   /* replace699_0 -> 11 in the cache */
   /* replace699_1_0 -> 36 in the cache */
   /* replace699_1_1 -> 390 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 390 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 2119 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search700_0_0 -> 16 in the cache */
   /* search700_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 16, 124 },
      -1,
   } },
   /* search700_1_0 -> 36 in the cache */
   /* search700_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2121, 2122 },
      -1,
   } },

   /* replace700_0_0 -> 16 in the cache */
   /* replace700_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace700_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2124, 124 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search701_0_0 -> 16 in the cache */
   /* search701_0_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 16, 124 },
      -1,
   } },
   /* search701_1_0 -> 36 in the cache */
   /* search701_1_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 36, 124 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2126, 2127 },
      -1,
   } },

   /* replace701_0_0 -> 16 in the cache */
   /* replace701_0_1 -> 36 in the cache */
   /* replace701_0 -> 2124 in the cache */
   /* replace701_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2124, 124 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search702_0_0 -> 16 in the cache */
   /* search702_0_1 -> 124 in the cache */
   /* search702_0 -> 2121 in the cache */
   /* search702_1_0 -> 36 in the cache */
   /* search702_1_1 -> 124 in the cache */
   /* search702_1 -> 2122 in the cache */
   /* search702 -> 2123 in the cache */

   /* replace702_0_0 -> 16 in the cache */
   /* replace702_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace702_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2130, 124 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search703_0_0 -> 16 in the cache */
   /* search703_0_1 -> 124 in the cache */
   /* search703_0 -> 2121 in the cache */
   /* search703_1_0 -> 36 in the cache */
   /* search703_1_1 -> 124 in the cache */
   /* search703_1 -> 2122 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2121, 2122 },
      -1,
   } },

   /* replace703_0_0 -> 16 in the cache */
   /* replace703_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace703_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2133, 124 },
      -1,
   } },

   /* ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search704_0_0 -> 16 in the cache */
   /* search704_0_1 -> 124 in the cache */
   /* search704_0 -> 2126 in the cache */
   /* search704_1_0 -> 36 in the cache */
   /* search704_1_1 -> 124 in the cache */
   /* search704_1 -> 2127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2126, 2127 },
      -1,
   } },

   /* replace704_0_0 -> 16 in the cache */
   /* replace704_0_1 -> 36 in the cache */
   /* replace704_0 -> 2133 in the cache */
   /* replace704_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2133, 124 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search705_0_0 -> 16 in the cache */
   /* search705_0_1 -> 124 in the cache */
   /* search705_0 -> 2126 in the cache */
   /* search705_1_0 -> 36 in the cache */
   /* search705_1_1 -> 124 in the cache */
   /* search705_1 -> 2127 in the cache */
   /* search705 -> 2128 in the cache */

   /* replace705_0_0 -> 16 in the cache */
   /* replace705_0_1 -> 36 in the cache */
   /* replace705_0 -> 2130 in the cache */
   /* replace705_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2130, 124 },
      -1,
   } },

   /* ('ineg', ('b2i32', 'a@32')) => a */
   /* search706_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2138 },
      -1,
   } },

   /* replace706 -> 16 in the cache */

   /* ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b') */
   /* search707_0 -> 16 in the cache */
   /* search707_1_0 -> 19 in the cache */
   /* search707_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2140 },
      -1,
   } },

   /* replace707_0 -> 16 in the cache */
   /* replace707_1 -> 36 in the cache */
   /* replace707 -> 908 in the cache */

   /* ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b') */
   /* search708_0 -> 16 in the cache */
   /* search708_1_0 -> 19 in the cache */
   /* search708_1_1 -> 36 in the cache */
   /* search708_1 -> 2140 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 16, 2140 },
      -1,
   } },

   /* replace708_0 -> 16 in the cache */
   /* replace708_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b') */
   /* search709_0 -> 16 in the cache */
   /* search709_1_0 -> 19 in the cache */
   /* search709_1_1 -> 36 in the cache */
   /* search709_1 -> 2140 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2140 },
      -1,
   } },

   /* replace709_0 -> 16 in the cache */
   /* replace709_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4)) */
   /* search710_0 -> 16 in the cache */
   /* search710_1_0_0 -> 36 in the cache */
   /* search710_1_0_1 -> 381 in the cache */
   /* search710_1_0 -> 2086 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x4 /* 4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2086, 2146 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2147 },
      -1,
   } },

   /* replace710_0 -> 16 in the cache */
   /* replace710_1_0 -> 36 in the cache */
   /* replace710_1_1 -> 2146 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 2146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 2149 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search711_0_0 -> 21 in the cache */
   /* search711_0_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 21, 859 },
      -1,
   } },
   /* search711_1_0 -> 41 in the cache */
   /* search711_1_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 41, 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2151, 2152 },
      -1,
   } },

   /* replace711_0_0 -> 21 in the cache */
   /* replace711_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace711_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2154, 859 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search712_0_0 -> 21 in the cache */
   /* search712_0_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 21, 859 },
      -1,
   } },
   /* search712_1_0 -> 41 in the cache */
   /* search712_1_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 41, 859 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2156, 2157 },
      -1,
   } },

   /* replace712_0_0 -> 21 in the cache */
   /* replace712_0_1 -> 41 in the cache */
   /* replace712_0 -> 2154 in the cache */
   /* replace712_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2154, 859 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search713_0_0 -> 21 in the cache */
   /* search713_0_1 -> 859 in the cache */
   /* search713_0 -> 2151 in the cache */
   /* search713_1_0 -> 41 in the cache */
   /* search713_1_1 -> 859 in the cache */
   /* search713_1 -> 2152 in the cache */
   /* search713 -> 2153 in the cache */

   /* replace713_0_0 -> 21 in the cache */
   /* replace713_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace713_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2160, 859 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search714_0_0 -> 21 in the cache */
   /* search714_0_1 -> 859 in the cache */
   /* search714_0 -> 2151 in the cache */
   /* search714_1_0 -> 41 in the cache */
   /* search714_1_1 -> 859 in the cache */
   /* search714_1 -> 2152 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2151, 2152 },
      -1,
   } },

   /* replace714_0_0 -> 21 in the cache */
   /* replace714_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace714_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2163, 859 },
      -1,
   } },

   /* ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search715_0_0 -> 21 in the cache */
   /* search715_0_1 -> 859 in the cache */
   /* search715_0 -> 2156 in the cache */
   /* search715_1_0 -> 41 in the cache */
   /* search715_1_1 -> 859 in the cache */
   /* search715_1 -> 2157 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2156, 2157 },
      -1,
   } },

   /* replace715_0_0 -> 21 in the cache */
   /* replace715_0_1 -> 41 in the cache */
   /* replace715_0 -> 2163 in the cache */
   /* replace715_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2163, 859 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search716_0_0 -> 21 in the cache */
   /* search716_0_1 -> 859 in the cache */
   /* search716_0 -> 2156 in the cache */
   /* search716_1_0 -> 41 in the cache */
   /* search716_1_1 -> 859 in the cache */
   /* search716_1 -> 2157 in the cache */
   /* search716 -> 2158 in the cache */

   /* replace716_0_0 -> 21 in the cache */
   /* replace716_0_1 -> 41 in the cache */
   /* replace716_0 -> 2160 in the cache */
   /* replace716_1 -> 859 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2160, 859 },
      -1,
   } },

   /* ('ineg', ('b2i64', 'a@64')) => a */
   /* search717_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2168 },
      -1,
   } },

   /* replace717 -> 21 in the cache */

   /* ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b') */
   /* search718_0 -> 21 in the cache */
   /* search718_1_0 -> 24 in the cache */
   /* search718_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 2170 },
      -1,
   } },

   /* replace718_0 -> 21 in the cache */
   /* replace718_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b') */
   /* search719_0 -> 21 in the cache */
   /* search719_1_0 -> 24 in the cache */
   /* search719_1_1 -> 36 in the cache */
   /* search719_1 -> 2170 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 21, 2170 },
      -1,
   } },

   /* replace719_0 -> 21 in the cache */
   /* replace719_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b') */
   /* search720_0 -> 21 in the cache */
   /* search720_1_0 -> 24 in the cache */
   /* search720_1_1 -> 36 in the cache */
   /* search720_1 -> 2170 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2170 },
      -1,
   } },

   /* replace720_0 -> 21 in the cache */
   /* replace720_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5)) */
   /* search721_0 -> 21 in the cache */
   /* search721_1_0_0 -> 36 in the cache */
   /* search721_1_0_1 -> 381 in the cache */
   /* search721_1_0 -> 2086 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x5 /* 5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2086, 2177 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2178 },
      -1,
   } },

   /* replace721_0 -> 21 in the cache */
   /* replace721_1_0 -> 36 in the cache */
   /* replace721_1_1 -> 2177 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 36, 2177 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 2180 },
      -1,
   } },

   /* ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a') */
   /* search722_0_0 -> 32 in the cache */
   /* search722_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 61 },
      -1,
   } },
   /* search722_1_0 -> 32 in the cache */
   /* search722_1_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 32, 35 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2182, 2183 },
      -1,
   } },

   /* replace722_0 -> 35 in the cache */
   /* replace722_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 35, 32 },
      -1,
   } },

   /* ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a') */
   /* search723_0_0 -> 35 in the cache */
   /* search723_0_1 -> 32 in the cache */
   /* search723_0 -> 2185 in the cache */
   /* search723_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2186 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2185, 2187 },
      -1,
   } },

   /* replace723_0 -> 2186 in the cache */
   /* replace723_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2186, 32 },
      -1,
   } },

   /* ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a') */
   /* search724_0_0 -> 2186 in the cache */
   /* search724_0_1 -> 32 in the cache */
   /* search724_0 -> 2189 in the cache */
   /* search724_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2190 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2189, 2191 },
      -1,
   } },

   /* replace724_0 -> 2190 in the cache */
   /* replace724_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2190, 32 },
      -1,
   } },

   /* ('ior', 'a', ('ieq', 'a', False)) => True */
   /* search725_0 -> 722 in the cache */
   /* search725_1_0 -> 722 in the cache */
   /* search725_1_1 -> 1039 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 722, 1039 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 722, 2194 },
      -1,
   } },

   /* replace725 -> 1192 in the cache */

   /* ('ior', 'a', ('inot', 'a')) => -1 */
   /* search726_0 -> 32 in the cache */
   /* search726_1_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 2196 },
      -1,
   } },

   /* replace726 -> 63 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b') */
   /* search727_0_0_0 -> 722 in the cache */
   /* search727_0_0 -> 1183 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1183 },
      -1,
   } },
   /* search727_1_0_0 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1090 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2199 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2198, 2200 },
      -1,
   } },

   /* replace727_0 -> 722 in the cache */
   /* replace727_1 -> 1090 in the cache */
   /* replace727 -> 1335 in the cache */

   /* ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b')) */
   /* search728_0_0 -> 722 in the cache */
   /* search728_0_1 -> 1090 in the cache */
   /* search728_0 -> 1335 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1335 },
      -1,
   } },

   /* replace728_0_0 -> 722 in the cache */
   /* replace728_0_1 -> 1090 in the cache */
   /* replace728_0 -> 1107 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1107 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0)) */
   /* search729_0_0_0_0_0 -> 32 in the cache */
   /* search729_0_0_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 32, 61 },
      -1,
   } },
   /* search729_0_0_0_1 -> 1090 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      2, 2,
      { 2204, 1090 },
      -1,
   } },
   /* search729_0_0_1 -> 449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2205, 449 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2206 },
      -1,
   } },
   /* search729_1_0 -> 32 in the cache */
   /* search729_1_1 -> 61 in the cache */
   /* search729_1 -> 1206 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2207, 1206 },
      -1,
   } },

   /* replace729_0_0_0 -> 1090 in the cache */
   /* replace729_0_0_1 -> 449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 1090, 449 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2209 },
      -1,
   } },
   /* replace729_1_0 -> 32 in the cache */
   /* replace729_1_1 -> 61 in the cache */
   /* replace729_1 -> 1206 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2210, 1206 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0)) */
   /* search730_0_0_0_0_0 -> 0 in the cache */
   /* search730_0_0_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      3, 1,
      { 0, 3 },
      -1,
   } },
   /* search730_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 2,
      { 2212, 86 },
      -1,
   } },
   /* search730_0_0_1 -> 449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2213, 449 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2214 },
      -1,
   } },
   /* search730_1_0 -> 0 in the cache */
   /* search730_1_1 -> 86 in the cache */
   /* search730_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2215, 90 },
      -1,
   } },

   /* replace730_0_0_0_0 -> 3 in the cache */
   /* replace730_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 3, 86 },
      -1,
   } },
   /* replace730_0_0_1 -> 449 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 2,
      { 2217, 449 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 2,
      { 2218 },
      -1,
   } },
   /* replace730_1_0 -> 0 in the cache */
   /* replace730_1_1 -> 86 in the cache */
   /* replace730_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2219, 90 },
      -1,
   } },

   /* ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b') */
   /* search731_0 -> 32 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search731_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 2221, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2222 },
      -1,
   } },

   /* replace731_0 -> 32 in the cache */
   /* replace731_1 -> 2221 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 2221 },
      -1,
   } },

   /* ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a') */
   /* search732_0_0 -> 0 in the cache */
   /* search732_0_1 -> 3 in the cache */
   /* search732_0 -> 1240 in the cache */
   /* search732_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1240, 0 },
      -1,
   } },

   /* replace732_0 -> 3 in the cache */
   /* replace732_1 -> 0 in the cache */
   /* replace732 -> 1040 in the cache */

   /* ('~fge', 'a', ('fmin', 'b', 'a')) => True */
   /* search733_0 -> 32 in the cache */
   /* search733_1_0 -> 2221 in the cache */
   /* search733_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 2221, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2226 },
      -1,
   } },

   /* replace733 -> 1192 in the cache */

   /* ('~fge', ('fmax', 'a', 'b'), 'a') => True */
   /* search734_0_0 -> 0 in the cache */
   /* search734_0_1 -> 3 in the cache */
   /* search734_0 -> 1238 in the cache */
   /* search734_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1238, 0 },
      -1,
   } },

   /* replace734 -> 1192 in the cache */

   /* ('flt', 'a', ('fmin', 'b', 'a')) => False */
   /* search735_0 -> 32 in the cache */
   /* search735_1_0 -> 2221 in the cache */
   /* search735_1_1 -> 32 in the cache */
   /* search735_1 -> 2226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2226 },
      -1,
   } },

   /* replace735 -> 1039 in the cache */

   /* ('flt', ('fmax', 'a', 'b'), 'a') => False */
   /* search736_0_0 -> 0 in the cache */
   /* search736_0_1 -> 3 in the cache */
   /* search736_0 -> 1238 in the cache */
   /* search736_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1238, 0 },
      -1,
   } },

   /* replace736 -> 1039 in the cache */

   /* ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b') */
   /* search737_0 -> 32 in the cache */
   /* search737_1_0 -> 2221 in the cache */
   /* search737_1_1 -> 32 in the cache */
   /* search737_1 -> 2222 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2222 },
      -1,
   } },

   /* replace737_0 -> 32 in the cache */
   /* replace737_1 -> 2221 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 2221 },
      -1,
   } },

   /* ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a') */
   /* search738_0_0 -> 0 in the cache */
   /* search738_0_1 -> 3 in the cache */
   /* search738_0 -> 1240 in the cache */
   /* search738_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1240, 0 },
      -1,
   } },

   /* replace738_0 -> 3 in the cache */
   /* replace738_1 -> 0 in the cache */
   /* replace738 -> 1052 in the cache */

   /* ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b') */
   /* search739_0 -> 32 in the cache */
   /* search739_1_0 -> 2221 in the cache */
   /* search739_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2221, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2234 },
      -1,
   } },

   /* replace739_0 -> 32 in the cache */
   /* replace739_1 -> 2221 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 2221 },
      -1,
   } },

   /* ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a') */
   /* search740_0_0 -> 0 in the cache */
   /* search740_0_1 -> 3 in the cache */
   /* search740_0 -> 1300 in the cache */
   /* search740_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1300, 0 },
      -1,
   } },

   /* replace740_0 -> 3 in the cache */
   /* replace740_1 -> 0 in the cache */
   /* replace740 -> 1045 in the cache */

   /* ('ige', 'a', ('imin', 'b', 'a')) => True */
   /* search741_0 -> 32 in the cache */
   /* search741_1_0 -> 2221 in the cache */
   /* search741_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2221, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2238 },
      -1,
   } },

   /* replace741 -> 1192 in the cache */

   /* ('ige', ('imax', 'a', 'b'), 'a') => True */
   /* search742_0_0 -> 0 in the cache */
   /* search742_0_1 -> 3 in the cache */
   /* search742_0 -> 1292 in the cache */
   /* search742_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1292, 0 },
      -1,
   } },

   /* replace742 -> 1192 in the cache */

   /* ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b') */
   /* search743_0 -> 32 in the cache */
   /* search743_1_0 -> 2221 in the cache */
   /* search743_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2221, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2241 },
      -1,
   } },

   /* replace743_0 -> 32 in the cache */
   /* replace743_1 -> 2221 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 2221 },
      -1,
   } },

   /* ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a') */
   /* search744_0_0 -> 0 in the cache */
   /* search744_0_1 -> 3 in the cache */
   /* search744_0 -> 1297 in the cache */
   /* search744_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1297, 0 },
      -1,
   } },

   /* replace744_0 -> 3 in the cache */
   /* replace744_1 -> 0 in the cache */
   /* replace744 -> 1047 in the cache */

   /* ('uge', 'a', ('umin', 'b', 'a')) => True */
   /* search745_0 -> 32 in the cache */
   /* search745_1_0 -> 2221 in the cache */
   /* search745_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2221, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2245 },
      -1,
   } },

   /* replace745 -> 1192 in the cache */

   /* ('uge', ('umax', 'a', 'b'), 'a') => True */
   /* search746_0_0 -> 0 in the cache */
   /* search746_0_1 -> 3 in the cache */
   /* search746_0 -> 1289 in the cache */
   /* search746_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1289, 0 },
      -1,
   } },

   /* replace746 -> 1192 in the cache */

   /* ('ilt', 'a', ('imin', 'b', 'a')) => False */
   /* search747_0 -> 32 in the cache */
   /* search747_1_0 -> 2221 in the cache */
   /* search747_1_1 -> 32 in the cache */
   /* search747_1 -> 2238 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2238 },
      -1,
   } },

   /* replace747 -> 1039 in the cache */

   /* ('ilt', ('imax', 'a', 'b'), 'a') => False */
   /* search748_0_0 -> 0 in the cache */
   /* search748_0_1 -> 3 in the cache */
   /* search748_0 -> 1292 in the cache */
   /* search748_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1292, 0 },
      -1,
   } },

   /* replace748 -> 1039 in the cache */

   /* ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b') */
   /* search749_0 -> 32 in the cache */
   /* search749_1_0 -> 2221 in the cache */
   /* search749_1_1 -> 32 in the cache */
   /* search749_1 -> 2234 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2234 },
      -1,
   } },

   /* replace749_0 -> 32 in the cache */
   /* replace749_1 -> 2221 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 2221 },
      -1,
   } },

   /* ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a') */
   /* search750_0_0 -> 0 in the cache */
   /* search750_0_1 -> 3 in the cache */
   /* search750_0 -> 1300 in the cache */
   /* search750_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1300, 0 },
      -1,
   } },

   /* replace750_0 -> 3 in the cache */
   /* replace750_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('umin', 'b', 'a')) => False */
   /* search751_0 -> 32 in the cache */
   /* search751_1_0 -> 2221 in the cache */
   /* search751_1_1 -> 32 in the cache */
   /* search751_1 -> 2245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2245 },
      -1,
   } },

   /* replace751 -> 1039 in the cache */

   /* ('ult', ('umax', 'a', 'b'), 'a') => False */
   /* search752_0_0 -> 0 in the cache */
   /* search752_0_1 -> 3 in the cache */
   /* search752_0 -> 1289 in the cache */
   /* search752_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1289, 0 },
      -1,
   } },

   /* replace752 -> 1039 in the cache */

   /* ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b') */
   /* search753_0 -> 32 in the cache */
   /* search753_1_0 -> 2221 in the cache */
   /* search753_1_1 -> 32 in the cache */
   /* search753_1 -> 2241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2241 },
      -1,
   } },

   /* replace753_0 -> 32 in the cache */
   /* replace753_1 -> 2221 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 2221 },
      -1,
   } },

   /* ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a') */
   /* search754_0_0 -> 0 in the cache */
   /* search754_0_1 -> 3 in the cache */
   /* search754_0 -> 1297 in the cache */
   /* search754_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1297, 0 },
      -1,
   } },

   /* replace754_0 -> 3 in the cache */
   /* replace754_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('iand', 'b', 'a')) => False */
   /* search755_0 -> 32 in the cache */
   /* search755_1_0 -> 2221 in the cache */
   /* search755_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2221, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2260 },
      -1,
   } },

   /* replace755 -> 1039 in the cache */

   /* ('ult', ('ior', 'a', 'b'), 'a') => False */
   /* search756_0_0 -> 0 in the cache */
   /* search756_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 3 },
      -1,
   } },
   /* search756_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2262, 0 },
      -1,
   } },

   /* replace756 -> 1039 in the cache */

   /* ('uge', 'a', ('iand', 'b', 'a')) => True */
   /* search757_0 -> 32 in the cache */
   /* search757_1_0 -> 2221 in the cache */
   /* search757_1_1 -> 32 in the cache */
   /* search757_1 -> 2260 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2260 },
      -1,
   } },

   /* replace757 -> 1192 in the cache */

   /* ('uge', ('ior', 'a', 'b'), 'a') => True */
   /* search758_0_0 -> 0 in the cache */
   /* search758_0_1 -> 3 in the cache */
   /* search758_0 -> 2262 in the cache */
   /* search758_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2262, 0 },
      -1,
   } },

   /* replace758 -> 1192 in the cache */

   /* ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search759_0 -> 271 in the cache */
   /* search759_1_0 -> 272 in the cache */
   /* search759_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 272, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 271, 2266 },
      -1,
   } },

   /* replace759_0_0 -> 128 in the cache */
   /* replace759_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace759_1_0 -> 128 in the cache */
   /* replace759_1_1 -> 131 in the cache */
   /* replace759_1 -> 1601 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2268, 1601 },
      -1,
   } },

   /* ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search760_0_0 -> 271 in the cache */
   /* search760_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 271, 129 },
      -1,
   } },
   /* search760_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2270, 776 },
      -1,
   } },

   /* replace760_0_0 -> 128 in the cache */
   /* replace760_0_1 -> 131 in the cache */
   /* replace760_0 -> 1601 in the cache */
   /* replace760_1_0 -> 129 in the cache */
   /* replace760_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1601, 2272 },
      -1,
   } },

   /* ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search761_0 -> 271 in the cache */
   /* search761_1_0 -> 272 in the cache */
   /* search761_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 272, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 271, 2274 },
      -1,
   } },

   /* replace761_0_0 -> 128 in the cache */
   /* replace761_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace761_1_0 -> 128 in the cache */
   /* replace761_1_1 -> 131 in the cache */
   /* replace761_1 -> 1611 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2276, 1611 },
      -1,
   } },

   /* ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search762_0_0 -> 271 in the cache */
   /* search762_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 271, 129 },
      -1,
   } },
   /* search762_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2278, 776 },
      -1,
   } },

   /* replace762_0_0 -> 128 in the cache */
   /* replace762_0_1 -> 131 in the cache */
   /* replace762_0 -> 1611 in the cache */
   /* replace762_1_0 -> 129 in the cache */
   /* replace762_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1611, 2280 },
      -1,
   } },

   /* ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search763_0 -> 271 in the cache */
   /* search763_1_0 -> 272 in the cache */
   /* search763_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 272, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 271, 2282 },
      -1,
   } },

   /* replace763_0_0 -> 128 in the cache */
   /* replace763_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace763_1_0 -> 128 in the cache */
   /* replace763_1_1 -> 131 in the cache */
   /* replace763_1 -> 1621 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2284, 1621 },
      -1,
   } },

   /* ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search764_0_0 -> 271 in the cache */
   /* search764_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 271, 129 },
      -1,
   } },
   /* search764_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2286, 776 },
      -1,
   } },

   /* replace764_0_0 -> 128 in the cache */
   /* replace764_0_1 -> 131 in the cache */
   /* replace764_0 -> 1621 in the cache */
   /* replace764_1_0 -> 129 in the cache */
   /* replace764_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1621, 2288 },
      -1,
   } },

   /* ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search765_0 -> 271 in the cache */
   /* search765_1_0 -> 272 in the cache */
   /* search765_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 272, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 271, 2290 },
      -1,
   } },

   /* replace765_0_0 -> 128 in the cache */
   /* replace765_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 128, 129 },
      -1,
   } },
   /* replace765_1_0 -> 128 in the cache */
   /* replace765_1_1 -> 131 in the cache */
   /* replace765_1 -> 1631 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2292, 1631 },
      -1,
   } },

   /* ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search766_0_0 -> 271 in the cache */
   /* search766_0_1 -> 129 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 271, 129 },
      -1,
   } },
   /* search766_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2294, 776 },
      -1,
   } },

   /* replace766_0_0 -> 128 in the cache */
   /* replace766_0_1 -> 131 in the cache */
   /* replace766_0 -> 1631 in the cache */
   /* replace766_1_0 -> 129 in the cache */
   /* replace766_1_1 -> 131 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 129, 131 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1631, 2296 },
      -1,
   } },

   /* ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search767_0 -> 271 in the cache */
   /* search767_1_0 -> 272 in the cache */
   /* search767_1_1 -> 131 in the cache */
   /* search767_1 -> 2274 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 271, 2274 },
      -1,
   } },

   /* replace767_0_0 -> 128 in the cache */
   /* replace767_0_1 -> 129 in the cache */
   /* replace767_0 -> 2268 in the cache */
   /* replace767_1_0 -> 128 in the cache */
   /* replace767_1_1 -> 131 in the cache */
   /* replace767_1 -> 1601 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2268, 1601 },
      -1,
   } },

   /* ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search768_0_0 -> 271 in the cache */
   /* search768_0_1 -> 129 in the cache */
   /* search768_0 -> 2278 in the cache */
   /* search768_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2278, 776 },
      -1,
   } },

   /* replace768_0_0 -> 128 in the cache */
   /* replace768_0_1 -> 131 in the cache */
   /* replace768_0 -> 1601 in the cache */
   /* replace768_1_0 -> 129 in the cache */
   /* replace768_1_1 -> 131 in the cache */
   /* replace768_1 -> 2272 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1601, 2272 },
      -1,
   } },

   /* ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search769_0 -> 271 in the cache */
   /* search769_1_0 -> 272 in the cache */
   /* search769_1_1 -> 131 in the cache */
   /* search769_1 -> 2266 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 271, 2266 },
      -1,
   } },

   /* replace769_0_0 -> 128 in the cache */
   /* replace769_0_1 -> 129 in the cache */
   /* replace769_0 -> 2276 in the cache */
   /* replace769_1_0 -> 128 in the cache */
   /* replace769_1_1 -> 131 in the cache */
   /* replace769_1 -> 1611 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2276, 1611 },
      -1,
   } },

   /* ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search770_0_0 -> 271 in the cache */
   /* search770_0_1 -> 129 in the cache */
   /* search770_0 -> 2270 in the cache */
   /* search770_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2270, 776 },
      -1,
   } },

   /* replace770_0_0 -> 128 in the cache */
   /* replace770_0_1 -> 131 in the cache */
   /* replace770_0 -> 1611 in the cache */
   /* replace770_1_0 -> 129 in the cache */
   /* replace770_1_1 -> 131 in the cache */
   /* replace770_1 -> 2280 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1611, 2280 },
      -1,
   } },

   /* ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search771_0 -> 271 in the cache */
   /* search771_1_0 -> 272 in the cache */
   /* search771_1_1 -> 131 in the cache */
   /* search771_1 -> 2290 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 271, 2290 },
      -1,
   } },

   /* replace771_0_0 -> 128 in the cache */
   /* replace771_0_1 -> 129 in the cache */
   /* replace771_0 -> 2284 in the cache */
   /* replace771_1_0 -> 128 in the cache */
   /* replace771_1_1 -> 131 in the cache */
   /* replace771_1 -> 1621 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2284, 1621 },
      -1,
   } },

   /* ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search772_0_0 -> 271 in the cache */
   /* search772_0_1 -> 129 in the cache */
   /* search772_0 -> 2294 in the cache */
   /* search772_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2294, 776 },
      -1,
   } },

   /* replace772_0_0 -> 128 in the cache */
   /* replace772_0_1 -> 131 in the cache */
   /* replace772_0 -> 1621 in the cache */
   /* replace772_1_0 -> 129 in the cache */
   /* replace772_1_1 -> 131 in the cache */
   /* replace772_1 -> 2288 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1621, 2288 },
      -1,
   } },

   /* ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search773_0 -> 271 in the cache */
   /* search773_1_0 -> 272 in the cache */
   /* search773_1_1 -> 131 in the cache */
   /* search773_1 -> 2282 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 271, 2282 },
      -1,
   } },

   /* replace773_0_0 -> 128 in the cache */
   /* replace773_0_1 -> 129 in the cache */
   /* replace773_0 -> 2292 in the cache */
   /* replace773_1_0 -> 128 in the cache */
   /* replace773_1_1 -> 131 in the cache */
   /* replace773_1 -> 1631 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2292, 1631 },
      -1,
   } },

   /* ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search774_0_0 -> 271 in the cache */
   /* search774_0_1 -> 129 in the cache */
   /* search774_0 -> 2286 in the cache */
   /* search774_1 -> 776 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2286, 776 },
      -1,
   } },

   /* replace774_0_0 -> 128 in the cache */
   /* replace774_0_1 -> 131 in the cache */
   /* replace774_0 -> 1631 in the cache */
   /* replace774_1_0 -> 129 in the cache */
   /* replace774_1_1 -> 131 in the cache */
   /* replace774_1 -> 2296 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1631, 2296 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b')) */
   /* search775_0_0 -> 32 in the cache */
   /* search775_0_1 -> 61 in the cache */
   /* search775_0 -> 1206 in the cache */
   /* search775_1_0_0 -> 32 in the cache */
   /* search775_1_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2314 },
      -1,
   } },
   /* search775_2_0 -> 32 in the cache */
   /* search775_2_1 -> 36 in the cache */
   /* search775_2 -> 2314 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1206, 2315, 2314 },
      -1,
   } },

   /* replace775_0_0 -> 32 in the cache */
   /* replace775_0_1 -> 36 in the cache */
   /* replace775_0 -> 2314 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2314 },
      -1,
   } },

   /* ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b') */
   /* search776_0_0_0 -> 32 in the cache */
   /* search776_0_0 -> 106 in the cache */
   /* search776_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 106, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2318 },
      -1,
   } },

   /* replace776_0_0 -> 32 in the cache */
   /* replace776_0 -> 106 in the cache */
   /* replace776_1 -> 36 in the cache */
   /* replace776 -> 2318 in the cache */

   /* ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b') */
   /* search777_0_0 -> 0 in the cache */
   /* search777_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_slt,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2320 },
      -1,
   } },

   /* replace777_0 -> 0 in the cache */
   /* replace777_1 -> 3 in the cache */
   /* replace777 -> 2320 in the cache */

   /* ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b') */
   /* search778_0_0 -> 0 in the cache */
   /* search778_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sge,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2322 },
      -1,
   } },

   /* replace778_0 -> 0 in the cache */
   /* replace778_1 -> 3 in the cache */
   /* replace778 -> 2322 in the cache */

   /* ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b') */
   /* search779_0_0 -> 0 in the cache */
   /* search779_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2324 },
      -1,
   } },

   /* replace779_0 -> 0 in the cache */
   /* replace779_1 -> 3 in the cache */
   /* replace779 -> 2324 in the cache */

   /* ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b') */
   /* search780_0_0 -> 0 in the cache */
   /* search780_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2326 },
      -1,
   } },

   /* replace780_0 -> 0 in the cache */
   /* replace780_1 -> 3 in the cache */
   /* replace780 -> 2326 in the cache */

   /* ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b')) */
   /* search781_0 -> 0 in the cache */
   /* search781_1 -> 3 in the cache */
   /* search781 -> 2320 in the cache */

   /* replace781_0_0 -> 0 in the cache */
   /* replace781_0_1 -> 3 in the cache */
   /* replace781_0 -> 1011 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1011 },
      -1,
   } },

   /* ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b')) */
   /* search782_0 -> 0 in the cache */
   /* search782_1 -> 3 in the cache */
   /* search782 -> 2322 in the cache */

   /* replace782_0_0 -> 0 in the cache */
   /* replace782_0_1 -> 3 in the cache */
   /* replace782_0 -> 1008 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1008 },
      -1,
   } },

   /* ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b')) */
   /* search783_0 -> 0 in the cache */
   /* search783_1 -> 3 in the cache */
   /* search783 -> 2324 in the cache */

   /* replace783_0_0 -> 0 in the cache */
   /* replace783_0_1 -> 3 in the cache */
   /* replace783_0 -> 1017 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1017 },
      -1,
   } },

   /* ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b')) */
   /* search784_0 -> 0 in the cache */
   /* search784_1 -> 3 in the cache */
   /* search784 -> 2326 in the cache */

   /* replace784_0_0 -> 0 in the cache */
   /* replace784_0_1 -> 3 in the cache */
   /* replace784_0 -> 1014 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1014 },
      -1,
   } },

   /* ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search785_0_0 -> 0 in the cache */
   /* search785_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search785_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2332, 259 },
      -1,
   } },

   /* replace785_0 -> 0 in the cache */
   /* replace785_1 -> 3 in the cache */
   /* replace785 -> 2324 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search786_0_0 -> 0 in the cache */
   /* search786_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search786_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2334, 259 },
      -1,
   } },

   /* replace786_0 -> 0 in the cache */
   /* replace786_1 -> 3 in the cache */
   /* replace786 -> 2326 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search787_0_0 -> 0 in the cache */
   /* search787_0_1 -> 3 in the cache */
   /* search787_0 -> 2320 in the cache */
   /* search787_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2320, 259 },
      -1,
   } },

   /* replace787_0 -> 0 in the cache */
   /* replace787_1 -> 3 in the cache */
   /* replace787 -> 2320 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search788_0_0 -> 0 in the cache */
   /* search788_0_1 -> 3 in the cache */
   /* search788_0 -> 2322 in the cache */
   /* search788_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2322, 259 },
      -1,
   } },

   /* replace788_0 -> 0 in the cache */
   /* replace788_1 -> 3 in the cache */
   /* replace788 -> 2322 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search789_0_0 -> 0 in the cache */
   /* search789_0_1 -> 3 in the cache */
   /* search789_0 -> 2332 in the cache */
   /* search789_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2332, 245 },
      -1,
   } },

   /* replace789_0 -> 0 in the cache */
   /* replace789_1 -> 3 in the cache */
   /* replace789 -> 2324 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search790_0_0 -> 0 in the cache */
   /* search790_0_1 -> 3 in the cache */
   /* search790_0 -> 2334 in the cache */
   /* search790_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2334, 245 },
      -1,
   } },

   /* replace790_0 -> 0 in the cache */
   /* replace790_1 -> 3 in the cache */
   /* replace790 -> 2326 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search791_0_0 -> 0 in the cache */
   /* search791_0_1 -> 3 in the cache */
   /* search791_0 -> 2320 in the cache */
   /* search791_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2320, 245 },
      -1,
   } },

   /* replace791_0 -> 0 in the cache */
   /* replace791_1 -> 3 in the cache */
   /* replace791 -> 2320 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search792_0_0 -> 0 in the cache */
   /* search792_0_1 -> 3 in the cache */
   /* search792_0 -> 2322 in the cache */
   /* search792_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2322, 245 },
      -1,
   } },

   /* replace792_0 -> 0 in the cache */
   /* replace792_1 -> 3 in the cache */
   /* replace792 -> 2322 in the cache */

   /* ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search793_0_0 -> 0 in the cache */
   /* search793_0_1 -> 3 in the cache */
   /* search793_0 -> 2332 in the cache */
   /* search793_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2332, 245 },
      -1,
   } },

   /* replace793_0 -> 0 in the cache */
   /* replace793_1 -> 3 in the cache */
   /* replace793 -> 2326 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search794_0_0 -> 0 in the cache */
   /* search794_0_1 -> 3 in the cache */
   /* search794_0 -> 2334 in the cache */
   /* search794_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2334, 245 },
      -1,
   } },

   /* replace794_0 -> 0 in the cache */
   /* replace794_1 -> 3 in the cache */
   /* replace794 -> 2324 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search795_0_0 -> 0 in the cache */
   /* search795_0_1 -> 3 in the cache */
   /* search795_0 -> 2320 in the cache */
   /* search795_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2320, 245 },
      -1,
   } },

   /* replace795_0 -> 0 in the cache */
   /* replace795_1 -> 3 in the cache */
   /* replace795 -> 2322 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search796_0_0 -> 0 in the cache */
   /* search796_0_1 -> 3 in the cache */
   /* search796_0 -> 2322 in the cache */
   /* search796_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2322, 245 },
      -1,
   } },

   /* replace796_0 -> 0 in the cache */
   /* replace796_1 -> 3 in the cache */
   /* replace796 -> 2320 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search797_0_0 -> 0 in the cache */
   /* search797_0_1 -> 3 in the cache */
   /* search797_0 -> 2332 in the cache */
   /* search797_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2332, 259 },
      -1,
   } },

   /* replace797_0 -> 0 in the cache */
   /* replace797_1 -> 3 in the cache */
   /* replace797 -> 2326 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search798_0_0 -> 0 in the cache */
   /* search798_0_1 -> 3 in the cache */
   /* search798_0 -> 2334 in the cache */
   /* search798_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2334, 259 },
      -1,
   } },

   /* replace798_0 -> 0 in the cache */
   /* replace798_1 -> 3 in the cache */
   /* replace798 -> 2324 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search799_0_0 -> 0 in the cache */
   /* search799_0_1 -> 3 in the cache */
   /* search799_0 -> 2320 in the cache */
   /* search799_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2320, 259 },
      -1,
   } },

   /* replace799_0 -> 0 in the cache */
   /* replace799_1 -> 3 in the cache */
   /* replace799 -> 2322 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search800_0_0 -> 0 in the cache */
   /* search800_0_1 -> 3 in the cache */
   /* search800_0 -> 2322 in the cache */
   /* search800_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2322, 259 },
      -1,
   } },

   /* replace800_0 -> 0 in the cache */
   /* replace800_1 -> 3 in the cache */
   /* replace800 -> 2320 in the cache */

   /* ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y')) */
   /* search801_0 -> 16 in the cache */
   /* search801_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2351, 2352 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 2354, 2355 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      -1, 2,
      { 2353, 2356 },
      -1,
   } },

   /* ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0) */
   /* search802_0 -> 16 in the cache */
   /* search802_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace802_0_0 -> 16 in the cache */
   /* replace802_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace802_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2359, 117 },
      -1,
   } },

   /* ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0) */
   /* search803_0 -> 16 in the cache */
   /* search803_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace803_0_0 -> 16 in the cache */
   /* replace803_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace803_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2362, 117 },
      -1,
   } },

   /* ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y')) */
   /* search804_0 -> 16 in the cache */
   /* search804_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace804_0_0 -> 2351 in the cache */
   /* replace804_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2351, 2352 },
      -1,
   } },
   /* replace804_1_0 -> 2354 in the cache */
   /* replace804_1_1 -> 2355 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 2354, 2355 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      -1, 2,
      { 2365, 2366 },
      -1,
   } },

   /* ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search805_0 -> 16 in the cache */
   /* search805_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace805_0_0_0 -> 16 in the cache */
   /* replace805_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 16, 36 },
      -1,
   } },
   /* replace805_0_1_0 -> 16 in the cache */
   /* replace805_0_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot3,
      -1, 2,
      { 2369, 2370 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2371 },
      -1,
   } },

   /* ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search806_0 -> 16 in the cache */
   /* search806_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace806_0_0_0 -> 16 in the cache */
   /* replace806_0_0_1 -> 36 in the cache */
   /* replace806_0_0 -> 2369 in the cache */
   /* replace806_0_1_0 -> 16 in the cache */
   /* replace806_0_1_1 -> 36 in the cache */
   /* replace806_0_1 -> 2370 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot4,
      -1, 2,
      { 2369, 2370 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2374 },
      -1,
   } },

   /* ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')) */
   /* search807_0 -> 0 in the cache */
   /* search807_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace807_0_0 -> 731 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace807_1_0 -> 732 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2378, 2380 },
      -1,
   } },

   /* ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z')) */
   /* search808_0 -> 0 in the cache */
   /* search808_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace808_0_0_0 -> 731 in the cache */
   /* replace808_0_0_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace808_0_1_0 -> 732 in the cache */
   /* replace808_0_1_1 -> 2379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2383, 2384 },
      -1,
   } },
   /* replace808_1_0 -> 733 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 733, 2386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2385, 2387 },
      -1,
   } },

   /* ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w'))) */
   /* search809_0 -> 0 in the cache */
   /* search809_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace809_0_0_0 -> 731 in the cache */
   /* replace809_0_0_1 -> 2377 in the cache */
   /* replace809_0_0 -> 2378 in the cache */
   /* replace809_0_1_0 -> 732 in the cache */
   /* replace809_0_1_1 -> 2379 in the cache */
   /* replace809_0_1 -> 2380 in the cache */
   /* replace809_0 -> 2381 in the cache */
   /* replace809_1_0_0 -> 733 in the cache */
   /* replace809_1_0_1 -> 2386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 733, 2386 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 2391, 2392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2390, 2393 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2381, 2394 },
      -1,
   } },

   /* ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')) */
   /* search810_0 -> 0 in the cache */
   /* search810_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace810_0_0 -> 731 in the cache */
   /* replace810_0_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace810_1_0 -> 732 in the cache */
   /* replace810_1_1 -> 2379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2397, 2398 },
      -1,
   } },

   /* ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z')) */
   /* search811_0 -> 0 in the cache */
   /* search811_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace811_0_0_0 -> 731 in the cache */
   /* replace811_0_0_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace811_0_1_0 -> 732 in the cache */
   /* replace811_0_1_1 -> 2379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2401, 2402 },
      -1,
   } },
   /* replace811_1_0 -> 733 in the cache */
   /* replace811_1_1 -> 2386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 733, 2386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2403, 2404 },
      -1,
   } },

   /* ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w'))) */
   /* search812_0 -> 0 in the cache */
   /* search812_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace812_0_0_0 -> 731 in the cache */
   /* replace812_0_0_1 -> 2377 in the cache */
   /* replace812_0_0 -> 2397 in the cache */
   /* replace812_0_1_0 -> 732 in the cache */
   /* replace812_0_1_1 -> 2379 in the cache */
   /* replace812_0_1 -> 2398 in the cache */
   /* replace812_0 -> 2399 in the cache */
   /* replace812_1_0_0 -> 733 in the cache */
   /* replace812_1_0_1 -> 2386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 733, 2386 },
      -1,
   } },
   /* replace812_1_1_0 -> 2391 in the cache */
   /* replace812_1_1_1 -> 2392 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 2391, 2392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2407, 2408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2399, 2409 },
      -1,
   } },

   /* ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')) */
   /* search813_0 -> 0 in the cache */
   /* search813_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace813_0_0 -> 731 in the cache */
   /* replace813_0_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace813_1_0 -> 732 in the cache */
   /* replace813_1_1 -> 2379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2412, 2413 },
      -1,
   } },

   /* ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z')) */
   /* search814_0 -> 0 in the cache */
   /* search814_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace814_0_0_0 -> 731 in the cache */
   /* replace814_0_0_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace814_0_1_0 -> 732 in the cache */
   /* replace814_0_1_1 -> 2379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2416, 2417 },
      -1,
   } },
   /* replace814_1_0 -> 733 in the cache */
   /* replace814_1_1 -> 2386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 733, 2386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2418, 2419 },
      -1,
   } },

   /* ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w'))) */
   /* search815_0 -> 0 in the cache */
   /* search815_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace815_0_0_0 -> 731 in the cache */
   /* replace815_0_0_1 -> 2377 in the cache */
   /* replace815_0_0 -> 2412 in the cache */
   /* replace815_0_1_0 -> 732 in the cache */
   /* replace815_0_1_1 -> 2379 in the cache */
   /* replace815_0_1 -> 2413 in the cache */
   /* replace815_0 -> 2414 in the cache */
   /* replace815_1_0_0 -> 733 in the cache */
   /* replace815_1_0_1 -> 2386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 733, 2386 },
      -1,
   } },
   /* replace815_1_1_0 -> 2391 in the cache */
   /* replace815_1_1_1 -> 2392 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 2391, 2392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2422, 2423 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2414, 2424 },
      -1,
   } },

   /* ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')) */
   /* search816_0 -> 0 in the cache */
   /* search816_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace816_0_0 -> 731 in the cache */
   /* replace816_0_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace816_1_0 -> 732 in the cache */
   /* replace816_1_1 -> 2379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2427, 2428 },
      -1,
   } },

   /* ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z')) */
   /* search817_0 -> 0 in the cache */
   /* search817_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace817_0_0_0 -> 731 in the cache */
   /* replace817_0_0_1 -> 2377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 731, 2377 },
      -1,
   } },
   /* replace817_0_1_0 -> 732 in the cache */
   /* replace817_0_1_1 -> 2379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 732, 2379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2431, 2432 },
      -1,
   } },
   /* replace817_1_0 -> 733 in the cache */
   /* replace817_1_1 -> 2386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 733, 2386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2433, 2434 },
      -1,
   } },

   /* ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w'))) */
   /* search818_0 -> 0 in the cache */
   /* search818_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace818_0_0_0 -> 731 in the cache */
   /* replace818_0_0_1 -> 2377 in the cache */
   /* replace818_0_0 -> 2427 in the cache */
   /* replace818_0_1_0 -> 732 in the cache */
   /* replace818_0_1_1 -> 2379 in the cache */
   /* replace818_0_1 -> 2428 in the cache */
   /* replace818_0 -> 2429 in the cache */
   /* replace818_1_0_0 -> 733 in the cache */
   /* replace818_1_0_1 -> 2386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 733, 2386 },
      -1,
   } },
   /* replace818_1_1_0 -> 2391 in the cache */
   /* replace818_1_1_1 -> 2392 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 2391, 2392 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2437, 2438 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2429, 2439 },
      -1,
   } },

   /* ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b') */
   /* search819_0_0 -> 0 in the cache */
   /* search819_0_1 -> 3 in the cache */
   /* search819_0 -> 2332 in the cache */
   /* search819_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2332, 259 },
      -1,
   } },

   /* replace819_0 -> 0 in the cache */
   /* replace819_1 -> 3 in the cache */
   /* replace819 -> 1017 in the cache */

   /* ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b') */
   /* search820_0_0 -> 0 in the cache */
   /* search820_0_1 -> 3 in the cache */
   /* search820_0 -> 2334 in the cache */
   /* search820_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2334, 259 },
      -1,
   } },

   /* replace820_0 -> 0 in the cache */
   /* replace820_1 -> 3 in the cache */
   /* replace820 -> 1014 in the cache */

   /* ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b') */
   /* search821_0_0 -> 0 in the cache */
   /* search821_0_1 -> 3 in the cache */
   /* search821_0 -> 2320 in the cache */
   /* search821_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2320, 259 },
      -1,
   } },

   /* replace821_0 -> 0 in the cache */
   /* replace821_1 -> 3 in the cache */
   /* replace821 -> 1011 in the cache */

   /* ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b') */
   /* search822_0_0 -> 0 in the cache */
   /* search822_0_1 -> 3 in the cache */
   /* search822_0 -> 2322 in the cache */
   /* search822_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2322, 259 },
      -1,
   } },

   /* replace822_0 -> 0 in the cache */
   /* replace822_1 -> 3 in the cache */
   /* replace822 -> 1008 in the cache */

   /* ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b') */
   /* search823_0_0 -> 0 in the cache */
   /* search823_0_1 -> 3 in the cache */
   /* search823_0 -> 2332 in the cache */
   /* search823_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2332, 245 },
      -1,
   } },

   /* replace823_0 -> 0 in the cache */
   /* replace823_1 -> 3 in the cache */
   /* replace823 -> 1017 in the cache */

   /* ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b') */
   /* search824_0_0 -> 0 in the cache */
   /* search824_0_1 -> 3 in the cache */
   /* search824_0 -> 2334 in the cache */
   /* search824_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2334, 245 },
      -1,
   } },

   /* replace824_0 -> 0 in the cache */
   /* replace824_1 -> 3 in the cache */
   /* replace824 -> 1014 in the cache */

   /* ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b') */
   /* search825_0_0 -> 0 in the cache */
   /* search825_0_1 -> 3 in the cache */
   /* search825_0 -> 2320 in the cache */
   /* search825_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2320, 245 },
      -1,
   } },

   /* replace825_0 -> 0 in the cache */
   /* replace825_1 -> 3 in the cache */
   /* replace825 -> 1011 in the cache */

   /* ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b') */
   /* search826_0_0 -> 0 in the cache */
   /* search826_0_1 -> 3 in the cache */
   /* search826_0 -> 2322 in the cache */
   /* search826_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2322, 245 },
      -1,
   } },

   /* replace826_0 -> 0 in the cache */
   /* replace826_1 -> 3 in the cache */
   /* replace826 -> 1008 in the cache */

   /* ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b') */
   /* search827_0_0 -> 0 in the cache */
   /* search827_0_1 -> 3 in the cache */
   /* search827_0 -> 2332 in the cache */
   /* search827_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2332, 245 },
      -1,
   } },

   /* replace827_0 -> 0 in the cache */
   /* replace827_1 -> 3 in the cache */
   /* replace827 -> 1014 in the cache */

   /* ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b') */
   /* search828_0_0 -> 0 in the cache */
   /* search828_0_1 -> 3 in the cache */
   /* search828_0 -> 2334 in the cache */
   /* search828_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 2334, 245 },
      -1,
   } },

   /* replace828_0 -> 0 in the cache */
   /* replace828_1 -> 3 in the cache */
   /* replace828 -> 1017 in the cache */

   /* ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b') */
   /* search829_0_0 -> 0 in the cache */
   /* search829_0_1 -> 3 in the cache */
   /* search829_0 -> 2320 in the cache */
   /* search829_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2320, 245 },
      -1,
   } },

   /* replace829_0 -> 0 in the cache */
   /* replace829_1 -> 3 in the cache */
   /* replace829 -> 1008 in the cache */

   /* ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b') */
   /* search830_0_0 -> 0 in the cache */
   /* search830_0_1 -> 3 in the cache */
   /* search830_0 -> 2322 in the cache */
   /* search830_1 -> 245 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 2322, 245 },
      -1,
   } },

   /* replace830_0 -> 0 in the cache */
   /* replace830_1 -> 3 in the cache */
   /* replace830 -> 1011 in the cache */

   /* ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b') */
   /* search831_0_0 -> 0 in the cache */
   /* search831_0_1 -> 3 in the cache */
   /* search831_0 -> 2332 in the cache */
   /* search831_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2332, 259 },
      -1,
   } },

   /* replace831_0 -> 0 in the cache */
   /* replace831_1 -> 3 in the cache */
   /* replace831 -> 1014 in the cache */

   /* ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b') */
   /* search832_0_0 -> 0 in the cache */
   /* search832_0_1 -> 3 in the cache */
   /* search832_0 -> 2334 in the cache */
   /* search832_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 2334, 259 },
      -1,
   } },

   /* replace832_0 -> 0 in the cache */
   /* replace832_1 -> 3 in the cache */
   /* replace832 -> 1017 in the cache */

   /* ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b') */
   /* search833_0_0 -> 0 in the cache */
   /* search833_0_1 -> 3 in the cache */
   /* search833_0 -> 2320 in the cache */
   /* search833_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2320, 259 },
      -1,
   } },

   /* replace833_0 -> 0 in the cache */
   /* replace833_1 -> 3 in the cache */
   /* replace833 -> 1008 in the cache */

   /* ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b') */
   /* search834_0_0 -> 0 in the cache */
   /* search834_0_1 -> 3 in the cache */
   /* search834_0 -> 2322 in the cache */
   /* search834_1 -> 259 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 2322, 259 },
      -1,
   } },

   /* replace834_0 -> 0 in the cache */
   /* replace834_1 -> 3 in the cache */
   /* replace834 -> 1011 in the cache */

   /* ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0) */
   /* search835_0_0 -> 32 in the cache */
   /* search835_0 -> 98 in the cache */
   /* search835_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace835_0 -> 32 in the cache */
   /* replace835_1 -> 113 in the cache */
   /* replace835 -> 1210 in the cache */

   /* ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0) */
   /* search836_0_0 -> 32 in the cache */
   /* search836_0 -> 98 in the cache */
   /* search836_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace836_0 -> 32 in the cache */
   /* replace836_1 -> 113 in the cache */
   /* replace836 -> 1214 in the cache */

   /* ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search837_0_0 -> 722 in the cache */
   /* search837_0 -> 1183 in the cache */
   /* search837_1_0 -> 1090 in the cache */
   /* search837_1 -> 2199 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 1183, 2199 },
      -1,
   } },

   /* replace837_0_0 -> 722 in the cache */
   /* replace837_0_1 -> 1090 in the cache */
   /* replace837_0 -> 1102 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1102 },
      -1,
   } },

   /* ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search838_0_0 -> 722 in the cache */
   /* search838_0 -> 1183 in the cache */
   /* search838_1_0 -> 1090 in the cache */
   /* search838_1 -> 2199 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1183, 2199 },
      -1,
   } },

   /* replace838_0_0 -> 722 in the cache */
   /* replace838_0_1 -> 1090 in the cache */
   /* replace838_0 -> 1102 in the cache */
   /* replace838 -> 2460 in the cache */

   /* ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b')) */
   /* search839_0_0 -> 722 in the cache */
   /* search839_0 -> 1183 in the cache */
   /* search839_1_0 -> 1090 in the cache */
   /* search839_1 -> 2199 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1183, 2199 },
      -1,
   } },

   /* replace839_0_0 -> 722 in the cache */
   /* replace839_0_1 -> 1090 in the cache */
   /* replace839_0 -> 1094 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1094 },
      -1,
   } },

   /* ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search840_0_0 -> 722 in the cache */
   /* search840_0 -> 1085 in the cache */
   /* search840_1_0 -> 1090 in the cache */
   /* search840_1 -> 1091 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1085, 1091 },
      -1,
   } },

   /* replace840_0_0 -> 722 in the cache */
   /* replace840_0_1 -> 1090 in the cache */
   /* replace840_0 -> 1102 in the cache */
   /* replace840 -> 1223 in the cache */

   /* ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b')) */
   /* search841_0_0_0 -> 722 in the cache */
   /* search841_0_0 -> 1085 in the cache */
   /* search841_0_1_0 -> 1090 in the cache */
   /* search841_0_1 -> 1091 in the cache */
   /* search841_0 -> 1121 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1121 },
      -1,
   } },

   /* replace841_0_0 -> 722 in the cache */
   /* replace841_0_1 -> 1090 in the cache */
   /* replace841_0 -> 1094 in the cache */
   /* replace841 -> 1220 in the cache */

   /* ('iand', 'a@bool16', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search842_1 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2466, 466 },
      -1,
   } },

   /* replace842_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iand', 'a@bool32', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search843_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2469, 232 },
      -1,
   } },

   /* replace843_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('flt', ('fneg', ('b2f', 'a@1')), 0) => a */
   /* search844_0_0_0 -> 722 in the cache */
   /* search844_0_0 -> 1085 in the cache */
   /* search844_0 -> 1088 in the cache */
   /* search844_1 -> 1184 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1088, 1184 },
      -1,
   } },

   /* replace844 -> 722 in the cache */

   /* ('ilt', 'a', 'a') => False */
   /* search845_0 -> 32 in the cache */
   /* search845_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace845 -> 1039 in the cache */

   /* ('ige', 'a', 'a') => True */
   /* search846_0 -> 32 in the cache */
   /* search846_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace846 -> 1192 in the cache */

   /* ('ieq', 'a', 'a') => True */
   /* search847_0 -> 32 in the cache */
   /* search847_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace847 -> 1192 in the cache */

   /* ('ine', 'a', 'a') => False */
   /* search848_0 -> 32 in the cache */
   /* search848_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace848 -> 1039 in the cache */

   /* ('ult', 'a', 'a') => False */
   /* search849_0 -> 32 in the cache */
   /* search849_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace849 -> 1039 in the cache */

   /* ('uge', 'a', 'a') => True */
   /* search850_0 -> 32 in the cache */
   /* search850_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace850 -> 1192 in the cache */

   /* ('flt', 'a', 'a') => False */
   /* search851_0 -> 32 in the cache */
   /* search851_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace851 -> 1039 in the cache */

   /* ('fge', 'a(is_a_number)', 'a') => True */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search852_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 2480, 32 },
      -1,
   } },

   /* replace852 -> 1192 in the cache */

   /* ('feq', 'a(is_a_number)', 'a') => True */
   /* search853_0 -> 2480 in the cache */
   /* search853_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 2480, 32 },
      -1,
   } },

   /* replace853 -> 1192 in the cache */

   /* ('fneu', 'a(is_a_number)', 'a') => False */
   /* search854_0 -> 2480 in the cache */
   /* search854_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 2480, 32 },
      -1,
   } },

   /* replace854 -> 1039 in the cache */

   /* ('iand', 'a', 'a') => a */
   /* search855_0 -> 32 in the cache */
   /* search855_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace855 -> 32 in the cache */

   /* ('iand', 'a', -1) => a */
   /* search856_0 -> 32 in the cache */
   /* search856_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace856 -> 32 in the cache */

   /* ('iand', 'a', 0) => 0 */
   /* search857_0 -> 32 in the cache */
   /* search857_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace857 -> 61 in the cache */

   /* ('ior', 'a', 'a') => a */
   /* search858_0 -> 32 in the cache */
   /* search858_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace858 -> 32 in the cache */

   /* ('ior', 'a', 0) => a */
   /* search859_0 -> 32 in the cache */
   /* search859_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace859 -> 32 in the cache */

   /* ('ior', 'a', True) => True */
   /* search860_0 -> 722 in the cache */
   /* search860_1 -> 1192 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 722, 1192 },
      -1,
   } },

   /* replace860 -> 1192 in the cache */

   /* ('ixor', 'a', 'a') => 0 */
   /* search861_0 -> 32 in the cache */
   /* search861_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace861 -> 61 in the cache */

   /* ('ixor', 'a', 0) => a */
   /* search862_0 -> 32 in the cache */
   /* search862_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace862 -> 32 in the cache */

   /* ('ixor', 'a', ('ixor', 'a', 'b')) => b */
   /* search863_0 -> 0 in the cache */
   /* search863_1_0 -> 0 in the cache */
   /* search863_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 2,
      { 0, 2492 },
      -1,
   } },

   /* replace863 -> 3 in the cache */

   /* ('ixor', 'a', -1) => ('inot', 'a') */
   /* search864_0 -> 32 in the cache */
   /* search864_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace864_0 -> 32 in the cache */
   /* replace864 -> 2196 in the cache */

   /* ('inot', ('inot', 'a')) => a */
   /* search865_0_0 -> 32 in the cache */
   /* search865_0 -> 2196 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 2196 },
      -1,
   } },

   /* replace865 -> 32 in the cache */

   /* ('ior', ('iand', 'a', 'b'), 'b') => b */
   /* search866_0_0 -> 0 in the cache */
   /* search866_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search866_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2496, 3 },
      -1,
   } },

   /* replace866 -> 3 in the cache */

   /* ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b') */
   /* search867_0_0 -> 0 in the cache */
   /* search867_0_1 -> 3 in the cache */
   /* search867_0 -> 84 in the cache */
   /* search867_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace867_0 -> 0 in the cache */
   /* replace867_1 -> 3 in the cache */
   /* replace867 -> 2262 in the cache */

   /* ('iand', ('ior', 'a', 'b'), 'b') => b */
   /* search868_0_0 -> 0 in the cache */
   /* search868_0_1 -> 3 in the cache */
   /* search868_0 -> 84 in the cache */
   /* search868_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace868 -> 3 in the cache */

   /* ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b') */
   /* search869_0_0 -> 0 in the cache */
   /* search869_0_1 -> 3 in the cache */
   /* search869_0 -> 2496 in the cache */
   /* search869_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2496, 3 },
      -1,
   } },

   /* replace869_0 -> 0 in the cache */
   /* replace869_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b')) */
   /* search870_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search870_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2502, 2503 },
      -1,
   } },

   /* replace870_0_0 -> 0 in the cache */
   /* replace870_0_1 -> 3 in the cache */
   /* replace870_0 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2262 },
      -1,
   } },

   /* ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b')) */
   /* search871_0_0 -> 0 in the cache */
   /* search871_0 -> 2502 in the cache */
   /* search871_1_0 -> 3 in the cache */
   /* search871_1 -> 2503 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2502, 2503 },
      -1,
   } },

   /* replace871_0_0 -> 0 in the cache */
   /* replace871_0_1 -> 3 in the cache */
   /* replace871_0 -> 2501 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2501 },
      -1,
   } },

   /* ('ishl', 0, 'a') => 0 */
   /* search872_0 -> 1184 in the cache */
   /* search872_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1184, 16 },
      -1,
   } },

   /* replace872 -> 1184 in the cache */

   /* ('ishl', 'a', 0) => a */
   /* search873_0 -> 32 in the cache */
   /* search873_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 124 },
      -1,
   } },

   /* replace873 -> 32 in the cache */

   /* ('ishr', 0, 'a') => 0 */
   /* search874_0 -> 1184 in the cache */
   /* search874_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1184, 16 },
      -1,
   } },

   /* replace874 -> 1184 in the cache */

   /* ('ishr', -1, 'a') => -1 */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   /* search875_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 2511, 16 },
      -1,
   } },

   /* replace875 -> 2511 in the cache */

   /* ('ishr', 'a', 0) => a */
   /* search876_0 -> 32 in the cache */
   /* search876_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 124 },
      -1,
   } },

   /* replace876 -> 32 in the cache */

   /* ('ushr', 0, 'a') => 0 */
   /* search877_0 -> 1184 in the cache */
   /* search877_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1184, 16 },
      -1,
   } },

   /* replace877 -> 1184 in the cache */

   /* ('ushr', 'a', 0) => a */
   /* search878_0 -> 32 in the cache */
   /* search878_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 32, 124 },
      -1,
   } },

   /* replace878 -> 32 in the cache */

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search879_0_0 -> 11 in the cache */
   /* search879_0_1 -> 36 in the cache */
   /* search879_0 -> 2112 in the cache */
   /* search879_1_0 -> 11 in the cache */
   /* search879_1_1_0 -> 815 in the cache */
   /* search879_1_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 815, 2516 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2517 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2112, 2518 },
      -1,
   } },

   /* replace879_0 -> 11 in the cache */
   /* replace879_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b') */
   /* search880_0_0 -> 11 in the cache */
   /* search880_0_1 -> 36 in the cache */
   /* search880_0 -> 2112 in the cache */
   /* search880_1_0 -> 11 in the cache */
   /* search880_1_1_0 -> 815 in the cache */
   /* search880_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 815, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 2521 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2112, 2522 },
      -1,
   } },

   /* replace880_0 -> 11 in the cache */
   /* replace880_1 -> 36 in the cache */
   /* replace880 -> 2520 in the cache */

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search881_0_0 -> 16 in the cache */
   /* search881_0_1 -> 36 in the cache */
   /* search881_0 -> 908 in the cache */
   /* search881_1_0 -> 16 in the cache */
   /* search881_1_1_0 -> 836 in the cache */
   /* search881_1_1_1_0 -> 36 in the cache */
   /* search881_1_1_1 -> 2516 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 836, 2516 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2524 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 908, 2525 },
      -1,
   } },

   /* replace881_0 -> 16 in the cache */
   /* replace881_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b') */
   /* search882_0_0 -> 16 in the cache */
   /* search882_0_1 -> 36 in the cache */
   /* search882_0 -> 908 in the cache */
   /* search882_1_0 -> 16 in the cache */
   /* search882_1_1_0 -> 836 in the cache */
   /* search882_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 836, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 2528 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 908, 2529 },
      -1,
   } },

   /* replace882_0 -> 16 in the cache */
   /* replace882_1 -> 36 in the cache */
   /* replace882 -> 2527 in the cache */

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search883_0_0 -> 11 in the cache */
   /* search883_0_1 -> 36 in the cache */
   /* search883_0 -> 2116 in the cache */
   /* search883_1_0 -> 11 in the cache */
   /* search883_1_1_0 -> 815 in the cache */
   /* search883_1_1_1_0 -> 36 in the cache */
   /* search883_1_1_1 -> 2516 in the cache */
   /* search883_1_1 -> 2517 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2517 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2116, 2531 },
      -1,
   } },

   /* replace883_0 -> 11 in the cache */
   /* replace883_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b') */
   /* search884_0_0 -> 11 in the cache */
   /* search884_0_1 -> 36 in the cache */
   /* search884_0 -> 2116 in the cache */
   /* search884_1_0 -> 11 in the cache */
   /* search884_1_1_0 -> 815 in the cache */
   /* search884_1_1_1 -> 36 in the cache */
   /* search884_1_1 -> 2521 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 2521 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2116, 2534 },
      -1,
   } },

   /* replace884_0 -> 11 in the cache */
   /* replace884_1 -> 36 in the cache */
   /* replace884 -> 2533 in the cache */

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search885_0_0 -> 16 in the cache */
   /* search885_0_1 -> 36 in the cache */
   /* search885_0 -> 2145 in the cache */
   /* search885_1_0 -> 16 in the cache */
   /* search885_1_1_0 -> 836 in the cache */
   /* search885_1_1_1_0 -> 36 in the cache */
   /* search885_1_1_1 -> 2516 in the cache */
   /* search885_1_1 -> 2524 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2524 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2145, 2536 },
      -1,
   } },

   /* replace885_0 -> 16 in the cache */
   /* replace885_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b') */
   /* search886_0_0 -> 16 in the cache */
   /* search886_0_1 -> 36 in the cache */
   /* search886_0 -> 2145 in the cache */
   /* search886_1_0 -> 16 in the cache */
   /* search886_1_1_0 -> 836 in the cache */
   /* search886_1_1_1 -> 36 in the cache */
   /* search886_1_1 -> 2528 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 2528 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2145, 2539 },
      -1,
   } },

   /* replace886_0 -> 16 in the cache */
   /* replace886_1 -> 36 in the cache */
   /* replace886 -> 2538 in the cache */

   /* ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b'))) */
   /* search887_0 -> 11 in the cache */
   /* search887_1 -> 36 in the cache */
   /* search887 -> 2520 in the cache */

   /* replace887_0_0 -> 11 in the cache */
   /* replace887_0_1 -> 36 in the cache */
   /* replace887_0 -> 2112 in the cache */
   /* replace887_1_0 -> 11 in the cache */
   /* replace887_1_1_0 -> 815 in the cache */
   /* replace887_1_1_1 -> 36 in the cache */
   /* replace887_1_1 -> 2521 in the cache */
   /* replace887_1 -> 2522 in the cache */
   /* replace887 -> 2523 in the cache */

   /* ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b'))) */
   /* search888_0 -> 16 in the cache */
   /* search888_1 -> 36 in the cache */
   /* search888 -> 2527 in the cache */

   /* replace888_0_0 -> 16 in the cache */
   /* replace888_0_1 -> 36 in the cache */
   /* replace888_0 -> 908 in the cache */
   /* replace888_1_0 -> 16 in the cache */
   /* replace888_1_1_0 -> 836 in the cache */
   /* replace888_1_1_1 -> 36 in the cache */
   /* replace888_1_1 -> 2528 in the cache */
   /* replace888_1 -> 2529 in the cache */
   /* replace888 -> 2530 in the cache */

   /* ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b'))) */
   /* search889_0 -> 11 in the cache */
   /* search889_1 -> 36 in the cache */
   /* search889 -> 2533 in the cache */

   /* replace889_0_0 -> 11 in the cache */
   /* replace889_0_1 -> 36 in the cache */
   /* replace889_0 -> 2116 in the cache */
   /* replace889_1_0 -> 11 in the cache */
   /* replace889_1_1_0 -> 815 in the cache */
   /* replace889_1_1_1 -> 36 in the cache */
   /* replace889_1_1 -> 2521 in the cache */
   /* replace889_1 -> 2534 in the cache */
   /* replace889 -> 2535 in the cache */

   /* ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b'))) */
   /* search890_0 -> 16 in the cache */
   /* search890_1 -> 36 in the cache */
   /* search890 -> 2538 in the cache */

   /* replace890_0_0 -> 16 in the cache */
   /* replace890_0_1 -> 36 in the cache */
   /* replace890_0 -> 2145 in the cache */
   /* replace890_1_0 -> 16 in the cache */
   /* replace890_1_1_0 -> 836 in the cache */
   /* replace890_1_1_1 -> 36 in the cache */
   /* replace890_1_1 -> 2528 in the cache */
   /* replace890_1 -> 2539 in the cache */
   /* replace890 -> 2540 in the cache */

   /* ('~fexp2', ('flog2', 'a')) => a */
   /* search891_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 2541 },
      -1,
   } },

   /* replace891 -> 32 in the cache */

   /* ('~flog2', ('fexp2', 'a')) => a */
   /* search892_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2543 },
      -1,
   } },

   /* replace892 -> 32 in the cache */

   /* ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b')) */
   /* search893_0 -> 0 in the cache */
   /* search893_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* replace893_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace893_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2546, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2547 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b') */
   /* search894_0_0_0 -> 0 in the cache */
   /* search894_0_0 -> 2546 in the cache */
   /* search894_0_1 -> 3 in the cache */
   /* search894_0 -> 2547 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2547 },
      -1,
   } },

   /* replace894_0 -> 0 in the cache */
   /* replace894_1 -> 3 in the cache */
   /* replace894 -> 2545 in the cache */

   /* ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd')) */
   /* search895_0_0_0_0 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 151 },
      -1,
   } },
   /* search895_0_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 2550, 152 },
      -1,
   } },
   /* search895_0_1_0_0 -> 154 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 154 },
      -1,
   } },
   /* search895_0_1_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 2552, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 2551, 2553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 3,
      { 2554 },
      -1,
   } },

   /* replace895_0_0 -> 151 in the cache */
   /* replace895_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 151, 152 },
      -1,
   } },
   /* replace895_1_0 -> 154 in the cache */
   /* replace895_1_1 -> 155 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 154, 155 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2556, 2557 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a') */
   /* search896_0_0_0 -> 32 in the cache */
   /* search896_0_0 -> 2541 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2541, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2560 },
      -1,
   } },

   /* replace896_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a') */
   /* search897_0_0_0 -> 32 in the cache */
   /* search897_0_0 -> 2541 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4000000000000000 /* 2.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2541, 2563 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2564 },
      -1,
   } },

   /* replace897_0 -> 32 in the cache */
   /* replace897_1 -> 32 in the cache */
   /* replace897 -> 240 in the cache */

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')) */
   /* search898_0_0_0 -> 32 in the cache */
   /* search898_0_0 -> 2541 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4010000000000000 /* 4.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2541, 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2567 },
      -1,
   } },

   /* replace898_0_0 -> 32 in the cache */
   /* replace898_0_1 -> 32 in the cache */
   /* replace898_0 -> 240 in the cache */
   /* replace898_1_0 -> 32 in the cache */
   /* replace898_1_1 -> 32 in the cache */
   /* replace898_1 -> 240 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 240, 240 },
      -1,
   } },

   /* ('~fpow', 'a', 1.0) => a */
   /* search899_0 -> 32 in the cache */
   /* search899_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 230 },
      -1,
   } },

   /* replace899 -> 32 in the cache */

   /* ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a') */
   /* search900_0 -> 32 in the cache */
   /* search900_1 -> 2563 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2563 },
      -1,
   } },

   /* replace900_0 -> 32 in the cache */
   /* replace900_1 -> 32 in the cache */
   /* replace900 -> 240 in the cache */

   /* ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')) */
   /* search901_0 -> 32 in the cache */
   /* search901_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2566 },
      -1,
   } },

   /* replace901_0_0 -> 32 in the cache */
   /* replace901_0_1 -> 32 in the cache */
   /* replace901_0 -> 240 in the cache */
   /* replace901_1_0 -> 32 in the cache */
   /* replace901_1_1 -> 32 in the cache */
   /* replace901_1 -> 240 in the cache */
   /* replace901 -> 2569 in the cache */

   /* ('~fpow', 2.0, 'a') => ('fexp2', 'a') */
   /* search902_0 -> 2563 in the cache */
   /* search902_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2563, 32 },
      -1,
   } },

   /* replace902_0 -> 32 in the cache */
   /* replace902 -> 2543 in the cache */

   /* ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a */
   /* search903_0_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x400199999999999a /* 2.2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2574 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fdd1743e963dc48 /* 0.454545 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2575, 2576 },
      -1,
   } },

   /* replace903 -> 32 in the cache */

   /* ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a') */
   /* search904_0_0_0 -> 32 in the cache */
   /* search904_0_0_1 -> 2574 in the cache */
   /* search904_0_0 -> 2575 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2575 },
      -1,
   } },
   /* search904_1 -> 2576 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2578, 2576 },
      -1,
   } },

   /* replace904_0 -> 32 in the cache */
   /* replace904 -> 103 in the cache */

   /* ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a')) */
   /* search905_0_0 -> 32 in the cache */
   /* search905_0 -> 2543 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 2543 },
      -1,
   } },

   /* replace905_0_0 -> 2559 in the cache */
   /* replace905_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2559, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2581 },
      -1,
   } },

   /* ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a')) */
   /* search906_0_0 -> 32 in the cache */
   /* search906_0 -> 2543 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2543 },
      -1,
   } },

   /* replace906_0_0 -> 32 in the cache */
   /* replace906_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 98 },
      -1,
   } },

   /* ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a')) */
   /* search907_0_0 -> 32 in the cache */
   /* search907_0 -> 2543 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frsq,
      -1, 0,
      { 2543 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbfe0000000000000 /* -0.5 */ },
   } },
   /* replace907_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2586, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2587 },
      -1,
   } },

   /* ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a')) */
   /* search908_0_0 -> 32 in the cache */
   /* search908_0 -> 2562 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2562 },
      -1,
   } },

   /* replace908_0 -> 2559 in the cache */
   /* replace908_1_0 -> 32 in the cache */
   /* replace908_1 -> 2541 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2559, 2541 },
      -1,
   } },

   /* ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a')) */
   /* search909_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2591 },
      -1,
   } },

   /* replace909_0_0 -> 32 in the cache */
   /* replace909_0 -> 2541 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2541 },
      -1,
   } },

   /* ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a')) */
   /* search910_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frsq,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2594 },
      -1,
   } },

   /* replace910_0 -> 2586 in the cache */
   /* replace910_1_0 -> 32 in the cache */
   /* replace910_1 -> 2541 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2586, 2541 },
      -1,
   } },

   /* ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a')) */
   /* search911_0_0 -> 0 in the cache */
   /* search911_0_1 -> 3 in the cache */
   /* search911_0 -> 2545 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2545 },
      -1,
   } },

   /* replace911_0 -> 3 in the cache */
   /* replace911_1_0 -> 0 in the cache */
   /* replace911_1 -> 2546 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 3, 2546 },
      -1,
   } },

   /* ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b')) */
   /* search912_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 0 },
      0,
   } },
   /* search912_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2599, 2600 },
      -1,
   } },

   /* replace912_0_0 -> 0 in the cache */
   /* replace912_0_1 -> 3 in the cache */
   /* replace912_0 -> 261 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 261 },
      -1,
   } },

   /* ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0)) */
   /* search913_0_0 -> 32 in the cache */
   /* search913_0_1 -> 113 in the cache */
   /* search913_0 -> 674 in the cache */
   /* search913_1 -> 113 in the cache */
   /* search913_2_0 -> 32 in the cache */
   /* search913_2 -> 2562 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 674, 113, 2562 },
      -1,
   } },

   /* replace913_0_0 -> 32 in the cache */
   /* replace913_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 113 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 1,
      { 2604 },
      -1,
   } },

   /* ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a') */
   /* search914_0_0 -> 32 in the cache */
   /* search914_0 -> 2562 in the cache */
   /* search914_1_0 -> 32 in the cache */
   /* search914_1 -> 2562 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 2562, 2562 },
      -1,
   } },

   /* replace914_0 -> 32 in the cache */
   /* replace914 -> 103 in the cache */

   /* ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a') */
   /* search915_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 16 },
      -1,
   } },
   /* search915_1_0 -> 16 in the cache */
   /* search915_1 -> 2607 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 2607, 2607 },
      -1,
   } },

   /* replace915_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('~fdiv', 1.0, 'a') => ('frcp', 'a') */
   /* search916_0 -> 230 in the cache */
   /* search916_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fdiv,
      -1, 0,
      { 230, 32 },
      -1,
   } },

   /* replace916_0 -> 32 in the cache */
   /* replace916 -> 2591 in the cache */

   /* ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b')) */
   /* search917_0 -> 0 in the cache */
   /* search917_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdiv,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* replace917_0 -> 0 in the cache */
   /* replace917_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 2612 },
      -1,
   } },

   /* ('~frcp', ('frcp', 'a')) => a */
   /* search918_0_0 -> 32 in the cache */
   /* search918_0 -> 2591 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2591 },
      -1,
   } },

   /* replace918 -> 32 in the cache */

   /* ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a') */
   /* search919_0_0 -> 32 in the cache */
   /* search919_0 -> 2562 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2562 },
      -1,
   } },

   /* replace919_0 -> 32 in the cache */
   /* replace919 -> 2594 in the cache */

   /* ('fsqrt', 'a') => ('frcp', ('frsq', 'a')) */
   /* search920_0 -> 32 in the cache */
   /* search920 -> 2562 in the cache */

   /* replace920_0_0 -> 32 in the cache */
   /* replace920_0 -> 2594 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2594 },
      -1,
   } },

   /* ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a') */
   /* search921_0_0 -> 32 in the cache */
   /* search921_0 -> 2594 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2594 },
      -1,
   } },

   /* replace921_0 -> 32 in the cache */
   /* replace921 -> 2562 in the cache */

   /* ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)) */
   /* search922_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsin,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace922_0_0_0_0_0_0 -> 2563 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fc45f306dc9c883 /* 0.15915494309189535 */ },
   } },
   /* replace922_0_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      5, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_0_0_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      4, 2,
      { 2620, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2621 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 3,
      { 2563, 2622 },
      -1,
   } },
   /* replace922_0_0_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2623, 230 },
      -1,
   } },
   /* replace922_0_0_0_1_0_0_0 -> 2563 in the cache */
   /* replace922_0_0_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      9, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_0_0_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      8, 2,
      { 2625, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2626 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      7, 3,
      { 2563, 2627 },
      -1,
   } },
   /* replace922_0_0_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2628, 230 },
      -1,
   } },
   /* replace922_0_0_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace922_0_0_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      12, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_0_0_1_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      11, 2,
      { 2630, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2631 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      10, 3,
      { 2563, 2632 },
      -1,
   } },
   /* replace922_0_0_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2633, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2634 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      6, 7,
      { 2629, 2635 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2624, 2636 },
      -1,
   } },
   /* replace922_0_0_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 11,
      { 2637, 2566 },
      -1,
   } },
   /* replace922_0_1_0_0_0_0_0 -> 2563 in the cache */
   /* replace922_0_1_0_0_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_1_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      16, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_1_0_0_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      15, 2,
      { 2639, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2640 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      14, 3,
      { 2563, 2641 },
      -1,
   } },
   /* replace922_0_1_0_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2642, 230 },
      -1,
   } },
   /* replace922_0_1_0_0_1_0_0_0 -> 2563 in the cache */
   /* replace922_0_1_0_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_1_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      20, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_1_0_0_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      19, 2,
      { 2644, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2645 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      18, 3,
      { 2563, 2646 },
      -1,
   } },
   /* replace922_0_1_0_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2647, 230 },
      -1,
   } },
   /* replace922_0_1_0_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace922_0_1_0_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_1_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      23, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_1_0_0_1_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      22, 2,
      { 2649, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2650 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      21, 3,
      { 2563, 2651 },
      -1,
   } },
   /* replace922_0_1_0_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2652, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2653 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      17, 7,
      { 2648, 2654 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2643, 2655 },
      -1,
   } },
   /* replace922_0_1_0_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      13, 11,
      { 2656, 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 11,
      { 2657 },
      -1,
   } },
   /* replace922_0_2_0_0_0_0_0 -> 2563 in the cache */
   /* replace922_0_2_0_0_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_2_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      27, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_2_0_0_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      26, 2,
      { 2659, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2660 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      25, 3,
      { 2563, 2661 },
      -1,
   } },
   /* replace922_0_2_0_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2662, 230 },
      -1,
   } },
   /* replace922_0_2_0_0_1_0_0_0 -> 2563 in the cache */
   /* replace922_0_2_0_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_2_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      31, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_2_0_0_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      30, 2,
      { 2664, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      29, 3,
      { 2563, 2666 },
      -1,
   } },
   /* replace922_0_2_0_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2667, 230 },
      -1,
   } },
   /* replace922_0_2_0_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace922_0_2_0_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_0_2_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      34, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_0_2_0_0_1_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      33, 2,
      { 2669, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2670 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      32, 3,
      { 2563, 2671 },
      -1,
   } },
   /* replace922_0_2_0_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2672, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2673 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      28, 7,
      { 2668, 2674 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2663, 2675 },
      -1,
   } },
   /* replace922_0_2_0_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      24, 11,
      { 2676, 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 11,
      { 2677 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 34,
      { 2638, 2658, 2678 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fcccccccccccccd /* 0.225 */ },
   } },
   /* replace922_2_0_0_0_0 -> 2563 in the cache */
   /* replace922_2_0_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_2_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      38, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_2_0_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      37, 2,
      { 2681, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2682 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      36, 3,
      { 2563, 2683 },
      -1,
   } },
   /* replace922_2_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2684, 230 },
      -1,
   } },
   /* replace922_2_0_1_0_0_0 -> 2563 in the cache */
   /* replace922_2_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_2_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      42, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_2_0_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      41, 2,
      { 2686, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2687 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      40, 3,
      { 2563, 2688 },
      -1,
   } },
   /* replace922_2_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2689, 230 },
      -1,
   } },
   /* replace922_2_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace922_2_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace922_2_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      45, 1,
      { 2619, 32 },
      -1,
   } },
   /* replace922_2_0_1_1_0_0_1_0_1 -> 2559 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      44, 2,
      { 2691, 2559 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2692 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      43, 3,
      { 2563, 2693 },
      -1,
   } },
   /* replace922_2_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2694, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2695 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      39, 7,
      { 2690, 2696 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2685, 2697 },
      -1,
   } },
   /* replace922_2_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      35, 11,
      { 2698, 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 46,
      { 2679, 2680, 2699 },
      -1,
   } },

   /* ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)) */
   /* search923_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fcos,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace923_0_0_0_0_0_0 -> 2563 in the cache */
   /* replace923_0_0_0_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_0_0_0_0_1_0_0 -> 2620 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe8000000000000 /* 0.75 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      4, 2,
      { 2620, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 3,
      { 2563, 2704 },
      -1,
   } },
   /* replace923_0_0_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2705, 230 },
      -1,
   } },
   /* replace923_0_0_0_1_0_0_0 -> 2563 in the cache */
   /* replace923_0_0_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_0_0_1_0_0_1_0_0 -> 2625 in the cache */
   /* replace923_0_0_0_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      8, 2,
      { 2625, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2707 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      7, 3,
      { 2563, 2708 },
      -1,
   } },
   /* replace923_0_0_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2709, 230 },
      -1,
   } },
   /* replace923_0_0_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace923_0_0_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_0_0_1_1_0_0_1_0_0 -> 2630 in the cache */
   /* replace923_0_0_0_1_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      11, 2,
      { 2630, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2711 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      10, 3,
      { 2563, 2712 },
      -1,
   } },
   /* replace923_0_0_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2713, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2714 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      6, 7,
      { 2710, 2715 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2706, 2716 },
      -1,
   } },
   /* replace923_0_0_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 11,
      { 2717, 2566 },
      -1,
   } },
   /* replace923_0_1_0_0_0_0_0 -> 2563 in the cache */
   /* replace923_0_1_0_0_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_1_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_1_0_0_0_0_1_0_0 -> 2639 in the cache */
   /* replace923_0_1_0_0_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      15, 2,
      { 2639, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      14, 3,
      { 2563, 2720 },
      -1,
   } },
   /* replace923_0_1_0_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2721, 230 },
      -1,
   } },
   /* replace923_0_1_0_0_1_0_0_0 -> 2563 in the cache */
   /* replace923_0_1_0_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_1_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_1_0_0_1_0_0_1_0_0 -> 2644 in the cache */
   /* replace923_0_1_0_0_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      19, 2,
      { 2644, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2723 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      18, 3,
      { 2563, 2724 },
      -1,
   } },
   /* replace923_0_1_0_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2725, 230 },
      -1,
   } },
   /* replace923_0_1_0_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace923_0_1_0_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_1_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_1_0_0_1_1_0_0_1_0_0 -> 2649 in the cache */
   /* replace923_0_1_0_0_1_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      22, 2,
      { 2649, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2727 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      21, 3,
      { 2563, 2728 },
      -1,
   } },
   /* replace923_0_1_0_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2729, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2730 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      17, 7,
      { 2726, 2731 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2722, 2732 },
      -1,
   } },
   /* replace923_0_1_0_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      13, 11,
      { 2733, 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 11,
      { 2734 },
      -1,
   } },
   /* replace923_0_2_0_0_0_0_0 -> 2563 in the cache */
   /* replace923_0_2_0_0_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_2_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_2_0_0_0_0_1_0_0 -> 2659 in the cache */
   /* replace923_0_2_0_0_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      26, 2,
      { 2659, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2736 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      25, 3,
      { 2563, 2737 },
      -1,
   } },
   /* replace923_0_2_0_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2738, 230 },
      -1,
   } },
   /* replace923_0_2_0_0_1_0_0_0 -> 2563 in the cache */
   /* replace923_0_2_0_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_2_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_2_0_0_1_0_0_1_0_0 -> 2664 in the cache */
   /* replace923_0_2_0_0_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      30, 2,
      { 2664, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2740 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      29, 3,
      { 2563, 2741 },
      -1,
   } },
   /* replace923_0_2_0_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2742, 230 },
      -1,
   } },
   /* replace923_0_2_0_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace923_0_2_0_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_0_2_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_0_2_0_0_1_1_0_0_1_0_0 -> 2669 in the cache */
   /* replace923_0_2_0_0_1_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      33, 2,
      { 2669, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2744 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      32, 3,
      { 2563, 2745 },
      -1,
   } },
   /* replace923_0_2_0_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2746, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2747 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      28, 7,
      { 2743, 2748 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2739, 2749 },
      -1,
   } },
   /* replace923_0_2_0_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      24, 11,
      { 2750, 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 11,
      { 2751 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 34,
      { 2718, 2735, 2752 },
      -1,
   } },
   /* replace923_1 -> 2680 in the cache */
   /* replace923_2_0_0_0_0 -> 2563 in the cache */
   /* replace923_2_0_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_2_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_2_0_0_0_1_0_0 -> 2681 in the cache */
   /* replace923_2_0_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      37, 2,
      { 2681, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2754 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      36, 3,
      { 2563, 2755 },
      -1,
   } },
   /* replace923_2_0_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2756, 230 },
      -1,
   } },
   /* replace923_2_0_1_0_0_0 -> 2563 in the cache */
   /* replace923_2_0_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_2_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_2_0_1_0_0_1_0_0 -> 2686 in the cache */
   /* replace923_2_0_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      41, 2,
      { 2686, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2758 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      40, 3,
      { 2563, 2759 },
      -1,
   } },
   /* replace923_2_0_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2760, 230 },
      -1,
   } },
   /* replace923_2_0_1_1_0_0_0 -> 2563 in the cache */
   /* replace923_2_0_1_1_0_0_1_0_0_0 -> 2619 in the cache */
   /* replace923_2_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace923_2_0_1_1_0_0_1_0_0 -> 2691 in the cache */
   /* replace923_2_0_1_1_0_0_1_0_1 -> 2702 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      44, 2,
      { 2691, 2702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2762 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      43, 3,
      { 2563, 2763 },
      -1,
   } },
   /* replace923_2_0_1_1_0_1 -> 230 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2764, 230 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2765 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      39, 7,
      { 2761, 2766 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2757, 2767 },
      -1,
   } },
   /* replace923_2_1 -> 2566 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      35, 11,
      { 2768, 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 46,
      { 2753, 2680, 2769 },
      -1,
   } },

   /* ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0) */
   /* search924_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2b16,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace924_0 -> 32 in the cache */
   /* replace924_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ine16,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0) */
   /* search925_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2b32,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace925_0 -> 32 in the cache */
   /* replace925_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ine32,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0) */
   /* search926_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_i2b1,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace926_0 -> 32 in the cache */
   /* replace926_1 -> 61 in the cache */
   /* replace926 -> 1188 in the cache */

   /* ('ieq', 'a', True) => a */
   /* search927_0 -> 722 in the cache */
   /* search927_1 -> 1192 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 722, 1192 },
      -1,
   } },

   /* replace927 -> 722 in the cache */

   /* ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a') */
   /* search928_0 -> 722 in the cache */
   /* search928_1 -> 1192 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 722, 1192 },
      3,
   } },

   /* replace928_0 -> 722 in the cache */
   /* replace928 -> 1087 in the cache */

   /* ('ine', 'a', False) => a */
   /* search929_0 -> 722 in the cache */
   /* search929_1 -> 1039 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 722, 1039 },
      -1,
   } },

   /* replace929 -> 722 in the cache */

   /* ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a') */
   /* search930_0 -> 722 in the cache */
   /* search930_1 -> 1039 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 722, 1039 },
      3,
   } },

   /* replace930_0 -> 722 in the cache */
   /* replace930 -> 1087 in the cache */

   /* ('bcsel', 'a', True, False) => a */
   /* search931_0 -> 722 in the cache */
   /* search931_1 -> 1192 in the cache */
   /* search931_2 -> 1039 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1192, 1039 },
      -1,
   } },

   /* replace931 -> 722 in the cache */

   /* ('bcsel', 'a', False, True) => ('inot', 'a') */
   /* search932_0 -> 722 in the cache */
   /* search932_1 -> 1039 in the cache */
   /* search932_2 -> 1192 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1039, 1192 },
      -1,
   } },

   /* replace932_0 -> 722 in the cache */
   /* replace932 -> 1087 in the cache */

   /* ('bcsel', True, 'b', 'c') => b */
   /* search933_0 -> 1192 in the cache */
   /* search933_1 -> 1073 in the cache */
   /* search933_2 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1192, 1073, 669 },
      -1,
   } },

   /* replace933 -> 1073 in the cache */

   /* ('bcsel', False, 'b', 'c') => c */
   /* search934_0 -> 1039 in the cache */
   /* search934_1 -> 1073 in the cache */
   /* search934_2 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1039, 1073, 669 },
      -1,
   } },

   /* replace934 -> 669 in the cache */

   /* ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search935_0 -> 722 in the cache */
   /* search935_1 -> 466 in the cache */
   /* search935_2 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 466, 115 },
      -1,
   } },

   /* replace935_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 722 },
      -1,
   } },

   /* ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search936_0 -> 722 in the cache */
   /* search936_1 -> 115 in the cache */
   /* search936_2 -> 466 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 115, 466 },
      -1,
   } },

   /* replace936_0_0 -> 722 in the cache */
   /* replace936_0 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1087 },
      -1,
   } },

   /* ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search937_0 -> 722 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 2788, 2789 },
      -1,
   } },

   /* replace937_0_0 -> 722 in the cache */
   /* replace937_0 -> 2785 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2785 },
      -1,
   } },

   /* ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search938_0 -> 722 in the cache */
   /* search938_1 -> 2789 in the cache */
   /* search938_2 -> 2788 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 2789, 2788 },
      -1,
   } },

   /* replace938_0_0_0 -> 722 in the cache */
   /* replace938_0_0 -> 1087 in the cache */
   /* replace938_0 -> 2787 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2787 },
      -1,
   } },

   /* ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search939_0 -> 722 in the cache */
   /* search939_1 -> 232 in the cache */
   /* search939_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 232, 117 },
      -1,
   } },

   /* replace939_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 722 },
      -1,
   } },

   /* ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search940_0 -> 722 in the cache */
   /* search940_1 -> 117 in the cache */
   /* search940_2 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 117, 232 },
      -1,
   } },

   /* replace940_0_0 -> 722 in the cache */
   /* replace940_0 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1087 },
      -1,
   } },

   /* ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search941_0 -> 722 in the cache */
   /* search941_1 -> 267 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 267, 2798 },
      -1,
   } },

   /* replace941_0_0 -> 722 in the cache */
   /* replace941_0 -> 2795 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2795 },
      -1,
   } },

   /* ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search942_0 -> 722 in the cache */
   /* search942_1 -> 2798 in the cache */
   /* search942_2 -> 267 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 2798, 267 },
      -1,
   } },

   /* replace942_0_0_0 -> 722 in the cache */
   /* replace942_0_0 -> 1087 in the cache */
   /* replace942_0 -> 2797 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2797 },
      -1,
   } },

   /* ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search943_0 -> 722 in the cache */
   /* search943_1 -> 607 in the cache */
   /* search943_2 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 607, 1871 },
      -1,
   } },

   /* replace943_0 -> 722 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 722 },
      -1,
   } },

   /* ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search944_0 -> 722 in the cache */
   /* search944_1 -> 1871 in the cache */
   /* search944_2 -> 607 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1871, 607 },
      -1,
   } },

   /* replace944_0_0 -> 722 in the cache */
   /* replace944_0 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1087 },
      -1,
   } },

   /* ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search945_0 -> 722 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 2807, 2808 },
      -1,
   } },

   /* replace945_0_0 -> 722 in the cache */
   /* replace945_0 -> 2804 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2804 },
      -1,
   } },

   /* ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search946_0 -> 722 in the cache */
   /* search946_1 -> 2808 in the cache */
   /* search946_2 -> 2807 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 2808, 2807 },
      -1,
   } },

   /* replace946_0_0_0 -> 722 in the cache */
   /* replace946_0_0 -> 1087 in the cache */
   /* replace946_0 -> 2806 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2806 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', 'b') => b */
   /* search947_0 -> 722 in the cache */
   /* search947_1 -> 3 in the cache */
   /* search947_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 3, 3 },
      -1,
   } },

   /* replace947 -> 3 in the cache */

   /* ('~fcsel', 'a', 'b', 'b') => b */
   /* search948_0 -> 16 in the cache */
   /* search948_1 -> 36 in the cache */
   /* search948_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fcsel,
      -1, 0,
      { 16, 36, 36 },
      -1,
   } },

   /* replace948 -> 36 in the cache */

   /* ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1')) */
   /* search949_0 -> 722 in the cache */
   /* search949_1 -> 2511 in the cache */
   /* search949_2 -> 1184 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 2511, 1184 },
      -1,
   } },

   /* replace949_0_0 -> 722 in the cache */
   /* replace949_0 -> 1183 in the cache */
   /* replace949 -> 2198 in the cache */

   /* ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a'))) */
   /* search950_0 -> 722 in the cache */
   /* search950_1 -> 1184 in the cache */
   /* search950_2 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 722, 1184, 2511 },
      -1,
   } },

   /* replace950_0_0_0 -> 722 in the cache */
   /* replace950_0_0 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1087 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2817 },
      -1,
   } }