
/* Copyright © 2015-2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* This file generated from vk_entrypoints_gen.py, don't edit directly. */

#include "panvk_entrypoints.h"

/* Weak aliases for all potential implementations. These will resolve to
 * NULL if they're not defined, which lets the resolve_entrypoint() function
 * either pick the correct entry point.
 *
 * MSVC uses different decorated names for 32-bit versus 64-bit. Declare
 * all argument sizes for 32-bit because computing the actual size would be
 * difficult.
 */




#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateInstance=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateInstance=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateInstance(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyInstance=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyInstance=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDevices@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumeratePhysicalDevices=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumeratePhysicalDevices=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetInstanceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetInstanceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetInstanceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL panvk_GetInstanceProcAddr(VkInstance instance, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceVersion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumerateInstanceVersion=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumerateInstanceVersion=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumerateInstanceVersion(uint32_t* pApiVersion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumerateInstanceLayerProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumerateInstanceLayerProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumerateInstanceLayerProperties(uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateInstanceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumerateInstanceExtensionProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumerateInstanceExtensionProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateAndroidSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateAndroidSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateAndroidSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayPlaneSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDisplayPlaneSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDisplayPlaneSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroySurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroySurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_VI_NN
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateViSurfaceNN@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateViSurfaceNN=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateViSurfaceNN=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWaylandSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateWaylandSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateWaylandSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateWin32SurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateWin32SurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateWin32SurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXlibSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateXlibSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateXlibSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateXcbSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateXcbSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateXcbSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDirectFBSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDirectFBSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDirectFBSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImagePipeSurfaceFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateImagePipeSurfaceFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateImagePipeSurfaceFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateImagePipeSurfaceFUCHSIA(VkInstance instance, const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateStreamDescriptorSurfaceGGP@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateStreamDescriptorSurfaceGGP=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateStreamDescriptorSurfaceGGP=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateStreamDescriptorSurfaceGGP(VkInstance instance, const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateScreenSurfaceQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateScreenSurfaceQNX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateScreenSurfaceQNX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateScreenSurfaceQNX(VkInstance instance, const VkScreenSurfaceCreateInfoQNX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDebugReportCallbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDebugReportCallbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDebugReportCallbackEXT(VkInstance instance, const VkDebugReportCallbackCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugReportCallbackEXT* pCallback) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyDebugReportCallbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyDebugReportCallbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugReportMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DebugReportMessageEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DebugReportMessageEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags, VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location, int32_t messageCode, const char* pLayerPrefix, const char* pMessage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroups@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumeratePhysicalDeviceGroups=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumeratePhysicalDeviceGroups=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceGroupsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumeratePhysicalDeviceGroupsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumeratePhysicalDeviceGroupsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_IOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateIOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateIOSSurfaceMVK=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateIOSSurfaceMVK=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMacOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateMacOSSurfaceMVK=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateMacOSSurfaceMVK=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateMetalSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateMetalSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateMetalSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDebugUtilsMessengerEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDebugUtilsMessengerEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDebugUtilsMessengerEXT(VkInstance instance, const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugUtilsMessengerEXT* pMessenger) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyDebugUtilsMessengerEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyDebugUtilsMessengerEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SubmitDebugUtilsMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_SubmitDebugUtilsMessageEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_SubmitDebugUtilsMessageEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity, VkDebugUtilsMessageTypeFlagsEXT messageTypes, const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateHeadlessSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateHeadlessSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateHeadlessSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif

const struct vk_instance_entrypoint_table panvk_instance_entrypoints = {
    .CreateInstance = panvk_CreateInstance,
    .DestroyInstance = panvk_DestroyInstance,
    .EnumeratePhysicalDevices = panvk_EnumeratePhysicalDevices,
    .GetInstanceProcAddr = panvk_GetInstanceProcAddr,
    .EnumerateInstanceVersion = panvk_EnumerateInstanceVersion,
    .EnumerateInstanceLayerProperties = panvk_EnumerateInstanceLayerProperties,
    .EnumerateInstanceExtensionProperties = panvk_EnumerateInstanceExtensionProperties,
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .CreateAndroidSurfaceKHR = panvk_CreateAndroidSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateAndroidSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_ANDROID_KHR
    .CreateDisplayPlaneSurfaceKHR = panvk_CreateDisplayPlaneSurfaceKHR,
    .DestroySurfaceKHR = panvk_DestroySurfaceKHR,
#ifdef VK_USE_PLATFORM_VI_NN
    .CreateViSurfaceNN = panvk_CreateViSurfaceNN,
#elif defined(_MSC_VER)
    .CreateViSurfaceNN = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .CreateWaylandSurfaceKHR = panvk_CreateWaylandSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWaylandSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .CreateWin32SurfaceKHR = panvk_CreateWin32SurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWin32SurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .CreateXlibSurfaceKHR = panvk_CreateXlibSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXlibSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .CreateXcbSurfaceKHR = panvk_CreateXcbSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXcbSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .CreateDirectFBSurfaceEXT = panvk_CreateDirectFBSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateDirectFBSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
    .CreateImagePipeSurfaceFUCHSIA = panvk_CreateImagePipeSurfaceFUCHSIA,
#elif defined(_MSC_VER)
    .CreateImagePipeSurfaceFUCHSIA = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
    .CreateStreamDescriptorSurfaceGGP = panvk_CreateStreamDescriptorSurfaceGGP,
#elif defined(_MSC_VER)
    .CreateStreamDescriptorSurfaceGGP = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .CreateScreenSurfaceQNX = panvk_CreateScreenSurfaceQNX,
#elif defined(_MSC_VER)
    .CreateScreenSurfaceQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .CreateDebugReportCallbackEXT = panvk_CreateDebugReportCallbackEXT,
    .DestroyDebugReportCallbackEXT = panvk_DestroyDebugReportCallbackEXT,
    .DebugReportMessageEXT = panvk_DebugReportMessageEXT,
    .EnumeratePhysicalDeviceGroups = panvk_EnumeratePhysicalDeviceGroups,
    .EnumeratePhysicalDeviceGroupsKHR = panvk_EnumeratePhysicalDeviceGroupsKHR,
#ifdef VK_USE_PLATFORM_IOS_MVK
    .CreateIOSSurfaceMVK = panvk_CreateIOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateIOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
    .CreateMacOSSurfaceMVK = panvk_CreateMacOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateMacOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
    .CreateMetalSurfaceEXT = panvk_CreateMetalSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateMetalSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_METAL_EXT
    .CreateDebugUtilsMessengerEXT = panvk_CreateDebugUtilsMessengerEXT,
    .DestroyDebugUtilsMessengerEXT = panvk_DestroyDebugUtilsMessengerEXT,
    .SubmitDebugUtilsMessageEXT = panvk_SubmitDebugUtilsMessageEXT,
    .CreateHeadlessSurfaceEXT = panvk_CreateHeadlessSurfaceEXT,
};


#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceQueueFamilyProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceQueueFamilyProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceMemoryProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceMemoryProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceFeatures=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceFeatures=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceImageFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceImageFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumerateDeviceLayerProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumerateDeviceLayerProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumerateDeviceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumerateDeviceExtensionProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumerateDeviceExtensionProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSparseImageFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSparseImageFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceDisplayPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceDisplayPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneSupportedDisplaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDisplayPlaneSupportedDisplaysKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDisplayPlaneSupportedDisplaysKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDisplayModePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDisplayModePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDisplayModeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDisplayModeKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDisplayModeKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDisplayPlaneCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDisplayPlaneCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfaceSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfaceSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormatsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfaceFormatsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfaceFormatsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfacePresentModesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfacePresentModesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWaylandPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceWaylandPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceWaylandPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL panvk_GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceWin32PresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceWin32PresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceWin32PresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL panvk_GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXlibPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceXlibPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceXlibPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL panvk_GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceXcbPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceXcbPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceXcbPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL panvk_GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceScreenPresentationSupportQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceScreenPresentationSupportQNX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceScreenPresentationSupportQNX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL panvk_GetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceFeatures2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceFeatures2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFeatures2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceFeatures2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceFeatures2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceImageFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceImageFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceImageFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceImageFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceQueueFamilyProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceQueueFamilyProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceQueueFamilyProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceQueueFamilyProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceMemoryProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceMemoryProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMemoryProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceMemoryProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceMemoryProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSparseImageFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSparseImageFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceExternalBufferProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceExternalBufferProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalBufferPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceExternalBufferPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceExternalBufferPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceExternalBufferPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphoreProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceExternalSemaphoreProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceExternalSemaphoreProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFenceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceExternalFenceProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceExternalFenceProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceExternalFencePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceExternalFencePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceExternalFencePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ReleaseDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ReleaseDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ReleaseDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireXlibDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_AcquireXlibDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_AcquireXlibDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRandROutputDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetRandROutputDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetRandROutputDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_AcquireWinrtDisplayNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_AcquireWinrtDisplayNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetWinrtDisplayNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetWinrtDisplayNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfaceCapabilities2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfaceCapabilities2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDevicePresentRectanglesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDevicePresentRectanglesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDevicePresentRectanglesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceMultisamplePropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceMultisamplePropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceMultisamplePropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfaceCapabilities2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfaceCapabilities2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfaceFormats2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfaceFormats2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfaceFormats2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceDisplayProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceDisplayProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayModeProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDisplayModeProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDisplayModeProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDisplayPlaneCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDisplayPlaneCapabilities2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDisplayPlaneCapabilities2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainEXT* pTimeDomains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSurfacePresentModes2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSurfacePresentModes2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceToolProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceToolProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceToolPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceToolPropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceToolPropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceFragmentShadingRatesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceFragmentShadingRatesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceFragmentShadingRatesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) __attribute__ ((weak));
#endif
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceVideoCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceVideoCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPhysicalDeviceVideoFormatPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPhysicalDeviceVideoFormatPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPhysicalDeviceVideoFormatPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_AcquireDrmDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_AcquireDrmDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDrmDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDrmDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display) __attribute__ ((weak));
#endif

const struct vk_physical_device_entrypoint_table panvk_physical_device_entrypoints = {
    .GetPhysicalDeviceProperties = panvk_GetPhysicalDeviceProperties,
    .GetPhysicalDeviceQueueFamilyProperties = panvk_GetPhysicalDeviceQueueFamilyProperties,
    .GetPhysicalDeviceMemoryProperties = panvk_GetPhysicalDeviceMemoryProperties,
    .GetPhysicalDeviceFeatures = panvk_GetPhysicalDeviceFeatures,
    .GetPhysicalDeviceFormatProperties = panvk_GetPhysicalDeviceFormatProperties,
    .GetPhysicalDeviceImageFormatProperties = panvk_GetPhysicalDeviceImageFormatProperties,
    .CreateDevice = panvk_CreateDevice,
    .EnumerateDeviceLayerProperties = panvk_EnumerateDeviceLayerProperties,
    .EnumerateDeviceExtensionProperties = panvk_EnumerateDeviceExtensionProperties,
    .GetPhysicalDeviceSparseImageFormatProperties = panvk_GetPhysicalDeviceSparseImageFormatProperties,
    .GetPhysicalDeviceDisplayPropertiesKHR = panvk_GetPhysicalDeviceDisplayPropertiesKHR,
    .GetPhysicalDeviceDisplayPlanePropertiesKHR = panvk_GetPhysicalDeviceDisplayPlanePropertiesKHR,
    .GetDisplayPlaneSupportedDisplaysKHR = panvk_GetDisplayPlaneSupportedDisplaysKHR,
    .GetDisplayModePropertiesKHR = panvk_GetDisplayModePropertiesKHR,
    .CreateDisplayModeKHR = panvk_CreateDisplayModeKHR,
    .GetDisplayPlaneCapabilitiesKHR = panvk_GetDisplayPlaneCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceSupportKHR = panvk_GetPhysicalDeviceSurfaceSupportKHR,
    .GetPhysicalDeviceSurfaceCapabilitiesKHR = panvk_GetPhysicalDeviceSurfaceCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceFormatsKHR = panvk_GetPhysicalDeviceSurfaceFormatsKHR,
    .GetPhysicalDeviceSurfacePresentModesKHR = panvk_GetPhysicalDeviceSurfacePresentModesKHR,
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .GetPhysicalDeviceWaylandPresentationSupportKHR = panvk_GetPhysicalDeviceWaylandPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWaylandPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceWin32PresentationSupportKHR = panvk_GetPhysicalDeviceWin32PresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWin32PresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .GetPhysicalDeviceXlibPresentationSupportKHR = panvk_GetPhysicalDeviceXlibPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXlibPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .GetPhysicalDeviceXcbPresentationSupportKHR = panvk_GetPhysicalDeviceXcbPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXcbPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = panvk_GetPhysicalDeviceDirectFBPresentationSupportEXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceScreenPresentationSupportQNX = panvk_GetPhysicalDeviceScreenPresentationSupportQNX,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceScreenPresentationSupportQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceExternalImageFormatPropertiesNV = panvk_GetPhysicalDeviceExternalImageFormatPropertiesNV,
    .GetPhysicalDeviceFeatures2 = panvk_GetPhysicalDeviceFeatures2,
    .GetPhysicalDeviceFeatures2KHR = panvk_GetPhysicalDeviceFeatures2KHR,
    .GetPhysicalDeviceProperties2 = panvk_GetPhysicalDeviceProperties2,
    .GetPhysicalDeviceProperties2KHR = panvk_GetPhysicalDeviceProperties2KHR,
    .GetPhysicalDeviceFormatProperties2 = panvk_GetPhysicalDeviceFormatProperties2,
    .GetPhysicalDeviceFormatProperties2KHR = panvk_GetPhysicalDeviceFormatProperties2KHR,
    .GetPhysicalDeviceImageFormatProperties2 = panvk_GetPhysicalDeviceImageFormatProperties2,
    .GetPhysicalDeviceImageFormatProperties2KHR = panvk_GetPhysicalDeviceImageFormatProperties2KHR,
    .GetPhysicalDeviceQueueFamilyProperties2 = panvk_GetPhysicalDeviceQueueFamilyProperties2,
    .GetPhysicalDeviceQueueFamilyProperties2KHR = panvk_GetPhysicalDeviceQueueFamilyProperties2KHR,
    .GetPhysicalDeviceMemoryProperties2 = panvk_GetPhysicalDeviceMemoryProperties2,
    .GetPhysicalDeviceMemoryProperties2KHR = panvk_GetPhysicalDeviceMemoryProperties2KHR,
    .GetPhysicalDeviceSparseImageFormatProperties2 = panvk_GetPhysicalDeviceSparseImageFormatProperties2,
    .GetPhysicalDeviceSparseImageFormatProperties2KHR = panvk_GetPhysicalDeviceSparseImageFormatProperties2KHR,
    .GetPhysicalDeviceExternalBufferProperties = panvk_GetPhysicalDeviceExternalBufferProperties,
    .GetPhysicalDeviceExternalBufferPropertiesKHR = panvk_GetPhysicalDeviceExternalBufferPropertiesKHR,
    .GetPhysicalDeviceExternalSemaphoreProperties = panvk_GetPhysicalDeviceExternalSemaphoreProperties,
    .GetPhysicalDeviceExternalSemaphorePropertiesKHR = panvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR,
    .GetPhysicalDeviceExternalFenceProperties = panvk_GetPhysicalDeviceExternalFenceProperties,
    .GetPhysicalDeviceExternalFencePropertiesKHR = panvk_GetPhysicalDeviceExternalFencePropertiesKHR,
    .ReleaseDisplayEXT = panvk_ReleaseDisplayEXT,
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .AcquireXlibDisplayEXT = panvk_AcquireXlibDisplayEXT,
#elif defined(_MSC_VER)
    .AcquireXlibDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .GetRandROutputDisplayEXT = panvk_GetRandROutputDisplayEXT,
#elif defined(_MSC_VER)
    .GetRandROutputDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .AcquireWinrtDisplayNV = panvk_AcquireWinrtDisplayNV,
#elif defined(_MSC_VER)
    .AcquireWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetWinrtDisplayNV = panvk_GetWinrtDisplayNV,
#elif defined(_MSC_VER)
    .GetWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfaceCapabilities2EXT = panvk_GetPhysicalDeviceSurfaceCapabilities2EXT,
    .GetPhysicalDevicePresentRectanglesKHR = panvk_GetPhysicalDevicePresentRectanglesKHR,
    .GetPhysicalDeviceMultisamplePropertiesEXT = panvk_GetPhysicalDeviceMultisamplePropertiesEXT,
    .GetPhysicalDeviceSurfaceCapabilities2KHR = panvk_GetPhysicalDeviceSurfaceCapabilities2KHR,
    .GetPhysicalDeviceSurfaceFormats2KHR = panvk_GetPhysicalDeviceSurfaceFormats2KHR,
    .GetPhysicalDeviceDisplayProperties2KHR = panvk_GetPhysicalDeviceDisplayProperties2KHR,
    .GetPhysicalDeviceDisplayPlaneProperties2KHR = panvk_GetPhysicalDeviceDisplayPlaneProperties2KHR,
    .GetDisplayModeProperties2KHR = panvk_GetDisplayModeProperties2KHR,
    .GetDisplayPlaneCapabilities2KHR = panvk_GetDisplayPlaneCapabilities2KHR,
    .GetPhysicalDeviceCalibrateableTimeDomainsEXT = panvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT,
    .GetPhysicalDeviceCooperativeMatrixPropertiesNV = panvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV,
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfacePresentModes2EXT = panvk_GetPhysicalDeviceSurfacePresentModes2EXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceSurfacePresentModes2EXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = panvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
    .GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = panvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
    .GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = panvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV,
    .GetPhysicalDeviceToolProperties = panvk_GetPhysicalDeviceToolProperties,
    .GetPhysicalDeviceToolPropertiesEXT = panvk_GetPhysicalDeviceToolPropertiesEXT,
    .GetPhysicalDeviceFragmentShadingRatesKHR = panvk_GetPhysicalDeviceFragmentShadingRatesKHR,
#ifdef VK_ENABLE_BETA_EXTENSIONS
    .GetPhysicalDeviceVideoCapabilitiesKHR = panvk_GetPhysicalDeviceVideoCapabilitiesKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceVideoCapabilitiesKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
    .GetPhysicalDeviceVideoFormatPropertiesKHR = panvk_GetPhysicalDeviceVideoFormatPropertiesKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceVideoFormatPropertiesKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_ENABLE_BETA_EXTENSIONS
    .AcquireDrmDisplayEXT = panvk_AcquireDrmDisplayEXT,
    .GetDrmDisplayEXT = panvk_GetDrmDisplayEXT,
};


#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDeviceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDeviceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL panvk_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetDeviceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetDeviceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL panvk_v6_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetDeviceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetDeviceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL panvk_v7_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDeviceQueue=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDeviceQueue=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetDeviceQueue=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetDeviceQueue=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetDeviceQueue=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetDeviceQueue=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_QueueSubmit=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_QueueSubmit=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_QueueSubmit=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_QueueSubmit=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_QueueSubmit=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_QueueSubmit=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_QueueWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_QueueWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_QueueWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_QueueWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_QueueWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_QueueWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DeviceWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DeviceWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DeviceWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DeviceWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DeviceWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DeviceWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_AllocateMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_AllocateMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_AllocateMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_AllocateMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_AllocateMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_AllocateMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_FreeMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_FreeMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_FreeMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_FreeMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_FreeMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_FreeMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_MapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_MapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_MapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_MapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_MapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_MapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_UnmapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_UnmapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_UnmapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_UnmapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_UnmapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_UnmapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_FlushMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_FlushMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_FlushMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_FlushMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_FlushMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_FlushMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_InvalidateMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_InvalidateMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_InvalidateMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDeviceMemoryCommitment=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetDeviceMemoryCommitment=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetDeviceMemoryCommitment=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetBufferMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetBufferMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetBufferMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetBufferMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetBufferMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetBufferMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_BindBufferMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_BindBufferMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_BindBufferMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_BindBufferMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_BindBufferMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_BindBufferMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetImageMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetImageMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetImageMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetImageMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetImageMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetImageMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_BindImageMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_BindImageMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_BindImageMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_BindImageMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_BindImageMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_BindImageMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetImageSparseMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetImageSparseMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetImageSparseMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_QueueBindSparse=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_QueueBindSparse=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_QueueBindSparse=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_QueueBindSparse=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_QueueBindSparse=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_QueueBindSparse=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ResetFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ResetFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_ResetFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_ResetFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_ResetFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_ResetFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetFenceStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetFenceStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetFenceStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetFenceStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetFenceStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetFenceStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_WaitForFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_WaitForFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_WaitForFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_WaitForFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_WaitForFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_WaitForFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateSemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateSemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateSemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateSemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateSemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateSemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroySemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroySemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroySemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroySemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroySemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroySemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetEventStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetEventStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetEventStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetEventStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetEventStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetEventStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_SetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_SetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_SetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_SetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_SetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_SetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_ResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_ResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_ResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_ResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_ResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_ResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_ResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_ResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ResetQueryPoolEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ResetQueryPoolEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_ResetQueryPoolEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_ResetQueryPoolEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_ResetQueryPoolEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_ResetQueryPoolEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetImageSubresourceLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetImageSubresourceLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetImageSubresourceLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetImageSubresourceLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetImageSubresourceLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetImageSubresourceLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreatePipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreatePipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreatePipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreatePipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreatePipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreatePipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyPipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyPipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyPipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyPipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyPipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyPipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetPipelineCacheData=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetPipelineCacheData=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetPipelineCacheData=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetPipelineCacheData=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetPipelineCacheData=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetPipelineCacheData=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_MergePipelineCaches=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_MergePipelineCaches=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_MergePipelineCaches=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_MergePipelineCaches=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_MergePipelineCaches=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_MergePipelineCaches=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateGraphicsPipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateGraphicsPipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateGraphicsPipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateGraphicsPipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateGraphicsPipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateGraphicsPipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateComputePipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateComputePipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateComputePipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateComputePipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateComputePipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateComputePipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreatePipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreatePipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreatePipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreatePipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreatePipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreatePipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyPipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyPipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyPipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyPipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyPipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyPipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateSampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateSampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateSampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateSampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateSampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateSampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroySampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroySampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroySampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroySampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroySampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroySampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ResetDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ResetDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_ResetDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_ResetDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_ResetDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_ResetDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_AllocateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_AllocateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_AllocateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_AllocateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_AllocateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_AllocateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_FreeDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_FreeDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_FreeDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_FreeDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_FreeDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_FreeDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_UpdateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_UpdateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_UpdateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_UpdateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_UpdateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_UpdateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetRenderAreaGranularity=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetRenderAreaGranularity=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetRenderAreaGranularity=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetRenderAreaGranularity=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetRenderAreaGranularity=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetRenderAreaGranularity=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroyCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroyCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroyCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroyCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroyCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroyCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ResetCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ResetCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_ResetCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_ResetCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_ResetCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_ResetCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_AllocateCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_AllocateCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_AllocateCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_AllocateCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_AllocateCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_AllocateCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_FreeCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_FreeCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_FreeCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_FreeCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_FreeCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_FreeCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_BeginCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_BeginCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_BeginCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_BeginCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_BeginCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_BeginCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_EndCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_EndCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_EndCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_EndCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_EndCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_EndCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_ResetCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_ResetCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_ResetCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_ResetCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_ResetCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_ResetCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBindPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBindPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBindPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBindPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBindPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBindPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetViewport=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetViewport=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetViewport=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetViewport=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetViewport=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetViewport=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetScissor=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetScissor=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetScissor=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetScissor=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetScissor=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetScissor=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetLineWidth=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetLineWidth=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetLineWidth=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetLineWidth=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetLineWidth=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetLineWidth=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetDepthBias=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetDepthBias=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetDepthBias=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetDepthBias=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetDepthBias=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetDepthBias=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetBlendConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetBlendConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetBlendConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetBlendConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetBlendConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetBlendConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetDepthBounds=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetDepthBounds=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetDepthBounds=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetDepthBounds=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetDepthBounds=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetDepthBounds=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetStencilCompareMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetStencilCompareMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetStencilCompareMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetStencilCompareMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetStencilCompareMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetStencilCompareMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetStencilWriteMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetStencilWriteMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetStencilWriteMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetStencilWriteMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetStencilWriteMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetStencilWriteMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetStencilReference=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetStencilReference=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetStencilReference=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetStencilReference=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetStencilReference=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetStencilReference=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBindDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBindDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBindDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBindDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBindDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBindDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBindIndexBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBindIndexBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBindIndexBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBindIndexBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBindIndexBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBindIndexBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBindVertexBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBindVertexBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBindVertexBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBindVertexBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBindVertexBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBindVertexBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDraw=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDraw=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDraw=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDraw=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDraw=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDraw=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDrawIndexed=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDrawIndexed=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDrawIndexed=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDrawIndexed=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDrawIndexed=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDrawIndexed=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDrawMultiEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDrawMultiEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDrawMultiEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDrawMultiEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDrawMultiEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDrawMultiEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDrawMultiIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDrawMultiIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDrawMultiIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDrawIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDrawIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDrawIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDrawIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDrawIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDrawIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDrawIndexedIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDrawIndexedIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDrawIndexedIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDispatch=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDispatch=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDispatch=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDispatch=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDispatch=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDispatch=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDispatchIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDispatchIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDispatchIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDispatchIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDispatchIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDispatchIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSubpassShadingHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSubpassShadingHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSubpassShadingHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdCopyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdCopyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdCopyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdCopyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdCopyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdCopyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdCopyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdCopyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdCopyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdCopyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdCopyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdCopyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBlitImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBlitImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBlitImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBlitImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBlitImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBlitImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdCopyBufferToImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdCopyBufferToImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdCopyBufferToImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdCopyBufferToImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdCopyBufferToImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdCopyBufferToImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdCopyImageToBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdCopyImageToBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdCopyImageToBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdCopyImageToBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdCopyImageToBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdCopyImageToBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdUpdateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdUpdateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdUpdateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdUpdateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdUpdateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdUpdateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdFillBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdFillBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdFillBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdFillBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdFillBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdFillBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdClearColorImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdClearColorImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdClearColorImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdClearColorImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdClearColorImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdClearColorImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdClearDepthStencilImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdClearDepthStencilImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdClearDepthStencilImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdClearDepthStencilImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdClearDepthStencilImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdClearDepthStencilImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdClearAttachments=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdClearAttachments=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdClearAttachments=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdClearAttachments=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdClearAttachments=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdClearAttachments=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdResolveImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdResolveImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdResolveImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdResolveImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdResolveImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdResolveImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdSetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdSetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdSetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdSetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdSetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdSetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdWaitEvents=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdWaitEvents=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdWaitEvents=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdWaitEvents=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdWaitEvents=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdWaitEvents=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdPipelineBarrier=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdPipelineBarrier=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdPipelineBarrier=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdPipelineBarrier=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdPipelineBarrier=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdPipelineBarrier=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBeginQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBeginQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBeginQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBeginQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBeginQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBeginQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdEndQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdEndQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdEndQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdEndQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdEndQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdEndQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBeginConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBeginConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBeginConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdEndConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdEndConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdEndConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdWriteTimestamp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdWriteTimestamp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdWriteTimestamp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdWriteTimestamp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdWriteTimestamp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdWriteTimestamp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdCopyQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdCopyQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdCopyQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdPushConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdPushConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdPushConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdPushConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdPushConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdPushConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdBeginRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdBeginRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdBeginRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdBeginRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdBeginRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdBeginRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdNextSubpass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdNextSubpass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdNextSubpass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdNextSubpass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdNextSubpass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdNextSubpass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdEndRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdEndRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdEndRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdEndRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdEndRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdEndRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdExecuteCommands=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdExecuteCommands=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdExecuteCommands=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdExecuteCommands=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdExecuteCommands=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdExecuteCommands=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateSharedSwapchainsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateSharedSwapchainsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateSharedSwapchainsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CreateSwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CreateSwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CreateSwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CreateSwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CreateSwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CreateSwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DestroySwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DestroySwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DestroySwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DestroySwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DestroySwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DestroySwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_GetSwapchainImagesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_GetSwapchainImagesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_GetSwapchainImagesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_GetSwapchainImagesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_GetSwapchainImagesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_GetSwapchainImagesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_AcquireNextImageKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_AcquireNextImageKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_AcquireNextImageKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_AcquireNextImageKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_AcquireNextImageKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_AcquireNextImageKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_QueuePresentKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_QueuePresentKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_QueuePresentKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_QueuePresentKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_QueuePresentKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_QueuePresentKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DebugMarkerSetObjectNameEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DebugMarkerSetObjectNameEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DebugMarkerSetObjectNameEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_DebugMarkerSetObjectTagEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_DebugMarkerSetObjectTagEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v6_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_DebugMarkerSetObjectTagEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL panvk_v7_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDebugMarkerBeginEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDebugMarkerBeginEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v7_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v7_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v7_CmdDebugMarkerBeginEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v7_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_CmdDebugMarkerEndEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_CmdDebugMarkerEndEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_CmdDebugMarkerEndEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_panvk_v6_CmdDebugMarkerEndEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:panvk_v6_CmdDebugMarkerEndEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#panvk_v6_CmdDebugMarkerEndEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL panvk_v6_CmdDebugM