/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_he extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "CNY", "\u200eCN\u00a5\u200e" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "ILP", "\u05dc\u05f4\u05d9" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\u00a5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MXP", "MXP" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "USN", "USN" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u05e4\u05d6\u05d8\u05d4 \u05d0\u05e0\u05d3\u05d5\u05e8\u05d9\u05ea" },
            { "aed", "\u05d3\u05d9\u05e8\u05d4\u05dd \u05e9\u05dc \u05d0\u05d9\u05d7\u05d5\u05d3 \u05d4\u05e0\u05e1\u05d9\u05db\u05d5\u05d9\u05d5\u05ea \u05d4\u05e2\u05e8\u05d1\u05d9\u05d5\u05ea" },
            { "afn", "\u05d0\u05e4\u05d2\u05e0\u05d9 \u05d0\u05e4\u05d2\u05e0\u05d9" },
            { "all", "\u05dc\u05e7 \u05d0\u05dc\u05d1\u05e0\u05d9" },
            { "amd", "\u05d3\u05e8\u05d0\u05dd \u05d0\u05e8\u05de\u05e0\u05d9" },
            { "ang", "\u05d2\u05d9\u05dc\u05d3\u05e8 \u05e9\u05dc \u05d4\u05d0\u05e0\u05d8\u05d9\u05dc\u05d9\u05dd \u05d4\u05d4\u05d5\u05dc\u05e0\u05d3\u05d9\u05d9\u05dd" },
            { "aoa", "\u05e7\u05d5\u05d0\u05e0\u05d6\u05d4 \u05d0\u05e0\u05d2\u05d5\u05dc\u05d9" },
            { "aon", "\u05e7\u05d5\u05d0\u05e0\u05d6\u05d4 \u05d7\u05d3\u05e9 \u05d0\u05e0\u05d2\u05d5\u05dc\u05d9 (1990\u20132000)" },
            { "aor", "\u05e7\u05d5\u05d0\u05e0\u05d6\u05d4 \u05e8\u05d2\u05f3\u05d5\u05e1\u05d8\u05d3\u05d5 \u05d0\u05e0\u05d2\u05d5\u05dc\u05d9 (1995\u20131999)" },
            { "arp", "\u05e4\u05d6\u05d5 \u05d0\u05e8\u05d2\u05e0\u05d8\u05d9\u05e0\u05d0\u05d9 (1983\u20131985)" },
            { "ars", "\u05e4\u05e1\u05d5 \u05d0\u05e8\u05d2\u05e0\u05d8\u05d9\u05e0\u05d0\u05d9" },
            { "ats", "\u05e9\u05d9\u05dc\u05d9\u05e0\u05d2 \u05d0\u05d5\u05e1\u05d8\u05e8\u05d9" },
            { "aud", "\u05d3\u05d5\u05dc\u05e8 \u05d0\u05d5\u05e1\u05d8\u05e8\u05dc\u05d9" },
            { "awg", "\u05e4\u05dc\u05d5\u05e8\u05d9\u05df \u05e9\u05dc \u05d0\u05e8\u05d5\u05d1\u05d4" },
            { "azm", "\u05de\u05e0\u05d0\u05d8 \u05d0\u05d6\u05e8\u05d1\u05d9\u05d2\u05f3\u05d0\u05e0\u05d9 (1993\u20132006)" },
            { "azn", "\u05de\u05d0\u05e0\u05d0\u05d8 \u05d0\u05d6\u05e8\u05d1\u05d9\u05d9\u05d2\u05f3\u05e0\u05d9" },
            { "bad", "\u05d3\u05d9\u05e0\u05e8 \u05e9\u05dc \u05d1\u05d5\u05e1\u05e0\u05d9\u05d4\u05be\u05d4\u05e8\u05e6\u05d2\u05d5\u05d1\u05d9\u05e0\u05d4" },
            { "bam", "\u05de\u05d0\u05e8\u05e7 \u05e1\u05d7\u05d9\u05e8 \u05e9\u05dc \u05d1\u05d5\u05e1\u05e0\u05d9\u05d4 \u05d5\u05d4\u05e8\u05e6\u05d2\u05d5\u05d1\u05d9\u05e0\u05d4" },
            { "bbd", "\u05d3\u05d5\u05dc\u05e8 \u05d1\u05e8\u05d1\u05d3\u05d9\u05d0\u05e0\u05d9" },
            { "bdt", "\u05d8\u05d0\u05e7\u05d4 \u05d1\u05e0\u05d2\u05dc\u05d3\u05e9\u05d9" },
            { "bec", "\u05e4\u05e8\u05e0\u05e7 \u05d1\u05dc\u05d2\u05d9 (\u05d1\u05e8 \u05d4\u05de\u05e8\u05d4)" },
            { "bef", "\u05e4\u05e8\u05e0\u05e7 \u05d1\u05dc\u05d2\u05d9" },
            { "bgl", "\u05dc\u05d1 \u05d1\u05d5\u05dc\u05d2\u05e8\u05d9 \u05d9\u05e9\u05df" },
            { "bgn", "\u05dc\u05d1 \u05d1\u05d5\u05dc\u05d2\u05e8\u05d9" },
            { "bhd", "\u05d3\u05d9\u05e0\u05e8 \u05d1\u05d7\u05e8\u05d9\u05d9\u05e0\u05d9" },
            { "bif", "\u05e4\u05e8\u05e0\u05e7 \u05d1\u05d5\u05e8\u05d5\u05e0\u05d3\u05d9" },
            { "bmd", "\u05d3\u05d5\u05dc\u05e8 \u05d1\u05e8\u05de\u05d5\u05d3\u05d4" },
            { "bnd", "\u05d3\u05d5\u05dc\u05e8 \u05d1\u05e8\u05d5\u05e0\u05d9\u05d9" },
            { "bob", "\u05d1\u05d5\u05dc\u05d9\u05d1\u05d9\u05d0\u05e0\u05d5" },
            { "bop", "\u05e4\u05d6\u05d5 \u05d1\u05d5\u05dc\u05d9\u05d1\u05d9" },
            { "brb", "\u05e7\u05e8\u05d5\u05d6\u05d9\u05d0\u05e8\u05d5 \u05d7\u05d3\u05e9 \u05d1\u05e8\u05d6\u05d9\u05dc\u05d0\u05d9 (1967\u20131986)" },
            { "brc", "\u05e7\u05e8\u05d5\u05d6\u05d3\u05d5 \u05d1\u05e8\u05d6\u05d9\u05dc\u05d0\u05d9" },
            { "brl", "\u05e8\u05d9\u05d0\u05dc \u05d1\u05e8\u05d6\u05d9\u05dc\u05d0\u05d9" },
            { "bsd", "\u05d3\u05d5\u05dc\u05e8 \u05d1\u05d4\u05d0\u05de\u05d9" },
            { "btn", "\u05e0\u05d2\u05d5\u05dc\u05d8\u05e8\u05d5\u05dd \u05d1\u05d4\u05d5\u05d8\u05e0\u05d9" },
            { "bwp", "\u05e4\u05d5\u05dc\u05d4 \u05d1\u05d5\u05d8\u05e1\u05d5\u05d0\u05e0\u05d9" },
            { "byn", "\u05e8\u05d5\u05d1\u05dc \u05d1\u05dc\u05e8\u05d5\u05e1\u05d9" },
            { "byr", "\u05e8\u05d5\u05d1\u05dc \u05d1\u05dc\u05e8\u05d5\u05e1\u05d9 (2000\u20132016)" },
            { "bzd", "\u05d3\u05d5\u05dc\u05e8 \u05d1\u05dc\u05d9\u05d6\u05d9" },
            { "cad", "\u05d3\u05d5\u05dc\u05e8 \u05e7\u05e0\u05d3\u05d9" },
            { "cdf", "\u05e4\u05e8\u05e0\u05e7 \u05e7\u05d5\u05e0\u05d2\u05d5\u05dc\u05d6\u05d9" },
            { "chf", "\u05e4\u05e8\u05e0\u05e7 \u05e9\u05d5\u05d5\u05d9\u05e6\u05e8\u05d9" },
            { "clp", "\u05e4\u05e1\u05d5 \u05e6\u05f3\u05d9\u05dc\u05d0\u05e0\u05d9" },
            { "cnh", "\u05d9\u05d5\u05d0\u05df \u05e1\u05d9\u05e0\u05d9 (CNH)" },
            { "cny", "\u05d9\u05d5\u05d0\u05df \u05e1\u05d9\u05e0\u05d9" },
            { "cop", "\u05e4\u05e1\u05d5 \u05e7\u05d5\u05dc\u05d5\u05de\u05d1\u05d9\u05d0\u05e0\u05d9" },
            { "crc", "\u05e7\u05d5\u05dc\u05d5\u05df \u05e7\u05d5\u05e1\u05d8\u05d4\u05be\u05e8\u05d9\u05e7\u05e0\u05d9" },
            { "csd", "\u05d3\u05d9\u05e0\u05e8 \u05e1\u05e8\u05d1\u05d9 \u05d9\u05e9\u05df" },
            { "cuc", "\u05e4\u05e1\u05d5 \u05e7\u05d5\u05d1\u05e0\u05d9 \u05dc\u05d4\u05de\u05e8\u05d4" },
            { "cup", "\u05e4\u05e1\u05d5 \u05e7\u05d5\u05d1\u05e0\u05d9" },
            { "cve", "\u05d0\u05e1\u05e7\u05d5\u05d3\u05d5 \u05db\u05e3 \u05d5\u05e8\u05d3\u05d4" },
            { "cyp", "\u05dc\u05d9\u05e8\u05d4 \u05e7\u05e4\u05e8\u05d9\u05e1\u05d0\u05d9\u05ea" },
            { "czk", "\u05e7\u05d5\u05e8\u05d5\u05e0\u05d4 \u05e6\u05f3\u05db\u05d9\u05ea" },
            { "ddm", "\u05de\u05e8\u05e7 \u05de\u05d6\u05e8\u05d7 \u05d2\u05e8\u05de\u05e0\u05d9" },
            { "dem", "\u05de\u05e8\u05e7 \u05d2\u05e8\u05de\u05e0\u05d9" },
            { "djf", "\u05e4\u05e8\u05e0\u05e7 \u05d2\u05f3\u05d9\u05d1\u05d5\u05d8\u05d9" },
            { "dkk", "\u05db\u05ea\u05e8 \u05d3\u05e0\u05d9" },
            { "dop", "\u05e4\u05e1\u05d5 \u05d3\u05d5\u05de\u05d9\u05e0\u05d9\u05e7\u05e0\u05d9" },
            { "dzd", "\u05d3\u05d9\u05e0\u05e8 \u05d0\u05dc\u05d2\u05f3\u05d9\u05e8\u05d9" },
            { "ecs", "\u05e1\u05d5\u05e7\u05e8 \u05d0\u05e7\u05d5\u05d0\u05d3\u05d5\u05e8\u05d9" },
            { "eek", "\u05e7\u05e8\u05d5\u05df \u05d0\u05e1\u05d8\u05d5\u05e0\u05d9" },
            { "egp", "\u05dc\u05d9\u05e8\u05d4 \u05de\u05e6\u05e8\u05d9\u05ea" },
            { "ern", "\u05e0\u05d0\u05e7\u05e4\u05d4 \u05d0\u05e8\u05d9\u05ea\u05e8\u05d0\u05d9" },
            { "esp", "\u05e4\u05e1\u05d8\u05d4 \u05e1\u05e4\u05e8\u05d3\u05d9" },
            { "etb", "\u05d1\u05d9\u05e8 \u05d0\u05ea\u05d9\u05d5\u05e4\u05d9" },
            { "eur", "\u05d0\u05d9\u05e8\u05d5" },
            { "fim", "\u05de\u05e8\u05e7 \u05e4\u05d9\u05e0\u05d9" },
            { "fjd", "\u05d3\u05d5\u05dc\u05e8 \u05e4\u05d9\u05d2\u05f3\u05d9" },
            { "fkp", "\u05dc\u05d9\u05e8\u05d4 \u05e9\u05dc \u05d0\u05d9\u05d9 \u05e4\u05d5\u05e7\u05dc\u05e0\u05d3" },
            { "frf", "\u05e4\u05e8\u05e0\u05e7 \u05e6\u05e8\u05e4\u05ea\u05d9" },
            { "gbp", "\u05dc\u05d9\u05e8\u05d4 \u05e9\u05d8\u05e8\u05dc\u05d9\u05e0\u05d2" },
            { "gel", "\u05dc\u05d0\u05e8\u05d9 \u05d2\u05d0\u05d5\u05e8\u05d2\u05d9" },
            { "ghs", "\u05e1\u05d3\u05d9 \u05d2\u05d0\u05e0\u05d9" },
            { "gip", "\u05e4\u05d0\u05d5\u05e0\u05d3 \u05d2\u05d9\u05d1\u05e8\u05dc\u05d8\u05e8" },
            { "gmd", "\u05d3\u05dc\u05e1\u05d9 \u05d2\u05de\u05d1\u05d9" },
            { "gnf", "\u05e4\u05e8\u05e0\u05e7 \u05d2\u05d9\u05e0\u05d0\u05d9" },
            { "grd", "\u05d3\u05e8\u05db\u05de\u05d4" },
            { "gtq", "\u05e7\u05e6\u05d0\u05dc \u05d2\u05d5\u05d0\u05d8\u05de\u05dc\u05d9" },
            { "gwp", "\u05e4\u05d6\u05d5 \u05d2\u05d9\u05e0\u05d0\u05d9" },
            { "gyd", "\u05d3\u05d5\u05dc\u05e8 \u05d2\u05d9\u05d0\u05e0\u05d9" },
            { "hkd", "\u05d3\u05d5\u05dc\u05e8 \u05d4\u05d5\u05e0\u05d2 \u05e7\u05d5\u05e0\u05d2\u05d9" },
            { "hnl", "\u05dc\u05de\u05e4\u05d9\u05e8\u05d4 \u05d4\u05d5\u05e0\u05d3\u05d5\u05e8\u05d9" },
            { "hrk", "\u05e7\u05d5\u05e0\u05d4 \u05e7\u05e8\u05d5\u05d0\u05d8\u05d9" },
            { "htg", "\u05d2\u05d5\u05e8\u05d3 \u05d4\u05d0\u05d9\u05d8\u05d9" },
            { "huf", "\u05e4\u05d5\u05e8\u05d9\u05e0\u05d8 \u05d4\u05d5\u05e0\u05d2\u05e8\u05d9" },
            { "idr", "\u05e8\u05d5\u05e4\u05d9\u05d4 \u05d0\u05d9\u05e0\u05d3\u05d5\u05e0\u05d6\u05d9\u05ea" },
            { "iep", "\u05dc\u05d9\u05e8\u05d4 \u05d0\u05d9\u05e8\u05d9\u05ea" },
            { "ilp", "\u05dc\u05d9\u05e8\u05d4 \u05d9\u05e9\u05e8\u05d0\u05dc\u05d9\u05ea" },
            { "ils", "\u05e9\u05e7\u05dc \u05d7\u05d3\u05e9" },
            { "inr", "\u05e8\u05d5\u05e4\u05d9 \u05d4\u05d5\u05d3\u05d9" },
            { "iqd", "\u05d3\u05d9\u05e0\u05e8 \u05e2\u05d9\u05e8\u05d0\u05e7\u05d9" },
            { "irr", "\u05e8\u05d9\u05d0\u05dc \u05d0\u05d9\u05e8\u05d0\u05e0\u05d9" },
            { "isk", "\u05db\u05ea\u05e8 \u05d0\u05d9\u05e1\u05dc\u05e0\u05d3\u05d9" },
            { "itl", "\u05dc\u05d9\u05e8\u05d4 \u05d0\u05d9\u05d8\u05dc\u05e7\u05d9\u05ea" },
            { "jmd", "\u05d3\u05d5\u05dc\u05e8 \u05d2\u05f3\u05de\u05d9\u05d9\u05e7\u05e0\u05d9" },
            { "jod", "\u05d3\u05d9\u05e0\u05e8 \u05d9\u05e8\u05d3\u05e0\u05d9" },
            { "jpy", "\u05d9\u05df \u05d9\u05e4\u05e0\u05d9" },
            { "kes", "\u05e9\u05d9\u05dc\u05d9\u05e0\u05d2 \u05e7\u05e0\u05d9\u05d9\u05ea\u05d9" },
            { "kgs", "\u05e1\u05d5\u05dd \u05e7\u05d9\u05e8\u05d2\u05d9\u05d6\u05d9" },
            { "khr", "\u05e8\u05d9\u05dc \u05e7\u05de\u05d1\u05d5\u05d3\u05d9" },
            { "kmf", "\u05e4\u05e8\u05e0\u05e7 \u05e7\u05d5\u05de\u05d5\u05e8\u05d5\u05d0\u05d9" },
            { "kpw", "\u05d5\u05d5\u05df \u05e6\u05e4\u05d5\u05df \u05e7\u05d5\u05e8\u05d9\u05d0\u05e0\u05d9" },
            { "krw", "\u05d5\u05d5\u05df \u05d3\u05e8\u05d5\u05dd \u05e7\u05d5\u05e8\u05d9\u05d0\u05e0\u05d9" },
            { "kwd", "\u05d3\u05d9\u05e0\u05e8 \u05db\u05d5\u05d5\u05d9\u05ea\u05d9" },
            { "kyd", "\u05d3\u05d5\u05dc\u05e8 \u05e7\u05d9\u05d9\u05de\u05e0\u05d9" },
            { "kzt", "\u05d8\u05e0\u05d2\u05d4 \u05e7\u05d6\u05d7\u05e1\u05d8\u05e0\u05d9" },
            { "lak", "\u05e7\u05d9\u05e4 \u05dc\u05d0\u05d9" },
            { "lbp", "\u05dc\u05d9\u05e8\u05d4 \u05dc\u05d1\u05e0\u05d5\u05e0\u05d9\u05ea" },
            { "lkr", "\u05e8\u05d5\u05e4\u05d9 \u05e1\u05e8\u05d9 \u05dc\u05e0\u05e7\u05d9" },
            { "lrd", "\u05d3\u05d5\u05dc\u05e8 \u05dc\u05d9\u05d1\u05e8\u05d9" },
            { "lsl", "\u05dc\u05d5\u05d8\u05d9 \u05dc\u05e1\u05d5\u05ea\u05d9" },
            { "ltl", "\u05dc\u05d9\u05d8\u05d0 \u05dc\u05d9\u05d8\u05d0\u05d9" },
            { "luf", "\u05e4\u05e8\u05e0\u05e7 \u05dc\u05d5\u05e7\u05e1\u05de\u05d1\u05d5\u05e8\u05d2\u05d9" },
            { "lvl", "\u05dc\u05d8 \u05dc\u05d8\u05d1\u05d9" },
            { "lyd", "\u05d3\u05d9\u05e0\u05e8 \u05dc\u05d5\u05d1\u05d9" },
            { "mad", "\u05d3\u05d9\u05e8\u05d4\u05dd \u05de\u05e8\u05d5\u05e7\u05d0\u05d9" },
            { "maf", "\u05e4\u05e8\u05e0\u05e7 \u05de\u05e8\u05d5\u05e7\u05d0\u05d9" },
            { "mdl", "\u05dc\u05d0\u05d5 \u05de\u05d5\u05dc\u05d3\u05d5\u05d1\u05e0\u05d9" },
            { "mga", "\u05d0\u05e8\u05d9\u05d0\u05e8\u05d9 \u05de\u05dc\u05d2\u05e9\u05d9" },
            { "mgf", "\u05e4\u05e8\u05e0\u05e7 \u05de\u05d3\u05d2\u05e1\u05e7\u05d0\u05e8\u05d9" },
            { "mkd", "\u05d3\u05d9\u05e0\u05e8 \u05de\u05e7\u05d3\u05d5\u05e0\u05d9" },
            { "mmk", "\u05e7\u05d9\u05d0\u05d8 \u05de\u05d9\u05d0\u05e0\u05de\u05e8\u05d9" },
            { "mnt", "\u05d8\u05d5\u05d2\u05e8\u05d5\u05d2 \u05de\u05d5\u05e0\u05d2\u05d5\u05dc\u05d9" },
            { "mop", "\u05e4\u05d8\u05e7\u05d4 \u05e9\u05dc \u05de\u05e7\u05d0\u05d5" },
            { "mro", "\u05d0\u05d5\u05d0\u05d5\u05d2\u05d5\u05d9\u05d4 \u05de\u05d0\u05d5\u05e8\u05d9\u05d8\u05e0\u05d9 (1973\u20132017)" },
            { "mru", "\u05d0\u05d5\u05d0\u05d5\u05d2\u05d5\u05d9\u05d4 \u05de\u05d0\u05d5\u05e8\u05d9\u05d8\u05e0\u05d9" },
            { "mtl", "\u05dc\u05d9\u05e8\u05d4 \u05de\u05dc\u05d8\u05d9\u05ea" },
            { "mur", "\u05e8\u05d5\u05e4\u05d9 \u05de\u05d0\u05d5\u05e8\u05d9\u05e6\u05d9\u05e0\u05d9" },
            { "mvr", "\u05e8\u05d5\u05e4\u05d9\u05d4 \u05de\u05dc\u05d3\u05d9\u05d1\u05d9\u05ea" },
            { "mwk", "\u05e7\u05d5\u05d0\u05e6\u05f3\u05d4 \u05de\u05dc\u05d0\u05d5\u05d5\u05d9" },
            { "mxn", "\u05e4\u05e1\u05d5 \u05de\u05e7\u05e1\u05d9\u05e7\u05e0\u05d9" },
            { "mxp", "\u05e4\u05d6\u05d5 \u05de\u05e7\u05e1\u05d9\u05e7\u05e0\u05d9 (1861 \u2013 1992)" },
            { "mxv", "\u05d9\u05d7\u05d9\u05d3\u05ea \u05d4\u05e9\u05e7\u05e2\u05d5\u05ea \u05de\u05e7\u05e1\u05d9\u05e7\u05e0\u05d9\u05ea" },
            { "myr", "\u05e8\u05d9\u05e0\u05d2\u05d9\u05d8 \u05de\u05dc\u05d6\u05d9" },
            { "mze", "\u05d0\u05e1\u05e7\u05d5\u05d3\u05d5 \u05de\u05d5\u05d6\u05de\u05d1\u05d9\u05e7\u05d9" },
            { "mzm", "\u05de\u05d8\u05d9\u05e7\u05dc" },
            { "mzn", "\u05de\u05d8\u05d9\u05e7\u05dc \u05de\u05d5\u05d6\u05de\u05d1\u05d9\u05e0\u05d9" },
            { "nad", "\u05d3\u05d5\u05dc\u05e8 \u05e0\u05de\u05d9\u05d1\u05d9" },
            { "ngn", "\u05e0\u05d0\u05d9\u05e8\u05d4 \u05e0\u05d9\u05d2\u05e8\u05d9" },
            { "nic", "\u05e7\u05d5\u05e8\u05d3\u05d5\u05d1\u05d4 (1988\u20131991)" },
            { "nio", "\u05e7\u05d5\u05e8\u05d3\u05d5\u05d1\u05d4 \u05e0\u05d9\u05e7\u05e8\u05d2\u05d5\u05d0\u05d4" },
            { "nlg", "\u05d2\u05d9\u05dc\u05d3\u05df \u05d4\u05d5\u05dc\u05e0\u05d3\u05d9" },
            { "nok", "\u05db\u05ea\u05e8 \u05e0\u05d5\u05e8\u05d5\u05d5\u05d2\u05d9" },
            { "npr", "\u05e8\u05d5\u05e4\u05d9 \u05e0\u05e4\u05d0\u05dc\u05d9" },
            { "nzd", "\u05d3\u05d5\u05dc\u05e8 \u05e0\u05d9\u05d5 \u05d6\u05d9\u05dc\u05e0\u05d3\u05d9" },
            { "omr", "\u05e8\u05d9\u05d0\u05dc \u05e2\u05d5\u05de\u05d0\u05e0\u05d9" },
            { "pab", "\u05d1\u05dc\u05d1\u05d5\u05d0\u05d4 \u05e4\u05e0\u05de\u05d9" },
            { "pen", "\u05e1\u05d5\u05dc \u05e4\u05e8\u05d5\u05d0\u05e0\u05d9" },
            { "pgk", "\u05e7\u05d9\u05e0\u05d4 \u05e9\u05dc \u05e4\u05e4\u05d5\u05d0\u05d4 \u05d2\u05d9\u05e0\u05d0\u05d4 \u05d4\u05d7\u05d3\u05e9\u05d4" },
            { "php", "\u05e4\u05d6\u05d5 \u05e4\u05d9\u05dc\u05d9\u05e4\u05d9\u05e0\u05d9" },
            { "pkr", "\u05e8\u05d5\u05e4\u05d9 \u05e4\u05e7\u05d9\u05e1\u05d8\u05e0\u05d9" },
            { "pln", "\u05d6\u05dc\u05d5\u05d8\u05d9 \u05e4\u05d5\u05dc\u05e0\u05d9" },
            { "pte", "\u05d0\u05e1\u05e7\u05d5\u05d3\u05d5 \u05e4\u05d5\u05e8\u05d8\u05d5\u05d2\u05dc\u05d9" },
            { "pyg", "\u05d2\u05d5\u05d0\u05e8\u05e0\u05d9 \u05e4\u05e8\u05d2\u05d5\u05d5\u05d0\u05d9" },
            { "qar", "\u05e8\u05d9\u05d0\u05dc \u05e7\u05d8\u05d0\u05e8\u05d9" },
            { "rol", "\u05dc\u05d0\u05d5 \u05e8\u05d5\u05de\u05e0\u05d9 \u05d9\u05e9\u05df" },
            { "ron", "\u05dc\u05d0\u05d5 \u05e8\u05d5\u05de\u05e0\u05d9" },
            { "rsd", "\u05d3\u05d9\u05e0\u05e8 \u05e1\u05e8\u05d1\u05d9" },
            { "rub", "\u05e8\u05d5\u05d1\u05dc \u05e8\u05d5\u05e1\u05d9" },
            { "rur", "\u05e8\u05d5\u05d1\u05dc \u05e8\u05d5\u05e1\u05d9 (1991 \u2013 1998)" },
            { "rwf", "\u05e4\u05e8\u05e0\u05e7 \u05e8\u05d5\u05d0\u05e0\u05d3\u05d9" },
            { "sar", "\u05e8\u05d9\u05d0\u05dc \u05e1\u05e2\u05d5\u05d3\u05d9" },
            { "sbd", "\u05d3\u05d5\u05dc\u05e8 \u05d0\u05d9\u05d9 \u05e9\u05dc\u05de\u05d4" },
            { "scr", "\u05e8\u05d5\u05e4\u05d9 \u05e1\u05d9\u05d9\u05e9\u05dc\u05d9" },
            { "sdd", "\u05d3\u05d9\u05e0\u05e8 \u05e1\u05d5\u05d3\u05e0\u05d9" },
            { "sdg", "\u05dc\u05d9\u05e8\u05d4 \u05e1\u05d5\u05d3\u05e0\u05d9\u05ea" },
            { "sdp", "\u05dc\u05d9\u05e8\u05d4 \u05e1\u05d5\u05d3\u05e0\u05d9\u05ea (1957\u20131998)" },
            { "sek", "\u05db\u05ea\u05e8 \u05e9\u05d5\u05d5\u05d3\u05d9" },
            { "sgd", "\u05d3\u05d5\u05dc\u05e8 \u05e1\u05d9\u05e0\u05d2\u05e4\u05d5\u05e8\u05d9" },
            { "shp", "\u05e4\u05d0\u05d5\u05e0\u05d3 \u05e1\u05e0\u05d8 \u05d4\u05dc\u05e0\u05d9" },
            { "sit", "\u05d8\u05d5\u05dc\u05d0\u05e8 \u05e1\u05dc\u05d5\u05d1\u05e0\u05d9" },
            { "skk", "\u05e7\u05d5\u05e8\u05d5\u05e0\u05d4 \u05e1\u05dc\u05d5\u05d1\u05e7\u05d9" },
            { "sll", "\u05dc\u05d9\u05d0\u05d5\u05df \u05e1\u05d9\u05d9\u05e8\u05d4 \u05dc\u05d0\u05d5\u05e0\u05d9" },
            { "sos", "\u05e9\u05d9\u05dc\u05d9\u05e0\u05d2 \u05e1\u05d5\u05de\u05dc\u05d9" },
            { "srd", "\u05d3\u05d5\u05dc\u05e8 \u05e1\u05d5\u05e8\u05d9\u05e0\u05d0\u05de\u05d9" },
            { "srg", "\u05d2\u05d9\u05dc\u05d3\u05e8 \u05e1\u05d5\u05e8\u05d9\u05e0\u05d0\u05de\u05d9" },
            { "ssp", "\u05dc\u05d9\u05e8\u05d4 \u05d3\u05e8\u05d5\u05dd-\u05e1\u05d5\u05d3\u05e0\u05d9\u05ea" },
            { "std", "\u05d3\u05d5\u05d1\u05e8\u05d4 \u05e9\u05dc \u05e1\u05df \u05d8\u05d5\u05de\u05d4 \u05d5\u05e4\u05e8\u05d9\u05e0\u05e1\u05d9\u05e4\u05d4 (1977\u20132017)" },
            { "stn", "\u05d3\u05d5\u05d1\u05e8\u05d4 \u05e9\u05dc \u05e1\u05d0\u05d5 \u05d8\u05d5\u05de\u05d4 \u05d5\u05e4\u05e8\u05d9\u05e0\u05e1\u05d9\u05e4\u05d4" },
            { "sur", "\u05e8\u05d5\u05d1\u05dc \u05e1\u05d5\u05d1\u05d9\u05d9\u05d8\u05d9" },
            { "svc", "\u05e7\u05d5\u05dc\u05d5\u05df \u05e1\u05dc\u05d1\u05d3\u05d5\u05e8\u05d9" },
            { "syp", "\u05dc\u05d9\u05e8\u05d4 \u05e1\u05d5\u05e8\u05d9\u05ea" },
            { "szl", "\u05dc\u05d9\u05dc\u05e0\u05d2\u05e0\u05d9 \u05e1\u05d5\u05d5\u05d6\u05d9\u05dc\u05e0\u05d3\u05d9" },
            { "thb", "\u05d1\u05d4\u05d8 \u05ea\u05d0\u05d9\u05dc\u05e0\u05d3\u05d9" },
            { "tjs", "\u05e1\u05d5\u05de\u05d5\u05e0\u05d9 \u05d8\u05d2\u05f3\u05e7\u05d9\u05e1\u05d8\u05e0\u05d9" },
            { "tmm", "\u05de\u05e0\u05d0\u05d8 \u05d8\u05d5\u05e8\u05e7\u05de\u05d0\u05e0\u05d9" },
            { "tmt", "\u05de\u05d0\u05e0\u05d0\u05d8 \u05d8\u05d5\u05e8\u05e7\u05de\u05e0\u05d9" },
            { "tnd", "\u05d3\u05d9\u05e0\u05e8 \u05d8\u05d5\u05e0\u05d9\u05e1\u05d0\u05d9" },
            { "top", "\u05e4\u05d0\u05e0\u05d2\u05d4 \u05d8\u05d5\u05e0\u05d2\u05d9" },
            { "tpe", "\u05d0\u05e1\u05e7\u05d5\u05d3\u05d5 \u05d8\u05d9\u05de\u05d5\u05e8\u05d0\u05d9" },
            { "trl", "\u05dc\u05d9\u05e8\u05d4 \u05d8\u05d5\u05e8\u05e7\u05d9\u05ea" },
            { "try", "\u05dc\u05d9\u05e8\u05d4 \u05d8\u05d5\u05e8\u05e7\u05d9\u05ea \u05d7\u05d3\u05e9\u05d4" },
            { "ttd", "\u05d3\u05d5\u05dc\u05e8 \u05d8\u05e8\u05d9\u05e0\u05d9\u05d3\u05d3\u05d9" },
            { "twd", "\u05d3\u05d5\u05dc\u05e8 \u05d8\u05d9\u05d9\u05d5\u05d5\u05d0\u05e0\u05d9 \u05d7\u05d3\u05e9" },
            { "tzs", "\u05e9\u05d9\u05dc\u05d9\u05e0\u05d2 \u05d8\u05e0\u05d6\u05e0\u05d9" },
            { "uah", "\u05d4\u05e8\u05d9\u05d1\u05e0\u05d4 \u05d0\u05d5\u05e7\u05e8\u05d0\u05d9\u05e0\u05d9" },
            { "ugs", "\u05e9\u05d9\u05dc\u05d9\u05e0\u05d2 \u05d0\u05d5\u05d2\u05e0\u05d3\u05d9 (1966 \u2013 1987)" },
            { "ugx", "\u05e9\u05d9\u05dc\u05d9\u05e0\u05d2 \u05d0\u05d5\u05d2\u05e0\u05d3\u05d9" },
            { "usd", "\u05d3\u05d5\u05dc\u05e8 \u05d0\u05de\u05e8\u05d9\u05e7\u05d0\u05d9" },
            { "usn", "\u05d3\u05d5\u05dc\u05e8 \u05d0\u05de\u05e8\u05d9\u05e7\u05d0\u05d9 (\u05d4\u05d9\u05d5\u05dd \u05d4\u05d1\u05d0)" },
            { "uss", "\u05d3\u05d5\u05dc\u05e8 \u05d0\u05de\u05e8\u05d9\u05e7\u05d0\u05d9 (\u05d4\u05d9\u05d5\u05dd \u05d4\u05d6\u05d4)" },
            { "uyu", "\u05e4\u05e1\u05d5 \u05d0\u05d5\u05e8\u05d5\u05d2\u05d5\u05d5\u05d0\u05d9" },
            { "uzs", "\u05e1\u05d5\u05dd \u05d0\u05d5\u05d6\u05d1\u05e7\u05d9" },
            { "veb", "\u05d1\u05d5\u05dc\u05d9\u05d1\u05e8 \u05d5\u05e0\u05e6\u05d5\u05d0\u05dc\u05d9 (1871\u20132008)" },
            { "vef", "\u05d1\u05d5\u05dc\u05d9\u05d1\u05e8 \u05d5\u05e0\u05e6\u05d5\u05d0\u05dc\u05d9 (2008\u20132018)" },
            { "ves", "\u05d1\u05d5\u05dc\u05d9\u05d1\u05e8 \u05d5\u05e0\u05e6\u05d5\u05d0\u05dc\u05d9" },
            { "vnd", "\u05d3\u05d5\u05e0\u05d2 \u05d5\u05d9\u05d9\u05d8\u05e0\u05d0\u05de\u05d9" },
            { "vuv", "\u05d5\u05d0\u05d8\u05d5 \u05e9\u05dc \u05d5\u05e0\u05d5\u05d0\u05d8\u05d5" },
            { "wst", "\u05d8\u05d0\u05dc\u05d4 \u05e1\u05de\u05d5\u05d0\u05d9" },
            { "xaf", "\u05e4\u05e8\u05e0\u05e7 CFA \u05de\u05e8\u05db\u05d6 \u05d0\u05e4\u05e8\u05d9\u05e7\u05e0\u05d9" },
            { "xag", "\u05db\u05e1\u05e3" },
            { "xau", "\u05d6\u05d4\u05d1" },
            { "xcd", "\u05d3\u05d5\u05dc\u05e8 \u05de\u05d6\u05e8\u05d7 \u05e7\u05e8\u05d9\u05d1\u05d9" },
            { "xdr", "\u05d6\u05db\u05d5\u05d9\u05d5\u05ea \u05de\u05e9\u05d9\u05db\u05d4 \u05de\u05d9\u05d5\u05d7\u05d3\u05d5\u05ea" },
            { "xfo", "\u05e4\u05e8\u05e0\u05e7 \u05d6\u05d4\u05d1" },
            { "xof", "\u05e4\u05e8\u05e0\u05e7 CFA \u05de\u05e2\u05e8\u05d1 \u05d0\u05e4\u05e8\u05d9\u05e7\u05e0\u05d9" },
            { "xpd", "\u05e4\u05dc\u05d3\u05d9\u05d5\u05dd" },
            { "xpf", "\u05e4\u05e8\u05e0\u05e7 \u05e4\u05d5\u05dc\u05d9\u05e0\u05d6\u05d9\u05d4 \u05d4\u05e6\u05e8\u05e4\u05ea\u05d9\u05ea" },
            { "xpt", "\u05e4\u05dc\u05d8\u05d9\u05e0\u05d4" },
            { "xts", "\u05e1\u05d9\u05de\u05d5\u05df \u05dc\u05de\u05d8\u05e8\u05d5\u05ea \u05d1\u05d3\u05d9\u05e7\u05d4" },
            { "xxx", "\u05de\u05d8\u05d1\u05e2 \u05e9\u05d0\u05d9\u05e0\u05d5 \u05d9\u05d3\u05d5\u05e2" },
            { "ydd", "\u05d3\u05d9\u05e0\u05e8 \u05ea\u05d9\u05de\u05e0\u05d9" },
            { "yer", "\u05e8\u05d9\u05d0\u05dc \u05ea\u05d9\u05de\u05e0\u05d9" },
            { "zal", "\u05e8\u05d0\u05e0\u05d3 \u05d3\u05e8\u05d5\u05dd \u05d0\u05e4\u05e8\u05d9\u05e7\u05d0\u05d9 (\u05db\u05e1\u05e4\u05d9)" },
            { "zar", "\u05e8\u05d0\u05e0\u05d3 \u05d3\u05e8\u05d5\u05dd \u05d0\u05e4\u05e8\u05d9\u05e7\u05d0\u05d9" },
            { "zmk", "\u05e7\u05d5\u05d5\u05d0\u05e6\u05f3\u05d4 \u05d6\u05de\u05d1\u05d9\u05ea (1968\u20132012)" },
            { "zmw", "\u05e7\u05d5\u05d5\u05d0\u05e6\u05f3\u05d4 \u05d6\u05de\u05d1\u05d9" },
            { "zrn", "\u05d6\u05d0\u05d9\u05e8 \u05d7\u05d3\u05e9" },
            { "zwd", "\u05d3\u05d5\u05dc\u05e8 \u05d6\u05d9\u05de\u05d1\u05d1\u05d5\u05d0\u05d9" },
        };
        return data;
    }
}
