/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DistributedManager;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.security.DeployXmlPermission;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.FailedContext;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jakartaee.Migration;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class HostConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(HostConfig.class);
    protected static final StringManager sm = StringManager.getManager(HostConfig.class);
    protected static final long FILE_MODIFICATION_RESOLUTION_MS = 1000L;
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected Host host = null;
    protected ObjectName oname = null;
    protected boolean deployXML = false;
    protected boolean copyXML = false;
    protected boolean unpackWARs = false;
    protected final Map<String, DeployedApplication> deployed = new ConcurrentHashMap<String, DeployedApplication>();
    private Set<String> servicedSet = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Digester digester = HostConfig.createDigester(this.contextClass);
    private final Object digesterLock = new Object();
    protected final Set<String> invalidWars = new HashSet<String>();

    public String getContextClass() {
        return this.contextClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextClass(String string) {
        String string2 = this.contextClass;
        this.contextClass = string;
        if (!string2.equals(string)) {
            Object object = this.digesterLock;
            synchronized (object) {
                this.digester = HostConfig.createDigester(this.getContextClass());
            }
        }
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean bl) {
        this.deployXML = bl;
    }

    private boolean isDeployThisXML(File file, ContextName contextName) {
        Policy policy;
        boolean bl = this.isDeployXML();
        if (Globals.IS_SECURITY_ENABLED && !bl && (policy = Policy.getPolicy()) != null) {
            try {
                URL uRL = file.toURI().toURL();
                CodeSource codeSource = new CodeSource(uRL, (Certificate[])null);
                PermissionCollection permissionCollection = policy.getPermissions(codeSource);
                DeployXmlPermission deployXmlPermission = new DeployXmlPermission(contextName.getBaseName());
                if (permissionCollection.implies(deployXmlPermission)) {
                    bl = true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                log.warn((Object)sm.getString("hostConfig.docBaseUrlInvalid"), (Throwable)malformedURLException);
            }
        }
        return bl;
    }

    public boolean isCopyXML() {
        return this.copyXML;
    }

    public void setCopyXML(boolean bl) {
        this.copyXML = bl;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean bl) {
        this.unpackWARs = bl;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            this.host = (Host)lifecycleEvent.getLifecycle();
            if (this.host instanceof StandardHost) {
                this.setCopyXML(((StandardHost)this.host).isCopyXML());
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
                this.setContextClass(((StandardHost)this.host).getContextClass());
            }
        }
        catch (ClassCastException classCastException) {
            log.error((Object)sm.getString("hostConfig.cce", new Object[]{lifecycleEvent.getLifecycle()}), (Throwable)classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("periodic")) {
            this.check();
        } else if (lifecycleEvent.getType().equals("before_start")) {
            this.beforeStart();
        } else if (lifecycleEvent.getType().equals("start")) {
            this.start();
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stop();
        }
    }

    public boolean tryAddServiced(String string) {
        return this.servicedSet.add(string);
    }

    public void removeServiced(String string) {
        this.servicedSet.remove(string);
    }

    public long getDeploymentTime(String string) {
        DeployedApplication deployedApplication = this.deployed.get(string);
        if (deployedApplication == null) {
            return 0L;
        }
        return deployedApplication.timestamp;
    }

    public boolean isDeployed(String string) {
        return this.deployed.containsKey(string);
    }

    protected static Digester createDigester(String string) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("Context", string, "className");
        digester.addSetProperties("Context");
        return digester;
    }

    protected File returnCanonicalPath(String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.host.getCatalinaBase(), string);
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public String getConfigBaseName() {
        return this.host.getConfigBaseFile().getAbsolutePath();
    }

    protected void deployApps() {
        this.migrateLegacyApps();
        File file = this.host.getAppBaseFile();
        File file2 = this.host.getConfigBaseFile();
        String[] stringArray = this.filterAppPaths(file.list());
        this.deployDescriptors(file2, file2.list());
        this.deployWARs(file, stringArray);
        this.deployDirectories(file, stringArray);
    }

    protected String[] filterAppPaths(String[] stringArray) {
        Pattern pattern = this.host.getDeployIgnorePattern();
        if (pattern == null || stringArray == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = null;
        for (String string : stringArray) {
            if (matcher == null) {
                matcher = pattern.matcher(string);
            } else {
                matcher.reset(string);
            }
            if (matcher.matches()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("hostConfig.ignorePath", new Object[]{string}));
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    protected void deployApps(String string) {
        File file = this.host.getAppBaseFile();
        File file2 = this.host.getConfigBaseFile();
        ContextName contextName = new ContextName(string, false);
        String string2 = contextName.getBaseName();
        if (this.deploymentExists(contextName.getName())) {
            return;
        }
        File file3 = new File(file2, string2 + ".xml");
        if (file3.exists()) {
            this.deployDescriptor(contextName, file3);
            return;
        }
        File file4 = new File(file, string2 + ".war");
        if (file4.exists()) {
            this.deployWAR(contextName, file4);
            return;
        }
        File file5 = new File(file, string2);
        if (file5.exists()) {
            this.deployDirectory(contextName, file5);
        }
    }

    protected void deployDescriptors(File file, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        ExecutorService executorService = this.host.getStartStopExecutor();
        ArrayList arrayList = new ArrayList();
        for (String string : stringArray) {
            ContextName contextName;
            File file2 = new File(file, string);
            if (!string.toLowerCase(Locale.ENGLISH).endsWith(".xml") || !this.tryAddServiced((contextName = new ContextName(string, true)).getName())) continue;
            try {
                if (this.deploymentExists(contextName.getName())) {
                    this.removeServiced(contextName.getName());
                    continue;
                }
                arrayList.add(executorService.submit(new DeployDescriptor(this, contextName, file2)));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.removeServiced(contextName.getName());
                throw throwable;
            }
        }
        for (Future future : arrayList) {
            try {
                future.get();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("hostConfig.deployDescriptor.threaded.error"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDescriptor(ContextName contextName, File file) {
        Serializable serializable;
        DeployedApplication deployedApplication = new DeployedApplication(contextName.getName(), true);
        long l = 0L;
        if (log.isInfoEnabled()) {
            l = System.currentTimeMillis();
            log.info((Object)sm.getString("hostConfig.deployDescriptor", new Object[]{file.getAbsolutePath()}));
        }
        Context context = null;
        boolean bl = false;
        boolean bl2 = false;
        File file2 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            serializable = this.digesterLock;
            synchronized (serializable) {
                try {
                    context = (Context)this.digester.parse((InputStream)fileInputStream);
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("hostConfig.deployDescriptor.error", new Object[]{file.getAbsolutePath()}), (Throwable)exception);
                }
                finally {
                    this.digester.reset();
                    if (context == null) {
                        context = new FailedContext();
                    }
                }
            }
            if (context.getPath() != null) {
                log.warn((Object)sm.getString("hostConfig.deployDescriptor.path", new Object[]{context.getPath(), file.getAbsolutePath()}));
            }
            serializable = Class.forName(this.host.getConfigClass());
            LifecycleListener lifecycleListener = (LifecycleListener)((Class)serializable).getConstructor(new Class[0]).newInstance(new Object[0]);
            context.addLifecycleListener(lifecycleListener);
            context.setConfigFile(file.toURI().toURL());
            context.setName(contextName.getName());
            context.setPath(contextName.getPath());
            context.setWebappVersion(contextName.getVersion());
            if (context.getDocBase() != null) {
                File file3 = new File(context.getDocBase());
                if (!file3.isAbsolute()) {
                    file3 = new File(this.host.getAppBaseFile(), context.getDocBase());
                }
                if (!file3.getCanonicalFile().toPath().startsWith(this.host.getAppBaseFile().toPath())) {
                    File file4;
                    File file5;
                    bl2 = true;
                    deployedApplication.redeployResources.put(file.getAbsolutePath(), file.lastModified());
                    deployedApplication.redeployResources.put(file3.getAbsolutePath(), file3.lastModified());
                    if (file3.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                        bl = true;
                    }
                    if ((file5 = new File(this.host.getAppBaseFile(), contextName.getBaseName() + ".war")).exists()) {
                        log.warn((Object)sm.getString("hostConfig.deployDescriptor.hiddenWar", new Object[]{file.getAbsolutePath(), file5.getAbsolutePath()}));
                    }
                    if ((file4 = new File(this.host.getAppBaseFile(), contextName.getBaseName())).exists()) {
                        log.warn((Object)sm.getString("hostConfig.deployDescriptor.hiddenDir", new Object[]{file.getAbsolutePath(), file4.getAbsolutePath()}));
                    }
                } else {
                    log.warn((Object)sm.getString("hostConfig.deployDescriptor.localDocBaseSpecified", new Object[]{file3}));
                    context.setDocBase(null);
                }
            }
            this.host.addChild(context);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", new Object[]{file.getAbsolutePath()}), throwable);
        }
        finally {
            boolean bl3;
            file2 = new File(this.host.getAppBaseFile(), contextName.getBaseName());
            if (context.getDocBase() != null && !context.getDocBase().toLowerCase(Locale.ENGLISH).endsWith(".war") && !(file2 = new File(context.getDocBase())).isAbsolute()) {
                file2 = new File(this.host.getAppBaseFile(), context.getDocBase());
            }
            if ((bl3 = this.unpackWARs) && context instanceof StandardContext) {
                bl3 = ((StandardContext)context).getUnpackWAR();
            }
            if (bl) {
                if (bl3) {
                    deployedApplication.redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
                    this.addWatchedResources(deployedApplication, file2.getAbsolutePath(), context);
                } else {
                    this.addWatchedResources(deployedApplication, null, context);
                }
            } else {
                if (!bl2) {
                    serializable = new File(file2.getAbsolutePath() + ".war");
                    if (((File)serializable).exists()) {
                        deployedApplication.redeployResources.put(((File)serializable).getAbsolutePath(), ((File)serializable).lastModified());
                    } else {
                        deployedApplication.redeployResources.put(((File)serializable).getAbsolutePath(), 0L);
                    }
                }
                if (bl3) {
                    deployedApplication.redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
                    this.addWatchedResources(deployedApplication, file2.getAbsolutePath(), context);
                } else {
                    this.addWatchedResources(deployedApplication, null, context);
                }
                if (!bl2) {
                    deployedApplication.redeployResources.put(file.getAbsolutePath(), file.lastModified());
                }
            }
            this.addGlobalRedeployResources(deployedApplication);
        }
        if (this.host.findChild(context.getName()) != null) {
            this.deployed.put(context.getName(), deployedApplication);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.deployDescriptor.finished", new Object[]{file.getAbsolutePath(), System.currentTimeMillis() - l}));
        }
    }

    protected void deployWARs(File file, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        ExecutorService executorService = this.host.getStartStopExecutor();
        ArrayList arrayList = new ArrayList();
        for (String string : stringArray) {
            ContextName contextName;
            if (string.equalsIgnoreCase("META-INF") || string.equalsIgnoreCase("WEB-INF")) continue;
            File file2 = new File(file, string);
            if (!string.toLowerCase(Locale.ENGLISH).endsWith(".war") || !file2.isFile() || this.invalidWars.contains(string) || !this.tryAddServiced((contextName = new ContextName(string, true)).getName())) continue;
            try {
                if (this.deploymentExists(contextName.getName())) {
                    DeployedApplication deployedApplication = this.deployed.get(contextName.getName());
                    boolean bl = this.unpackWARs;
                    if (bl && this.host.findChild(contextName.getName()) instanceof StandardContext) {
                        bl = ((StandardContext)this.host.findChild(contextName.getName())).getUnpackWAR();
                    }
                    if (!bl && deployedApplication != null) {
                        File file3 = new File(file, contextName.getBaseName());
                        if (file3.exists()) {
                            if (!deployedApplication.loggedDirWarning) {
                                log.warn((Object)sm.getString("hostConfig.deployWar.hiddenDir", new Object[]{file3.getAbsoluteFile(), file2.getAbsoluteFile()}));
                                deployedApplication.loggedDirWarning = true;
                            }
                        } else {
                            deployedApplication.loggedDirWarning = false;
                        }
                    }
                    this.removeServiced(contextName.getName());
                    continue;
                }
                if (!this.validateContextPath(file, contextName.getBaseName())) {
                    log.error((Object)sm.getString("hostConfig.illegalWarName", new Object[]{string}));
                    this.invalidWars.add(string);
                    this.removeServiced(contextName.getName());
                    continue;
                }
                arrayList.add(executorService.submit(new DeployWar(this, contextName, file2)));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.removeServiced(contextName.getName());
                throw throwable;
            }
        }
        for (Future future : arrayList) {
            try {
                future.get();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("hostConfig.deployWar.threaded.error"), (Throwable)exception);
            }
        }
    }

    private boolean validateContextPath(File file, String string) {
        StringBuilder stringBuilder;
        String string2 = null;
        try {
            String string3 = file.getCanonicalPath();
            stringBuilder = new StringBuilder(string3);
            if (string3.endsWith(File.separator)) {
                stringBuilder.append(string.substring(1).replace('/', File.separatorChar));
            } else {
                stringBuilder.append(string.replace('/', File.separatorChar));
            }
            string2 = new File(stringBuilder.toString()).getCanonicalPath();
            if (string2.endsWith(File.separator)) {
                stringBuilder.append(File.separator);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return string2.equals(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWAR(ContextName contextName, File file) {
        Object object;
        Object object2;
        InputStream inputStream;
        JarEntry jarEntry;
        Object object3;
        boolean bl;
        Object object4;
        boolean bl2;
        File file2;
        block85: {
            file2 = new File(this.host.getAppBaseFile(), contextName.getBaseName() + "/META-INF/context.xml");
            File file3 = new File(this.host.getAppBaseFile(), contextName.getBaseName() + "/META-INF/war-tracker");
            bl2 = false;
            try (JarFile jarFile = new JarFile(file);){
                object4 = jarFile.getJarEntry("META-INF/context.xml");
                if (object4 != null) {
                    bl2 = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean bl3 = false;
            if (file2.exists() && this.unpackWARs && (!file3.exists() || file3.lastModified() == file.lastModified())) {
                bl3 = true;
            }
            object4 = null;
            bl = this.isDeployThisXML(file, contextName);
            try {
                Object object5;
                if (bl && bl3 && !this.copyXML) {
                    object5 = this.digesterLock;
                    synchronized (object5) {
                        try {
                            object4 = (Context)this.digester.parse(file2);
                        }
                        catch (Exception exception) {
                            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", new Object[]{file.getAbsolutePath()}), (Throwable)exception);
                        }
                        finally {
                            this.digester.reset();
                            if (object4 == null) {
                                object4 = new FailedContext();
                            }
                        }
                    }
                    object4.setConfigFile(file2.toURI().toURL());
                    break block85;
                }
                if (bl && bl2) {
                    object5 = this.digesterLock;
                    synchronized (object5) {
                        try {
                            object3 = new JarFile(file);
                            try {
                                jarEntry = ((JarFile)object3).getJarEntry("META-INF/context.xml");
                                inputStream = ((JarFile)object3).getInputStream(jarEntry);
                                try {
                                    object4 = (Context)this.digester.parse(inputStream);
                                }
                                finally {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                            }
                            finally {
                                ((ZipFile)object3).close();
                            }
                        }
                        catch (Exception exception) {
                            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", new Object[]{file.getAbsolutePath()}), (Throwable)exception);
                        }
                        finally {
                            this.digester.reset();
                            if (object4 == null) {
                                object4 = new FailedContext();
                            }
                            object4.setConfigFile(UriUtil.buildJarUrl((File)file, (String)"META-INF/context.xml"));
                        }
                        break block85;
                    }
                }
                if (!bl && bl2) {
                    log.error((Object)sm.getString("hostConfig.deployDescriptor.blocked", new Object[]{contextName.getPath(), "META-INF/context.xml", new File(this.host.getConfigBaseFile(), contextName.getBaseName() + ".xml")}));
                } else {
                    object4 = (Context)Class.forName(this.contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("hostConfig.deployWar.error", new Object[]{file.getAbsolutePath()}), throwable);
            }
            finally {
                if (object4 == null) {
                    object4 = new FailedContext();
                }
            }
        }
        boolean bl4 = false;
        if (bl) {
            if (this.host instanceof StandardHost) {
                bl4 = ((StandardHost)this.host).isCopyXML();
            }
            if (!bl4 && object4 instanceof StandardContext) {
                bl4 = ((StandardContext)object4).getCopyXML();
            }
            if (bl2 && bl4) {
                file2 = new File(this.host.getConfigBaseFile(), contextName.getBaseName() + ".xml");
                try {
                    object3 = new JarFile(file);
                    try {
                        jarEntry = ((JarFile)object3).getJarEntry("META-INF/context.xml");
                        inputStream = ((JarFile)object3).getInputStream(jarEntry);
                        try {
                            object2 = new FileOutputStream(file2);
                            try {
                                IOTools.flow(inputStream, (OutputStream)object2);
                            }
                            finally {
                                ((OutputStream)object2).close();
                            }
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    finally {
                        ((ZipFile)object3).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        object3 = new DeployedApplication(contextName.getName(), file2.exists() && bl && bl4);
        long l = 0L;
        if (log.isInfoEnabled()) {
            l = System.currentTimeMillis();
            log.info((Object)sm.getString("hostConfig.deployWar", new Object[]{file.getAbsolutePath()}));
        }
        try {
            ((DeployedApplication)object3).redeployResources.put(file.getAbsolutePath(), file.lastModified());
            if (bl && file2.exists() && bl4) {
                ((DeployedApplication)object3).redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
            } else {
                ((DeployedApplication)object3).redeployResources.put(new File(this.host.getConfigBaseFile(), contextName.getBaseName() + ".xml").getAbsolutePath(), 0L);
            }
            object2 = Class.forName(this.host.getConfigClass());
            object = (LifecycleListener)((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
            object4.addLifecycleListener((LifecycleListener)object);
            object4.setName(contextName.getName());
            object4.setPath(contextName.getPath());
            object4.setWebappVersion(contextName.getVersion());
            object4.setDocBase(contextName.getBaseName() + ".war");
            this.host.addChild((Container)object4);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.error((Object)sm.getString("hostConfig.deployWar.error", new Object[]{file.getAbsolutePath()}), throwable);
        }
        finally {
            boolean bl5 = this.unpackWARs;
            if (bl5 && object4 instanceof StandardContext) {
                bl5 = ((StandardContext)object4).getUnpackWAR();
            }
            if (bl5 && object4.getDocBase() != null) {
                object = new File(this.host.getAppBaseFile(), contextName.getBaseName());
                ((DeployedApplication)object3).redeployResources.put(((File)object).getAbsolutePath(), ((File)object).lastModified());
                this.addWatchedResources((DeployedApplication)object3, ((File)object).getAbsolutePath(), (Context)object4);
                if (bl && !bl4 && (bl2 || file2.exists())) {
                    ((DeployedApplication)object3).redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
                }
            } else {
                this.addWatchedResources((DeployedApplication)object3, null, (Context)object4);
            }
            this.addGlobalRedeployResources((DeployedApplication)object3);
        }
        this.deployed.put(contextName.getName(), (DeployedApplication)object3);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.deployWar.finished", new Object[]{file.getAbsolutePath(), System.currentTimeMillis() - l}));
        }
    }

    protected void deployDirectories(File file, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        ExecutorService executorService = this.host.getStartStopExecutor();
        ArrayList arrayList = new ArrayList();
        for (String string : stringArray) {
            ContextName contextName;
            File file2;
            if (string.equalsIgnoreCase("META-INF") || string.equalsIgnoreCase("WEB-INF") || !(file2 = new File(file, string)).isDirectory() || !this.tryAddServiced((contextName = new ContextName(string, false)).getName())) continue;
            try {
                if (this.deploymentExists(contextName.getName())) {
                    this.removeServiced(contextName.getName());
                    continue;
                }
                arrayList.add(executorService.submit(new DeployDirectory(this, contextName, file2)));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.removeServiced(contextName.getName());
                throw throwable;
            }
        }
        for (Future future : arrayList) {
            try {
                future.get();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("hostConfig.deployDir.threaded.error"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDirectory(ContextName contextName, File file) {
        DeployedApplication deployedApplication;
        long l = 0L;
        if (log.isInfoEnabled()) {
            l = System.currentTimeMillis();
            log.info((Object)sm.getString("hostConfig.deployDir", new Object[]{file.getAbsolutePath()}));
        }
        Context context = null;
        File file2 = new File(file, "META-INF/context.xml");
        File file3 = new File(this.host.getConfigBaseFile(), contextName.getBaseName() + ".xml");
        boolean bl = this.isCopyXML();
        boolean bl2 = this.isDeployThisXML(file, contextName);
        try {
            Class<?> clazz;
            if (bl2 && file2.exists()) {
                clazz = this.digesterLock;
                synchronized (clazz) {
                    try {
                        context = (Context)this.digester.parse(file2);
                    }
                    catch (Exception exception) {
                        log.error((Object)sm.getString("hostConfig.deployDescriptor.error", new Object[]{file2}), (Throwable)exception);
                        context = new FailedContext();
                    }
                    finally {
                        this.digester.reset();
                        if (context == null) {
                            context = new FailedContext();
                        }
                    }
                }
                if (!bl && context instanceof StandardContext) {
                    bl = ((StandardContext)context).getCopyXML();
                }
                if (bl) {
                    Files.copy(file2.toPath(), file3.toPath(), new CopyOption[0]);
                    context.setConfigFile(file3.toURI().toURL());
                } else {
                    context.setConfigFile(file2.toURI().toURL());
                }
            } else if (!bl2 && file2.exists()) {
                log.error((Object)sm.getString("hostConfig.deployDescriptor.blocked", new Object[]{contextName.getPath(), file2, file3}));
                context = new FailedContext();
            } else {
                context = (Context)Class.forName(this.contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener lifecycleListener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            context.addLifecycleListener(lifecycleListener);
            context.setName(contextName.getName());
            context.setPath(contextName.getPath());
            context.setWebappVersion(contextName.getVersion());
            context.setDocBase(contextName.getBaseName());
            this.host.addChild(context);
            deployedApplication = new DeployedApplication(contextName.getName(), file2.exists() && bl2 && bl);
        }
        catch (Throwable throwable) {
            try {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("hostConfig.deployDir.error", new Object[]{file.getAbsolutePath()}), throwable);
                deployedApplication = new DeployedApplication(contextName.getName(), file2.exists() && bl2 && bl);
            }
            catch (Throwable throwable2) {
                DeployedApplication deployedApplication2 = new DeployedApplication(contextName.getName(), file2.exists() && bl2 && bl);
                deployedApplication2.redeployResources.put(file.getAbsolutePath() + ".war", 0L);
                deployedApplication2.redeployResources.put(file.getAbsolutePath(), file.lastModified());
                if (bl2 && file2.exists()) {
                    if (bl) {
                        deployedApplication2.redeployResources.put(file3.getAbsolutePath(), file3.lastModified());
                    } else {
                        deployedApplication2.redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
                        deployedApplication2.redeployResources.put(file3.getAbsolutePath(), 0L);
                    }
                } else {
                    deployedApplication2.redeployResources.put(file3.getAbsolutePath(), 0L);
                    if (!file2.exists()) {
                        deployedApplication2.redeployResources.put(file2.getAbsolutePath(), 0L);
                    }
                }
                this.addWatchedResources(deployedApplication2, file.getAbsolutePath(), context);
                this.addGlobalRedeployResources(deployedApplication2);
                throw throwable2;
            }
            deployedApplication.redeployResources.put(file.getAbsolutePath() + ".war", 0L);
            deployedApplication.redeployResources.put(file.getAbsolutePath(), file.lastModified());
            if (bl2 && file2.exists()) {
                if (bl) {
                    deployedApplication.redeployResources.put(file3.getAbsolutePath(), file3.lastModified());
                } else {
                    deployedApplication.redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
                    deployedApplication.redeployResources.put(file3.getAbsolutePath(), 0L);
                }
            } else {
                deployedApplication.redeployResources.put(file3.getAbsolutePath(), 0L);
                if (!file2.exists()) {
                    deployedApplication.redeployResources.put(file2.getAbsolutePath(), 0L);
                }
            }
            this.addWatchedResources(deployedApplication, file.getAbsolutePath(), context);
            this.addGlobalRedeployResources(deployedApplication);
        }
        deployedApplication.redeployResources.put(file.getAbsolutePath() + ".war", 0L);
        deployedApplication.redeployResources.put(file.getAbsolutePath(), file.lastModified());
        if (bl2 && file2.exists()) {
            if (bl) {
                deployedApplication.redeployResources.put(file3.getAbsolutePath(), file3.lastModified());
            } else {
                deployedApplication.redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
                deployedApplication.redeployResources.put(file3.getAbsolutePath(), 0L);
            }
        } else {
            deployedApplication.redeployResources.put(file3.getAbsolutePath(), 0L);
            if (!file2.exists()) {
                deployedApplication.redeployResources.put(file2.getAbsolutePath(), 0L);
            }
        }
        this.addWatchedResources(deployedApplication, file.getAbsolutePath(), context);
        this.addGlobalRedeployResources(deployedApplication);
        this.deployed.put(contextName.getName(), deployedApplication);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.deployDir.finished", new Object[]{file.getAbsolutePath(), System.currentTimeMillis() - l}));
        }
    }

    protected void migrateLegacyApps() {
        File file = this.host.getAppBaseFile();
        File file2 = this.host.getLegacyAppBaseFile();
        if (!file2.isDirectory()) {
            return;
        }
        ExecutorService executorService = this.host.getStartStopExecutor();
        ArrayList arrayList = new ArrayList();
        String[] stringArray = file2.list();
        for (String string : stringArray) {
            ContextName contextName;
            File file3 = new File(file2, string);
            File file4 = new File(file, string);
            if (file3.lastModified() <= file4.lastModified()) continue;
            if (file3.isFile() && file3.getName().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                contextName = new ContextName(string, true);
            } else {
                if (!file3.isDirectory()) continue;
                contextName = new ContextName(string, false);
            }
            if (!this.tryAddServiced(contextName.getBaseName())) continue;
            try {
                arrayList.add(executorService.submit(new MigrateApp(this, contextName, file3, file4)));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.removeServiced(contextName.getName());
                throw throwable;
            }
        }
        for (Future future : arrayList) {
            try {
                future.get();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("hostConfig.migrateApp.threaded.error"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateLegacyApp(File file, File file2) {
        File file3 = null;
        File file4 = null;
        try {
            file3 = File.createTempFile("new", null, this.host.getLegacyAppBaseFile());
            file4 = File.createTempFile("old", null, this.host.getLegacyAppBaseFile());
            Files.delete(file3.toPath());
            Files.delete(file4.toPath());
            Migration migration = new Migration();
            migration.setSource(file);
            migration.setDestination(file3);
            migration.execute();
            if (file2.exists()) {
                Files.move(file2.toPath(), file4.toPath(), new CopyOption[0]);
            }
            Files.move(file3.toPath(), file2.toPath(), new CopyOption[0]);
            ExpandWar.delete(file4);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("hostConfig.migrateError"), throwable);
        }
        finally {
            if (file3 != null && file3.exists()) {
                ExpandWar.delete(file3);
            }
        }
    }

    protected boolean deploymentExists(String string) {
        return this.deployed.containsKey(string) || this.host.findChild(string) != null;
    }

    protected void addWatchedResources(DeployedApplication deployedApplication, String string, Context context) {
        String[] stringArray;
        File file = null;
        if (string != null && !(file = new File(string)).isAbsolute()) {
            file = new File(this.host.getAppBaseFile(), string);
        }
        for (String string2 : stringArray = context.findWatchedResources()) {
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                if (string != null) {
                    file2 = new File(file, string2);
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Ignoring non-existent WatchedResource '" + file2.getAbsolutePath() + "'"));
                    continue;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Watching WatchedResource '" + file2.getAbsolutePath() + "'"));
            }
            deployedApplication.reloadResources.put(file2.getAbsolutePath(), file2.lastModified());
        }
    }

    protected void addGlobalRedeployResources(DeployedApplication deployedApplication) {
        File file;
        File file2 = new File(this.getConfigBaseName(), "context.xml.default");
        if (file2.isFile()) {
            deployedApplication.redeployResources.put(file2.getAbsolutePath(), file2.lastModified());
        }
        if ((file = this.returnCanonicalPath("conf/context.xml")).isFile()) {
            deployedApplication.redeployResources.put(file.getAbsolutePath(), file.lastModified());
        }
    }

    protected synchronized void checkResources(DeployedApplication deployedApplication, boolean bl) {
        int n;
        String[] stringArray = deployedApplication.redeployResources.keySet().toArray(new String[0]);
        long l = System.currentTimeMillis() - 1000L;
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2 = new File(stringArray[n]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + deployedApplication.name + "] redeploy resource " + (File)stringArray2));
            }
            long l2 = deployedApplication.redeployResources.get(stringArray[n]);
            if (stringArray2.exists() || l2 == 0L) {
                if (stringArray2.lastModified() == l2 || this.host.getAutoDeploy() && stringArray2.lastModified() >= l && !bl) continue;
                if (stringArray2.isDirectory()) {
                    deployedApplication.redeployResources.put(stringArray[n], stringArray2.lastModified());
                    continue;
                }
                if (deployedApplication.hasDescriptor && stringArray2.getName().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                    Context context = (Context)this.host.findChild(deployedApplication.name);
                    String string = context.getDocBase();
                    if (!string.toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                        File file = new File(string);
                        if (!file.isAbsolute()) {
                            file = new File(this.host.getAppBaseFile(), string);
                        }
                        this.reload(deployedApplication, file, stringArray2.getAbsolutePath());
                    } else {
                        this.reload(deployedApplication, null, null);
                    }
                    deployedApplication.redeployResources.put(stringArray[n], stringArray2.lastModified());
                    deployedApplication.timestamp = System.currentTimeMillis();
                    boolean bl2 = this.unpackWARs;
                    if (bl2 && context instanceof StandardContext) {
                        bl2 = ((StandardContext)context).getUnpackWAR();
                    }
                    if (bl2) {
                        this.addWatchedResources(deployedApplication, context.getDocBase(), context);
                    } else {
                        this.addWatchedResources(deployedApplication, null, context);
                    }
                    return;
                }
                this.undeploy(deployedApplication);
                this.deleteRedeployResources(deployedApplication, stringArray, n, false);
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (stringArray2.exists()) continue;
            this.undeploy(deployedApplication);
            this.deleteRedeployResources(deployedApplication, stringArray, n, true);
            return;
        }
        stringArray = deployedApplication.reloadResources.keySet().toArray(new String[0]);
        n = 0;
        for (String string : stringArray) {
            File file = new File(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + deployedApplication.name + "] reload resource " + file));
            }
            long l3 = deployedApplication.reloadResources.get(string);
            if (file.lastModified() != l3 && (!this.host.getAutoDeploy() || file.lastModified() < l || bl) || n != 0) {
                if (n == 0) {
                    this.reload(deployedApplication, null, null);
                    n = 1;
                }
                deployedApplication.reloadResources.put(string, file.lastModified());
            }
            deployedApplication.timestamp = System.currentTimeMillis();
        }
    }

    private void reload(DeployedApplication deployedApplication, File file, String string) {
        Context context;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.reload", new Object[]{deployedApplication.name}));
        }
        if ((context = (Context)this.host.findChild(deployedApplication.name)).getState().isAvailable()) {
            if (file != null && string != null) {
                context.addLifecycleListener(new ExpandedDirectoryRemovalListener(file, string));
            }
            context.reload();
        } else {
            if (file != null && string != null) {
                ExpandWar.delete(file);
                context.setDocBase(string);
            }
            try {
                context.start();
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("hostConfig.context.restart", new Object[]{deployedApplication.name}), (Throwable)exception);
            }
        }
    }

    private void undeploy(DeployedApplication deployedApplication) {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.undeploy", new Object[]{deployedApplication.name}));
        }
        Container container = this.host.findChild(deployedApplication.name);
        try {
            this.host.removeChild(container);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("hostConfig.context.remove", new Object[]{deployedApplication.name}), throwable);
        }
        this.deployed.remove(deployedApplication.name);
    }

    private void deleteRedeployResources(DeployedApplication deployedApplication, String[] stringArray, int n, boolean bl) {
        for (int i = n + 1; i < stringArray.length; ++i) {
            String[] stringArray2 = new File(stringArray[i]);
            if ("context.xml.default".equals(stringArray2.getName()) || !this.isDeletableResource(deployedApplication, (File)stringArray2)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delete " + (File)stringArray2));
            }
            ExpandWar.delete((File)stringArray2);
        }
        if (bl) {
            String[] stringArray3;
            for (String string : stringArray3 = deployedApplication.reloadResources.keySet().toArray(new String[0])) {
                File file = new File(string);
                if ("context.xml.default".equals(file.getName()) || !this.isDeletableResource(deployedApplication, file)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete " + file));
                }
                ExpandWar.delete(file);
            }
        }
    }

    private boolean isDeletableResource(DeployedApplication deployedApplication, File file) {
        String string;
        String string2;
        String string3;
        if (!file.isAbsolute()) {
            log.warn((Object)sm.getString("hostConfig.resourceNotAbsolute", new Object[]{deployedApplication.name, file}));
            return false;
        }
        try {
            string3 = file.getParentFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("hostConfig.canonicalizing", new Object[]{file.getParentFile(), deployedApplication.name}), (Throwable)iOException);
            return false;
        }
        try {
            string2 = this.host.getAppBaseFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("hostConfig.canonicalizing", new Object[]{this.host.getAppBaseFile(), deployedApplication.name}), (Throwable)iOException);
            return false;
        }
        if (string3.equals(string2)) {
            return true;
        }
        try {
            string = this.host.getConfigBaseFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("hostConfig.canonicalizing", new Object[]{this.host.getConfigBaseFile(), deployedApplication.name}), (Throwable)iOException);
            return false;
        }
        return string3.equals(string) && file.getName().endsWith(".xml");
    }

    public void beforeStart() {
        if (this.host.getCreateDirs()) {
            File[] fileArray;
            for (File file : fileArray = new File[]{this.host.getAppBaseFile(), this.host.getConfigBaseFile()}) {
                if (file.mkdirs() || file.isDirectory()) continue;
                log.error((Object)sm.getString("hostConfig.createDirs", new Object[]{file}));
            }
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.start"));
        }
        try {
            ObjectName objectName = this.host.getObjectName();
            this.oname = new ObjectName(objectName.getDomain() + ":type=Deployer,host=" + this.host.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, this.getClass().getName());
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("hostConfig.jmx.register", new Object[]{this.oname}), (Throwable)exception);
        }
        if (!this.host.getAppBaseFile().isDirectory()) {
            log.error((Object)sm.getString("hostConfig.appBase", new Object[]{this.host.getName(), this.host.getAppBaseFile().getPath()}));
            this.host.setDeployOnStartup(false);
            this.host.setAutoDeploy(false);
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.stop"));
        }
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception exception) {
                log.warn((Object)sm.getString("hostConfig.jmx.unregister", new Object[]{this.oname}), (Throwable)exception);
            }
        }
        this.oname = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() {
        if (this.host.getAutoDeploy()) {
            DeployedApplication[] deployedApplicationArray;
            for (DeployedApplication deployedApplication : deployedApplicationArray = this.deployed.values().toArray(new DeployedApplication[0])) {
                if (!this.tryAddServiced(deployedApplication.name)) continue;
                try {
                    this.checkResources(deployedApplication, false);
                }
                finally {
                    this.removeServiced(deployedApplication.name);
                }
            }
            if (this.host.getUndeployOldVersions()) {
                this.checkUndeploy();
            }
            this.deployApps();
        }
    }

    public void check(String string) {
        if (this.tryAddServiced(string)) {
            try {
                DeployedApplication deployedApplication = this.deployed.get(string);
                if (deployedApplication != null) {
                    this.checkResources(deployedApplication, true);
                }
                this.deployApps(string);
            }
            finally {
                this.removeServiced(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkUndeploy() {
        if (this.deployed.size() < 2) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>(this.deployed.keySet());
        Iterator iterator = treeSet.iterator();
        ContextName contextName = new ContextName((String)iterator.next(), false);
        do {
            ContextName contextName2;
            if ((contextName2 = new ContextName((String)iterator.next(), false)).getPath().equals(contextName.getPath())) {
                Context context = (Context)this.host.findChild(contextName.getName());
                Context context2 = (Context)this.host.findChild(contextName2.getName());
                if (context != null && context2 != null && context2.getState().isAvailable() && this.tryAddServiced(contextName.getName())) {
                    try {
                        int n;
                        Manager manager = context.getManager();
                        if (manager != null && (n = manager instanceof DistributedManager ? ((DistributedManager)((Object)manager)).getActiveSessionsFull() : manager.getActiveSessions()) == 0) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)sm.getString("hostConfig.undeployVersion", new Object[]{contextName.getName()}));
                            }
                            DeployedApplication deployedApplication = this.deployed.get(contextName.getName());
                            String[] stringArray = deployedApplication.redeployResources.keySet().toArray(new String[0]);
                            this.undeploy(deployedApplication);
                            this.deleteRedeployResources(deployedApplication, stringArray, -1, true);
                        }
                    }
                    finally {
                        this.removeServiced(contextName.getName());
                    }
                }
            }
            contextName = contextName2;
        } while (iterator.hasNext());
    }

    public void manageApp(Context context) {
        String string = context.getName();
        if (this.deployed.containsKey(string)) {
            return;
        }
        DeployedApplication deployedApplication = new DeployedApplication(string, false);
        boolean bl = false;
        if (context.getDocBase() != null) {
            File file = new File(context.getDocBase());
            if (!file.isAbsolute()) {
                file = new File(this.host.getAppBaseFile(), context.getDocBase());
            }
            deployedApplication.redeployResources.put(file.getAbsolutePath(), file.lastModified());
            if (file.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                bl = true;
            }
        }
        this.host.addChild(context);
        boolean bl2 = this.unpackWARs;
        if (bl2 && context instanceof StandardContext) {
            bl2 = ((StandardContext)context).getUnpackWAR();
        }
        if (bl && bl2) {
            File file = new File(this.host.getAppBaseFile(), context.getBaseName());
            deployedApplication.redeployResources.put(file.getAbsolutePath(), file.lastModified());
            this.addWatchedResources(deployedApplication, file.getAbsolutePath(), context);
        } else {
            this.addWatchedResources(deployedApplication, null, context);
        }
        this.deployed.put(string, deployedApplication);
    }

    public void unmanageApp(String string) {
        this.deployed.remove(string);
        this.host.removeChild(this.host.findChild(string));
    }

    private static class ExpandedDirectoryRemovalListener
    implements LifecycleListener {
        private final File toDelete;
        private final String newDocBase;

        public ExpandedDirectoryRemovalListener(File file, String string) {
            this.toDelete = file;
            this.newDocBase = string;
        }

        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if ("after_stop".equals(lifecycleEvent.getType())) {
                Context context = (Context)lifecycleEvent.getLifecycle();
                ExpandWar.delete(this.toDelete);
                context.setDocBase(this.newDocBase);
                context.removeLifecycleListener(this);
            }
        }
    }

    private static class MigrateApp
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File source;
        private File destination;

        public MigrateApp(HostConfig hostConfig, ContextName contextName, File file, File file2) {
            this.config = hostConfig;
            this.cn = contextName;
            this.source = file;
            this.destination = file2;
        }

        @Override
        public void run() {
            try {
                this.config.migrateLegacyApp(this.source, this.destination);
            }
            finally {
                this.config.removeServiced(this.cn.getName());
            }
        }
    }

    private static class DeployDirectory
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File dir;

        public DeployDirectory(HostConfig hostConfig, ContextName contextName, File file) {
            this.config = hostConfig;
            this.cn = contextName;
            this.dir = file;
        }

        @Override
        public void run() {
            try {
                this.config.deployDirectory(this.cn, this.dir);
            }
            finally {
                this.config.removeServiced(this.cn.getName());
            }
        }
    }

    private static class DeployWar
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File war;

        public DeployWar(HostConfig hostConfig, ContextName contextName, File file) {
            this.config = hostConfig;
            this.cn = contextName;
            this.war = file;
        }

        @Override
        public void run() {
            try {
                this.config.deployWAR(this.cn, this.war);
            }
            finally {
                this.config.removeServiced(this.cn.getName());
            }
        }
    }

    private static class DeployDescriptor
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File descriptor;

        public DeployDescriptor(HostConfig hostConfig, ContextName contextName, File file) {
            this.config = hostConfig;
            this.cn = contextName;
            this.descriptor = file;
        }

        @Override
        public void run() {
            try {
                this.config.deployDescriptor(this.cn, this.descriptor);
            }
            finally {
                this.config.removeServiced(this.cn.getName());
            }
        }
    }

    protected static class DeployedApplication {
        public final String name;
        public final boolean hasDescriptor;
        public final LinkedHashMap<String, Long> redeployResources = new LinkedHashMap();
        public final HashMap<String, Long> reloadResources = new HashMap();
        public long timestamp = System.currentTimeMillis();
        public boolean loggedDirWarning = false;

        public DeployedApplication(String string, boolean bl) {
            this.name = string;
            this.hasDescriptor = bl;
        }
    }
}

