/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.el.ExpressionFactory;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;

class PageInfo {
    private final List<String> imports;
    private final Map<String, Long> dependants;
    private final BeanRepository beanRepository;
    private final Set<String> varInfoNames;
    private final HashMap<String, TagLibraryInfo> taglibsMap;
    private final HashMap<String, String> jspPrefixMapper;
    private final HashMap<String, LinkedList<String>> xmlPrefixMapper;
    private final HashMap<String, Mark> nonCustomTagPrefixMap;
    private final String jspFile;
    private static final String defaultLanguage = "java";
    private String language;
    private final String defaultExtends;
    private String xtends;
    private String contentType = null;
    private String session;
    private boolean isSession = true;
    private String bufferValue;
    private int buffer = 8192;
    private String autoFlush;
    private boolean isAutoFlush = true;
    private String isThreadSafeValue;
    private boolean isThreadSafe = true;
    private String isErrorPageValue;
    private boolean isErrorPage = false;
    private String errorPage = null;
    private String info;
    private boolean scriptless = false;
    private boolean scriptingInvalid = false;
    private String isELIgnoredValue;
    private boolean isELIgnored = false;
    private String deferredSyntaxAllowedAsLiteralValue;
    private boolean deferredSyntaxAllowedAsLiteral = false;
    private final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();
    private String trimDirectiveWhitespacesValue;
    private boolean trimDirectiveWhitespaces = false;
    private String omitXmlDecl = null;
    private String doctypeName = null;
    private String doctypePublic = null;
    private String doctypeSystem = null;
    private boolean isJspPrefixHijacked;
    private final HashSet<String> prefixes;
    private boolean hasJspRoot = false;
    private Collection<String> includePrelude;
    private Collection<String> includeCoda;
    private final List<String> pluginDcls;
    private boolean errorOnUndeclaredNamespace = false;
    private String errorOnELNotFoundValue;
    private boolean errorOnELNotFound = false;
    private final boolean isTagFile;

    PageInfo(BeanRepository beanRepository, JspCompilationContext jspCompilationContext) {
        this.isTagFile = jspCompilationContext.isTagFile();
        this.jspFile = jspCompilationContext.getJspFile();
        this.defaultExtends = jspCompilationContext.getOptions().getJspServletBase();
        this.beanRepository = beanRepository;
        this.varInfoNames = new HashSet<String>();
        this.taglibsMap = new HashMap();
        this.jspPrefixMapper = new HashMap();
        this.xmlPrefixMapper = new HashMap();
        this.nonCustomTagPrefixMap = new HashMap();
        this.dependants = new HashMap<String, Long>();
        this.includePrelude = new ArrayList<String>();
        this.includeCoda = new ArrayList<String>();
        this.pluginDcls = new ArrayList<String>();
        this.prefixes = new HashSet();
        this.imports = new ArrayList<String>(Constants.STANDARD_IMPORTS);
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public boolean isPluginDeclared(String string) {
        if (this.pluginDcls.contains(string)) {
            return true;
        }
        this.pluginDcls.add(string);
        return false;
    }

    public void addImports(List<String> list) {
        this.imports.addAll(list);
    }

    public void addImport(String string) {
        this.imports.add(string);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void addDependant(String string, Long l) {
        if (!this.dependants.containsKey(string) && !this.jspFile.equals(string)) {
            this.dependants.put(string, l);
        }
    }

    public Map<String, Long> getDependants() {
        return this.dependants;
    }

    public BeanRepository getBeanRepository() {
        return this.beanRepository;
    }

    public void setScriptless(boolean bl) {
        this.scriptless = bl;
    }

    public boolean isScriptless() {
        return this.scriptless;
    }

    public void setScriptingInvalid(boolean bl) {
        this.scriptingInvalid = bl;
    }

    public boolean isScriptingInvalid() {
        return this.scriptingInvalid;
    }

    public Collection<String> getIncludePrelude() {
        return this.includePrelude;
    }

    public void setIncludePrelude(Collection<String> collection) {
        this.includePrelude = collection;
    }

    public Collection<String> getIncludeCoda() {
        return this.includeCoda;
    }

    public void setIncludeCoda(Collection<String> collection) {
        this.includeCoda = collection;
    }

    public void setHasJspRoot(boolean bl) {
        this.hasJspRoot = bl;
    }

    public boolean hasJspRoot() {
        return this.hasJspRoot;
    }

    public String getOmitXmlDecl() {
        return this.omitXmlDecl;
    }

    public void setOmitXmlDecl(String string) {
        this.omitXmlDecl = string;
    }

    public String getDoctypeName() {
        return this.doctypeName;
    }

    public void setDoctypeName(String string) {
        this.doctypeName = string;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String string) {
        this.doctypeSystem = string;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String string) {
        this.doctypePublic = string;
    }

    public void setIsJspPrefixHijacked(boolean bl) {
        this.isJspPrefixHijacked = bl;
    }

    public boolean isJspPrefixHijacked() {
        return this.isJspPrefixHijacked;
    }

    public void addPrefix(String string) {
        this.prefixes.add(string);
    }

    public boolean containsPrefix(String string) {
        return this.prefixes.contains(string);
    }

    public void addTaglib(String string, TagLibraryInfo tagLibraryInfo) {
        this.taglibsMap.put(string, tagLibraryInfo);
    }

    public TagLibraryInfo getTaglib(String string) {
        return this.taglibsMap.get(string);
    }

    public Collection<TagLibraryInfo> getTaglibs() {
        return this.taglibsMap.values();
    }

    public boolean hasTaglib(String string) {
        return this.taglibsMap.containsKey(string);
    }

    public void addPrefixMapping(String string, String string2) {
        this.jspPrefixMapper.put(string, string2);
    }

    public void pushPrefixMapping(String string, String string2) {
        LinkedList<String> linkedList = this.xmlPrefixMapper.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this.xmlPrefixMapper.put(string, linkedList);
        }
        linkedList.addFirst(string2);
    }

    public void popPrefixMapping(String string) {
        LinkedList<String> linkedList = this.xmlPrefixMapper.get(string);
        linkedList.removeFirst();
    }

    public String getURI(String string) {
        String string2 = null;
        LinkedList<String> linkedList = this.xmlPrefixMapper.get(string);
        string2 = linkedList == null || linkedList.size() == 0 ? this.jspPrefixMapper.get(string) : linkedList.getFirst();
        return string2;
    }

    public void setLanguage(String string, Node node, ErrorDispatcher errorDispatcher, boolean bl) throws JasperException {
        if (!defaultLanguage.equalsIgnoreCase(string)) {
            if (bl) {
                errorDispatcher.jspError(node, "jsp.error.page.language.nonjava", new String[0]);
            } else {
                errorDispatcher.jspError(node, "jsp.error.tag.language.nonjava", new String[0]);
            }
        }
        this.language = string;
    }

    public String getLanguage(boolean bl) {
        return this.language == null && bl ? defaultLanguage : this.language;
    }

    public void setExtends(String string) {
        this.xtends = string;
    }

    public String getExtends(boolean bl) {
        return this.xtends == null && bl ? this.defaultExtends : this.xtends;
    }

    public String getExtends() {
        return this.getExtends(true);
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setBufferValue(String string, Node node, ErrorDispatcher errorDispatcher) throws JasperException {
        if ("none".equalsIgnoreCase(string)) {
            this.buffer = 0;
        } else {
            if (string == null || !string.endsWith("kb")) {
                if (node == null) {
                    errorDispatcher.jspError("jsp.error.page.invalid.buffer", new String[0]);
                } else {
                    errorDispatcher.jspError(node, "jsp.error.page.invalid.buffer", new String[0]);
                }
            }
            try {
                int n = Integer.parseInt(string.substring(0, string.length() - 2));
                this.buffer = n * 1024;
            }
            catch (NumberFormatException numberFormatException) {
                if (node == null) {
                    errorDispatcher.jspError("jsp.error.page.invalid.buffer", new String[0]);
                }
                errorDispatcher.jspError(node, "jsp.error.page.invalid.buffer", new String[0]);
            }
        }
        this.bufferValue = string;
    }

    public String getBufferValue() {
        return this.bufferValue;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setSession(String string, Node node, ErrorDispatcher errorDispatcher) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.isSession = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.isSession = false;
        } else {
            errorDispatcher.jspError(node, "jsp.error.page.invalid.session", new String[0]);
        }
        this.session = string;
    }

    public String getSession() {
        return this.session;
    }

    public boolean isSession() {
        return this.isSession;
    }

    public void setAutoFlush(String string, Node node, ErrorDispatcher errorDispatcher) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.isAutoFlush = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.isAutoFlush = false;
        } else {
            errorDispatcher.jspError(node, "jsp.error.autoFlush.invalid", new String[0]);
        }
        this.autoFlush = string;
    }

    public String getAutoFlush() {
        return this.autoFlush;
    }

    public boolean isAutoFlush() {
        return this.isAutoFlush;
    }

    public void setIsThreadSafe(String string, Node node, ErrorDispatcher errorDispatcher) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.isThreadSafe = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.isThreadSafe = false;
        } else {
            errorDispatcher.jspError(node, "jsp.error.page.invalid.isthreadsafe", new String[0]);
        }
        this.isThreadSafeValue = string;
    }

    public String getIsThreadSafe() {
        return this.isThreadSafeValue;
    }

    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void setErrorPage(String string) {
        this.errorPage = string;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setIsErrorPage(String string, Node node, ErrorDispatcher errorDispatcher) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.isErrorPage = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.isErrorPage = false;
        } else {
            errorDispatcher.jspError(node, "jsp.error.page.invalid.iserrorpage", new String[0]);
        }
        this.isErrorPageValue = string;
    }

    public String getIsErrorPage() {
        return this.isErrorPageValue;
    }

    public boolean isErrorPage() {
        return this.isErrorPage;
    }

    public void setIsELIgnored(String string, Node node, ErrorDispatcher errorDispatcher, boolean bl) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.isELIgnored = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.isELIgnored = false;
        } else if (bl) {
            errorDispatcher.jspError(node, "jsp.error.page.invalid.iselignored", new String[0]);
        } else {
            errorDispatcher.jspError(node, "jsp.error.tag.invalid.iselignored", new String[0]);
        }
        this.isELIgnoredValue = string;
    }

    public void setErrorOnELNotFound(String string, Node node, ErrorDispatcher errorDispatcher, boolean bl) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.errorOnELNotFound = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.errorOnELNotFound = false;
        } else if (bl) {
            errorDispatcher.jspError(node, "jsp.error.page.invalid.errorOnELNotFound", new String[0]);
        } else {
            errorDispatcher.jspError(node, "jsp.error.tag.invalid.errorOnELNotFound", new String[0]);
        }
        this.errorOnELNotFoundValue = string;
    }

    public void setDeferredSyntaxAllowedAsLiteral(String string, Node node, ErrorDispatcher errorDispatcher, boolean bl) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.deferredSyntaxAllowedAsLiteral = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.deferredSyntaxAllowedAsLiteral = false;
        } else if (bl) {
            errorDispatcher.jspError(node, "jsp.error.page.invalid.deferredsyntaxallowedasliteral", new String[0]);
        } else {
            errorDispatcher.jspError(node, "jsp.error.tag.invalid.deferredsyntaxallowedasliteral", new String[0]);
        }
        this.deferredSyntaxAllowedAsLiteralValue = string;
    }

    public void setTrimDirectiveWhitespaces(String string, Node node, ErrorDispatcher errorDispatcher, boolean bl) throws JasperException {
        if ("true".equalsIgnoreCase(string)) {
            this.trimDirectiveWhitespaces = true;
        } else if ("false".equalsIgnoreCase(string)) {
            this.trimDirectiveWhitespaces = false;
        } else if (bl) {
            errorDispatcher.jspError(node, "jsp.error.page.invalid.trimdirectivewhitespaces", new String[0]);
        } else {
            errorDispatcher.jspError(node, "jsp.error.tag.invalid.trimdirectivewhitespaces", new String[0]);
        }
        this.trimDirectiveWhitespacesValue = string;
    }

    public void setELIgnored(boolean bl) {
        this.isELIgnored = bl;
    }

    public String getIsELIgnored() {
        return this.isELIgnoredValue;
    }

    public boolean isELIgnored() {
        return this.isELIgnored;
    }

    public void setErrorOnELNotFound(boolean bl) {
        this.errorOnELNotFound = bl;
    }

    public String getErrorOnELNotFound() {
        return this.errorOnELNotFoundValue;
    }

    public boolean isErrorOnELNotFound() {
        return this.errorOnELNotFound;
    }

    public void putNonCustomTagPrefix(String string, Mark mark) {
        this.nonCustomTagPrefixMap.put(string, mark);
    }

    public Mark getNonCustomTagPrefix(String string) {
        return this.nonCustomTagPrefixMap.get(string);
    }

    public String getDeferredSyntaxAllowedAsLiteral() {
        return this.deferredSyntaxAllowedAsLiteralValue;
    }

    public boolean isDeferredSyntaxAllowedAsLiteral() {
        return this.deferredSyntaxAllowedAsLiteral;
    }

    public void setDeferredSyntaxAllowedAsLiteral(boolean bl) {
        this.deferredSyntaxAllowedAsLiteral = bl;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public String getTrimDirectiveWhitespaces() {
        return this.trimDirectiveWhitespacesValue;
    }

    public boolean isTrimDirectiveWhitespaces() {
        return this.trimDirectiveWhitespaces;
    }

    public void setTrimDirectiveWhitespaces(boolean bl) {
        this.trimDirectiveWhitespaces = bl;
    }

    public Set<String> getVarInfoNames() {
        return this.varInfoNames;
    }

    public boolean isErrorOnUndeclaredNamespace() {
        return this.errorOnUndeclaredNamespace;
    }

    public void setErrorOnUndeclaredNamespace(boolean bl) {
        this.errorOnUndeclaredNamespace = bl;
    }
}

