/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.util.HashMap;
import java.util.List;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.Annotations;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;

public class JavaClass {
    private final int accessFlags;
    private final String className;
    private final String superclassName;
    private final String[] interfaceNames;
    private final Annotations runtimeVisibleAnnotations;
    private final List<Annotations> runtimeVisibleFieldOrMethodAnnotations;

    JavaClass(String string, String string2, int n, ConstantPool constantPool, String[] stringArray, Annotations annotations, List<Annotations> list) {
        this.accessFlags = n;
        this.runtimeVisibleAnnotations = annotations;
        this.runtimeVisibleFieldOrMethodAnnotations = list;
        this.className = string;
        this.superclassName = string2;
        this.interfaceNames = stringArray;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.runtimeVisibleAnnotations != null) {
            return this.runtimeVisibleAnnotations.getAnnotationEntries();
        }
        return null;
    }

    public AnnotationEntry[] getAllAnnotationEntries() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.runtimeVisibleAnnotations != null) {
            for (AnnotationEntry object : this.runtimeVisibleAnnotations.getAnnotationEntries()) {
                hashMap.put(object.getAnnotationType(), object);
            }
        }
        if (this.runtimeVisibleFieldOrMethodAnnotations != null) {
            for (Annotations annotations : this.runtimeVisibleFieldOrMethodAnnotations.toArray(new Annotations[0])) {
                for (AnnotationEntry annotationEntry : annotations.getAnnotationEntries()) {
                    hashMap.putIfAbsent(annotationEntry.getAnnotationType(), annotationEntry);
                }
            }
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        return hashMap.values().toArray(new AnnotationEntry[0]);
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public String getSuperclassName() {
        return this.superclassName;
    }
}

