/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.autoupdate.cli.Bundle;
import org.netbeans.modules.autoupdate.cli.PrintTable;
import org.netbeans.modules.autoupdate.cli.Status;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.spi.ProgressUIWorker;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionGroups;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.NbPreferences;

public class ModuleOptions
extends OptionProcessor {
    private static final Logger LOG = Logger.getLogger(ModuleOptions.class.getName());
    private Option list;
    private Option install;
    private Option disable;
    private Option enable;
    private Option update;
    private Option refresh;
    private Option updateAll;
    private Option both;
    private Option extraUC;
    private Collection<UpdateUnitProvider> ownUUP = new HashSet<UpdateUnitProvider>();
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";

    private Option init() {
        if (this.both != null) {
            return this.both;
        }
        String string = "org.netbeans.modules.autoupdate.cli.Bundle";
        this.list = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"list"), (String)string, (String)"MSG_ListModules");
        this.install = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"install"), (String)string, (String)"MSG_InstallModules");
        this.disable = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"disable"), (String)string, (String)"MSG_DisableModules");
        this.enable = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"enable"), (String)string, (String)"MSG_EnableModules");
        this.update = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"update"), (String)string, (String)"MSG_UpdateModules");
        this.refresh = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"refresh"), (String)string, (String)"MSG_Refresh");
        this.updateAll = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"update-all"), (String)string, (String)"MSG_UpdateAll");
        this.extraUC = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"extra-uc"), (String)string, (String)"MSG_ExtraUC");
        Option option = OptionGroups.someOf((Option[])new Option[]{this.refresh, this.list, this.install, this.disable, this.enable, this.update, this.updateAll, this.extraUC});
        Option option2 = Option.withoutArgument((char)'\uffff', (String)"modules");
        this.both = OptionGroups.allOf((Option[])new Option[]{option2, option});
        return this.both;
    }

    public Set<Option> getOptions() {
        return Collections.singleton(this.init());
    }

    private void refresh(Env env) throws CommandException {
        for (UpdateUnitProvider updateUnitProvider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
            try {
                env.getOutputStream().println("Refreshing " + updateUnitProvider.getDisplayName());
                updateUnitProvider.refresh(null, true);
            }
            catch (IOException iOException) {
                throw (CommandException)new CommandException(31, iOException.getMessage()).initCause((Throwable)iOException);
            }
        }
    }

    private void listAllModules(PrintStream printStream) throws IOException {
        List list = UpdateManager.getDefault().getUpdateUnits();
        PrintTable printTable = new PrintTable(Bundle.MSG_ListHeader_CodeName(), Bundle.MSG_ListHeader_Version(), Bundle.MSG_ListHeader_State());
        printTable.setLimits(50, -1, -1);
        for (UpdateUnit updateUnit : list) {
            printTable.addRow(Status.toArray(updateUnit));
        }
        StringBuilder stringBuilder = new StringBuilder();
        printTable.write(stringBuilder);
        printStream.print(stringBuilder.toString());
        printStream.flush();
    }

    private static <T extends Throwable> T initCause(T t, Throwable throwable) {
        t.initCause(throwable);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Env env, Map<Option, String[]> map) throws CommandException {
        try {
            try {
                if (map.containsKey(this.extraUC)) {
                    this.extraUC(env, map.get(this.extraUC));
                }
                if (map.containsKey(this.refresh)) {
                    this.refresh(env);
                }
                if (map.containsKey(this.list)) {
                    this.listAllModules(env.getOutputStream());
                }
                if (map.containsKey(this.install)) {
                    this.install(env, map.get(this.install));
                }
                if (map.containsKey(this.disable)) {
                    this.changeModuleState(map.get(this.disable), false);
                }
                if (map.containsKey(this.enable)) {
                    this.changeModuleState(map.get(this.enable), true);
                }
            }
            catch (InterruptedException interruptedException) {
                throw ModuleOptions.initCause(new CommandException(4), interruptedException);
            }
            catch (IOException iOException) {
                throw ModuleOptions.initCause(new CommandException(4), iOException);
            }
            catch (OperationException operationException) {
                throw ModuleOptions.initCause(new CommandException(4), operationException);
            }
            if (map.containsKey(this.updateAll)) {
                this.updateAll(env);
            }
            if (map.containsKey(this.update)) {
                this.updateModules(env, map.get(this.update));
            }
        }
        finally {
            for (UpdateUnitProvider updateUnitProvider : this.ownUUP) {
                UpdateUnitProviderFactory.getDefault().remove(updateUnitProvider);
            }
        }
    }

    private void changeModuleState(String[] stringArray, boolean bl) throws IOException, CommandException, InterruptedException, OperationException {
        for (String string : stringArray) {
            int n = string.indexOf(47);
            if (n < 0) continue;
            String string2 = string.substring(0, n);
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        List list = UpdateManager.getDefault().getUpdateUnits();
        OperationContainer operationContainer = bl ? OperationContainer.createForEnable() : OperationContainer.createForDisable();
        for (UpdateUnit updateUnit : list) {
            if (!hashSet.contains(updateUnit.getCodeName())) continue;
            if (bl) {
                operationContainer.add(updateUnit, updateUnit.getInstalled());
                continue;
            }
            operationContainer.add(updateUnit, updateUnit.getInstalled());
        }
        OperationSupport operationSupport = (OperationSupport)operationContainer.getSupport();
        operationSupport.doOperation(null);
    }

    private void updateModules(Env env, String ... stringArray) throws CommandException {
        Object object;
        ProgressHandle progressHandle;
        UpdateElement updateElement;
        List list;
        UpdateUnit updateUnit;
        InstallSupport installSupport;
        if (!this.initialized()) {
            this.refresh(env);
        }
        Pattern[] patternArray = ModuleOptions.findMatcher(env, stringArray);
        List list2 = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<String> collection = this.getFirstClassModules();
        boolean bl = false;
        OperationContainer operationContainer = OperationContainer.createForUpdate();
        if (!collection.isEmpty() && stringArray.length == 0) {
            installSupport = list2.iterator();
            while (installSupport.hasNext()) {
                updateUnit = (UpdateUnit)installSupport.next();
                if (updateUnit.getInstalled() == null || (list = updateUnit.getAvailableUpdates()).isEmpty() || !collection.contains(updateUnit.getCodeName())) continue;
                updateElement = (UpdateElement)list.get(0);
                env.getOutputStream().println(Bundle.MSG_Update(updateUnit.getCodeName(), updateUnit.getInstalled().getSpecificationVersion(), updateElement.getSpecificationVersion()));
                if (!operationContainer.canBeAdded(updateUnit, updateElement)) continue;
                LOG.fine("  ... update " + updateUnit.getInstalled() + " -> " + updateElement);
                bl = true;
                progressHandle = operationContainer.add(updateElement);
                if (progressHandle == null) continue;
                object = progressHandle.getRequiredElements();
                LOG.fine("      ... add required elements: " + object);
                operationContainer.add((Collection)object);
            }
        }
        if (!bl) {
            installSupport = list2.iterator();
            while (installSupport.hasNext()) {
                updateUnit = (UpdateUnit)installSupport.next();
                if (updateUnit.getInstalled() == null || (list = updateUnit.getAvailableUpdates()).isEmpty() || stringArray.length > 0 && !ModuleOptions.matches(updateUnit.getCodeName(), patternArray)) continue;
                updateElement = (UpdateElement)list.get(0);
                env.getOutputStream().println(Bundle.MSG_Update(updateUnit.getCodeName(), updateUnit.getInstalled().getSpecificationVersion(), updateElement.getSpecificationVersion()));
                if (!operationContainer.canBeAdded(updateUnit, updateElement)) continue;
                LOG.fine("  ... update " + updateUnit.getInstalled() + " -> " + updateElement);
                progressHandle = operationContainer.add(updateElement);
                if (progressHandle == null) continue;
                object = progressHandle.getRequiredElements();
                LOG.fine("      ... add required elements: " + object);
                operationContainer.add((Collection)object);
            }
        }
        if ((installSupport = (InstallSupport)operationContainer.getSupport()) == null) {
            env.getOutputStream().println(patternArray == null || patternArray.length == 0 ? Bundle.MSG_UpdateNotFound() : Bundle.MSG_UpdateNoMatchPattern(Arrays.asList(patternArray)));
            env.getOutputStream().println("updates=0");
            return;
        }
        env.getOutputStream().println("updates=" + operationContainer.listAll().size());
        updateUnit = new CLIInternalHandle("downloading-updates", env).createProgressHandle();
        updateUnit.setInitialDelay(0);
        try {
            list = installSupport.doDownload((ProgressHandle)updateUnit, null, false);
            updateElement = installSupport.doValidate((InstallSupport.Validator)list, null);
            progressHandle = new CLIInternalHandle("installing-updates", env).createProgressHandle();
            progressHandle.setInitialDelay(0);
            object = installSupport.doInstall((InstallSupport.Installer)updateElement, progressHandle);
            if (object != null) {
                installSupport.doRestart(object, null);
            }
        }
        catch (OperationException operationException) {
            try {
                installSupport.doCancel();
                throw (CommandException)new CommandException(33, operationException.getMessage()).initCause((Throwable)operationException);
            }
            catch (OperationException operationException2) {
                throw (CommandException)new CommandException(33, operationException2.getMessage()).initCause((Throwable)operationException2);
            }
        }
    }

    private static Pattern[] findMatcher(Env env, String[] stringArray) {
        Pattern[] patternArray = new Pattern[stringArray.length];
        for (int i = 0; i < patternArray.length; ++i) {
            try {
                patternArray[i] = Pattern.compile(stringArray[i]);
                continue;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                env.getErrorStream().println(Bundle.MSG_CantCompileRegex(stringArray[i]));
            }
        }
        return patternArray;
    }

    private static boolean matches(String string, Pattern[] patternArray) {
        for (Pattern pattern : patternArray) {
            if (pattern == null || !pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    private void install(Env env, String ... stringArray) throws CommandException {
        UpdateElement updateElement;
        if (!this.initialized()) {
            this.refresh(env);
        }
        Pattern[] patternArray = ModuleOptions.findMatcher(env, stringArray);
        List list = UpdateManager.getDefault().getUpdateUnits();
        OperationContainer operationContainer = OperationContainer.createForInstall();
        for (UpdateUnit updateUnit : list) {
            if (updateUnit.getInstalled() != null || !ModuleOptions.matches(updateUnit.getCodeName(), patternArray) || updateUnit.getAvailableUpdates().isEmpty()) continue;
            updateElement = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
            env.getOutputStream().println(Bundle.MSG_Installing(updateUnit.getCodeName(), updateElement.getSpecificationVersion()));
            operationContainer.add(updateElement);
        }
        InstallSupport installSupport = (InstallSupport)operationContainer.getSupport();
        if (installSupport == null) {
            env.getOutputStream().println(Bundle.MSG_InstallNoMatch(Arrays.asList(patternArray)));
            return;
        }
        try {
            UpdateUnit updateUnit;
            env.getOutputStream().println("modules=" + operationContainer.listAll().size());
            updateUnit = new CLIInternalHandle("downloading-modules", env).createProgressHandle();
            updateUnit.setInitialDelay(0);
            updateElement = installSupport.doDownload((ProgressHandle)updateUnit, null, false);
            InstallSupport.Installer installer = installSupport.doValidate((InstallSupport.Validator)updateElement, null);
            ProgressHandle progressHandle = new CLIInternalHandle("installing-modules", env).createProgressHandle();
            progressHandle.setInitialDelay(0);
            OperationSupport.Restarter restarter = installSupport.doInstall(installer, progressHandle);
            if (restarter != null) {
                installSupport.doRestart(restarter, null);
            }
        }
        catch (OperationException operationException) {
            if (OperationException.ERROR_TYPE.INSTALL.equals((Object)operationException.getErrorType())) {
                env.getErrorStream().println(operationException.getLocalizedMessage());
                throw (CommandException)new CommandException(34, operationException.getMessage()).initCause((Throwable)operationException);
            }
            try {
                installSupport.doCancel();
                throw (CommandException)new CommandException(32, operationException.getMessage()).initCause((Throwable)operationException);
            }
            catch (OperationException operationException2) {
                throw (CommandException)new CommandException(32, operationException2.getMessage()).initCause((Throwable)operationException2);
            }
        }
    }

    private void updateAll(Env env) throws CommandException {
        this.updateModules(env, new String[0]);
    }

    private void extraUC(Env env, String ... stringArray) throws CommandException {
        ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
        for (String string : stringArray) {
            try {
                arrayList.add(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw ModuleOptions.initCause(new CommandException(4), malformedURLException);
            }
        }
        for (URL uRL : arrayList) {
            this.ownUUP.add(UpdateUnitProviderFactory.getDefault().create(Long.toString(System.currentTimeMillis()), uRL.toExternalForm(), uRL));
        }
        this.refresh(env);
    }

    private boolean initialized() {
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        long l = preferences.getLong("lastCheckTime", -1L);
        return l != -1L;
    }

    private Collection<String> getFirstClassModules() {
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        String string = preferences.get(PLUGIN_MANAGER_FIRST_CLASS_MODULES, "");
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken().trim());
        }
        return hashSet;
    }

    private class CLIProgressUIWorker
    implements ProgressUIWorker {
        private final Env env;

        public CLIProgressUIWorker(Env env) {
            this.env = env;
        }

        public void processProgressEvent(ProgressEvent progressEvent) {
            this.printEvent(progressEvent);
        }

        public void processSelectedProgressEvent(ProgressEvent progressEvent) {
            this.printEvent(progressEvent);
        }

        private void printEvent(ProgressEvent progressEvent) {
            String string = progressEvent.getMessage();
            if (string != null && string.length() > 0) {
                this.env.getOutputStream().println(string);
            }
        }
    }

    private class CLIInternalHandle
    extends InternalHandle {
        public CLIInternalHandle(String string, Env env) {
            super(string, null, false);
            this.setController(new Controller((ProgressUIWorker)new CLIProgressUIWorker(env)));
        }
    }
}

