/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
import * as lsp from 'vscode-languageserver';
import { MessageType } from 'vscode-languageserver';
import { attachWorkDone } from 'vscode-languageserver/lib/common/progress.js';
import { TypeScriptRenameRequest } from './ts-protocol.js';
// Hack around the LSP library that makes it otherwise impossible to differentiate between Null and Client-initiated reporter.
const nullProgressReporter = attachWorkDone(undefined, /* params */ undefined);
export class LspClientImpl {
    constructor(connection) {
        this.connection = connection;
    }
    async createProgressReporter(_, workDoneProgress) {
        let reporter;
        if (workDoneProgress && workDoneProgress.constructor !== nullProgressReporter.constructor) {
            reporter = workDoneProgress;
        }
        else {
            reporter = workDoneProgress || await this.connection.window.createWorkDoneProgress();
        }
        return reporter;
    }
    async withProgress(options, task) {
        const { message, reporter } = options;
        reporter.begin(message);
        return task(reporter).then(result => {
            reporter.done();
            return result;
        });
    }
    publishDiagnostics(params) {
        this.connection.sendDiagnostics(params);
    }
    showErrorMessage(message) {
        this.connection.sendNotification(lsp.ShowMessageNotification.type, { type: MessageType.Error, message });
    }
    logMessage(args) {
        this.connection.sendNotification(lsp.LogMessageNotification.type, args);
    }
    async applyWorkspaceEdit(params) {
        return this.connection.workspace.applyEdit(params);
    }
    async rename(args) {
        return this.connection.sendRequest(TypeScriptRenameRequest.type, args);
    }
}
//# sourceMappingURL=lsp-client.js.map