"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _IconButton = _interopRequireDefault(require("../IconButton"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var types = _interopRequireWildcard(require("../../types"));

var _utils = require("../../utils");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var REQUIRED_FIELD_SYMBOL = "*";
var COMPONENT_TYPES = {
  array: "ArrayField",
  "boolean": "BooleanField",
  integer: "NumberField",
  number: "NumberField",
  object: "ObjectField",
  string: "StringField",
  "null": "NullField"
};

function getFieldComponent(schema, uiSchema, idSchema, fields) {
  var field = uiSchema["ui:field"];

  if (typeof field === "function") {
    return field;
  }

  if (typeof field === "string" && field in fields) {
    return fields[field];
  }

  var componentName = COMPONENT_TYPES[(0, _utils.getSchemaType)(schema)]; // If the type is not defined and the schema uses 'anyOf' or 'oneOf', don't
  // render a field and let the MultiSchemaField component handle the form display

  if (!componentName && (schema.anyOf || schema.oneOf)) {
    return function () {
      return null;
    };
  }

  return componentName in fields ? fields[componentName] : function () {
    var UnsupportedField = fields.UnsupportedField;
    return _react["default"].createElement(UnsupportedField, {
      schema: schema,
      idSchema: idSchema,
      reason: "Unknown field type ".concat(schema.type)
    });
  };
}

function Label(props) {
  var label = props.label,
      required = props.required,
      id = props.id;

  if (!label) {
    return null;
  }

  return _react["default"].createElement("label", {
    className: "control-label",
    htmlFor: id
  }, label, required && _react["default"].createElement("span", {
    className: "required"
  }, REQUIRED_FIELD_SYMBOL));
}

function LabelInput(props) {
  var id = props.id,
      label = props.label,
      onChange = props.onChange;
  return _react["default"].createElement("input", {
    className: "form-control",
    type: "text",
    id: id,
    onBlur: function onBlur(event) {
      return onChange(event.target.value);
    },
    defaultValue: label
  });
}

function Help(props) {
  var id = props.id,
      help = props.help;

  if (!help) {
    return null;
  }

  if (typeof help === "string") {
    return _react["default"].createElement("p", {
      id: id,
      className: "help-block"
    }, help);
  }

  return _react["default"].createElement("div", {
    id: id,
    className: "help-block"
  }, help);
}

function ErrorList(props) {
  var _props$errors = props.errors,
      errors = _props$errors === void 0 ? [] : _props$errors;

  if (errors.length === 0) {
    return null;
  }

  return _react["default"].createElement("div", null, _react["default"].createElement("ul", {
    className: "error-detail bs-callout bs-callout-info"
  }, errors.filter(function (elem) {
    return !!elem;
  }).map(function (error, index) {
    return _react["default"].createElement("li", {
      className: "text-danger",
      key: index
    }, error);
  })));
}

function DefaultTemplate(props) {
  var id = props.id,
      label = props.label,
      children = props.children,
      errors = props.errors,
      help = props.help,
      description = props.description,
      hidden = props.hidden,
      required = props.required,
      displayLabel = props.displayLabel;

  if (hidden) {
    return _react["default"].createElement("div", {
      className: "hidden"
    }, children);
  }

  return _react["default"].createElement(WrapIfAdditional, props, displayLabel && _react["default"].createElement(Label, {
    label: label,
    required: required,
    id: id
  }), displayLabel && description ? description : null, children, errors, help);
}

if (process.env.NODE_ENV !== "production") {
  DefaultTemplate.propTypes = {
    id: _propTypes["default"].string,
    classNames: _propTypes["default"].string,
    label: _propTypes["default"].string,
    children: _propTypes["default"].node.isRequired,
    errors: _propTypes["default"].element,
    rawErrors: _propTypes["default"].arrayOf(_propTypes["default"].string),
    help: _propTypes["default"].element,
    rawHelp: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].element]),
    description: _propTypes["default"].element,
    rawDescription: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].element]),
    hidden: _propTypes["default"].bool,
    required: _propTypes["default"].bool,
    readonly: _propTypes["default"].bool,
    displayLabel: _propTypes["default"].bool,
    fields: _propTypes["default"].object,
    formContext: _propTypes["default"].object
  };
}

DefaultTemplate.defaultProps = {
  hidden: false,
  readonly: false,
  required: false,
  displayLabel: true
};

function WrapIfAdditional(props) {
  var id = props.id,
      classNames = props.classNames,
      disabled = props.disabled,
      label = props.label,
      onKeyChange = props.onKeyChange,
      onDropPropertyClick = props.onDropPropertyClick,
      readonly = props.readonly,
      required = props.required,
      schema = props.schema;
  var keyLabel = "".concat(label, " Key"); // i18n ?

  var additional = schema.hasOwnProperty(_utils.ADDITIONAL_PROPERTY_FLAG);

  if (!additional) {
    return _react["default"].createElement("div", {
      className: classNames
    }, props.children);
  }

  return _react["default"].createElement("div", {
    className: classNames
  }, _react["default"].createElement("div", {
    className: "row"
  }, _react["default"].createElement("div", {
    className: "col-xs-5 form-additional"
  }, _react["default"].createElement("div", {
    className: "form-group"
  }, _react["default"].createElement(Label, {
    label: keyLabel,
    required: required,
    id: "".concat(id, "-key")
  }), _react["default"].createElement(LabelInput, {
    label: label,
    required: required,
    id: "".concat(id, "-key"),
    onChange: onKeyChange
  }))), _react["default"].createElement("div", {
    className: "form-additional form-group col-xs-5"
  }, props.children), _react["default"].createElement("div", {
    className: "col-xs-2"
  }, _react["default"].createElement(_IconButton["default"], {
    type: "danger",
    icon: "remove",
    className: "array-item-remove btn-block",
    tabIndex: "-1",
    style: {
      border: "0"
    },
    disabled: disabled || readonly,
    onClick: onDropPropertyClick(label)
  }))));
}

function SchemaFieldRender(props) {
  var uiSchema = props.uiSchema,
      formData = props.formData,
      errorSchema = props.errorSchema,
      idPrefix = props.idPrefix,
      idSeparator = props.idSeparator,
      name = props.name,
      onChange = props.onChange,
      onKeyChange = props.onKeyChange,
      onDropPropertyClick = props.onDropPropertyClick,
      required = props.required,
      _props$registry = props.registry,
      registry = _props$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _props$registry,
      _props$wasPropertyKey = props.wasPropertyKeyModified,
      wasPropertyKeyModified = _props$wasPropertyKey === void 0 ? false : _props$wasPropertyKey;
  var rootSchema = registry.rootSchema,
      fields = registry.fields,
      formContext = registry.formContext;
  var FieldTemplate = uiSchema["ui:FieldTemplate"] || registry.FieldTemplate || DefaultTemplate;
  var idSchema = props.idSchema;
  var schema = (0, _utils.retrieveSchema)(props.schema, rootSchema, formData);
  idSchema = (0, _utils.mergeObjects)((0, _utils.toIdSchema)(schema, null, rootSchema, formData, idPrefix, idSeparator), idSchema);
  var FieldComponent = getFieldComponent(schema, uiSchema, idSchema, fields);
  var DescriptionField = fields.DescriptionField;
  var disabled = Boolean(props.disabled || uiSchema["ui:disabled"]);
  var readonly = Boolean(props.readonly || uiSchema["ui:readonly"] || props.schema.readOnly || schema.readOnly);
  var uiSchemaHideError = uiSchema["ui:hideError"]; // Set hideError to the value provided in the uiSchema, otherwise stick with the prop to propagate to children

  var hideError = uiSchemaHideError === undefined ? props.hideError : Boolean(uiSchemaHideError);
  var autofocus = Boolean(props.autofocus || uiSchema["ui:autofocus"]);

  if (Object.keys(schema).length === 0) {
    return null;
  }

  var displayLabel = (0, _utils.getDisplayLabel)(schema, uiSchema, rootSchema);

  var __errors = errorSchema.__errors,
      fieldErrorSchema = _objectWithoutProperties(errorSchema, ["__errors"]); // See #439: uiSchema: Don't pass consumed class names to child components


  var field = _react["default"].createElement(FieldComponent, _extends({}, props, {
    idSchema: idSchema,
    schema: schema,
    uiSchema: _objectSpread({}, uiSchema, {
      classNames: undefined
    }),
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    autofocus: autofocus,
    errorSchema: fieldErrorSchema,
    formContext: formContext,
    rawErrors: __errors
  }));

  var id = idSchema.$id; // If this schema has a title defined, but the user has set a new key/label, retain their input.

  var label;

  if (wasPropertyKeyModified) {
    label = name;
  } else {
    label = uiSchema["ui:title"] || props.schema.title || schema.title || name;
  }

  var description = uiSchema["ui:description"] || props.schema.description || schema.description;
  var errors = __errors;
  var help = uiSchema["ui:help"];
  var hidden = uiSchema["ui:widget"] === "hidden";
  var classNames = ["form-group", "field", "field-".concat(schema.type)];

  if (!hideError && errors && errors.length > 0) {
    classNames.push("field-error has-error has-danger");
  }

  classNames.push(uiSchema.classNames);
  classNames = classNames.join(" ").trim();
  var fieldProps = {
    description: _react["default"].createElement(DescriptionField, {
      id: id + "__description",
      description: description,
      formContext: formContext
    }),
    rawDescription: description,
    help: _react["default"].createElement(Help, {
      id: id + "__help",
      help: help
    }),
    rawHelp: typeof help === "string" ? help : undefined,
    errors: hideError ? undefined : _react["default"].createElement(ErrorList, {
      errors: errors
    }),
    rawErrors: hideError ? undefined : errors,
    id: id,
    label: label,
    hidden: hidden,
    onChange: onChange,
    onKeyChange: onKeyChange,
    onDropPropertyClick: onDropPropertyClick,
    required: required,
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    displayLabel: displayLabel,
    classNames: classNames,
    formContext: formContext,
    formData: formData,
    fields: fields,
    schema: schema,
    uiSchema: uiSchema,
    registry: registry
  };
  var _AnyOfField = registry.fields.AnyOfField;
  var _OneOfField = registry.fields.OneOfField;
  return _react["default"].createElement(FieldTemplate, fieldProps, _react["default"].createElement(_react["default"].Fragment, null, field, schema.anyOf && !(0, _utils.isSelect)(schema) && _react["default"].createElement(_AnyOfField, {
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    errorSchema: errorSchema,
    formData: formData,
    idPrefix: idPrefix,
    idSchema: idSchema,
    idSeparator: idSeparator,
    onBlur: props.onBlur,
    onChange: props.onChange,
    onFocus: props.onFocus,
    options: schema.anyOf.map(function (_schema) {
      return (0, _utils.retrieveSchema)(_schema, rootSchema, formData);
    }),
    baseType: schema.type,
    registry: registry,
    schema: schema,
    uiSchema: uiSchema
  }), schema.oneOf && !(0, _utils.isSelect)(schema) && _react["default"].createElement(_OneOfField, {
    disabled: disabled,
    readonly: readonly,
    hideError: hideError,
    errorSchema: errorSchema,
    formData: formData,
    idPrefix: idPrefix,
    idSchema: idSchema,
    idSeparator: idSeparator,
    onBlur: props.onBlur,
    onChange: props.onChange,
    onFocus: props.onFocus,
    options: schema.oneOf.map(function (_schema) {
      return (0, _utils.retrieveSchema)(_schema, rootSchema, formData);
    }),
    baseType: schema.type,
    registry: registry,
    schema: schema,
    uiSchema: uiSchema
  })));
}

var SchemaField =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SchemaField, _React$Component);

  function SchemaField() {
    _classCallCheck(this, SchemaField);

    return _possibleConstructorReturn(this, _getPrototypeOf(SchemaField).apply(this, arguments));
  }

  _createClass(SchemaField, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return !(0, _utils.deepEquals)(this.props, nextProps);
    }
  }, {
    key: "render",
    value: function render() {
      return SchemaFieldRender(this.props);
    }
  }]);

  return SchemaField;
}(_react["default"].Component);

SchemaField.defaultProps = {
  uiSchema: {},
  errorSchema: {},
  idSchema: {},
  disabled: false,
  readonly: false,
  autofocus: false,
  hideError: false
};

if (process.env.NODE_ENV !== "production") {
  SchemaField.propTypes = {
    schema: _propTypes["default"].object.isRequired,
    uiSchema: _propTypes["default"].object,
    idSchema: _propTypes["default"].object,
    formData: _propTypes["default"].any,
    errorSchema: _propTypes["default"].object,
    registry: types.registry.isRequired
  };
}

var _default = SchemaField;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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