/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "dbus-display1.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.VM
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1VM
 * @title: QemuDBusDisplay1VM
 * @short_description: Generated C code for the org.qemu.Display1.VM D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-VM.top_of_page">org.qemu.Display1.VM</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.VM ---- */

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_vm_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_vm_property_info_uuid =
{
  {
    -1,
    (gchar *) "UUID",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uuid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_vm_property_info_console_ids =
{
  {
    -1,
    (gchar *) "ConsoleIDs",
    (gchar *) "au",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "console-ids",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _qemu_dbus_display1_vm_property_info_pointers[] =
{
  &_qemu_dbus_display1_vm_property_info_name.parent_struct,
  &_qemu_dbus_display1_vm_property_info_uuid.parent_struct,
  &_qemu_dbus_display1_vm_property_info_console_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_vm_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.VM",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_qemu_dbus_display1_vm_property_info_pointers,
    NULL
  },
  "display1-vm",
};


/**
 * qemu_dbus_display1_vm_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-VM.top_of_page">org.qemu.Display1.VM</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_vm_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_vm_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_vm_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1VM interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_vm_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "uuid");
  g_object_class_override_property (klass, property_id_begin++, "console-ids");
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1VM:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-VM.top_of_page">org.qemu.Display1.VM</link>.
 */

/**
 * QemuDBusDisplay1VMIface:
 * @parent_iface: The parent interface.
 * @get_console_ids: Getter for the #QemuDBusDisplay1VM:console-ids property.
 * @get_name: Getter for the #QemuDBusDisplay1VM:name property.
 * @get_uuid: Getter for the #QemuDBusDisplay1VM:uuid property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-VM.top_of_page">org.qemu.Display1.VM</link>.
 */

typedef QemuDBusDisplay1VMIface QemuDBusDisplay1VMInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1VM, qemu_dbus_display1_vm, G_TYPE_OBJECT)

static void
qemu_dbus_display1_vm_default_init (QemuDBusDisplay1VMIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * QemuDBusDisplay1VM:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-VM.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1VM:uuid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-VM.UUID">"UUID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("uuid", "UUID", "UUID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1VM:console-ids:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-VM.ConsoleIDs">"ConsoleIDs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("console-ids", "ConsoleIDs", "ConsoleIDs", G_VARIANT_TYPE ("au"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * qemu_dbus_display1_vm_get_name: (skip)
 * @object: A #QemuDBusDisplay1VM.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-VM.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_vm_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
qemu_dbus_display1_vm_get_name (QemuDBusDisplay1VM *object)
{
  return QEMU_DBUS_DISPLAY1_VM_GET_IFACE (object)->get_name (object);
}

/**
 * qemu_dbus_display1_vm_dup_name: (skip)
 * @object: A #QemuDBusDisplay1VM.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-VM.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
qemu_dbus_display1_vm_dup_name (QemuDBusDisplay1VM *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_vm_set_name: (skip)
 * @object: A #QemuDBusDisplay1VM.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-VM.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_vm_set_name (QemuDBusDisplay1VM *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * qemu_dbus_display1_vm_get_uuid: (skip)
 * @object: A #QemuDBusDisplay1VM.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-VM.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_vm_dup_uuid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
qemu_dbus_display1_vm_get_uuid (QemuDBusDisplay1VM *object)
{
  return QEMU_DBUS_DISPLAY1_VM_GET_IFACE (object)->get_uuid (object);
}

/**
 * qemu_dbus_display1_vm_dup_uuid: (skip)
 * @object: A #QemuDBusDisplay1VM.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-VM.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
qemu_dbus_display1_vm_dup_uuid (QemuDBusDisplay1VM *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "uuid", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_vm_set_uuid: (skip)
 * @object: A #QemuDBusDisplay1VM.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-VM.UUID">"UUID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_vm_set_uuid (QemuDBusDisplay1VM *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "uuid", value, NULL);
}

/**
 * qemu_dbus_display1_vm_get_console_ids: (skip)
 * @object: A #QemuDBusDisplay1VM.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-VM.ConsoleIDs">"ConsoleIDs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_vm_dup_console_ids() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
qemu_dbus_display1_vm_get_console_ids (QemuDBusDisplay1VM *object)
{
  return QEMU_DBUS_DISPLAY1_VM_GET_IFACE (object)->get_console_ids (object);
}

/**
 * qemu_dbus_display1_vm_dup_console_ids: (skip)
 * @object: A #QemuDBusDisplay1VM.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-VM.ConsoleIDs">"ConsoleIDs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
qemu_dbus_display1_vm_dup_console_ids (QemuDBusDisplay1VM *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "console-ids", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_vm_set_console_ids: (skip)
 * @object: A #QemuDBusDisplay1VM.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-VM.ConsoleIDs">"ConsoleIDs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_vm_set_console_ids (QemuDBusDisplay1VM *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "console-ids", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1VMProxy:
 *
 * The #QemuDBusDisplay1VMProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1VMProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1VMProxy.
 */

struct _QemuDBusDisplay1VMProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_vm_proxy_iface_init (QemuDBusDisplay1VMIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1VMProxy, qemu_dbus_display1_vm_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1VMProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_VM, qemu_dbus_display1_vm_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1VMProxy, qemu_dbus_display1_vm_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_VM, qemu_dbus_display1_vm_proxy_iface_init))

#endif
static void
qemu_dbus_display1_vm_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1VMProxy *proxy = QEMU_DBUS_DISPLAY1_VM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_vm_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_vm_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_vm_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
qemu_dbus_display1_vm_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.qemu.Display1.VM: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
qemu_dbus_display1_vm_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_vm_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.qemu.Display1.VM", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) qemu_dbus_display1_vm_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
qemu_dbus_display1_vm_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_vm_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_VM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_VM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_vm_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1VMProxy *proxy = QEMU_DBUS_DISPLAY1_VM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_vm_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_vm_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
qemu_dbus_display1_vm_proxy_get_name (QemuDBusDisplay1VM *object)
{
  QemuDBusDisplay1VMProxy *proxy = QEMU_DBUS_DISPLAY1_VM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
qemu_dbus_display1_vm_proxy_get_uuid (QemuDBusDisplay1VM *object)
{
  QemuDBusDisplay1VMProxy *proxy = QEMU_DBUS_DISPLAY1_VM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UUID");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
qemu_dbus_display1_vm_proxy_get_console_ids (QemuDBusDisplay1VM *object)
{
  QemuDBusDisplay1VMProxy *proxy = QEMU_DBUS_DISPLAY1_VM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConsoleIDs");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
qemu_dbus_display1_vm_proxy_init (QemuDBusDisplay1VMProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_vm_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_VM_PROXY, QemuDBusDisplay1VMProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_vm_interface_info ());
}

static void
qemu_dbus_display1_vm_proxy_class_init (QemuDBusDisplay1VMProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_vm_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_vm_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_vm_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_vm_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_vm_proxy_g_properties_changed;

  qemu_dbus_display1_vm_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1VMProxyPrivate));
#endif
}

static void
qemu_dbus_display1_vm_proxy_iface_init (QemuDBusDisplay1VMIface *iface)
{
  iface->get_name = qemu_dbus_display1_vm_proxy_get_name;
  iface->get_uuid = qemu_dbus_display1_vm_proxy_get_uuid;
  iface->get_console_ids = qemu_dbus_display1_vm_proxy_get_console_ids;
}

/**
 * qemu_dbus_display1_vm_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-VM.top_of_page">org.qemu.Display1.VM</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_vm_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_vm_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_vm_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_VM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.VM", NULL);
}

/**
 * qemu_dbus_display1_vm_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_vm_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_vm_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1VMProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1VM *
qemu_dbus_display1_vm_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_VM (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_vm_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-VM.top_of_page">org.qemu.Display1.VM</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_vm_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1VMProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1VM *
qemu_dbus_display1_vm_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_VM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.VM", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_VM (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_vm_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_vm_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_vm_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_vm_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_vm_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_VM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.VM", NULL);
}

/**
 * qemu_dbus_display1_vm_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_vm_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_vm_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1VMProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1VM *
qemu_dbus_display1_vm_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_VM (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_vm_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_vm_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_vm_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1VMProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1VM *
qemu_dbus_display1_vm_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_VM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.VM", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_VM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1VMSkeleton:
 *
 * The #QemuDBusDisplay1VMSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1VMSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1VMSkeleton.
 */

struct _QemuDBusDisplay1VMSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_vm_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_VM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_VM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_vm_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_vm_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_vm_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_vm_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_vm_skeleton_vtable =
{
  _qemu_dbus_display1_vm_skeleton_handle_method_call,
  _qemu_dbus_display1_vm_skeleton_handle_get_property,
  _qemu_dbus_display1_vm_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_vm_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_vm_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_vm_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_vm_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_vm_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_vm_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_vm_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_vm_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_vm_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.VM", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _qemu_dbus_display1_vm_emit_changed (gpointer user_data);

static void
qemu_dbus_display1_vm_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _qemu_dbus_display1_vm_emit_changed (skeleton);
}

static void qemu_dbus_display1_vm_skeleton_iface_init (QemuDBusDisplay1VMIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1VMSkeleton, qemu_dbus_display1_vm_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1VMSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_VM, qemu_dbus_display1_vm_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1VMSkeleton, qemu_dbus_display1_vm_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_VM, qemu_dbus_display1_vm_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_vm_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_vm_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_vm_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_qemu_dbus_display1_vm_emit_changed (gpointer user_data)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.qemu.Display1.VM",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_qemu_dbus_display1_vm_schedule_emit_changed (QemuDBusDisplay1VMSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
qemu_dbus_display1_vm_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _qemu_dbus_display1_vm_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _qemu_dbus_display1_vm_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
qemu_dbus_display1_vm_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_vm_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _qemu_dbus_display1_vm_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
qemu_dbus_display1_vm_skeleton_init (QemuDBusDisplay1VMSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_vm_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_VM_SKELETON, QemuDBusDisplay1VMSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_VARIANT);
}

static const gchar *
qemu_dbus_display1_vm_skeleton_get_name (QemuDBusDisplay1VM *object)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
qemu_dbus_display1_vm_skeleton_get_uuid (QemuDBusDisplay1VM *object)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
qemu_dbus_display1_vm_skeleton_get_console_ids (QemuDBusDisplay1VM *object)
{
  QemuDBusDisplay1VMSkeleton *skeleton = QEMU_DBUS_DISPLAY1_VM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
qemu_dbus_display1_vm_skeleton_class_init (QemuDBusDisplay1VMSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_vm_skeleton_finalize;
  gobject_class->get_property = qemu_dbus_display1_vm_skeleton_get_property;
  gobject_class->set_property = qemu_dbus_display1_vm_skeleton_set_property;
  gobject_class->notify       = qemu_dbus_display1_vm_skeleton_notify;


  qemu_dbus_display1_vm_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_vm_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_vm_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_vm_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_vm_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1VMSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_vm_skeleton_iface_init (QemuDBusDisplay1VMIface *iface)
{
  iface->get_name = qemu_dbus_display1_vm_skeleton_get_name;
  iface->get_uuid = qemu_dbus_display1_vm_skeleton_get_uuid;
  iface->get_console_ids = qemu_dbus_display1_vm_skeleton_get_console_ids;
}

/**
 * qemu_dbus_display1_vm_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-VM.top_of_page">org.qemu.Display1.VM</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1VMSkeleton): The skeleton object.
 */
QemuDBusDisplay1VM *
qemu_dbus_display1_vm_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_VM (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_VM_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.Console
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1Console
 * @title: QemuDBusDisplay1Console
 * @short_description: Generated C code for the org.qemu.Display1.Console D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-Console.top_of_page">org.qemu.Display1.Console</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.Console ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_console_method_info_register_listener_IN_ARG_listener =
{
  {
    -1,
    (gchar *) "listener",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_console_method_info_register_listener_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_console_method_info_register_listener_IN_ARG_listener.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_console_method_info_register_listener =
{
  {
    -1,
    (gchar *) "RegisterListener",
    (GDBusArgInfo **) &_qemu_dbus_display1_console_method_info_register_listener_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-listener",
  TRUE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_width_mm =
{
  {
    -1,
    (gchar *) "width_mm",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_height_mm =
{
  {
    -1,
    (gchar *) "height_mm",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_xoff =
{
  {
    -1,
    (gchar *) "xoff",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_yoff =
{
  {
    -1,
    (gchar *) "yoff",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_width_mm.parent_struct,
  &_qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_height_mm.parent_struct,
  &_qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_xoff.parent_struct,
  &_qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_yoff.parent_struct,
  &_qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_width.parent_struct,
  &_qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_console_method_info_set_uiinfo =
{
  {
    -1,
    (gchar *) "SetUIInfo",
    (GDBusArgInfo **) &_qemu_dbus_display1_console_method_info_set_uiinfo_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-uiinfo",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_console_method_info_pointers[] =
{
  &_qemu_dbus_display1_console_method_info_register_listener.parent_struct,
  &_qemu_dbus_display1_console_method_info_set_uiinfo.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_console_property_info_label =
{
  {
    -1,
    (gchar *) "Label",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "label",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_console_property_info_head =
{
  {
    -1,
    (gchar *) "Head",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "head",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_console_property_info_type_ =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_console_property_info_width =
{
  {
    -1,
    (gchar *) "Width",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "width",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_console_property_info_height =
{
  {
    -1,
    (gchar *) "Height",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "height",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_console_property_info_device_address =
{
  {
    -1,
    (gchar *) "DeviceAddress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device-address",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _qemu_dbus_display1_console_property_info_pointers[] =
{
  &_qemu_dbus_display1_console_property_info_label.parent_struct,
  &_qemu_dbus_display1_console_property_info_head.parent_struct,
  &_qemu_dbus_display1_console_property_info_type_.parent_struct,
  &_qemu_dbus_display1_console_property_info_width.parent_struct,
  &_qemu_dbus_display1_console_property_info_height.parent_struct,
  &_qemu_dbus_display1_console_property_info_device_address.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_console_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.Console",
    (GDBusMethodInfo **) &_qemu_dbus_display1_console_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_qemu_dbus_display1_console_property_info_pointers,
    NULL
  },
  "display1-console",
};


/**
 * qemu_dbus_display1_console_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-Console.top_of_page">org.qemu.Display1.Console</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_console_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_console_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_console_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1Console interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_console_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "label");
  g_object_class_override_property (klass, property_id_begin++, "head");
  g_object_class_override_property (klass, property_id_begin++, "type");
  g_object_class_override_property (klass, property_id_begin++, "width");
  g_object_class_override_property (klass, property_id_begin++, "height");
  g_object_class_override_property (klass, property_id_begin++, "device-address");
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1Console:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Console.top_of_page">org.qemu.Display1.Console</link>.
 */

/**
 * QemuDBusDisplay1ConsoleIface:
 * @parent_iface: The parent interface.
 * @handle_register_listener: Handler for the #QemuDBusDisplay1Console::handle-register-listener signal.
 * @handle_set_uiinfo: Handler for the #QemuDBusDisplay1Console::handle-set-uiinfo signal.
 * @get_device_address: Getter for the #QemuDBusDisplay1Console:device-address property.
 * @get_head: Getter for the #QemuDBusDisplay1Console:head property.
 * @get_height: Getter for the #QemuDBusDisplay1Console:height property.
 * @get_label: Getter for the #QemuDBusDisplay1Console:label property.
 * @get_type_: Getter for the #QemuDBusDisplay1Console:type property.
 * @get_width: Getter for the #QemuDBusDisplay1Console:width property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Console.top_of_page">org.qemu.Display1.Console</link>.
 */

typedef QemuDBusDisplay1ConsoleIface QemuDBusDisplay1ConsoleInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1Console, qemu_dbus_display1_console, G_TYPE_OBJECT)

static void
qemu_dbus_display1_console_default_init (QemuDBusDisplay1ConsoleIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1Console::handle-register-listener:
   * @object: A #QemuDBusDisplay1Console.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_listener: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Console.RegisterListener">RegisterListener()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_console_complete_register_listener() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-listener",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ConsoleIface, handle_register_listener),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * QemuDBusDisplay1Console::handle-set-uiinfo:
   * @object: A #QemuDBusDisplay1Console.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_width_mm: Argument passed by remote caller.
   * @arg_height_mm: Argument passed by remote caller.
   * @arg_xoff: Argument passed by remote caller.
   * @arg_yoff: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Console.SetUIInfo">SetUIInfo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_console_complete_set_uiinfo() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-uiinfo",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ConsoleIface, handle_set_uiinfo),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INT, G_TYPE_INT, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * QemuDBusDisplay1Console:label:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Console.Label">"Label"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("label", "Label", "Label", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Console:head:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Console.Head">"Head"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("head", "Head", "Head", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Console:type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Console.Type">"Type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("type", "Type", "Type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Console:width:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Console.Width">"Width"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("width", "Width", "Width", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Console:height:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Console.Height">"Height"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("height", "Height", "Height", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Console:device-address:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Console.DeviceAddress">"DeviceAddress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("device-address", "DeviceAddress", "DeviceAddress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * qemu_dbus_display1_console_get_label: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Console.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_console_dup_label() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
qemu_dbus_display1_console_get_label (QemuDBusDisplay1Console *object)
{
  return QEMU_DBUS_DISPLAY1_CONSOLE_GET_IFACE (object)->get_label (object);
}

/**
 * qemu_dbus_display1_console_dup_label: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-Console.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
qemu_dbus_display1_console_dup_label (QemuDBusDisplay1Console *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "label", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_console_set_label: (skip)
 * @object: A #QemuDBusDisplay1Console.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Console.Label">"Label"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_console_set_label (QemuDBusDisplay1Console *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "label", value, NULL);
}

/**
 * qemu_dbus_display1_console_get_head: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Console.Head">"Head"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
qemu_dbus_display1_console_get_head (QemuDBusDisplay1Console *object)
{
  return QEMU_DBUS_DISPLAY1_CONSOLE_GET_IFACE (object)->get_head (object);
}

/**
 * qemu_dbus_display1_console_set_head: (skip)
 * @object: A #QemuDBusDisplay1Console.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Console.Head">"Head"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_console_set_head (QemuDBusDisplay1Console *object, guint value)
{
  g_object_set (G_OBJECT (object), "head", value, NULL);
}

/**
 * qemu_dbus_display1_console_get_type_: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Console.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_console_dup_type_() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
qemu_dbus_display1_console_get_type_ (QemuDBusDisplay1Console *object)
{
  return QEMU_DBUS_DISPLAY1_CONSOLE_GET_IFACE (object)->get_type_ (object);
}

/**
 * qemu_dbus_display1_console_dup_type_: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-Console.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
qemu_dbus_display1_console_dup_type_ (QemuDBusDisplay1Console *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "type", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_console_set_type_: (skip)
 * @object: A #QemuDBusDisplay1Console.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Console.Type">"Type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_console_set_type_ (QemuDBusDisplay1Console *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "type", value, NULL);
}

/**
 * qemu_dbus_display1_console_get_width: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Console.Width">"Width"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
qemu_dbus_display1_console_get_width (QemuDBusDisplay1Console *object)
{
  return QEMU_DBUS_DISPLAY1_CONSOLE_GET_IFACE (object)->get_width (object);
}

/**
 * qemu_dbus_display1_console_set_width: (skip)
 * @object: A #QemuDBusDisplay1Console.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Console.Width">"Width"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_console_set_width (QemuDBusDisplay1Console *object, guint value)
{
  g_object_set (G_OBJECT (object), "width", value, NULL);
}

/**
 * qemu_dbus_display1_console_get_height: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Console.Height">"Height"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
qemu_dbus_display1_console_get_height (QemuDBusDisplay1Console *object)
{
  return QEMU_DBUS_DISPLAY1_CONSOLE_GET_IFACE (object)->get_height (object);
}

/**
 * qemu_dbus_display1_console_set_height: (skip)
 * @object: A #QemuDBusDisplay1Console.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Console.Height">"Height"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_console_set_height (QemuDBusDisplay1Console *object, guint value)
{
  g_object_set (G_OBJECT (object), "height", value, NULL);
}

/**
 * qemu_dbus_display1_console_get_device_address: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Console.DeviceAddress">"DeviceAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_console_dup_device_address() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
qemu_dbus_display1_console_get_device_address (QemuDBusDisplay1Console *object)
{
  return QEMU_DBUS_DISPLAY1_CONSOLE_GET_IFACE (object)->get_device_address (object);
}

/**
 * qemu_dbus_display1_console_dup_device_address: (skip)
 * @object: A #QemuDBusDisplay1Console.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-Console.DeviceAddress">"DeviceAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
qemu_dbus_display1_console_dup_device_address (QemuDBusDisplay1Console *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "device-address", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_console_set_device_address: (skip)
 * @object: A #QemuDBusDisplay1Console.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Console.DeviceAddress">"DeviceAddress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_console_set_device_address (QemuDBusDisplay1Console *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "device-address", value, NULL);
}

/**
 * qemu_dbus_display1_console_call_register_listener:
 * @proxy: A #QemuDBusDisplay1ConsoleProxy.
 * @arg_listener: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Console.RegisterListener">RegisterListener()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_console_call_register_listener_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_console_call_register_listener_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_console_call_register_listener (
    QemuDBusDisplay1Console *proxy,
    GVariant *arg_listener,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "RegisterListener",
    g_variant_new ("(@h)",
                   arg_listener),
    call_flags,
    timeout_msec,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_console_call_register_listener_finish:
 * @proxy: A #QemuDBusDisplay1ConsoleProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_console_call_register_listener().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_console_call_register_listener().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_console_call_register_listener_finish (
    QemuDBusDisplay1Console *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_console_call_register_listener_sync:
 * @proxy: A #QemuDBusDisplay1ConsoleProxy.
 * @arg_listener: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Console.RegisterListener">RegisterListener()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_console_call_register_listener() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_console_call_register_listener_sync (
    QemuDBusDisplay1Console *proxy,
    GVariant *arg_listener,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "RegisterListener",
    g_variant_new ("(@h)",
                   arg_listener),
    call_flags,
    timeout_msec,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_console_call_set_uiinfo:
 * @proxy: A #QemuDBusDisplay1ConsoleProxy.
 * @arg_width_mm: Argument to pass with the method invocation.
 * @arg_height_mm: Argument to pass with the method invocation.
 * @arg_xoff: Argument to pass with the method invocation.
 * @arg_yoff: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Console.SetUIInfo">SetUIInfo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_console_call_set_uiinfo_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_console_call_set_uiinfo_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_console_call_set_uiinfo (
    QemuDBusDisplay1Console *proxy,
    guint16 arg_width_mm,
    guint16 arg_height_mm,
    gint arg_xoff,
    gint arg_yoff,
    guint arg_width,
    guint arg_height,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetUIInfo",
    g_variant_new ("(qqiiuu)",
                   arg_width_mm,
                   arg_height_mm,
                   arg_xoff,
                   arg_yoff,
                   arg_width,
                   arg_height),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_console_call_set_uiinfo_finish:
 * @proxy: A #QemuDBusDisplay1ConsoleProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_console_call_set_uiinfo().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_console_call_set_uiinfo().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_console_call_set_uiinfo_finish (
    QemuDBusDisplay1Console *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_console_call_set_uiinfo_sync:
 * @proxy: A #QemuDBusDisplay1ConsoleProxy.
 * @arg_width_mm: Argument to pass with the method invocation.
 * @arg_height_mm: Argument to pass with the method invocation.
 * @arg_xoff: Argument to pass with the method invocation.
 * @arg_yoff: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Console.SetUIInfo">SetUIInfo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_console_call_set_uiinfo() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_console_call_set_uiinfo_sync (
    QemuDBusDisplay1Console *proxy,
    guint16 arg_width_mm,
    guint16 arg_height_mm,
    gint arg_xoff,
    gint arg_yoff,
    guint arg_width,
    guint arg_height,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetUIInfo",
    g_variant_new ("(qqiiuu)",
                   arg_width_mm,
                   arg_height_mm,
                   arg_xoff,
                   arg_yoff,
                   arg_width,
                   arg_height),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_console_complete_register_listener:
 * @object: A #QemuDBusDisplay1Console.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Console.RegisterListener">RegisterListener()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_console_complete_register_listener (
    QemuDBusDisplay1Console *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/**
 * qemu_dbus_display1_console_complete_set_uiinfo:
 * @object: A #QemuDBusDisplay1Console.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Console.SetUIInfo">SetUIInfo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_console_complete_set_uiinfo (
    QemuDBusDisplay1Console *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ConsoleProxy:
 *
 * The #QemuDBusDisplay1ConsoleProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ConsoleProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ConsoleProxy.
 */

struct _QemuDBusDisplay1ConsoleProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_console_proxy_iface_init (QemuDBusDisplay1ConsoleIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ConsoleProxy, qemu_dbus_display1_console_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1ConsoleProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE, qemu_dbus_display1_console_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ConsoleProxy, qemu_dbus_display1_console_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE, qemu_dbus_display1_console_proxy_iface_init))

#endif
static void
qemu_dbus_display1_console_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_console_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_console_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_console_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
qemu_dbus_display1_console_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.qemu.Display1.Console: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
qemu_dbus_display1_console_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_console_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.qemu.Display1.Console", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) qemu_dbus_display1_console_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
qemu_dbus_display1_console_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_console_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_CONSOLE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_CONSOLE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_console_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_console_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_console_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
qemu_dbus_display1_console_proxy_get_label (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Label");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
qemu_dbus_display1_console_proxy_get_head (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Head");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
qemu_dbus_display1_console_proxy_get_type_ (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
qemu_dbus_display1_console_proxy_get_width (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Width");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
qemu_dbus_display1_console_proxy_get_height (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Height");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
qemu_dbus_display1_console_proxy_get_device_address (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleProxy *proxy = QEMU_DBUS_DISPLAY1_CONSOLE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DeviceAddress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
qemu_dbus_display1_console_proxy_init (QemuDBusDisplay1ConsoleProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_console_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_CONSOLE_PROXY, QemuDBusDisplay1ConsoleProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_console_interface_info ());
}

static void
qemu_dbus_display1_console_proxy_class_init (QemuDBusDisplay1ConsoleProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_console_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_console_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_console_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_console_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_console_proxy_g_properties_changed;

  qemu_dbus_display1_console_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ConsoleProxyPrivate));
#endif
}

static void
qemu_dbus_display1_console_proxy_iface_init (QemuDBusDisplay1ConsoleIface *iface)
{
  iface->get_label = qemu_dbus_display1_console_proxy_get_label;
  iface->get_head = qemu_dbus_display1_console_proxy_get_head;
  iface->get_type_ = qemu_dbus_display1_console_proxy_get_type_;
  iface->get_width = qemu_dbus_display1_console_proxy_get_width;
  iface->get_height = qemu_dbus_display1_console_proxy_get_height;
  iface->get_device_address = qemu_dbus_display1_console_proxy_get_device_address;
}

/**
 * qemu_dbus_display1_console_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Console.top_of_page">org.qemu.Display1.Console</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_console_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_console_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_console_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Console", NULL);
}

/**
 * qemu_dbus_display1_console_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_console_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_console_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ConsoleProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Console *
qemu_dbus_display1_console_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CONSOLE (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_console_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Console.top_of_page">org.qemu.Display1.Console</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_console_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ConsoleProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Console *
qemu_dbus_display1_console_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Console", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CONSOLE (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_console_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_console_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_console_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_console_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_console_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Console", NULL);
}

/**
 * qemu_dbus_display1_console_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_console_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_console_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ConsoleProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Console *
qemu_dbus_display1_console_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CONSOLE (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_console_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_console_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_console_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ConsoleProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Console *
qemu_dbus_display1_console_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Console", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CONSOLE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ConsoleSkeleton:
 *
 * The #QemuDBusDisplay1ConsoleSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ConsoleSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ConsoleSkeleton.
 */

struct _QemuDBusDisplay1ConsoleSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_console_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_CONSOLE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_CONSOLE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_console_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_console_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_console_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_console_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_console_skeleton_vtable =
{
  _qemu_dbus_display1_console_skeleton_handle_method_call,
  _qemu_dbus_display1_console_skeleton_handle_get_property,
  _qemu_dbus_display1_console_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_console_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_console_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_console_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_console_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_console_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_console_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_console_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_console_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_console_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.Console", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _qemu_dbus_display1_console_emit_changed (gpointer user_data);

static void
qemu_dbus_display1_console_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _qemu_dbus_display1_console_emit_changed (skeleton);
}

static void qemu_dbus_display1_console_skeleton_iface_init (QemuDBusDisplay1ConsoleIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ConsoleSkeleton, qemu_dbus_display1_console_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1ConsoleSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE, qemu_dbus_display1_console_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ConsoleSkeleton, qemu_dbus_display1_console_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE, qemu_dbus_display1_console_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_console_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  guint n;
  for (n = 0; n < 6; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_console_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_console_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_qemu_dbus_display1_console_emit_changed (gpointer user_data)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.qemu.Display1.Console",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_qemu_dbus_display1_console_schedule_emit_changed (QemuDBusDisplay1ConsoleSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
qemu_dbus_display1_console_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _qemu_dbus_display1_console_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _qemu_dbus_display1_console_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
qemu_dbus_display1_console_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 6);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_console_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _qemu_dbus_display1_console_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
qemu_dbus_display1_console_skeleton_init (QemuDBusDisplay1ConsoleSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_console_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_CONSOLE_SKELETON, QemuDBusDisplay1ConsoleSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 6);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
}

static const gchar *
qemu_dbus_display1_console_skeleton_get_label (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
qemu_dbus_display1_console_skeleton_get_head (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
qemu_dbus_display1_console_skeleton_get_type_ (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
qemu_dbus_display1_console_skeleton_get_width (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
qemu_dbus_display1_console_skeleton_get_height (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
qemu_dbus_display1_console_skeleton_get_device_address (QemuDBusDisplay1Console *object)
{
  QemuDBusDisplay1ConsoleSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CONSOLE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
qemu_dbus_display1_console_skeleton_class_init (QemuDBusDisplay1ConsoleSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_console_skeleton_finalize;
  gobject_class->get_property = qemu_dbus_display1_console_skeleton_get_property;
  gobject_class->set_property = qemu_dbus_display1_console_skeleton_set_property;
  gobject_class->notify       = qemu_dbus_display1_console_skeleton_notify;


  qemu_dbus_display1_console_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_console_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_console_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_console_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_console_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ConsoleSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_console_skeleton_iface_init (QemuDBusDisplay1ConsoleIface *iface)
{
  iface->get_label = qemu_dbus_display1_console_skeleton_get_label;
  iface->get_head = qemu_dbus_display1_console_skeleton_get_head;
  iface->get_type_ = qemu_dbus_display1_console_skeleton_get_type_;
  iface->get_width = qemu_dbus_display1_console_skeleton_get_width;
  iface->get_height = qemu_dbus_display1_console_skeleton_get_height;
  iface->get_device_address = qemu_dbus_display1_console_skeleton_get_device_address;
}

/**
 * qemu_dbus_display1_console_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Console.top_of_page">org.qemu.Display1.Console</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ConsoleSkeleton): The skeleton object.
 */
QemuDBusDisplay1Console *
qemu_dbus_display1_console_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_CONSOLE (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_CONSOLE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.Keyboard
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1Keyboard
 * @title: QemuDBusDisplay1Keyboard
 * @short_description: Generated C code for the org.qemu.Display1.Keyboard D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-Keyboard.top_of_page">org.qemu.Display1.Keyboard</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.Keyboard ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_keyboard_method_info_press_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_keyboard_method_info_press_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_keyboard_method_info_press_IN_ARG_keycode.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_keyboard_method_info_press =
{
  {
    -1,
    (gchar *) "Press",
    (GDBusArgInfo **) &_qemu_dbus_display1_keyboard_method_info_press_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-press",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_keyboard_method_info_release_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_keyboard_method_info_release_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_keyboard_method_info_release_IN_ARG_keycode.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_keyboard_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    (GDBusArgInfo **) &_qemu_dbus_display1_keyboard_method_info_release_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_keyboard_method_info_pointers[] =
{
  &_qemu_dbus_display1_keyboard_method_info_press.parent_struct,
  &_qemu_dbus_display1_keyboard_method_info_release.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_keyboard_property_info_modifiers =
{
  {
    -1,
    (gchar *) "Modifiers",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "modifiers",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _qemu_dbus_display1_keyboard_property_info_pointers[] =
{
  &_qemu_dbus_display1_keyboard_property_info_modifiers.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_keyboard_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.Keyboard",
    (GDBusMethodInfo **) &_qemu_dbus_display1_keyboard_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_qemu_dbus_display1_keyboard_property_info_pointers,
    NULL
  },
  "display1-keyboard",
};


/**
 * qemu_dbus_display1_keyboard_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-Keyboard.top_of_page">org.qemu.Display1.Keyboard</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_keyboard_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_keyboard_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_keyboard_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1Keyboard interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_keyboard_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "modifiers");
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1Keyboard:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Keyboard.top_of_page">org.qemu.Display1.Keyboard</link>.
 */

/**
 * QemuDBusDisplay1KeyboardIface:
 * @parent_iface: The parent interface.
 * @handle_press: Handler for the #QemuDBusDisplay1Keyboard::handle-press signal.
 * @handle_release: Handler for the #QemuDBusDisplay1Keyboard::handle-release signal.
 * @get_modifiers: Getter for the #QemuDBusDisplay1Keyboard:modifiers property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Keyboard.top_of_page">org.qemu.Display1.Keyboard</link>.
 */

typedef QemuDBusDisplay1KeyboardIface QemuDBusDisplay1KeyboardInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1Keyboard, qemu_dbus_display1_keyboard, G_TYPE_OBJECT)

static void
qemu_dbus_display1_keyboard_default_init (QemuDBusDisplay1KeyboardIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1Keyboard::handle-press:
   * @object: A #QemuDBusDisplay1Keyboard.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keycode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Press">Press()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_keyboard_complete_press() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-press",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1KeyboardIface, handle_press),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * QemuDBusDisplay1Keyboard::handle-release:
   * @object: A #QemuDBusDisplay1Keyboard.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keycode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_keyboard_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1KeyboardIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * QemuDBusDisplay1Keyboard:modifiers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Keyboard.Modifiers">"Modifiers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("modifiers", "Modifiers", "Modifiers", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * qemu_dbus_display1_keyboard_get_modifiers: (skip)
 * @object: A #QemuDBusDisplay1Keyboard.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Keyboard.Modifiers">"Modifiers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
qemu_dbus_display1_keyboard_get_modifiers (QemuDBusDisplay1Keyboard *object)
{
  return QEMU_DBUS_DISPLAY1_KEYBOARD_GET_IFACE (object)->get_modifiers (object);
}

/**
 * qemu_dbus_display1_keyboard_set_modifiers: (skip)
 * @object: A #QemuDBusDisplay1Keyboard.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Keyboard.Modifiers">"Modifiers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_keyboard_set_modifiers (QemuDBusDisplay1Keyboard *object, guint value)
{
  g_object_set (G_OBJECT (object), "modifiers", value, NULL);
}

/**
 * qemu_dbus_display1_keyboard_call_press:
 * @proxy: A #QemuDBusDisplay1KeyboardProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Press">Press()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_keyboard_call_press_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_keyboard_call_press_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_keyboard_call_press (
    QemuDBusDisplay1Keyboard *proxy,
    guint arg_keycode,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Press",
    g_variant_new ("(u)",
                   arg_keycode),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_keyboard_call_press_finish:
 * @proxy: A #QemuDBusDisplay1KeyboardProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_keyboard_call_press().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_keyboard_call_press().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_keyboard_call_press_finish (
    QemuDBusDisplay1Keyboard *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_keyboard_call_press_sync:
 * @proxy: A #QemuDBusDisplay1KeyboardProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Press">Press()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_keyboard_call_press() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_keyboard_call_press_sync (
    QemuDBusDisplay1Keyboard *proxy,
    guint arg_keycode,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Press",
    g_variant_new ("(u)",
                   arg_keycode),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_keyboard_call_release:
 * @proxy: A #QemuDBusDisplay1KeyboardProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_keyboard_call_release_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_keyboard_call_release_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_keyboard_call_release (
    QemuDBusDisplay1Keyboard *proxy,
    guint arg_keycode,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(u)",
                   arg_keycode),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_keyboard_call_release_finish:
 * @proxy: A #QemuDBusDisplay1KeyboardProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_keyboard_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_keyboard_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_keyboard_call_release_finish (
    QemuDBusDisplay1Keyboard *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_keyboard_call_release_sync:
 * @proxy: A #QemuDBusDisplay1KeyboardProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_keyboard_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_keyboard_call_release_sync (
    QemuDBusDisplay1Keyboard *proxy,
    guint arg_keycode,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(u)",
                   arg_keycode),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_keyboard_complete_press:
 * @object: A #QemuDBusDisplay1Keyboard.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Press">Press()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_keyboard_complete_press (
    QemuDBusDisplay1Keyboard *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_keyboard_complete_release:
 * @object: A #QemuDBusDisplay1Keyboard.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Keyboard.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_keyboard_complete_release (
    QemuDBusDisplay1Keyboard *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1KeyboardProxy:
 *
 * The #QemuDBusDisplay1KeyboardProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1KeyboardProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1KeyboardProxy.
 */

struct _QemuDBusDisplay1KeyboardProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_keyboard_proxy_iface_init (QemuDBusDisplay1KeyboardIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1KeyboardProxy, qemu_dbus_display1_keyboard_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1KeyboardProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD, qemu_dbus_display1_keyboard_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1KeyboardProxy, qemu_dbus_display1_keyboard_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD, qemu_dbus_display1_keyboard_proxy_iface_init))

#endif
static void
qemu_dbus_display1_keyboard_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1KeyboardProxy *proxy = QEMU_DBUS_DISPLAY1_KEYBOARD_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_keyboard_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_keyboard_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_keyboard_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
qemu_dbus_display1_keyboard_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.qemu.Display1.Keyboard: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
qemu_dbus_display1_keyboard_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_keyboard_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.qemu.Display1.Keyboard", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) qemu_dbus_display1_keyboard_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
qemu_dbus_display1_keyboard_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_keyboard_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_keyboard_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1KeyboardProxy *proxy = QEMU_DBUS_DISPLAY1_KEYBOARD_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_keyboard_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_keyboard_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
qemu_dbus_display1_keyboard_proxy_get_modifiers (QemuDBusDisplay1Keyboard *object)
{
  QemuDBusDisplay1KeyboardProxy *proxy = QEMU_DBUS_DISPLAY1_KEYBOARD_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Modifiers");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
qemu_dbus_display1_keyboard_proxy_init (QemuDBusDisplay1KeyboardProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_keyboard_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD_PROXY, QemuDBusDisplay1KeyboardProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_keyboard_interface_info ());
}

static void
qemu_dbus_display1_keyboard_proxy_class_init (QemuDBusDisplay1KeyboardProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_keyboard_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_keyboard_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_keyboard_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_keyboard_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_keyboard_proxy_g_properties_changed;

  qemu_dbus_display1_keyboard_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1KeyboardProxyPrivate));
#endif
}

static void
qemu_dbus_display1_keyboard_proxy_iface_init (QemuDBusDisplay1KeyboardIface *iface)
{
  iface->get_modifiers = qemu_dbus_display1_keyboard_proxy_get_modifiers;
}

/**
 * qemu_dbus_display1_keyboard_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Keyboard.top_of_page">org.qemu.Display1.Keyboard</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_keyboard_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_keyboard_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_keyboard_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Keyboard", NULL);
}

/**
 * qemu_dbus_display1_keyboard_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_keyboard_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_keyboard_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1KeyboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Keyboard *
qemu_dbus_display1_keyboard_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_KEYBOARD (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_keyboard_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Keyboard.top_of_page">org.qemu.Display1.Keyboard</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_keyboard_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1KeyboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Keyboard *
qemu_dbus_display1_keyboard_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Keyboard", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_KEYBOARD (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_keyboard_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_keyboard_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_keyboard_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_keyboard_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_keyboard_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Keyboard", NULL);
}

/**
 * qemu_dbus_display1_keyboard_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_keyboard_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_keyboard_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1KeyboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Keyboard *
qemu_dbus_display1_keyboard_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_KEYBOARD (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_keyboard_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_keyboard_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_keyboard_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1KeyboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Keyboard *
qemu_dbus_display1_keyboard_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Keyboard", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_KEYBOARD (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1KeyboardSkeleton:
 *
 * The #QemuDBusDisplay1KeyboardSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1KeyboardSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1KeyboardSkeleton.
 */

struct _QemuDBusDisplay1KeyboardSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_keyboard_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_keyboard_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_keyboard_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_keyboard_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_keyboard_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_keyboard_skeleton_vtable =
{
  _qemu_dbus_display1_keyboard_skeleton_handle_method_call,
  _qemu_dbus_display1_keyboard_skeleton_handle_get_property,
  _qemu_dbus_display1_keyboard_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_keyboard_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_keyboard_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_keyboard_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_keyboard_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_keyboard_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_keyboard_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_keyboard_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_keyboard_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_keyboard_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.Keyboard", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _qemu_dbus_display1_keyboard_emit_changed (gpointer user_data);

static void
qemu_dbus_display1_keyboard_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _qemu_dbus_display1_keyboard_emit_changed (skeleton);
}

static void qemu_dbus_display1_keyboard_skeleton_iface_init (QemuDBusDisplay1KeyboardIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1KeyboardSkeleton, qemu_dbus_display1_keyboard_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1KeyboardSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD, qemu_dbus_display1_keyboard_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1KeyboardSkeleton, qemu_dbus_display1_keyboard_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD, qemu_dbus_display1_keyboard_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_keyboard_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_keyboard_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_keyboard_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_qemu_dbus_display1_keyboard_emit_changed (gpointer user_data)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.qemu.Display1.Keyboard",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_qemu_dbus_display1_keyboard_schedule_emit_changed (QemuDBusDisplay1KeyboardSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
qemu_dbus_display1_keyboard_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _qemu_dbus_display1_keyboard_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _qemu_dbus_display1_keyboard_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
qemu_dbus_display1_keyboard_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_keyboard_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _qemu_dbus_display1_keyboard_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
qemu_dbus_display1_keyboard_skeleton_init (QemuDBusDisplay1KeyboardSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_keyboard_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD_SKELETON, QemuDBusDisplay1KeyboardSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
qemu_dbus_display1_keyboard_skeleton_get_modifiers (QemuDBusDisplay1Keyboard *object)
{
  QemuDBusDisplay1KeyboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_KEYBOARD_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
qemu_dbus_display1_keyboard_skeleton_class_init (QemuDBusDisplay1KeyboardSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_keyboard_skeleton_finalize;
  gobject_class->get_property = qemu_dbus_display1_keyboard_skeleton_get_property;
  gobject_class->set_property = qemu_dbus_display1_keyboard_skeleton_set_property;
  gobject_class->notify       = qemu_dbus_display1_keyboard_skeleton_notify;


  qemu_dbus_display1_keyboard_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_keyboard_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_keyboard_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_keyboard_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_keyboard_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1KeyboardSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_keyboard_skeleton_iface_init (QemuDBusDisplay1KeyboardIface *iface)
{
  iface->get_modifiers = qemu_dbus_display1_keyboard_skeleton_get_modifiers;
}

/**
 * qemu_dbus_display1_keyboard_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Keyboard.top_of_page">org.qemu.Display1.Keyboard</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1KeyboardSkeleton): The skeleton object.
 */
QemuDBusDisplay1Keyboard *
qemu_dbus_display1_keyboard_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_KEYBOARD (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_KEYBOARD_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.Mouse
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1Mouse
 * @title: QemuDBusDisplay1Mouse
 * @short_description: Generated C code for the org.qemu.Display1.Mouse D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-Mouse.top_of_page">org.qemu.Display1.Mouse</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.Mouse ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_mouse_method_info_press_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_mouse_method_info_press_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_mouse_method_info_press_IN_ARG_button.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_mouse_method_info_press =
{
  {
    -1,
    (gchar *) "Press",
    (GDBusArgInfo **) &_qemu_dbus_display1_mouse_method_info_press_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-press",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_mouse_method_info_release_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_mouse_method_info_release_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_mouse_method_info_release_IN_ARG_button.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_mouse_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    (GDBusArgInfo **) &_qemu_dbus_display1_mouse_method_info_release_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_mouse_method_info_set_abs_position_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_mouse_method_info_set_abs_position_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_mouse_method_info_set_abs_position_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_mouse_method_info_set_abs_position_IN_ARG_x.parent_struct,
  &_qemu_dbus_display1_mouse_method_info_set_abs_position_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_mouse_method_info_set_abs_position =
{
  {
    -1,
    (gchar *) "SetAbsPosition",
    (GDBusArgInfo **) &_qemu_dbus_display1_mouse_method_info_set_abs_position_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-abs-position",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_mouse_method_info_rel_motion_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_mouse_method_info_rel_motion_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_mouse_method_info_rel_motion_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_mouse_method_info_rel_motion_IN_ARG_dx.parent_struct,
  &_qemu_dbus_display1_mouse_method_info_rel_motion_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_mouse_method_info_rel_motion =
{
  {
    -1,
    (gchar *) "RelMotion",
    (GDBusArgInfo **) &_qemu_dbus_display1_mouse_method_info_rel_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-rel-motion",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_mouse_method_info_pointers[] =
{
  &_qemu_dbus_display1_mouse_method_info_press.parent_struct,
  &_qemu_dbus_display1_mouse_method_info_release.parent_struct,
  &_qemu_dbus_display1_mouse_method_info_set_abs_position.parent_struct,
  &_qemu_dbus_display1_mouse_method_info_rel_motion.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_mouse_property_info_is_absolute =
{
  {
    -1,
    (gchar *) "IsAbsolute",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "is-absolute",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _qemu_dbus_display1_mouse_property_info_pointers[] =
{
  &_qemu_dbus_display1_mouse_property_info_is_absolute.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_mouse_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.Mouse",
    (GDBusMethodInfo **) &_qemu_dbus_display1_mouse_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_qemu_dbus_display1_mouse_property_info_pointers,
    NULL
  },
  "display1-mouse",
};


/**
 * qemu_dbus_display1_mouse_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-Mouse.top_of_page">org.qemu.Display1.Mouse</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_mouse_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_mouse_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_mouse_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1Mouse interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_mouse_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "is-absolute");
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1Mouse:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Mouse.top_of_page">org.qemu.Display1.Mouse</link>.
 */

/**
 * QemuDBusDisplay1MouseIface:
 * @parent_iface: The parent interface.
 * @handle_press: Handler for the #QemuDBusDisplay1Mouse::handle-press signal.
 * @handle_rel_motion: Handler for the #QemuDBusDisplay1Mouse::handle-rel-motion signal.
 * @handle_release: Handler for the #QemuDBusDisplay1Mouse::handle-release signal.
 * @handle_set_abs_position: Handler for the #QemuDBusDisplay1Mouse::handle-set-abs-position signal.
 * @get_is_absolute: Getter for the #QemuDBusDisplay1Mouse:is-absolute property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Mouse.top_of_page">org.qemu.Display1.Mouse</link>.
 */

typedef QemuDBusDisplay1MouseIface QemuDBusDisplay1MouseInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1Mouse, qemu_dbus_display1_mouse, G_TYPE_OBJECT)

static void
qemu_dbus_display1_mouse_default_init (QemuDBusDisplay1MouseIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1Mouse::handle-press:
   * @object: A #QemuDBusDisplay1Mouse.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_button: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Press">Press()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_mouse_complete_press() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-press",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1MouseIface, handle_press),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * QemuDBusDisplay1Mouse::handle-release:
   * @object: A #QemuDBusDisplay1Mouse.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_button: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_mouse_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1MouseIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * QemuDBusDisplay1Mouse::handle-set-abs-position:
   * @object: A #QemuDBusDisplay1Mouse.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Mouse.SetAbsPosition">SetAbsPosition()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_mouse_complete_set_abs_position() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-abs-position",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1MouseIface, handle_set_abs_position),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * QemuDBusDisplay1Mouse::handle-rel-motion:
   * @object: A #QemuDBusDisplay1Mouse.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Mouse.RelMotion">RelMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_mouse_complete_rel_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-rel-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1MouseIface, handle_rel_motion),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /* GObject properties for D-Bus properties: */
  /**
   * QemuDBusDisplay1Mouse:is-absolute:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Mouse.IsAbsolute">"IsAbsolute"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("is-absolute", "IsAbsolute", "IsAbsolute", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * qemu_dbus_display1_mouse_get_is_absolute: (skip)
 * @object: A #QemuDBusDisplay1Mouse.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Mouse.IsAbsolute">"IsAbsolute"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
qemu_dbus_display1_mouse_get_is_absolute (QemuDBusDisplay1Mouse *object)
{
  return QEMU_DBUS_DISPLAY1_MOUSE_GET_IFACE (object)->get_is_absolute (object);
}

/**
 * qemu_dbus_display1_mouse_set_is_absolute: (skip)
 * @object: A #QemuDBusDisplay1Mouse.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Mouse.IsAbsolute">"IsAbsolute"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_mouse_set_is_absolute (QemuDBusDisplay1Mouse *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "is-absolute", value, NULL);
}

/**
 * qemu_dbus_display1_mouse_call_press:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Press">Press()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_mouse_call_press_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_mouse_call_press_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_mouse_call_press (
    QemuDBusDisplay1Mouse *proxy,
    guint arg_button,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Press",
    g_variant_new ("(u)",
                   arg_button),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_mouse_call_press_finish:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_mouse_call_press().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_mouse_call_press().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_press_finish (
    QemuDBusDisplay1Mouse *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_call_press_sync:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Press">Press()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_mouse_call_press() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_press_sync (
    QemuDBusDisplay1Mouse *proxy,
    guint arg_button,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Press",
    g_variant_new ("(u)",
                   arg_button),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_call_release:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_mouse_call_release_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_mouse_call_release_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_mouse_call_release (
    QemuDBusDisplay1Mouse *proxy,
    guint arg_button,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(u)",
                   arg_button),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_mouse_call_release_finish:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_mouse_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_mouse_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_release_finish (
    QemuDBusDisplay1Mouse *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_call_release_sync:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_mouse_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_release_sync (
    QemuDBusDisplay1Mouse *proxy,
    guint arg_button,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(u)",
                   arg_button),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_call_set_abs_position:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.SetAbsPosition">SetAbsPosition()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_mouse_call_set_abs_position_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_mouse_call_set_abs_position_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_mouse_call_set_abs_position (
    QemuDBusDisplay1Mouse *proxy,
    guint arg_x,
    guint arg_y,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetAbsPosition",
    g_variant_new ("(uu)",
                   arg_x,
                   arg_y),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_mouse_call_set_abs_position_finish:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_mouse_call_set_abs_position().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_mouse_call_set_abs_position().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_set_abs_position_finish (
    QemuDBusDisplay1Mouse *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_call_set_abs_position_sync:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.SetAbsPosition">SetAbsPosition()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_mouse_call_set_abs_position() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_set_abs_position_sync (
    QemuDBusDisplay1Mouse *proxy,
    guint arg_x,
    guint arg_y,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetAbsPosition",
    g_variant_new ("(uu)",
                   arg_x,
                   arg_y),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_call_rel_motion:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.RelMotion">RelMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_mouse_call_rel_motion_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_mouse_call_rel_motion_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_mouse_call_rel_motion (
    QemuDBusDisplay1Mouse *proxy,
    gint arg_dx,
    gint arg_dy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RelMotion",
    g_variant_new ("(ii)",
                   arg_dx,
                   arg_dy),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_mouse_call_rel_motion_finish:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_mouse_call_rel_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_mouse_call_rel_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_rel_motion_finish (
    QemuDBusDisplay1Mouse *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_call_rel_motion_sync:
 * @proxy: A #QemuDBusDisplay1MouseProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Mouse.RelMotion">RelMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_mouse_call_rel_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_mouse_call_rel_motion_sync (
    QemuDBusDisplay1Mouse *proxy,
    gint arg_dx,
    gint arg_dy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RelMotion",
    g_variant_new ("(ii)",
                   arg_dx,
                   arg_dy),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_mouse_complete_press:
 * @object: A #QemuDBusDisplay1Mouse.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Press">Press()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_mouse_complete_press (
    QemuDBusDisplay1Mouse *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_mouse_complete_release:
 * @object: A #QemuDBusDisplay1Mouse.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Mouse.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_mouse_complete_release (
    QemuDBusDisplay1Mouse *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_mouse_complete_set_abs_position:
 * @object: A #QemuDBusDisplay1Mouse.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Mouse.SetAbsPosition">SetAbsPosition()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_mouse_complete_set_abs_position (
    QemuDBusDisplay1Mouse *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_mouse_complete_rel_motion:
 * @object: A #QemuDBusDisplay1Mouse.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Mouse.RelMotion">RelMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_mouse_complete_rel_motion (
    QemuDBusDisplay1Mouse *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1MouseProxy:
 *
 * The #QemuDBusDisplay1MouseProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1MouseProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1MouseProxy.
 */

struct _QemuDBusDisplay1MouseProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_mouse_proxy_iface_init (QemuDBusDisplay1MouseIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1MouseProxy, qemu_dbus_display1_mouse_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1MouseProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_MOUSE, qemu_dbus_display1_mouse_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1MouseProxy, qemu_dbus_display1_mouse_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_MOUSE, qemu_dbus_display1_mouse_proxy_iface_init))

#endif
static void
qemu_dbus_display1_mouse_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1MouseProxy *proxy = QEMU_DBUS_DISPLAY1_MOUSE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_mouse_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_mouse_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_mouse_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
qemu_dbus_display1_mouse_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.qemu.Display1.Mouse: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
qemu_dbus_display1_mouse_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_mouse_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.qemu.Display1.Mouse", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) qemu_dbus_display1_mouse_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
qemu_dbus_display1_mouse_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_mouse_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_MOUSE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_MOUSE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_mouse_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1MouseProxy *proxy = QEMU_DBUS_DISPLAY1_MOUSE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_mouse_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_mouse_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
qemu_dbus_display1_mouse_proxy_get_is_absolute (QemuDBusDisplay1Mouse *object)
{
  QemuDBusDisplay1MouseProxy *proxy = QEMU_DBUS_DISPLAY1_MOUSE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IsAbsolute");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
qemu_dbus_display1_mouse_proxy_init (QemuDBusDisplay1MouseProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_mouse_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_MOUSE_PROXY, QemuDBusDisplay1MouseProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_mouse_interface_info ());
}

static void
qemu_dbus_display1_mouse_proxy_class_init (QemuDBusDisplay1MouseProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_mouse_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_mouse_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_mouse_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_mouse_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_mouse_proxy_g_properties_changed;

  qemu_dbus_display1_mouse_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1MouseProxyPrivate));
#endif
}

static void
qemu_dbus_display1_mouse_proxy_iface_init (QemuDBusDisplay1MouseIface *iface)
{
  iface->get_is_absolute = qemu_dbus_display1_mouse_proxy_get_is_absolute;
}

/**
 * qemu_dbus_display1_mouse_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Mouse.top_of_page">org.qemu.Display1.Mouse</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_mouse_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_mouse_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_mouse_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_MOUSE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Mouse", NULL);
}

/**
 * qemu_dbus_display1_mouse_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_mouse_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_mouse_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1MouseProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Mouse *
qemu_dbus_display1_mouse_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_MOUSE (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_mouse_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Mouse.top_of_page">org.qemu.Display1.Mouse</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_mouse_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1MouseProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Mouse *
qemu_dbus_display1_mouse_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_MOUSE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Mouse", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_MOUSE (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_mouse_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_mouse_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_mouse_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_mouse_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_mouse_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_MOUSE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Mouse", NULL);
}

/**
 * qemu_dbus_display1_mouse_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_mouse_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_mouse_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1MouseProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Mouse *
qemu_dbus_display1_mouse_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_MOUSE (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_mouse_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_mouse_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_mouse_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1MouseProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Mouse *
qemu_dbus_display1_mouse_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_MOUSE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Mouse", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_MOUSE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1MouseSkeleton:
 *
 * The #QemuDBusDisplay1MouseSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1MouseSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1MouseSkeleton.
 */

struct _QemuDBusDisplay1MouseSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_mouse_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_MOUSE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_MOUSE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_mouse_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_mouse_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_mouse_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_mouse_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_mouse_skeleton_vtable =
{
  _qemu_dbus_display1_mouse_skeleton_handle_method_call,
  _qemu_dbus_display1_mouse_skeleton_handle_get_property,
  _qemu_dbus_display1_mouse_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_mouse_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_mouse_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_mouse_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_mouse_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_mouse_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_mouse_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_mouse_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_mouse_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_mouse_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.Mouse", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _qemu_dbus_display1_mouse_emit_changed (gpointer user_data);

static void
qemu_dbus_display1_mouse_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _qemu_dbus_display1_mouse_emit_changed (skeleton);
}

static void qemu_dbus_display1_mouse_skeleton_iface_init (QemuDBusDisplay1MouseIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1MouseSkeleton, qemu_dbus_display1_mouse_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1MouseSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_MOUSE, qemu_dbus_display1_mouse_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1MouseSkeleton, qemu_dbus_display1_mouse_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_MOUSE, qemu_dbus_display1_mouse_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_mouse_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_mouse_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_mouse_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_qemu_dbus_display1_mouse_emit_changed (gpointer user_data)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.qemu.Display1.Mouse",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_qemu_dbus_display1_mouse_schedule_emit_changed (QemuDBusDisplay1MouseSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
qemu_dbus_display1_mouse_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _qemu_dbus_display1_mouse_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _qemu_dbus_display1_mouse_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
qemu_dbus_display1_mouse_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_mouse_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _qemu_dbus_display1_mouse_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
qemu_dbus_display1_mouse_skeleton_init (QemuDBusDisplay1MouseSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_mouse_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_MOUSE_SKELETON, QemuDBusDisplay1MouseSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
}

static gboolean 
qemu_dbus_display1_mouse_skeleton_get_is_absolute (QemuDBusDisplay1Mouse *object)
{
  QemuDBusDisplay1MouseSkeleton *skeleton = QEMU_DBUS_DISPLAY1_MOUSE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
qemu_dbus_display1_mouse_skeleton_class_init (QemuDBusDisplay1MouseSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_mouse_skeleton_finalize;
  gobject_class->get_property = qemu_dbus_display1_mouse_skeleton_get_property;
  gobject_class->set_property = qemu_dbus_display1_mouse_skeleton_set_property;
  gobject_class->notify       = qemu_dbus_display1_mouse_skeleton_notify;


  qemu_dbus_display1_mouse_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_mouse_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_mouse_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_mouse_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_mouse_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1MouseSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_mouse_skeleton_iface_init (QemuDBusDisplay1MouseIface *iface)
{
  iface->get_is_absolute = qemu_dbus_display1_mouse_skeleton_get_is_absolute;
}

/**
 * qemu_dbus_display1_mouse_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Mouse.top_of_page">org.qemu.Display1.Mouse</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1MouseSkeleton): The skeleton object.
 */
QemuDBusDisplay1Mouse *
qemu_dbus_display1_mouse_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_MOUSE (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_MOUSE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.Listener
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1Listener
 * @title: QemuDBusDisplay1Listener
 * @short_description: Generated C code for the org.qemu.Display1.Listener D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-Listener.top_of_page">org.qemu.Display1.Listener</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.Listener ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_IN_ARG_stride =
{
  {
    -1,
    (gchar *) "stride",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_IN_ARG_pixman_format =
{
  {
    -1,
    (gchar *) "pixman_format",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_listener_method_info_scanout_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_listener_method_info_scanout_IN_ARG_width.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_IN_ARG_height.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_IN_ARG_stride.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_IN_ARG_pixman_format.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_listener_method_info_scanout =
{
  {
    -1,
    (gchar *) "Scanout",
    (GDBusArgInfo **) &_qemu_dbus_display1_listener_method_info_scanout_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-scanout",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_IN_ARG_stride =
{
  {
    -1,
    (gchar *) "stride",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_IN_ARG_pixman_format =
{
  {
    -1,
    (gchar *) "pixman_format",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_listener_method_info_update_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_listener_method_info_update_IN_ARG_x.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_IN_ARG_y.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_IN_ARG_width.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_IN_ARG_height.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_IN_ARG_stride.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_IN_ARG_pixman_format.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_listener_method_info_update =
{
  {
    -1,
    (gchar *) "Update",
    (GDBusArgInfo **) &_qemu_dbus_display1_listener_method_info_update_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_dmabuf =
{
  {
    -1,
    (gchar *) "dmabuf",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_stride =
{
  {
    -1,
    (gchar *) "stride",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_fourcc =
{
  {
    -1,
    (gchar *) "fourcc",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_modifier =
{
  {
    -1,
    (gchar *) "modifier",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_y0_top =
{
  {
    -1,
    (gchar *) "y0_top",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_dmabuf.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_width.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_height.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_stride.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_fourcc.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_modifier.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_y0_top.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_listener_method_info_scanout_dmabuf =
{
  {
    -1,
    (gchar *) "ScanoutDMABUF",
    (GDBusArgInfo **) &_qemu_dbus_display1_listener_method_info_scanout_dmabuf_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-scanout-dmabuf",
  TRUE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_x.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_y.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_width.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_listener_method_info_update_dmabuf =
{
  {
    -1,
    (gchar *) "UpdateDMABUF",
    (GDBusArgInfo **) &_qemu_dbus_display1_listener_method_info_update_dmabuf_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-dmabuf",
  FALSE
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_listener_method_info_disable =
{
  {
    -1,
    (gchar *) "Disable",
    NULL,
    NULL,
    NULL
  },
  "handle-disable",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_on =
{
  {
    -1,
    (gchar *) "on",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_x.parent_struct,
  &_qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_y.parent_struct,
  &_qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_on.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_listener_method_info_mouse_set =
{
  {
    -1,
    (gchar *) "MouseSet",
    (GDBusArgInfo **) &_qemu_dbus_display1_listener_method_info_mouse_set_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-mouse-set",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_hot_x =
{
  {
    -1,
    (gchar *) "hot_x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_hot_y =
{
  {
    -1,
    (gchar *) "hot_y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_width.parent_struct,
  &_qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_height.parent_struct,
  &_qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_hot_x.parent_struct,
  &_qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_hot_y.parent_struct,
  &_qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_listener_method_info_cursor_define =
{
  {
    -1,
    (gchar *) "CursorDefine",
    (GDBusArgInfo **) &_qemu_dbus_display1_listener_method_info_cursor_define_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-cursor-define",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_listener_method_info_pointers[] =
{
  &_qemu_dbus_display1_listener_method_info_scanout.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update.parent_struct,
  &_qemu_dbus_display1_listener_method_info_scanout_dmabuf.parent_struct,
  &_qemu_dbus_display1_listener_method_info_update_dmabuf.parent_struct,
  &_qemu_dbus_display1_listener_method_info_disable.parent_struct,
  &_qemu_dbus_display1_listener_method_info_mouse_set.parent_struct,
  &_qemu_dbus_display1_listener_method_info_cursor_define.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_listener_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.Listener",
    (GDBusMethodInfo **) &_qemu_dbus_display1_listener_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "display1-listener",
};


/**
 * qemu_dbus_display1_listener_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-Listener.top_of_page">org.qemu.Display1.Listener</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_listener_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_listener_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_listener_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1Listener interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_listener_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1Listener:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Listener.top_of_page">org.qemu.Display1.Listener</link>.
 */

/**
 * QemuDBusDisplay1ListenerIface:
 * @parent_iface: The parent interface.
 * @handle_cursor_define: Handler for the #QemuDBusDisplay1Listener::handle-cursor-define signal.
 * @handle_disable: Handler for the #QemuDBusDisplay1Listener::handle-disable signal.
 * @handle_mouse_set: Handler for the #QemuDBusDisplay1Listener::handle-mouse-set signal.
 * @handle_scanout: Handler for the #QemuDBusDisplay1Listener::handle-scanout signal.
 * @handle_scanout_dmabuf: Handler for the #QemuDBusDisplay1Listener::handle-scanout-dmabuf signal.
 * @handle_update: Handler for the #QemuDBusDisplay1Listener::handle-update signal.
 * @handle_update_dmabuf: Handler for the #QemuDBusDisplay1Listener::handle-update-dmabuf signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Listener.top_of_page">org.qemu.Display1.Listener</link>.
 */

typedef QemuDBusDisplay1ListenerIface QemuDBusDisplay1ListenerInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1Listener, qemu_dbus_display1_listener, G_TYPE_OBJECT)

static void
qemu_dbus_display1_listener_default_init (QemuDBusDisplay1ListenerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1Listener::handle-scanout:
   * @object: A #QemuDBusDisplay1Listener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_stride: Argument passed by remote caller.
   * @arg_pixman_format: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Listener.Scanout">Scanout()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_listener_complete_scanout() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-scanout",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ListenerIface, handle_scanout),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * QemuDBusDisplay1Listener::handle-update:
   * @object: A #QemuDBusDisplay1Listener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_stride: Argument passed by remote caller.
   * @arg_pixman_format: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Listener.Update">Update()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_listener_complete_update() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ListenerIface, handle_update),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * QemuDBusDisplay1Listener::handle-scanout-dmabuf:
   * @object: A #QemuDBusDisplay1Listener.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_dmabuf: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_stride: Argument passed by remote caller.
   * @arg_fourcc: Argument passed by remote caller.
   * @arg_modifier: Argument passed by remote caller.
   * @arg_y0_top: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Listener.ScanoutDMABUF">ScanoutDMABUF()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_listener_complete_scanout_dmabuf() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-scanout-dmabuf",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ListenerIface, handle_scanout_dmabuf),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    9,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT64, G_TYPE_BOOLEAN);

  /**
   * QemuDBusDisplay1Listener::handle-update-dmabuf:
   * @object: A #QemuDBusDisplay1Listener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Listener.UpdateDMABUF">UpdateDMABUF()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_listener_complete_update_dmabuf() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-dmabuf",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ListenerIface, handle_update_dmabuf),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * QemuDBusDisplay1Listener::handle-disable:
   * @object: A #QemuDBusDisplay1Listener.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Listener.Disable">Disable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_listener_complete_disable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ListenerIface, handle_disable),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * QemuDBusDisplay1Listener::handle-mouse-set:
   * @object: A #QemuDBusDisplay1Listener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_on: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Listener.MouseSet">MouseSet()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_listener_complete_mouse_set() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mouse-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ListenerIface, handle_mouse_set),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * QemuDBusDisplay1Listener::handle-cursor-define:
   * @object: A #QemuDBusDisplay1Listener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_hot_x: Argument passed by remote caller.
   * @arg_hot_y: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Listener.CursorDefine">CursorDefine()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_listener_complete_cursor_define() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cursor-define",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ListenerIface, handle_cursor_define),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_VARIANT);

}

/**
 * qemu_dbus_display1_listener_call_scanout:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_stride: Argument to pass with the method invocation.
 * @arg_pixman_format: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.Scanout">Scanout()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_call_scanout_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_call_scanout_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_listener_call_scanout (
    QemuDBusDisplay1Listener *proxy,
    guint arg_width,
    guint arg_height,
    guint arg_stride,
    guint arg_pixman_format,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Scanout",
    g_variant_new ("(uuuu@ay)",
                   arg_width,
                   arg_height,
                   arg_stride,
                   arg_pixman_format,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_listener_call_scanout_finish:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_call_scanout().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_listener_call_scanout().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_scanout_finish (
    QemuDBusDisplay1Listener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_scanout_sync:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_stride: Argument to pass with the method invocation.
 * @arg_pixman_format: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.Scanout">Scanout()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_call_scanout() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_scanout_sync (
    QemuDBusDisplay1Listener *proxy,
    guint arg_width,
    guint arg_height,
    guint arg_stride,
    guint arg_pixman_format,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Scanout",
    g_variant_new ("(uuuu@ay)",
                   arg_width,
                   arg_height,
                   arg_stride,
                   arg_pixman_format,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_update:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_stride: Argument to pass with the method invocation.
 * @arg_pixman_format: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.Update">Update()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_call_update_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_call_update_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_listener_call_update (
    QemuDBusDisplay1Listener *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    guint arg_stride,
    guint arg_pixman_format,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Update",
    g_variant_new ("(iiiiuu@ay)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_stride,
                   arg_pixman_format,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_listener_call_update_finish:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_call_update().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_listener_call_update().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_update_finish (
    QemuDBusDisplay1Listener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_update_sync:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_stride: Argument to pass with the method invocation.
 * @arg_pixman_format: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.Update">Update()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_call_update() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_update_sync (
    QemuDBusDisplay1Listener *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    guint arg_stride,
    guint arg_pixman_format,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Update",
    g_variant_new ("(iiiiuu@ay)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_stride,
                   arg_pixman_format,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_scanout_dmabuf:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_dmabuf: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_stride: Argument to pass with the method invocation.
 * @arg_fourcc: Argument to pass with the method invocation.
 * @arg_modifier: Argument to pass with the method invocation.
 * @arg_y0_top: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.ScanoutDMABUF">ScanoutDMABUF()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_call_scanout_dmabuf_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_call_scanout_dmabuf_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_listener_call_scanout_dmabuf (
    QemuDBusDisplay1Listener *proxy,
    GVariant *arg_dmabuf,
    guint arg_width,
    guint arg_height,
    guint arg_stride,
    guint arg_fourcc,
    guint64 arg_modifier,
    gboolean arg_y0_top,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "ScanoutDMABUF",
    g_variant_new ("(@huuuutb)",
                   arg_dmabuf,
                   arg_width,
                   arg_height,
                   arg_stride,
                   arg_fourcc,
                   arg_modifier,
                   arg_y0_top),
    call_flags,
    timeout_msec,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_listener_call_scanout_dmabuf_finish:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_call_scanout_dmabuf().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_listener_call_scanout_dmabuf().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_scanout_dmabuf_finish (
    QemuDBusDisplay1Listener *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_scanout_dmabuf_sync:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_dmabuf: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_stride: Argument to pass with the method invocation.
 * @arg_fourcc: Argument to pass with the method invocation.
 * @arg_modifier: Argument to pass with the method invocation.
 * @arg_y0_top: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.ScanoutDMABUF">ScanoutDMABUF()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_call_scanout_dmabuf() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_scanout_dmabuf_sync (
    QemuDBusDisplay1Listener *proxy,
    GVariant *arg_dmabuf,
    guint arg_width,
    guint arg_height,
    guint arg_stride,
    guint arg_fourcc,
    guint64 arg_modifier,
    gboolean arg_y0_top,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "ScanoutDMABUF",
    g_variant_new ("(@huuuutb)",
                   arg_dmabuf,
                   arg_width,
                   arg_height,
                   arg_stride,
                   arg_fourcc,
                   arg_modifier,
                   arg_y0_top),
    call_flags,
    timeout_msec,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_update_dmabuf:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.UpdateDMABUF">UpdateDMABUF()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_call_update_dmabuf_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_call_update_dmabuf_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_listener_call_update_dmabuf (
    QemuDBusDisplay1Listener *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateDMABUF",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_listener_call_update_dmabuf_finish:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_call_update_dmabuf().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_listener_call_update_dmabuf().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_update_dmabuf_finish (
    QemuDBusDisplay1Listener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_update_dmabuf_sync:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.UpdateDMABUF">UpdateDMABUF()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_call_update_dmabuf() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_update_dmabuf_sync (
    QemuDBusDisplay1Listener *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateDMABUF",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_disable:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.Disable">Disable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_call_disable_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_call_disable_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_listener_call_disable (
    QemuDBusDisplay1Listener *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_listener_call_disable_finish:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_call_disable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_listener_call_disable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_disable_finish (
    QemuDBusDisplay1Listener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_disable_sync:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.Disable">Disable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_call_disable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_disable_sync (
    QemuDBusDisplay1Listener *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_mouse_set:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_on: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.MouseSet">MouseSet()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_call_mouse_set_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_call_mouse_set_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_listener_call_mouse_set (
    QemuDBusDisplay1Listener *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_on,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MouseSet",
    g_variant_new ("(iii)",
                   arg_x,
                   arg_y,
                   arg_on),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_listener_call_mouse_set_finish:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_call_mouse_set().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_listener_call_mouse_set().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_mouse_set_finish (
    QemuDBusDisplay1Listener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_mouse_set_sync:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_on: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.MouseSet">MouseSet()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_call_mouse_set() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_mouse_set_sync (
    QemuDBusDisplay1Listener *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_on,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MouseSet",
    g_variant_new ("(iii)",
                   arg_x,
                   arg_y,
                   arg_on),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_cursor_define:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_hot_x: Argument to pass with the method invocation.
 * @arg_hot_y: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.CursorDefine">CursorDefine()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_call_cursor_define_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_call_cursor_define_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_listener_call_cursor_define (
    QemuDBusDisplay1Listener *proxy,
    gint arg_width,
    gint arg_height,
    gint arg_hot_x,
    gint arg_hot_y,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CursorDefine",
    g_variant_new ("(iiii@ay)",
                   arg_width,
                   arg_height,
                   arg_hot_x,
                   arg_hot_y,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_listener_call_cursor_define_finish:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_call_cursor_define().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_listener_call_cursor_define().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_cursor_define_finish (
    QemuDBusDisplay1Listener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_call_cursor_define_sync:
 * @proxy: A #QemuDBusDisplay1ListenerProxy.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_hot_x: Argument to pass with the method invocation.
 * @arg_hot_y: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Listener.CursorDefine">CursorDefine()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_call_cursor_define() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_listener_call_cursor_define_sync (
    QemuDBusDisplay1Listener *proxy,
    gint arg_width,
    gint arg_height,
    gint arg_hot_x,
    gint arg_hot_y,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CursorDefine",
    g_variant_new ("(iiii@ay)",
                   arg_width,
                   arg_height,
                   arg_hot_x,
                   arg_hot_y,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_listener_complete_scanout:
 * @object: A #QemuDBusDisplay1Listener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Listener.Scanout">Scanout()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_listener_complete_scanout (
    QemuDBusDisplay1Listener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_listener_complete_update:
 * @object: A #QemuDBusDisplay1Listener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Listener.Update">Update()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_listener_complete_update (
    QemuDBusDisplay1Listener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_listener_complete_scanout_dmabuf:
 * @object: A #QemuDBusDisplay1Listener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Listener.ScanoutDMABUF">ScanoutDMABUF()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_listener_complete_scanout_dmabuf (
    QemuDBusDisplay1Listener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/**
 * qemu_dbus_display1_listener_complete_update_dmabuf:
 * @object: A #QemuDBusDisplay1Listener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Listener.UpdateDMABUF">UpdateDMABUF()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_listener_complete_update_dmabuf (
    QemuDBusDisplay1Listener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_listener_complete_disable:
 * @object: A #QemuDBusDisplay1Listener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Listener.Disable">Disable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_listener_complete_disable (
    QemuDBusDisplay1Listener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_listener_complete_mouse_set:
 * @object: A #QemuDBusDisplay1Listener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Listener.MouseSet">MouseSet()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_listener_complete_mouse_set (
    QemuDBusDisplay1Listener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_listener_complete_cursor_define:
 * @object: A #QemuDBusDisplay1Listener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Listener.CursorDefine">CursorDefine()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_listener_complete_cursor_define (
    QemuDBusDisplay1Listener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ListenerProxy:
 *
 * The #QemuDBusDisplay1ListenerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ListenerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ListenerProxy.
 */

struct _QemuDBusDisplay1ListenerProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_listener_proxy_iface_init (QemuDBusDisplay1ListenerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ListenerProxy, qemu_dbus_display1_listener_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1ListenerProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_LISTENER, qemu_dbus_display1_listener_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ListenerProxy, qemu_dbus_display1_listener_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_LISTENER, qemu_dbus_display1_listener_proxy_iface_init))

#endif
static void
qemu_dbus_display1_listener_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1ListenerProxy *proxy = QEMU_DBUS_DISPLAY1_LISTENER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_listener_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_listener_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_listener_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_listener_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_listener_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_LISTENER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_LISTENER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_listener_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1ListenerProxy *proxy = QEMU_DBUS_DISPLAY1_LISTENER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_listener_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_listener_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
qemu_dbus_display1_listener_proxy_init (QemuDBusDisplay1ListenerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_listener_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_LISTENER_PROXY, QemuDBusDisplay1ListenerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_listener_interface_info ());
}

static void
qemu_dbus_display1_listener_proxy_class_init (QemuDBusDisplay1ListenerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_listener_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_listener_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_listener_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_listener_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_listener_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ListenerProxyPrivate));
#endif
}

static void
qemu_dbus_display1_listener_proxy_iface_init (QemuDBusDisplay1ListenerIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_listener_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Listener.top_of_page">org.qemu.Display1.Listener</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_listener_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_LISTENER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Listener", NULL);
}

/**
 * qemu_dbus_display1_listener_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_listener_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Listener *
qemu_dbus_display1_listener_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_LISTENER (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_listener_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Listener.top_of_page">org.qemu.Display1.Listener</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Listener *
qemu_dbus_display1_listener_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_LISTENER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Listener", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_LISTENER (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_listener_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_listener_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_listener_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_listener_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_listener_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_LISTENER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Listener", NULL);
}

/**
 * qemu_dbus_display1_listener_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_listener_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_listener_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Listener *
qemu_dbus_display1_listener_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_LISTENER (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_listener_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_listener_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_listener_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Listener *
qemu_dbus_display1_listener_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_LISTENER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Listener", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_LISTENER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ListenerSkeleton:
 *
 * The #QemuDBusDisplay1ListenerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ListenerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ListenerSkeleton.
 */

struct _QemuDBusDisplay1ListenerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_listener_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1ListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_LISTENER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_LISTENER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_LISTENER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_listener_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_LISTENER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_listener_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_listener_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_LISTENER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_listener_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_listener_skeleton_vtable =
{
  _qemu_dbus_display1_listener_skeleton_handle_method_call,
  _qemu_dbus_display1_listener_skeleton_handle_get_property,
  _qemu_dbus_display1_listener_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_listener_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_listener_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_listener_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_listener_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_listener_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1ListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_LISTENER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_listener_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_listener_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_listener_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_listener_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.Listener", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
qemu_dbus_display1_listener_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void qemu_dbus_display1_listener_skeleton_iface_init (QemuDBusDisplay1ListenerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ListenerSkeleton, qemu_dbus_display1_listener_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1ListenerSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_LISTENER, qemu_dbus_display1_listener_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ListenerSkeleton, qemu_dbus_display1_listener_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_LISTENER, qemu_dbus_display1_listener_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_listener_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1ListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_LISTENER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_listener_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_listener_skeleton_init (QemuDBusDisplay1ListenerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_listener_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_LISTENER_SKELETON, QemuDBusDisplay1ListenerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
qemu_dbus_display1_listener_skeleton_class_init (QemuDBusDisplay1ListenerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_listener_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_listener_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_listener_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_listener_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_listener_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ListenerSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_listener_skeleton_iface_init (QemuDBusDisplay1ListenerIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_listener_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Listener.top_of_page">org.qemu.Display1.Listener</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ListenerSkeleton): The skeleton object.
 */
QemuDBusDisplay1Listener *
qemu_dbus_display1_listener_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_LISTENER (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_LISTENER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.Clipboard
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1Clipboard
 * @title: QemuDBusDisplay1Clipboard
 * @short_description: Generated C code for the org.qemu.Display1.Clipboard D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-Clipboard.top_of_page">org.qemu.Display1.Clipboard</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.Clipboard ---- */

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_clipboard_method_info_register =
{
  {
    -1,
    (gchar *) "Register",
    NULL,
    NULL,
    NULL
  },
  "handle-register",
  FALSE
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_clipboard_method_info_unregister =
{
  {
    -1,
    (gchar *) "Unregister",
    NULL,
    NULL,
    NULL
  },
  "handle-unregister",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_selection =
{
  {
    -1,
    (gchar *) "selection",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_mimes =
{
  {
    -1,
    (gchar *) "mimes",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_selection.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_serial.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_mimes.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_clipboard_method_info_grab =
{
  {
    -1,
    (gchar *) "Grab",
    (GDBusArgInfo **) &_qemu_dbus_display1_clipboard_method_info_grab_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-grab",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_release_IN_ARG_selection =
{
  {
    -1,
    (gchar *) "selection",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_clipboard_method_info_release_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_clipboard_method_info_release_IN_ARG_selection.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_clipboard_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    (GDBusArgInfo **) &_qemu_dbus_display1_clipboard_method_info_release_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_request_IN_ARG_selection =
{
  {
    -1,
    (gchar *) "selection",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_request_IN_ARG_mimes =
{
  {
    -1,
    (gchar *) "mimes",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_clipboard_method_info_request_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_clipboard_method_info_request_IN_ARG_selection.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_request_IN_ARG_mimes.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_request_OUT_ARG_reply_mime =
{
  {
    -1,
    (gchar *) "reply_mime",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_clipboard_method_info_request_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_clipboard_method_info_request_OUT_ARG_pointers[] =
{
  &_qemu_dbus_display1_clipboard_method_info_request_OUT_ARG_reply_mime.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_request_OUT_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_clipboard_method_info_request =
{
  {
    -1,
    (gchar *) "Request",
    (GDBusArgInfo **) &_qemu_dbus_display1_clipboard_method_info_request_IN_ARG_pointers,
    (GDBusArgInfo **) &_qemu_dbus_display1_clipboard_method_info_request_OUT_ARG_pointers,
    NULL
  },
  "handle-request",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_clipboard_method_info_pointers[] =
{
  &_qemu_dbus_display1_clipboard_method_info_register.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_unregister.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_grab.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_release.parent_struct,
  &_qemu_dbus_display1_clipboard_method_info_request.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_clipboard_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.Clipboard",
    (GDBusMethodInfo **) &_qemu_dbus_display1_clipboard_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "display1-clipboard",
};


/**
 * qemu_dbus_display1_clipboard_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-Clipboard.top_of_page">org.qemu.Display1.Clipboard</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_clipboard_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_clipboard_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_clipboard_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1Clipboard interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_clipboard_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1Clipboard:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Clipboard.top_of_page">org.qemu.Display1.Clipboard</link>.
 */

/**
 * QemuDBusDisplay1ClipboardIface:
 * @parent_iface: The parent interface.
 * @handle_grab: Handler for the #QemuDBusDisplay1Clipboard::handle-grab signal.
 * @handle_register: Handler for the #QemuDBusDisplay1Clipboard::handle-register signal.
 * @handle_release: Handler for the #QemuDBusDisplay1Clipboard::handle-release signal.
 * @handle_request: Handler for the #QemuDBusDisplay1Clipboard::handle-request signal.
 * @handle_unregister: Handler for the #QemuDBusDisplay1Clipboard::handle-unregister signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Clipboard.top_of_page">org.qemu.Display1.Clipboard</link>.
 */

typedef QemuDBusDisplay1ClipboardIface QemuDBusDisplay1ClipboardInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1Clipboard, qemu_dbus_display1_clipboard, G_TYPE_OBJECT)

static void
qemu_dbus_display1_clipboard_default_init (QemuDBusDisplay1ClipboardIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1Clipboard::handle-register:
   * @object: A #QemuDBusDisplay1Clipboard.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Register">Register()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_clipboard_complete_register() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ClipboardIface, handle_register),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * QemuDBusDisplay1Clipboard::handle-unregister:
   * @object: A #QemuDBusDisplay1Clipboard.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Unregister">Unregister()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_clipboard_complete_unregister() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ClipboardIface, handle_unregister),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * QemuDBusDisplay1Clipboard::handle-grab:
   * @object: A #QemuDBusDisplay1Clipboard.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_selection: Argument passed by remote caller.
   * @arg_serial: Argument passed by remote caller.
   * @arg_mimes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Grab">Grab()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_clipboard_complete_grab() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-grab",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ClipboardIface, handle_grab),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRV);

  /**
   * QemuDBusDisplay1Clipboard::handle-release:
   * @object: A #QemuDBusDisplay1Clipboard.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_selection: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_clipboard_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ClipboardIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * QemuDBusDisplay1Clipboard::handle-request:
   * @object: A #QemuDBusDisplay1Clipboard.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_selection: Argument passed by remote caller.
   * @arg_mimes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Request">Request()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_clipboard_complete_request() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ClipboardIface, handle_request),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRV);

}

/**
 * qemu_dbus_display1_clipboard_call_register:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Register">Register()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_clipboard_call_register_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_clipboard_call_register_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_clipboard_call_register (
    QemuDBusDisplay1Clipboard *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Register",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_clipboard_call_register_finish:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_clipboard_call_register().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_clipboard_call_register().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_register_finish (
    QemuDBusDisplay1Clipboard *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_register_sync:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Register">Register()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_clipboard_call_register() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_register_sync (
    QemuDBusDisplay1Clipboard *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Register",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_unregister:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Unregister">Unregister()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_clipboard_call_unregister_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_clipboard_call_unregister_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_clipboard_call_unregister (
    QemuDBusDisplay1Clipboard *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unregister",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_clipboard_call_unregister_finish:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_clipboard_call_unregister().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_clipboard_call_unregister().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_unregister_finish (
    QemuDBusDisplay1Clipboard *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_unregister_sync:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Unregister">Unregister()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_clipboard_call_unregister() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_unregister_sync (
    QemuDBusDisplay1Clipboard *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unregister",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_grab:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @arg_selection: Argument to pass with the method invocation.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_mimes: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Grab">Grab()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_clipboard_call_grab_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_clipboard_call_grab_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_clipboard_call_grab (
    QemuDBusDisplay1Clipboard *proxy,
    guint arg_selection,
    guint arg_serial,
    const gchar *const *arg_mimes,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Grab",
    g_variant_new ("(uu^as)",
                   arg_selection,
                   arg_serial,
                   arg_mimes),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_clipboard_call_grab_finish:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_clipboard_call_grab().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_clipboard_call_grab().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_grab_finish (
    QemuDBusDisplay1Clipboard *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_grab_sync:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @arg_selection: Argument to pass with the method invocation.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_mimes: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Grab">Grab()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_clipboard_call_grab() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_grab_sync (
    QemuDBusDisplay1Clipboard *proxy,
    guint arg_selection,
    guint arg_serial,
    const gchar *const *arg_mimes,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Grab",
    g_variant_new ("(uu^as)",
                   arg_selection,
                   arg_serial,
                   arg_mimes),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_release:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @arg_selection: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_clipboard_call_release_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_clipboard_call_release_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_clipboard_call_release (
    QemuDBusDisplay1Clipboard *proxy,
    guint arg_selection,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(u)",
                   arg_selection),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_clipboard_call_release_finish:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_clipboard_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_clipboard_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_release_finish (
    QemuDBusDisplay1Clipboard *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_release_sync:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @arg_selection: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_clipboard_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_release_sync (
    QemuDBusDisplay1Clipboard *proxy,
    guint arg_selection,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("(u)",
                   arg_selection),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_request:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @arg_selection: Argument to pass with the method invocation.
 * @arg_mimes: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Request">Request()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_clipboard_call_request_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_clipboard_call_request_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_clipboard_call_request (
    QemuDBusDisplay1Clipboard *proxy,
    guint arg_selection,
    const gchar *const *arg_mimes,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Request",
    g_variant_new ("(u^as)",
                   arg_selection,
                   arg_mimes),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_clipboard_call_request_finish:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @out_reply_mime: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_clipboard_call_request().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_clipboard_call_request().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_request_finish (
    QemuDBusDisplay1Clipboard *proxy,
    gchar **out_reply_mime,
    GVariant **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s@ay)",
                 out_reply_mime,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_call_request_sync:
 * @proxy: A #QemuDBusDisplay1ClipboardProxy.
 * @arg_selection: Argument to pass with the method invocation.
 * @arg_mimes: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_reply_mime: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Request">Request()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_clipboard_call_request() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_clipboard_call_request_sync (
    QemuDBusDisplay1Clipboard *proxy,
    guint arg_selection,
    const gchar *const *arg_mimes,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    gchar **out_reply_mime,
    GVariant **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Request",
    g_variant_new ("(u^as)",
                   arg_selection,
                   arg_mimes),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s@ay)",
                 out_reply_mime,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_clipboard_complete_register:
 * @object: A #QemuDBusDisplay1Clipboard.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Register">Register()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_clipboard_complete_register (
    QemuDBusDisplay1Clipboard *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_clipboard_complete_unregister:
 * @object: A #QemuDBusDisplay1Clipboard.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Unregister">Unregister()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_clipboard_complete_unregister (
    QemuDBusDisplay1Clipboard *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_clipboard_complete_grab:
 * @object: A #QemuDBusDisplay1Clipboard.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Grab">Grab()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_clipboard_complete_grab (
    QemuDBusDisplay1Clipboard *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_clipboard_complete_release:
 * @object: A #QemuDBusDisplay1Clipboard.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_clipboard_complete_release (
    QemuDBusDisplay1Clipboard *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_clipboard_complete_request:
 * @object: A #QemuDBusDisplay1Clipboard.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @reply_mime: Parameter to return.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Clipboard.Request">Request()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_clipboard_complete_request (
    QemuDBusDisplay1Clipboard *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *reply_mime,
    GVariant *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s@ay)",
                   reply_mime,
                   data));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ClipboardProxy:
 *
 * The #QemuDBusDisplay1ClipboardProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ClipboardProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ClipboardProxy.
 */

struct _QemuDBusDisplay1ClipboardProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_clipboard_proxy_iface_init (QemuDBusDisplay1ClipboardIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ClipboardProxy, qemu_dbus_display1_clipboard_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1ClipboardProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD, qemu_dbus_display1_clipboard_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ClipboardProxy, qemu_dbus_display1_clipboard_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD, qemu_dbus_display1_clipboard_proxy_iface_init))

#endif
static void
qemu_dbus_display1_clipboard_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1ClipboardProxy *proxy = QEMU_DBUS_DISPLAY1_CLIPBOARD_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_clipboard_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_clipboard_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_clipboard_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_clipboard_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_clipboard_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_clipboard_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1ClipboardProxy *proxy = QEMU_DBUS_DISPLAY1_CLIPBOARD_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_clipboard_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_clipboard_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
qemu_dbus_display1_clipboard_proxy_init (QemuDBusDisplay1ClipboardProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_clipboard_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD_PROXY, QemuDBusDisplay1ClipboardProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_clipboard_interface_info ());
}

static void
qemu_dbus_display1_clipboard_proxy_class_init (QemuDBusDisplay1ClipboardProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_clipboard_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_clipboard_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_clipboard_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_clipboard_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_clipboard_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ClipboardProxyPrivate));
#endif
}

static void
qemu_dbus_display1_clipboard_proxy_iface_init (QemuDBusDisplay1ClipboardIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_clipboard_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Clipboard.top_of_page">org.qemu.Display1.Clipboard</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_clipboard_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_clipboard_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_clipboard_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Clipboard", NULL);
}

/**
 * qemu_dbus_display1_clipboard_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_clipboard_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_clipboard_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ClipboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Clipboard *
qemu_dbus_display1_clipboard_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CLIPBOARD (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_clipboard_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Clipboard.top_of_page">org.qemu.Display1.Clipboard</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_clipboard_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ClipboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Clipboard *
qemu_dbus_display1_clipboard_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Clipboard", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CLIPBOARD (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_clipboard_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_clipboard_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_clipboard_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_clipboard_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_clipboard_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Clipboard", NULL);
}

/**
 * qemu_dbus_display1_clipboard_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_clipboard_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_clipboard_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ClipboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Clipboard *
qemu_dbus_display1_clipboard_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CLIPBOARD (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_clipboard_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_clipboard_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_clipboard_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ClipboardProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Clipboard *
qemu_dbus_display1_clipboard_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Clipboard", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CLIPBOARD (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ClipboardSkeleton:
 *
 * The #QemuDBusDisplay1ClipboardSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ClipboardSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ClipboardSkeleton.
 */

struct _QemuDBusDisplay1ClipboardSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_clipboard_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1ClipboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CLIPBOARD_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_clipboard_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ClipboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CLIPBOARD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_clipboard_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_clipboard_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ClipboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CLIPBOARD_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_clipboard_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_clipboard_skeleton_vtable =
{
  _qemu_dbus_display1_clipboard_skeleton_handle_method_call,
  _qemu_dbus_display1_clipboard_skeleton_handle_get_property,
  _qemu_dbus_display1_clipboard_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_clipboard_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_clipboard_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_clipboard_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_clipboard_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_clipboard_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1ClipboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CLIPBOARD_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_clipboard_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_clipboard_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_clipboard_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_clipboard_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.Clipboard", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
qemu_dbus_display1_clipboard_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void qemu_dbus_display1_clipboard_skeleton_iface_init (QemuDBusDisplay1ClipboardIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ClipboardSkeleton, qemu_dbus_display1_clipboard_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1ClipboardSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD, qemu_dbus_display1_clipboard_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ClipboardSkeleton, qemu_dbus_display1_clipboard_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD, qemu_dbus_display1_clipboard_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_clipboard_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1ClipboardSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CLIPBOARD_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_clipboard_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_clipboard_skeleton_init (QemuDBusDisplay1ClipboardSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_clipboard_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD_SKELETON, QemuDBusDisplay1ClipboardSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
qemu_dbus_display1_clipboard_skeleton_class_init (QemuDBusDisplay1ClipboardSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_clipboard_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_clipboard_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_clipboard_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_clipboard_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_clipboard_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ClipboardSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_clipboard_skeleton_iface_init (QemuDBusDisplay1ClipboardIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_clipboard_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Clipboard.top_of_page">org.qemu.Display1.Clipboard</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ClipboardSkeleton): The skeleton object.
 */
QemuDBusDisplay1Clipboard *
qemu_dbus_display1_clipboard_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_CLIPBOARD (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_CLIPBOARD_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.Audio
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1Audio
 * @title: QemuDBusDisplay1Audio
 * @short_description: Generated C code for the org.qemu.Display1.Audio D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-Audio.top_of_page">org.qemu.Display1.Audio</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.Audio ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_method_info_register_out_listener_IN_ARG_listener =
{
  {
    -1,
    (gchar *) "listener",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_method_info_register_out_listener_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_method_info_register_out_listener_IN_ARG_listener.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_method_info_register_out_listener =
{
  {
    -1,
    (gchar *) "RegisterOutListener",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_method_info_register_out_listener_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-out-listener",
  TRUE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_method_info_register_in_listener_IN_ARG_listener =
{
  {
    -1,
    (gchar *) "listener",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_method_info_register_in_listener_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_method_info_register_in_listener_IN_ARG_listener.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_method_info_register_in_listener =
{
  {
    -1,
    (gchar *) "RegisterInListener",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_method_info_register_in_listener_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-in-listener",
  TRUE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_audio_method_info_pointers[] =
{
  &_qemu_dbus_display1_audio_method_info_register_out_listener.parent_struct,
  &_qemu_dbus_display1_audio_method_info_register_in_listener.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_audio_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.Audio",
    (GDBusMethodInfo **) &_qemu_dbus_display1_audio_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "display1-audio",
};


/**
 * qemu_dbus_display1_audio_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-Audio.top_of_page">org.qemu.Display1.Audio</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_audio_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_audio_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1Audio interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_audio_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1Audio:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Audio.top_of_page">org.qemu.Display1.Audio</link>.
 */

/**
 * QemuDBusDisplay1AudioIface:
 * @parent_iface: The parent interface.
 * @handle_register_in_listener: Handler for the #QemuDBusDisplay1Audio::handle-register-in-listener signal.
 * @handle_register_out_listener: Handler for the #QemuDBusDisplay1Audio::handle-register-out-listener signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Audio.top_of_page">org.qemu.Display1.Audio</link>.
 */

typedef QemuDBusDisplay1AudioIface QemuDBusDisplay1AudioInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1Audio, qemu_dbus_display1_audio, G_TYPE_OBJECT)

static void
qemu_dbus_display1_audio_default_init (QemuDBusDisplay1AudioIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1Audio::handle-register-out-listener:
   * @object: A #QemuDBusDisplay1Audio.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_listener: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterOutListener">RegisterOutListener()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_complete_register_out_listener() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-out-listener",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioIface, handle_register_out_listener),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * QemuDBusDisplay1Audio::handle-register-in-listener:
   * @object: A #QemuDBusDisplay1Audio.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_listener: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterInListener">RegisterInListener()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_complete_register_in_listener() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-in-listener",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioIface, handle_register_in_listener),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

}

/**
 * qemu_dbus_display1_audio_call_register_out_listener:
 * @proxy: A #QemuDBusDisplay1AudioProxy.
 * @arg_listener: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterOutListener">RegisterOutListener()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_call_register_out_listener_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_call_register_out_listener_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_call_register_out_listener (
    QemuDBusDisplay1Audio *proxy,
    GVariant *arg_listener,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "RegisterOutListener",
    g_variant_new ("(@h)",
                   arg_listener),
    call_flags,
    timeout_msec,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_call_register_out_listener_finish:
 * @proxy: A #QemuDBusDisplay1AudioProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_call_register_out_listener().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_call_register_out_listener().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_call_register_out_listener_finish (
    QemuDBusDisplay1Audio *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_call_register_out_listener_sync:
 * @proxy: A #QemuDBusDisplay1AudioProxy.
 * @arg_listener: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterOutListener">RegisterOutListener()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_call_register_out_listener() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_call_register_out_listener_sync (
    QemuDBusDisplay1Audio *proxy,
    GVariant *arg_listener,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "RegisterOutListener",
    g_variant_new ("(@h)",
                   arg_listener),
    call_flags,
    timeout_msec,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_call_register_in_listener:
 * @proxy: A #QemuDBusDisplay1AudioProxy.
 * @arg_listener: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterInListener">RegisterInListener()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_call_register_in_listener_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_call_register_in_listener_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_call_register_in_listener (
    QemuDBusDisplay1Audio *proxy,
    GVariant *arg_listener,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "RegisterInListener",
    g_variant_new ("(@h)",
                   arg_listener),
    call_flags,
    timeout_msec,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_call_register_in_listener_finish:
 * @proxy: A #QemuDBusDisplay1AudioProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_call_register_in_listener().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_call_register_in_listener().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_call_register_in_listener_finish (
    QemuDBusDisplay1Audio *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_call_register_in_listener_sync:
 * @proxy: A #QemuDBusDisplay1AudioProxy.
 * @arg_listener: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterInListener">RegisterInListener()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_call_register_in_listener() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_call_register_in_listener_sync (
    QemuDBusDisplay1Audio *proxy,
    GVariant *arg_listener,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "RegisterInListener",
    g_variant_new ("(@h)",
                   arg_listener),
    call_flags,
    timeout_msec,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_complete_register_out_listener:
 * @object: A #QemuDBusDisplay1Audio.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterOutListener">RegisterOutListener()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_complete_register_out_listener (
    QemuDBusDisplay1Audio *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/**
 * qemu_dbus_display1_audio_complete_register_in_listener:
 * @object: A #QemuDBusDisplay1Audio.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Audio.RegisterInListener">RegisterInListener()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_complete_register_in_listener (
    QemuDBusDisplay1Audio *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1AudioProxy:
 *
 * The #QemuDBusDisplay1AudioProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1AudioProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1AudioProxy.
 */

struct _QemuDBusDisplay1AudioProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_audio_proxy_iface_init (QemuDBusDisplay1AudioIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioProxy, qemu_dbus_display1_audio_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1AudioProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO, qemu_dbus_display1_audio_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioProxy, qemu_dbus_display1_audio_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO, qemu_dbus_display1_audio_proxy_iface_init))

#endif
static void
qemu_dbus_display1_audio_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1AudioProxy *proxy = QEMU_DBUS_DISPLAY1_AUDIO_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_audio_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_audio_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_audio_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_audio_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_AUDIO);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_AUDIO);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_audio_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1AudioProxy *proxy = QEMU_DBUS_DISPLAY1_AUDIO_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
qemu_dbus_display1_audio_proxy_init (QemuDBusDisplay1AudioProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_audio_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_PROXY, QemuDBusDisplay1AudioProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_audio_interface_info ());
}

static void
qemu_dbus_display1_audio_proxy_class_init (QemuDBusDisplay1AudioProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_audio_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_audio_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_audio_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_audio_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_audio_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1AudioProxyPrivate));
#endif
}

static void
qemu_dbus_display1_audio_proxy_iface_init (QemuDBusDisplay1AudioIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_audio_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Audio.top_of_page">org.qemu.Display1.Audio</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_audio_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Audio", NULL);
}

/**
 * qemu_dbus_display1_audio_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_audio_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Audio *
qemu_dbus_display1_audio_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_audio_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Audio.top_of_page">org.qemu.Display1.Audio</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Audio *
qemu_dbus_display1_audio_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Audio", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_audio_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_audio_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_audio_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Audio", NULL);
}

/**
 * qemu_dbus_display1_audio_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_audio_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Audio *
qemu_dbus_display1_audio_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_audio_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_audio_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Audio *
qemu_dbus_display1_audio_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Audio", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1AudioSkeleton:
 *
 * The #QemuDBusDisplay1AudioSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1AudioSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1AudioSkeleton.
 */

struct _QemuDBusDisplay1AudioSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_audio_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1AudioSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_AUDIO);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_AUDIO);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_audio_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1AudioSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_audio_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1AudioSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_audio_skeleton_vtable =
{
  _qemu_dbus_display1_audio_skeleton_handle_method_call,
  _qemu_dbus_display1_audio_skeleton_handle_get_property,
  _qemu_dbus_display1_audio_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_audio_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_audio_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_audio_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_audio_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_audio_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1AudioSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_audio_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_audio_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_audio_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_audio_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.Audio", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
qemu_dbus_display1_audio_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void qemu_dbus_display1_audio_skeleton_iface_init (QemuDBusDisplay1AudioIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioSkeleton, qemu_dbus_display1_audio_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1AudioSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO, qemu_dbus_display1_audio_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioSkeleton, qemu_dbus_display1_audio_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO, qemu_dbus_display1_audio_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_audio_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1AudioSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_audio_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_audio_skeleton_init (QemuDBusDisplay1AudioSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_audio_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_SKELETON, QemuDBusDisplay1AudioSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
qemu_dbus_display1_audio_skeleton_class_init (QemuDBusDisplay1AudioSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_audio_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_audio_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_audio_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_audio_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_audio_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1AudioSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_audio_skeleton_iface_init (QemuDBusDisplay1AudioIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_audio_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Audio.top_of_page">org.qemu.Display1.Audio</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioSkeleton): The skeleton object.
 */
QemuDBusDisplay1Audio *
qemu_dbus_display1_audio_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_AUDIO (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.AudioOutListener
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1AudioOutListener
 * @title: QemuDBusDisplay1AudioOutListener
 * @short_description: Generated C code for the org.qemu.Display1.AudioOutListener D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-AudioOutListener.top_of_page">org.qemu.Display1.AudioOutListener</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.AudioOutListener ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_bits =
{
  {
    -1,
    (gchar *) "bits",
    (gchar *) "y",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_is_signed =
{
  {
    -1,
    (gchar *) "is_signed",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_is_float =
{
  {
    -1,
    (gchar *) "is_float",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_freq =
{
  {
    -1,
    (gchar *) "freq",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_nchannels =
{
  {
    -1,
    (gchar *) "nchannels",
    (gchar *) "y",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_bytes_per_frame =
{
  {
    -1,
    (gchar *) "bytes_per_frame",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_bytes_per_second =
{
  {
    -1,
    (gchar *) "bytes_per_second",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_be =
{
  {
    -1,
    (gchar *) "be",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_bits.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_is_signed.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_is_float.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_freq.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_nchannels.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_bytes_per_frame.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_bytes_per_second.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_be.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_out_listener_method_info_init =
{
  {
    -1,
    (gchar *) "Init",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_out_listener_method_info_init_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-init",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_fini_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_out_listener_method_info_fini_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_out_listener_method_info_fini_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_out_listener_method_info_fini =
{
  {
    -1,
    (gchar *) "Fini",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_out_listener_method_info_fini_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-fini",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_set_enabled_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_set_enabled_IN_ARG_enabled =
{
  {
    -1,
    (gchar *) "enabled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_out_listener_method_info_set_enabled_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_out_listener_method_info_set_enabled_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_set_enabled_IN_ARG_enabled.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_out_listener_method_info_set_enabled =
{
  {
    -1,
    (gchar *) "SetEnabled",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_out_listener_method_info_set_enabled_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-enabled",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_mute =
{
  {
    -1,
    (gchar *) "mute",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_volume =
{
  {
    -1,
    (gchar *) "volume",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_mute.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_out_listener_method_info_set_volume =
{
  {
    -1,
    (gchar *) "SetVolume",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_out_listener_method_info_set_volume_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-volume",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_write_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_out_listener_method_info_write_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_out_listener_method_info_write_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_out_listener_method_info_write_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_write_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_out_listener_method_info_write =
{
  {
    -1,
    (gchar *) "Write",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_out_listener_method_info_write_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-write",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_audio_out_listener_method_info_pointers[] =
{
  &_qemu_dbus_display1_audio_out_listener_method_info_init.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_fini.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_set_enabled.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_set_volume.parent_struct,
  &_qemu_dbus_display1_audio_out_listener_method_info_write.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_audio_out_listener_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.AudioOutListener",
    (GDBusMethodInfo **) &_qemu_dbus_display1_audio_out_listener_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "display1-audio-out-listener",
};


/**
 * qemu_dbus_display1_audio_out_listener_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-AudioOutListener.top_of_page">org.qemu.Display1.AudioOutListener</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_audio_out_listener_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_out_listener_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_audio_out_listener_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1AudioOutListener interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_audio_out_listener_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1AudioOutListener:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioOutListener.top_of_page">org.qemu.Display1.AudioOutListener</link>.
 */

/**
 * QemuDBusDisplay1AudioOutListenerIface:
 * @parent_iface: The parent interface.
 * @handle_fini: Handler for the #QemuDBusDisplay1AudioOutListener::handle-fini signal.
 * @handle_init: Handler for the #QemuDBusDisplay1AudioOutListener::handle-init signal.
 * @handle_set_enabled: Handler for the #QemuDBusDisplay1AudioOutListener::handle-set-enabled signal.
 * @handle_set_volume: Handler for the #QemuDBusDisplay1AudioOutListener::handle-set-volume signal.
 * @handle_write: Handler for the #QemuDBusDisplay1AudioOutListener::handle-write signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioOutListener.top_of_page">org.qemu.Display1.AudioOutListener</link>.
 */

typedef QemuDBusDisplay1AudioOutListenerIface QemuDBusDisplay1AudioOutListenerInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1AudioOutListener, qemu_dbus_display1_audio_out_listener, G_TYPE_OBJECT)

static void
qemu_dbus_display1_audio_out_listener_default_init (QemuDBusDisplay1AudioOutListenerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1AudioOutListener::handle-init:
   * @object: A #QemuDBusDisplay1AudioOutListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_bits: Argument passed by remote caller.
   * @arg_is_signed: Argument passed by remote caller.
   * @arg_is_float: Argument passed by remote caller.
   * @arg_freq: Argument passed by remote caller.
   * @arg_nchannels: Argument passed by remote caller.
   * @arg_bytes_per_frame: Argument passed by remote caller.
   * @arg_bytes_per_second: Argument passed by remote caller.
   * @arg_be: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Init">Init()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_out_listener_complete_init() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-init",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioOutListenerIface, handle_init),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    10,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UCHAR, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UCHAR, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * QemuDBusDisplay1AudioOutListener::handle-fini:
   * @object: A #QemuDBusDisplay1AudioOutListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Fini">Fini()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_out_listener_complete_fini() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-fini",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioOutListenerIface, handle_fini),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * QemuDBusDisplay1AudioOutListener::handle-set-enabled:
   * @object: A #QemuDBusDisplay1AudioOutListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_enabled: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetEnabled">SetEnabled()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_out_listener_complete_set_enabled() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-enabled",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioOutListenerIface, handle_set_enabled),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_BOOLEAN);

  /**
   * QemuDBusDisplay1AudioOutListener::handle-set-volume:
   * @object: A #QemuDBusDisplay1AudioOutListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_mute: Argument passed by remote caller.
   * @arg_volume: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetVolume">SetVolume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_out_listener_complete_set_volume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-volume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioOutListenerIface, handle_set_volume),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * QemuDBusDisplay1AudioOutListener::handle-write:
   * @object: A #QemuDBusDisplay1AudioOutListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Write">Write()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_out_listener_complete_write() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-write",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioOutListenerIface, handle_write),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_VARIANT);

}

/**
 * qemu_dbus_display1_audio_out_listener_call_init:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_bits: Argument to pass with the method invocation.
 * @arg_is_signed: Argument to pass with the method invocation.
 * @arg_is_float: Argument to pass with the method invocation.
 * @arg_freq: Argument to pass with the method invocation.
 * @arg_nchannels: Argument to pass with the method invocation.
 * @arg_bytes_per_frame: Argument to pass with the method invocation.
 * @arg_bytes_per_second: Argument to pass with the method invocation.
 * @arg_be: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Init">Init()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_out_listener_call_init_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_out_listener_call_init_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_out_listener_call_init (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    guchar arg_bits,
    gboolean arg_is_signed,
    gboolean arg_is_float,
    guint arg_freq,
    guchar arg_nchannels,
    guint arg_bytes_per_frame,
    guint arg_bytes_per_second,
    gboolean arg_be,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Init",
    g_variant_new ("(tybbuyuub)",
                   arg_id,
                   arg_bits,
                   arg_is_signed,
                   arg_is_float,
                   arg_freq,
                   arg_nchannels,
                   arg_bytes_per_frame,
                   arg_bytes_per_second,
                   arg_be),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_out_listener_call_init_finish:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_out_listener_call_init().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_out_listener_call_init().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_init_finish (
    QemuDBusDisplay1AudioOutListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_init_sync:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_bits: Argument to pass with the method invocation.
 * @arg_is_signed: Argument to pass with the method invocation.
 * @arg_is_float: Argument to pass with the method invocation.
 * @arg_freq: Argument to pass with the method invocation.
 * @arg_nchannels: Argument to pass with the method invocation.
 * @arg_bytes_per_frame: Argument to pass with the method invocation.
 * @arg_bytes_per_second: Argument to pass with the method invocation.
 * @arg_be: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Init">Init()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_out_listener_call_init() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_init_sync (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    guchar arg_bits,
    gboolean arg_is_signed,
    gboolean arg_is_float,
    guint arg_freq,
    guchar arg_nchannels,
    guint arg_bytes_per_frame,
    guint arg_bytes_per_second,
    gboolean arg_be,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Init",
    g_variant_new ("(tybbuyuub)",
                   arg_id,
                   arg_bits,
                   arg_is_signed,
                   arg_is_float,
                   arg_freq,
                   arg_nchannels,
                   arg_bytes_per_frame,
                   arg_bytes_per_second,
                   arg_be),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_fini:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Fini">Fini()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_out_listener_call_fini_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_out_listener_call_fini_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_out_listener_call_fini (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Fini",
    g_variant_new ("(t)",
                   arg_id),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_out_listener_call_fini_finish:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_out_listener_call_fini().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_out_listener_call_fini().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_fini_finish (
    QemuDBusDisplay1AudioOutListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_fini_sync:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Fini">Fini()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_out_listener_call_fini() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_fini_sync (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Fini",
    g_variant_new ("(t)",
                   arg_id),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_set_enabled:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_enabled: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetEnabled">SetEnabled()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_out_listener_call_set_enabled_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_out_listener_call_set_enabled_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_out_listener_call_set_enabled (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    gboolean arg_enabled,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEnabled",
    g_variant_new ("(tb)",
                   arg_id,
                   arg_enabled),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_out_listener_call_set_enabled_finish:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_out_listener_call_set_enabled().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_out_listener_call_set_enabled().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_set_enabled_finish (
    QemuDBusDisplay1AudioOutListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_set_enabled_sync:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_enabled: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetEnabled">SetEnabled()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_out_listener_call_set_enabled() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_set_enabled_sync (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    gboolean arg_enabled,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEnabled",
    g_variant_new ("(tb)",
                   arg_id,
                   arg_enabled),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_set_volume:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_mute: Argument to pass with the method invocation.
 * @arg_volume: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetVolume">SetVolume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_out_listener_call_set_volume_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_out_listener_call_set_volume_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_out_listener_call_set_volume (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    gboolean arg_mute,
    GVariant *arg_volume,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(tb@ay)",
                   arg_id,
                   arg_mute,
                   arg_volume),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_out_listener_call_set_volume_finish:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_out_listener_call_set_volume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_out_listener_call_set_volume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_set_volume_finish (
    QemuDBusDisplay1AudioOutListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_set_volume_sync:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_mute: Argument to pass with the method invocation.
 * @arg_volume: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetVolume">SetVolume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_out_listener_call_set_volume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_set_volume_sync (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    gboolean arg_mute,
    GVariant *arg_volume,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(tb@ay)",
                   arg_id,
                   arg_mute,
                   arg_volume),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_write:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Write">Write()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_out_listener_call_write_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_out_listener_call_write_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_out_listener_call_write (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Write",
    g_variant_new ("(t@ay)",
                   arg_id,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_out_listener_call_write_finish:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_out_listener_call_write().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_out_listener_call_write().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_write_finish (
    QemuDBusDisplay1AudioOutListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_call_write_sync:
 * @proxy: A #QemuDBusDisplay1AudioOutListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Write">Write()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_out_listener_call_write() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_out_listener_call_write_sync (
    QemuDBusDisplay1AudioOutListener *proxy,
    guint64 arg_id,
    GVariant *arg_data,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Write",
    g_variant_new ("(t@ay)",
                   arg_id,
                   arg_data),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_complete_init:
 * @object: A #QemuDBusDisplay1AudioOutListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Init">Init()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_out_listener_complete_init (
    QemuDBusDisplay1AudioOutListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_out_listener_complete_fini:
 * @object: A #QemuDBusDisplay1AudioOutListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Fini">Fini()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_out_listener_complete_fini (
    QemuDBusDisplay1AudioOutListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_out_listener_complete_set_enabled:
 * @object: A #QemuDBusDisplay1AudioOutListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetEnabled">SetEnabled()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_out_listener_complete_set_enabled (
    QemuDBusDisplay1AudioOutListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_out_listener_complete_set_volume:
 * @object: A #QemuDBusDisplay1AudioOutListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.SetVolume">SetVolume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_out_listener_complete_set_volume (
    QemuDBusDisplay1AudioOutListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_out_listener_complete_write:
 * @object: A #QemuDBusDisplay1AudioOutListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioOutListener.Write">Write()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_out_listener_complete_write (
    QemuDBusDisplay1AudioOutListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1AudioOutListenerProxy:
 *
 * The #QemuDBusDisplay1AudioOutListenerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1AudioOutListenerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1AudioOutListenerProxy.
 */

struct _QemuDBusDisplay1AudioOutListenerProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_audio_out_listener_proxy_iface_init (QemuDBusDisplay1AudioOutListenerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioOutListenerProxy, qemu_dbus_display1_audio_out_listener_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1AudioOutListenerProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER, qemu_dbus_display1_audio_out_listener_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioOutListenerProxy, qemu_dbus_display1_audio_out_listener_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER, qemu_dbus_display1_audio_out_listener_proxy_iface_init))

#endif
static void
qemu_dbus_display1_audio_out_listener_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1AudioOutListenerProxy *proxy = QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_audio_out_listener_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_audio_out_listener_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_audio_out_listener_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_audio_out_listener_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_out_listener_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_audio_out_listener_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1AudioOutListenerProxy *proxy = QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_out_listener_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_out_listener_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
qemu_dbus_display1_audio_out_listener_proxy_init (QemuDBusDisplay1AudioOutListenerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_audio_out_listener_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER_PROXY, QemuDBusDisplay1AudioOutListenerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_audio_out_listener_interface_info ());
}

static void
qemu_dbus_display1_audio_out_listener_proxy_class_init (QemuDBusDisplay1AudioOutListenerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_audio_out_listener_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_audio_out_listener_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_audio_out_listener_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_audio_out_listener_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_audio_out_listener_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1AudioOutListenerProxyPrivate));
#endif
}

static void
qemu_dbus_display1_audio_out_listener_proxy_iface_init (QemuDBusDisplay1AudioOutListenerIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_audio_out_listener_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioOutListener.top_of_page">org.qemu.Display1.AudioOutListener</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_out_listener_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_out_listener_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_audio_out_listener_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioOutListener", NULL);
}

/**
 * qemu_dbus_display1_audio_out_listener_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_out_listener_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_audio_out_listener_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioOutListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioOutListener *
qemu_dbus_display1_audio_out_listener_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioOutListener.top_of_page">org.qemu.Display1.AudioOutListener</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_out_listener_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioOutListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioOutListener *
qemu_dbus_display1_audio_out_listener_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioOutListener", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_audio_out_listener_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_audio_out_listener_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_out_listener_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_out_listener_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_audio_out_listener_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioOutListener", NULL);
}

/**
 * qemu_dbus_display1_audio_out_listener_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_out_listener_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_audio_out_listener_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioOutListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioOutListener *
qemu_dbus_display1_audio_out_listener_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_audio_out_listener_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_audio_out_listener_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_out_listener_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioOutListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioOutListener *
qemu_dbus_display1_audio_out_listener_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioOutListener", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1AudioOutListenerSkeleton:
 *
 * The #QemuDBusDisplay1AudioOutListenerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1AudioOutListenerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1AudioOutListenerSkeleton.
 */

struct _QemuDBusDisplay1AudioOutListenerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_audio_out_listener_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1AudioOutListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_audio_out_listener_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1AudioOutListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_out_listener_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_audio_out_listener_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1AudioOutListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_out_listener_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_audio_out_listener_skeleton_vtable =
{
  _qemu_dbus_display1_audio_out_listener_skeleton_handle_method_call,
  _qemu_dbus_display1_audio_out_listener_skeleton_handle_get_property,
  _qemu_dbus_display1_audio_out_listener_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_audio_out_listener_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_audio_out_listener_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1AudioOutListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_audio_out_listener_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_audio_out_listener_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_audio_out_listener_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_audio_out_listener_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.AudioOutListener", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void qemu_dbus_display1_audio_out_listener_skeleton_iface_init (QemuDBusDisplay1AudioOutListenerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioOutListenerSkeleton, qemu_dbus_display1_audio_out_listener_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1AudioOutListenerSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER, qemu_dbus_display1_audio_out_listener_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioOutListenerSkeleton, qemu_dbus_display1_audio_out_listener_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER, qemu_dbus_display1_audio_out_listener_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_audio_out_listener_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1AudioOutListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_audio_out_listener_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_audio_out_listener_skeleton_init (QemuDBusDisplay1AudioOutListenerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_audio_out_listener_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER_SKELETON, QemuDBusDisplay1AudioOutListenerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
qemu_dbus_display1_audio_out_listener_skeleton_class_init (QemuDBusDisplay1AudioOutListenerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_audio_out_listener_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_audio_out_listener_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1AudioOutListenerSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_audio_out_listener_skeleton_iface_init (QemuDBusDisplay1AudioOutListenerIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_audio_out_listener_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioOutListener.top_of_page">org.qemu.Display1.AudioOutListener</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioOutListenerSkeleton): The skeleton object.
 */
QemuDBusDisplay1AudioOutListener *
qemu_dbus_display1_audio_out_listener_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_AUDIO_OUT_LISTENER (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_OUT_LISTENER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.AudioInListener
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1AudioInListener
 * @title: QemuDBusDisplay1AudioInListener
 * @short_description: Generated C code for the org.qemu.Display1.AudioInListener D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-AudioInListener.top_of_page">org.qemu.Display1.AudioInListener</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.AudioInListener ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_bits =
{
  {
    -1,
    (gchar *) "bits",
    (gchar *) "y",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_is_signed =
{
  {
    -1,
    (gchar *) "is_signed",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_is_float =
{
  {
    -1,
    (gchar *) "is_float",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_freq =
{
  {
    -1,
    (gchar *) "freq",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_nchannels =
{
  {
    -1,
    (gchar *) "nchannels",
    (gchar *) "y",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_bytes_per_frame =
{
  {
    -1,
    (gchar *) "bytes_per_frame",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_bytes_per_second =
{
  {
    -1,
    (gchar *) "bytes_per_second",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_be =
{
  {
    -1,
    (gchar *) "be",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_bits.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_is_signed.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_is_float.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_freq.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_nchannels.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_bytes_per_frame.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_bytes_per_second.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_be.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_in_listener_method_info_init =
{
  {
    -1,
    (gchar *) "Init",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_in_listener_method_info_init_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-init",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_fini_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_in_listener_method_info_fini_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_in_listener_method_info_fini_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_in_listener_method_info_fini =
{
  {
    -1,
    (gchar *) "Fini",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_in_listener_method_info_fini_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-fini",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_set_enabled_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_set_enabled_IN_ARG_enabled =
{
  {
    -1,
    (gchar *) "enabled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_in_listener_method_info_set_enabled_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_in_listener_method_info_set_enabled_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_set_enabled_IN_ARG_enabled.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_in_listener_method_info_set_enabled =
{
  {
    -1,
    (gchar *) "SetEnabled",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_in_listener_method_info_set_enabled_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-enabled",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_mute =
{
  {
    -1,
    (gchar *) "mute",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_volume =
{
  {
    -1,
    (gchar *) "volume",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_mute.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_in_listener_method_info_set_volume =
{
  {
    -1,
    (gchar *) "SetVolume",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_in_listener_method_info_set_volume_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-volume",
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_read_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_read_IN_ARG_size =
{
  {
    -1,
    (gchar *) "size",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_in_listener_method_info_read_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_in_listener_method_info_read_IN_ARG_id.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_read_IN_ARG_size.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_audio_in_listener_method_info_read_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "ay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _qemu_dbus_display1_audio_in_listener_method_info_read_OUT_ARG_pointers[] =
{
  &_qemu_dbus_display1_audio_in_listener_method_info_read_OUT_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_audio_in_listener_method_info_read =
{
  {
    -1,
    (gchar *) "Read",
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_in_listener_method_info_read_IN_ARG_pointers,
    (GDBusArgInfo **) &_qemu_dbus_display1_audio_in_listener_method_info_read_OUT_ARG_pointers,
    NULL
  },
  "handle-read",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_audio_in_listener_method_info_pointers[] =
{
  &_qemu_dbus_display1_audio_in_listener_method_info_init.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_fini.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_set_enabled.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_set_volume.parent_struct,
  &_qemu_dbus_display1_audio_in_listener_method_info_read.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_audio_in_listener_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.AudioInListener",
    (GDBusMethodInfo **) &_qemu_dbus_display1_audio_in_listener_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "display1-audio-in-listener",
};


/**
 * qemu_dbus_display1_audio_in_listener_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-AudioInListener.top_of_page">org.qemu.Display1.AudioInListener</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_audio_in_listener_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_in_listener_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_audio_in_listener_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1AudioInListener interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_audio_in_listener_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1AudioInListener:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioInListener.top_of_page">org.qemu.Display1.AudioInListener</link>.
 */

/**
 * QemuDBusDisplay1AudioInListenerIface:
 * @parent_iface: The parent interface.
 * @handle_fini: Handler for the #QemuDBusDisplay1AudioInListener::handle-fini signal.
 * @handle_init: Handler for the #QemuDBusDisplay1AudioInListener::handle-init signal.
 * @handle_read: Handler for the #QemuDBusDisplay1AudioInListener::handle-read signal.
 * @handle_set_enabled: Handler for the #QemuDBusDisplay1AudioInListener::handle-set-enabled signal.
 * @handle_set_volume: Handler for the #QemuDBusDisplay1AudioInListener::handle-set-volume signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioInListener.top_of_page">org.qemu.Display1.AudioInListener</link>.
 */

typedef QemuDBusDisplay1AudioInListenerIface QemuDBusDisplay1AudioInListenerInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1AudioInListener, qemu_dbus_display1_audio_in_listener, G_TYPE_OBJECT)

static void
qemu_dbus_display1_audio_in_listener_default_init (QemuDBusDisplay1AudioInListenerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1AudioInListener::handle-init:
   * @object: A #QemuDBusDisplay1AudioInListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_bits: Argument passed by remote caller.
   * @arg_is_signed: Argument passed by remote caller.
   * @arg_is_float: Argument passed by remote caller.
   * @arg_freq: Argument passed by remote caller.
   * @arg_nchannels: Argument passed by remote caller.
   * @arg_bytes_per_frame: Argument passed by remote caller.
   * @arg_bytes_per_second: Argument passed by remote caller.
   * @arg_be: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Init">Init()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_in_listener_complete_init() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-init",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioInListenerIface, handle_init),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    10,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UCHAR, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UCHAR, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * QemuDBusDisplay1AudioInListener::handle-fini:
   * @object: A #QemuDBusDisplay1AudioInListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Fini">Fini()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_in_listener_complete_fini() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-fini",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioInListenerIface, handle_fini),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64);

  /**
   * QemuDBusDisplay1AudioInListener::handle-set-enabled:
   * @object: A #QemuDBusDisplay1AudioInListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_enabled: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetEnabled">SetEnabled()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_in_listener_complete_set_enabled() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-enabled",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioInListenerIface, handle_set_enabled),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_BOOLEAN);

  /**
   * QemuDBusDisplay1AudioInListener::handle-set-volume:
   * @object: A #QemuDBusDisplay1AudioInListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_mute: Argument passed by remote caller.
   * @arg_volume: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetVolume">SetVolume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_in_listener_complete_set_volume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-volume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioInListenerIface, handle_set_volume),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

  /**
   * QemuDBusDisplay1AudioInListener::handle-read:
   * @object: A #QemuDBusDisplay1AudioInListener.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_size: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Read">Read()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_audio_in_listener_complete_read() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1AudioInListenerIface, handle_read),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT64, G_TYPE_UINT64);

}

/**
 * qemu_dbus_display1_audio_in_listener_call_init:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_bits: Argument to pass with the method invocation.
 * @arg_is_signed: Argument to pass with the method invocation.
 * @arg_is_float: Argument to pass with the method invocation.
 * @arg_freq: Argument to pass with the method invocation.
 * @arg_nchannels: Argument to pass with the method invocation.
 * @arg_bytes_per_frame: Argument to pass with the method invocation.
 * @arg_bytes_per_second: Argument to pass with the method invocation.
 * @arg_be: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Init">Init()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_in_listener_call_init_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_in_listener_call_init_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_in_listener_call_init (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    guchar arg_bits,
    gboolean arg_is_signed,
    gboolean arg_is_float,
    guint arg_freq,
    guchar arg_nchannels,
    guint arg_bytes_per_frame,
    guint arg_bytes_per_second,
    gboolean arg_be,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Init",
    g_variant_new ("(tybbuyuub)",
                   arg_id,
                   arg_bits,
                   arg_is_signed,
                   arg_is_float,
                   arg_freq,
                   arg_nchannels,
                   arg_bytes_per_frame,
                   arg_bytes_per_second,
                   arg_be),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_in_listener_call_init_finish:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_in_listener_call_init().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_in_listener_call_init().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_init_finish (
    QemuDBusDisplay1AudioInListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_init_sync:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_bits: Argument to pass with the method invocation.
 * @arg_is_signed: Argument to pass with the method invocation.
 * @arg_is_float: Argument to pass with the method invocation.
 * @arg_freq: Argument to pass with the method invocation.
 * @arg_nchannels: Argument to pass with the method invocation.
 * @arg_bytes_per_frame: Argument to pass with the method invocation.
 * @arg_bytes_per_second: Argument to pass with the method invocation.
 * @arg_be: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Init">Init()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_in_listener_call_init() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_init_sync (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    guchar arg_bits,
    gboolean arg_is_signed,
    gboolean arg_is_float,
    guint arg_freq,
    guchar arg_nchannels,
    guint arg_bytes_per_frame,
    guint arg_bytes_per_second,
    gboolean arg_be,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Init",
    g_variant_new ("(tybbuyuub)",
                   arg_id,
                   arg_bits,
                   arg_is_signed,
                   arg_is_float,
                   arg_freq,
                   arg_nchannels,
                   arg_bytes_per_frame,
                   arg_bytes_per_second,
                   arg_be),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_fini:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Fini">Fini()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_in_listener_call_fini_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_in_listener_call_fini_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_in_listener_call_fini (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Fini",
    g_variant_new ("(t)",
                   arg_id),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_in_listener_call_fini_finish:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_in_listener_call_fini().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_in_listener_call_fini().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_fini_finish (
    QemuDBusDisplay1AudioInListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_fini_sync:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Fini">Fini()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_in_listener_call_fini() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_fini_sync (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Fini",
    g_variant_new ("(t)",
                   arg_id),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_set_enabled:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_enabled: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetEnabled">SetEnabled()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_in_listener_call_set_enabled_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_in_listener_call_set_enabled_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_in_listener_call_set_enabled (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    gboolean arg_enabled,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEnabled",
    g_variant_new ("(tb)",
                   arg_id,
                   arg_enabled),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_in_listener_call_set_enabled_finish:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_in_listener_call_set_enabled().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_in_listener_call_set_enabled().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_set_enabled_finish (
    QemuDBusDisplay1AudioInListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_set_enabled_sync:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_enabled: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetEnabled">SetEnabled()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_in_listener_call_set_enabled() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_set_enabled_sync (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    gboolean arg_enabled,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEnabled",
    g_variant_new ("(tb)",
                   arg_id,
                   arg_enabled),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_set_volume:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_mute: Argument to pass with the method invocation.
 * @arg_volume: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetVolume">SetVolume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_in_listener_call_set_volume_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_in_listener_call_set_volume_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_in_listener_call_set_volume (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    gboolean arg_mute,
    GVariant *arg_volume,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(tb@ay)",
                   arg_id,
                   arg_mute,
                   arg_volume),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_in_listener_call_set_volume_finish:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_in_listener_call_set_volume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_in_listener_call_set_volume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_set_volume_finish (
    QemuDBusDisplay1AudioInListener *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_set_volume_sync:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_mute: Argument to pass with the method invocation.
 * @arg_volume: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetVolume">SetVolume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_in_listener_call_set_volume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_set_volume_sync (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    gboolean arg_mute,
    GVariant *arg_volume,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(tb@ay)",
                   arg_id,
                   arg_mute,
                   arg_volume),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_read:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_size: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Read">Read()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_in_listener_call_read_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_in_listener_call_read_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_audio_in_listener_call_read (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    guint64 arg_size,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Read",
    g_variant_new ("(tt)",
                   arg_id,
                   arg_size),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_audio_in_listener_call_read_finish:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_in_listener_call_read().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_audio_in_listener_call_read().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_read_finish (
    QemuDBusDisplay1AudioInListener *proxy,
    GVariant **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ay)",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_call_read_sync:
 * @proxy: A #QemuDBusDisplay1AudioInListenerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_size: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Read">Read()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_in_listener_call_read() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_audio_in_listener_call_read_sync (
    QemuDBusDisplay1AudioInListener *proxy,
    guint64 arg_id,
    guint64 arg_size,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GVariant **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Read",
    g_variant_new ("(tt)",
                   arg_id,
                   arg_size),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ay)",
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_complete_init:
 * @object: A #QemuDBusDisplay1AudioInListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Init">Init()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_in_listener_complete_init (
    QemuDBusDisplay1AudioInListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_in_listener_complete_fini:
 * @object: A #QemuDBusDisplay1AudioInListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Fini">Fini()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_in_listener_complete_fini (
    QemuDBusDisplay1AudioInListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_in_listener_complete_set_enabled:
 * @object: A #QemuDBusDisplay1AudioInListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetEnabled">SetEnabled()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_in_listener_complete_set_enabled (
    QemuDBusDisplay1AudioInListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_in_listener_complete_set_volume:
 * @object: A #QemuDBusDisplay1AudioInListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.SetVolume">SetVolume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_in_listener_complete_set_volume (
    QemuDBusDisplay1AudioInListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * qemu_dbus_display1_audio_in_listener_complete_read:
 * @object: A #QemuDBusDisplay1AudioInListener.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-AudioInListener.Read">Read()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_audio_in_listener_complete_read (
    QemuDBusDisplay1AudioInListener *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ay)",
                   data));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1AudioInListenerProxy:
 *
 * The #QemuDBusDisplay1AudioInListenerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1AudioInListenerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1AudioInListenerProxy.
 */

struct _QemuDBusDisplay1AudioInListenerProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_audio_in_listener_proxy_iface_init (QemuDBusDisplay1AudioInListenerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioInListenerProxy, qemu_dbus_display1_audio_in_listener_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1AudioInListenerProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER, qemu_dbus_display1_audio_in_listener_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioInListenerProxy, qemu_dbus_display1_audio_in_listener_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER, qemu_dbus_display1_audio_in_listener_proxy_iface_init))

#endif
static void
qemu_dbus_display1_audio_in_listener_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1AudioInListenerProxy *proxy = QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_audio_in_listener_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_audio_in_listener_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_audio_in_listener_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
qemu_dbus_display1_audio_in_listener_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_in_listener_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_audio_in_listener_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1AudioInListenerProxy *proxy = QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_in_listener_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_in_listener_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
qemu_dbus_display1_audio_in_listener_proxy_init (QemuDBusDisplay1AudioInListenerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_audio_in_listener_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER_PROXY, QemuDBusDisplay1AudioInListenerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_audio_in_listener_interface_info ());
}

static void
qemu_dbus_display1_audio_in_listener_proxy_class_init (QemuDBusDisplay1AudioInListenerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_audio_in_listener_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_audio_in_listener_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_audio_in_listener_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_audio_in_listener_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_audio_in_listener_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1AudioInListenerProxyPrivate));
#endif
}

static void
qemu_dbus_display1_audio_in_listener_proxy_iface_init (QemuDBusDisplay1AudioInListenerIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_audio_in_listener_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioInListener.top_of_page">org.qemu.Display1.AudioInListener</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_in_listener_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_in_listener_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_audio_in_listener_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioInListener", NULL);
}

/**
 * qemu_dbus_display1_audio_in_listener_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_in_listener_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_audio_in_listener_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioInListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioInListener *
qemu_dbus_display1_audio_in_listener_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioInListener.top_of_page">org.qemu.Display1.AudioInListener</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_in_listener_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioInListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioInListener *
qemu_dbus_display1_audio_in_listener_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioInListener", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_audio_in_listener_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_audio_in_listener_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_audio_in_listener_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_audio_in_listener_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_audio_in_listener_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioInListener", NULL);
}

/**
 * qemu_dbus_display1_audio_in_listener_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_audio_in_listener_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_audio_in_listener_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioInListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioInListener *
qemu_dbus_display1_audio_in_listener_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_audio_in_listener_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_audio_in_listener_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_audio_in_listener_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioInListenerProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1AudioInListener *
qemu_dbus_display1_audio_in_listener_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.AudioInListener", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1AudioInListenerSkeleton:
 *
 * The #QemuDBusDisplay1AudioInListenerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1AudioInListenerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1AudioInListenerSkeleton.
 */

struct _QemuDBusDisplay1AudioInListenerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_audio_in_listener_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1AudioInListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_audio_in_listener_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1AudioInListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_in_listener_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_audio_in_listener_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1AudioInListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_audio_in_listener_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_audio_in_listener_skeleton_vtable =
{
  _qemu_dbus_display1_audio_in_listener_skeleton_handle_method_call,
  _qemu_dbus_display1_audio_in_listener_skeleton_handle_get_property,
  _qemu_dbus_display1_audio_in_listener_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_audio_in_listener_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_audio_in_listener_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1AudioInListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_audio_in_listener_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_audio_in_listener_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_audio_in_listener_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_audio_in_listener_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.AudioInListener", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void qemu_dbus_display1_audio_in_listener_skeleton_iface_init (QemuDBusDisplay1AudioInListenerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioInListenerSkeleton, qemu_dbus_display1_audio_in_listener_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1AudioInListenerSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER, qemu_dbus_display1_audio_in_listener_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1AudioInListenerSkeleton, qemu_dbus_display1_audio_in_listener_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER, qemu_dbus_display1_audio_in_listener_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_audio_in_listener_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1AudioInListenerSkeleton *skeleton = QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_audio_in_listener_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_audio_in_listener_skeleton_init (QemuDBusDisplay1AudioInListenerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_audio_in_listener_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER_SKELETON, QemuDBusDisplay1AudioInListenerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
qemu_dbus_display1_audio_in_listener_skeleton_class_init (QemuDBusDisplay1AudioInListenerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_audio_in_listener_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_audio_in_listener_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1AudioInListenerSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_audio_in_listener_skeleton_iface_init (QemuDBusDisplay1AudioInListenerIface *iface G_GNUC_UNUSED)
{
}

/**
 * qemu_dbus_display1_audio_in_listener_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-AudioInListener.top_of_page">org.qemu.Display1.AudioInListener</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1AudioInListenerSkeleton): The skeleton object.
 */
QemuDBusDisplay1AudioInListener *
qemu_dbus_display1_audio_in_listener_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_AUDIO_IN_LISTENER (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_AUDIO_IN_LISTENER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.qemu.Display1.Chardev
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:QemuDBusDisplay1Chardev
 * @title: QemuDBusDisplay1Chardev
 * @short_description: Generated C code for the org.qemu.Display1.Chardev D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-qemu-Display1-Chardev.top_of_page">org.qemu.Display1.Chardev</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.qemu.Display1.Chardev ---- */

static const _ExtendedGDBusArgInfo _qemu_dbus_display1_chardev_method_info_register_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _qemu_dbus_display1_chardev_method_info_register_IN_ARG_pointers[] =
{
  &_qemu_dbus_display1_chardev_method_info_register_IN_ARG_stream.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_chardev_method_info_register =
{
  {
    -1,
    (gchar *) "Register",
    (GDBusArgInfo **) &_qemu_dbus_display1_chardev_method_info_register_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register",
  TRUE
};

static const _ExtendedGDBusMethodInfo _qemu_dbus_display1_chardev_method_info_send_break =
{
  {
    -1,
    (gchar *) "SendBreak",
    NULL,
    NULL,
    NULL
  },
  "handle-send-break",
  FALSE
};

static const GDBusMethodInfo * const _qemu_dbus_display1_chardev_method_info_pointers[] =
{
  &_qemu_dbus_display1_chardev_method_info_register.parent_struct,
  &_qemu_dbus_display1_chardev_method_info_send_break.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_chardev_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_chardev_property_info_feopened =
{
  {
    -1,
    (gchar *) "FEOpened",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "feopened",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_chardev_property_info_echo =
{
  {
    -1,
    (gchar *) "Echo",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "echo",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _qemu_dbus_display1_chardev_property_info_owner =
{
  {
    -1,
    (gchar *) "Owner",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "owner",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _qemu_dbus_display1_chardev_property_info_pointers[] =
{
  &_qemu_dbus_display1_chardev_property_info_name.parent_struct,
  &_qemu_dbus_display1_chardev_property_info_feopened.parent_struct,
  &_qemu_dbus_display1_chardev_property_info_echo.parent_struct,
  &_qemu_dbus_display1_chardev_property_info_owner.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _qemu_dbus_display1_chardev_interface_info =
{
  {
    -1,
    (gchar *) "org.qemu.Display1.Chardev",
    (GDBusMethodInfo **) &_qemu_dbus_display1_chardev_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_qemu_dbus_display1_chardev_property_info_pointers,
    NULL
  },
  "display1-chardev",
};


/**
 * qemu_dbus_display1_chardev_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-qemu-Display1-Chardev.top_of_page">org.qemu.Display1.Chardev</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
qemu_dbus_display1_chardev_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_qemu_dbus_display1_chardev_interface_info.parent_struct;
}

/**
 * qemu_dbus_display1_chardev_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #QemuDBusDisplay1Chardev interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
qemu_dbus_display1_chardev_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "feopened");
  g_object_class_override_property (klass, property_id_begin++, "echo");
  g_object_class_override_property (klass, property_id_begin++, "owner");
  return property_id_begin - 1;
}



/**
 * QemuDBusDisplay1Chardev:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Chardev.top_of_page">org.qemu.Display1.Chardev</link>.
 */

/**
 * QemuDBusDisplay1ChardevIface:
 * @parent_iface: The parent interface.
 * @handle_register: Handler for the #QemuDBusDisplay1Chardev::handle-register signal.
 * @handle_send_break: Handler for the #QemuDBusDisplay1Chardev::handle-send-break signal.
 * @get_echo: Getter for the #QemuDBusDisplay1Chardev:echo property.
 * @get_feopened: Getter for the #QemuDBusDisplay1Chardev:feopened property.
 * @get_name: Getter for the #QemuDBusDisplay1Chardev:name property.
 * @get_owner: Getter for the #QemuDBusDisplay1Chardev:owner property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Chardev.top_of_page">org.qemu.Display1.Chardev</link>.
 */

typedef QemuDBusDisplay1ChardevIface QemuDBusDisplay1ChardevInterface;
G_DEFINE_INTERFACE (QemuDBusDisplay1Chardev, qemu_dbus_display1_chardev, G_TYPE_OBJECT)

static void
qemu_dbus_display1_chardev_default_init (QemuDBusDisplay1ChardevIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * QemuDBusDisplay1Chardev::handle-register:
   * @object: A #QemuDBusDisplay1Chardev.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_stream: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Chardev.Register">Register()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_chardev_complete_register() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ChardevIface, handle_register),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /**
   * QemuDBusDisplay1Chardev::handle-send-break:
   * @object: A #QemuDBusDisplay1Chardev.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-qemu-Display1-Chardev.SendBreak">SendBreak()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call qemu_dbus_display1_chardev_complete_send_break() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-break",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (QemuDBusDisplay1ChardevIface, handle_send_break),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * QemuDBusDisplay1Chardev:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Chardev.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Chardev:feopened:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Chardev.FEOpened">"FEOpened"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("feopened", "FEOpened", "FEOpened", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Chardev:echo:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Chardev.Echo">"Echo"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("echo", "Echo", "Echo", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * QemuDBusDisplay1Chardev:owner:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-qemu-Display1-Chardev.Owner">"Owner"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("owner", "Owner", "Owner", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * qemu_dbus_display1_chardev_get_name: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_chardev_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
qemu_dbus_display1_chardev_get_name (QemuDBusDisplay1Chardev *object)
{
  return QEMU_DBUS_DISPLAY1_CHARDEV_GET_IFACE (object)->get_name (object);
}

/**
 * qemu_dbus_display1_chardev_dup_name: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
qemu_dbus_display1_chardev_dup_name (QemuDBusDisplay1Chardev *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_chardev_set_name: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_chardev_set_name (QemuDBusDisplay1Chardev *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * qemu_dbus_display1_chardev_get_feopened: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Chardev.FEOpened">"FEOpened"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
qemu_dbus_display1_chardev_get_feopened (QemuDBusDisplay1Chardev *object)
{
  return QEMU_DBUS_DISPLAY1_CHARDEV_GET_IFACE (object)->get_feopened (object);
}

/**
 * qemu_dbus_display1_chardev_set_feopened: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Chardev.FEOpened">"FEOpened"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_chardev_set_feopened (QemuDBusDisplay1Chardev *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "feopened", value, NULL);
}

/**
 * qemu_dbus_display1_chardev_get_echo: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Echo">"Echo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
qemu_dbus_display1_chardev_get_echo (QemuDBusDisplay1Chardev *object)
{
  return QEMU_DBUS_DISPLAY1_CHARDEV_GET_IFACE (object)->get_echo (object);
}

/**
 * qemu_dbus_display1_chardev_set_echo: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Echo">"Echo"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_chardev_set_echo (QemuDBusDisplay1Chardev *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "echo", value, NULL);
}

/**
 * qemu_dbus_display1_chardev_get_owner: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 *
 * Gets the value of the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Owner">"Owner"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use qemu_dbus_display1_chardev_dup_owner() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
qemu_dbus_display1_chardev_get_owner (QemuDBusDisplay1Chardev *object)
{
  return QEMU_DBUS_DISPLAY1_CHARDEV_GET_IFACE (object)->get_owner (object);
}

/**
 * qemu_dbus_display1_chardev_dup_owner: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Owner">"Owner"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
qemu_dbus_display1_chardev_dup_owner (QemuDBusDisplay1Chardev *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "owner", &value, NULL);
  return value;
}

/**
 * qemu_dbus_display1_chardev_set_owner: (skip)
 * @object: A #QemuDBusDisplay1Chardev.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-qemu-Display1-Chardev.Owner">"Owner"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
qemu_dbus_display1_chardev_set_owner (QemuDBusDisplay1Chardev *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "owner", value, NULL);
}

/**
 * qemu_dbus_display1_chardev_call_register:
 * @proxy: A #QemuDBusDisplay1ChardevProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Chardev.Register">Register()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_chardev_call_register_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_chardev_call_register_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_chardev_call_register (
    QemuDBusDisplay1Chardev *proxy,
    GVariant *arg_stream,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Register",
    g_variant_new ("(@h)",
                   arg_stream),
    call_flags,
    timeout_msec,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_chardev_call_register_finish:
 * @proxy: A #QemuDBusDisplay1ChardevProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_chardev_call_register().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_chardev_call_register().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_chardev_call_register_finish (
    QemuDBusDisplay1Chardev *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_chardev_call_register_sync:
 * @proxy: A #QemuDBusDisplay1ChardevProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Chardev.Register">Register()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_chardev_call_register() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_chardev_call_register_sync (
    QemuDBusDisplay1Chardev *proxy,
    GVariant *arg_stream,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Register",
    g_variant_new ("(@h)",
                   arg_stream),
    call_flags,
    timeout_msec,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_chardev_call_send_break:
 * @proxy: A #QemuDBusDisplay1ChardevProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Chardev.SendBreak">SendBreak()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_chardev_call_send_break_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_chardev_call_send_break_sync() for the synchronous, blocking version of this method.
 */
void
qemu_dbus_display1_chardev_call_send_break (
    QemuDBusDisplay1Chardev *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendBreak",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * qemu_dbus_display1_chardev_call_send_break_finish:
 * @proxy: A #QemuDBusDisplay1ChardevProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_chardev_call_send_break().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with qemu_dbus_display1_chardev_call_send_break().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_chardev_call_send_break_finish (
    QemuDBusDisplay1Chardev *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_chardev_call_send_break_sync:
 * @proxy: A #QemuDBusDisplay1ChardevProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-qemu-Display1-Chardev.SendBreak">SendBreak()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_chardev_call_send_break() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
qemu_dbus_display1_chardev_call_send_break_sync (
    QemuDBusDisplay1Chardev *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendBreak",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * qemu_dbus_display1_chardev_complete_register:
 * @object: A #QemuDBusDisplay1Chardev.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Chardev.Register">Register()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_chardev_complete_register (
    QemuDBusDisplay1Chardev *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/**
 * qemu_dbus_display1_chardev_complete_send_break:
 * @object: A #QemuDBusDisplay1Chardev.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-qemu-Display1-Chardev.SendBreak">SendBreak()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
qemu_dbus_display1_chardev_complete_send_break (
    QemuDBusDisplay1Chardev *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ChardevProxy:
 *
 * The #QemuDBusDisplay1ChardevProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ChardevProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ChardevProxy.
 */

struct _QemuDBusDisplay1ChardevProxyPrivate
{
  GData *qdata;
};

static void qemu_dbus_display1_chardev_proxy_iface_init (QemuDBusDisplay1ChardevIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ChardevProxy, qemu_dbus_display1_chardev_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (QemuDBusDisplay1ChardevProxy)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV, qemu_dbus_display1_chardev_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ChardevProxy, qemu_dbus_display1_chardev_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV, qemu_dbus_display1_chardev_proxy_iface_init))

#endif
static void
qemu_dbus_display1_chardev_proxy_finalize (GObject *object)
{
  QemuDBusDisplay1ChardevProxy *proxy = QEMU_DBUS_DISPLAY1_CHARDEV_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (qemu_dbus_display1_chardev_proxy_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_chardev_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_chardev_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
qemu_dbus_display1_chardev_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.qemu.Display1.Chardev: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
qemu_dbus_display1_chardev_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_chardev_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.qemu.Display1.Chardev", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) qemu_dbus_display1_chardev_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
qemu_dbus_display1_chardev_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_qemu_dbus_display1_chardev_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], QEMU_DBUS_TYPE_DISPLAY1_CHARDEV);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_CHARDEV);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
qemu_dbus_display1_chardev_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  QemuDBusDisplay1ChardevProxy *proxy = QEMU_DBUS_DISPLAY1_CHARDEV_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_chardev_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_chardev_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
qemu_dbus_display1_chardev_proxy_get_name (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevProxy *proxy = QEMU_DBUS_DISPLAY1_CHARDEV_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
qemu_dbus_display1_chardev_proxy_get_feopened (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevProxy *proxy = QEMU_DBUS_DISPLAY1_CHARDEV_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FEOpened");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
qemu_dbus_display1_chardev_proxy_get_echo (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevProxy *proxy = QEMU_DBUS_DISPLAY1_CHARDEV_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Echo");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
qemu_dbus_display1_chardev_proxy_get_owner (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevProxy *proxy = QEMU_DBUS_DISPLAY1_CHARDEV_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Owner");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
qemu_dbus_display1_chardev_proxy_init (QemuDBusDisplay1ChardevProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = qemu_dbus_display1_chardev_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, QEMU_DBUS_TYPE_DISPLAY1_CHARDEV_PROXY, QemuDBusDisplay1ChardevProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), qemu_dbus_display1_chardev_interface_info ());
}

static void
qemu_dbus_display1_chardev_proxy_class_init (QemuDBusDisplay1ChardevProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = qemu_dbus_display1_chardev_proxy_finalize;
  gobject_class->get_property = qemu_dbus_display1_chardev_proxy_get_property;
  gobject_class->set_property = qemu_dbus_display1_chardev_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = qemu_dbus_display1_chardev_proxy_g_signal;
  proxy_class->g_properties_changed = qemu_dbus_display1_chardev_proxy_g_properties_changed;

  qemu_dbus_display1_chardev_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ChardevProxyPrivate));
#endif
}

static void
qemu_dbus_display1_chardev_proxy_iface_init (QemuDBusDisplay1ChardevIface *iface)
{
  iface->get_name = qemu_dbus_display1_chardev_proxy_get_name;
  iface->get_feopened = qemu_dbus_display1_chardev_proxy_get_feopened;
  iface->get_echo = qemu_dbus_display1_chardev_proxy_get_echo;
  iface->get_owner = qemu_dbus_display1_chardev_proxy_get_owner;
}

/**
 * qemu_dbus_display1_chardev_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Chardev.top_of_page">org.qemu.Display1.Chardev</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_chardev_proxy_new_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_chardev_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_chardev_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Chardev", NULL);
}

/**
 * qemu_dbus_display1_chardev_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_chardev_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_chardev_proxy_new().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ChardevProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Chardev *
qemu_dbus_display1_chardev_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CHARDEV (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_chardev_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Chardev.top_of_page">org.qemu.Display1.Chardev</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_chardev_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ChardevProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Chardev *
qemu_dbus_display1_chardev_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Chardev", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CHARDEV (ret);
  else
    return NULL;
}


/**
 * qemu_dbus_display1_chardev_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like qemu_dbus_display1_chardev_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call qemu_dbus_display1_chardev_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See qemu_dbus_display1_chardev_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
qemu_dbus_display1_chardev_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Chardev", NULL);
}

/**
 * qemu_dbus_display1_chardev_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to qemu_dbus_display1_chardev_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with qemu_dbus_display1_chardev_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ChardevProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Chardev *
qemu_dbus_display1_chardev_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CHARDEV (ret);
  else
    return NULL;
}

/**
 * qemu_dbus_display1_chardev_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like qemu_dbus_display1_chardev_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See qemu_dbus_display1_chardev_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ChardevProxy): The constructed proxy object or %NULL if @error is set.
 */
QemuDBusDisplay1Chardev *
qemu_dbus_display1_chardev_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.qemu.Display1.Chardev", NULL);
  if (ret != NULL)
    return QEMU_DBUS_DISPLAY1_CHARDEV (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * QemuDBusDisplay1ChardevSkeleton:
 *
 * The #QemuDBusDisplay1ChardevSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * QemuDBusDisplay1ChardevSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #QemuDBusDisplay1ChardevSkeleton.
 */

struct _QemuDBusDisplay1ChardevSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_qemu_dbus_display1_chardev_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], QEMU_DBUS_TYPE_DISPLAY1_CHARDEV);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, QEMU_DBUS_TYPE_DISPLAY1_CHARDEV);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_qemu_dbus_display1_chardev_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_chardev_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_qemu_dbus_display1_chardev_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_qemu_dbus_display1_chardev_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _qemu_dbus_display1_chardev_skeleton_vtable =
{
  _qemu_dbus_display1_chardev_skeleton_handle_method_call,
  _qemu_dbus_display1_chardev_skeleton_handle_get_property,
  _qemu_dbus_display1_chardev_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
qemu_dbus_display1_chardev_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return qemu_dbus_display1_chardev_interface_info ();
}

static GDBusInterfaceVTable *
qemu_dbus_display1_chardev_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_qemu_dbus_display1_chardev_skeleton_vtable;
}

static GVariant *
qemu_dbus_display1_chardev_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_qemu_dbus_display1_chardev_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _qemu_dbus_display1_chardev_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _qemu_dbus_display1_chardev_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _qemu_dbus_display1_chardev_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.qemu.Display1.Chardev", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _qemu_dbus_display1_chardev_emit_changed (gpointer user_data);

static void
qemu_dbus_display1_chardev_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _qemu_dbus_display1_chardev_emit_changed (skeleton);
}

static void qemu_dbus_display1_chardev_skeleton_iface_init (QemuDBusDisplay1ChardevIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ChardevSkeleton, qemu_dbus_display1_chardev_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (QemuDBusDisplay1ChardevSkeleton)
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV, qemu_dbus_display1_chardev_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (QemuDBusDisplay1ChardevSkeleton, qemu_dbus_display1_chardev_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV, qemu_dbus_display1_chardev_skeleton_iface_init))

#endif
static void
qemu_dbus_display1_chardev_skeleton_finalize (GObject *object)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (qemu_dbus_display1_chardev_skeleton_parent_class)->finalize (object);
}

static void
qemu_dbus_display1_chardev_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_qemu_dbus_display1_chardev_emit_changed (gpointer user_data)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.qemu.Display1.Chardev",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_qemu_dbus_display1_chardev_schedule_emit_changed (QemuDBusDisplay1ChardevSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
qemu_dbus_display1_chardev_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _qemu_dbus_display1_chardev_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _qemu_dbus_display1_chardev_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
qemu_dbus_display1_chardev_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _qemu_dbus_display1_chardev_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _qemu_dbus_display1_chardev_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
qemu_dbus_display1_chardev_skeleton_init (QemuDBusDisplay1ChardevSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = qemu_dbus_display1_chardev_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, QEMU_DBUS_TYPE_DISPLAY1_CHARDEV_SKELETON, QemuDBusDisplay1ChardevSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
}

static const gchar *
qemu_dbus_display1_chardev_skeleton_get_name (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
qemu_dbus_display1_chardev_skeleton_get_feopened (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
qemu_dbus_display1_chardev_skeleton_get_echo (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
qemu_dbus_display1_chardev_skeleton_get_owner (QemuDBusDisplay1Chardev *object)
{
  QemuDBusDisplay1ChardevSkeleton *skeleton = QEMU_DBUS_DISPLAY1_CHARDEV_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
qemu_dbus_display1_chardev_skeleton_class_init (QemuDBusDisplay1ChardevSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = qemu_dbus_display1_chardev_skeleton_finalize;
  gobject_class->get_property = qemu_dbus_display1_chardev_skeleton_get_property;
  gobject_class->set_property = qemu_dbus_display1_chardev_skeleton_set_property;
  gobject_class->notify       = qemu_dbus_display1_chardev_skeleton_notify;


  qemu_dbus_display1_chardev_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = qemu_dbus_display1_chardev_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = qemu_dbus_display1_chardev_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = qemu_dbus_display1_chardev_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = qemu_dbus_display1_chardev_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (QemuDBusDisplay1ChardevSkeletonPrivate));
#endif
}

static void
qemu_dbus_display1_chardev_skeleton_iface_init (QemuDBusDisplay1ChardevIface *iface)
{
  iface->get_name = qemu_dbus_display1_chardev_skeleton_get_name;
  iface->get_feopened = qemu_dbus_display1_chardev_skeleton_get_feopened;
  iface->get_echo = qemu_dbus_display1_chardev_skeleton_get_echo;
  iface->get_owner = qemu_dbus_display1_chardev_skeleton_get_owner;
}

/**
 * qemu_dbus_display1_chardev_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-qemu-Display1-Chardev.top_of_page">org.qemu.Display1.Chardev</link>.
 *
 * Returns: (transfer full) (type QemuDBusDisplay1ChardevSkeleton): The skeleton object.
 */
QemuDBusDisplay1Chardev *
qemu_dbus_display1_chardev_skeleton_new (void)
{
  return QEMU_DBUS_DISPLAY1_CHARDEV (g_object_new (QEMU_DBUS_TYPE_DISPLAY1_CHARDEV_SKELETON, NULL));
}

