/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.gephi.statistics.plugin.Modularity;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.ModularityPanel;
import org.openide.util.NbBundle;

public class ModularityUI
implements StatisticsUI {
    private final StatSettings settings = new StatSettings();
    private ModularityPanel panel;
    private Modularity mod;

    public JPanel getSettingsPanel() {
        this.panel = new ModularityPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.mod = (Modularity)statistics;
        if (this.panel != null) {
            this.settings.load(this.mod);
            this.panel.setRandomize(this.mod.getRandom());
            this.panel.setUseWeight(this.mod.getUseWeight());
            this.panel.setResolution(this.mod.getResolution());
            this.panel.setInitialModularityClassIndex(this.mod.getInitialModularityClassIndex());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.mod.setRandom(this.panel.isRandomize());
            this.mod.setUseWeight(this.panel.useWeight());
            this.mod.setResolution(this.panel.resolution());
            this.mod.setInitialModularityClassIndex(this.panel.getInitialModularityClassIndex());
            this.settings.save(this.mod);
        }
        this.mod = null;
        this.panel = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return Modularity.class;
    }

    public String getValue() {
        DecimalFormat df = new DecimalFormat("###.###");
        return df.format(this.mod.getModularity());
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"ModularityUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_COMMUNITY_DETECTION;
    }

    public int getPosition() {
        return 600;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"ModularityUI.shortDescription");
    }

    private static class StatSettings {
        private boolean randomize = true;
        private boolean useWeight = true;

        private StatSettings() {
        }

        private void save(Modularity stat) {
            this.randomize = stat.getRandom();
            this.useWeight = stat.getUseWeight();
        }

        private void load(Modularity stat) {
            stat.setRandom(this.randomize);
            stat.setUseWeight(this.useWeight);
        }
    }
}

