/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.preview;

import javax.swing.JPanel;
import org.gephi.io.exporter.preview.PNGExporter;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.preview.AbstractExporterSettings;
import org.gephi.ui.exporter.preview.UIExporterPDF;
import org.gephi.ui.exporter.preview.UIExporterPNGPanel;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class UIExporterPNG
implements ExporterUI {
    private final ExporterPNGSettings settings = new ExporterPNGSettings();
    private UIExporterPNGPanel panel;
    private PNGExporter exporter;
    private ValidationPanel validationPanel;

    public JPanel getPanel() {
        this.panel = new UIExporterPNGPanel();
        this.validationPanel = UIExporterPNGPanel.createValidationPanel(this.panel);
        return this.validationPanel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (PNGExporter)exporter;
        this.settings.load(this.exporter);
        this.panel.setup(this.exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof PNGExporter;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterPDF.class, (String)"UIExporterPNG.name");
    }

    private static class ExporterPNGSettings
    extends AbstractExporterSettings {
        private static final String WIDTH = "PNG_width";
        private static final String HEIGHT = "PNG_height";
        private static final String MARGIN = "PNG_margin";
        private static final String TRANSPARENT_BACKGROUND = "PNG_transparentBackground";
        private static final PNGExporter DEFAULT = new PNGExporter();

        private ExporterPNGSettings() {
        }

        void load(PNGExporter exporter) {
            exporter.setHeight(this.get(HEIGHT, DEFAULT.getHeight()));
            exporter.setWidth(this.get(WIDTH, DEFAULT.getWidth()));
            exporter.setMargin(this.get(MARGIN, DEFAULT.getMargin()));
            exporter.setTransparentBackground(this.get(TRANSPARENT_BACKGROUND, DEFAULT.isTransparentBackground()));
        }

        void save(PNGExporter exporter) {
            this.put(HEIGHT, exporter.getHeight());
            this.put(WIDTH, exporter.getWidth());
            this.put(MARGIN, exporter.getMargin());
            this.put(TRANSPARENT_BACKGROUND, exporter.isTransparentBackground());
        }
    }
}

