/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.propertyeditor;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.openide.util.Lookup;

abstract class AbstractAttributeColumnPropertyEditor
extends PropertyEditorSupport {
    private final EditorClass editorClass;
    private final AttributeTypeClass attributeTypeClass;
    private Column[] columns;
    private Column selectedColumn;

    protected AbstractAttributeColumnPropertyEditor(EditorClass editorClass, AttributeTypeClass attributeClass) {
        this.editorClass = editorClass;
        this.attributeTypeClass = attributeClass;
    }

    protected Column[] getColumns() {
        ArrayList<Column> cols = new ArrayList<Column>();
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        if (model != null) {
            if (this.editorClass.equals((Object)EditorClass.NODE) || this.editorClass.equals((Object)EditorClass.NODEEDGE)) {
                for (Column column : model.getNodeTable()) {
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.NUMBER) && this.isNumberColumn(column)) {
                        cols.add(column);
                        continue;
                    }
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.DYNAMIC_NUMBER) && this.isDynamicNumberColumn(column)) {
                        cols.add(column);
                        continue;
                    }
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.ALL_NUMBER) && (this.isDynamicNumberColumn(column) || this.isNumberColumn(column))) {
                        cols.add(column);
                        continue;
                    }
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.ALL)) {
                        cols.add(column);
                        continue;
                    }
                    if (!this.attributeTypeClass.equals((Object)AttributeTypeClass.STRING) || !this.isStringColumn(column)) continue;
                    cols.add(column);
                }
            }
            if (this.editorClass.equals((Object)EditorClass.EDGE) || this.editorClass.equals((Object)EditorClass.NODEEDGE)) {
                for (Column column : model.getEdgeTable()) {
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.NUMBER) && this.isNumberColumn(column)) {
                        cols.add(column);
                        continue;
                    }
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.DYNAMIC_NUMBER) && this.isDynamicNumberColumn(column)) {
                        cols.add(column);
                        continue;
                    }
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.ALL_NUMBER) && (this.isDynamicNumberColumn(column) || this.isNumberColumn(column))) {
                        cols.add(column);
                        continue;
                    }
                    if (this.attributeTypeClass.equals((Object)AttributeTypeClass.ALL)) {
                        cols.add(column);
                        continue;
                    }
                    if (!this.attributeTypeClass.equals((Object)AttributeTypeClass.STRING) || !this.isStringColumn(column)) continue;
                    cols.add(column);
                }
            }
        }
        return cols.toArray(new Column[0]);
    }

    @Override
    public String[] getTags() {
        this.columns = this.getColumns();
        String[] tags = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            tags[i] = this.columns[i].getTitle();
        }
        return tags;
    }

    @Override
    public Object getValue() {
        return this.selectedColumn;
    }

    @Override
    public void setValue(Object value) {
        Column column;
        this.selectedColumn = column = (Column)value;
    }

    @Override
    public String getAsText() {
        if (this.selectedColumn == null) {
            return "---";
        }
        return this.selectedColumn.getTitle();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        for (Column c : this.columns) {
            if (!c.getTitle().equals(text)) continue;
            this.selectedColumn = c;
        }
    }

    public boolean isDynamicNumberColumn(Column column) {
        return AttributeUtils.isDynamicType((Class)column.getTypeClass()) && AttributeUtils.isNumberType((Class)column.getTypeClass());
    }

    public boolean isNumberColumn(Column column) {
        return AttributeUtils.isNumberType((Class)column.getTypeClass()) && !AttributeUtils.isArrayType((Class)column.getTypeClass()) && !AttributeUtils.isDynamicType((Class)column.getTypeClass());
    }

    public boolean isStringColumn(Column column) {
        return column.getTypeClass().equals(String.class);
    }

    public static enum AttributeTypeClass {
        ALL,
        NUMBER,
        STRING,
        DYNAMIC_NUMBER,
        ALL_NUMBER;

    }

    public static enum EditorClass {
        NODE,
        EDGE,
        NODEEDGE;

    }
}

