/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb.core;

import java.awt.Component;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.StringValuePair;

public class BreadcrumbTreeAdapterSelector
extends JBreadcrumbBar<Object> {
    public BreadcrumbTreeAdapterSelector(TreeModel treeModel, TreeAdapter treeAdapter, boolean isRootVisible) {
        super(new TreeCallback(treeModel, treeAdapter, isRootVisible));
    }

    public BreadcrumbTreeAdapterSelector(JTree tree, TreeAdapter treeAdapter) {
        this(tree.getModel(), treeAdapter, tree.isRootVisible());
    }

    public BreadcrumbTreeAdapterSelector(final JTree tree) {
        this(tree, new TreeAdapter(){

            private JLabel getRenderer(Object node) {
                Component renderer = tree.getCellRenderer().getTreeCellRendererComponent(tree, node, false, false, tree.getModel().isLeaf(node), 0, false);
                if (renderer instanceof JLabel) {
                    return (JLabel)renderer;
                }
                return null;
            }

            @Override
            public String toString(Object node) {
                JLabel label = this.getRenderer(node);
                if (label != null) {
                    return label.getText();
                }
                return null;
            }

            @Override
            public Icon getIcon(Object node) {
                JLabel label = this.getRenderer(node);
                if (label != null) {
                    return label.getIcon();
                }
                return null;
            }
        });
    }

    public static class TreeCallback
    extends BreadcrumbBarCallBack<Object> {
        protected TreeModel treeModel;
        protected TreeAdapter treeAdapter;
        protected boolean isRootVisible;

        public TreeCallback(TreeModel treeModel, TreeAdapter treeAdapter, boolean isRootVisible) {
            this.treeModel = treeModel;
            this.treeAdapter = treeAdapter;
            this.isRootVisible = isRootVisible;
        }

        @Override
        public List<StringValuePair<Object>> getPathChoices(List<BreadcrumbItem<Object>> path) {
            if (path == null) {
                Object root = this.treeModel.getRoot();
                LinkedList<StringValuePair<Object>> bRoots = new LinkedList<StringValuePair<Object>>();
                if (this.isRootVisible) {
                    StringValuePair<Object> rootPair = new StringValuePair<Object>(this.treeAdapter.toString(root), root);
                    rootPair.set("icon", this.treeAdapter.getIcon(root));
                    bRoots.add(rootPair);
                } else {
                    for (int i = 0; i < this.treeModel.getChildCount(root); ++i) {
                        Object rootChild = this.treeModel.getChild(root, i);
                        StringValuePair<Object> rootPair = new StringValuePair<Object>(this.treeAdapter.toString(rootChild), rootChild);
                        rootPair.set("icon", this.treeAdapter.getIcon(rootChild));
                        bRoots.add(rootPair);
                    }
                }
                return bRoots;
            }
            if (path.size() == 0) {
                return null;
            }
            Object lastInPath = path.get(path.size() - 1).getData();
            if (this.treeModel.isLeaf(lastInPath)) {
                return null;
            }
            LinkedList<StringValuePair<Object>> lResult = new LinkedList<StringValuePair<Object>>();
            for (int i = 0; i < this.treeModel.getChildCount(lastInPath); ++i) {
                Object child = this.treeModel.getChild(lastInPath, i);
                if (this.treeModel.isLeaf(child)) continue;
                StringValuePair<Object> pair = new StringValuePair<Object>(this.treeAdapter.toString(child), child);
                pair.set("icon", this.treeAdapter.getIcon(child));
                lResult.add(pair);
            }
            return lResult;
        }

        @Override
        public List<StringValuePair<Object>> getLeafs(List<BreadcrumbItem<Object>> path) {
            Object lastInPath = path.get(path.size() - 1).getData();
            if (this.treeModel.isLeaf(lastInPath)) {
                return null;
            }
            LinkedList<StringValuePair<Object>> lResult = new LinkedList<StringValuePair<Object>>();
            for (int i = 0; i < this.treeModel.getChildCount(lastInPath); ++i) {
                Object child = this.treeModel.getChild(lastInPath, i);
                if (!this.treeModel.isLeaf(child)) continue;
                StringValuePair<Object> pair = new StringValuePair<Object>(this.treeAdapter.toString(child), child);
                pair.set("icon", this.treeAdapter.getIcon(child));
                lResult.add(pair);
            }
            return lResult;
        }

        @Override
        public InputStream getLeafContent(Object leaf) {
            return null;
        }
    }

    public static abstract class TreeAdapter {
        public abstract String toString(Object var1);

        public Icon getIcon(Object node) {
            return null;
        }
    }
}

