/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import org.gephi.preview.AbstractRenderTarget;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.spi.RenderTargetBuilder;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PDFRenderTargetBuilder
implements RenderTargetBuilder {
    @Override
    public String getName() {
        return "pdf";
    }

    @Override
    public RenderTarget buildRenderTarget(PreviewModel previewModel) {
        CanvasSize cs = previewModel.getGraphicsCanvasSize();
        PreviewProperties properties = previewModel.getProperties();
        float marginBottom = properties.getFloatValue("pfd.margin.bottom");
        float marginLeft = properties.getFloatValue("pdf.margin.left");
        float marginRight = properties.getFloatValue("pdf.margin.right");
        float marginTop = properties.getFloatValue("pdf.margin.top");
        Rectangle pageSize = (Rectangle)properties.getValue("pdf.pagesize");
        boolean landscape = properties.getBooleanValue("pdf.landscape");
        PdfContentByte cb = (PdfContentByte)properties.getValue("pdf.contentbyte");
        PDFRenderTargetImpl renderTarget = new PDFRenderTargetImpl(cb, cs, pageSize, marginLeft, marginRight, marginTop, marginBottom, landscape);
        return renderTarget;
    }

    public static class PDFRenderTargetImpl
    extends AbstractRenderTarget
    implements PDFTarget {
        private static boolean fontRegistered = false;
        private final PdfContentByte cb;
        private final float marginTop;
        private final float marginBottom;
        private final float marginLeft;
        private final float marginRight;
        private final boolean landscape;
        private final Rectangle pageSize;

        public PDFRenderTargetImpl(PdfContentByte cb, CanvasSize cs, Rectangle size, float marginLeft, float marginRight, float marginTop, float marginBottom, boolean landscape) {
            this.cb = cb;
            this.marginTop = marginTop;
            this.marginLeft = marginLeft;
            this.marginBottom = marginBottom;
            this.marginRight = marginRight;
            this.pageSize = size;
            this.landscape = landscape;
            double centerX = cs.getX() + cs.getWidth() / 2.0f;
            double centerY = cs.getY() + cs.getHeight() / 2.0f;
            double pageWidth = size.getWidth() - marginLeft - marginRight;
            double pageHeight = size.getHeight() - marginTop - marginBottom;
            double ratioWidth = pageWidth / (double)cs.getWidth();
            double ratioHeight = pageHeight / (double)cs.getHeight();
            double scale = (float)(ratioWidth < ratioHeight ? ratioWidth : ratioHeight);
            double translateX = ((double)marginLeft + pageWidth / 2.0) / scale;
            double translateY = ((double)marginBottom + pageHeight / 2.0) / scale;
            cb.transform(AffineTransform.getTranslateInstance(-centerX * scale, centerY * scale));
            cb.transform(AffineTransform.getScaleInstance(scale, scale));
            cb.transform(AffineTransform.getTranslateInstance(translateX, translateY));
            FontFactory.register((String)"/org/gephi/preview/fonts/LiberationSans.ttf", (String)"ArialMT");
        }

        @Override
        public PdfContentByte getContentByte() {
            return this.cb;
        }

        @Override
        public BaseFont getBaseFont(Font font) {
            try {
                if (font != null) {
                    BaseFont baseFont;
                    if (!(font.getFontName().equals("Courier") || font.getFontName().equals("Courier-Bold") || font.getFontName().equals("Courier-Oblique") || font.getFontName().equals("Courier-BoldOblique") || font.getFontName().equals("Helvetica") || font.getFontName().equals("Helvetica-Bold") || font.getFontName().equals("Helvetica-BoldOblique") || font.getFontName().equals("Helvetica-Oblique") || font.getFontName().equals("Symbol") || font.getFontName().equals("Times-Roman") || font.getFontName().equals("Times-Bold") || font.getFontName().equals("Times-Italic") || font.getFontName().equals("Times-BoldItalic") || font.getFontName().equals("ZapfDingbats") || font.getFontName().equals("Courier-Bold") || font.getFontName().equals("Courier-Bold") || font.getFontName().equals("Courier-Bold"))) {
                        com.itextpdf.text.Font itextFont = FontFactory.getFont((String)font.getFontName(), (String)"Identity-H", (float)font.getSize(), (int)font.getStyle());
                        baseFont = itextFont.getBaseFont();
                        if (baseFont == null && !fontRegistered) {
                            if (this.progressTicket != null) {
                                String displayName = this.progressTicket.getDisplayName();
                                Progress.setDisplayName((ProgressTicket)this.progressTicket, (String)NbBundle.getMessage(PDFRenderTargetImpl.class, (String)"PDFRenderTargetImpl.font.registration"));
                                this.registerFonts();
                                Progress.setDisplayName((ProgressTicket)this.progressTicket, (String)displayName);
                            }
                            itextFont = FontFactory.getFont((String)font.getFontName(), (String)"Identity-H", (float)font.getSize(), (int)font.getStyle());
                            baseFont = itextFont.getBaseFont();
                            fontRegistered = true;
                        }
                    } else {
                        com.itextpdf.text.Font itextFont = FontFactory.getFont((String)font.getFontName(), (float)font.getSize(), (int)font.getStyle());
                        baseFont = itextFont.getBaseFont();
                    }
                    if (baseFont != null) {
                        return baseFont;
                    }
                    return BaseFont.createFont();
                }
                return BaseFont.createFont();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
                return null;
            }
        }

        private void registerFonts() {
            FontFactory.registerDirectories();
            if (Utilities.isMac()) {
                String userFonts = "/" + System.getProperty("user.home") + "/Library/Fonts";
                FontFactory.registerDirectory((String)userFonts);
                String adobeFonts = "/Library/Application Support/Adobe/Fonts";
                FontFactory.registerDirectory((String)adobeFonts);
            }
        }

        @Override
        public float getMarginBottom() {
            return this.marginBottom;
        }

        @Override
        public float getMarginLeft() {
            return this.marginLeft;
        }

        @Override
        public float getMarginRight() {
            return this.marginRight;
        }

        @Override
        public float getMarginTop() {
            return this.marginTop;
        }

        @Override
        public boolean isLandscape() {
            return this.landscape;
        }

        @Override
        public Rectangle getPageSize() {
            return this.pageSize;
        }
    }
}

