/* gnome-chess.c generated by valac 0.56.2, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2020 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include "libchess.h"
#include "libengine.h"
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <locale.h>

#define NEW_GAME_ACTION_NAME "new"
#define OPEN_GAME_ACTION_NAME "open"
#define SAVE_GAME_ACTION_NAME "save"
#define SAVE_GAME_AS_ACTION_NAME "save-as"
#define UNDO_MOVE_ACTION_NAME "undo"
#define RESIGN_ACTION_NAME "resign"
#define PAUSE_RESUME_ACTION_NAME "pause-resume"
#define HISTORY_GO_FIRST_ACTION_NAME "go-first"
#define HISTORY_GO_PREVIOUS_ACTION_NAME "go-previous"
#define HISTORY_GO_NEXT_ACTION_NAME "go-next"
#define HISTORY_GO_LAST_ACTION_NAME "go-last"
#define PREFERENCES_ACTION_NAME "preferences"
#define HELP_ACTION_NAME "help"
#define ABOUT_ACTION_NAME "about"
#define QUIT_ACTION_NAME "quit"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
typedef struct _ChessApplicationPrivate ChessApplicationPrivate;

#define TYPE_CHESS_WINDOW (chess_window_get_type ())
#define CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_WINDOW, ChessWindow))
#define CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_WINDOW, ChessWindowClass))
#define IS_CHESS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_WINDOW))
#define IS_CHESS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_WINDOW))
#define CHESS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_WINDOW, ChessWindowClass))

typedef struct _ChessWindow ChessWindow;
typedef struct _ChessWindowClass ChessWindowClass;

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
enum  {
	CHESS_APPLICATION_0_PROPERTY,
	CHESS_APPLICATION_WINDOW_PROPERTY,
	CHESS_APPLICATION_VIEW_PROPERTY,
	CHESS_APPLICATION_SCENE_PROPERTY,
	CHESS_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* chess_application_properties[CHESS_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
typedef void (*ChessScenePromotionTypeCompletionHandler) (PieceType* type, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef void (*ChessApplicationPromptSaveGameCallback) (gboolean cancelled, gpointer user_data);
typedef struct _Block7Data Block7Data;
typedef void (*ChessApplicationPresentSaveDialogCallback) (gboolean saved, gpointer user_data);
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;

#define TYPE_PROMOTION_TYPE_SELECTOR_DIALOG (promotion_type_selector_dialog_get_type ())
#define PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialog))
#define PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define PROMOTION_TYPE_SELECTOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))

typedef struct _PromotionTypeSelectorDialog PromotionTypeSelectorDialog;
typedef struct _PromotionTypeSelectorDialogClass PromotionTypeSelectorDialogClass;
typedef struct _Block10Data Block10Data;
typedef enum  {
	CHESS_WINDOW_LAYOUT_MODE_NORMAL,
	CHESS_WINDOW_LAYOUT_MODE_NARROW
} ChessWindowLayoutMode;

#define CHESS_WINDOW_TYPE_LAYOUT_MODE (chess_window_layout_mode_get_type ())
typedef enum  {
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP
} PromotionTypeSelectorDialogSelectedType;

#define PROMOTION_TYPE_SELECTOR_DIALOG_TYPE_SELECTED_TYPE (promotion_type_selector_dialog_selected_type_get_type ())
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessApplication {
	AdwApplication parent_instance;
	ChessApplicationPrivate * priv;
};

struct _ChessApplicationClass {
	AdwApplicationClass parent_class;
};

struct _ChessApplicationPrivate {
	GSettings* settings;
	ChessWindow* _window;
	PreferencesDialog* preferences_dialog;
	GtkAboutDialog* about_dialog;
	GtkFileChooserNative* open_dialog;
	GtkFileChooserNative* save_dialog;
	gulong save_dialog_response_id;
	PGNGame* pgn_game;
	ChessGame* game;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gboolean starting;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
	guint engine_timeout_source;
	gchar* copyrights;
};

struct _Block4Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
	ChessState* original_state;
	gchar* move;
};

struct _Block5Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
};

struct _Block6Data {
	int _ref_count_;
	ChessApplication* self;
	gboolean started;
	ChessGame* game;
	ChessMove* move;
};

struct _Block7Data {
	int _ref_count_;
	ChessApplication* self;
	GtkMessageDialog* prompt_save_game_dialog;
	ChessApplicationPromptSaveGameCallback callback;
	gpointer callback_target;
};

struct _Block8Data {
	int _ref_count_;
	ChessApplication* self;
	GtkMessageDialog* claim_draw_dialog;
};

struct _Block9Data {
	int _ref_count_;
	ChessApplication* self;
	GtkMessageDialog* resign_dialog;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _Block10Data {
	int _ref_count_;
	ChessApplication* self;
	PromotionTypeSelectorDialog* promotion_type_selector_dialog;
	ChessScenePromotionTypeCompletionHandler handler;
	gpointer handler_target;
	GDestroyNotify handler_target_destroy_notify;
};

struct _Block11Data {
	int _ref_count_;
	ChessApplication* self;
	GtkMessageDialog* invalid_pgn_dialog;
};

struct _Block12Data {
	int _ref_count_;
	ChessApplication* self;
	GtkMessageDialog* invalid_move_dialog;
};

struct _Block13Data {
	int _ref_count_;
	ChessApplication* self;
	ChessApplicationPresentSaveDialogCallback callback;
	gpointer callback_target;
};

struct _Block14Data {
	int _ref_count_;
	Block13Data * _data13_;
	GtkMessageDialog* save_error_dialog;
};

static gint ChessApplication_private_offset;
static gpointer chess_application_parent_class = NULL;

VALA_EXTERN GType chess_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessApplication, g_object_unref)
VALA_EXTERN GType chess_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessWindow, g_object_unref)
VALA_EXTERN GType preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
VALA_EXTERN void chess_application_new_game_cb (ChessApplication* self);
static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
VALA_EXTERN void chess_application_open_game_cb (ChessApplication* self);
static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void chess_application_save_game_cb (ChessApplication* self);
static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void chess_application_save_game_as_cb (ChessApplication* self);
static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
VALA_EXTERN void chess_application_undo_move_cb (ChessApplication* self);
static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void chess_application_resign_cb (ChessApplication* self);
static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
VALA_EXTERN void chess_application_pause_resume_cb (ChessApplication* self);
static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void chess_application_history_go_first_cb (ChessApplication* self);
static void _chess_application_history_go_first_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void chess_application_history_go_previous_cb (ChessApplication* self);
static void _chess_application_history_go_previous_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void chess_application_history_go_next_cb (ChessApplication* self);
static void _chess_application_history_go_next_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void chess_application_history_go_last_cb (ChessApplication* self);
static void _chess_application_history_go_last_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void chess_application_preferences_cb (ChessApplication* self);
static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
VALA_EXTERN void chess_application_help_cb (ChessApplication* self);
static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
VALA_EXTERN void chess_application_about_cb (ChessApplication* self);
static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
VALA_EXTERN void chess_application_quit_cb (ChessApplication* self);
static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static ChessApplication* chess_application_new (void);
static ChessApplication* chess_application_construct (GType object_type);
static gint chess_application_real_handle_local_options (GApplication* base,
                                                  GVariantDict* options);
static void chess_application_real_startup (GApplication* base);
VALA_EXTERN ChessWindow* chess_window_new (ChessApplication* app);
VALA_EXTERN ChessWindow* chess_window_construct (GType object_type,
                                     ChessApplication* app);
static void chess_application_set_window (ChessApplication* self,
                                   ChessWindow* value);
VALA_EXTERN ChessWindow* chess_application_get_window (ChessApplication* self);
VALA_EXTERN GType chess_scene_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessScene, g_object_unref)
VALA_EXTERN ChessScene* chess_application_get_scene (ChessApplication* self);
static gboolean __lambda22_ (ChessApplication* self,
                      ChessPlayer* p);
static gboolean ___lambda22__chess_scene_is_human (ChessScene* _sender,
                                            ChessPlayer* player,
                                            gpointer self);
static void chess_application_show_promotion_type_selector (ChessApplication* self,
                                                     ChessScenePromotionTypeCompletionHandler handler,
                                                     gpointer handler_target,
                                                     GDestroyNotify handler_target_destroy_notify);
static void _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender,
                                                                                        ChessScenePromotionTypeCompletionHandler handler,
                                                                                        gpointer handler_target,
                                                                                        GDestroyNotify handler_target_destroy_notify,
                                                                                        gpointer self);
static void chess_application_real_open (GApplication* base,
                                  GFile** files,
                                  gint files_length1,
                                  const gchar* hint);
static void chess_application_real_activate (GApplication* base);
static void chess_application_start_new_game (ChessApplication* self);
static void chess_application_load_game (ChessApplication* self,
                                  GFile* file);
static void chess_application_real_shutdown (GApplication* base);
static void chess_application_autosave (ChessApplication* self);
VALA_EXTERN void chess_application_quit_game (ChessApplication* self);
static void chess_application_update_pgn_time_remaining (ChessApplication* self);
static void chess_application_start_game (ChessApplication* self);
static void chess_application_game_turn_cb (ChessApplication* self,
                                     ChessGame* game,
                                     ChessPlayer* player);
static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender,
                                                              ChessPlayer* player,
                                                              gpointer self);
static void chess_application_game_move_cb (ChessApplication* self,
                                     ChessGame* game,
                                     ChessMove* move);
static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender,
                                                       ChessMove* move,
                                                       gpointer self);
static void chess_application_game_undo_cb (ChessApplication* self,
                                     ChessGame* game);
static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender,
                                                      gpointer self);
static void chess_application_game_end_cb (ChessApplication* self);
static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender,
                                                      gpointer self);
static void chess_application_show_invalid_move_dialog (ChessApplication* self,
                                                 const gchar* error_message);
VALA_EXTERN void chess_scene_set_game (ChessScene* self,
                           ChessGame* value);
VALA_EXTERN void chess_window_start_game (ChessWindow* self);
static void chess_application_engine_move_cb (ChessApplication* self,
                                       ChessEngine* engine,
                                       const gchar* move);
static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender,
                                                           const gchar* move,
                                                           gpointer self);
static void chess_application_engine_resigned_cb (ChessApplication* self,
                                           ChessEngine* engine);
static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender,
                                                                  gpointer self);
static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self,
                                                       ChessEngine* engine);
static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender,
                                                                                          gpointer self);
static void chess_application_engine_error_cb (ChessApplication* self,
                                        ChessEngine* engine);
static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender,
                                                            gpointer self);
static void chess_application_engine_claim_draw_cb (ChessApplication* self,
                                             ChessEngine* engine);
static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender,
                                                                      gpointer self);
static void chess_application_engine_offer_draw_cb (ChessApplication* self,
                                             ChessEngine* engine);
static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender,
                                                                      gpointer self);
static ChessEngine* chess_application_get_engine (ChessApplication* self,
                                           const gchar* name,
                                           const gchar* difficulty);
VALA_EXTERN void chess_application_disable_action (ChessApplication* self,
                                       const gchar* name);
VALA_EXTERN void chess_application_enable_action (ChessApplication* self,
                                      const gchar* name);
VALA_EXTERN void chess_window_set_clock_visible (ChessWindow* self,
                                     gboolean visible);
static void chess_application_update_action_status (ChessApplication* self);
VALA_EXTERN void chess_window_update_history_panel (ChessWindow* self);
VALA_EXTERN void chess_window_update_pause_resume_button (ChessWindow* self);
VALA_EXTERN void chess_window_update_game_status (ChessWindow* self,
                                      const gchar* title,
                                      const gchar* info);
static void chess_application_update_engine_timeout (ChessApplication* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup9 (gchar** self,
                          gssize length);
static void chess_application_do_engine_move (ChessApplication* self,
                                       const gchar* move);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean ___lambda15_ (Block4Data* _data4_);
static gboolean ____lambda15__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda16_ (Block5Data* _data5_);
static gboolean ___lambda16__gsource_func (gpointer self);
static gboolean ___lambda12_ (ChessApplication* self);
static gboolean ____lambda12__gsource_func (gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN void chess_window_move (ChessWindow* self,
                        ChessMove* m);
VALA_EXTERN GType chess_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessView, g_object_unref)
VALA_EXTERN ChessView* chess_application_get_view (ChessApplication* self);
static gboolean __lambda10_ (Block6Data* _data6_);
static void chess_application_present_claim_draw_dialog (ChessApplication* self);
static gboolean ___lambda10__gsource_func (gpointer self);
VALA_EXTERN void chess_window_undo (ChessWindow* self);
VALA_EXTERN gchar* chess_application_compute_current_title (ChessApplication* self);
VALA_EXTERN gchar* chess_application_compute_status_info (ChessApplication* self);
VALA_EXTERN void chess_window_end_game (ChessWindow* self);
static void chess_application_prompt_save_game (ChessApplication* self,
                                         const gchar* prompt_text,
                                         ChessApplicationPromptSaveGameCallback callback,
                                         gpointer callback_target);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda5_ (Block7Data* _data7_,
                 gint response_id);
static void chess_application_present_save_dialog (ChessApplication* self,
                                            ChessApplicationPresentSaveDialogCallback callback,
                                            gpointer callback_target);
static void ____lambda8_ (Block7Data* _data7_,
                   gboolean saved);
static void _____lambda8__chess_application_present_save_dialog_callback (gboolean saved,
                                                                   gpointer self);
static void ___lambda5__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda11_ (Block8Data* _data8_,
                  gint response_id);
static void ___lambda11__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void __lambda9_ (ChessApplication* self,
                 gboolean cancelled);
static void ___lambda9__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                              gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda20_ (Block9Data* _data9_,
                  gint response_id);
static void ___lambda20__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN GType chess_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessModel, g_object_unref)
VALA_EXTERN void chess_scene_set_move_number (ChessScene* self,
                                  gint value);
VALA_EXTERN gint chess_scene_get_move_number (ChessScene* self);
VALA_EXTERN PreferencesDialog* preferences_dialog_new (GtkWindow* window,
                                           GSettings* settings,
                                           GList* ai_profiles);
VALA_EXTERN PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkWindow* window,
                                                 GSettings* settings,
                                                 GList* ai_profiles);
static void __lambda21_ (ChessApplication* self);
static void ___lambda21__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN GType promotion_type_selector_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromotionTypeSelectorDialog, g_object_unref)
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
VALA_EXTERN const gchar* chess_scene_get_theme_name (ChessScene* self);
VALA_EXTERN GType chess_window_layout_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ChessWindowLayoutMode chess_window_get_layout_mode (ChessWindow* self);
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_new (GtkWindow* window,
                                                                 Color color,
                                                                 const gchar* theme,
                                                                 ChessWindowLayoutMode layout_mode);
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_construct (GType object_type,
                                                                       GtkWindow* window,
                                                                       Color color,
                                                                       const gchar* theme,
                                                                       ChessWindowLayoutMode layout_mode);
static void __lambda24_ (Block10Data* _data10_,
                  gint response_id);
static GType promotion_type_selector_dialog_selected_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void ___lambda24__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void chess_application_run_invalid_pgn_dialog (ChessApplication* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda19_ (Block11Data* _data11_);
static void ___lambda19__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda13_ (Block12Data* _data12_);
static void ___lambda13__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda6_ (Block13Data* _data13_,
                 gint response_id);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ____lambda7_ (Block14Data* _data14_);
static void _____lambda7__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void ___lambda6__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                             gint response_id,
                                             gpointer self);
static void __lambda17_ (ChessApplication* self,
                  gboolean cancelled);
static void ___lambda18_ (ChessApplication* self,
                   gint response_id);
static void ____lambda18__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                               gint response_id,
                                               gpointer self);
static void ___lambda17__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                               gpointer self);
static gint chess_application_main (gchar** args,
                             gint args_length1);
VALA_EXTERN ChessView* chess_window_get_view (ChessWindow* self);
VALA_EXTERN ChessScene* chess_view_get_scene (ChessView* self);
static void chess_application_finalize (GObject * obj);
static GType chess_application_get_type_once (void);
static void _vala_chess_application_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_chess_application_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CHESS_APPLICATION_action_entries[15] = {{NEW_GAME_ACTION_NAME, _chess_application_new_game_cb_gsimple_action_activate_callback}, {OPEN_GAME_ACTION_NAME, _chess_application_open_game_cb_gsimple_action_activate_callback}, {SAVE_GAME_ACTION_NAME, _chess_application_save_game_cb_gsimple_action_activate_callback}, {SAVE_GAME_AS_ACTION_NAME, _chess_application_save_game_as_cb_gsimple_action_activate_callback}, {UNDO_MOVE_ACTION_NAME, _chess_application_undo_move_cb_gsimple_action_activate_callback}, {RESIGN_ACTION_NAME, _chess_application_resign_cb_gsimple_action_activate_callback}, {PAUSE_RESUME_ACTION_NAME, _chess_application_pause_resume_cb_gsimple_action_activate_callback}, {HISTORY_GO_FIRST_ACTION_NAME, _chess_application_history_go_first_cb_gsimple_action_activate_callback}, {HISTORY_GO_PREVIOUS_ACTION_NAME, _chess_application_history_go_previous_cb_gsimple_action_activate_callback}, {HISTORY_GO_NEXT_ACTION_NAME, _chess_application_history_go_next_cb_gsimple_action_activate_callback}, {HISTORY_GO_LAST_ACTION_NAME, _chess_application_history_go_last_cb_gsimple_action_activate_callback}, {PREFERENCES_ACTION_NAME, _chess_application_preferences_cb_gsimple_action_activate_callback}, {HELP_ACTION_NAME, _chess_application_help_cb_gsimple_action_activate_callback}, {ABOUT_ACTION_NAME, _chess_application_about_cb_gsimple_action_activate_callback}, {QUIT_ACTION_NAME, _chess_application_quit_cb_gsimple_action_activate_callback}};
static const GOptionEntry CHESS_APPLICATION_option_entries[2] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const gchar* CHESS_APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* CHESS_APPLICATION_artists[3] = {"Max Froumentin", "Jakub Steiner", NULL};

static inline gpointer
chess_application_get_instance_private (ChessApplication* self)
{
	return G_STRUCT_MEMBER_P (self, ChessApplication_private_offset);
}

static void
_chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	chess_application_new_game_cb ((ChessApplication*) self);
}

static void
_chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	chess_application_open_game_cb ((ChessApplication*) self);
}

static void
_chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	chess_application_save_game_cb ((ChessApplication*) self);
}

static void
_chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	chess_application_save_game_as_cb ((ChessApplication*) self);
}

static void
_chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	chess_application_undo_move_cb ((ChessApplication*) self);
}

static void
_chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	chess_application_resign_cb ((ChessApplication*) self);
}

static void
_chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	chess_application_pause_resume_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_first_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	chess_application_history_go_first_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_previous_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	chess_application_history_go_previous_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_next_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	chess_application_history_go_next_cb ((ChessApplication*) self);
}

static void
_chess_application_history_go_last_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	chess_application_history_go_last_cb ((ChessApplication*) self);
}

static void
_chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	chess_application_preferences_cb ((ChessApplication*) self);
}

static void
_chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	chess_application_help_cb ((ChessApplication*) self);
}

static void
_chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	chess_application_about_cb ((ChessApplication*) self);
}

static void
_chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	chess_application_quit_cb ((ChessApplication*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static ChessApplication*
chess_application_construct (GType object_type)
{
	ChessApplication * self = NULL;
	self = (ChessApplication*) g_object_new (object_type, "application-id", "org.gnome.Chess", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_application_add_main_option_entries ((GApplication*) self, CHESS_APPLICATION_option_entries);
	return self;
}

static ChessApplication*
chess_application_new (void)
{
	return chess_application_construct (TYPE_CHESS_APPLICATION);
}

static gint
chess_application_real_handle_local_options (GApplication* base,
                                             GVariantDict* options)
{
	ChessApplication * self;
	gint result;
	self = (ChessApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "gnome-chess %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static gboolean
__lambda22_ (ChessApplication* self,
             ChessPlayer* p)
{
	ChessPlayer* _tmp0_;
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = self->priv->human_player;
	result = p == _tmp0_;
	return result;
}

static gboolean
___lambda22__chess_scene_is_human (ChessScene* _sender,
                                   ChessPlayer* player,
                                   gpointer self)
{
	gboolean result;
	result = __lambda22_ ((ChessApplication*) self, player);
	return result;
}

static void
_chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender,
                                                                                   ChessScenePromotionTypeCompletionHandler handler,
                                                                                   gpointer handler_target,
                                                                                   GDestroyNotify handler_target_destroy_notify,
                                                                                   gpointer self)
{
	chess_application_show_promotion_type_selector ((ChessApplication*) self, handler, handler_target, handler_target_destroy_notify);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
chess_application_real_startup (GApplication* base)
{
	ChessApplication * self;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	ChessWindow* _tmp39_;
	ChessWindow* _tmp40_;
	ChessWindow* _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	GSettings* _tmp44_;
	ChessWindow* _tmp46_;
	GSettings* _tmp47_;
	ChessScene* _tmp48_;
	ChessScene* _tmp49_;
	GSettings* _tmp50_;
	ChessScene* _tmp51_;
	ChessScene* _tmp52_;
	GSettings* _tmp53_;
	ChessScene* _tmp54_;
	ChessScene* _tmp55_;
	GSettings* _tmp56_;
	ChessScene* _tmp57_;
	ChessScene* _tmp58_;
	GSettings* _tmp59_;
	ChessScene* _tmp60_;
	ChessScene* _tmp61_;
	ChessScene* _tmp62_;
	ChessScene* _tmp63_;
	ChessScene* _tmp64_;
	ChessScene* _tmp65_;
	gchar* system_engine_cfg = NULL;
	gchar* _tmp66_;
	gchar* user_engine_cfg = NULL;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	const gchar* _tmp69_;
	GList* _tmp75_;
	self = (ChessApplication*) base;
	G_APPLICATION_CLASS (chess_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = g_settings_new ("org.gnome.Chess");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, CHESS_APPLICATION_action_entries, (gint) G_N_ELEMENTS (CHESS_APPLICATION_action_entries), self);
	_tmp1_ = g_strdup ("<Control>n");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." NEW_GAME_ACTION_NAME, _tmp3_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = g_strdup ("<Control>o");
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." OPEN_GAME_ACTION_NAME, _tmp6_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = g_strdup ("<Control>s");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." SAVE_GAME_ACTION_NAME, _tmp9_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = g_strdup ("<Shift><Control>s");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." SAVE_GAME_AS_ACTION_NAME, _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = g_strdup ("<Control>z");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." UNDO_MOVE_ACTION_NAME, _tmp15_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = g_strdup ("<Control>p");
	_tmp17_ = g_strdup ("Pause");
	_tmp18_ = g_new0 (gchar*, 2 + 1);
	_tmp18_[0] = _tmp16_;
	_tmp18_[1] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." PAUSE_RESUME_ACTION_NAME, _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = g_strdup ("<Shift><Alt>Left");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_FIRST_ACTION_NAME, _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_strdup ("<Alt>Left");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_PREVIOUS_ACTION_NAME, _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = g_strdup ("<Alt>Right");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_NEXT_ACTION_NAME, _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("<Shift><Alt>Right");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HISTORY_GO_LAST_ACTION_NAME, _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("F1");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." HELP_ACTION_NAME, _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("<Control>q");
	_tmp36_ = g_strdup ("<Control>w");
	_tmp37_ = g_new0 (gchar*, 2 + 1);
	_tmp37_[0] = _tmp35_;
	_tmp37_[1] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app." QUIT_ACTION_NAME, _tmp38_);
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
	_tmp39_ = chess_window_new (self);
	g_object_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	chess_application_set_window (self, _tmp40_);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = self->priv->_window;
	_tmp42_ = self->priv->settings;
	_tmp43_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) _tmp41_, g_settings_get_int (_tmp42_, "width"), g_settings_get_int (_tmp43_, "height"));
	_tmp44_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp44_, "maximized")) {
		ChessWindow* _tmp45_;
		_tmp45_ = self->priv->_window;
		gtk_window_maximize ((GtkWindow*) _tmp45_);
	}
	_tmp46_ = self->priv->_window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp46_);
	_tmp47_ = self->priv->settings;
	_tmp48_ = chess_application_get_scene (self);
	_tmp49_ = _tmp48_;
	g_settings_bind (_tmp47_, "show-move-hints", (GObject*) _tmp49_, "show-move-hints", G_SETTINGS_BIND_GET);
	_tmp50_ = self->priv->settings;
	_tmp51_ = chess_application_get_scene (self);
	_tmp52_ = _tmp51_;
	g_settings_bind (_tmp50_, "show-numbering", (GObject*) _tmp52_, "show-numbering", G_SETTINGS_BIND_GET);
	_tmp53_ = self->priv->settings;
	_tmp54_ = chess_application_get_scene (self);
	_tmp55_ = _tmp54_;
	g_settings_bind (_tmp53_, "piece-theme", (GObject*) _tmp55_, "theme-name", G_SETTINGS_BIND_GET);
	_tmp56_ = self->priv->settings;
	_tmp57_ = chess_application_get_scene (self);
	_tmp58_ = _tmp57_;
	g_settings_bind (_tmp56_, "move-format", (GObject*) _tmp58_, "move-format", G_SETTINGS_BIND_GET);
	_tmp59_ = self->priv->settings;
	_tmp60_ = chess_application_get_scene (self);
	_tmp61_ = _tmp60_;
	g_settings_bind (_tmp59_, "board-side", (GObject*) _tmp61_, "board-side", G_SETTINGS_BIND_GET);
	_tmp62_ = chess_application_get_scene (self);
	_tmp63_ = _tmp62_;
	g_signal_connect_object (_tmp63_, "is-human", (GCallback) ___lambda22__chess_scene_is_human, self, 0);
	_tmp64_ = chess_application_get_scene (self);
	_tmp65_ = _tmp64_;
	g_signal_connect_object (_tmp65_, "choose-promotion-type", (GCallback) _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
	_tmp66_ = g_build_filename (SYSCONFDIR, "gnome-chess", "engines.conf", NULL, NULL);
	system_engine_cfg = _tmp66_;
	_tmp67_ = g_get_user_config_dir ();
	_tmp68_ = g_build_filename (_tmp67_, "gnome-chess", "engines.conf", NULL, NULL);
	user_engine_cfg = _tmp68_;
	_tmp69_ = user_engine_cfg;
	if (g_file_test (_tmp69_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp70_;
		GList* _tmp71_;
		_tmp70_ = user_engine_cfg;
		_tmp71_ = ai_profile_load_ai_profiles (_tmp70_);
		(self->priv->ai_profiles == NULL) ? NULL : (self->priv->ai_profiles = (_g_list_free__g_object_unref0_ (self->priv->ai_profiles), NULL));
		self->priv->ai_profiles = _tmp71_;
	} else {
		const gchar* _tmp72_;
		_tmp72_ = system_engine_cfg;
		if (g_file_test (_tmp72_, G_FILE_TEST_EXISTS)) {
			const gchar* _tmp73_;
			GList* _tmp74_;
			_tmp73_ = system_engine_cfg;
			_tmp74_ = ai_profile_load_ai_profiles (_tmp73_);
			(self->priv->ai_profiles == NULL) ? NULL : (self->priv->ai_profiles = (_g_list_free__g_object_unref0_ (self->priv->ai_profiles), NULL));
			self->priv->ai_profiles = _tmp74_;
		} else {
			g_warning ("gnome-chess.vala:161: engines.conf not found");
		}
	}
	_tmp75_ = self->priv->ai_profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp75_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			AIProfile* _tmp76_;
			AIProfile* profile = NULL;
			_tmp76_ = _g_object_ref0 ((AIProfile*) profile_it->data);
			profile = _tmp76_;
			{
				AIProfile* _tmp77_;
				const gchar* _tmp78_;
				const gchar* _tmp79_;
				AIProfile* _tmp80_;
				const gchar* _tmp81_;
				const gchar* _tmp82_;
				_tmp77_ = profile;
				_tmp78_ = ai_profile_get_name (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = profile;
				_tmp81_ = ai_profile_get_path (_tmp80_);
				_tmp82_ = _tmp81_;
				g_debug ("gnome-chess.vala:164: Detected AI profile %s in %s", _tmp79_, _tmp82_);
				_g_object_unref0 (profile);
			}
		}
	}
	_g_free0 (user_engine_cfg);
	_g_free0 (system_engine_cfg);
}

static void
chess_application_real_open (GApplication* base,
                             GFile** files,
                             gint files_length1,
                             const gchar* hint)
{
	ChessApplication * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	self = (ChessApplication*) base;
	g_return_if_fail (hint != NULL);
	if (files_length1 != 1) {
		g_warning ("gnome-chess.vala:172: %s", _ ("GNOME Chess can only open one PGN at a time."));
	}
	_tmp0_ = files[0];
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp1_;
	g_application_activate ((GApplication*) self);
}

static void
chess_application_real_activate (GApplication* base)
{
	ChessApplication * self;
	ChessWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ChessWindow* _tmp22_;
	self = (ChessApplication*) base;
	_tmp0_ = self->priv->_window;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GFile* data_dir = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp20_;
		_tmp3_ = g_get_user_data_dir ();
		_tmp4_ = g_build_filename (_tmp3_, "gnome-chess", NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		data_dir = _tmp7_;
		_tmp8_ = data_dir;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		g_mkdir_with_parents (_tmp10_, 0755);
		_g_free0 (_tmp10_);
		_tmp11_ = data_dir;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "/autosave.pgn", NULL);
		_g_free0 (self->priv->autosave_filename);
		self->priv->autosave_filename = _tmp14_;
		_g_free0 (_tmp13_);
		_tmp16_ = self->priv->game_file;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_;
			_tmp17_ = self->priv->autosave_filename;
			_tmp15_ = g_file_test (_tmp17_, G_FILE_TEST_EXISTS);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			const gchar* _tmp18_;
			GFile* _tmp19_;
			_tmp18_ = self->priv->autosave_filename;
			_tmp19_ = g_file_new_for_path (_tmp18_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp19_;
		}
		_tmp20_ = self->priv->game_file;
		if (_tmp20_ == NULL) {
			chess_application_start_new_game (self);
		} else {
			GFile* _tmp21_;
			_tmp21_ = self->priv->game_file;
			chess_application_load_game (self, _tmp21_);
		}
		_g_object_unref0 (data_dir);
	}
	_tmp22_ = self->priv->_window;
	gtk_window_present ((GtkWindow*) _tmp22_);
}

static void
chess_application_real_shutdown (GApplication* base)
{
	ChessApplication * self;
	ChessEngine* _tmp0_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	ChessWindow* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GSettings* _tmp7_;
	ChessWindow* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GSettings* _tmp11_;
	ChessWindow* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GSettings* _tmp15_;
	self = (ChessApplication*) base;
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp1_, TRUE);
	}
	chess_application_autosave (self);
	_tmp2_ = self->priv->settings;
	g_settings_delay (_tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->_window;
	g_object_get ((GtkWindow*) _tmp4_, "default-width", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	g_settings_set_int (_tmp3_, "width", _tmp6_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = self->priv->_window;
	g_object_get ((GtkWindow*) _tmp8_, "default-height", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	g_settings_set_int (_tmp7_, "height", _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = self->priv->_window;
	g_object_get ((GtkWindow*) _tmp12_, "maximized", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	g_settings_set_boolean (_tmp11_, "maximized", _tmp14_);
	_tmp15_ = self->priv->settings;
	g_settings_apply (_tmp15_);
	G_APPLICATION_CLASS (chess_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
}

void
chess_application_quit_game (ChessApplication* self)
{
	ChessWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
chess_application_autosave (ChessApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->game_needs_saving) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->autosave_filename;
		g_remove (_tmp0_);
		return;
	}
	{
		GFile* autosave_file = NULL;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		PGNGame* _tmp6_;
		GFile* _tmp7_;
		_tmp1_ = self->priv->autosave_filename;
		_tmp2_ = g_file_new_for_path (_tmp1_);
		autosave_file = _tmp2_;
		_tmp3_ = autosave_file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		g_debug ("gnome-chess.vala:235: Writing current game to %s", _tmp5_);
		_g_free0 (_tmp5_);
		chess_application_update_pgn_time_remaining (self);
		_tmp6_ = self->priv->pgn_game;
		_tmp7_ = autosave_file;
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (autosave_file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (autosave_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("gnome-chess.vala:241: Failed to autosave: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender,
                                                         ChessPlayer* player,
                                                         gpointer self)
{
	chess_application_game_turn_cb ((ChessApplication*) self, _sender, player);
}

static void
_chess_application_game_move_cb_chess_game_moved (ChessGame* _sender,
                                                  ChessMove* move,
                                                  gpointer self)
{
	chess_application_game_move_cb ((ChessApplication*) self, _sender, move);
}

static void
_chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender,
                                                 gpointer self)
{
	chess_application_game_undo_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_game_end_cb_chess_game_ended (ChessGame* _sender,
                                                 gpointer self)
{
	chess_application_game_end_cb ((ChessApplication*) self);
}

static void
_chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender,
                                                      const gchar* move,
                                                      gpointer self)
{
	chess_application_engine_move_cb ((ChessApplication*) self, _sender, move);
}

static void
_chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender,
                                                             gpointer self)
{
	chess_application_engine_resigned_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender,
                                                                                     gpointer self)
{
	chess_application_engine_stopped_unexpectedly_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender,
                                                       gpointer self)
{
	chess_application_engine_error_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender,
                                                                 gpointer self)
{
	chess_application_engine_claim_draw_cb ((ChessApplication*) self, _sender);
}

static void
_chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender,
                                                                 gpointer self)
{
	chess_application_engine_offer_draw_cb ((ChessApplication*) self, _sender);
}

static void
chess_application_start_game (ChessApplication* self)
{
	gchar* fen = NULL;
	gchar* _tmp0_;
	gchar** moves = NULL;
	PGNGame* _tmp1_;
	GList* _tmp2_;
	gchar** _tmp3_;
	gint moves_length1;
	gint _moves_size_;
	gint i = 0;
	PGNGame* _tmp4_;
	GList* _tmp5_;
	PGNGame* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ChessGame* _tmp21_;
	gboolean _tmp36_ = FALSE;
	PGNGame* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	ChessGame* _tmp60_;
	ChessGame* _tmp61_;
	ChessGame* _tmp62_;
	ChessGame* _tmp63_;
	ChessScene* _tmp64_;
	ChessScene* _tmp65_;
	ChessGame* _tmp66_;
	ChessWindow* _tmp67_;
	gchar* white_engine = NULL;
	PGNGame* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* white_level = NULL;
	PGNGame* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	gchar* black_engine = NULL;
	PGNGame* _tmp78_;
	const gchar* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* black_level = NULL;
	PGNGame* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	const gchar* _tmp86_;
	ChessEngine* _tmp88_;
	const gchar* _tmp102_;
	ChessEngine* _tmp130_;
	gboolean _tmp157_ = FALSE;
	GFile* _tmp158_;
	ChessGame* _tmp163_;
	gint timer_increment_adj_value = 0;
	PGNGame* _tmp164_;
	const gchar* _tmp165_;
	const gchar* _tmp166_;
	ClockType clock_type = 0;
	PGNGame* _tmp174_;
	const gchar* _tmp175_;
	const gchar* _tmp176_;
	ChessWindow* _tmp186_;
	ChessGame* _tmp187_;
	ChessClock* _tmp188_;
	ChessClock* _tmp189_;
	ChessGame* _tmp190_;
	ChessClock* _tmp191_;
	ChessClock* _tmp192_;
	PGNGame* _tmp199_;
	const gchar* _tmp200_;
	const gchar* _tmp201_;
	const gchar* _tmp202_;
	ChessEngine* _tmp214_;
	gboolean _tmp216_ = FALSE;
	gchar** _tmp217_;
	gint _tmp217__length1;
	ChessWindow* _tmp224_;
	ChessWindow* _tmp225_;
	GList* _tmp226_;
	gboolean _tmp229_ = FALSE;
	gboolean _tmp230_ = FALSE;
	const gchar* _tmp231_;
	ChessGame* _tmp242_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->starting = TRUE;
	_tmp0_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
	fen = _tmp0_;
	_tmp1_ = self->priv->pgn_game;
	_tmp2_ = _tmp1_->moves;
	_tmp3_ = g_new0 (gchar*, g_list_length (_tmp2_) + 1);
	moves = _tmp3_;
	moves_length1 = g_list_length (_tmp2_);
	_moves_size_ = moves_length1;
	i = 0;
	_tmp4_ = self->priv->pgn_game;
	_tmp5_ = _tmp4_->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp5_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp6_;
			gchar* move = NULL;
			_tmp6_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp6_;
			{
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp7_ = moves;
				_tmp7__length1 = moves_length1;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = move;
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (_tmp7_[_tmp8_]);
				_tmp7_[_tmp8_] = _tmp10_;
				_g_free0 (move);
			}
		}
	}
	_tmp11_ = self->priv->pgn_game;
	_tmp12_ = pgn_game_get_set_up (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		PGNGame* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = self->priv->pgn_game;
		_tmp15_ = pgn_game_get_fen (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ != NULL) {
			PGNGame* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp17_ = self->priv->pgn_game;
			_tmp18_ = pgn_game_get_fen (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (fen);
			fen = _tmp20_;
		} else {
			g_warning ("gnome-chess.vala:260: Chess game has SetUp tag but no FEN tag");
		}
	}
	_tmp21_ = self->priv->game;
	if (_tmp21_ != NULL) {
		ChessGame* _tmp22_;
		guint _tmp23_;
		ChessGame* _tmp24_;
		guint _tmp25_;
		ChessGame* _tmp26_;
		guint _tmp27_;
		ChessGame* _tmp28_;
		_tmp22_ = self->priv->game;
		g_signal_parse_name ("turn-started", TYPE_CHESS_GAME, &_tmp23_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self);
		_tmp24_ = self->priv->game;
		g_signal_parse_name ("moved", TYPE_CHESS_GAME, &_tmp25_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp24_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp25_, 0, NULL, (GCallback) _chess_application_game_move_cb_chess_game_moved, self);
		_tmp26_ = self->priv->game;
		g_signal_parse_name ("undo", TYPE_CHESS_GAME, &_tmp27_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp26_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp27_, 0, NULL, (GCallback) _chess_application_game_undo_cb_chess_game_undo, self);
		_tmp28_ = self->priv->game;
		g_signal_connect_object (_tmp28_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
	}
	{
		ChessGame* _tmp29_ = NULL;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gint _tmp31__length1;
		ChessGame* _tmp32_;
		ChessGame* _tmp33_;
		_tmp30_ = fen;
		_tmp31_ = moves;
		_tmp31__length1 = moves_length1;
		_tmp32_ = chess_game_new (_tmp30_, _tmp31_, _tmp31__length1, &_inner_error0_);
		_tmp29_ = _tmp32_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp33_ = _tmp29_;
		_tmp29_ = NULL;
		_g_object_unref0 (self->priv->game);
		self->priv->game = _tmp33_;
		_g_object_unref0 (_tmp29_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		chess_application_show_invalid_move_dialog (self, _tmp35_);
		chess_application_start_new_game (self);
		_g_error_free0 (e);
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (fen);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (fen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp37_ = self->priv->pgn_game;
	_tmp38_ = pgn_game_get_time_control (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ != NULL) {
		PGNGame* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		_tmp40_ = self->priv->pgn_game;
		_tmp41_ = pgn_game_get_time_control (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp36_ = atoi (_tmp42_) != 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gboolean _tmp43_ = FALSE;
		PGNGame* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		_tmp44_ = self->priv->pgn_game;
		_tmp45_ = pgn_game_get_white_time_left (_tmp44_);
		_tmp46_ = _tmp45_;
		if (_tmp46_ != NULL) {
			PGNGame* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			_tmp47_ = self->priv->pgn_game;
			_tmp48_ = pgn_game_get_black_time_left (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp43_ = _tmp49_ != NULL;
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			gint white_seconds = 0;
			PGNGame* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gint black_seconds = 0;
			PGNGame* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			gboolean _tmp56_ = FALSE;
			_tmp50_ = self->priv->pgn_game;
			_tmp51_ = pgn_game_get_white_time_left (_tmp50_);
			_tmp52_ = _tmp51_;
			white_seconds = atoi (_tmp52_);
			_tmp53_ = self->priv->pgn_game;
			_tmp54_ = pgn_game_get_black_time_left (_tmp53_);
			_tmp55_ = _tmp54_;
			black_seconds = atoi (_tmp55_);
			if (white_seconds >= 0) {
				_tmp56_ = black_seconds >= 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ChessGame* _tmp57_;
				ChessClock* _tmp58_;
				ChessClock* _tmp59_;
				_tmp57_ = self->priv->game;
				_tmp58_ = chess_clock_new (white_seconds, black_seconds);
				_tmp59_ = _tmp58_;
				chess_game_set_clock (_tmp57_, _tmp59_);
				_g_object_unref0 (_tmp59_);
			}
		}
	}
	_tmp60_ = self->priv->game;
	g_signal_connect_object (_tmp60_, "turn-started", (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self, 0);
	_tmp61_ = self->priv->game;
	g_signal_connect_object (_tmp61_, "moved", (GCallback) _chess_application_game_move_cb_chess_game_moved, self, 0);
	_tmp62_ = self->priv->game;
	g_signal_connect_object (_tmp62_, "undo", (GCallback) _chess_application_game_undo_cb_chess_game_undo, self, 0);
	_tmp63_ = self->priv->game;
	g_signal_connect_object (_tmp63_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
	_tmp64_ = chess_application_get_scene (self);
	_tmp65_ = _tmp64_;
	_tmp66_ = self->priv->game;
	chess_scene_set_game (_tmp65_, _tmp66_);
	_tmp67_ = self->priv->_window;
	chess_window_start_game (_tmp67_);
	_tmp68_ = self->priv->pgn_game;
	_tmp69_ = pgn_game_get_white_ai (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = g_strdup (_tmp70_);
	white_engine = _tmp71_;
	_tmp72_ = self->priv->pgn_game;
	_tmp73_ = pgn_game_get_white_level (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_strdup (_tmp74_);
	white_level = _tmp75_;
	_tmp76_ = white_level;
	if (_tmp76_ == NULL) {
		gchar* _tmp77_;
		_tmp77_ = g_strdup ("normal");
		_g_free0 (white_level);
		white_level = _tmp77_;
	}
	_tmp78_ = self->priv->pgn_game;
	_tmp79_ = pgn_game_get_black_ai (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = g_strdup (_tmp80_);
	black_engine = _tmp81_;
	_tmp82_ = self->priv->pgn_game;
	_tmp83_ = pgn_game_get_black_level (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = g_strdup (_tmp84_);
	black_level = _tmp85_;
	_tmp86_ = black_level;
	if (_tmp86_ == NULL) {
		gchar* _tmp87_;
		_tmp87_ = g_strdup ("normal");
		_g_free0 (black_level);
		black_level = _tmp87_;
	}
	_g_object_unref0 (self->priv->human_player);
	self->priv->human_player = NULL;
	_g_object_unref0 (self->priv->opponent);
	self->priv->opponent = NULL;
	_tmp88_ = self->priv->opponent_engine;
	if (_tmp88_ != NULL) {
		ChessEngine* _tmp89_;
		ChessEngine* _tmp90_;
		guint _tmp91_;
		ChessEngine* _tmp92_;
		guint _tmp93_;
		ChessEngine* _tmp94_;
		guint _tmp95_;
		ChessEngine* _tmp96_;
		guint _tmp97_;
		ChessEngine* _tmp98_;
		guint _tmp99_;
		ChessEngine* _tmp100_;
		guint _tmp101_;
		_tmp89_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp89_, TRUE);
		_tmp90_ = self->priv->opponent_engine;
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp91_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp90_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp91_, 0, NULL, (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self);
		_tmp92_ = self->priv->opponent_engine;
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp93_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp92_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp93_, 0, NULL, (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self);
		_tmp94_ = self->priv->opponent_engine;
		g_signal_parse_name ("stopped-unexpectedly", TYPE_CHESS_ENGINE, &_tmp95_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp94_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp95_, 0, NULL, (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self);
		_tmp96_ = self->priv->opponent_engine;
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp97_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp96_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp97_, 0, NULL, (GCallback) _chess_application_engine_error_cb_chess_engine_error, self);
		_tmp98_ = self->priv->opponent_engine;
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp99_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp98_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp99_, 0, NULL, (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self);
		_tmp100_ = self->priv->opponent_engine;
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp101_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp100_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp101_, 0, NULL, (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = NULL;
	}
	_tmp102_ = white_engine;
	if (_tmp102_ != NULL) {
		ChessGame* _tmp103_;
		ChessPlayer* _tmp104_;
		ChessPlayer* _tmp105_;
		ChessPlayer* _tmp106_;
		ChessGame* _tmp107_;
		ChessPlayer* _tmp108_;
		ChessPlayer* _tmp109_;
		ChessPlayer* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ChessEngine* _tmp113_;
		ChessPlayer* _tmp114_;
		ChessPlayer* _tmp115_;
		_tmp103_ = self->priv->game;
		_tmp104_ = chess_game_get_white (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = _g_object_ref0 (_tmp105_);
		_g_object_unref0 (self->priv->opponent);
		self->priv->opponent = _tmp106_;
		_tmp107_ = self->priv->game;
		_tmp108_ = chess_game_get_black (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = _g_object_ref0 (_tmp109_);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = _tmp110_;
		_tmp111_ = white_engine;
		_tmp112_ = white_level;
		_tmp113_ = chess_application_get_engine (self, _tmp111_, _tmp112_);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = _tmp113_;
		_tmp114_ = self->priv->opponent;
		chess_player_set_local_human (_tmp114_, FALSE);
		_tmp115_ = self->priv->human_player;
		chess_player_set_local_human (_tmp115_, TRUE);
	} else {
		const gchar* _tmp116_;
		_tmp116_ = black_engine;
		if (_tmp116_ != NULL) {
			ChessGame* _tmp117_;
			ChessPlayer* _tmp118_;
			ChessPlayer* _tmp119_;
			ChessPlayer* _tmp120_;
			ChessGame* _tmp121_;
			ChessPlayer* _tmp122_;
			ChessPlayer* _tmp123_;
			ChessPlayer* _tmp124_;
			const gchar* _tmp125_;
			const gchar* _tmp126_;
			ChessEngine* _tmp127_;
			ChessPlayer* _tmp128_;
			ChessPlayer* _tmp129_;
			_tmp117_ = self->priv->game;
			_tmp118_ = chess_game_get_black (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = _g_object_ref0 (_tmp119_);
			_g_object_unref0 (self->priv->opponent);
			self->priv->opponent = _tmp120_;
			_tmp121_ = self->priv->game;
			_tmp122_ = chess_game_get_white (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp124_ = _g_object_ref0 (_tmp123_);
			_g_object_unref0 (self->priv->human_player);
			self->priv->human_player = _tmp124_;
			_tmp125_ = black_engine;
			_tmp126_ = black_level;
			_tmp127_ = chess_application_get_engine (self, _tmp125_, _tmp126_);
			_g_object_unref0 (self->priv->opponent_engine);
			self->priv->opponent_engine = _tmp127_;
			_tmp128_ = self->priv->opponent;
			chess_player_set_local_human (_tmp128_, FALSE);
			_tmp129_ = self->priv->human_player;
			chess_player_set_local_human (_tmp129_, TRUE);
		}
	}
	_tmp130_ = self->priv->opponent_engine;
	if (_tmp130_ == NULL) {
		ChessGame* _tmp131_;
		ChessPlayer* _tmp132_;
		ChessPlayer* _tmp133_;
		ChessGame* _tmp134_;
		ChessPlayer* _tmp135_;
		ChessPlayer* _tmp136_;
		_tmp131_ = self->priv->game;
		_tmp132_ = chess_game_get_black (_tmp131_);
		_tmp133_ = _tmp132_;
		chess_player_set_local_human (_tmp133_, TRUE);
		_tmp134_ = self->priv->game;
		_tmp135_ = chess_game_get_white (_tmp134_);
		_tmp136_ = _tmp135_;
		chess_player_set_local_human (_tmp136_, TRUE);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = NULL;
	} else {
		ChessEngine* _tmp137_;
		ChessEngine* _tmp138_;
		ChessEngine* _tmp139_;
		ChessEngine* _tmp140_;
		ChessEngine* _tmp141_;
		ChessEngine* _tmp142_;
		ChessEngine* _tmp143_;
		_tmp137_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp137_, "moved", (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self, 0);
		_tmp138_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp138_, "resigned", (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self, 0);
		_tmp139_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp139_, "stopped-unexpectedly", (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self, 0);
		_tmp140_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp140_, "error", (GCallback) _chess_application_engine_error_cb_chess_engine_error, self, 0);
		_tmp141_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp141_, "claim-draw", (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
		_tmp142_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp142_, "offer-draw", (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
		_tmp143_ = self->priv->opponent_engine;
		if (!chess_engine_start (_tmp143_)) {
			ChessGame* _tmp144_;
			ChessGame* _tmp145_;
			chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
			_tmp144_ = self->priv->game;
			_tmp144_->result = CHESS_RESULT_BUG;
			_tmp145_ = self->priv->game;
			_tmp145_->rule = CHESS_RULE_BUG;
			chess_application_game_end_cb (self);
			_g_free0 (black_level);
			_g_free0 (black_engine);
			_g_free0 (white_level);
			_g_free0 (white_engine);
			moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (fen);
			return;
		}
	}
	{
		gint j = 0;
		ChessGame* _tmp146_;
		GList* _tmp147_;
		_tmp146_ = self->priv->game;
		_tmp147_ = _tmp146_->move_stack;
		j = ((gint) g_list_length (_tmp147_)) - 2;
		{
			gboolean _tmp148_ = FALSE;
			_tmp148_ = TRUE;
			while (TRUE) {
				ChessState* state = NULL;
				ChessGame* _tmp150_;
				GList* _tmp151_;
				gconstpointer _tmp152_;
				ChessState* _tmp153_;
				ChessGame* _tmp154_;
				ChessState* _tmp155_;
				ChessMove* _tmp156_;
				if (!_tmp148_) {
					gint _tmp149_;
					_tmp149_ = j;
					j = _tmp149_ - 1;
				}
				_tmp148_ = FALSE;
				if (!(j >= 0)) {
					break;
				}
				_tmp150_ = self->priv->game;
				_tmp151_ = _tmp150_->move_stack;
				_tmp152_ = g_list_nth_data (_tmp151_, (guint) j);
				_tmp153_ = _g_object_ref0 ((ChessState*) _tmp152_);
				state = _tmp153_;
				_tmp154_ = self->priv->game;
				_tmp155_ = state;
				_tmp156_ = _tmp155_->last_move;
				chess_application_game_move_cb (self, _tmp154_, _tmp156_);
				_g_object_unref0 (state);
			}
		}
	}
	_tmp158_ = self->priv->game_file;
	if (_tmp158_ != NULL) {
		GFile* _tmp159_;
		gchar* _tmp160_;
		gchar* _tmp161_;
		const gchar* _tmp162_;
		_tmp159_ = self->priv->game_file;
		_tmp160_ = g_file_get_path (_tmp159_);
		_tmp161_ = _tmp160_;
		_tmp162_ = self->priv->autosave_filename;
		_tmp157_ = g_strcmp0 (_tmp161_, _tmp162_) == 0;
		_g_free0 (_tmp161_);
	} else {
		_tmp157_ = FALSE;
	}
	if (_tmp157_) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_action (self, SAVE_GAME_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
	}
	_tmp163_ = self->priv->game;
	chess_game_start (_tmp163_);
	timer_increment_adj_value = 0;
	_tmp164_ = self->priv->pgn_game;
	_tmp165_ = pgn_game_get_timer_increment (_tmp164_);
	_tmp166_ = _tmp165_;
	if (_tmp166_ != NULL) {
		PGNGame* _tmp167_;
		const gchar* _tmp168_;
		const gchar* _tmp169_;
		_tmp167_ = self->priv->pgn_game;
		_tmp168_ = pgn_game_get_timer_increment (_tmp167_);
		_tmp169_ = _tmp168_;
		timer_increment_adj_value = atoi (_tmp169_);
	} else {
		GSettings* _tmp170_;
		PGNGame* _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
		_tmp170_ = self->priv->settings;
		timer_increment_adj_value = g_settings_get_int (_tmp170_, "timer-increment");
		_tmp171_ = self->priv->pgn_game;
		_tmp172_ = g_strdup_printf ("%i", timer_increment_adj_value);
		_tmp173_ = _tmp172_;
		pgn_game_set_timer_increment (_tmp171_, _tmp173_);
		_g_free0 (_tmp173_);
	}
	clock_type = CLOCK_TYPE_SIMPLE;
	_tmp174_ = self->priv->pgn_game;
	_tmp175_ = pgn_game_get_clock_type (_tmp174_);
	_tmp176_ = _tmp175_;
	if (_tmp176_ != NULL) {
		PGNGame* _tmp177_;
		const gchar* _tmp178_;
		const gchar* _tmp179_;
		_tmp177_ = self->priv->pgn_game;
		_tmp178_ = pgn_game_get_clock_type (_tmp177_);
		_tmp179_ = _tmp178_;
		clock_type = clock_type_string_to_enum (_tmp179_);
	} else {
		GSettings* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		PGNGame* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		_tmp180_ = self->priv->settings;
		_tmp181_ = g_settings_get_string (_tmp180_, "clock-type");
		_tmp182_ = _tmp181_;
		clock_type = clock_type_string_to_enum (_tmp182_);
		_g_free0 (_tmp182_);
		_tmp183_ = self->priv->pgn_game;
		_tmp184_ = clock_type_to_string (clock_type);
		_tmp185_ = _tmp184_;
		pgn_game_set_clock_type (_tmp183_, _tmp185_);
		_g_free0 (_tmp185_);
	}
	_tmp186_ = self->priv->_window;
	_tmp187_ = self->priv->game;
	_tmp188_ = chess_game_get_clock (_tmp187_);
	_tmp189_ = _tmp188_;
	chess_window_set_clock_visible (_tmp186_, _tmp189_ != NULL);
	_tmp190_ = self->priv->game;
	_tmp191_ = chess_game_get_clock (_tmp190_);
	_tmp192_ = _tmp191_;
	if (_tmp192_ != NULL) {
		ChessGame* _tmp193_;
		ChessClock* _tmp194_;
		ChessClock* _tmp195_;
		ChessGame* _tmp196_;
		ChessClock* _tmp197_;
		ChessClock* _tmp198_;
		_tmp193_ = self->priv->game;
		_tmp194_ = chess_game_get_clock (_tmp193_);
		_tmp195_ = _tmp194_;
		chess_clock_set_extra_seconds (_tmp195_, (gint) timer_increment_adj_value);
		_tmp196_ = self->priv->game;
		_tmp197_ = chess_game_get_clock (_tmp196_);
		_tmp198_ = _tmp197_;
		chess_clock_set_clock_type (_tmp198_, clock_type);
	}
	_tmp199_ = self->priv->pgn_game;
	_tmp200_ = pgn_game_get_result (_tmp199_);
	_tmp201_ = _tmp200_;
	_tmp202_ = pgn_game_RESULT_WHITE;
	if (g_strcmp0 (_tmp201_, _tmp202_) == 0) {
		ChessGame* _tmp203_;
		_tmp203_ = self->priv->game;
		_tmp203_->result = CHESS_RESULT_WHITE_WON;
	} else {
		PGNGame* _tmp204_;
		const gchar* _tmp205_;
		const gchar* _tmp206_;
		const gchar* _tmp207_;
		_tmp204_ = self->priv->pgn_game;
		_tmp205_ = pgn_game_get_result (_tmp204_);
		_tmp206_ = _tmp205_;
		_tmp207_ = pgn_game_RESULT_BLACK;
		if (g_strcmp0 (_tmp206_, _tmp207_) == 0) {
			ChessGame* _tmp208_;
			_tmp208_ = self->priv->game;
			_tmp208_->result = CHESS_RESULT_BLACK_WON;
		} else {
			PGNGame* _tmp209_;
			const gchar* _tmp210_;
			const gchar* _tmp211_;
			const gchar* _tmp212_;
			_tmp209_ = self->priv->pgn_game;
			_tmp210_ = pgn_game_get_result (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp212_ = pgn_game_RESULT_DRAW;
			if (g_strcmp0 (_tmp211_, _tmp212_) == 0) {
				ChessGame* _tmp213_;
				_tmp213_ = self->priv->game;
				_tmp213_->result = CHESS_RESULT_DRAW;
			}
		}
	}
	_tmp214_ = self->priv->opponent_engine;
	if (_tmp214_ != NULL) {
		ChessEngine* _tmp215_;
		_tmp215_ = self->priv->opponent_engine;
		chess_engine_start_game (_tmp215_);
	}
	_tmp217_ = moves;
	_tmp217__length1 = moves_length1;
	if (_tmp217__length1 > 0) {
		ChessGame* _tmp218_;
		ChessClock* _tmp219_;
		ChessClock* _tmp220_;
		_tmp218_ = self->priv->game;
		_tmp219_ = chess_game_get_clock (_tmp218_);
		_tmp220_ = _tmp219_;
		_tmp216_ = _tmp220_ != NULL;
	} else {
		_tmp216_ = FALSE;
	}
	if (_tmp216_) {
		ChessGame* _tmp221_;
		ChessClock* _tmp222_;
		ChessClock* _tmp223_;
		_tmp221_ = self->priv->game;
		_tmp222_ = chess_game_get_clock (_tmp221_);
		_tmp223_ = _tmp222_;
		chess_clock_start (_tmp223_);
		chess_application_enable_action (self, PAUSE_RESUME_ACTION_NAME);
	} else {
		chess_application_disable_action (self, PAUSE_RESUME_ACTION_NAME);
	}
	chess_application_update_action_status (self);
	_tmp224_ = self->priv->_window;
	chess_window_update_history_panel (_tmp224_);
	_tmp225_ = self->priv->_window;
	chess_window_update_pause_resume_button (_tmp225_);
	_tmp226_ = self->priv->ai_profiles;
	if (_tmp226_ == NULL) {
		ChessWindow* _tmp227_;
		_tmp227_ = self->priv->_window;
		chess_window_update_game_status (_tmp227_, NULL, _ ("No chess engine is installed. You will not be able to play against the" \
" computer."));
	} else {
		ChessWindow* _tmp228_;
		_tmp228_ = self->priv->_window;
		chess_window_update_game_status (_tmp228_, NULL, NULL);
	}
	self->priv->starting = FALSE;
	_tmp231_ = white_engine;
	if (_tmp231_ != NULL) {
		ChessGame* _tmp232_;
		ChessPlayer* _tmp233_;
		ChessPlayer* _tmp234_;
		_tmp232_ = self->priv->game;
		_tmp233_ = chess_game_get_current_player (_tmp232_);
		_tmp234_ = _tmp233_;
		_tmp230_ = _tmp234_->color == COLOR_WHITE;
	} else {
		_tmp230_ = FALSE;
	}
	if (_tmp230_) {
		_tmp229_ = TRUE;
	} else {
		gboolean _tmp235_ = FALSE;
		const gchar* _tmp236_;
		_tmp236_ = black_engine;
		if (_tmp236_ != NULL) {
			ChessGame* _tmp237_;
			ChessPlayer* _tmp238_;
			ChessPlayer* _tmp239_;
			_tmp237_ = self->priv->game;
			_tmp238_ = chess_game_get_current_player (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp235_ = _tmp239_->color == COLOR_BLACK;
		} else {
			_tmp235_ = FALSE;
		}
		_tmp229_ = _tmp235_;
	}
	if (_tmp229_) {
		ChessEngine* _tmp240_;
		ChessEngine* _tmp241_;
		_tmp240_ = self->priv->opponent_engine;
		_vala_assert (_tmp240_ != NULL, "opponent_engine != null");
		chess_application_update_engine_timeout (self);
		_tmp241_ = self->priv->opponent_engine;
		chess_engine_move (_tmp241_);
	}
	_tmp242_ = self->priv->game;
	if (_tmp242_->result != CHESS_RESULT_IN_PROGRESS) {
		ChessGame* _tmp243_;
		ChessGame* _tmp244_;
		_tmp243_ = self->priv->game;
		_tmp244_ = self->priv->game;
		chess_game_stop (_tmp243_, _tmp244_->result, CHESS_RULE_UNKNOWN);
	}
	_g_free0 (black_level);
	_g_free0 (black_engine);
	_g_free0 (white_level);
	_g_free0 (white_engine);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fen);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static ChessEngine*
chess_application_get_engine (ChessApplication* self,
                              const gchar* name,
                              const gchar* difficulty)
{
	ChessEngine* engine = NULL;
	AIProfile* profile = NULL;
	GList* _tmp0_;
	AIProfile* _tmp8_;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp13_;
	GQuark _tmp15_ = 0U;
	static GQuark _tmp14_label0 = 0;
	static GQuark _tmp14_label1 = 0;
	AIProfile* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	ChessEngine* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	profile = NULL;
	if (g_strcmp0 (name, "human") == 0) {
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (engine);
		return result;
	}
	if (g_strcmp0 (name, "GNUchess") == 0) {
		name = "GNU Chess";
	}
	_tmp0_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp0_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp1_;
			AIProfile* p = NULL;
			_tmp1_ = _g_object_ref0 ((AIProfile*) p_it->data);
			p = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				if (g_strcmp0 (name, "") == 0) {
					_tmp2_ = TRUE;
				} else {
					AIProfile* _tmp3_;
					const gchar* _tmp4_;
					const gchar* _tmp5_;
					_tmp3_ = p;
					_tmp4_ = ai_profile_get_name (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp2_ = g_strcmp0 (_tmp5_, name) == 0;
				}
				if (_tmp2_) {
					AIProfile* _tmp6_;
					AIProfile* _tmp7_;
					_tmp6_ = p;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_g_object_unref0 (profile);
					profile = _tmp7_;
					_g_object_unref0 (p);
					break;
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp8_ = profile;
	if (_tmp8_ == NULL) {
		GList* _tmp9_;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		AIProfile* _tmp12_;
		g_warning ("gnome-chess.vala:493: Unknown AI profile %s", name);
		_tmp9_ = self->priv->ai_profiles;
		if (_tmp9_ == NULL) {
			result = NULL;
			_g_object_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
		_tmp10_ = self->priv->ai_profiles;
		_tmp11_ = _tmp10_->data;
		_tmp12_ = _g_object_ref0 ((AIProfile*) _tmp11_);
		_g_object_unref0 (profile);
		profile = _tmp12_;
	}
	_tmp13_ = difficulty;
	_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
	if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_ = 0;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gchar** _tmp20_;
				gint _tmp20__length1;
				AIProfile* _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_ = 0;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gchar** _tmp25_;
				gint _tmp25__length1;
				AIProfile* _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				gint _tmp28_ = 0;
				gchar** _tmp29_;
				gint _tmp29__length1;
				gchar** _tmp30_;
				gint _tmp30__length1;
				_tmp16_ = profile;
				_tmp17_ = ai_profile_get_easy_options (_tmp16_, &_tmp18_);
				_tmp17__length1 = _tmp18_;
				_tmp19_ = _tmp17_;
				_tmp19__length1 = _tmp17__length1;
				_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup1 (_tmp19_, _tmp19__length1) : _tmp19_;
				_tmp20__length1 = _tmp19__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp20_;
				options_length1 = _tmp20__length1;
				_options_size_ = options_length1;
				_tmp21_ = profile;
				_tmp22_ = ai_profile_get_easy_uci_go_options (_tmp21_, &_tmp23_);
				_tmp22__length1 = _tmp23_;
				_tmp24_ = _tmp22_;
				_tmp24__length1 = _tmp22__length1;
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup2 (_tmp24_, _tmp24__length1) : _tmp24_;
				_tmp25__length1 = _tmp24__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp25_;
				uci_go_options_length1 = _tmp25__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp26_ = profile;
				_tmp27_ = ai_profile_get_easy_args (_tmp26_, &_tmp28_);
				_tmp27__length1 = _tmp28_;
				_tmp29_ = _tmp27_;
				_tmp29__length1 = _tmp27__length1;
				_tmp30_ = (_tmp29_ != NULL) ? _vala_array_dup3 (_tmp29_, _tmp29__length1) : _tmp29_;
				_tmp30__length1 = _tmp29__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp30_;
				args_length1 = _tmp30__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp31_;
				gchar** _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_ = 0;
				gchar** _tmp34_;
				gint _tmp34__length1;
				gchar** _tmp35_;
				gint _tmp35__length1;
				AIProfile* _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_ = 0;
				gchar** _tmp39_;
				gint _tmp39__length1;
				gchar** _tmp40_;
				gint _tmp40__length1;
				AIProfile* _tmp41_;
				gchar** _tmp42_;
				gint _tmp42__length1;
				gint _tmp43_ = 0;
				gchar** _tmp44_;
				gint _tmp44__length1;
				gchar** _tmp45_;
				gint _tmp45__length1;
				_tmp31_ = profile;
				_tmp32_ = ai_profile_get_hard_options (_tmp31_, &_tmp33_);
				_tmp32__length1 = _tmp33_;
				_tmp34_ = _tmp32_;
				_tmp34__length1 = _tmp32__length1;
				_tmp35_ = (_tmp34_ != NULL) ? _vala_array_dup4 (_tmp34_, _tmp34__length1) : _tmp34_;
				_tmp35__length1 = _tmp34__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp35_;
				options_length1 = _tmp35__length1;
				_options_size_ = options_length1;
				_tmp36_ = profile;
				_tmp37_ = ai_profile_get_hard_uci_go_options (_tmp36_, &_tmp38_);
				_tmp37__length1 = _tmp38_;
				_tmp39_ = _tmp37_;
				_tmp39__length1 = _tmp37__length1;
				_tmp40_ = (_tmp39_ != NULL) ? _vala_array_dup5 (_tmp39_, _tmp39__length1) : _tmp39_;
				_tmp40__length1 = _tmp39__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp40_;
				uci_go_options_length1 = _tmp40__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp41_ = profile;
				_tmp42_ = ai_profile_get_hard_args (_tmp41_, &_tmp43_);
				_tmp42__length1 = _tmp43_;
				_tmp44_ = _tmp42_;
				_tmp44__length1 = _tmp42__length1;
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup6 (_tmp44_, _tmp44__length1) : _tmp44_;
				_tmp45__length1 = _tmp44__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp45_;
				args_length1 = _tmp45__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				AIProfile* _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				gint _tmp48_ = 0;
				gchar** _tmp49_;
				gint _tmp49__length1;
				gchar** _tmp50_;
				gint _tmp50__length1;
				AIProfile* _tmp51_;
				gchar** _tmp52_;
				gint _tmp52__length1;
				gint _tmp53_ = 0;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gchar** _tmp55_;
				gint _tmp55__length1;
				AIProfile* _tmp56_;
				gchar** _tmp57_;
				gint _tmp57__length1;
				gint _tmp58_ = 0;
				gchar** _tmp59_;
				gint _tmp59__length1;
				gchar** _tmp60_;
				gint _tmp60__length1;
				_tmp46_ = profile;
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp48_);
				_tmp47__length1 = _tmp48_;
				_tmp49_ = _tmp47_;
				_tmp49__length1 = _tmp47__length1;
				_tmp50_ = (_tmp49_ != NULL) ? _vala_array_dup7 (_tmp49_, _tmp49__length1) : _tmp49_;
				_tmp50__length1 = _tmp49__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp50_;
				options_length1 = _tmp50__length1;
				_options_size_ = options_length1;
				_tmp51_ = profile;
				_tmp52_ = ai_profile_get_normal_uci_go_options (_tmp51_, &_tmp53_);
				_tmp52__length1 = _tmp53_;
				_tmp54_ = _tmp52_;
				_tmp54__length1 = _tmp52__length1;
				_tmp55_ = (_tmp54_ != NULL) ? _vala_array_dup8 (_tmp54_, _tmp54__length1) : _tmp54_;
				_tmp55__length1 = _tmp54__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp55_;
				uci_go_options_length1 = _tmp55__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp56_ = profile;
				_tmp57_ = ai_profile_get_normal_args (_tmp56_, &_tmp58_);
				_tmp57__length1 = _tmp58_;
				_tmp59_ = _tmp57_;
				_tmp59__length1 = _tmp57__length1;
				_tmp60_ = (_tmp59_ != NULL) ? _vala_array_dup9 (_tmp59_, _tmp59__length1) : _tmp59_;
				_tmp60__length1 = _tmp59__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp60_;
				args_length1 = _tmp60__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	}
	_tmp61_ = profile;
	_tmp62_ = ai_profile_get_protocol (_tmp61_);
	_tmp63_ = _tmp62_;
	if (g_strcmp0 (_tmp63_, "cecp") == 0) {
		gchar** _tmp64_;
		gint _tmp64__length1;
		AIProfile* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gchar** _tmp68_;
		gint _tmp68__length1;
		AIProfile* _tmp69_;
		guint _tmp70_;
		guint _tmp71_;
		gchar** _tmp72_;
		gint _tmp72__length1;
		ChessEngineCECP* _tmp73_;
		_tmp64_ = uci_go_options;
		_tmp64__length1 = uci_go_options_length1;
		g_warn_if_fail (_tmp64__length1 == 0);
		_tmp65_ = profile;
		_tmp66_ = ai_profile_get_binary (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = args;
		_tmp68__length1 = args_length1;
		_tmp69_ = profile;
		_tmp70_ = ai_profile_get_delay_seconds (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = options;
		_tmp72__length1 = options_length1;
		_tmp73_ = chess_engine_cecp_new (_tmp67_, _tmp68_, _tmp68__length1, _tmp71_, _tmp72_, _tmp72__length1);
		_g_object_unref0 (engine);
		engine = (ChessEngine*) _tmp73_;
	} else {
		AIProfile* _tmp74_;
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		_tmp74_ = profile;
		_tmp75_ = ai_profile_get_protocol (_tmp74_);
		_tmp76_ = _tmp75_;
		if (g_strcmp0 (_tmp76_, "uci") == 0) {
			AIProfile* _tmp77_;
			const gchar* _tmp78_;
			const gchar* _tmp79_;
			gchar** _tmp80_;
			gint _tmp80__length1;
			AIProfile* _tmp81_;
			guint _tmp82_;
			guint _tmp83_;
			gchar** _tmp84_;
			gint _tmp84__length1;
			gchar** _tmp85_;
			gint _tmp85__length1;
			ChessEngineUCI* _tmp86_;
			_tmp77_ = profile;
			_tmp78_ = ai_profile_get_binary (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = args;
			_tmp80__length1 = args_length1;
			_tmp81_ = profile;
			_tmp82_ = ai_profile_get_delay_seconds (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = options;
			_tmp84__length1 = options_length1;
			_tmp85_ = uci_go_options;
			_tmp85__length1 = uci_go_options_length1;
			_tmp86_ = chess_engine_uci_new (_tmp79_, _tmp80_, _tmp80__length1, _tmp83_, _tmp84_, _tmp84__length1, _tmp85_, _tmp85__length1);
			_g_object_unref0 (engine);
			engine = (ChessEngine*) _tmp86_;
		} else {
			AIProfile* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			_tmp87_ = profile;
			_tmp88_ = ai_profile_get_protocol (_tmp87_);
			_tmp89_ = _tmp88_;
			g_warning ("gnome-chess.vala:531: Unknown AI protocol %s", _tmp89_);
			result = NULL;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
	}
	result = engine;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (profile);
	return result;
}

static void
chess_application_do_engine_move (ChessApplication* self,
                                  const gchar* move)
{
	ChessPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->opponent;
	if (!chess_player_move (_tmp0_, move, TRUE)) {
		ChessGame* _tmp1_;
		g_warning ("gnome-chess.vala:542: Engine's move %s is illegal! Engine desync?", move);
		_tmp1_ = self->priv->game;
		chess_game_stop (_tmp1_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ChessApplication* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->original_state);
		_g_object_unref0 (_data4_->original_game);
		_g_free0 (_data4_->move);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
___lambda15_ (Block4Data* _data4_)
{
	ChessApplication* self;
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = _data4_->self;
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		ChessGame* _tmp3_;
		ChessGame* _tmp4_;
		_tmp3_ = self->priv->game;
		_tmp4_ = _data4_->original_game;
		if (_tmp3_ == _tmp4_) {
			ChessGame* _tmp5_;
			ChessState* _tmp6_;
			ChessState* _tmp7_;
			ChessState* _tmp8_;
			_tmp5_ = self->priv->game;
			_tmp6_ = chess_game_get_current_state (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _data4_->original_state;
			_vala_assert (_tmp7_ == _tmp8_, "game.current_state == original_state");
			chess_application_do_engine_move (self, _data4_->move);
		}
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
____lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda15_ (self);
	return result;
}

static void
chess_application_engine_move_cb (ChessApplication* self,
                                  ChessEngine* engine,
                                  const gchar* move)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	ChessGame* _tmp1_;
	ChessGame* _tmp2_;
	ChessGame* _tmp3_;
	ChessState* _tmp4_;
	ChessState* _tmp5_;
	ChessState* _tmp6_;
	ChessGame* _tmp7_;
	ChessGame* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_return_if_fail (move != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup (move);
	_g_free0 (_data4_->move);
	_data4_->move = _tmp0_;
	_tmp1_ = self->priv->game;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data4_->original_game = _tmp2_;
	_tmp3_ = self->priv->game;
	_tmp4_ = chess_game_get_current_state (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data4_->original_state = _tmp6_;
	_tmp7_ = self->priv->game;
	if (!_tmp7_->is_started) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = chess_game_get_is_paused (_tmp8_);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		chess_application_do_engine_move (self, _data4_->move);
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda15__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
chess_application_engine_resigned_cb (ChessApplication* self,
                                      ChessEngine* engine)
{
	ChessPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_resign (_tmp0_);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ChessApplication* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->original_game);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda16_ (Block5Data* _data5_)
{
	ChessApplication* self;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	gboolean result;
	self = _data5_->self;
	_tmp1_ = self->priv->game;
	if (_tmp1_ == _data5_->original_game) {
		ChessGame* _tmp2_;
		_tmp2_ = self->priv->game;
		_tmp0_ = _tmp2_->is_started;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp3_;
		_tmp3_ = self->priv->game;
		chess_game_stop (_tmp3_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ (self);
	return result;
}

static void
chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self,
                                                  ChessEngine* engine)
{
	Block5Data* _data5_;
	ChessGame* _tmp0_;
	ChessGame* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data5_->original_game = _tmp1_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda16__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
chess_application_engine_error_cb (ChessApplication* self,
                                   ChessEngine* engine)
{
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
}

static void
chess_application_engine_claim_draw_cb (ChessApplication* self,
                                        ChessEngine* engine)
{
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	if (chess_game_can_claim_draw (_tmp0_)) {
		ChessPlayer* _tmp1_;
		_tmp1_ = self->priv->opponent;
		chess_player_claim_draw (_tmp1_);
	} else {
		ChessGame* _tmp2_;
		ChessState* _tmp3_;
		ChessState* _tmp4_;
		ChessGame* _tmp5_;
		ChessState* _tmp6_;
		ChessState* _tmp7_;
		ChessPlayer* _tmp8_;
		_tmp2_ = self->priv->game;
		_tmp3_ = chess_game_get_current_state (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->game;
		_tmp6_ = chess_game_get_current_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->current_player;
		if (!chess_state_can_move (_tmp4_, _tmp8_)) {
			ChessGame* _tmp9_;
			_tmp9_ = self->priv->game;
			chess_game_stop (_tmp9_, CHESS_RESULT_DRAW, CHESS_RULE_STALEMATE);
		} else {
			ChessGame* _tmp10_;
			_tmp10_ = self->priv->game;
			chess_game_stop (_tmp10_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
		}
	}
}

static void
chess_application_engine_offer_draw_cb (ChessApplication* self,
                                        ChessEngine* engine)
{
	ChessGame* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	if (chess_game_can_claim_draw (_tmp0_)) {
		ChessPlayer* _tmp1_;
		_tmp1_ = self->priv->opponent;
		chess_player_claim_draw (_tmp1_);
	}
}

static void
chess_application_game_turn_cb (ChessApplication* self,
                                ChessGame* game,
                                ChessPlayer* player)
{
	ChessClock* _tmp0_;
	ChessClock* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (player != NULL);
	if (!game->is_started) {
		return;
	}
	_tmp0_ = chess_game_get_clock (game);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		chess_application_enable_action (self, PAUSE_RESUME_ACTION_NAME);
	}
}

static gboolean
___lambda12_ (ChessApplication* self)
{
	ChessEngine* _tmp0_;
	gboolean result;
	self->priv->engine_timeout_source = (guint) 0;
	g_warning ("gnome-chess.vala:681: Engine did not move for 30 seconds! Game over.");
	_tmp0_ = self->priv->opponent_engine;
	chess_application_engine_error_cb (self, _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda12_ ((ChessApplication*) self);
	return result;
}

static void
chess_application_update_engine_timeout (ChessApplication* self)
{
	ChessGame* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PGNGame* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->priv->engine_timeout_source != ((guint) 0)) {
		g_source_remove (self->priv->engine_timeout_source);
		self->priv->engine_timeout_source = (guint) 0;
	}
	_tmp0_ = self->priv->game;
	if (!_tmp0_->is_started) {
		return;
	}
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = pgn_game_get_white_ai (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ChessGame* _tmp6_;
		ChessPlayer* _tmp7_;
		ChessPlayer* _tmp8_;
		_tmp6_ = self->priv->game;
		_tmp7_ = chess_game_get_current_player (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_->color == COLOR_WHITE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		PGNGame* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = self->priv->pgn_game;
		_tmp11_ = pgn_game_get_black_ai (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ChessGame* _tmp13_;
			ChessPlayer* _tmp14_;
			ChessPlayer* _tmp15_;
			_tmp13_ = self->priv->game;
			_tmp14_ = chess_game_get_current_player (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_->color == COLOR_BLACK;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp1_ = _tmp9_;
	}
	if (_tmp1_) {
		self->priv->engine_timeout_source = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ____lambda12__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ChessApplication* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->game);
		_g_object_unref0 (_data6_->move);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
__lambda10_ (Block6Data* _data6_)
{
	ChessApplication* self;
	gboolean _tmp0_ = FALSE;
	ChessEngine* _tmp1_;
	gboolean result;
	self = _data6_->self;
	if (chess_game_can_claim_draw (_data6_->game)) {
		_tmp0_ = _data6_->started;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		chess_application_present_claim_draw_dialog (self);
	}
	_tmp1_ = self->priv->opponent_engine;
	if (_tmp1_ != NULL) {
		ChessEngine* _tmp2_;
		gboolean _tmp3_ = FALSE;
		ChessPiece* _tmp4_;
		Color _tmp5_;
		Color _tmp6_;
		ChessPlayer* _tmp7_;
		_tmp2_ = self->priv->opponent_engine;
		chess_engine_report_move (_tmp2_, _data6_->move);
		_tmp4_ = _data6_->move->piece;
		_tmp5_ = chess_piece_get_color (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->opponent;
		if (_tmp6_ != _tmp7_->color) {
			_tmp3_ = _data6_->started;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			ChessEngine* _tmp8_;
			_tmp8_ = self->priv->opponent_engine;
			chess_engine_move (_tmp8_);
		}
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ (self);
	return result;
}

static void
chess_application_game_move_cb (ChessApplication* self,
                                ChessGame* game,
                                ChessMove* move)
{
	Block6Data* _data6_;
	ChessGame* _tmp0_;
	ChessMove* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	PGNGame* _tmp6_;
	GList* _tmp7_;
	ChessWindow* _tmp10_;
	ChessWindow* _tmp11_;
	ChessWindow* _tmp12_;
	ChessView* _tmp13_;
	ChessView* _tmp14_;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data6_->game);
	_data6_->game = _tmp0_;
	_tmp1_ = _g_object_ref0 (move);
	_g_object_unref0 (_data6_->move);
	_data6_->move = _tmp1_;
	chess_application_enable_action (self, NEW_GAME_ACTION_NAME);
	self->priv->game_needs_saving = TRUE;
	if (_data6_->move->number == 1) {
		ChessPlayer* _tmp4_;
		_tmp4_ = self->priv->opponent;
		_tmp3_ = _tmp4_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ChessPlayer* _tmp5_;
		_tmp5_ = self->priv->opponent;
		_tmp2_ = _tmp5_->color == COLOR_WHITE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		self->priv->game_needs_saving = FALSE;
	}
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = _tmp6_->moves;
	if (((guint) _data6_->move->number) > g_list_length (_tmp7_)) {
		PGNGame* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->pgn_game;
		_tmp9_ = chess_move_get_san (_data6_->move);
		_tmp8_->moves = g_list_append (_tmp8_->moves, _tmp9_);
	}
	_tmp10_ = self->priv->_window;
	chess_window_move (_tmp10_, _data6_->move);
	chess_application_enable_action (self, SAVE_GAME_ACTION_NAME);
	chess_application_enable_action (self, SAVE_GAME_AS_ACTION_NAME);
	chess_application_update_action_status (self);
	_tmp11_ = self->priv->_window;
	chess_window_update_history_panel (_tmp11_);
	_tmp12_ = self->priv->_window;
	chess_window_update_game_status (_tmp12_, NULL, NULL);
	_tmp13_ = chess_application_get_view (self);
	_tmp14_ = _tmp13_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp14_);
	if (!self->priv->starting) {
		_tmp15_ = _data6_->game->is_started;
	} else {
		_tmp15_ = FALSE;
	}
	_data6_->started = _tmp15_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda10__gsource_func, block6_data_ref (_data6_), block6_data_unref);
	if (_data6_->started) {
		chess_application_update_engine_timeout (self);
	}
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
chess_application_game_undo_cb (ChessApplication* self,
                                ChessGame* game)
{
	ChessEngine* _tmp0_;
	PGNGame* _tmp2_;
	PGNGame* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	PGNGame* _tmp6_;
	const gchar* _tmp7_;
	ChessWindow* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	ChessWindow* _tmp11_;
	ChessWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_undo (_tmp1_);
	}
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = _tmp3_->moves;
	_tmp5_ = g_list_last (_tmp4_);
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = pgn_game_RESULT_IN_PROGRESS;
	pgn_game_set_result (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->_window;
	chess_window_undo (_tmp8_);
	_tmp9_ = chess_game_get_n_moves (game);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > ((guint) 0)) {
		self->priv->game_needs_saving = TRUE;
		chess_application_enable_action (self, SAVE_GAME_ACTION_NAME);
		chess_application_enable_action (self, SAVE_GAME_AS_ACTION_NAME);
	} else {
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_action (self, NEW_GAME_ACTION_NAME);
		chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
		chess_application_disable_action (self, SAVE_GAME_AS_ACTION_NAME);
	}
	chess_application_update_action_status (self);
	_tmp11_ = self->priv->_window;
	chess_window_update_history_panel (_tmp11_);
	_tmp12_ = self->priv->_window;
	chess_window_update_game_status (_tmp12_, NULL, NULL);
}

static void
chess_application_update_action_status (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean can_resign = FALSE;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	gboolean can_undo = FALSE;
	gboolean _tmp14_ = FALSE;
	ChessPlayer* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = chess_game_get_n_moves (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > ((guint) 0)) {
		ChessGame* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_is_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	can_resign = _tmp0_;
	if (can_resign) {
		chess_application_enable_action (self, RESIGN_ACTION_NAME);
	} else {
		chess_application_disable_action (self, RESIGN_ACTION_NAME);
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = chess_game_get_n_moves (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > ((guint) 0)) {
		ChessGame* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->game;
		_tmp12_ = chess_game_get_is_paused (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp7_ = !_tmp13_;
	} else {
		_tmp7_ = FALSE;
	}
	can_undo = _tmp7_;
	_tmp15_ = self->priv->opponent;
	if (_tmp15_ != NULL) {
		ChessPlayer* _tmp16_;
		_tmp16_ = self->priv->opponent;
		_tmp14_ = _tmp16_->color == COLOR_WHITE;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gboolean _tmp17_ = FALSE;
		ChessGame* _tmp18_;
		guint _tmp19_;
		guint _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_n_moves (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ > ((guint) 1)) {
			ChessGame* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = self->priv->game;
			_tmp22_ = chess_game_get_is_paused (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp17_ = !_tmp23_;
		} else {
			_tmp17_ = FALSE;
		}
		can_undo = _tmp17_;
	}
	if (can_undo) {
		chess_application_enable_action (self, UNDO_MOVE_ACTION_NAME);
	} else {
		chess_application_disable_action (self, UNDO_MOVE_ACTION_NAME);
	}
}

gchar*
chess_application_compute_current_title (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessPlayer* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = self->priv->human_player;
	if (_tmp2_ != NULL) {
		ChessPlayer* _tmp3_;
		ChessGame* _tmp4_;
		ChessPlayer* _tmp5_;
		ChessPlayer* _tmp6_;
		_tmp3_ = self->priv->human_player;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_current_player (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp3_->color == _tmp6_->color;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ChessGame* _tmp7_;
		ChessState* _tmp8_;
		ChessState* _tmp9_;
		ChessGame* _tmp10_;
		ChessPlayer* _tmp11_;
		ChessPlayer* _tmp12_;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_current_state (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_current_player (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = chess_state_is_in_check (_tmp9_, _tmp12_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp13_;
		ChessPlayer* _tmp14_;
		ChessPlayer* _tmp15_;
		_tmp13_ = self->priv->game;
		_tmp14_ = chess_game_get_current_player (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_->color == COLOR_WHITE) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup (_ ("White is in Check"));
			result = _tmp16_;
			return result;
		} else {
			gchar* _tmp17_;
			_tmp17_ = g_strdup (_ ("Black is in Check"));
			result = _tmp17_;
			return result;
		}
	} else {
		ChessGame* _tmp18_;
		ChessPlayer* _tmp19_;
		ChessPlayer* _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_current_player (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_->color == COLOR_WHITE) {
			gboolean _tmp21_ = FALSE;
			ChessPlayer* _tmp22_;
			_tmp22_ = self->priv->human_player;
			if (_tmp22_ == NULL) {
				_tmp21_ = TRUE;
			} else {
				ChessPlayer* _tmp23_;
				_tmp23_ = self->priv->human_player;
				_tmp21_ = _tmp23_->color == COLOR_WHITE;
			}
			if (_tmp21_) {
				gchar* _tmp24_;
				_tmp24_ = g_strdup (_ ("White to Move"));
				result = _tmp24_;
				return result;
			} else {
				gchar* _tmp25_;
				_tmp25_ = g_strdup (_ ("White is Thinking…"));
				result = _tmp25_;
				return result;
			}
		} else {
			gboolean _tmp26_ = FALSE;
			ChessPlayer* _tmp27_;
			_tmp27_ = self->priv->human_player;
			if (_tmp27_ == NULL) {
				_tmp26_ = TRUE;
			} else {
				ChessPlayer* _tmp28_;
				_tmp28_ = self->priv->human_player;
				_tmp26_ = _tmp28_->color == COLOR_BLACK;
			}
			if (_tmp26_) {
				gchar* _tmp29_;
				_tmp29_ = g_strdup (_ ("Black to Move"));
				result = _tmp29_;
				return result;
			} else {
				gchar* _tmp30_;
				_tmp30_ = g_strdup (_ ("Black is Thinking…"));
				result = _tmp30_;
				return result;
			}
		}
	}
}

gchar*
chess_application_compute_status_info (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	ChessState* _tmp2_;
	ChessState* _tmp3_;
	ChessMove* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = chess_game_get_current_state (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->last_move;
	if (_tmp4_ != NULL) {
		ChessGame* _tmp5_;
		ChessState* _tmp6_;
		ChessState* _tmp7_;
		ChessMove* _tmp8_;
		_tmp5_ = self->priv->game;
		_tmp6_ = chess_game_get_current_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->last_move;
		_tmp0_ = _tmp8_->en_passant;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessGame* _tmp9_;
		ChessPlayer* _tmp10_;
		ChessPlayer* _tmp11_;
		_tmp9_ = self->priv->game;
		_tmp10_ = chess_game_get_current_player (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_->color == COLOR_WHITE) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup (_ ("Black captured White's pawn <span font_style='italic'>en passant</span" \
">."));
			result = _tmp12_;
			return result;
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strdup (_ ("White captured Black's pawn <span font_style='italic'>en passant</span" \
">."));
			result = _tmp13_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static void
chess_application_game_end_cb (ChessApplication* self)
{
	gchar* what = NULL;
	gchar* _tmp0_;
	ChessGame* _tmp1_;
	gchar* why = NULL;
	gchar* _tmp12_;
	ChessGame* _tmp13_;
	ChessWindow* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	ChessWindow* _tmp44_;
	g_return_if_fail (self != NULL);
	chess_application_disable_action (self, RESIGN_ACTION_NAME);
	chess_application_disable_action (self, PAUSE_RESUME_ACTION_NAME);
	chess_application_enable_action (self, NEW_GAME_ACTION_NAME);
	self->priv->game_needs_saving = FALSE;
	_tmp0_ = g_strdup ("");
	what = _tmp0_;
	_tmp1_ = self->priv->game;
	switch (_tmp1_->result) {
		case CHESS_RESULT_WHITE_WON:
		{
			gchar* _tmp2_;
			PGNGame* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = g_strdup (_ ("White Wins"));
			_g_free0 (what);
			what = _tmp2_;
			_tmp3_ = self->priv->pgn_game;
			_tmp4_ = pgn_game_RESULT_WHITE;
			pgn_game_set_result (_tmp3_, _tmp4_);
			break;
		}
		case CHESS_RESULT_BLACK_WON:
		{
			gchar* _tmp5_;
			PGNGame* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = g_strdup (_ ("Black Wins"));
			_g_free0 (what);
			what = _tmp5_;
			_tmp6_ = self->priv->pgn_game;
			_tmp7_ = pgn_game_RESULT_BLACK;
			pgn_game_set_result (_tmp6_, _tmp7_);
			break;
		}
		case CHESS_RESULT_DRAW:
		{
			gchar* _tmp8_;
			PGNGame* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = g_strdup (_ ("Game is Drawn"));
			_g_free0 (what);
			what = _tmp8_;
			_tmp9_ = self->priv->pgn_game;
			_tmp10_ = pgn_game_RESULT_DRAW;
			pgn_game_set_result (_tmp9_, _tmp10_);
			break;
		}
		case CHESS_RESULT_BUG:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Oops!"));
			_g_free0 (what);
			what = _tmp11_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp12_ = g_strdup ("");
	why = _tmp12_;
	_tmp13_ = self->priv->game;
	switch (_tmp13_->rule) {
		case CHESS_RULE_CHECKMATE:
		{
			ChessGame* _tmp14_;
			_tmp14_ = self->priv->game;
			if (_tmp14_->result == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp15_;
				_tmp15_ = g_strdup (_ ("Black is in check and cannot move."));
				_g_free0 (why);
				why = _tmp15_;
			} else {
				ChessGame* _tmp16_;
				_tmp16_ = self->priv->game;
				if (_tmp16_->result == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp17_;
					_tmp17_ = g_strdup (_ ("White is in check and cannot move."));
					_g_free0 (why);
					why = _tmp17_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_STALEMATE:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup (_ ("Player cannot move."));
			_g_free0 (why);
			why = _tmp18_;
			break;
		}
		case CHESS_RULE_FIFTY_MOVES:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup (_ ("No piece was taken or pawn moved in fifty moves."));
			_g_free0 (why);
			why = _tmp19_;
			break;
		}
		case CHESS_RULE_SEVENTY_FIVE_MOVES:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup (_ ("No piece was taken or pawn moved in 75 moves."));
			_g_free0 (why);
			why = _tmp20_;
			break;
		}
		case CHESS_RULE_TIMEOUT:
		{
			ChessGame* _tmp21_;
			_tmp21_ = self->priv->game;
			if (_tmp21_->result == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp22_;
				_tmp22_ = g_strdup (_ ("Black has run out of time."));
				_g_free0 (why);
				why = _tmp22_;
			} else {
				ChessGame* _tmp23_;
				_tmp23_ = self->priv->game;
				if (_tmp23_->result == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp24_;
					_tmp24_ = g_strdup (_ ("White has run out of time."));
					_g_free0 (why);
					why = _tmp24_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_THREE_FOLD_REPETITION:
		{
			gchar* _tmp25_;
			_tmp25_ = g_strdup (_ ("The same board state has occurred three times."));
			_g_free0 (why);
			why = _tmp25_;
			break;
		}
		case CHESS_RULE_FIVE_FOLD_REPETITION:
		{
			gchar* _tmp26_;
			_tmp26_ = g_strdup (_ ("The same board state has occurred five times."));
			_g_free0 (why);
			why = _tmp26_;
			break;
		}
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
		{
			gchar* _tmp27_;
			_tmp27_ = g_strdup (_ ("Neither player can checkmate."));
			_g_free0 (why);
			why = _tmp27_;
			break;
		}
		case CHESS_RULE_RESIGN:
		{
			ChessGame* _tmp28_;
			_tmp28_ = self->priv->game;
			if (_tmp28_->result == CHESS_RESULT_WHITE_WON) {
				gchar* _tmp29_;
				_tmp29_ = g_strdup (_ ("Black has resigned."));
				_g_free0 (why);
				why = _tmp29_;
			} else {
				ChessGame* _tmp30_;
				_tmp30_ = self->priv->game;
				if (_tmp30_->result == CHESS_RESULT_BLACK_WON) {
					gchar* _tmp31_;
					_tmp31_ = g_strdup (_ ("White has resigned."));
					_g_free0 (why);
					why = _tmp31_;
				} else {
					g_assert_not_reached ();
				}
			}
			break;
		}
		case CHESS_RULE_ABANDONMENT:
		{
			gchar* _tmp32_;
			PGNGame* _tmp33_;
			const gchar* _tmp34_;
			_tmp32_ = g_strdup (_ ("The game has been abandoned."));
			_g_free0 (why);
			why = _tmp32_;
			_tmp33_ = self->priv->pgn_game;
			_tmp34_ = pgn_game_TERMINATE_ABANDONED;
			pgn_game_set_termination (_tmp33_, _tmp34_);
			break;
		}
		case CHESS_RULE_DEATH:
		{
			gchar* _tmp35_;
			PGNGame* _tmp36_;
			const gchar* _tmp37_;
			_tmp35_ = g_strdup (_ ("The game log says a player died!"));
			_g_free0 (why);
			why = _tmp35_;
			_tmp36_ = self->priv->pgn_game;
			_tmp37_ = pgn_game_TERMINATE_DEATH;
			pgn_game_set_termination (_tmp36_, _tmp37_);
			break;
		}
		case CHESS_RULE_BUG:
		{
			gchar* _tmp38_;
			_tmp38_ = g_strdup (_ ("The computer player is confused. The game cannot continue."));
			_g_free0 (why);
			why = _tmp38_;
			break;
		}
		case CHESS_RULE_UNKNOWN:
		{
			GFile* _tmp39_;
			gchar* _tmp40_;
			_tmp39_ = self->priv->game_file;
			_tmp40_ = g_file_get_basename (_tmp39_);
			_g_free0 (why);
			why = _tmp40_;
			break;
		}
		default:
		break;
	}
	_tmp41_ = self->priv->_window;
	_tmp42_ = what;
	_tmp43_ = why;
	chess_window_update_game_status (_tmp41_, _tmp42_, _tmp43_);
	_tmp44_ = self->priv->_window;
	chess_window_end_game (_tmp44_);
	chess_application_update_engine_timeout (self);
	_g_free0 (why);
	_g_free0 (what);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ChessApplication* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->prompt_save_game_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
____lambda8_ (Block7Data* _data7_,
              gboolean saved)
{
	ChessApplication* self;
	self = _data7_->self;
	_data7_->callback (!saved, _data7_->callback_target);
}

static void
_____lambda8__chess_application_present_save_dialog_callback (gboolean saved,
                                                              gpointer self)
{
	____lambda8_ (self, saved);
}

static void
__lambda5_ (Block7Data* _data7_,
            gint response_id)
{
	ChessApplication* self;
	gboolean _tmp0_ = FALSE;
	GtkMessageDialog* _tmp1_;
	self = _data7_->self;
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = response_id == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp0_) {
		_data7_->callback (TRUE, _data7_->callback_target);
	} else {
		if (response_id == ((gint) GTK_RESPONSE_YES)) {
			chess_application_present_save_dialog (self, _____lambda8__chess_application_present_save_dialog_callback, _data7_);
		} else {
			g_warn_if_fail (response_id == ((gint) GTK_RESPONSE_NO));
			self->priv->game_needs_saving = FALSE;
			chess_application_autosave (self);
			_data7_->callback (FALSE, _data7_->callback_target);
		}
	}
	_tmp1_ = _data7_->prompt_save_game_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp1_);
}

static void
___lambda5__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda5_ (self, response_id);
}

static void
chess_application_prompt_save_game (ChessApplication* self,
                                    const gchar* prompt_text,
                                    ChessApplicationPromptSaveGameCallback callback,
                                    gpointer callback_target)
{
	Block7Data* _data7_;
	ChessWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	GtkMessageDialog* _tmp2_;
	ChessGame* _tmp3_;
	GtkMessageDialog* _tmp8_;
	GtkMessageDialog* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prompt_text != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->callback = callback;
	_data7_->callback_target = callback_target;
	if (!self->priv->game_needs_saving) {
		_data7_->callback (FALSE, _data7_->callback_target);
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp0_ = self->priv->_window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", prompt_text);
	g_object_ref_sink (_tmp1_);
	_data7_->prompt_save_game_dialog = _tmp1_;
	_tmp2_ = _data7_->prompt_save_game_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp2_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp3_ = self->priv->game;
	if (_tmp3_->result == CHESS_RESULT_IN_PROGRESS) {
		GtkMessageDialog* _tmp4_;
		GtkMessageDialog* _tmp5_;
		_tmp4_ = _data7_->prompt_save_game_dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp4_, _ ("_Abandon game"), (gint) GTK_RESPONSE_NO);
		_tmp5_ = _data7_->prompt_save_game_dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp5_, _ ("_Save game for later"), (gint) GTK_RESPONSE_YES);
	} else {
		GtkMessageDialog* _tmp6_;
		GtkMessageDialog* _tmp7_;
		_tmp6_ = _data7_->prompt_save_game_dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp6_, _ ("_Discard game"), (gint) GTK_RESPONSE_NO);
		_tmp7_ = _data7_->prompt_save_game_dialog;
		gtk_dialog_add_button ((GtkDialog*) _tmp7_, _ ("_Save game log"), (gint) GTK_RESPONSE_YES);
	}
	_tmp8_ = _data7_->prompt_save_game_dialog;
	g_signal_connect_data ((GtkDialog*) _tmp8_, "response", (GCallback) ___lambda5__gtk_dialog_response, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp9_ = _data7_->prompt_save_game_dialog;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ChessApplication* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->claim_draw_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda11_ (Block8Data* _data8_,
             gint response_id)
{
	ChessApplication* self;
	ChessGame* _tmp0_;
	GtkMessageDialog* _tmp4_;
	self = _data8_->self;
	_tmp0_ = self->priv->game;
	chess_game_unpause (_tmp0_);
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		ChessGame* _tmp1_;
		ChessPlayer* _tmp2_;
		ChessPlayer* _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = chess_game_get_current_player (_tmp1_);
		_tmp3_ = _tmp2_;
		chess_player_claim_draw (_tmp3_);
	}
	_tmp4_ = _data8_->claim_draw_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp4_);
}

static void
___lambda11__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda11_ (self, response_id);
}

static void
chess_application_present_claim_draw_dialog (ChessApplication* self)
{
	ChessGame* _tmp0_;
	Block8Data* _data8_;
	ChessGame* _tmp1_;
	ChessWindow* _tmp2_;
	GtkMessageDialog* _tmp3_;
	gchar* reason = NULL;
	ChessGame* _tmp4_;
	GtkMessageDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	GtkMessageDialog* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (chess_game_can_claim_draw (_tmp0_), "game.can_claim_draw ()");
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp1_ = self->priv->game;
	chess_game_pause (_tmp1_, FALSE);
	_tmp2_ = self->priv->_window;
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Would you like to claim a draw?"));
	g_object_ref_sink (_tmp3_);
	_data8_->claim_draw_dialog = _tmp3_;
	_tmp4_ = self->priv->game;
	if (chess_game_is_fifty_move_rule_fulfilled (_tmp4_)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("You may claim a draw because fifty moves have passed without a capture" \
" or pawn advancement. (The computer player may still choose to claim a" \
" draw even if you choose to keep playing.)"));
		_g_free0 (reason);
		reason = _tmp5_;
	} else {
		ChessGame* _tmp6_;
		_tmp6_ = self->priv->game;
		if (chess_game_is_three_fold_repeat (_tmp6_)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("You may claim a draw because the current board position has occurred t" \
"hree times. (The computer player may still choose to claim a draw even" \
" if you choose to keep playing.)"));
			_g_free0 (reason);
			reason = _tmp7_;
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp8_ = _data8_->claim_draw_dialog;
	_tmp9_ = reason;
	g_object_set (_tmp8_, "secondary-text", _tmp9_, NULL);
	_tmp10_ = _data8_->claim_draw_dialog;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp10_, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Claim Draw"), GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp11_ = _data8_->claim_draw_dialog;
	g_signal_connect_data ((GtkDialog*) _tmp11_, "response", (GCallback) ___lambda11__gtk_dialog_response, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp12_ = _data8_->claim_draw_dialog;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_g_free0 (reason);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
__lambda9_ (ChessApplication* self,
            gboolean cancelled)
{
	if (!cancelled) {
		chess_application_start_new_game (self);
	}
}

static void
___lambda9__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                         gpointer self)
{
	__lambda9_ ((ChessApplication*) self, cancelled);
}

void
chess_application_new_game_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_prompt_save_game (self, _ ("Save this game before starting a new one?"), ___lambda9__chess_application_prompt_save_game_callback, self);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ChessApplication* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->resign_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda20_ (Block9Data* _data9_,
             gint response_id)
{
	ChessApplication* self;
	ChessGame* _tmp0_;
	self = _data9_->self;
	_tmp0_ = self->priv->game;
	chess_game_unpause (_tmp0_);
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		ChessPlayer* _tmp1_;
		_tmp1_ = self->priv->human_player;
		if (_tmp1_ != NULL) {
			ChessPlayer* _tmp2_;
			_tmp2_ = self->priv->human_player;
			chess_player_resign (_tmp2_);
		} else {
			ChessGame* _tmp3_;
			ChessPlayer* _tmp4_;
			ChessPlayer* _tmp5_;
			_tmp3_ = self->priv->game;
			_tmp4_ = chess_game_get_current_player (_tmp3_);
			_tmp5_ = _tmp4_;
			chess_player_resign (_tmp5_);
		}
	}
	gtk_window_destroy ((GtkWindow*) _data9_->resign_dialog);
}

static void
___lambda20__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda20_ (self, response_id);
}

void
chess_application_resign_cb (ChessApplication* self)
{
	Block9Data* _data9_;
	ChessGame* _tmp0_;
	ChessWindow* _tmp1_;
	GtkMessageDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	chess_game_pause (_tmp0_, FALSE);
	_tmp1_ = self->priv->_window;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Are you sure you want to resign?"));
	g_object_ref_sink (_tmp2_);
	_data9_->resign_dialog = _tmp2_;
	gtk_message_dialog_format_secondary_text (_data9_->resign_dialog, "%s", _ ("This makes sense if you plan to save the game as a record of your loss" \
"."));
	gtk_dialog_add_buttons ((GtkDialog*) _data9_->resign_dialog, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Resign"), GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_signal_connect_data ((GtkDialog*) _data9_->resign_dialog, "response", (GCallback) ___lambda20__gtk_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data9_->resign_dialog);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

void
chess_application_undo_move_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	ChessPlayer* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp1_->selected_rank = -1;
	_tmp2_ = chess_application_get_scene (self);
	_tmp3_ = _tmp2_;
	_tmp3_->selected_file = -1;
	_tmp4_ = self->priv->opponent;
	if (_tmp4_ != NULL) {
		ChessPlayer* _tmp5_;
		_tmp5_ = self->priv->human_player;
		chess_player_undo (_tmp5_);
	} else {
		ChessGame* _tmp6_;
		ChessPlayer* _tmp7_;
		ChessPlayer* _tmp8_;
		_tmp6_ = self->priv->game;
		_tmp7_ = chess_game_get_opponent (_tmp6_);
		_tmp8_ = _tmp7_;
		chess_player_undo (_tmp8_);
	}
}

void
chess_application_pause_resume_cb (ChessApplication* self)
{
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ChessWindow* _tmp5_;
	ChessWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessGame* _tmp3_;
		_tmp3_ = self->priv->game;
		chess_game_unpause (_tmp3_);
	} else {
		ChessGame* _tmp4_;
		_tmp4_ = self->priv->game;
		chess_game_pause (_tmp4_, TRUE);
	}
	chess_application_update_action_status (self);
	_tmp5_ = self->priv->_window;
	chess_window_update_history_panel (_tmp5_);
	_tmp6_ = self->priv->_window;
	chess_window_update_pause_resume_button (_tmp6_);
}

void
chess_application_quit_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_quit_game (self);
}

static void
chess_application_history_go_first_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	chess_scene_set_move_number (_tmp1_, 0);
}

static void
chess_application_history_go_previous_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ChessScene* _tmp4_;
	ChessScene* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		return;
	}
	_tmp4_ = chess_application_get_scene (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_scene_get_move_number (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == -1) {
		ChessScene* _tmp8_;
		ChessScene* _tmp9_;
		ChessGame* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		_tmp8_ = chess_application_get_scene (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
		_tmp12_ = _tmp11_;
		chess_scene_set_move_number (_tmp9_, ((gint) _tmp12_) - 1);
	} else {
		ChessScene* _tmp13_;
		ChessScene* _tmp14_;
		ChessScene* _tmp15_;
		ChessScene* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp13_ = chess_application_get_scene (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = chess_application_get_scene (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = chess_scene_get_move_number (_tmp16_);
		_tmp18_ = _tmp17_;
		chess_scene_set_move_number (_tmp14_, _tmp18_ - 1);
	}
}

static void
chess_application_history_go_next_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint move_number = 0;
	ChessScene* _tmp4_;
	ChessScene* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	ChessGame* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == -1) {
		return;
	}
	_tmp4_ = chess_application_get_scene (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_scene_get_move_number (_tmp5_);
	_tmp7_ = _tmp6_;
	move_number = _tmp7_ + 1;
	_tmp8_ = self->priv->game;
	_tmp9_ = chess_game_get_n_moves (_tmp8_);
	_tmp10_ = _tmp9_;
	if (((guint) move_number) >= _tmp10_) {
		ChessScene* _tmp11_;
		ChessScene* _tmp12_;
		_tmp11_ = chess_application_get_scene (self);
		_tmp12_ = _tmp11_;
		chess_scene_set_move_number (_tmp12_, -1);
	} else {
		ChessScene* _tmp13_;
		ChessScene* _tmp14_;
		_tmp13_ = chess_application_get_scene (self);
		_tmp14_ = _tmp13_;
		chess_scene_set_move_number (_tmp14_, move_number);
	}
}

static void
chess_application_history_go_last_cb (ChessApplication* self)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_application_get_scene (self);
	_tmp1_ = _tmp0_;
	chess_scene_set_move_number (_tmp1_, -1);
}

static void
__lambda21_ (ChessApplication* self)
{
	PreferencesDialog* _tmp0_;
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
___lambda21__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda21_ ((ChessApplication*) self);
}

static void
chess_application_preferences_cb (ChessApplication* self)
{
	PreferencesDialog* _tmp0_;
	ChessWindow* _tmp2_;
	GSettings* _tmp3_;
	GList* _tmp4_;
	PreferencesDialog* _tmp5_;
	PreferencesDialog* _tmp6_;
	PreferencesDialog* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		PreferencesDialog* _tmp1_;
		_tmp1_ = self->priv->preferences_dialog;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = self->priv->_window;
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->ai_profiles;
	_tmp5_ = preferences_dialog_new ((GtkWindow*) _tmp2_, _tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp5_;
	_tmp6_ = self->priv->preferences_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp6_, "response", (GCallback) ___lambda21__gtk_dialog_response, self, 0);
	_tmp7_ = self->priv->preferences_dialog;
	gtk_widget_show ((GtkWidget*) _tmp7_);
}

void
chess_application_help_cb (ChessApplication* self)
{
	ChessWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-chess", (guint32) GDK_CURRENT_TIME);
}

void
chess_application_about_cb (ChessApplication* self)
{
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp2_;
	GtkAboutDialog* _tmp3_;
	ChessWindow* _tmp4_;
	GtkAboutDialog* _tmp5_;
	GtkAboutDialog* _tmp6_;
	GtkAboutDialog* _tmp7_;
	GtkAboutDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkAboutDialog* _tmp10_;
	GtkAboutDialog* _tmp11_;
	GtkAboutDialog* _tmp12_;
	GtkAboutDialog* _tmp13_;
	GtkAboutDialog* _tmp14_;
	GtkAboutDialog* _tmp15_;
	GtkAboutDialog* _tmp16_;
	GtkAboutDialog* _tmp17_;
	GtkAboutDialog* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	if (_tmp0_ != NULL) {
		GtkAboutDialog* _tmp1_;
		_tmp1_ = self->priv->about_dialog;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = _tmp2_;
	_tmp3_ = self->priv->about_dialog;
	_tmp4_ = self->priv->_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp4_);
	_tmp5_ = self->priv->about_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	_tmp6_ = self->priv->about_dialog;
	gtk_about_dialog_set_program_name (_tmp6_, _ ("Chess"));
	_tmp7_ = self->priv->about_dialog;
	gtk_about_dialog_set_version (_tmp7_, VERSION);
	_tmp8_ = self->priv->about_dialog;
	_tmp9_ = self->priv->copyrights;
	gtk_about_dialog_set_copyright (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->about_dialog;
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_3_0);
	_tmp11_ = self->priv->about_dialog;
	gtk_about_dialog_set_comments (_tmp11_, _ ("A classic game of positional strategy"));
	_tmp12_ = self->priv->about_dialog;
	gtk_about_dialog_set_authors (_tmp12_, CHESS_APPLICATION_authors);
	_tmp13_ = self->priv->about_dialog;
	gtk_about_dialog_set_artists (_tmp13_, CHESS_APPLICATION_artists);
	_tmp14_ = self->priv->about_dialog;
	gtk_about_dialog_set_translator_credits (_tmp14_, _ ("translator-credits"));
	_tmp15_ = self->priv->about_dialog;
	gtk_about_dialog_set_website (_tmp15_, "https://wiki.gnome.org/Apps/Chess");
	_tmp16_ = self->priv->about_dialog;
	gtk_about_dialog_set_logo_icon_name (_tmp16_, "org.gnome.Chess");
	_tmp17_ = self->priv->about_dialog;
	gtk_window_set_hide_on_close ((GtkWindow*) _tmp17_, TRUE);
	_tmp18_ = self->priv->about_dialog;
	gtk_widget_show ((GtkWidget*) _tmp18_);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ChessApplication* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->promotion_type_selector_dialog);
		(_data10_->handler_target_destroy_notify == NULL) ? NULL : (_data10_->handler_target_destroy_notify (_data10_->handler_target), NULL);
		_data10_->handler = NULL;
		_data10_->handler_target = NULL;
		_data10_->handler_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda24_ (Block10Data* _data10_,
             gint response_id)
{
	ChessApplication* self;
	self = _data10_->self;
	switch (response_id) {
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN:
		{
			PieceType _tmp0_;
			_tmp0_ = PIECE_TYPE_QUEEN;
			_data10_->handler (&_tmp0_, _data10_->handler_target);
			break;
		}
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT:
		{
			PieceType _tmp1_;
			_tmp1_ = PIECE_TYPE_KNIGHT;
			_data10_->handler (&_tmp1_, _data10_->handler_target);
			break;
		}
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK:
		{
			PieceType _tmp2_;
			_tmp2_ = PIECE_TYPE_ROOK;
			_data10_->handler (&_tmp2_, _data10_->handler_target);
			break;
		}
		case PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP:
		{
			PieceType _tmp3_;
			_tmp3_ = PIECE_TYPE_BISHOP;
			_data10_->handler (&_tmp3_, _data10_->handler_target);
			break;
		}
		default:
		{
			_data10_->handler (NULL, _data10_->handler_target);
			break;
		}
	}
	gtk_window_destroy ((GtkWindow*) _data10_->promotion_type_selector_dialog);
	_g_object_unref0 (_data10_->promotion_type_selector_dialog);
	_data10_->promotion_type_selector_dialog = NULL;
}

static void
___lambda24__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda24_ (self, response_id);
}

static void
chess_application_show_promotion_type_selector (ChessApplication* self,
                                                ChessScenePromotionTypeCompletionHandler handler,
                                                gpointer handler_target,
                                                GDestroyNotify handler_target_destroy_notify)
{
	Block10Data* _data10_;
	ChessWindow* _tmp0_;
	ChessGame* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessPlayer* _tmp3_;
	ChessScene* _tmp4_;
	ChessScene* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ChessWindow* _tmp8_;
	ChessWindowLayoutMode _tmp9_;
	ChessWindowLayoutMode _tmp10_;
	PromotionTypeSelectorDialog* _tmp11_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	(_data10_->handler_target_destroy_notify == NULL) ? NULL : (_data10_->handler_target_destroy_notify (_data10_->handler_target), NULL);
	_data10_->handler = NULL;
	_data10_->handler_target = NULL;
	_data10_->handler_target_destroy_notify = NULL;
	_data10_->handler = handler;
	_data10_->handler_target = handler_target;
	_data10_->handler_target_destroy_notify = handler_target_destroy_notify;
	_tmp0_ = self->priv->_window;
	_tmp1_ = self->priv->game;
	_tmp2_ = chess_game_get_current_player (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_application_get_scene (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = chess_scene_get_theme_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_window;
	_tmp9_ = chess_window_get_layout_mode (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = promotion_type_selector_dialog_new ((GtkWindow*) _tmp0_, _tmp3_->color, _tmp7_, _tmp10_);
	g_object_ref_sink (_tmp11_);
	_data10_->promotion_type_selector_dialog = _tmp11_;
	g_signal_connect_data ((GtkDialog*) _data10_->promotion_type_selector_dialog, "response", (GCallback) ___lambda24__gtk_dialog_response, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data10_->promotion_type_selector_dialog);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ChessApplication* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->invalid_pgn_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda19_ (Block11Data* _data11_)
{
	ChessApplication* self;
	self = _data11_->self;
	gtk_window_destroy ((GtkWindow*) _data11_->invalid_pgn_dialog);
}

static void
___lambda19__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda19_ (self);
}

static void
chess_application_run_invalid_pgn_dialog (ChessApplication* self)
{
	Block11Data* _data11_;
	ChessWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = self->priv->_window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _ ("This does not look like a valid PGN game."));
	g_object_ref_sink (_tmp1_);
	_data11_->invalid_pgn_dialog = _tmp1_;
	gtk_dialog_add_button ((GtkDialog*) _data11_->invalid_pgn_dialog, _ ("_OK"), (gint) GTK_RESPONSE_OK);
	g_signal_connect_data ((GtkDialog*) _data11_->invalid_pgn_dialog, "response", (GCallback) ___lambda19__gtk_dialog_response, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data11_->invalid_pgn_dialog);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ChessApplication* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->invalid_move_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda13_ (Block12Data* _data12_)
{
	ChessApplication* self;
	self = _data12_->self;
	gtk_window_destroy ((GtkWindow*) _data12_->invalid_move_dialog);
}

static void
___lambda13__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda13_ (self);
}

static void
chess_application_show_invalid_move_dialog (ChessApplication* self,
                                            const gchar* error_message)
{
	Block12Data* _data12_;
	ChessWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = self->priv->_window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", error_message);
	g_object_ref_sink (_tmp1_);
	_data12_->invalid_move_dialog = _tmp1_;
	gtk_dialog_add_button ((GtkDialog*) _data12_->invalid_move_dialog, _ ("_OK"), (gint) GTK_RESPONSE_OK);
	g_signal_connect_data ((GtkDialog*) _data12_->invalid_move_dialog, "response", (GCallback) ___lambda13__gtk_dialog_response, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data12_->invalid_move_dialog);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
chess_application_update_pgn_time_remaining (ChessApplication* self)
{
	ChessGame* _tmp0_;
	ChessClock* _tmp1_;
	ChessClock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_clock (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		PGNGame* _tmp3_;
		ChessGame* _tmp4_;
		ChessClock* _tmp5_;
		ChessClock* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		PGNGame* _tmp11_;
		ChessGame* _tmp12_;
		ChessClock* _tmp13_;
		ChessClock* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp3_ = self->priv->pgn_game;
		_tmp4_ = self->priv->game;
		_tmp5_ = chess_game_get_clock (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = chess_clock_get_white_remaining_seconds (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		pgn_game_set_white_time_left (_tmp3_, _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = self->priv->pgn_game;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_clock (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = chess_clock_get_black_remaining_seconds (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("%i", _tmp16_);
		_tmp18_ = _tmp17_;
		pgn_game_set_black_time_left (_tmp11_, _tmp18_);
		_g_free0 (_tmp18_);
	}
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ChessApplication* self;
		self = _data13_->self;
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ChessApplication* self;
		self = _data14_->_data13_->self;
		_g_object_unref0 (_data14_->save_error_dialog);
		block13_data_unref (_data14_->_data13_);
		_data14_->_data13_ = NULL;
		g_slice_free (Block14Data, _data14_);
	}
}

static void
____lambda7_ (Block14Data* _data14_)
{
	Block13Data* _data13_;
	ChessApplication* self;
	GtkMessageDialog* _tmp0_;
	_data13_ = _data14_->_data13_;
	self = _data13_->self;
	_tmp0_ = _data14_->save_error_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
	if (_data13_->callback != NULL) {
		_data13_->callback (FALSE, _data13_->callback_target);
	}
}

static void
_____lambda7__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	____lambda7_ (self);
}

static void
__lambda6_ (Block13Data* _data13_,
            gint response_id)
{
	ChessApplication* self;
	GtkFileChooserNative* _tmp11_;
	GError* _inner_error0_ = NULL;
	self = _data13_->self;
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		chess_application_update_pgn_time_remaining (self);
		{
			GtkFileChooserNative* _tmp0_;
			GFile* _tmp1_;
			PGNGame* _tmp2_;
			GFile* _tmp3_;
			_tmp0_ = self->priv->save_dialog;
			_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp1_;
			_tmp2_ = self->priv->pgn_game;
			_tmp3_ = self->priv->game_file;
			pgn_game_write (_tmp2_, _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
			self->priv->game_needs_saving = FALSE;
			if (_data13_->callback != NULL) {
				_data13_->callback (TRUE, _data13_->callback_target);
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			Block14Data* _data14_;
			ChessWindow* _tmp4_;
			GError* _tmp5_;
			const gchar* _tmp6_;
			GtkMessageDialog* _tmp7_;
			GtkMessageDialog* _tmp8_;
			GtkMessageDialog* _tmp9_;
			GtkMessageDialog* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_data14_ = g_slice_new0 (Block14Data);
			_data14_->_ref_count_ = 1;
			_data14_->_data13_ = block13_data_ref (_data13_);
			_tmp4_ = self->priv->_window;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp4_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, _ ("Failed to save game: %s"), _tmp6_);
			g_object_ref_sink (_tmp7_);
			_data14_->save_error_dialog = _tmp7_;
			_tmp8_ = _data14_->save_error_dialog;
			gtk_dialog_add_button ((GtkDialog*) _tmp8_, _ ("_OK"), (gint) GTK_RESPONSE_OK);
			_tmp9_ = _data14_->save_error_dialog;
			g_signal_connect_data ((GtkDialog*) _tmp9_, "response", (GCallback) _____lambda7__gtk_dialog_response, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
			_tmp10_ = _data14_->save_error_dialog;
			gtk_widget_show ((GtkWidget*) _tmp10_);
			_g_error_free0 (e);
			block14_data_unref (_data14_);
			_data14_ = NULL;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		if (_data13_->callback != NULL) {
			_data13_->callback (FALSE, _data13_->callback_target);
		}
	}
	_tmp11_ = self->priv->save_dialog;
	gtk_native_dialog_hide ((GtkNativeDialog*) _tmp11_);
}

static void
___lambda6__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                        gint response_id,
                                        gpointer self)
{
	__lambda6_ (self, response_id);
}

static void
chess_application_present_save_dialog (ChessApplication* self,
                                       ChessApplicationPresentSaveDialogCallback callback,
                                       gpointer callback_target)
{
	Block13Data* _data13_;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp29_;
	gulong _tmp30_;
	GtkFileChooserNative* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->callback = callback;
	_data13_->callback_target = callback_target;
	_tmp0_ = self->priv->save_dialog;
	if (_tmp0_ == NULL) {
		ChessWindow* _tmp1_;
		GtkFileChooserNative* _tmp2_;
		gboolean set_file = FALSE;
		GFile* _tmp3_;
		GtkFileFilter* pgn_filter = NULL;
		GtkFileFilter* _tmp17_;
		GtkFileFilter* _tmp18_;
		GtkFileFilter* _tmp19_;
		GtkFileChooserNative* _tmp20_;
		GtkFileFilter* _tmp21_;
		GtkFileFilter* all_filter = NULL;
		GtkFileFilter* _tmp22_;
		GtkFileFilter* _tmp23_;
		GtkFileFilter* _tmp24_;
		GtkFileChooserNative* _tmp25_;
		GtkFileFilter* _tmp26_;
		GtkFileChooserNative* _tmp27_;
		_tmp1_ = self->priv->_window;
		_tmp2_ = gtk_file_chooser_native_new (_ ("Save Chess Game"), (GtkWindow*) _tmp1_, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Save"), _ ("_Cancel"));
		_g_object_unref0 (self->priv->save_dialog);
		self->priv->save_dialog = _tmp2_;
		set_file = FALSE;
		_tmp3_ = self->priv->game_file;
		if (_tmp3_ != NULL) {
			gchar* path = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp4_ = self->priv->game_file;
			_tmp5_ = g_file_get_path (_tmp4_);
			path = _tmp5_;
			_tmp7_ = path;
			_tmp8_ = self->priv->autosave_filename;
			if (g_strcmp0 (_tmp7_, _tmp8_) != 0) {
				const gchar* _tmp9_;
				_tmp9_ = path;
				_tmp6_ = !g_str_has_prefix (_tmp9_, "/run");
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				{
					GtkFileChooserNative* _tmp10_;
					GFile* _tmp11_;
					_tmp10_ = self->priv->save_dialog;
					_tmp11_ = self->priv->game_file;
					gtk_file_chooser_set_file ((GtkFileChooser*) _tmp10_, _tmp11_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					set_file = TRUE;
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp12_;
					const gchar* _tmp13_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					g_warning ("gnome-chess.vala:1314: Failed to set file chooser default file: %s", _tmp13_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (path);
					block13_data_unref (_data13_);
					_data13_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_free0 (path);
		}
		if (!set_file) {
			GtkFileChooserNative* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp14_ = self->priv->save_dialog;
			_tmp15_ = g_strconcat (_ ("Untitled Chess Game"), ".pgn", NULL);
			_tmp16_ = _tmp15_;
			gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp14_, _tmp16_);
			_g_free0 (_tmp16_);
		}
		_tmp17_ = gtk_file_filter_new ();
		pgn_filter = _tmp17_;
		_tmp18_ = pgn_filter;
		gtk_file_filter_set_name (_tmp18_, _ ("PGN files"));
		_tmp19_ = pgn_filter;
		gtk_file_filter_add_pattern (_tmp19_, "*.pgn");
		_tmp20_ = self->priv->save_dialog;
		_tmp21_ = pgn_filter;
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp20_, _tmp21_);
		_tmp22_ = gtk_file_filter_new ();
		all_filter = _tmp22_;
		_tmp23_ = all_filter;
		gtk_file_filter_set_name (_tmp23_, _ ("All files"));
		_tmp24_ = all_filter;
		gtk_file_filter_add_pattern (_tmp24_, "*");
		_tmp25_ = self->priv->save_dialog;
		_tmp26_ = all_filter;
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp25_, _tmp26_);
		_tmp27_ = self->priv->save_dialog;
		gtk_native_dialog_set_modal ((GtkNativeDialog*) _tmp27_, TRUE);
		_g_object_unref0 (all_filter);
		_g_object_unref0 (pgn_filter);
	}
	if (self->priv->save_dialog_response_id != ((gulong) 0)) {
		GtkFileChooserNative* _tmp28_;
		_tmp28_ = self->priv->save_dialog;
		g_signal_handler_disconnect ((GObject*) _tmp28_, self->priv->save_dialog_response_id);
	}
	_tmp29_ = self->priv->save_dialog;
	_tmp30_ = g_signal_connect_data ((GtkNativeDialog*) _tmp29_, "response", (GCallback) ___lambda6__gtk_native_dialog_response, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	self->priv->save_dialog_response_id = _tmp30_;
	_tmp31_ = self->priv->save_dialog;
	gtk_native_dialog_show ((GtkNativeDialog*) _tmp31_);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

void
chess_application_save_game_cb (ChessApplication* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game_file;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->game_file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->autosave_filename;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		chess_application_present_save_dialog (self, NULL, NULL);
		return;
	}
	chess_application_update_pgn_time_remaining (self);
	{
		PGNGame* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = self->priv->pgn_game;
		_tmp7_ = self->priv->game_file;
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->game_needs_saving = FALSE;
		chess_application_disable_action (self, SAVE_GAME_ACTION_NAME);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		chess_application_present_save_dialog (self, NULL, NULL);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
chess_application_save_game_as_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_present_save_dialog (self, NULL, NULL);
}

static void
___lambda18_ (ChessApplication* self,
              gint response_id)
{
	GtkFileChooserNative* _tmp3_;
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_;
		_tmp0_ = self->priv->open_dialog;
		_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = _tmp1_;
		_tmp2_ = self->priv->game_file;
		chess_application_load_game (self, _tmp2_);
	}
	_tmp3_ = self->priv->open_dialog;
	gtk_native_dialog_hide ((GtkNativeDialog*) _tmp3_);
}

static void
____lambda18__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                          gint response_id,
                                          gpointer self)
{
	___lambda18_ ((ChessApplication*) self, response_id);
}

static void
__lambda17_ (ChessApplication* self,
             gboolean cancelled)
{
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp15_;
	if (cancelled) {
		return;
	}
	_tmp0_ = self->priv->open_dialog;
	if (_tmp0_ == NULL) {
		ChessWindow* _tmp1_;
		GtkFileChooserNative* _tmp2_;
		GtkFileChooserNative* _tmp3_;
		GtkFileFilter* pgn_filter = NULL;
		GtkFileFilter* _tmp4_;
		GtkFileFilter* _tmp5_;
		GtkFileFilter* _tmp6_;
		GtkFileChooserNative* _tmp7_;
		GtkFileFilter* _tmp8_;
		GtkFileFilter* all_filter = NULL;
		GtkFileFilter* _tmp9_;
		GtkFileFilter* _tmp10_;
		GtkFileFilter* _tmp11_;
		GtkFileChooserNative* _tmp12_;
		GtkFileFilter* _tmp13_;
		GtkFileChooserNative* _tmp14_;
		_tmp1_ = self->priv->_window;
		_tmp2_ = gtk_file_chooser_native_new (_ ("Load Chess Game"), (GtkWindow*) _tmp1_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Open"), _ ("_Cancel"));
		_g_object_unref0 (self->priv->open_dialog);
		self->priv->open_dialog = _tmp2_;
		_tmp3_ = self->priv->open_dialog;
		gtk_native_dialog_set_modal ((GtkNativeDialog*) _tmp3_, TRUE);
		_tmp4_ = gtk_file_filter_new ();
		pgn_filter = _tmp4_;
		_tmp5_ = pgn_filter;
		gtk_file_filter_set_name (_tmp5_, _ ("PGN files"));
		_tmp6_ = pgn_filter;
		gtk_file_filter_add_pattern (_tmp6_, "*.pgn");
		_tmp7_ = self->priv->open_dialog;
		_tmp8_ = pgn_filter;
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp7_, _tmp8_);
		_tmp9_ = gtk_file_filter_new ();
		all_filter = _tmp9_;
		_tmp10_ = all_filter;
		gtk_file_filter_set_name (_tmp10_, _ ("All files"));
		_tmp11_ = all_filter;
		gtk_file_filter_add_pattern (_tmp11_, "*");
		_tmp12_ = self->priv->open_dialog;
		_tmp13_ = all_filter;
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp12_, _tmp13_);
		_tmp14_ = self->priv->open_dialog;
		g_signal_connect_object ((GtkNativeDialog*) _tmp14_, "response", (GCallback) ____lambda18__gtk_native_dialog_response, self, 0);
		_g_object_unref0 (all_filter);
		_g_object_unref0 (pgn_filter);
	}
	_tmp15_ = self->priv->open_dialog;
	gtk_native_dialog_show ((GtkNativeDialog*) _tmp15_);
}

static void
___lambda17__chess_application_prompt_save_game_callback (gboolean cancelled,
                                                          gpointer self)
{
	__lambda17_ ((ChessApplication*) self, cancelled);
}

void
chess_application_open_game_cb (ChessApplication* self)
{
	g_return_if_fail (self != NULL);
	chess_application_prompt_save_game (self, _ ("Save this game before loading another one?"), ___lambda17__chess_application_prompt_save_game_callback, self);
}

static void
chess_application_start_new_game (ChessApplication* self)
{
	PGNGame* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	PGNGame* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PGNGame* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint duration = 0;
	GSettings* _tmp10_;
	gchar* engine_name = NULL;
	GSettings* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* engine_level = NULL;
	GSettings* _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = NULL;
	chess_application_disable_action (self, NEW_GAME_ACTION_NAME);
	chess_application_disable_action (self, SAVE_GAME_AS_ACTION_NAME);
	_tmp0_ = pgn_game_new ();
	_g_object_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = now;
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
	_tmp5_ = _tmp4_;
	pgn_game_set_date (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = now;
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
	_tmp9_ = _tmp8_;
	pgn_game_set_time (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->settings;
	duration = g_settings_get_int (_tmp10_, "duration");
	if (duration > 0) {
		PGNGame* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		PGNGame* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		PGNGame* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp11_ = self->priv->pgn_game;
		_tmp12_ = g_strdup_printf ("%i", duration);
		_tmp13_ = _tmp12_;
		pgn_game_set_time_control (_tmp11_, _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = self->priv->pgn_game;
		_tmp15_ = g_strdup_printf ("%i", duration);
		_tmp16_ = _tmp15_;
		pgn_game_set_white_time_left (_tmp14_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->pgn_game;
		_tmp18_ = g_strdup_printf ("%i", duration);
		_tmp19_ = _tmp18_;
		pgn_game_set_black_time_left (_tmp17_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->settings;
	_tmp21_ = g_settings_get_string (_tmp20_, "opponent");
	engine_name = _tmp21_;
	_tmp22_ = engine_name;
	if (g_strcmp0 (_tmp22_, "") == 0) {
		GList* _tmp23_;
		_tmp23_ = self->priv->ai_profiles;
		if (_tmp23_ != NULL) {
			GList* _tmp24_;
			gconstpointer _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp24_ = self->priv->ai_profiles;
			_tmp25_ = _tmp24_->data;
			_tmp26_ = ai_profile_get_name ((AIProfile*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (engine_name);
			engine_name = _tmp28_;
		} else {
			gchar* _tmp29_;
			_tmp29_ = g_strdup ("human");
			_g_free0 (engine_name);
			engine_name = _tmp29_;
		}
	}
	_tmp30_ = self->priv->settings;
	_tmp31_ = g_settings_get_string (_tmp30_, "difficulty");
	engine_level = _tmp31_;
	_tmp33_ = engine_name;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_;
		_tmp34_ = engine_name;
		_tmp32_ = g_strcmp0 (_tmp34_, "human") != 0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gchar* play_as = NULL;
		GSettings* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp43_;
		GSettings* _tmp53_;
		const gchar* _tmp54_;
		_tmp35_ = self->priv->settings;
		_tmp36_ = g_settings_get_string (_tmp35_, "play-as");
		play_as = _tmp36_;
		_tmp37_ = play_as;
		if (g_strcmp0 (_tmp37_, "alternate") == 0) {
			gchar* last_side = NULL;
			GSettings* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_ = NULL;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp38_ = self->priv->settings;
			_tmp39_ = g_settings_get_string (_tmp38_, "last-played-as");
			last_side = _tmp39_;
			_tmp41_ = last_side;
			if (g_strcmp0 (_tmp41_, "white") == 0) {
				_tmp40_ = "black";
			} else {
				_tmp40_ = "white";
			}
			_tmp42_ = g_strdup (_tmp40_);
			_g_free0 (play_as);
			play_as = _tmp42_;
			_g_free0 (last_side);
		}
		_tmp43_ = play_as;
		if (g_strcmp0 (_tmp43_, "white") == 0) {
			PGNGame* _tmp44_;
			const gchar* _tmp45_;
			PGNGame* _tmp46_;
			const gchar* _tmp47_;
			_tmp44_ = self->priv->pgn_game;
			_tmp45_ = engine_name;
			pgn_game_set_black_ai (_tmp44_, _tmp45_);
			_tmp46_ = self->priv->pgn_game;
			_tmp47_ = engine_level;
			pgn_game_set_black_level (_tmp46_, _tmp47_);
		} else {
			const gchar* _tmp48_;
			_tmp48_ = play_as;
			if (g_strcmp0 (_tmp48_, "black") == 0) {
				PGNGame* _tmp49_;
				const gchar* _tmp50_;
				PGNGame* _tmp51_;
				const gchar* _tmp52_;
				_tmp49_ = self->priv->pgn_game;
				_tmp50_ = engine_name;
				pgn_game_set_white_ai (_tmp49_, _tmp50_);
				_tmp51_ = self->priv->pgn_game;
				_tmp52_ = engine_level;
				pgn_game_set_white_level (_tmp51_, _tmp52_);
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp53_ = self->priv->settings;
		_tmp54_ = play_as;
		g_settings_set_string (_tmp53_, "last-played-as", _tmp54_);
		_g_free0 (play_as);
	}
	chess_application_start_game (self);
	_g_free0 (engine_level);
	_g_free0 (engine_name);
	_g_date_time_unref0 (now);
}

static void
chess_application_load_game (ChessApplication* self,
                             GFile* file)
{
	PGNGame* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	chess_application_enable_action (self, NEW_GAME_ACTION_NAME);
	{
		PGN* pgn = NULL;
		PGN* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		PGNGame* _tmp3_;
		_tmp0_ = pgn_new_from_file (file, &_inner_error0_);
		pgn = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = pgn->games;
		_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
		_tmp3_ = _g_object_ref0 ((PGNGame*) _tmp2_);
		_g_object_unref0 (self->priv->pgn_game);
		self->priv->pgn_game = _tmp3_;
		_g_object_unref0 (pgn);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (self->priv->pgn_game);
		self->priv->pgn_game = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = self->priv->pgn_game;
	if (_tmp4_ == NULL) {
		PGNGame* _tmp5_;
		chess_application_run_invalid_pgn_dialog (self);
		_tmp5_ = pgn_game_new ();
		_g_object_unref0 (self->priv->pgn_game);
		self->priv->pgn_game = _tmp5_;
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = NULL;
	} else {
		GFile* _tmp6_;
		_tmp6_ = _g_object_ref0 (file);
		_g_object_unref0 (self->priv->game_file);
		self->priv->game_file = _tmp6_;
		chess_application_start_game (self);
	}
}

void
chess_application_enable_action (ChessApplication* self,
                                 const gchar* name)
{
	GAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, name);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), TRUE);
}

void
chess_application_disable_action (ChessApplication* self,
                                  const gchar* name)
{
	GAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, name);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), FALSE);
}

static gint
chess_application_main (gchar** args,
                        gint args_length1)
{
	ChessApplication* _tmp0_;
	ChessApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (_ ("Chess"));
	gtk_window_set_default_icon_name ("org.gnome.Chess");
	_tmp0_ = chess_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return chess_application_main (argv, argc);
}

ChessWindow*
chess_application_get_window (ChessApplication* self)
{
	ChessWindow* result;
	ChessWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
chess_application_set_window (ChessApplication* self,
                              ChessWindow* value)
{
	ChessWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = chess_application_get_window (self);
	if (old_value != value) {
		self->priv->_window = value;
		g_object_notify_by_pspec ((GObject *) self, chess_application_properties[CHESS_APPLICATION_WINDOW_PROPERTY]);
	}
}

ChessView*
chess_application_get_view (ChessApplication* self)
{
	ChessView* result;
	ChessWindow* _tmp0_;
	ChessView* _tmp1_;
	ChessView* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = chess_window_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

ChessScene*
chess_application_get_scene (ChessApplication* self)
{
	ChessScene* result;
	ChessView* _tmp0_;
	ChessView* _tmp1_;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_application_get_view (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_view_get_scene (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

static void
chess_application_class_init (ChessApplicationClass * klass,
                              gpointer klass_data)
{
	chess_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessApplication_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) chess_application_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) chess_application_real_startup;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) chess_application_real_open;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) chess_application_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) chess_application_real_shutdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_application_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_APPLICATION_WINDOW_PROPERTY, chess_application_properties[CHESS_APPLICATION_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", TYPE_CHESS_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_APPLICATION_VIEW_PROPERTY, chess_application_properties[CHESS_APPLICATION_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", TYPE_CHESS_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_APPLICATION_SCENE_PROPERTY, chess_application_properties[CHESS_APPLICATION_SCENE_PROPERTY] = g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
chess_application_instance_init (ChessApplication * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = chess_application_get_instance_private (self);
	self->priv->preferences_dialog = NULL;
	self->priv->about_dialog = NULL;
	self->priv->open_dialog = NULL;
	self->priv->save_dialog = NULL;
	self->priv->save_dialog_response_id = (gulong) 0;
	self->priv->game = NULL;
	self->priv->game_needs_saving = FALSE;
	self->priv->starting = TRUE;
	self->priv->opponent = NULL;
	self->priv->human_player = NULL;
	self->priv->opponent_engine = NULL;
	self->priv->engine_timeout_source = (guint) 0;
	_tmp0_ = g_strdup ("Copyright \302\251 2010\342\200\2232013 Robert Ancell\n" \
"Copyright \302\251 2013\342\200\2232020 Michael Catanzaro\n" \
"Copyright \302\251 2015\342\200\2232016 Sahil Sareen");
	self->priv->copyrights = _tmp0_;
}

static void
chess_application_finalize (GObject * obj)
{
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_APPLICATION, ChessApplication);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->about_dialog);
	_g_object_unref0 (self->priv->open_dialog);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->pgn_game);
	_g_object_unref0 (self->priv->game);
	_g_free0 (self->priv->autosave_filename);
	_g_object_unref0 (self->priv->game_file);
	(self->priv->ai_profiles == NULL) ? NULL : (self->priv->ai_profiles = (_g_list_free__g_object_unref0_ (self->priv->ai_profiles), NULL));
	_g_object_unref0 (self->priv->opponent);
	_g_object_unref0 (self->priv->human_player);
	_g_object_unref0 (self->priv->opponent_engine);
	_g_free0 (self->priv->copyrights);
	G_OBJECT_CLASS (chess_application_parent_class)->finalize (obj);
}

static GType
chess_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessApplication), 0, (GInstanceInitFunc) chess_application_instance_init, NULL };
	GType chess_application_type_id;
	chess_application_type_id = g_type_register_static (adw_application_get_type (), "ChessApplication", &g_define_type_info, 0);
	ChessApplication_private_offset = g_type_add_instance_private (chess_application_type_id, sizeof (ChessApplicationPrivate));
	return chess_application_type_id;
}

GType
chess_application_get_type (void)
{
	static volatile gsize chess_application_type_id__once = 0;
	if (g_once_init_enter (&chess_application_type_id__once)) {
		GType chess_application_type_id;
		chess_application_type_id = chess_application_get_type_once ();
		g_once_init_leave (&chess_application_type_id__once, chess_application_type_id);
	}
	return chess_application_type_id__once;
}

static void
_vala_chess_application_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_APPLICATION, ChessApplication);
	switch (property_id) {
		case CHESS_APPLICATION_WINDOW_PROPERTY:
		g_value_set_object (value, chess_application_get_window (self));
		break;
		case CHESS_APPLICATION_VIEW_PROPERTY:
		g_value_set_object (value, chess_application_get_view (self));
		break;
		case CHESS_APPLICATION_SCENE_PROPERTY:
		g_value_set_object (value, chess_application_get_scene (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_chess_application_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ChessApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_APPLICATION, ChessApplication);
	switch (property_id) {
		case CHESS_APPLICATION_WINDOW_PROPERTY:
		chess_application_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

