/* notifications_group.c generated by valac 0.56.3, the Vala compiler
 * generated from notifications_group.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include "budgie-private.h"

enum  {
	BUDGIE_NOTIFICATION_GROUP_0_PROPERTY,
	BUDGIE_NOTIFICATION_GROUP_NUM_PROPERTIES
};
static GParamSpec* budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
enum  {
	BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL,
	BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL,
	BUDGIE_NOTIFICATION_GROUP_NUM_SIGNALS
};
static guint budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_NUM_SIGNALS] = {0};

struct _BudgieNotificationGroupPrivate {
	GHashTable* notifications;
	GtkListBox* list;
	GtkBox* header;
	GtkImage* app_image;
	GtkLabel* app_label;
	gchar* app_name;
	GtkButton* dismiss_button;
};

struct _Block3Data {
	int _ref_count_;
	BudgieNotificationGroup* self;
	BudgieNotification* notification;
};

static gint BudgieNotificationGroup_private_offset;
static gpointer budgie_notification_group_parent_class = NULL;

static gint* _int_dup (gint* self);
static void _g_object_unref0_ (gpointer var);
static void _budgie_notification_group_dismiss_all_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda29_ (Block3Data* _data3_);
static void ___lambda29__notification_widget_closed_individually (NotificationWidget* _sender,
                                                           gpointer self);
static gboolean __lambda28_ (BudgieNotificationGroup* self,
                      guint32 id,
                      NotificationWidget* notification);
static gboolean ___lambda28__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static void budgie_notification_group_finalize (GObject * obj);
static GType budgie_notification_group_get_type_once (void);

static inline gpointer
budgie_notification_group_get_instance_private (BudgieNotificationGroup* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationGroup_private_offset);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_budgie_notification_group_dismiss_all_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	budgie_notification_group_dismiss_all ((BudgieNotificationGroup*) self);
}

BudgieNotificationGroup*
budgie_notification_group_construct (GType object_type,
                                     const gchar* c_app_icon,
                                     const gchar* c_app_name)
{
	BudgieNotificationGroup * self = NULL;
	GtkStyleContext* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	GtkImage* _tmp17_;
	const gchar* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkButton* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkBox* _tmp32_;
	GtkImage* _tmp33_;
	GtkBox* _tmp34_;
	GtkLabel* _tmp35_;
	GtkBox* _tmp36_;
	GtkButton* _tmp37_;
	GtkBox* _tmp38_;
	GtkListBox* _tmp39_;
	g_return_val_if_fail (c_app_icon != NULL, NULL);
	g_return_val_if_fail (c_app_name != NULL, NULL);
	self = (BudgieNotificationGroup*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 4, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_widget_set_focus_on_click ((GtkWidget*) self, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "raven-notifications-group");
	g_object_set ((GtkWidget*) self, "margin", 4, NULL);
	_tmp1_ = g_strdup (c_app_name);
	_g_free0 (self->priv->app_name);
	self->priv->app_name = _tmp1_;
	if (string_contains (c_app_name, "budgie")) {
		_tmp2_ = string_contains (c_app_icon, "caffeine");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Caffeine Mode"));
		_g_free0 (self->priv->app_name);
		self->priv->app_name = _tmp3_;
	}
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp6_;
	_tmp7_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->list);
	self->priv->list = _tmp7_;
	_tmp8_ = self->priv->list;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp8_, FALSE);
	_tmp9_ = self->priv->list;
	gtk_widget_set_focus_on_click ((GtkWidget*) _tmp9_, FALSE);
	_tmp10_ = self->priv->list;
	gtk_list_box_set_selection_mode (_tmp10_, GTK_SELECTION_NONE);
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp11_;
	_tmp12_ = self->priv->header;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "raven-notifications-group-header");
	_tmp14_ = (GtkImage*) gtk_image_new_from_icon_name (c_app_icon, (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->app_image);
	self->priv->app_image = _tmp14_;
	_tmp15_ = self->priv->app_image;
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	_tmp16_ = self->priv->app_image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp16_, 5);
	_tmp17_ = self->priv->app_image;
	gtk_image_set_pixel_size (_tmp17_, 32);
	_tmp18_ = self->priv->app_name;
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->app_label);
	self->priv->app_label = _tmp19_;
	_tmp20_ = self->priv->app_label;
	gtk_label_set_ellipsize (_tmp20_, PANGO_ELLIPSIZE_END);
	_tmp21_ = self->priv->app_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_START);
	_tmp22_ = self->priv->app_label;
	gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_LEFT);
	_tmp23_ = self->priv->app_label;
	gtk_label_set_use_markup (_tmp23_, TRUE);
	_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-all-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->dismiss_button);
	self->priv->dismiss_button = _tmp24_;
	_tmp25_ = self->priv->dismiss_button;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "flat");
	_tmp27_ = self->priv->dismiss_button;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "image-button");
	_tmp29_ = self->priv->dismiss_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp29_, GTK_ALIGN_CENTER);
	_tmp30_ = self->priv->dismiss_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_END);
	_tmp31_ = self->priv->dismiss_button;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) _budgie_notification_group_dismiss_all_gtk_button_clicked, self, 0);
	_tmp32_ = self->priv->header;
	_tmp33_ = self->priv->app_image;
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, FALSE, FALSE, (guint) 0);
	_tmp34_ = self->priv->header;
	_tmp35_ = self->priv->app_label;
	gtk_box_pack_start (_tmp34_, (GtkWidget*) _tmp35_, FALSE, FALSE, (guint) 0);
	_tmp36_ = self->priv->header;
	_tmp37_ = self->priv->dismiss_button;
	gtk_box_pack_end (_tmp36_, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 0);
	_tmp38_ = self->priv->header;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp38_, TRUE, TRUE, (guint) 0);
	_tmp39_ = self->priv->list;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp39_, TRUE, TRUE, (guint) 0);
	return self;
}

BudgieNotificationGroup*
budgie_notification_group_new (const gchar* c_app_icon,
                               const gchar* c_app_name)
{
	return budgie_notification_group_construct (BUDGIE_TYPE_NOTIFICATION_GROUP, c_app_icon, c_app_name);
}

/**
 * add_notification is responsible for adding a notification (if it doesn't exist) and updating our counter
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieNotificationGroup* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->notification);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda29_ (Block3Data* _data3_)
{
	BudgieNotificationGroup* self;
	guint n_id = 0U;
	guint32 _tmp0_;
	guint32 _tmp1_;
	self = _data3_->self;
	_tmp0_ = budgie_notification_get_id (_data3_->notification);
	_tmp1_ = _tmp0_;
	n_id = (guint) _tmp1_;
	budgie_notification_group_remove_notification (self, (guint32) n_id);
	g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL], 0, (guint32) n_id);
}

static void
___lambda29__notification_widget_closed_individually (NotificationWidget* _sender,
                                                      gpointer self)
{
	__lambda29_ (self);
}

void
budgie_notification_group_add_notification (BudgieNotificationGroup* self,
                                            guint32 id,
                                            BudgieNotification* notification)
{
	Block3Data* _data3_;
	BudgieNotification* _tmp0_;
	GHashTable* _tmp1_;
	NotificationWidget* widget = NULL;
	NotificationWidget* _tmp2_;
	GHashTable* _tmp3_;
	NotificationWidget* _tmp4_;
	GtkListBox* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data3_->notification);
	_data3_->notification = _tmp0_;
	_tmp1_ = self->priv->notifications;
	if (g_hash_table_contains (_tmp1_, (gpointer) ((guintptr) id))) {
		budgie_notification_group_remove_notification (self, id);
	}
	_tmp2_ = notification_widget_new (_data3_->notification);
	g_object_ref_sink (_tmp2_);
	widget = _tmp2_;
	_tmp3_ = self->priv->notifications;
	_tmp4_ = _g_object_ref0 (widget);
	g_hash_table_insert (_tmp3_, (gpointer) ((guintptr) id), _tmp4_);
	_tmp5_ = self->priv->list;
	gtk_list_box_prepend (_tmp5_, (GtkWidget*) widget);
	budgie_notification_group_update_count (self);
	g_signal_connect_data (widget, "closed-individually", (GCallback) ___lambda29__notification_widget_closed_individually, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (widget);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

/**
 * dismiss_all is responsible for dismissing all notifications
 */
static gboolean
__lambda28_ (BudgieNotificationGroup* self,
             guint32 id,
             NotificationWidget* notification)
{
	GtkListBox* _tmp0_;
	GtkContainer* _tmp1_;
	gboolean result;
	g_return_val_if_fail (notification != NULL, FALSE);
	_tmp0_ = self->priv->list;
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) notification);
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
	gtk_widget_destroy ((GtkWidget*) notification);
	g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL], 0, id);
	result = TRUE;
	return result;
}

static gboolean
___lambda28__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda28_ ((BudgieNotificationGroup*) self, (guint32) ((guintptr) key), (NotificationWidget*) value);
	return result;
}

void
budgie_notification_group_dismiss_all (BudgieNotificationGroup* self)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifications;
	g_hash_table_foreach_steal (_tmp0_, ___lambda28__ghr_func, self);
	budgie_notification_group_update_count (self);
	_tmp1_ = self->priv->app_name;
	g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL], 0, _tmp1_);
}

/**
 * remove_notification is responsible for removing a notification (if it exists) and updating our counter
 */
static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

void
budgie_notification_group_remove_notification (BudgieNotificationGroup* self,
                                               guint32 id)
{
	NotificationWidget* notification = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	NotificationWidget* _tmp2_;
	NotificationWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
	_tmp2_ = _g_object_ref0 ((NotificationWidget*) _tmp1_);
	notification = _tmp2_;
	_tmp3_ = notification;
	if (_tmp3_ != NULL) {
		GHashTable* _tmp4_;
		GtkListBox* _tmp5_;
		NotificationWidget* _tmp6_;
		GtkContainer* _tmp7_;
		NotificationWidget* _tmp8_;
		gint* _tmp9_;
		gint _tmp10_;
		_tmp4_ = self->priv->notifications;
		g_hash_table_steal (_tmp4_, (gpointer) ((guintptr) id));
		_tmp5_ = self->priv->list;
		_tmp6_ = notification;
		_tmp7_ = gtk_widget_get_parent ((GtkWidget*) _tmp6_);
		gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp7_);
		_tmp8_ = notification;
		gtk_widget_destroy ((GtkWidget*) _tmp8_);
		budgie_notification_group_update_count (self);
		g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL], 0, id);
		_tmp9_ = self->count;
		_tmp10_ = 0;
		if (_int_equal (_tmp9_, &_tmp10_) == TRUE) {
			const gchar* _tmp11_;
			_tmp11_ = self->priv->app_name;
			g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL], 0, _tmp11_);
		}
	}
	_g_object_unref0 (notification);
}

/**
 * update_count updates our notifications count for this group
 */
void
budgie_notification_group_update_count (BudgieNotificationGroup* self)
{
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	gint* _tmp4_;
	GtkLabel* _tmp5_;
	const gchar* _tmp6_;
	gint* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (gint) _tmp2_;
	_tmp4_ = __int_dup0 (&_tmp3_);
	_g_free0 (self->count);
	self->count = _tmp4_;
	_tmp5_ = self->priv->app_label;
	_tmp6_ = self->priv->app_name;
	_tmp7_ = self->count;
	_tmp8_ = g_strdup_printf ("<b>%s (%i)</b>", _tmp6_, *_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_markup (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
}

static void
budgie_notification_group_class_init (BudgieNotificationGroupClass * klass,
                                      gpointer klass_data)
{
	budgie_notification_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationGroup_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_notification_group_finalize;
	/**
	 * Signals
	 */
	budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL] = g_signal_new ("dismissed-group", BUDGIE_TYPE_NOTIFICATION_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL] = g_signal_new ("dismissed-notification", BUDGIE_TYPE_NOTIFICATION_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}

static void
budgie_notification_group_instance_init (BudgieNotificationGroup * self,
                                         gpointer klass)
{
	gint _tmp0_;
	gint* _tmp1_;
	self->priv = budgie_notification_group_get_instance_private (self);
	_tmp0_ = 0;
	_tmp1_ = __int_dup0 (&_tmp0_);
	self->count = _tmp1_;
	self->priv->notifications = NULL;
	self->priv->list = NULL;
	self->priv->header = NULL;
	self->priv->app_image = NULL;
	self->priv->app_label = NULL;
	self->priv->dismiss_button = NULL;
}

static void
budgie_notification_group_finalize (GObject * obj)
{
	BudgieNotificationGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup);
	_g_free0 (self->count);
	_g_hash_table_unref0 (self->priv->notifications);
	_g_object_unref0 (self->priv->list);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->app_image);
	_g_object_unref0 (self->priv->app_label);
	_g_free0 (self->priv->app_name);
	_g_object_unref0 (self->priv->dismiss_button);
	G_OBJECT_CLASS (budgie_notification_group_parent_class)->finalize (obj);
}

/**
 * NotificationGroup is a group of notifications.
 */
static GType
budgie_notification_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationGroup), 0, (GInstanceInitFunc) budgie_notification_group_instance_init, NULL };
	GType budgie_notification_group_type_id;
	budgie_notification_group_type_id = g_type_register_static (gtk_box_get_type (), "BudgieNotificationGroup", &g_define_type_info, 0);
	BudgieNotificationGroup_private_offset = g_type_add_instance_private (budgie_notification_group_type_id, sizeof (BudgieNotificationGroupPrivate));
	return budgie_notification_group_type_id;
}

GType
budgie_notification_group_get_type (void)
{
	static volatile gsize budgie_notification_group_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_group_type_id__once)) {
		GType budgie_notification_group_type_id;
		budgie_notification_group_type_id = budgie_notification_group_get_type_once ();
		g_once_init_leave (&budgie_notification_group_type_id__once, budgie_notification_group_type_id);
	}
	return budgie_notification_group_type_id__once;
}

