"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFileUploadLink = exports.putFileContents = void 0;
var layerr_1 = require("layerr");
var stream_1 = __importDefault(require("stream"));
var encode_1 = require("../tools/encode");
var url_1 = require("../tools/url");
var path_1 = require("../tools/path");
var request_1 = require("../request");
var response_1 = require("../response");
var size_1 = require("../tools/size");
var types_1 = require("../types");
function putFileContents(context, filePath, data, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var _a, contentLength, _b, overwrite, headers, requestOptions, response, error;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    _a = options.contentLength, contentLength = _a === void 0 ? true : _a, _b = options.overwrite, overwrite = _b === void 0 ? true : _b;
                    headers = {
                        "Content-Type": "application/octet-stream"
                    };
                    if (typeof WEB === "undefined" && data instanceof stream_1.default.Readable) {
                        // Skip, no content-length
                    }
                    else if (contentLength === false) {
                        // Skip, disabled
                    }
                    else if (typeof contentLength === "number") {
                        headers["Content-Length"] = "".concat(contentLength);
                    }
                    else {
                        headers["Content-Length"] = "".concat((0, size_1.calculateDataLength)(data));
                    }
                    if (!overwrite) {
                        headers["If-None-Match"] = "*";
                    }
                    requestOptions = (0, request_1.prepareRequestOptions)({
                        url: (0, url_1.joinURL)(context.remoteURL, (0, path_1.encodePath)(filePath)),
                        method: "PUT",
                        headers: headers,
                        data: data
                    }, context, options);
                    return [4 /*yield*/, (0, request_1.request)(requestOptions)];
                case 1:
                    response = _c.sent();
                    try {
                        (0, response_1.handleResponseCode)(context, response);
                    }
                    catch (err) {
                        error = err;
                        if (error.status === 412 && !overwrite) {
                            return [2 /*return*/, false];
                        }
                        else {
                            throw error;
                        }
                    }
                    return [2 /*return*/, true];
            }
        });
    });
}
exports.putFileContents = putFileContents;
function getFileUploadLink(context, filePath) {
    var url = "".concat((0, url_1.joinURL)(context.remoteURL, (0, path_1.encodePath)(filePath)), "?Content-Type=application/octet-stream");
    var protocol = /^https:/i.test(url) ? "https" : "http";
    switch (context.authType) {
        case types_1.AuthType.None:
            // Do nothing
            break;
        case types_1.AuthType.Password: {
            var authPart = context.headers.Authorization.replace(/^Basic /i, "").trim();
            var authContents = (0, encode_1.fromBase64)(authPart);
            url = url.replace(/^https?:\/\//, "".concat(protocol, "://").concat(authContents, "@"));
            break;
        }
        default:
            throw new layerr_1.Layerr({
                info: {
                    code: types_1.ErrorCode.LinkUnsupportedAuthType
                }
            }, "Unsupported auth type for file link: ".concat(context.authType));
    }
    return url;
}
exports.getFileUploadLink = getFileUploadLink;
