/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Occupation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionCache;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;

public class Colony
extends Settlement
implements TradeLocation {
    private static final Logger logger = Logger.getLogger(Colony.class.getName());
    private static final int COLONY_CLASS_INDEX = 20;
    public static final String TAG = "colony";
    public static final String REARRANGE_COLONY = "rearrangeColony";
    public static final int LIBERTY_PER_REBEL = 200;
    public static final int CHANGE_UPPER_BOUND = 10;
    public static final int FAMINE_TURNS = 3;
    public static final int TRADE_MARGIN = 5;
    protected final Map<String, Building> buildingMap = new HashMap<String, Building>();
    protected final List<ColonyTile> colonyTiles = new ArrayList<ColonyTile>();
    protected final Map<String, ExportData> exportData = new HashMap<String, ExportData>();
    protected int liberty;
    protected int sonsOfLiberty;
    protected int oldSonsOfLiberty;
    protected int tories;
    protected int oldTories;
    protected int productionBonus;
    protected int immigration;
    protected Turn established = new Turn(0);
    protected final BuildQueue<BuildableType> buildQueue = new BuildQueue(this, BuildQueue.CompletionAction.REMOVE_EXCEPT_LAST, 500);
    protected final BuildQueue<UnitType> populationQueue = new BuildQueue(this, BuildQueue.CompletionAction.SHUFFLE, 300);
    protected int displayUnitCount = -1;
    private final ProductionCache productionCache = new ProductionCache(this);
    private boolean traceOccupation = false;
    private static final String BUILD_QUEUE_TAG = "buildQueueItem";
    private static final String ESTABLISHED_TAG = "established";
    private static final String IMMIGRATION_TAG = "immigration";
    private static final String LIBERTY_TAG = "liberty";
    private static final String PRODUCTION_BONUS_TAG = "productionBonus";
    private static final String NAME_TAG = "name";
    private static final String OLD_SONS_OF_LIBERTY_TAG = "oldSonsOfLiberty";
    private static final String OLD_TORIES_TAG = "oldTories";
    private static final String POPULATION_QUEUE_TAG = "populationQueueItem";
    private static final String SONS_OF_LIBERTY_TAG = "sonsOfLiberty";
    private static final String TORIES_TAG = "tories";
    private static final String UNIT_COUNT_TAG = "unitCount";

    protected Colony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public Colony(Game game, String id) {
        super(game, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Building> getBuildings() {
        Map<String, Building> map = this.buildingMap;
        synchronized (map) {
            return new ArrayList<Building>(this.buildingMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Building getBuilding(BuildingType type) {
        Map<String, Building> map = this.buildingMap;
        synchronized (map) {
            return this.buildingMap.get(type.getFirstLevel().getId());
        }
    }

    protected void setBuildingMap(List<Building> buildings) {
        this.clearBuildingMap();
        for (Building b : buildings) {
            this.addBuilding(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBuildingMap() {
        Map<String, Building> map = this.buildingMap;
        synchronized (map) {
            this.buildingMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColonyTile> getColonyTiles() {
        List<ColonyTile> list = this.colonyTiles;
        synchronized (list) {
            return new ArrayList<ColonyTile>(this.colonyTiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setColonyTiles(List<ColonyTile> colonyTiles) {
        List<ColonyTile> list = this.colonyTiles;
        synchronized (list) {
            this.colonyTiles.clear();
            this.colonyTiles.addAll(colonyTiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearColonyTiles() {
        List<ColonyTile> list = this.colonyTiles;
        synchronized (list) {
            this.colonyTiles.clear();
        }
    }

    public ColonyTile getColonyTile(Tile tile) {
        return CollectionUtils.find(this.getColonyTiles(), CollectionUtils.matchKey(tile, ColonyTile::getWorkTile));
    }

    protected Collection<ExportData> getExportData() {
        return this.exportData.values();
    }

    protected void setExportData(Collection<ExportData> exportData) {
        this.exportData.clear();
        for (ExportData ed : exportData) {
            this.setExportData(ed);
        }
    }

    public ExportData getExportData(GoodsType goodsType) {
        ExportData result = this.exportData.get(goodsType.getId());
        if (result == null) {
            result = new ExportData(goodsType, this.getWarehouseCapacity());
            this.setExportData(result);
        }
        return result;
    }

    public final void setExportData(ExportData newExportData) {
        this.exportData.put(newExportData.getId(), newExportData);
    }

    protected int getSonsOfLiberty() {
        return this.sonsOfLiberty;
    }

    protected int getOldSonsOfLiberty() {
        return this.oldSonsOfLiberty;
    }

    protected int getTories() {
        return this.tories;
    }

    protected int getOldTories() {
        return this.oldTories;
    }

    public int getProductionBonus() {
        return this.productionBonus;
    }

    public void setProductionBonus(int productionBonus) {
        this.productionBonus = productionBonus;
    }

    public void modifyImmigration(int amount) {
        this.immigration += amount;
    }

    public Turn getEstablished() {
        return this.established;
    }

    public void setEstablished(Turn newEstablished) {
        this.established = newEstablished;
    }

    public List<BuildableType> getBuildQueue() {
        return this.buildQueue.getValues();
    }

    public void setBuildQueue(List<BuildableType> buildQueue) {
        this.buildQueue.setValues(buildQueue);
    }

    public List<UnitType> getPopulationQueue() {
        return this.populationQueue.getValues();
    }

    public void setPopulationQueue(List<UnitType> populationQueue) {
        this.populationQueue.setValues(populationQueue);
    }

    public int getDisplayUnitCount() {
        return this.displayUnitCount;
    }

    public void setDisplayUnitCount(int count) {
        this.displayUnitCount = count;
    }

    public boolean getOccupationTrace() {
        return this.traceOccupation;
    }

    public boolean setOccupationTrace(boolean trace) {
        boolean ret = this.traceOccupation;
        this.traceOccupation = trace;
        return ret;
    }

    private void accumulateChoices(Collection<GoodsType> workTypes, Collection<GoodsType> tried, List<Collection<GoodsType>> result) {
        workTypes.removeAll(tried);
        if (!workTypes.isEmpty()) {
            result.add(workTypes);
            tried.addAll(workTypes);
        }
    }

    private void accumulateChoice(GoodsType workType, Collection<GoodsType> tried, List<Collection<GoodsType>> result) {
        if (workType == null) {
            return;
        }
        this.accumulateChoices(workType.getEquivalentTypes(), tried, result);
    }

    public List<Collection<GoodsType>> getWorkTypeChoices(Unit unit, boolean userMode) {
        Specification spec = this.getSpecification();
        ArrayList<Collection<GoodsType>> result = new ArrayList<Collection<GoodsType>>();
        HashSet<GoodsType> tried = new HashSet<GoodsType>();
        HashSet<GoodsType> food = new HashSet<GoodsType>();
        HashSet<GoodsType> nonFood = new HashSet<GoodsType>();
        for (AbstractGoods ag : CollectionUtils.transform(unit.getType().getConsumedGoods(), g -> this.productionCache.getNetProductionOf(g.getType()) < g.getAmount())) {
            if (ag.isFoodType()) {
                food.addAll(ag.getType().getEquivalentTypes());
                continue;
            }
            nonFood.addAll(ag.getType().getEquivalentTypes());
        }
        if (userMode) {
            this.accumulateChoice(unit.getWorkType(), tried, result);
            this.accumulateChoice(unit.getType().getExpertProduction(), tried, result);
            this.accumulateChoice(unit.getExperienceType(), tried, result);
            this.accumulateChoices(food, tried, result);
            this.accumulateChoices(nonFood, tried, result);
        } else {
            this.accumulateChoices(food, tried, result);
            this.accumulateChoices(nonFood, tried, result);
            this.accumulateChoice(unit.getWorkType(), tried, result);
            this.accumulateChoice(unit.getType().getExpertProduction(), tried, result);
            this.accumulateChoice(unit.getExperienceType(), tried, result);
        }
        this.accumulateChoices(spec.getFoodGoodsTypeList(), tried, result);
        this.accumulateChoices(spec.getNewWorldLuxuryGoodsTypeList(), tried, result);
        this.accumulateChoices(spec.getGoodsTypeList(), tried, result);
        return result;
    }

    private Occupation getOccupationFor(Unit unit, Collection<GoodsType> workTypes, LogBuilder lb) {
        if (workTypes.isEmpty()) {
            return null;
        }
        Occupation best = new Occupation(null, null, null);
        int bestAmount = 0;
        for (WorkLocation wl : this.getCurrentWorkLocationsList()) {
            bestAmount = best.improve(unit, wl, bestAmount, workTypes, lb);
        }
        if (best.workLocation != null) {
            lb.add("\n  => ", best, " = ", bestAmount);
        }
        return best.workLocation == null ? null : best;
    }

    private Occupation getOccupationFor(Unit unit, boolean userMode, LogBuilder lb) {
        for (Collection<GoodsType> types : this.getWorkTypeChoices(unit, userMode)) {
            lb.add("\n  ");
            FreeColObject.logFreeColObjects(types, lb);
            Occupation occupation = this.getOccupationFor(unit, types, lb);
            if (occupation == null) continue;
            return occupation;
        }
        lb.add("\n  => FAILED");
        return null;
    }

    private Occupation getOccupationFor(Unit unit, Collection<GoodsType> workTypes) {
        LogBuilder lb = new LogBuilder(this.getOccupationTrace() ? 64 : 0);
        lb.add(this.getName(), ".getOccupationFor(", unit, ", ");
        FreeColObject.logFreeColObjects(workTypes, lb);
        lb.add(")");
        Occupation occupation = this.getOccupationFor(unit, workTypes, lb);
        lb.log(logger, Level.WARNING);
        return occupation;
    }

    private Occupation getOccupationFor(Unit unit, boolean userMode) {
        LogBuilder lb = new LogBuilder(this.getOccupationTrace() ? 64 : 0);
        lb.add(this.getName(), ".getOccupationFor(", unit, ")");
        Occupation occupation = this.getOccupationFor(unit, userMode, lb);
        lb.log(logger, Level.WARNING);
        return occupation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkLocation> getAllWorkLocationsList() {
        ArrayList<WorkLocation> ret = new ArrayList<WorkLocation>();
        Object object = this.colonyTiles;
        synchronized (object) {
            ret.addAll(this.colonyTiles);
        }
        object = this.buildingMap;
        synchronized (object) {
            ret.addAll(this.buildingMap.values());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<WorkLocation> getAllWorkLocations() {
        Stream<WorkLocation> ret = Stream.empty();
        Object object = this.colonyTiles;
        synchronized (object) {
            ret = CollectionUtils.concat(ret, CollectionUtils.map(this.colonyTiles, Function.identity()));
        }
        object = this.buildingMap;
        synchronized (object) {
            ret = CollectionUtils.concat(ret, CollectionUtils.map(this.buildingMap.values(), Function.identity()));
        }
        return ret;
    }

    public List<WorkLocation> getAvailableWorkLocationsList() {
        return CollectionUtils.transform(this.getAllWorkLocations(), WorkLocation::isAvailable);
    }

    public Stream<WorkLocation> getAvailableWorkLocations() {
        return this.getAvailableWorkLocationsList().stream();
    }

    public List<WorkLocation> getCurrentWorkLocationsList() {
        return CollectionUtils.transform(this.getAllWorkLocations(), WorkLocation::isCurrent);
    }

    public Stream<WorkLocation> getCurrentWorkLocations() {
        return this.getCurrentWorkLocationsList().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBuilding(Building building) {
        if (building == null || building.getType() == null) {
            return false;
        }
        BuildingType buildingType = building.getType().getFirstLevel();
        if (buildingType == null || buildingType.getId() == null) {
            return false;
        }
        Map<String, Building> map = this.buildingMap;
        synchronized (map) {
            this.buildingMap.put(buildingType.getId(), building);
        }
        this.addFeatures(building.getType());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        Map<String, Building> map = this.buildingMap;
        synchronized (map) {
            if (this.buildingMap.remove(buildingType.getId()) == null) {
                return false;
            }
        }
        this.removeFeatures(building.getType());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColonyTile(ColonyTile ct) {
        if (ct == null) {
            return;
        }
        List<ColonyTile> list = this.colonyTiles;
        synchronized (list) {
            this.colonyTiles.add(ct);
        }
    }

    public WorkLocation getWorkLocationWithAbility(String ability) {
        return CollectionUtils.find(this.getCurrentWorkLocations(), wl -> wl.hasAbility(ability));
    }

    public <T extends WorkLocation> T getWorkLocationWithAbility(String ability, Class<T> returnClass) {
        WorkLocation wl = this.getWorkLocationWithAbility(ability);
        try {
            if (wl != null) {
                return (T)((WorkLocation)returnClass.cast(wl));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public WorkLocation getWorkLocationWithModifier(String modifier) {
        return CollectionUtils.find(this.getCurrentWorkLocations(), wl -> wl.hasModifier(modifier));
    }

    public <T extends WorkLocation> T getWorkLocationWithModifier(String modifier, Class<T> returnClass) {
        WorkLocation wl = this.getWorkLocationWithModifier(modifier);
        if (wl != null) {
            try {
                return (T)((WorkLocation)returnClass.cast(wl));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<WorkLocation> getWorkLocationsForConsuming(GoodsType goodsType) {
        return CollectionUtils.transform(this.getCurrentWorkLocations(), wl -> CollectionUtils.any(wl.getInputs(), AbstractGoods.matches(goodsType)));
    }

    public List<WorkLocation> getWorkLocationsForProducing(GoodsType goodsType) {
        return CollectionUtils.transform(this.getCurrentWorkLocations(), wl -> CollectionUtils.any(wl.getOutputs(), AbstractGoods.matches(goodsType)));
    }

    public WorkLocation getWorkLocationForProducing(GoodsType goodsType) {
        return CollectionUtils.first(this.getWorkLocationsForProducing(goodsType));
    }

    public WorkLocation getWorkLocationFor(Unit unit, GoodsType goodsType) {
        if (goodsType == null) {
            return this.getWorkLocationFor(unit);
        }
        Occupation occupation = this.getOccupationFor(unit, goodsType.getEquivalentTypes());
        return occupation == null ? null : occupation.workLocation;
    }

    public WorkLocation getWorkLocationFor(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit, false);
        return occupation == null ? null : occupation.workLocation;
    }

    public boolean isTileInUse(Tile tile) {
        ColonyTile colonyTile = this.getColonyTile(tile);
        return colonyTile != null && !colonyTile.isEmpty();
    }

    public Building getWarehouse() {
        return this.getWorkLocationWithModifier("model.modifier.warehouseStorage", Building.class);
    }

    public boolean hasStockade() {
        return this.getStockade() != null;
    }

    public Building getStockade() {
        return this.getWorkLocationWithModifier("model.modifier.defence", Building.class);
    }

    public String getStockadeKey() {
        Building stockade = this.getStockade();
        return stockade == null ? null : stockade.getType().getSuffix();
    }

    public Stream<RandomChoice<Disaster>> getDisasterChoices() {
        return CollectionUtils.flatten(this.getColonyTiles(), ct -> ct.getWorkTile().getDisasterChoices());
    }

    public boolean isAutomaticBuild(BuildingType buildingType) {
        float value = this.owner.apply(100.0f, this.getGame().getTurn(), "model.modifier.buildingPriceBonus", buildingType);
        return value == 0.0f && this.canBuild(buildingType);
    }

    public List<UnitType> getBuildableUnits() {
        return CollectionUtils.transform(this.getSpecification().getUnitTypeList(), ut -> ut.needsGoodsToBuild() && this.canBuild((BuildableType)ut));
    }

    public int getTurnsToComplete(BuildableType buildable) {
        return this.getTurnsToComplete(buildable, null);
    }

    public int getTurnsToComplete(BuildableType buildable, AbstractGoods needed) {
        List<AbstractGoods> required = buildable.getRequiredGoodsList();
        int turns = 0;
        int satisfied = 0;
        int failing = 0;
        int underway = 0;
        ProductionInfo info = this.productionCache.getProductionInfo(this.buildQueue);
        for (AbstractGoods ag : required) {
            AbstractGoods consumption;
            GoodsType type = ag.getType();
            int amountNeeded = ag.getAmount();
            int amountAvailable = this.getGoodsCount(type);
            if (amountAvailable >= amountNeeded) {
                ++satisfied;
                continue;
            }
            int production = this.productionCache.getNetProductionOf(type);
            if (info != null && (consumption = CollectionUtils.find(info.getConsumption(), AbstractGoods.matches(type))) != null) {
                production += consumption.getAmount();
            }
            if (production <= 0) {
                ++failing;
                if (needed == null) continue;
                needed.setType(type);
                needed.setAmount(amountNeeded - amountAvailable);
                continue;
            }
            ++underway;
            int amountRemaining = amountNeeded - amountAvailable;
            int eta = amountRemaining / production;
            if (amountRemaining % production != 0) {
                ++eta;
            }
            turns = Math.max(turns, eta);
        }
        return satisfied + underway == required.size() ? turns : (failing == required.size() ? Integer.MIN_VALUE : -(turns + 1));
    }

    public boolean canBreed(GoodsType goodsType) {
        int breedingNumber = goodsType.getBreedingNumber();
        return breedingNumber < Integer.MAX_VALUE && breedingNumber <= this.getGoodsCount(goodsType);
    }

    public BuildableType getCurrentlyBuilding() {
        return this.buildQueue.getCurrentlyBuilding();
    }

    public void setCurrentlyBuilding(BuildableType buildable) {
        this.buildQueue.setCurrentlyBuilding(buildable);
    }

    public boolean canBuild() {
        return this.canBuild(this.getCurrentlyBuilding());
    }

    public boolean canBuild(BuildableType buildableType) {
        return this.getNoBuildReason(buildableType, null) == NoBuildReason.NONE;
    }

    public NoBuildReason getNoBuildReason(BuildableType buildableType, List<BuildableType> assumeBuilt) {
        if (buildableType == null) {
            return NoBuildReason.NOT_BUILDING;
        }
        if (!buildableType.needsGoodsToBuild()) {
            return NoBuildReason.NOT_BUILDABLE;
        }
        if (buildableType.getRequiredPopulation() > this.getUnitCount()) {
            return NoBuildReason.POPULATION_TOO_SMALL;
        }
        if (buildableType.hasAbility("model.ability.coastalOnly") && !this.getTile().isCoastland()) {
            return NoBuildReason.COASTAL;
        }
        if (CollectionUtils.any(buildableType.getRequiredAbilities().entrySet(), e -> ((Boolean)e.getValue()).booleanValue() != this.hasAbility((String)e.getKey()))) {
            return NoBuildReason.MISSING_ABILITY;
        }
        if (!CollectionUtils.all(buildableType.getLimits(), l -> l.evaluate(this))) {
            return NoBuildReason.LIMIT_EXCEEDED;
        }
        if (assumeBuilt == null) {
            assumeBuilt = Collections.emptyList();
        }
        return buildableType.canBeBuiltInColony(this.getColony(), assumeBuilt);
    }

    public int getPriceForBuilding() {
        return this.getPriceForBuilding(this.getCurrentlyBuilding());
    }

    public int getPriceForBuilding(BuildableType type) {
        return this.priceGoodsForBuilding(this.getRequiredGoods(type));
    }

    public int priceGoodsForBuilding(List<AbstractGoods> required) {
        Market market = this.getOwner().getMarket();
        return CollectionUtils.sum(required, ag -> ag.getType().isStorable() ? market.getBidPrice(ag.getType(), ag.getAmount()) * 110 / 100 : ag.getType().getPrice() * ag.getAmount());
    }

    public List<AbstractGoods> getRequiredGoods(BuildableType type) {
        return CollectionUtils.transform(type.getRequiredGoods(), ag -> ag.getAmount() > this.getGoodsCount(ag.getType()), ag -> new AbstractGoods(ag.getType(), ag.getAmount() - this.getGoodsCount(ag.getType())));
    }

    public List<AbstractGoods> getFullRequiredGoods(BuildableType buildable) {
        if (buildable == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractGoods> required = new ArrayList<AbstractGoods>();
        for (AbstractGoods ag : buildable.getRequiredGoodsList()) {
            int amount = ag.getAmount();
            for (GoodsType type = ag.getType(); type != null && amount > this.getGoodsCount(type); type = type.getInputType()) {
                required.add(0, new AbstractGoods(type, amount - this.getGoodsCount(type)));
            }
        }
        return required;
    }

    public boolean canPayToFinishBuilding() {
        return this.canPayToFinishBuilding(this.getCurrentlyBuilding());
    }

    public boolean canPayToFinishBuilding(BuildableType buildableType) {
        return buildableType != null && this.getOwner().checkGold(this.getPriceForBuilding(buildableType));
    }

    public void addLiberty(int amount) {
        List<GoodsType> libertyTypeList = this.getSpecification().getLibertyGoodsTypeList();
        int uc = this.getUnitCount();
        if (amount > 0 && !libertyTypeList.isEmpty() && Colony.calculateRebels(uc, this.sonsOfLiberty) <= uc + 1) {
            this.addGoods(libertyTypeList.get(0), amount);
        }
        this.updateSoL();
        this.updateProductionBonus();
    }

    public void modifyLiberty(int amount) {
        this.getOwner().modifyLiberty(amount);
        this.liberty += amount;
        this.liberty = Math.max(0, this.liberty);
        this.updateSoL();
        this.updateProductionBonus();
        boolean capped = this.getSpecification().getBoolean("model.option.bellAccumulationCapped");
        if (capped && this.sonsOfLiberty >= 100) {
            this.liberty = 200 * this.getUnitCount();
        }
    }

    public void updateSoL() {
        int uc = this.getUnitCount();
        this.oldSonsOfLiberty = this.sonsOfLiberty;
        this.oldTories = this.tories;
        this.sonsOfLiberty = this.calculateSoLPercentage(uc, this.getLiberty());
        this.tories = uc - Colony.calculateRebels(uc, this.sonsOfLiberty);
    }

    private int calculateSoLPercentage(int uc, int liberty) {
        if (uc <= 0) {
            return -1;
        }
        float membership = (float)liberty * 100.0f / (float)(200 * uc);
        if ((membership = Colony.applyModifiers(membership, this.getGame().getTurn(), this.getOwner().getModifiers("model.modifier.SoL"))) < 0.0f) {
            membership = 0.0f;
        } else if (membership > 100.0f) {
            membership = 100.0f;
        }
        return (int)membership;
    }

    public int getSoLPercentage() {
        return this.calculateSoLPercentage(this.getUnitCount(), this.getLiberty());
    }

    public static int calculateRebels(int uc, int solPercent) {
        return (int)Math.floor(0.01 * (double)solPercent * (double)uc);
    }

    public int getTory() {
        return 100 - this.getSoL();
    }

    protected boolean updateProductionBonus() {
        int newBonus;
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int n = this.sonsOfLiberty >= veryGoodGovernment ? 2 : (this.sonsOfLiberty >= goodGovernment ? 1 : (this.tories > veryBadGovernment ? -2 : (newBonus = this.tories > badGovernment ? -1 : 0)));
        if (this.productionBonus != newBonus) {
            this.invalidateCache();
            this.setProductionBonus(newBonus);
            return true;
        }
        return false;
    }

    public int getPreferredSizeChange() {
        return this.productionBonus < 0 ? -this.getUnitsToRemove() : this.getUnitsToAdd();
    }

    public int getUnitsToAdd() {
        int pop = this.getUnitCount();
        for (int i = 1; i <= 10; ++i) {
            if (this.governmentChange(pop + i) != -1) continue;
            return i - 1;
        }
        return 10;
    }

    public int getUnitsToRemove() {
        int pop = this.getUnitCount();
        for (int i = 1; i < pop; ++i) {
            if (this.governmentChange(pop - i) != 1) continue;
            return i;
        }
        return 0;
    }

    public boolean joinColony(Unit unit) {
        boolean ret;
        Occupation occupation = this.getOccupationFor(unit, false);
        if (occupation == null) {
            if (!this.traceOccupation) {
                LogBuilder lb = new LogBuilder(64);
                this.getOccupationFor(unit, false, lb);
                lb.log(logger, Level.WARNING);
            }
            ret = false;
        } else {
            ret = occupation.install(unit);
        }
        if (!ret) {
            unit.setLocation(this.getTile());
            logger.warning("Failed to join " + this.getName() + ": " + unit);
        }
        return ret;
    }

    public boolean canReducePopulation() {
        return (float)this.getUnitCount() > this.apply(0.0f, this.getGame().getTurn(), "model.modifier.minimumColonySize");
    }

    public StringTemplate getReducePopulationMessage() {
        if (this.canReducePopulation()) {
            return null;
        }
        Modifier min = CollectionUtils.first(this.getModifiers("model.modifier.minimumColonySize"));
        if (min == null) {
            return null;
        }
        FreeColObject source = min.getSource();
        if (source instanceof BuildingType) {
            source = this.getBuilding((BuildingType)source).getType();
        }
        return StringTemplate.template("model.colony.minimumColonySize").addName("%object%", source);
    }

    public ModelMessage getUnbuildableMessage(BuildableType buildable) {
        return (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.unbuildable", this, buildable).addName("%colony%", this.getName())).addNamed("%object%", buildable);
    }

    public int governmentChange(int unitCount) {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int rebelPercent = this.calculateSoLPercentage(unitCount, this.getLiberty());
        int rebelCount = Colony.calculateRebels(unitCount, rebelPercent);
        int loyalistCount = unitCount - rebelCount;
        int result = 0;
        if (rebelPercent >= veryGoodGovernment) {
            if (this.sonsOfLiberty < veryGoodGovernment) {
                result = 1;
            }
        } else if (rebelPercent >= goodGovernment) {
            if (this.sonsOfLiberty >= veryGoodGovernment) {
                result = -1;
            } else if (this.sonsOfLiberty < goodGovernment) {
                result = 1;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            result = -1;
        } else if (loyalistCount > veryBadGovernment) {
            if (this.tories <= veryBadGovernment) {
                result = -1;
            }
        } else if (loyalistCount > badGovernment) {
            if (this.tories <= badGovernment) {
                result = -1;
            } else if (this.tories > veryBadGovernment) {
                result = 1;
            }
        } else if (this.tories > badGovernment) {
            result = 1;
        }
        return result;
    }

    public ModelMessage checkForGovMgtChangeMessage() {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        String msgId = null;
        int number = 0;
        ModelMessage.MessageType msgType = ModelMessage.MessageType.GOVERNMENT_EFFICIENCY;
        if (this.sonsOfLiberty >= veryGoodGovernment) {
            if (this.oldSonsOfLiberty < veryGoodGovernment) {
                msgId = "model.colony.veryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            if (this.oldSonsOfLiberty == veryGoodGovernment) {
                msgId = "model.colony.lostVeryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            } else if (this.oldSonsOfLiberty < goodGovernment) {
                msgId = "model.colony.goodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
        } else {
            if (this.oldSonsOfLiberty >= goodGovernment) {
                msgId = "model.colony.lostGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
            if (this.tories > veryBadGovernment) {
                if (this.oldTories <= veryBadGovernment) {
                    msgId = "model.colony.veryBadGovernment";
                }
            } else if (this.tories > badGovernment) {
                if (this.oldTories <= badGovernment) {
                    msgId = "model.colony.badGovernment";
                } else if (this.oldTories > veryBadGovernment) {
                    msgId = "model.colony.governmentImproved1";
                }
            } else if (this.oldTories > badGovernment) {
                msgId = "model.colony.governmentImproved2";
            }
        }
        GoodsType bells = this.getSpecification().getGoodsType("model.goods.bells");
        return msgId == null ? null : (ModelMessage)((StringTemplate)new ModelMessage(msgType, msgId, this, bells).addName("%colony%", this.getName())).addAmount("%number%", number);
    }

    public void updatePopulation() {
        this.updateSoL();
        this.updateProductionBonus();
        if (this.getOwner().isAI()) {
            this.firePropertyChange(REARRANGE_COLONY, true, false);
        }
    }

    public void updateEducation(Unit unit, boolean enable) {
        WorkLocation wl = unit.getWorkLocation();
        if (wl == null) {
            throw new RuntimeException("updateEducation(" + unit + ") unit not at work location.");
        }
        if (wl.getColony() != this) {
            throw new RuntimeException("updateEducation(" + unit + ") unit not at work location in this colony.");
        }
        if (enable) {
            if (wl.canTeach()) {
                Unit student = unit.getStudent();
                if (student == null && (student = this.findStudent(unit)) != null) {
                    unit.setStudent(student);
                    student.setTeacher(unit);
                    unit.setTurnsOfTraining(0);
                    unit.changeWorkType(null);
                }
            } else {
                Unit teacher = unit.getTeacher();
                if (teacher == null && (teacher = this.findTeacher(unit)) != null) {
                    unit.setTeacher(teacher);
                    teacher.setStudent(unit);
                }
            }
        } else if (wl.canTeach()) {
            Unit student = unit.getStudent();
            if (student != null) {
                student.setTeacher(null);
                unit.setStudent(null);
                unit.setTurnsOfTraining(0);
            }
        } else {
            Unit teacher = unit.getTeacher();
            if (teacher != null) {
                teacher.setStudent(null);
                unit.setTeacher(null);
            }
        }
    }

    public boolean isUndead() {
        Unit u = this.getFirstUnit();
        return u != null && u.isUndead();
    }

    public int getApparentUnitCount() {
        return this.displayUnitCount > 0 ? this.displayUnitCount : this.getUnitCount();
    }

    public UnitType getBestDefenderType() {
        Predicate<UnitType> defenderPred = ut -> ut.getDefence() > 0.0 && !ut.isNaval() && ut.isAvailableTo(this.getOwner());
        return CollectionUtils.maximize(this.getSpecification().getUnitTypeList(), defenderPred, UnitType.defenceComparator);
    }

    public double getTotalDefencePower() {
        CombatModel cm = this.getGame().getCombatModel();
        return CollectionUtils.sumDouble(this.getTile().getUnits(), Unit::isDefensiveUnit, u -> cm.getDefencePower(null, (FreeColGameObject)u));
    }

    public boolean canBePillaged(Unit attacker) {
        return !this.hasStockade() && attacker.hasAbility("model.ability.pillageUnprotectedColony") && (!this.getBurnableBuildings().isEmpty() || !this.getTile().getNavalUnits().isEmpty() || !this.getLootableGoodsList().isEmpty() && attacker.getType().canCarryGoods() && attacker.hasSpaceLeft() || this.canBePlundered());
    }

    public boolean canBePlundered() {
        return this.owner.checkGold(1);
    }

    public List<Building> getBurnableBuildings() {
        return CollectionUtils.transform(this.getBuildings(), Building::canBeDamaged);
    }

    public List<Goods> getLootableGoodsList() {
        return CollectionUtils.transform(this.getGoodsList(), AbstractGoods::isStorable);
    }

    public boolean isUnderSiege() {
        int friendlyUnits = 0;
        int enemyUnits = 0;
        for (Unit u : CollectionUtils.iterable(CollectionUtils.flatten(this.getColonyTiles(), ct -> ct.getWorkTile().getUnits()))) {
            if (u.getOwner() == this.getOwner()) {
                if (!u.isDefensiveUnit()) continue;
                ++friendlyUnits;
                continue;
            }
            if (!this.getOwner().atWarWith(u.getOwner()) || !u.isOffensiveUnit()) continue;
            ++enemyUnits;
        }
        return enemyUnits > friendlyUnits;
    }

    public int evaluateFor(Player player) {
        int result;
        if (player.isAI() && player.owns(this) && player.getSettlementCount() < 5) {
            return Integer.MIN_VALUE;
        }
        if (player.owns(this)) {
            int v;
            result = 0;
            for (WorkLocation wl : this.getAvailableWorkLocationsList()) {
                v = wl.evaluateFor(player);
                if (v == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                result += v;
            }
            for (Unit u : this.getTile().getUnitList()) {
                v = u.evaluateFor(player);
                if (v == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                result += v;
            }
            for (Goods g : this.getCompactGoodsList()) {
                v = g.evaluateFor(player);
                if (v == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                result += v;
            }
        } else {
            result = this.getApparentUnitCount() * 1000 + 500 + 200 * CollectionUtils.count(this.getTile().getSurroundingTiles(0, 1), CollectionUtils.matchKey(this, Tile::getOwningSettlement));
            Building stockade = this.getStockade();
            if (stockade != null) {
                result *= stockade.getLevel();
            }
        }
        return result;
    }

    public boolean canTrain(Unit unit) {
        return this.canTrain(unit.getType());
    }

    public boolean canTrain(UnitType unitType) {
        return this.hasAbility("model.ability.teach") && CollectionUtils.any(this.getBuildings(), b -> b.canTeach() && b.canAddType(unitType));
    }

    public Stream<Unit> getTeachers() {
        return CollectionUtils.flatten(this.getBuildings(), WorkLocation::canTeach, UnitLocation::getUnits);
    }

    public Unit findTeacher(Unit student) {
        return this.getSpecification().getBoolean("model.option.allowStudentSelection") ? null : CollectionUtils.find(this.getTeachers(), u -> u.getStudent() == null && student.canBeStudent((Unit)u));
    }

    public Unit findStudent(Unit teacher) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        GoodsType expertProduction = teacher.getType().getExpertProduction();
        Predicate<Unit> teacherPred = u -> u.getTeacher() == null && u.canBeStudent(teacher);
        Comparator<Unit> skillComparator = Comparator.comparingInt(Unit::getSkillLevel);
        Comparator<Unit> tradeComparator = Comparator.comparingInt(u -> u.getWorkType() == expertProduction ? 0 : 1);
        Comparator<Unit> fullComparator = skillComparator.thenComparing(tradeComparator);
        return CollectionUtils.minimize(this.getUnits(), teacherPred, fullComparator);
    }

    public boolean isProducing(GoodsType goodsType) {
        return this.productionCache.isProducing(goodsType);
    }

    public boolean isConsuming(GoodsType goodsType) {
        return this.productionCache.isConsuming(goodsType);
    }

    public List<Consumer> getConsumers() {
        ArrayList<Consumer> result = new ArrayList<Consumer>();
        result.addAll(this.getUnitList());
        result.addAll(this.getBuildings());
        result.add(this.buildQueue);
        result.add(this.populationQueue);
        result.sort(Consumer.COMPARATOR);
        return result;
    }

    @Override
    public int getConsumptionOf(GoodsType goodsType) {
        Specification spec = this.getSpecification();
        int result = super.getConsumptionOf(goodsType);
        if (spec.getGoodsType("model.goods.bells").equals(goodsType)) {
            result -= spec.getInteger("model.option.unitsThatUseNoBells");
        }
        return Math.max(0, result);
    }

    public int getFoodProduction() {
        return CollectionUtils.sum(this.getSpecification().getFoodGoodsTypeList(), ft -> this.getTotalProductionOf((GoodsType)ft));
    }

    public int getStarvationTurns() {
        GoodsType foodType = this.getSpecification().getPrimaryFoodType();
        int food = this.getGoodsCount(foodType);
        int newFood = this.getAdjustedNetProductionOf(foodType);
        return newFood >= 0 ? -1 : food / -newFood;
    }

    public int getNewColonistTurns() {
        int newFood;
        GoodsType foodType = this.getSpecification().getPrimaryFoodType();
        int food = this.getGoodsCount(foodType);
        return food + (newFood = this.getAdjustedNetProductionOf(foodType)) >= 200 ? 1 : (newFood <= 0 ? -1 : (200 - food) / newFood + 1);
    }

    public Stream<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType, WorkLocation wl) {
        if (this.productionBonus == 0) {
            return Stream.empty();
        }
        int bonus = (int)Math.floor((float)this.productionBonus * wl.getRebelFactor());
        Modifier mod = new Modifier(goodsType.getId(), bonus, Modifier.ModifierType.ADDITIVE, Specification.SOL_MODIFIER_SOURCE);
        mod.setModifierIndex(20);
        return Stream.of(mod);
    }

    public int getNetProductionOf(GoodsType goodsType) {
        return this.productionCache.getNetProductionOf(goodsType);
    }

    public boolean isProductive(WorkLocation workLocation) {
        ProductionInfo info = this.productionCache.getProductionInfo(workLocation);
        return info != null && info.getProduction() != null && !info.getProduction().isEmpty() && info.getProduction().get(0).getAmount() > 0;
    }

    public int getAdjustedNetProductionOf(GoodsType goodsType) {
        ToIntFunction<BuildQueue> consumes = q -> {
            ProductionInfo pi = this.productionCache.getProductionInfo(q);
            return pi == null ? 0 : AbstractGoods.getCount(goodsType, pi.getConsumption());
        };
        return this.productionCache.getNetProductionOf(goodsType) + CollectionUtils.sum(Stream.of(this.buildQueue, this.populationQueue), consumes);
    }

    protected TypeCountMap<GoodsType> getProductionMap() {
        return this.productionCache.getProductionMap();
    }

    public ProductionInfo getProductionInfo(Object object) {
        return this.productionCache.getProductionInfo(object);
    }

    public void updateProductionTypes() {
        for (WorkLocation wl : this.getAvailableWorkLocationsList()) {
            wl.updateProductionType();
        }
    }

    public boolean canProduce(GoodsType goodsType) {
        return this.getNetProductionOf(goodsType) > 0 ? true : (goodsType.isBreedable() ? this.getGoodsCount(goodsType) >= goodsType.getBreedingNumber() : CollectionUtils.any(this.getWorkLocationsForProducing(goodsType), wl -> wl.getGenericPotential(goodsType) > 0 && CollectionUtils.all(wl.getInputs(), ag -> this.canProduce(ag.getType()))));
    }

    public List<TileImprovementSuggestion> getTileImprovementSuggestions() {
        Specification spec = this.getSpecification();
        List<TileImprovementSuggestion> result = CollectionUtils.transform(this.getTile().getSurroundingTiles(1, 1), Tile::hasLostCityRumour, t -> new TileImprovementSuggestion((Tile)t, null, Integer.MAX_VALUE));
        for (ColonyTile ct : CollectionUtils.transform(this.getColonyTiles(), WorkLocation::isAvailable)) {
            ToIntFunction<TileImprovementType> improve = CollectionUtils.cacheInt(ti -> ct.improvedBy((TileImprovementType)ti));
            result.addAll(CollectionUtils.transform(spec.getTileImprovementTypeList(), ti -> !ti.isNatural() && improve.applyAsInt((TileImprovementType)ti) > 0, ti -> new TileImprovementSuggestion(ct.getWorkTile(), (TileImprovementType)ti, improve.applyAsInt((TileImprovementType)ti))));
        }
        result.sort(TileImprovementSuggestion.descendingAmountComparator);
        return result;
    }

    public Unit getBetterExpert(Unit expert) {
        GoodsType production = expert.getWorkType();
        UnitType expertType = expert.getType();
        GoodsType expertise = expertType.getExpertProduction();
        Unit bestExpert = null;
        int bestImprovement = 0;
        if (production == null || expertise == null || production == expertise) {
            return null;
        }
        for (Unit nonExpert : CollectionUtils.transform(this.getUnits(), u -> u.getWorkType() == expertise && u.getType() != expertType)) {
            int improvement;
            WorkLocation nwl;
            int expertProductionNow = 0;
            int nonExpertProductionNow = 0;
            int expertProductionPotential = 0;
            int nonExpertProductionPotential = 0;
            WorkLocation ewl = expert.getWorkLocation();
            if (ewl != null) {
                expertProductionNow = ewl.getPotentialProduction(expertise, expert.getType());
                nonExpertProductionPotential = ewl.getPotentialProduction(expertise, nonExpert.getType());
            }
            if ((nwl = nonExpert.getWorkLocation()) != null) {
                nonExpertProductionNow = nwl.getPotentialProduction(expertise, nonExpert.getType());
                expertProductionPotential = nwl.getPotentialProduction(expertise, expertType);
            }
            if ((improvement = expertProductionPotential + nonExpertProductionPotential - expertProductionNow - nonExpertProductionNow) <= bestImprovement) continue;
            bestImprovement = improvement;
            bestExpert = nonExpert;
        }
        return bestExpert;
    }

    public Collection<StringTemplate> getProductionWarnings(GoodsType goodsType) {
        BuildableType currentlyBuilding;
        int amount = this.getGoodsCount(goodsType);
        int production = this.getNetProductionOf(goodsType);
        ArrayList<StringTemplate> result = new ArrayList<StringTemplate>();
        if (goodsType.isStorable()) {
            int waste;
            if (goodsType.limitIgnored()) {
                if (goodsType.isFoodType()) {
                    int starve = this.getStarvationTurns();
                    if (starve == 0) {
                        result.add((StringTemplate)StringTemplate.template("model.colony.starving").addName("%colony%", this.getName()));
                    } else if (starve <= 3) {
                        result.add((StringTemplate)((StringTemplate)StringTemplate.template("model.colony.famineFeared").addName("%colony%", this.getName())).addAmount("%number%", starve));
                    }
                }
            } else if (!this.getExportData(goodsType).getExported() && (waste = amount + production - this.getWarehouseCapacity()) > 0) {
                result.add((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("model.building.warehouseSoonFull").addNamed("%goods%", goodsType)).addName("%colony%", this.getName())).addAmount("%amount%", waste));
            }
        }
        if ((currentlyBuilding = this.getCurrentlyBuilding()) != null) {
            Function<AbstractGoods, StringTemplate> bMapper = ag -> ((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("model.colony.buildableNeedsGoods").addName("%colony%", this.getName())).addNamed("%buildable%", currentlyBuilding)).addAmount("%amount%", ag.getAmount() - amount)).addNamed("%goodsType%", goodsType);
            result.addAll(CollectionUtils.transform(currentlyBuilding.getRequiredGoods(), ag -> ag.getType() == goodsType && amount < ag.getAmount(), bMapper));
        }
        Function<WorkLocation, ProductionInfo> piMapper = wl -> this.getProductionInfo(wl);
        Predicate<WorkLocation> prodPred = CollectionUtils.isNotNull(piMapper);
        Function<WorkLocation, StringTemplate> pMapper = wl -> this.getInsufficientProductionMessage(this.getProductionInfo(wl), wl.getProductionDeficit(goodsType));
        result.addAll(CollectionUtils.transform(this.getWorkLocationsForProducing(goodsType), prodPred, pMapper, CollectionUtils.toListNoNulls()));
        Function<WorkLocation, List> cMapper = wl -> {
            ProductionInfo info = this.getProductionInfo(wl);
            Function<AbstractGoods, StringTemplate> gMapper = ag -> this.getInsufficientProductionMessage(info, wl.getProductionDeficit(ag.getType()));
            return CollectionUtils.transform(wl.getOutputs(), AbstractGoods::isStorable, gMapper, CollectionUtils.toListNoNulls());
        };
        result.addAll(CollectionUtils.transform(this.getWorkLocationsForConsuming(goodsType), prodPred, cMapper, CollectionUtils.toAppendedList()));
        return result;
    }

    private StringTemplate getInsufficientProductionMessage(ProductionInfo info, AbstractGoods deficit) {
        if (info == null || deficit == null) {
            return null;
        }
        List<AbstractGoods> input = info.getConsumptionDeficit();
        if (input.isEmpty()) {
            return null;
        }
        StringTemplate label = StringTemplate.label(", ");
        for (AbstractGoods ag : input) {
            label.addStringTemplate(ag.getLabel());
        }
        return ((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("model.colony.insufficientProduction").addName("%colony%", this.getName())).addNamed("%outputType%", deficit.getType())).addAmount("%outputAmount%", deficit.getAmount())).addStringTemplate("%consumptionDeficit%", label);
    }

    public boolean goodsUseful(GoodsType goodsType) {
        return this.getOwner().getPlayerType() != Player.PlayerType.INDEPENDENT || (!goodsType.isLibertyType() || this.getSoLPercentage() < 100) && !goodsType.isImmigrationType();
    }

    private void modifySpecialGoods(GoodsType goodsType, int amount) {
        Turn turn = this.getGame().getTurn();
        List<Modifier> mods = CollectionUtils.toList(goodsType.getModifiers("model.modifier.liberty"));
        if (!mods.isEmpty()) {
            this.modifyLiberty((int)Colony.applyModifiers((float)amount, turn, mods));
        }
        if (!(mods = CollectionUtils.toList(goodsType.getModifiers("model.modifier.immigration"))).isEmpty()) {
            int migration = (int)Colony.applyModifiers((float)amount, turn, mods);
            this.modifyImmigration(migration);
            this.getOwner().modifyImmigration(migration);
        }
    }

    public Colony copyColony() {
        Game game = this.getGame();
        Tile tile = this.getTile();
        Tile tileCopy = (Tile)tile.copy(game);
        Colony colony = tileCopy.getColony();
        for (ColonyTile ct : colony.getColonyTiles()) {
            Tile wt;
            if (ct.isColonyCenterTile()) {
                wt = tileCopy;
            } else {
                wt = ct.getWorkTile();
                if ((wt = (Tile)wt.copy(game)).getOwningSettlement() == this) {
                    wt.setOwningSettlement(colony);
                }
            }
            ct.setWorkTile(wt);
        }
        return colony;
    }

    public <T extends FreeColObject> T getCorresponding(T fco) {
        String id = fco.getId();
        return (T)(fco instanceof WorkLocation ? (FreeColObject)CollectionUtils.find(this.getAllWorkLocations(), CollectionUtils.matchKeyEquals(id, FreeColObject::getId)) : (fco instanceof Tile ? (this.getTile().getId().equals(id) ? this.getTile() : CollectionUtils.find(CollectionUtils.map(this.getColonyTiles(), ColonyTile::getWorkTile), CollectionUtils.matchKeyEquals(id, FreeColObject::getId))) : (fco instanceof Unit ? (FreeColObject)CollectionUtils.find(this.getAllUnitsList(), CollectionUtils.matchKeyEquals(id, FreeColObject::getId)) : null)));
    }

    @Override
    public Stream<Ability> getAbilities(String id, FreeColSpecObjectType type, Turn turn) {
        if (turn == null) {
            turn = this.getGame().getTurn();
        }
        return CollectionUtils.concat(super.getAbilities(id, type, turn), this.owner == null ? Stream.empty() : this.owner.getAbilities(id, type, turn));
    }

    @Override
    public Stream<FreeColGameObject> getDisposables() {
        return CollectionUtils.concat(CollectionUtils.flatten(this.getAllWorkLocations(), UnitLocation::getDisposables), super.getDisposables());
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        String name = this.getName();
        return StringTemplate.name(name == null ? "?" : name);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.joinColony((Unit)locatable);
        }
        return super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            WorkLocation wl;
            Location loc = locatable.getLocation();
            if (loc instanceof WorkLocation && (wl = (WorkLocation)loc).getColony() == this) {
                return wl.remove(locatable);
            }
            return false;
        }
        return super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return CollectionUtils.any(this.getAvailableWorkLocations(), wl -> wl.contains(locatable));
        }
        return super.contains(locatable);
    }

    @Override
    public int getUnitCount() {
        return CollectionUtils.sum(this.getCurrentWorkLocations(), UnitLocation::getUnitCount);
    }

    @Override
    public Stream<Unit> getUnits() {
        return CollectionUtils.flatten(this.getCurrentWorkLocations(), UnitLocation::getUnits);
    }

    @Override
    public List<Unit> getUnitList() {
        return CollectionUtils.toList(this.getUnits());
    }

    @Override
    public final Colony getColony() {
        return this;
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public String toShortString() {
        return this.getName();
    }

    @Override
    public void invalidateCache() {
        this.productionCache.invalidate();
    }

    @Override
    public int getGoodsCapacity() {
        return (int)this.apply(0.0f, this.getGame().getTurn(), "model.modifier.warehouseStorage");
    }

    @Override
    public boolean addGoods(GoodsType type, int amount) {
        super.addGoods(type, amount);
        this.productionCache.invalidate(type);
        this.modifySpecialGoods(type, amount);
        return true;
    }

    @Override
    public Goods removeGoods(GoodsType type, int amount) {
        Goods removed = super.removeGoods(type, amount);
        this.productionCache.invalidate(type);
        if (removed != null) {
            this.modifySpecialGoods(type, -removed.getAmount());
        }
        return removed;
    }

    @Override
    public int getImmigration() {
        return this.immigration;
    }

    @Override
    public int getLiberty() {
        return this.liberty;
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        if (this.displayUnitCount > 0) {
            return null;
        }
        CombatModel cm = this.getGame().getCombatModel();
        Comparator<Unit> comp = CollectionUtils.cachingDoubleComparator(u -> cm.getDefencePower(attacker, (FreeColGameObject)u));
        return CollectionUtils.maximize(this.getUnits(), comp);
    }

    @Override
    public double getDefenceRatio() {
        return this.getTotalDefencePower() / (double)(1 + this.getUnitCount());
    }

    @Override
    public boolean isBadlyDefended() {
        return this.getTotalDefencePower() < 0.95 * (double)this.getUnitCount() - 2.5;
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        int upper;
        if (this.canBePlundered() && (upper = this.owner.getGold() * (this.getUnitCount() + 1) / (this.owner.getColoniesPopulation() + 1)) > 0) {
            return new RandomRange(100, 1, upper + 1, 1);
        }
        return null;
    }

    @Override
    public int getSoL() {
        return this.sonsOfLiberty;
    }

    @Override
    public int getUpkeep() {
        return CollectionUtils.sum(this.getBuildings(), b -> b.getType().getUpkeep());
    }

    @Override
    public int getTotalProductionOf(GoodsType goodsType) {
        return CollectionUtils.sum(this.getCurrentWorkLocations(), wl -> wl.getTotalProductionOf(goodsType));
    }

    @Override
    public boolean canProvideGoods(List<AbstractGoods> requiredGoods) {
        BuildableType buildable = this.getCurrentlyBuilding();
        for (AbstractGoods goods : requiredGoods) {
            int available = this.getGoodsCount(goods.getType());
            int breedingNumber = goods.getType().getBreedingNumber();
            if (breedingNumber != Integer.MAX_VALUE) {
                available -= breedingNumber;
            }
            if (buildable != null) {
                available -= AbstractGoods.getCount(goods.getType(), buildable.getRequiredGoodsList());
            }
            if (available >= goods.getAmount()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasContacted(Player player) {
        return player != null && (player.isEuropean() || this.getOwner().getStance(player) != Stance.UNCONTACTED);
    }

    @Override
    public StringTemplate getAlarmLevelLabel(Player player) {
        Stance stance = this.getOwner().getStance(player);
        return StringTemplate.template("model.colony." + stance.getKey()).addStringTemplate("%nation%", this.getOwner().getNationLabel());
    }

    @Override
    public int calculateSettlementValue(int value, Unit unit) {
        value += this.getUnitCount();
        if (this.hasStockade()) {
            value -= 200 * this.getStockade().getLevel();
        }
        return value;
    }

    private int returnPresent(GoodsType goodsType, int turns) {
        return Math.max(0, this.getGoodsCount(goodsType) + turns * this.getNetProductionOf(goodsType));
    }

    @Override
    public int getAvailableGoodsCount(GoodsType goodsType) {
        return this.getGoodsCount(goodsType);
    }

    @Override
    public int getExportAmount(GoodsType goodsType, int turns) {
        int present = this.returnPresent(goodsType, turns);
        ExportData ed = this.getExportData(goodsType);
        return Math.max(0, present - ed.getExportLevel());
    }

    @Override
    public int getImportAmount(GoodsType goodsType, int turns) {
        if (goodsType.limitIgnored()) {
            return 10000;
        }
        int present = this.returnPresent(goodsType, turns);
        ExportData ed = this.getExportData(goodsType);
        int capacity = ed.getEffectiveImportLevel(this.getWarehouseCapacity());
        return Math.max(0, capacity - present);
    }

    @Override
    public String getLocationName(TradeLocation tradeLocation) {
        Colony colony = (Colony)tradeLocation;
        return colony.getName();
    }

    @Override
    public boolean canBeInput() {
        return true;
    }

    protected void addPortAbility() {
        this.addAbility(new Ability("model.ability.hasPort"));
    }

    public Constants.IntegrityType checkBuildQueueIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = Constants.IntegrityType.INTEGRITY_GOOD;
        List<BuildableType> buildables = this.buildQueue.getValues();
        ArrayList<BuildableType> assumeBuilt = new ArrayList<BuildableType>();
        for (int i = 0; i < buildables.size(); ++i) {
            BuildableType bt = buildables.get(i);
            NoBuildReason reason = this.getNoBuildReason(bt, assumeBuilt);
            if (reason == NoBuildReason.NONE) {
                assumeBuilt.add(bt);
                continue;
            }
            if (fix) {
                if (lb != null) {
                    lb.add("\n  Invalid build queue item removed: ", bt.getId());
                }
                this.buildQueue.remove(i);
                result = result.fix();
                continue;
            }
            if (lb != null) {
                lb.add("\n  Invalid build queue item: ", bt.getId());
            }
            result = result.fail();
        }
        List<UnitType> unitTypes = this.populationQueue.getValues();
        assumeBuilt.clear();
        for (int i = 0; i < unitTypes.size(); ++i) {
            UnitType ut = unitTypes.get(i);
            NoBuildReason reason = this.getNoBuildReason(ut, assumeBuilt);
            if (reason == NoBuildReason.NONE) {
                assumeBuilt.add(ut);
                continue;
            }
            if (fix) {
                if (lb != null) {
                    lb.add("\n  Invalid population queue item removed: ", ut.getId());
                }
                this.populationQueue.remove(i);
                result = result.fix();
                continue;
            }
            if (lb != null) {
                lb.add("\n  Invalid population queue item: ", ut.getId());
            }
            result = result.fail();
        }
        return result;
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        return result.combine(this.checkBuildQueueIntegrity(fix, lb));
    }

    @Override
    public int getClassIndex() {
        return 20;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Colony o = this.copyInCast(other, Colony.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.setBuildingMap(game.update(o.getBuildings(), true));
        this.setColonyTiles(game.update(o.getColonyTiles(), true));
        this.setExportData(o.getExportData());
        this.liberty = o.getLiberty();
        this.sonsOfLiberty = o.getSonsOfLiberty();
        this.oldSonsOfLiberty = o.getOldSonsOfLiberty();
        this.tories = o.getTories();
        this.oldTories = o.getOldTories();
        this.productionBonus = o.getProductionBonus();
        this.immigration = o.getImmigration();
        this.established = o.getEstablished();
        this.setBuildQueue(o.getBuildQueue());
        this.setPopulationQueue(o.getPopulationQueue());
        this.displayUnitCount = o.getDisplayUnitCount();
        for (WorkLocation wl : this.getAllWorkLocationsList()) {
            wl.setColony(this);
        }
        this.invalidateCache();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NAME_TAG, this.getName());
        xw.writeAttribute(ESTABLISHED_TAG, this.established.getNumber());
        xw.writeAttribute(SONS_OF_LIBERTY_TAG, this.sonsOfLiberty);
        if (xw.validFor(this.getOwner())) {
            xw.writeAttribute(OLD_SONS_OF_LIBERTY_TAG, this.oldSonsOfLiberty);
            xw.writeAttribute(TORIES_TAG, this.tories);
            xw.writeAttribute(OLD_TORIES_TAG, this.oldTories);
            xw.writeAttribute(LIBERTY_TAG, this.liberty);
            xw.writeAttribute(IMMIGRATION_TAG, this.immigration);
            xw.writeAttribute(PRODUCTION_BONUS_TAG, this.productionBonus);
        } else {
            int uc = this.getApparentUnitCount();
            if (uc > 0) {
                xw.writeAttribute(UNIT_COUNT_TAG, uc);
            } else if (uc == 0) {
                FreeCol.trace(logger, "Unit count fail: " + uc + " id=" + this.getId() + " name=" + this.getName() + " unitCount=" + this.getUnitCount() + " displayUnitCount=" + this.displayUnitCount + " scope=" + xw.getWriteScope() + "/" + xw.getClientPlayer());
            }
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.getOwner())) {
            for (Map.Entry<String, ExportData> entry : CollectionUtils.mapEntriesByKey(this.exportData)) {
                entry.getValue().toXML(xw);
            }
            for (WorkLocation workLocation : CollectionUtils.sort(this.getAllWorkLocations())) {
                workLocation.toXML(xw);
            }
            for (BuildableType buildableType : this.buildQueue.getValues()) {
                xw.writeStartElement(BUILD_QUEUE_TAG);
                xw.writeAttribute("id", buildableType);
                xw.writeEndElement();
            }
            for (BuildableType buildableType : this.populationQueue.getValues()) {
                xw.writeStartElement(POPULATION_QUEUE_TAG);
                xw.writeAttribute("id", buildableType);
                xw.writeEndElement();
            }
        } else {
            Building stockade = this.getStockade();
            if (stockade != null) {
                stockade.toXML(xw);
            }
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.established = new Turn(xr.getAttribute(ESTABLISHED_TAG, 0));
        this.sonsOfLiberty = xr.getAttribute(SONS_OF_LIBERTY_TAG, 0);
        this.oldSonsOfLiberty = xr.getAttribute(OLD_SONS_OF_LIBERTY_TAG, 0);
        this.tories = xr.getAttribute(TORIES_TAG, 0);
        this.oldTories = xr.getAttribute(OLD_TORIES_TAG, 0);
        this.liberty = xr.getAttribute(LIBERTY_TAG, 0);
        this.immigration = xr.getAttribute(IMMIGRATION_TAG, 0);
        this.productionBonus = xr.getAttribute(PRODUCTION_BONUS_TAG, 0);
        this.displayUnitCount = xr.getAttribute(UNIT_COUNT_TAG, -1);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearBuildingMap();
        this.clearColonyTiles();
        this.exportData.clear();
        this.buildQueue.clear();
        this.populationQueue.clear();
        super.readChildren(xr);
        this.invalidateCache();
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (BUILD_QUEUE_TAG.equals(tag)) {
            BuildableType bt = xr.getType(spec, "id", BuildableType.class, null);
            if (bt != null) {
                this.buildQueue.add(bt);
            }
            xr.closeTag(BUILD_QUEUE_TAG);
        } else if (POPULATION_QUEUE_TAG.equals(xr.getLocalName())) {
            UnitType ut = xr.getType(spec, "id", UnitType.class, null);
            if (ut != null) {
                this.populationQueue.add(ut);
            }
            xr.closeTag(POPULATION_QUEUE_TAG);
        } else if ("building".equals(tag)) {
            this.addBuilding(xr.readFreeColObject(game, Building.class));
        } else if ("colonyTile".equals(tag)) {
            this.addColonyTile(xr.readFreeColObject(game, ColonyTile.class));
        } else if ("exportData".equals(tag)) {
            ExportData data = new ExportData(xr);
            this.setExportData(data);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static class TileImprovementSuggestion {
        public static final Comparator<TileImprovementSuggestion> descendingAmountComparator = Comparator.comparingInt(TileImprovementSuggestion::getAmount).reversed().thenComparing(tis -> tis.tile);
        public Tile tile;
        public TileImprovementType tileImprovementType;
        public int amount;

        public TileImprovementSuggestion(Tile tile, TileImprovementType t, int amount) {
            this.tile = tile;
            this.tileImprovementType = t;
            this.amount = amount;
        }

        public boolean isExploration() {
            return this.tileImprovementType == null;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static enum NoBuildReason {
        NONE,
        NOT_BUILDING,
        NOT_BUILDABLE,
        POPULATION_TOO_SMALL,
        MISSING_BUILD_ABILITY,
        MISSING_ABILITY,
        WRONG_UPGRADE,
        COASTAL,
        LIMIT_EXCEEDED;

    }

    public static enum ColonyChangeEvent {
        POPULATION_CHANGE,
        PRODUCTION_CHANGE,
        BONUS_CHANGE,
        WAREHOUSE_CHANGE,
        BUILD_QUEUE_CHANGE,
        UNIT_TYPE_CHANGE;

    }
}

