/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.text.View;
import org.gephi.ui.components.JHTMLEditorPane;
import org.gephi.ui.components.ReportSelection;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class SimpleHTMLReport
extends JDialog
implements Printable {
    private final String LAST_PATH = "SimpleHTMLReport_Save_Last_Path";
    private final String mHTMLReport;
    private JButton closeButton;
    private JButton copyButton;
    private JEditorPane displayPane;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JButton printButton;
    private JButton saveButton;

    public SimpleHTMLReport(Frame parent, String html) {
        super(parent, false);
        this.mHTMLReport = html;
        this.initComponents();
        this.displayPane.setContentType("text/html;");
        this.displayPane.setText(this.mHTMLReport);
        Dimension dimension = new Dimension(700, 600);
        this.setPreferredSize(dimension);
        this.displayPane.setCaretPosition(0);
        this.setTitle("HTML Report");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.displayPane = new JHTMLEditorPane();
        this.closeButton = new JButton();
        this.jToolBar1 = new JToolBar();
        this.printButton = new JButton();
        this.copyButton = new JButton();
        this.saveButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(SimpleHTMLReport.class, (String)"SimpleHTMLReport.title"));
        this.jScrollPane1.setViewportView(this.displayPane);
        this.closeButton.setText(NbBundle.getMessage(SimpleHTMLReport.class, (String)"SimpleHTMLReport.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHTMLReport.this.closeButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.printButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/print.png")));
        this.printButton.setText(NbBundle.getMessage(SimpleHTMLReport.class, (String)"SimpleHTMLReport.printButton.text"));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHTMLReport.this.printButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.printButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/copy.gif")));
        this.copyButton.setText(NbBundle.getMessage(SimpleHTMLReport.class, (String)"SimpleHTMLReport.copyButton.text"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHTMLReport.this.copyButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.copyButton);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/save.png")));
        this.saveButton.setText(NbBundle.getMessage(SimpleHTMLReport.class, (String)"SimpleHTMLReport.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleHTMLReport.this.saveButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.saveButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar1, -1, 194, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()).addComponent(this.jScrollPane1, -1, 279, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 23, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.closeButton).addComponent(this.jToolBar1, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat pf = pjob.defaultPage();
        pjob.setPrintable(this, pf);
        try {
            if (pjob.printDialog()) {
                pjob.print();
            }
        }
        catch (PrinterException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        final String html = this.mHTMLReport;
        String path = NbPreferences.forModule(SimpleHTMLReport.class).get("SimpleHTMLReport_Save_Last_Path", null);
        JFileChooser fileChooser = new JFileChooser(path);
        int result = fileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            final File destinationFolder = fileChooser.getSelectedFile();
            NbPreferences.forModule(SimpleHTMLReport.class).put("SimpleHTMLReport_Save_Last_Path", destinationFolder.getAbsolutePath());
            Thread saveReportThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SimpleHTMLReport.this.saveReport(html, destinationFolder)) {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SimpleHTMLReport.class, (String)"SimpleHTMLReport.status.saveSuccess", (Object)destinationFolder.getName()));
                        } else {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SimpleHTMLReport.class, (String)"SimpleHTMLReport.status.saveError", (Object)destinationFolder.getName()));
                        }
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            }, "SaveReportTask");
            saveReportThread.start();
        }
    }

    private boolean saveReport(String html, File destinationFolder) throws IOException {
        if (!destinationFolder.exists()) {
            destinationFolder.mkdir();
        } else if (!destinationFolder.isDirectory()) {
            return false;
        }
        String imgRegex = "<img[^>]+src\\s*=\\s*['\"]([^'\"]+)['\"][^>]*>";
        Pattern pattern = Pattern.compile(imgRegex, 2);
        Matcher matcher = pattern.matcher(html);
        StringBuffer replaceBuffer = new StringBuffer();
        while (matcher.find()) {
            File file;
            String fileAbsolutePath = matcher.group(1);
            if (fileAbsolutePath.startsWith("file:")) {
                fileAbsolutePath = fileAbsolutePath.replaceFirst("file:", "");
            }
            if ((file = new File(fileAbsolutePath)).exists()) {
                this.copy(file, destinationFolder);
            }
            matcher.appendReplacement(replaceBuffer, "<IMG SRC=\"" + file.getName() + "\">");
        }
        matcher.appendTail(replaceBuffer);
        File htmlFile = new File(destinationFolder, "report.html");
        FileOutputStream outputStream = new FileOutputStream(htmlFile);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        out.append(replaceBuffer.toString());
        out.flush();
        out.close();
        outputStream.close();
        return true;
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            toolkit.getSystemClipboard().setContents(new ReportSelection(this.mHTMLReport), null);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        boolean last = false;
        try {
            View rootView = this.displayPane.getUI().getRootView(this.displayPane);
            double scaleX = pageFormat.getImageableWidth() / this.displayPane.getMinimumSize().getWidth();
            double scaleY = scaleX = Math.min(scaleX, 1.0);
            int end = (int)((double)pageIndex * (1.0 / scaleY * pageFormat.getImageableHeight()));
            Rectangle allocation = new Rectangle(0, -end, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            ((Graphics2D)graphics).scale(scaleX, scaleY);
            graphics.setClip((int)(pageFormat.getImageableX() / scaleX), (int)(pageFormat.getImageableY() / scaleY), (int)(pageFormat.getImageableWidth() / scaleX), (int)(pageFormat.getImageableHeight() / scaleY));
            ((Graphics2D)graphics).translate(graphics.getClipBounds().getX(), graphics.getClipBounds().getY());
            rootView.paint(graphics, allocation);
            boolean bl = last = (double)end > this.displayPane.getUI().getPreferredSize(this.displayPane).getHeight();
            if (last) {
                return 1;
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File source, File dest) throws IOException {
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            if (dest.isDirectory()) {
                dest = new File(dest, source.getName());
            }
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = ((FileChannel)in).size();
            MappedByteBuffer buf = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

