"use strict";
/* IMPORT */
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../utils");
var types_1 = require("../types");
var type_1 = require("./type");
/* CHANNELS */
var Channels = /** @class */ (function () {
    /* CONSTRUCTOR */
    function Channels(data, color) {
        this.color = color;
        this.changed = false;
        this.data = data; //TSC
        this.type = new type_1.default();
    }
    /* API */
    Channels.prototype.set = function (data, color) {
        this.color = color;
        this.changed = false;
        this.data = data; //TSC
        this.type.type = types_1.TYPE.ALL;
        return this;
    };
    /* HELPERS */
    Channels.prototype._ensureHSL = function () {
        if (this.data.h === undefined)
            this.data.h = utils_1.default.channel.rgb2hsl(this.data, 'h');
        if (this.data.s === undefined)
            this.data.s = utils_1.default.channel.rgb2hsl(this.data, 's');
        if (this.data.l === undefined)
            this.data.l = utils_1.default.channel.rgb2hsl(this.data, 'l');
    };
    Channels.prototype._ensureRGB = function () {
        if (this.data.r === undefined)
            this.data.r = utils_1.default.channel.hsl2rgb(this.data, 'r');
        if (this.data.g === undefined)
            this.data.g = utils_1.default.channel.hsl2rgb(this.data, 'g');
        if (this.data.b === undefined)
            this.data.b = utils_1.default.channel.hsl2rgb(this.data, 'b');
    };
    Object.defineProperty(Channels.prototype, "r", {
        /* GETTERS */
        get: function () {
            if (!this.type.is(types_1.TYPE.HSL) && this.data.r !== undefined)
                return this.data.r;
            this._ensureHSL();
            return utils_1.default.channel.hsl2rgb(this.data, 'r');
        },
        /* SETTERS */
        set: function (r) {
            this.type.set(types_1.TYPE.RGB);
            this.changed = true;
            this.data.r = r;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Channels.prototype, "g", {
        get: function () {
            if (!this.type.is(types_1.TYPE.HSL) && this.data.g !== undefined)
                return this.data.g;
            this._ensureHSL();
            return utils_1.default.channel.hsl2rgb(this.data, 'g');
        },
        set: function (g) {
            this.type.set(types_1.TYPE.RGB);
            this.changed = true;
            this.data.g = g;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Channels.prototype, "b", {
        get: function () {
            if (!this.type.is(types_1.TYPE.HSL) && this.data.b !== undefined)
                return this.data.b;
            this._ensureHSL();
            return utils_1.default.channel.hsl2rgb(this.data, 'b');
        },
        set: function (b) {
            this.type.set(types_1.TYPE.RGB);
            this.changed = true;
            this.data.b = b;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Channels.prototype, "h", {
        get: function () {
            if (!this.type.is(types_1.TYPE.RGB) && this.data.h !== undefined)
                return this.data.h;
            this._ensureRGB();
            return utils_1.default.channel.rgb2hsl(this.data, 'h');
        },
        set: function (h) {
            this.type.set(types_1.TYPE.HSL);
            this.changed = true;
            this.data.h = h;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Channels.prototype, "s", {
        get: function () {
            if (!this.type.is(types_1.TYPE.RGB) && this.data.s !== undefined)
                return this.data.s;
            this._ensureRGB();
            return utils_1.default.channel.rgb2hsl(this.data, 's');
        },
        set: function (s) {
            this.type.set(types_1.TYPE.HSL);
            this.changed = true;
            this.data.s = s;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Channels.prototype, "l", {
        get: function () {
            if (!this.type.is(types_1.TYPE.RGB) && this.data.l !== undefined)
                return this.data.l;
            this._ensureRGB();
            return utils_1.default.channel.rgb2hsl(this.data, 'l');
        },
        set: function (l) {
            this.type.set(types_1.TYPE.HSL);
            this.changed = true;
            this.data.l = l;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Channels.prototype, "a", {
        get: function () {
            return this.data.a;
        },
        set: function (a) {
            this.changed = true;
            this.data.a = a;
        },
        enumerable: true,
        configurable: true
    });
    return Channels;
}());
/* EXPORT */
exports.default = Channels;
