/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import javajs.util.BS;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolWriter;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.Edge;
import org.jmol.viewer.Viewer;

public class CMLWriter
implements JmolWriter {
    private Viewer vwr;
    private OC oc;
    private int atomsMax;
    private boolean addBonds;
    private boolean doTransform;
    private boolean allTrajectories;

    @Override
    public void set(Viewer viewer, OC out, Object[] data) {
        this.vwr = viewer;
        this.oc = this.oc == null ? this.vwr.getOutputChannel(null, null) : this.oc;
        this.atomsMax = (Integer)data[0];
        this.addBonds = (Boolean)data[1];
        this.doTransform = (Boolean)data[2];
        this.allTrajectories = (Boolean)data[3];
    }

    @Override
    public String write(BS bs) {
        SB sb = new SB();
        int nAtoms = bs.cardinality();
        if (nAtoms == 0) {
            return "";
        }
        if (Viewer.isJS) {
            Interface.getInterface("javajs.util.XmlUtil", this.vwr, "file");
        }
        CMLWriter.openTag(sb, "molecule");
        CMLWriter.openTag(sb, "atomArray");
        BS bsAtoms = new BS();
        Atom[] atoms = this.vwr.ms.at;
        int i = bs.nextSetBit(0);
        while (i >= 0 && --this.atomsMax >= 0) {
            Atom atom = atoms[i];
            String name = atom.getAtomName();
            PT.rep(name, "\"", "''");
            bsAtoms.set(atom.i);
            CMLWriter.appendTag(sb, "atom", new String[]{"id", "a" + (atom.i + 1), "title", atom.getAtomName(), "elementType", atom.getElementSymbol(), "x3", "" + atom.x, "y3", "" + atom.y, "z3", "" + atom.z});
            i = bs.nextSetBit(i + 1);
        }
        CMLWriter.closeTag(sb, "atomArray");
        if (this.addBonds) {
            CMLWriter.openTag(sb, "bondArray");
            int bondCount = this.vwr.ms.bondCount;
            Bond[] bonds = this.vwr.ms.bo;
            for (int i2 = 0; i2 < bondCount; ++i2) {
                String order;
                Bond bond = bonds[i2];
                Atom a1 = bond.atom1;
                Atom a2 = bond.atom2;
                if (!bsAtoms.get(a1.i) || !bsAtoms.get(a2.i) || (order = Edge.getCmlBondOrder(bond.order)) == null) continue;
                CMLWriter.appendTag(sb, "bond", new String[]{"atomRefs2", "a" + (bond.atom1.i + 1) + " a" + (bond.atom2.i + 1), "order", order});
            }
            CMLWriter.closeTag(sb, "bondArray");
        }
        CMLWriter.closeTag(sb, "molecule");
        return sb.toString();
    }

    private static void openTag(SB sb, String name) {
        sb.append("<").append(name).append(">\n");
    }

    private static void appendTag(SB sb, String name, String[] attributes) {
        sb.append("<").append(name);
        for (int i = 0; i < attributes.length; ++i) {
            sb.append(" ").append(attributes[i]).append("=\"").append(attributes[++i]).append("\"");
        }
        sb.append("/>\n");
    }

    private static void closeTag(SB sb, String name) {
        sb.append("</").append(name).append(">\n");
    }

    public String toString() {
        return this.oc == null ? "" : this.oc.toString();
    }
}

